-- New Audit  Log tables

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = public, pg_catalog; 
		
		-- remove redundent index on table notify.targets
		DROP INDEX IF EXISTS notify.targets_target_addr_complete_key;
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'public'
		        AND c.relname in ('syslog_target', 'audit_profile', 'audit_syslog_mapping')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
            --syslog_target
			CREATE TABLE syslog_target (
				 id SERIAL NOT NULL,
                 name TEXT NOT NULL, 
				 ip TEXT NOT NULL, 
				 port INTEGER DEFAULT 514 NOT NULL, 
				 protocol TEXT DEFAULT 'udp'::text NOT NULL, 
				 facility TEXT DEFAULT 'local0'::text NOT NULL, 
				 ssl BOOLEAN DEFAULT false NOT NULL, 				 
				 CONSTRAINT unique_syslog_target_name UNIQUE (name), 
				 CONSTRAINT unique_ip UNIQUE (ip),
				 CONSTRAINT pk_syslog_target PRIMARY KEY (id));

			ALTER TABLE syslog_target OWNER TO nms;
								 
			 REVOKE ALL ON TABLE syslog_target FROM PUBLIC;
			 REVOKE ALL ON TABLE syslog_target FROM nms;
			 GRANT ALL ON TABLE syslog_target TO nms;
			 GRANT SELECT ON TABLE syslog_target TO ndb_readers;
			 GRANT SELECT ON TABLE syslog_target TO ndb_writers;
			 GRANT ALL ON TABLE syslog_target TO PUBLIC;
			 GRANT ALL ON TABLE syslog_target TO ndbadm;
			 GRANT ALL ON SEQUENCE syslog_target_id_seq TO nms;
			 
			 INSERT INTO syslog_target (id, name, ip, port, protocol, facility, ssl) 
				VALUES (1, 'local', '127.0.0.1', 514, 'udp', 'local0', false);	  
				
			PERFORM pg_catalog.setval('syslog_target_id_seq', 1, true);	
			 
			-- audit_profile
			CREATE TABLE audit_profile (
				  id SERIAL NOT NULL, 
				  name TEXT NOT NULL, 
				  active BOOLEAN DEFAULT false NOT NULL, 
				  CONSTRAINT unique_audit_profile_name UNIQUE (name), 
				  CONSTRAINT pk_audit_profile PRIMARY KEY (id));
				  
			INSERT INTO audit_profile (id, name, active) VALUES (1, 'default', false);
			
			PERFORM pg_catalog.setval('audit_profile_id_seq', 1, true);	
				  
			ALTER TABLE audit_profile OWNER TO nms;
								 
			 REVOKE ALL ON TABLE audit_profile FROM PUBLIC;
			 REVOKE ALL ON TABLE audit_profile FROM nms;
			 GRANT ALL ON TABLE audit_profile TO nms;
			 GRANT SELECT ON TABLE audit_profile TO ndb_readers;
			 GRANT SELECT ON TABLE audit_profile TO ndb_writers;
			 GRANT ALL ON TABLE audit_profile TO PUBLIC;
			 GRANT ALL ON TABLE audit_profile TO ndbadm;
			 GRANT ALL ON SEQUENCE audit_profile_id_seq TO nms;	 
			 
			-- audit_syslog_mapping
			CREATE TABLE audit_syslog_mapping (
				 audit_profile_id INTEGER NOT NULL, 
				 syslog_target_id INTEGER NOT NULL);
				 
			INSERT INTO audit_syslog_mapping (audit_profile_id, syslog_target_id) VALUES (1, 1);	 
			 
			ALTER TABLE audit_syslog_mapping OWNER TO nms;
								 
			 REVOKE ALL ON TABLE audit_syslog_mapping FROM PUBLIC;
			 REVOKE ALL ON TABLE audit_syslog_mapping FROM nms;
			 GRANT ALL ON TABLE audit_syslog_mapping TO nms;
			 GRANT SELECT ON TABLE audit_syslog_mapping TO ndb_readers;
			 GRANT SELECT ON TABLE audit_syslog_mapping TO ndb_writers;
			 GRANT ALL ON TABLE audit_syslog_mapping TO PUBLIC;
			 GRANT ALL ON TABLE audit_syslog_mapping TO ndbadm;
			 	 			
			END IF; 
        		
		END;
$$;  
		 
