-- New BGP flowspec tables

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = flood, pg_catalog; 
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'flood'
		        AND c.relname in ('bgp_flowspec_events')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
			   CREATE TABLE bgp_flowspec_events
				( id SERIAL NOT NULL, 
				   flood_id INTEGER, 
				   pattern_id INTEGER, 
				   src_subnet INET, 
				   dst_subnet INET, 
				   src_port INTEGER, 
				   dst_port INTEGER, 
				   protocol INTEGER, 
				   since TIMESTAMP(6) WITH TIME ZONE DEFAULT now() NOT NULL, 
				   source flood.action_source_type, 
				   source_id INTEGER, 
				   status TEXT NOT NULL,
				   expiry TIMESTAMP(6) WITH TIME ZONE,
				   type TEXT, target_type TEXT, 
				   last_modified TIMESTAMP(6) WITH TIME ZONE DEFAULT now() NOT NULL, 
				   CONSTRAINT pk_bgp_fs_events PRIMARY KEY (id));
				   
				   ALTER TABLE bgp_flowspec_events OWNER TO nms;
								 
					REVOKE ALL ON TABLE bgp_flowspec_events FROM PUBLIC;
					REVOKE ALL ON TABLE bgp_flowspec_events FROM nms;
					GRANT ALL ON TABLE bgp_flowspec_events TO nms;
					GRANT SELECT ON TABLE bgp_flowspec_events TO ndb_readers;
				    GRANT SELECT ON TABLE bgp_flowspec_events TO ndb_writers;
					GRANT ALL ON TABLE bgp_flowspec_events TO PUBLIC;
				    GRANT ALL ON TABLE bgp_flowspec_events TO ndbadm;
					GRANT ALL ON SEQUENCE bgp_flowspec_events_id_seq TO nms;
			
			END IF; 

        		
		END;
$$;  