-- New BGP global tables

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = public, pg_catalog; 
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'public'
		        AND c.relname in ('bgp_global_config', 'quagga_bgp_agent_config', 'rs_bgp_agent_config')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
            --bgp_global_config
			CREATE TABLE bgp_global_config (
				 id SERIAL NOT NULL, 
				 default_trigger_duration INTEGER DEFAULT 3600, 
				 max_num_hosts SMALLINT DEFAULT 20, 
				 host_coverage_threshold REAL DEFAULT 20, 
				 default_host_community INTEGER, 
				 default_subnet_community INTEGER, 
				 agent_type TEXT DEFAULT 'None', 
				 CONSTRAINT pk_bgp_global_config PRIMARY KEY (id));

			ALTER TABLE bgp_global_config OWNER TO nms;
								 
			 REVOKE ALL ON TABLE bgp_global_config FROM PUBLIC;
			 REVOKE ALL ON TABLE bgp_global_config FROM nms;
			 GRANT ALL ON TABLE bgp_global_config TO nms;
			 GRANT SELECT ON TABLE bgp_global_config TO ndb_readers;
			 GRANT SELECT ON TABLE bgp_global_config TO ndb_writers;
			 GRANT ALL ON TABLE bgp_global_config TO PUBLIC;
			 GRANT ALL ON TABLE bgp_global_config TO ndbadm;
			 GRANT ALL ON SEQUENCE bgp_global_config_id_seq TO nms;
			 
			 INSERT INTO bgp_global_config (id, default_trigger_duration, max_num_hosts, host_coverage_threshold, default_host_community, default_subnet_community, agent_type) 
				VALUES (1, 3600, 20, 20.0, null, null, 'None');	  
				
			PERFORM pg_catalog.setval('bgp_global_config_id_seq', 1, true);	
			 
			-- quagga_bgp_agent_config
			CREATE TABLE quagga_bgp_agent_config (
				  id SERIAL NOT NULL, 
				  name TEXT, 
				  ips INET[], 
				  username TEXT, 
				  password TEXT, 
				  CONSTRAINT pk_quagga_bgp_agent_config PRIMARY KEY (id));
				  
			
				  
			ALTER TABLE quagga_bgp_agent_config OWNER TO nms;
								 
			 REVOKE ALL ON TABLE quagga_bgp_agent_config FROM PUBLIC;
			 REVOKE ALL ON TABLE quagga_bgp_agent_config FROM nms;
			 GRANT ALL ON TABLE quagga_bgp_agent_config TO nms;
			 GRANT SELECT ON TABLE quagga_bgp_agent_config TO ndb_readers;
			 GRANT SELECT ON TABLE quagga_bgp_agent_config TO ndb_writers;
			 GRANT ALL ON TABLE quagga_bgp_agent_config TO PUBLIC;
			 GRANT ALL ON TABLE quagga_bgp_agent_config TO ndbadm;
			 GRANT ALL ON SEQUENCE quagga_bgp_agent_config_id_seq TO nms;	 
			 
			-- rs_bgp_agent_config
			CREATE TABLE rs_bgp_agent_config (
				 id SERIAL NOT NULL, 
				 name TEXT, 
				 ips INET[], 
				 protocol TEXT, 
				 port INTEGER, 
				 CONSTRAINT pk_rs_bgp_agent_config PRIMARY KEY (id));
				 
				 
			ALTER TABLE rs_bgp_agent_config OWNER TO nms;
								 
			 REVOKE ALL ON TABLE rs_bgp_agent_config FROM PUBLIC;
			 REVOKE ALL ON TABLE rs_bgp_agent_config FROM nms;
			 GRANT ALL ON TABLE rs_bgp_agent_config TO nms;
			 GRANT SELECT ON TABLE rs_bgp_agent_config TO ndb_readers;
			 GRANT SELECT ON TABLE rs_bgp_agent_config TO ndb_writers;
			 GRANT ALL ON TABLE rs_bgp_agent_config TO PUBLIC;
			 GRANT ALL ON TABLE rs_bgp_agent_config TO ndbadm;
			 GRANT ALL ON SEQUENCE rs_bgp_agent_config_id_seq TO nms;		 
	 			
			END IF; 

        		
		END;
$$;  
		 
