-- New BGP tables

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = public, pg_catalog; 
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'public'
		        AND c.relname in ('bgp_peers_config', 'bgp_communities')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN	  
			  -- bgp_peers_config
			  CREATE TABLE bgp_peers_config (
               id  SERIAL NOT NULL,
			   name text,
               ip inet,
               asn integer,
               password text,
	           constraint pk_bgp_peers_config primary key(id)
              );

              ALTER TABLE bgp_peers_config OWNER TO nms;
			             		  
              REVOKE ALL ON TABLE bgp_peers_config FROM PUBLIC;
              REVOKE ALL ON TABLE bgp_peers_config FROM nms;
              GRANT ALL ON TABLE bgp_peers_config TO nms;
              GRANT SELECT ON TABLE bgp_peers_config TO ndb_readers;
              GRANT SELECT ON TABLE bgp_peers_config TO ndb_writers;
              GRANT ALL ON TABLE bgp_peers_config TO PUBLIC;
              GRANT ALL ON TABLE bgp_peers_config TO ndbadm;
			  
			  -- bgp_communities 
               CREATE TABLE bgp_communities (
                id SERIAL NOT NULL,
                community text,
	            constraint pk_bgp_communities primary key(id)
               );
			   
			  ALTER TABLE bgp_communities OWNER TO nms;
              		  
              REVOKE ALL ON TABLE bgp_communities FROM PUBLIC;
              REVOKE ALL ON TABLE bgp_communities FROM nms;
              GRANT ALL ON TABLE bgp_communities TO nms;
              GRANT SELECT ON TABLE bgp_communities TO ndb_readers;
              GRANT SELECT ON TABLE bgp_communities TO ndb_writers;
              GRANT ALL ON TABLE bgp_communities TO PUBLIC;
              GRANT ALL ON TABLE bgp_communities TO ndbadm;
             
		    END IF;
			
		SET search_path = flood, pg_catalog;
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'flood'
		        AND c.relname in ('bgp_events', 'bgp_peers_status')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
			
			  		  		  
			  -- bgp_events
			  CREATE TABLE bgp_events (
			   id SERIAL NOT NULL,
               subnet INET,
               flood_id integer,
               pattern_id integer,
               community integer,
               since timestamp with time zone DEFAULT now() NOT NULL,
               source action_source_type,
               source_id integer,
			   status text NOT NULL,
               expiry timestamp with time zone,
               type event_types,
			   target_type text,
			   constraint pk_bgp_events primary key(id)
              );

			  ALTER TABLE bgp_events OWNER TO nms;
			  
			  COMMENT ON COLUMN bgp_events.target_type IS 'HOST/SUBNET';
              		  
              REVOKE ALL ON TABLE bgp_events FROM PUBLIC;
              REVOKE ALL ON TABLE bgp_events FROM nms;
              GRANT ALL ON TABLE bgp_events TO nms;
              GRANT SELECT ON TABLE bgp_events TO ndb_readers;
              GRANT SELECT ON TABLE bgp_events TO ndb_writers;
              GRANT ALL ON TABLE bgp_events TO PUBLIC;
              GRANT ALL ON TABLE bgp_events TO ndbadm;
			  
			  -- bgp_peers_status
			  CREATE TABLE bgp_peers_status ( 
               id  SERIAL NOT NULL, 
               status status_type NOT NULL, 
               since timestamp with time zone DEFAULT now() NOT NULL,
               constraint pk_bgp_peers_status primary key(id)
              );
               
			  ALTER TABLE bgp_peers_status OWNER TO nms;
              		  
              REVOKE ALL ON TABLE bgp_peers_status FROM PUBLIC;
              REVOKE ALL ON TABLE bgp_peers_status FROM nms;
              GRANT ALL ON TABLE bgp_peers_status TO nms;
              GRANT SELECT ON TABLE bgp_peers_status TO ndb_readers;
              GRANT SELECT ON TABLE bgp_peers_status TO ndb_writers;
              GRANT ALL ON TABLE bgp_peers_status TO PUBLIC;
              GRANT ALL ON TABLE bgp_peers_status TO ndbadm; 
			  
			END IF; 

        		
		END;
$$;  