--    (c) Copyright 2017, Allot Communications
--    ALL RIGHTS RESERVED
--
-- This script used to add problem checks(dropped before prepare full backup) database after full backup/restore finish 
-- 
--
--    Comments:
--    "@(#)$Id$"
 

set search_path=fast,public,pg_catalog;

alter table entity_patterns add constraint entity_id__check_type CHECK (entity__check_type(entity_id, ('pattern-report'::text)::public.item_name));

alter table top_host_sets add constraint entity_id__check_type CHECK (entity__check_type(entity_id, ('pattern-top-hosts'::text)::public.item_name));

set search_path=flood,pg_catalog;

alter table alerts add constraint alerts_check1 CHECK (flood_has_sample_p(flood_id, sample_id));
alter table alerts add constraint pattern_id_check CHECK (((pattern_id IS NULL) OR (((sample_id IS NOT NULL) AND sample_has_pattern_p(sample_id, pattern_id)) OR ((sample_id IS NULL) AND flood_has_pattern_p(flood_id, pattern_id)))));

set search_path=notify,pg_catalog;

alter table filter_targets add constraint filter_targets__check_templates CHECK (notify.filter_templates_exists(filter_id, notify.target_type_id(target_id)) OR notify.filter_is_subfilter(filter_id));
alter table filter_targets add constraint filter_targets_importance_check_children CHECK (notify.target_type(target_id) <> 'importance'::text OR notify.filter_action_importance_check_children_p(filter_id, notify.target_addr(target_id)::integer));
alter table filter_targets add constraint filter_targets_importance_check_parents CHECK (notify.target_type(target_id) <> 'importance'::text OR notify.filter_action_importance_check_parents_p(filter_id, notify.target_addr(target_id)::integer));

alter table type_links add constraint type_links_check CHECK (notify.type_link_valid(type_id, "from", "to"));
 