-- New pattern_match_tolerance table

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = public, pg_catalog; 
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'public'
		        AND c.relname in ('pattern_match_tolerance')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
            --pattern_match_tolerance
			CREATE TABLE pattern_match_tolerance (
				 id SERIAL NOT NULL, 
				 deviation_percent_upper_bound REAL NOT NULL,
				 tolerance_level_percent REAL NOT NULL,
				 CONSTRAINT pk_pattern_match_tolerance PRIMARY KEY (id));

			ALTER TABLE pattern_match_tolerance OWNER TO nms;
								 
			 REVOKE ALL ON TABLE pattern_match_tolerance FROM PUBLIC;
			 REVOKE ALL ON TABLE pattern_match_tolerance FROM nms;
			 GRANT ALL ON TABLE pattern_match_tolerance TO nms;
			 GRANT SELECT ON TABLE pattern_match_tolerance TO ndb_readers;
			 GRANT SELECT ON TABLE pattern_match_tolerance TO ndb_writers;
			 GRANT ALL ON TABLE pattern_match_tolerance TO PUBLIC;
			 GRANT ALL ON TABLE pattern_match_tolerance TO ndbadm;
			 GRANT ALL ON SEQUENCE pattern_match_tolerance_id_seq TO nms;
			 
			INSERT INTO pattern_match_tolerance (id, deviation_percent_upper_bound, tolerance_level_percent) 
			                                            VALUES (1, 0.3, 0.2);
            INSERT INTO pattern_match_tolerance (id, deviation_percent_upper_bound, tolerance_level_percent) 
			                                            VALUES (2, 0.5, 0.1);
            INSERT INTO pattern_match_tolerance (id, deviation_percent_upper_bound, tolerance_level_percent) 
			                                            VALUES (3, 1.0, 0.05);	  
				
			PERFORM pg_catalog.setval('pattern_match_tolerance_id_seq', 3, true);
			
			END IF; 

        		
		END;
$$;  				
