--    (c) Copyright 2018, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Add statistical tables "on the fly"  for host/group
--                            Input parameter - hostid , groupid 
--    Include - 
--
--    Comments:
--    "@(#)$Id $"


SET search_path = public,pg_catalog;

CREATE OR REPLACE FUNCTION add_stats_table (hostid integer, groupid integer)  RETURNS void
LANGUAGE plpgsql
AS $_$
DECLARE
    table_name TEXT;
	view_name TEXT;
BEGIN    
   table_name := 'h' || hostid || '.' || '_stats' || groupid ;
   view_name := 'h' || hostid || '.' || 'stats' || groupid ;
   
   EXECUTE 'CREATE TABLE ' || table_name  || ' (timestamp INTEGER NOT NULL, 
	byt_incom_frag BIGINT, pkt_incom_frag BIGINT, 
	byt_outgo_frag BIGINT, pkt_outgo_frag BIGINT, 
	byt_incom_trunc BIGINT, pkt_incom_trunc BIGINT, 
	byt_outgo_trunc BIGINT, pkt_outgo_trunc BIGINT, 
	byt_incom_esp BIGINT, pkt_incom_esp BIGINT, 
	byt_outgo_esp BIGINT, pkt_outgo_esp BIGINT, 
	byt_incom_other BIGINT, pkt_incom_other BIGINT, 
	byt_outgo_other BIGINT, pkt_outgo_other BIGINT, 
	byt_incom_tcp_fin BIGINT, pkt_incom_tcp_fin BIGINT, 
	byt_outgo_tcp_fin BIGINT, pkt_outgo_tcp_fin BIGINT, 
	byt_incom_tcp_syn BIGINT, pkt_incom_tcp_syn BIGINT, 
	byt_outgo_tcp_syn BIGINT, pkt_outgo_tcp_syn BIGINT, 
	byt_incom_tcp_rst BIGINT, pkt_incom_tcp_rst BIGINT,
	byt_outgo_tcp_rst BIGINT, pkt_outgo_tcp_rst BIGINT, 
	byt_incom_tcp_ack BIGINT, pkt_incom_tcp_ack BIGINT, 
	byt_outgo_tcp_ack BIGINT, pkt_outgo_tcp_ack BIGINT, 
	byt_incom_tcp_ackdata BIGINT, pkt_incom_tcp_ackdata BIGINT, 
	byt_outgo_tcp_ackdata BIGINT, pkt_outgo_tcp_ackdata BIGINT, 
	byt_incom_tcp_inval BIGINT, pkt_incom_tcp_inval BIGINT, 
	byt_outgo_tcp_inval BIGINT, pkt_outgo_tcp_inval BIGINT, 
	byt_incom_udp_dns BIGINT, pkt_incom_udp_dns BIGINT, 
	byt_outgo_udp_dns BIGINT, pkt_outgo_udp_dns BIGINT, 
	byt_incom_udp_other BIGINT, pkt_incom_udp_other BIGINT, 
	byt_outgo_udp_other BIGINT, pkt_outgo_udp_other BIGINT, 
	byt_incom_icmp_echoreq BIGINT, pkt_incom_icmp_echoreq BIGINT, 
	byt_outgo_icmp_echoreq BIGINT, pkt_outgo_icmp_echoreq BIGINT, 
	byt_incom_icmp_echorep BIGINT, pkt_incom_icmp_echorep BIGINT, 
	byt_outgo_icmp_echorep BIGINT, pkt_outgo_icmp_echorep BIGINT, 
	byt_incom_icmp_unreach BIGINT, pkt_incom_icmp_unreach BIGINT, 
	byt_outgo_icmp_unreach BIGINT, pkt_outgo_icmp_unreach BIGINT, 
	byt_incom_icmp_other BIGINT, pkt_incom_icmp_other BIGINT, 
	byt_outgo_icmp_other BIGINT, pkt_outgo_icmp_other BIGINT, PRIMARY KEY (timestamp))';
	
	EXECUTE 'ALTER TABLE ' || table_name  || ' OWNER TO nms';
	EXECUTE 'GRANT ALL ON TABLE ' || table_name  || ' TO nms';
	
	EXECUTE 'CREATE VIEW ' || view_name  || ' AS SELECT timestamp, 
	byt_incom_frag, pkt_incom_frag, 
	byt_outgo_frag, pkt_outgo_frag, 
	byt_incom_trunc, pkt_incom_trunc, 
	byt_outgo_trunc, pkt_outgo_trunc, 
	byt_incom_esp, pkt_incom_esp, 
	byt_outgo_esp, pkt_outgo_esp, 
	byt_incom_other, pkt_incom_other, 
	byt_outgo_other, pkt_outgo_other, 
	byt_incom_tcp_fin, pkt_incom_tcp_fin, 
	byt_outgo_tcp_fin, pkt_outgo_tcp_fin, 
	byt_incom_tcp_syn, pkt_incom_tcp_syn, 
	byt_outgo_tcp_syn, pkt_outgo_tcp_syn, 
	byt_incom_tcp_rst, pkt_incom_tcp_rst,
	byt_outgo_tcp_rst, pkt_outgo_tcp_rst, 
	byt_incom_tcp_ack, pkt_incom_tcp_ack, 
	byt_outgo_tcp_ack, pkt_outgo_tcp_ack, 
	byt_incom_tcp_ackdata, pkt_incom_tcp_ackdata, 
	byt_outgo_tcp_ackdata, pkt_outgo_tcp_ackdata, 
	byt_incom_tcp_inval, pkt_incom_tcp_inval, 
	byt_outgo_tcp_inval, pkt_outgo_tcp_inval, 
	byt_incom_udp_dns, pkt_incom_udp_dns, 
	byt_outgo_udp_dns, pkt_outgo_udp_dns, 
	byt_incom_udp_other, pkt_incom_udp_other, 
	byt_outgo_udp_other, pkt_outgo_udp_other, 
	byt_incom_icmp_echoreq, pkt_incom_icmp_echoreq, 
	byt_outgo_icmp_echoreq, pkt_outgo_icmp_echoreq, 
	byt_incom_icmp_echorep, pkt_incom_icmp_echorep, 
	byt_outgo_icmp_echorep, pkt_outgo_icmp_echorep, 
	byt_incom_icmp_unreach, pkt_incom_icmp_unreach, 
	byt_outgo_icmp_unreach, pkt_outgo_icmp_unreach, 
	byt_incom_icmp_other, pkt_incom_icmp_other, 
	byt_outgo_icmp_other, pkt_outgo_icmp_other,
	byt_incom_tcp_fin + byt_incom_tcp_syn + byt_incom_tcp_rst AS byt_incom_tcp_endp, 
	byt_incom_tcp_fin + byt_incom_tcp_syn + byt_incom_tcp_rst + byt_incom_tcp_ack + byt_incom_tcp_ackdata + byt_incom_tcp_inval AS byt_incom_tcp_total,
	byt_incom_udp_dns + byt_incom_udp_other AS byt_incom_udp_total, 
	byt_incom_icmp_echoreq + byt_incom_icmp_echorep + byt_incom_icmp_unreach + byt_incom_icmp_other AS byt_incom_icmp_total,
	byt_incom_frag + byt_incom_trunc + byt_incom_esp + byt_incom_other + byt_incom_tcp_fin + byt_incom_tcp_syn + byt_incom_tcp_rst + byt_incom_tcp_ack + byt_incom_tcp_ackdata + byt_incom_tcp_inval + byt_incom_udp_dns + byt_incom_udp_other + byt_incom_icmp_echoreq + byt_incom_icmp_echorep + byt_incom_icmp_unreach + byt_incom_icmp_other AS byt_incom_ipv4,
	pkt_incom_tcp_fin + pkt_incom_tcp_syn + pkt_incom_tcp_rst AS pkt_incom_tcp_endp, 
	pkt_incom_tcp_fin + pkt_incom_tcp_syn + pkt_incom_tcp_rst + pkt_incom_tcp_ack + pkt_incom_tcp_ackdata + pkt_incom_tcp_inval AS pkt_incom_tcp_total,
	pkt_incom_udp_dns + pkt_incom_udp_other AS pkt_incom_udp_total, 
	pkt_incom_icmp_echoreq + pkt_incom_icmp_echorep + pkt_incom_icmp_unreach + pkt_incom_icmp_other AS pkt_incom_icmp_total,
	pkt_incom_frag + pkt_incom_trunc + pkt_incom_esp + pkt_incom_other + pkt_incom_tcp_fin + pkt_incom_tcp_syn + pkt_incom_tcp_rst + pkt_incom_tcp_ack + pkt_incom_tcp_ackdata + pkt_incom_tcp_inval + pkt_incom_udp_dns + pkt_incom_udp_other + pkt_incom_icmp_echoreq + pkt_incom_icmp_echorep + pkt_incom_icmp_unreach + pkt_incom_icmp_other AS pkt_incom_ipv4,
	byt_outgo_tcp_fin + byt_outgo_tcp_syn + byt_outgo_tcp_rst AS byt_outgo_tcp_endp, 
	byt_outgo_tcp_fin + byt_outgo_tcp_syn + byt_outgo_tcp_rst + byt_outgo_tcp_ack + byt_outgo_tcp_ackdata + byt_outgo_tcp_inval AS byt_outgo_tcp_total,
	byt_outgo_udp_dns + byt_outgo_udp_other AS byt_outgo_udp_total, 
	byt_outgo_icmp_echoreq + byt_outgo_icmp_echorep + byt_outgo_icmp_unreach + byt_outgo_icmp_other AS byt_outgo_icmp_total,
	byt_outgo_frag + byt_outgo_trunc + byt_outgo_esp + byt_outgo_other + byt_outgo_tcp_fin + byt_outgo_tcp_syn + byt_outgo_tcp_rst + byt_outgo_tcp_ack + byt_outgo_tcp_ackdata + byt_outgo_tcp_inval + byt_outgo_udp_dns + byt_outgo_udp_other + byt_outgo_icmp_echoreq + byt_outgo_icmp_echorep + byt_outgo_icmp_unreach + byt_outgo_icmp_other AS byt_outgo_ipv4,
	pkt_outgo_tcp_fin + pkt_outgo_tcp_syn + pkt_outgo_tcp_rst AS pkt_outgo_tcp_endp, 
	pkt_outgo_tcp_fin + pkt_outgo_tcp_syn + pkt_outgo_tcp_rst + pkt_outgo_tcp_ack + pkt_outgo_tcp_ackdata + pkt_outgo_tcp_inval AS pkt_outgo_tcp_total,
	pkt_outgo_udp_dns + pkt_outgo_udp_other AS pkt_outgo_udp_total, 
	pkt_outgo_icmp_echoreq + pkt_outgo_icmp_echorep + pkt_outgo_icmp_unreach + pkt_outgo_icmp_other AS pkt_outgo_icmp_total,
	pkt_outgo_frag + pkt_outgo_trunc + pkt_outgo_esp + pkt_outgo_other + pkt_outgo_tcp_fin + pkt_outgo_tcp_syn + pkt_outgo_tcp_rst + pkt_outgo_tcp_ack + pkt_outgo_tcp_ackdata + pkt_outgo_tcp_inval + pkt_outgo_udp_dns + pkt_outgo_udp_other + pkt_outgo_icmp_echoreq + pkt_outgo_icmp_echorep + pkt_outgo_icmp_unreach + pkt_outgo_icmp_other AS pkt_outgo_ipv4
	FROM ' || table_name;

EXECUTE 'ALTER VIEW ' || view_name || ' OWNER TO nms';
EXECUTE 'GRANT ALL ON TABLE ' || view_name || ' TO nms';
  
END
$_$;

ALTER FUNCTION public.add_stats_table(hostid integer, groupid integer) OWNER TO nms;