--    (c) Copyright 2016, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Set of SP(functions) for purging data - running from purge-process.sh
-- Include - detect_purge, fast_purge, quarantine_purge, smp_purge, stats_purge
--
--    Comments:
--    "@(#)$Id$"



SET search_path=purge,pg_catalog;

-- detect_purge
CREATE OR REPLACE FUNCTION detect_purge(aging_days integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    rows	INTEGER; 
    all_rows	INTEGER;    
    curr_time   TIMESTAMP;
	bgp_aging_days INTEGER;
	snapshot_aging_days INTEGER;
	snapshot_time_interval INTEGER;
BEGIN    

  all_rows := 0;
 
 /* Not need for new generation ( flood.cleanup could be removed from install script)
 PERFORM  DISTINCT ON (ss.subsystem_id)
   flood.cleanup(ss.subsystem_id, 'subsystem stale') IS NULL
   FROM flood.state	    s
  JOIN flood.registry    r  USING (flood_id)
   JOIN public.subsystems ss USING (subsystem_id)
   WHERE s.stop IS NULL
   AND s.start  < CURRENT_TIMESTAMP - '1 hour'::INTERVAL
   AND ss.alive < CURRENT_TIMESTAMP - '1 hour'::INTERVAL
   ORDER BY ss.subsystem_id;
  */
  -- Add for case 234049 - close false-active floods 
  UPDATE flood.state SET stop=modified, details='system shutdown' WHERE stop IS NULL AND modified < now() - '1 hour'::interval;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := rows;
  curr_time := clock_timestamp()::TIMESTAMP;
  RAISE NOTICE '%: detect_purge - % updated rows to close false-active floods  ', curr_time,all_rows;
  
  all_rows := 0;
  
 CREATE TEMP TABLE _purge_tmp_1 WITHOUT OIDS ON COMMIT DROP AS
  SELECT flood_id
  FROM flood.state
  LEFT JOIN flood.importance USING (flood_id)
  WHERE stop BETWEEN CURRENT_DATE - 21 AND CURRENT_DATE - 14
  AND importance IS NULL
  UNION ALL
  SELECT flood_id
  FROM flood.importance
   JOIN flood.state USING (flood_id)
   WHERE stop < CURRENT_DATE - 14 AND importance = 0;
   
 CREATE INDEX _purge_tmp_1_idx0 ON _purge_tmp_1(flood_id) ;
 ANALYZE _purge_tmp_1 ;
 
 CREATE TEMP TABLE _purge_tmp_2 WITHOUT OIDS ON COMMIT DROP AS
  SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
     FROM flood.samples JOIN _purge_tmp_1 ON ((flood.samples.flood_id) = (_purge_tmp_1.flood_id));
     
  CREATE INDEX _purge_tmp_2_idx0 ON _purge_tmp_2(sample_id); 
  CREATE INDEX _purge_tmp_2_idx1 ON _purge_tmp_2(report_id) ;
  CREATE INDEX _purge_tmp_2_idx2 ON _purge_tmp_2(top_hosts_id) ;
  CREATE INDEX _purge_tmp_2_idx3 ON _purge_tmp_2(alerts_id) ;
  ANALYZE _purge_tmp_2 ;
  DELETE FROM flood.samples USING _purge_tmp_1 WHERE (flood.samples.flood_id) = (_purge_tmp_1.flood_id)   ;   
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DELETE FROM fast.top_host_sets USING (SELECT sample_id FROM _purge_tmp_2 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work 
     WHERE (fast.top_host_sets.entity_id) = (work.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  --hb add new table to purge 12.2018
  DELETE FROM fast.top_subnet_sets USING (SELECT sample_id FROM _purge_tmp_2 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work 
     WHERE (fast.top_subnet_sets.sample_id) = (work.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
     
  CREATE TEMP TABLE _purge_tmp_3 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.sample_id) = (_purge_tmp_2.sample_id));
  CREATE INDEX _purge_tmp_3_idx0 ON _purge_tmp_3(sample_id) ;
  CREATE INDEX _purge_tmp_3_idx1 ON _purge_tmp_3(report_id) ;
  CREATE INDEX _purge_tmp_3_idx2 ON _purge_tmp_3(top_hosts_id) ;
  CREATE INDEX _purge_tmp_3_idx3 ON _purge_tmp_3(alerts_id) ;
  ANALYZE _purge_tmp_3 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.sample_id) = (_purge_tmp_2.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
   
  DROP TABLE _purge_tmp_3 ;
  
  CREATE TEMP TABLE _purge_tmp_4 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.report_id) = (_purge_tmp_2.sample_id));
  CREATE INDEX _purge_tmp_4_idx0 ON _purge_tmp_4(sample_id) ;
  CREATE INDEX _purge_tmp_4_idx1 ON _purge_tmp_4(report_id) ;
  CREATE INDEX _purge_tmp_4_idx2 ON _purge_tmp_4(top_hosts_id) ;
  CREATE INDEX _purge_tmp_4_idx3 ON _purge_tmp_4(alerts_id) ;
  ANALYZE _purge_tmp_4 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.report_id) = (_purge_tmp_2.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_4 ;
  CREATE TEMP TABLE _purge_tmp_5 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.top_hosts_id) = (_purge_tmp_2.sample_id));
  CREATE INDEX _purge_tmp_5_idx0 ON _purge_tmp_5(sample_id) ;
  CREATE INDEX _purge_tmp_5_idx1 ON _purge_tmp_5(report_id) ;
  CREATE INDEX _purge_tmp_5_idx2 ON _purge_tmp_5(top_hosts_id) ;
  CREATE INDEX _purge_tmp_5_idx3 ON _purge_tmp_5(alerts_id) ;
  ANALYZE _purge_tmp_5 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_2.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
   
  DROP TABLE _purge_tmp_5 ;
  CREATE TEMP TABLE _purge_tmp_6 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.alerts_id) = (_purge_tmp_2.sample_id));
  CREATE INDEX _purge_tmp_6_idx0 ON _purge_tmp_6(sample_id) ;
  CREATE INDEX _purge_tmp_6_idx1 ON _purge_tmp_6(report_id) ;
  CREATE INDEX _purge_tmp_6_idx2 ON _purge_tmp_6(top_hosts_id) ;
  CREATE INDEX _purge_tmp_6_idx3 ON _purge_tmp_6(alerts_id) ;
  ANALYZE _purge_tmp_6 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.alerts_id) = (_purge_tmp_2.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_6 ;
  CREATE TEMP TABLE _purge_tmp_7 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.entropy_id) = (_purge_tmp_2.sample_id));
  CREATE INDEX _purge_tmp_7_idx0 ON _purge_tmp_7(sample_id) ;
  CREATE INDEX _purge_tmp_7_idx1 ON _purge_tmp_7(report_id) ;
  CREATE INDEX _purge_tmp_7_idx2 ON _purge_tmp_7(top_hosts_id) ;
  CREATE INDEX _purge_tmp_7_idx3 ON _purge_tmp_7(alerts_id) ;
  ANALYZE _purge_tmp_7 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.entropy_id) = (_purge_tmp_2.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_7 ;

  CREATE TEMP TABLE _purge_tmp_8 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_2 ON ((quarantine.captures.fast_id) = (_purge_tmp_2.sample_id));
  CREATE INDEX _purge_tmp_8_idx0 ON _purge_tmp_8(capture_id) ;
  CREATE INDEX _purge_tmp_8_idx1 ON _purge_tmp_8(capture_id,addr) ;
  CREATE INDEX _purge_tmp_8_idx2 ON _purge_tmp_8(fast_id) ;
  ANALYZE _purge_tmp_8 ;
  CREATE TEMP TABLE _purge_tmp_9 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_8 ON ((quarantine.samples.capture_id) = (_purge_tmp_8.capture_id));
  CREATE INDEX _purge_tmp_9_idx0 ON _purge_tmp_9(sample_id) ;
  ANALYZE _purge_tmp_9 ;
  DELETE FROM quarantine.samples USING _purge_tmp_8 WHERE (quarantine.samples.capture_id) = (_purge_tmp_8.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_9 ;
  CREATE TEMP TABLE _purge_tmp_10 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_8 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_8.capture_id,_purge_tmp_8.addr));
  CREATE INDEX _purge_tmp_10_idx0 ON _purge_tmp_10(sample_id) ;
  ANALYZE _purge_tmp_10 ;
  DELETE FROM quarantine.samples USING _purge_tmp_8 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_8.capture_id,_purge_tmp_8.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_10 ;
  DELETE FROM quarantine.captures USING (SELECT sample_id FROM _purge_tmp_2 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_8 ;
  CREATE TEMP TABLE _purge_tmp_11 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_2 ON ((quarantine.samples.sample_id) = (_purge_tmp_2.sample_id));
  CREATE INDEX _purge_tmp_11_idx0 ON _purge_tmp_11(sample_id) ;
  ANALYZE _purge_tmp_11 ;
  DELETE FROM quarantine.samples USING _purge_tmp_2 WHERE (quarantine.samples.sample_id) = (_purge_tmp_2.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_11 ;
 DELETE FROM fast.entities USING (SELECT sample_id FROM _purge_tmp_2 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.entities.entity_id) = (work.sample_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows; 

 DELETE FROM fast.top_host_sets USING (SELECT report_id FROM _purge_tmp_2 ORDER BY report_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.entity_id) = (work.report_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 CREATE TEMP TABLE _purge_tmp_12 WITHOUT OIDS ON COMMIT DROP AS
  SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.sample_id) = (_purge_tmp_2.report_id));
 CREATE INDEX _purge_tmp_12_idx0 ON _purge_tmp_12(sample_id) ;
 CREATE INDEX _purge_tmp_12_idx1 ON _purge_tmp_12(report_id) ;
 CREATE INDEX _purge_tmp_12_idx2 ON _purge_tmp_12(top_hosts_id) ;
 CREATE INDEX _purge_tmp_12_idx3 ON _purge_tmp_12(alerts_id) ;
 ANALYZE _purge_tmp_12 ;
 DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.sample_id) = (_purge_tmp_2.report_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_12 ;
 CREATE TEMP TABLE _purge_tmp_13 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.report_id) = (_purge_tmp_2.report_id));
  CREATE INDEX _purge_tmp_13_idx0 ON _purge_tmp_13(sample_id) ;
  CREATE INDEX _purge_tmp_13_idx1 ON _purge_tmp_13(report_id) ;
  CREATE INDEX _purge_tmp_13_idx2 ON _purge_tmp_13(top_hosts_id) ;
  CREATE INDEX _purge_tmp_13_idx3 ON _purge_tmp_13(alerts_id) ;
  ANALYZE _purge_tmp_13 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.report_id) = (_purge_tmp_2.report_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_13 ;
  CREATE TEMP TABLE _purge_tmp_14 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.top_hosts_id) = (_purge_tmp_2.report_id));
  CREATE INDEX _purge_tmp_14_idx0 ON _purge_tmp_14(sample_id) ;
  CREATE INDEX _purge_tmp_14_idx1 ON _purge_tmp_14(report_id) ;
  CREATE INDEX _purge_tmp_14_idx2 ON _purge_tmp_14(top_hosts_id) ;
  CREATE INDEX _purge_tmp_14_idx3 ON _purge_tmp_14(alerts_id) ;
  ANALYZE _purge_tmp_14 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_2.report_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_14 ;
  CREATE TEMP TABLE _purge_tmp_15 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.alerts_id) = (_purge_tmp_2.report_id));
  CREATE INDEX _purge_tmp_15_idx0 ON _purge_tmp_15(sample_id) ;
  CREATE INDEX _purge_tmp_15_idx1 ON _purge_tmp_15(report_id) ;
  CREATE INDEX _purge_tmp_15_idx2 ON _purge_tmp_15(top_hosts_id) ;
  CREATE INDEX _purge_tmp_15_idx3 ON _purge_tmp_15(alerts_id) ;
  ANALYZE _purge_tmp_15 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.alerts_id) = (_purge_tmp_2.report_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_15 ;
  CREATE TEMP TABLE _purge_tmp_16 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.entropy_id) = (_purge_tmp_2.report_id));
  CREATE INDEX _purge_tmp_16_idx0 ON _purge_tmp_16(sample_id) ;
  CREATE INDEX _purge_tmp_16_idx1 ON _purge_tmp_16(report_id) ;
  CREATE INDEX _purge_tmp_16_idx2 ON _purge_tmp_16(top_hosts_id) ;
  CREATE INDEX _purge_tmp_16_idx3 ON _purge_tmp_16(alerts_id) ;
  ANALYZE _purge_tmp_16 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.entropy_id) = (_purge_tmp_2.report_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_16 ;
  
  CREATE TEMP TABLE _purge_tmp_17 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_2 ON ((quarantine.captures.fast_id) = (_purge_tmp_2.report_id));
  CREATE INDEX _purge_tmp_17_idx0 ON _purge_tmp_17(capture_id) ;
  CREATE INDEX _purge_tmp_17_idx1 ON _purge_tmp_17(capture_id,addr) ;
  CREATE INDEX _purge_tmp_17_idx2 ON _purge_tmp_17(fast_id) ;
  ANALYZE _purge_tmp_17 ;
  CREATE TEMP TABLE _purge_tmp_18 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_17 ON ((quarantine.samples.capture_id) = (_purge_tmp_17.capture_id));
  CREATE INDEX _purge_tmp_18_idx0 ON _purge_tmp_18(sample_id) ;
  ANALYZE _purge_tmp_18 ;
  DELETE FROM quarantine.samples USING _purge_tmp_17 WHERE (quarantine.samples.capture_id) = (_purge_tmp_17.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_18 ;
  CREATE TEMP TABLE _purge_tmp_19 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_17 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_17.capture_id,_purge_tmp_17.addr));
  CREATE INDEX _purge_tmp_19_idx0 ON _purge_tmp_19(sample_id) ;
  ANALYZE _purge_tmp_19 ;
  DELETE FROM quarantine.samples USING _purge_tmp_17 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_17.capture_id,_purge_tmp_17.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_19 ;
  DELETE FROM quarantine.captures USING (SELECT report_id FROM _purge_tmp_2 ORDER BY report_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.report_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_17 ;
  CREATE TEMP TABLE _purge_tmp_20 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_2 ON ((quarantine.samples.sample_id) = (_purge_tmp_2.report_id));
  CREATE INDEX _purge_tmp_20_idx0 ON _purge_tmp_20(sample_id) ;
  ANALYZE _purge_tmp_20 ;
  DELETE FROM quarantine.samples USING _purge_tmp_2 WHERE (quarantine.samples.sample_id) = (_purge_tmp_2.report_id); 
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_20 ;
  DELETE FROM fast.entities USING (SELECT report_id FROM _purge_tmp_2 ORDER BY report_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.entities.entity_id) = (work.report_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;

 DELETE FROM fast.top_host_sets USING (SELECT top_hosts_id FROM _purge_tmp_2 ORDER BY top_hosts_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.entity_id) = (work.top_hosts_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 CREATE TEMP TABLE _purge_tmp_21 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.sample_id) = (_purge_tmp_2.top_hosts_id));
 CREATE INDEX _purge_tmp_21_idx0 ON _purge_tmp_21(sample_id) ;
 CREATE INDEX _purge_tmp_21_idx1 ON _purge_tmp_21(report_id) ;
 CREATE INDEX _purge_tmp_21_idx2 ON _purge_tmp_21(top_hosts_id) ;
 CREATE INDEX _purge_tmp_21_idx3 ON _purge_tmp_21(alerts_id) ;
 ANALYZE _purge_tmp_21 ;
 DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.sample_id) = (_purge_tmp_2.top_hosts_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_21 ;
 CREATE TEMP TABLE _purge_tmp_22 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.report_id) = (_purge_tmp_2.top_hosts_id));
 CREATE INDEX _purge_tmp_22_idx0 ON _purge_tmp_22(sample_id) ;
 CREATE INDEX _purge_tmp_22_idx1 ON _purge_tmp_22(report_id) ;
 CREATE INDEX _purge_tmp_22_idx2 ON _purge_tmp_22(top_hosts_id) ;
 CREATE INDEX _purge_tmp_22_idx3 ON _purge_tmp_22(alerts_id) ;
 ANALYZE _purge_tmp_22 ;
 DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.report_id) = (_purge_tmp_2.top_hosts_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_22 ;
 CREATE TEMP TABLE _purge_tmp_23 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.top_hosts_id) = (_purge_tmp_2.top_hosts_id));
 CREATE INDEX _purge_tmp_23_idx0 ON _purge_tmp_23(sample_id) ;
 CREATE INDEX _purge_tmp_23_idx1 ON _purge_tmp_23(report_id) ;
 CREATE INDEX _purge_tmp_23_idx2 ON _purge_tmp_23(top_hosts_id) ;
 CREATE INDEX _purge_tmp_23_idx3 ON _purge_tmp_23(alerts_id) ;
 ANALYZE _purge_tmp_23 ;
 DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_2.top_hosts_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_23 ;
 CREATE TEMP TABLE _purge_tmp_24 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.alerts_id) = (_purge_tmp_2.top_hosts_id));
 CREATE INDEX _purge_tmp_24_idx0 ON _purge_tmp_24(sample_id) ;
 CREATE INDEX _purge_tmp_24_idx1 ON _purge_tmp_24(report_id) ;
 CREATE INDEX _purge_tmp_24_idx2 ON _purge_tmp_24(top_hosts_id) ;
 CREATE INDEX _purge_tmp_24_idx3 ON _purge_tmp_24(alerts_id) ;
 ANALYZE _purge_tmp_24 ;
 DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.alerts_id) = (_purge_tmp_2.top_hosts_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_24 ;
 CREATE TEMP TABLE _purge_tmp_25 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.entropy_id) = (_purge_tmp_2.top_hosts_id));
 CREATE INDEX _purge_tmp_25_idx0 ON _purge_tmp_25(sample_id) ;
 CREATE INDEX _purge_tmp_25_idx1 ON _purge_tmp_25(report_id) ;
 CREATE INDEX _purge_tmp_25_idx2 ON _purge_tmp_25(top_hosts_id) ;
 CREATE INDEX _purge_tmp_25_idx3 ON _purge_tmp_25(alerts_id) ;
 ANALYZE _purge_tmp_25 ;
 DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.entropy_id) = (_purge_tmp_2.top_hosts_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_25 ;

 CREATE TEMP TABLE _purge_tmp_26 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_2 ON ((quarantine.captures.fast_id) = (_purge_tmp_2.top_hosts_id));
 CREATE INDEX _purge_tmp_26_idx0 ON _purge_tmp_26(capture_id) ;
 CREATE INDEX _purge_tmp_26_idx1 ON _purge_tmp_26(capture_id,addr) ;
 CREATE INDEX _purge_tmp_26_idx2 ON _purge_tmp_26(fast_id) ;
 ANALYZE _purge_tmp_26 ;
 CREATE TEMP TABLE _purge_tmp_27 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_26 ON ((quarantine.samples.capture_id) = (_purge_tmp_26.capture_id));
 CREATE INDEX _purge_tmp_27_idx0 ON _purge_tmp_27(sample_id) ;
 ANALYZE _purge_tmp_27 ;
 DELETE FROM quarantine.samples USING _purge_tmp_26 WHERE (quarantine.samples.capture_id) = (_purge_tmp_26.capture_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_27 ;
 CREATE TEMP TABLE _purge_tmp_28 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_26 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_26.capture_id,_purge_tmp_26.addr));
 CREATE INDEX _purge_tmp_28_idx0 ON _purge_tmp_28(sample_id) ;
 ANALYZE _purge_tmp_28 ;
 DELETE FROM quarantine.samples USING _purge_tmp_26 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_26.capture_id,_purge_tmp_26.addr) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_28 ;
 DELETE FROM quarantine.captures USING (SELECT top_hosts_id FROM _purge_tmp_2 ORDER BY top_hosts_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.top_hosts_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_26 ;
 CREATE TEMP TABLE _purge_tmp_29 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_2 ON ((quarantine.samples.sample_id) = (_purge_tmp_2.top_hosts_id));
  CREATE INDEX _purge_tmp_29_idx0 ON _purge_tmp_29(sample_id) ;
  ANALYZE _purge_tmp_29 ;
  DELETE FROM quarantine.samples USING _purge_tmp_2 WHERE (quarantine.samples.sample_id) = (_purge_tmp_2.top_hosts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_29 ;
  DELETE FROM fast.entities USING (SELECT top_hosts_id FROM _purge_tmp_2 ORDER BY top_hosts_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.entities.entity_id) = (work.top_hosts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DELETE FROM fast.top_host_sets USING (SELECT alerts_id FROM _purge_tmp_2 ORDER BY alerts_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.entity_id) = (work.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  CREATE TEMP TABLE _purge_tmp_30 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.sample_id) = (_purge_tmp_2.alerts_id));
  CREATE INDEX _purge_tmp_30_idx0 ON _purge_tmp_30(sample_id) ;
  CREATE INDEX _purge_tmp_30_idx1 ON _purge_tmp_30(report_id) ;
  CREATE INDEX _purge_tmp_30_idx2 ON _purge_tmp_30(top_hosts_id) ;
  CREATE INDEX _purge_tmp_30_idx3 ON _purge_tmp_30(alerts_id) ;
  ANALYZE _purge_tmp_30 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.sample_id) = (_purge_tmp_2.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_30 ;
  CREATE TEMP TABLE _purge_tmp_31 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.report_id) = (_purge_tmp_2.alerts_id));
  CREATE INDEX _purge_tmp_31_idx0 ON _purge_tmp_31(sample_id) ;
  CREATE INDEX _purge_tmp_31_idx1 ON _purge_tmp_31(report_id) ;
  CREATE INDEX _purge_tmp_31_idx2 ON _purge_tmp_31(top_hosts_id) ;
  CREATE INDEX _purge_tmp_31_idx3 ON _purge_tmp_31(alerts_id) ;
  ANALYZE _purge_tmp_31 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.report_id) = (_purge_tmp_2.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  
  DROP TABLE _purge_tmp_31 ;
  CREATE TEMP TABLE _purge_tmp_32 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.top_hosts_id) = (_purge_tmp_2.alerts_id));
  CREATE INDEX _purge_tmp_32_idx0 ON _purge_tmp_32(sample_id) ;
  CREATE INDEX _purge_tmp_32_idx1 ON _purge_tmp_32(report_id) ;
  CREATE INDEX _purge_tmp_32_idx2 ON _purge_tmp_32(top_hosts_id) ;
  CREATE INDEX _purge_tmp_32_idx3 ON _purge_tmp_32(alerts_id) ;
  ANALYZE _purge_tmp_32 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_2.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_32 ;
  CREATE TEMP TABLE _purge_tmp_33 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.alerts_id) = (_purge_tmp_2.alerts_id));
  CREATE INDEX _purge_tmp_33_idx0 ON _purge_tmp_33(sample_id) ;
  CREATE INDEX _purge_tmp_33_idx1 ON _purge_tmp_33(report_id) ;
  CREATE INDEX _purge_tmp_33_idx2 ON _purge_tmp_33(top_hosts_id) ;
  CREATE INDEX _purge_tmp_33_idx3 ON _purge_tmp_33(alerts_id) ;
  ANALYZE _purge_tmp_33 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.alerts_id) = (_purge_tmp_2.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_33 ;
  CREATE TEMP TABLE _purge_tmp_34 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_2 ON ((flood.samples.entropy_id) = (_purge_tmp_2.alerts_id));
  CREATE INDEX _purge_tmp_34_idx0 ON _purge_tmp_34(sample_id) ;
  CREATE INDEX _purge_tmp_34_idx1 ON _purge_tmp_34(report_id) ;
  CREATE INDEX _purge_tmp_34_idx2 ON _purge_tmp_34(top_hosts_id) ;
  CREATE INDEX _purge_tmp_34_idx3 ON _purge_tmp_34(alerts_id) ;
  ANALYZE _purge_tmp_34 ;
  DELETE FROM flood.samples USING _purge_tmp_2 WHERE (flood.samples.entropy_id) = (_purge_tmp_2.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;

  CREATE TEMP TABLE _purge_tmp_35 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_2 ON ((quarantine.captures.fast_id) = (_purge_tmp_2.alerts_id));
  CREATE INDEX _purge_tmp_35_idx0 ON _purge_tmp_35(capture_id) ;
  CREATE INDEX _purge_tmp_35_idx1 ON _purge_tmp_35(capture_id,addr) ;
  CREATE INDEX _purge_tmp_35_idx2 ON _purge_tmp_35(fast_id) ;
  ANALYZE _purge_tmp_35 ;
  CREATE TEMP TABLE _purge_tmp_36 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_35 ON ((quarantine.samples.capture_id) = (_purge_tmp_35.capture_id));
  CREATE INDEX _purge_tmp_36_idx0 ON _purge_tmp_36(sample_id) ;
  ANALYZE _purge_tmp_36 ;
  DELETE FROM quarantine.samples USING _purge_tmp_35 WHERE (quarantine.samples.capture_id) = (_purge_tmp_35.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_36 ;
  CREATE TEMP TABLE _purge_tmp_37 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_35 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_35.capture_id,_purge_tmp_35.addr));
  CREATE INDEX _purge_tmp_37_idx0 ON _purge_tmp_37(sample_id) ;
  ANALYZE _purge_tmp_37 ;
  DELETE FROM quarantine.samples USING _purge_tmp_35 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_35.capture_id,_purge_tmp_35.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_37 ;
  DELETE FROM quarantine.captures USING (SELECT alerts_id FROM _purge_tmp_2 ORDER BY alerts_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_35 ;
  
  CREATE TEMP TABLE _purge_tmp_38 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_2 ON ((quarantine.samples.sample_id) = (_purge_tmp_2.alerts_id)) ;
  CREATE INDEX _purge_tmp_38_idx0 ON _purge_tmp_38(sample_id) ;
  ANALYZE _purge_tmp_38 ;
  DELETE FROM quarantine.samples USING _purge_tmp_2 WHERE (quarantine.samples.sample_id) = (_purge_tmp_2.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_38 ;
  DELETE FROM fast.entities USING (SELECT alerts_id FROM _purge_tmp_2 ORDER BY alerts_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.entities.entity_id) = (work.alerts_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_2 ;
  DELETE FROM flood.registry USING (SELECT flood_id FROM _purge_tmp_1 ORDER BY flood_id OFFSET 0 LIMIT 10000) AS work WHERE (flood.registry.flood_id) = (work.flood_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
   DROP TABLE _purge_tmp_1 ;
 
  --snapshot
   snapshot_aging_days := public.get_int_param('Purge','snapshot_history'); 
 IF snapshot_aging_days is NULL THEN
    snapshot_aging_days :=14;
 END IF;
 
  snapshot_time_interval := public.get_int_param('Snapshot','time_interval'); 
 IF snapshot_time_interval is NULL THEN
    snapshot_time_interval :=10;
 END IF;
 
 DELETE FROM flood.snapshot WHERE since < CURRENT_DATE - snapshot_aging_days ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DELETE FROM flood.snapshot WHERE since < CURRENT_TIMESTAMP(2) - interval '1 hour' - interval '1 second' and date_part('min',since)  < (60 - snapshot_time_interval) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
    
  --SELECT flood.mtg_lock() IS NULL ;
  PERFORM flood.mtg_lock()  ;
  DELETE FROM flood.mtg_reqs WHERE action_expire < CURRENT_DATE - aging_days;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  CREATE TEMP TABLE _purge_tmp_40 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood_id FROM flood.state WHERE stop < CURRENT_DATE - aging_days ;
  CREATE INDEX _purge_tmp_40_idx0 ON _purge_tmp_40(flood_id) ;
  ANALYZE _purge_tmp_40 ;
   
  CREATE TEMP TABLE _purge_tmp_41 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_40 ON ((flood.samples.flood_id) = (_purge_tmp_40.flood_id)) ;
  CREATE INDEX _purge_tmp_41_idx0 ON _purge_tmp_41(sample_id) ;
 CREATE INDEX _purge_tmp_41_idx1 ON _purge_tmp_41(report_id) ;
 CREATE INDEX _purge_tmp_41_idx2 ON _purge_tmp_41(top_hosts_id) ;
 CREATE INDEX _purge_tmp_41_idx3 ON _purge_tmp_41(alerts_id) ;
 ANALYZE _purge_tmp_41 ;
 DELETE FROM flood.samples USING _purge_tmp_40 WHERE (flood.samples.flood_id) = (_purge_tmp_40.flood_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_41 ;
 DELETE FROM flood.registry USING (SELECT flood_id FROM _purge_tmp_40 ORDER BY flood_id OFFSET 0 LIMIT 10000) AS work WHERE (flood.registry.flood_id) = (work.flood_id) ;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 DROP TABLE _purge_tmp_40 ;
 DELETE FROM flood.errors WHERE stop < CURRENT_DATE - aging_days;
 GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
 --SELECT flood.mtg_lock() IS NULL ;
 PERFORM flood.mtg_lock() ;
 DELETE FROM flood.mtg_graphs_real WHERE at < CURRENT_DATE - aging_days ;
 GET DIAGNOSTICS rows = ROW_COUNT;
 all_rows := all_rows + rows;
 DELETE FROM flood.mtg_live_log_past WHERE state_until < CURRENT_DATE - aging_days ;
 GET DIAGNOSTICS rows = ROW_COUNT;
 all_rows := all_rows + rows;
 DELETE FROM flood.mtg_reqs_log_past WHERE req_until < CURRENT_DATE - aging_days ;
 GET DIAGNOSTICS rows = ROW_COUNT;
 all_rows := all_rows + rows;
 
  --BGP
 bgp_aging_days := public.get_int_param('Purge','bgp_history'); 
 IF bgp_aging_days is NULL THEN
    bgp_aging_days :=60;
 END IF;	
 DELETE FROM flood.bgp_events WHERE since < CURRENT_DATE - bgp_aging_days ;
 GET DIAGNOSTICS rows = ROW_COUNT;
 all_rows := all_rows + rows;
 
 curr_time := clock_timestamp()::TIMESTAMP;
 
 RAISE NOTICE '%: detect_purge - % deleted rows ', curr_time,all_rows;  
 --COMMIT;

 END$_$;


ALTER FUNCTION purge.detect_purge(integer) OWNER TO ndbadm;
-----

-- fast_purge
CREATE OR REPLACE FUNCTION fast_purge(aging_days integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    rows	INTEGER; 
    all_rows	INTEGER;    
    curr_time   TIMESTAMP;
BEGIN    

  all_rows := 0;

  CREATE TEMP TABLE _purge_tmp_69 WITHOUT OIDS ON COMMIT DROP AS
    SELECT fast.entities.entity_id FROM fast.entities WHERE modified < CURRENT_DATE - aging_days;

  CREATE INDEX _purge_tmp_69_idx0 ON _purge_tmp_69(entity_id) ;
  ANALYZE _purge_tmp_69 ;

  DELETE FROM fast.top_host_sets USING (SELECT entity_id FROM _purge_tmp_69 ORDER BY entity_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.entity_id) = (work.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  CREATE TEMP TABLE _purge_tmp_70 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_69 ON ((flood.samples.sample_id) = (_purge_tmp_69.entity_id));
  CREATE INDEX _purge_tmp_70_idx0 ON _purge_tmp_70(sample_id) ;
  CREATE INDEX _purge_tmp_70_idx1 ON _purge_tmp_70(report_id) ;
  CREATE INDEX _purge_tmp_70_idx2 ON _purge_tmp_70(top_hosts_id) ;
  CREATE INDEX _purge_tmp_70_idx3 ON _purge_tmp_70(alerts_id) ;
  ANALYZE _purge_tmp_70 ;
  DELETE FROM flood.samples USING _purge_tmp_69 WHERE (flood.samples.sample_id) = (_purge_tmp_69.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_70 ;
  
  CREATE TEMP TABLE _purge_tmp_71 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_69 ON ((flood.samples.report_id) = (_purge_tmp_69.entity_id));
  CREATE INDEX _purge_tmp_71_idx0 ON _purge_tmp_71(sample_id) ;
  CREATE INDEX _purge_tmp_71_idx1 ON _purge_tmp_71(report_id) ;
  CREATE INDEX _purge_tmp_71_idx2 ON _purge_tmp_71(top_hosts_id) ;
  CREATE INDEX _purge_tmp_71_idx3 ON _purge_tmp_71(alerts_id) ;
  ANALYZE _purge_tmp_71 ;
  DELETE FROM flood.samples USING _purge_tmp_69 WHERE (flood.samples.report_id) = (_purge_tmp_69.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_71 ;
  
  CREATE TEMP TABLE _purge_tmp_72 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_69 ON ((flood.samples.top_hosts_id) = (_purge_tmp_69.entity_id));
  CREATE INDEX _purge_tmp_72_idx0 ON _purge_tmp_72(sample_id) ;
  CREATE INDEX _purge_tmp_72_idx1 ON _purge_tmp_72(report_id) ;
  CREATE INDEX _purge_tmp_72_idx2 ON _purge_tmp_72(top_hosts_id) ;
  CREATE INDEX _purge_tmp_72_idx3 ON _purge_tmp_72(alerts_id) ;
  ANALYZE _purge_tmp_72 ;
  DELETE FROM flood.samples USING _purge_tmp_69 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_69.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_72 ;

  CREATE TEMP TABLE _purge_tmp_73 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_69 ON ((flood.samples.alerts_id) = (_purge_tmp_69.entity_id));
  CREATE INDEX _purge_tmp_73_idx0 ON _purge_tmp_73(sample_id) ;
  CREATE INDEX _purge_tmp_73_idx1 ON _purge_tmp_73(report_id) ;
  CREATE INDEX _purge_tmp_73_idx2 ON _purge_tmp_73(top_hosts_id) ;
  CREATE INDEX _purge_tmp_73_idx3 ON _purge_tmp_73(alerts_id) ;
  ANALYZE _purge_tmp_73 ;
  DELETE FROM flood.samples USING _purge_tmp_69 WHERE (flood.samples.alerts_id) = (_purge_tmp_69.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_73 ;

  CREATE TEMP TABLE _purge_tmp_74 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_69 ON ((flood.samples.entropy_id) = (_purge_tmp_69.entity_id));
  CREATE INDEX _purge_tmp_74_idx0 ON _purge_tmp_74(sample_id) ;
  CREATE INDEX _purge_tmp_74_idx1 ON _purge_tmp_74(report_id) ;
  CREATE INDEX _purge_tmp_74_idx2 ON _purge_tmp_74(top_hosts_id) ;
  CREATE INDEX _purge_tmp_74_idx3 ON _purge_tmp_74(alerts_id) ;
  ANALYZE _purge_tmp_74 ;
  DELETE FROM flood.samples USING _purge_tmp_69 WHERE (flood.samples.entropy_id) = (_purge_tmp_69.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_74 ;

 
  CREATE TEMP TABLE _purge_tmp_75 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_69 ON ((quarantine.captures.fast_id) = (_purge_tmp_69.entity_id));
  CREATE INDEX _purge_tmp_75_idx0 ON _purge_tmp_75(capture_id) ;
  CREATE INDEX _purge_tmp_75_idx1 ON _purge_tmp_75(capture_id,addr) ;
  CREATE INDEX _purge_tmp_75_idx2 ON _purge_tmp_75(fast_id) ;
  ANALYZE _purge_tmp_75 ;
  CREATE TEMP TABLE _purge_tmp_76 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_75 ON ((quarantine.samples.capture_id) = (_purge_tmp_75.capture_id));
  CREATE INDEX _purge_tmp_76_idx0 ON _purge_tmp_76(sample_id) ;
  ANALYZE _purge_tmp_76 ;
  DELETE FROM quarantine.samples USING _purge_tmp_75 WHERE (quarantine.samples.capture_id) = (_purge_tmp_75.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_76 ;

  CREATE TEMP TABLE _purge_tmp_77 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_75 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_75.capture_id,_purge_tmp_75.addr));
  CREATE INDEX _purge_tmp_77_idx0 ON _purge_tmp_77(sample_id) ;
  ANALYZE _purge_tmp_77 ;
  DELETE FROM quarantine.samples USING _purge_tmp_75 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_75.capture_id,_purge_tmp_75.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_77 ;
  DELETE FROM quarantine.captures USING (SELECT entity_id FROM _purge_tmp_69 ORDER BY entity_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_75 ;

  CREATE TEMP TABLE _purge_tmp_78 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_69 ON ((quarantine.samples.sample_id) = (_purge_tmp_69.entity_id));
  CREATE INDEX _purge_tmp_78_idx0 ON _purge_tmp_78(sample_id) ;
  ANALYZE _purge_tmp_78 ;
  DELETE FROM quarantine.samples USING _purge_tmp_69 WHERE (quarantine.samples.sample_id) = (_purge_tmp_69.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_78 ;

  --hb SELECT min(modified) FROM fast.entities ;
  --hb SELECT max(modified) FROM (SELECT modified FROM fast.entities WHERE modified = CURRENT_DATE - (aging_days-15) AND modified < CURRENT_DATE - aging_days ORDER BY modified LIMIT 10000) AS work ;
  DROP TABLE _purge_tmp_69 ;

  CREATE TEMP TABLE _purge_tmp_79 WITHOUT OIDS ON COMMIT DROP AS
    SELECT entity_id
    FROM fast.entity_data
    JOIN fast.entities    USING (entity_id)
    JOIN fast.types       USING (type_id)
    WHERE fast.entities.modified
    BETWEEN CURRENT_DATE - 17
    AND CURRENT_DATE - 14
    AND fast.types.name = 'traffic-samples' ;
  CREATE INDEX _purge_tmp_79_idx0 ON _purge_tmp_79(entity_id) ;
  ANALYZE _purge_tmp_79 ;
   
  DELETE FROM fast.top_host_sets USING (SELECT entity_id FROM _purge_tmp_79 ORDER BY entity_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.entity_id) = (work.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  CREATE TEMP TABLE _purge_tmp_80 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_79 ON ((flood.samples.sample_id) = (_purge_tmp_79.entity_id));
  CREATE INDEX _purge_tmp_80_idx0 ON _purge_tmp_80(sample_id) ;
  CREATE INDEX _purge_tmp_80_idx1 ON _purge_tmp_80(report_id) ;
  CREATE INDEX _purge_tmp_80_idx2 ON _purge_tmp_80(top_hosts_id) ;
  CREATE INDEX _purge_tmp_80_idx3 ON _purge_tmp_80(alerts_id) ;
  ANALYZE _purge_tmp_80 ;
  DELETE FROM flood.samples USING _purge_tmp_79 WHERE (flood.samples.sample_id) = (_purge_tmp_79.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_80 ;
  
  CREATE TEMP TABLE _purge_tmp_81 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_79 ON ((flood.samples.report_id) = (_purge_tmp_79.entity_id));
  CREATE INDEX _purge_tmp_81_idx0 ON _purge_tmp_81(sample_id) ;
  CREATE INDEX _purge_tmp_81_idx1 ON _purge_tmp_81(report_id) ;
  CREATE INDEX _purge_tmp_81_idx2 ON _purge_tmp_81(top_hosts_id) ;
  CREATE INDEX _purge_tmp_81_idx3 ON _purge_tmp_81(alerts_id) ;
  ANALYZE _purge_tmp_81 ;
  DELETE FROM flood.samples USING _purge_tmp_79 WHERE (flood.samples.report_id) = (_purge_tmp_79.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_81 ;

  CREATE TEMP TABLE _purge_tmp_82 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_79 ON ((flood.samples.top_hosts_id) = (_purge_tmp_79.entity_id));
  CREATE INDEX _purge_tmp_82_idx0 ON _purge_tmp_82(sample_id) ;
  CREATE INDEX _purge_tmp_82_idx1 ON _purge_tmp_82(report_id) ;
  CREATE INDEX _purge_tmp_82_idx2 ON _purge_tmp_82(top_hosts_id) ;
  CREATE INDEX _purge_tmp_82_idx3 ON _purge_tmp_82(alerts_id) ;
  ANALYZE _purge_tmp_82 ;
  DELETE FROM flood.samples USING _purge_tmp_79 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_79.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_82 ;

  CREATE TEMP TABLE _purge_tmp_83 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_79 ON ((flood.samples.alerts_id) = (_purge_tmp_79.entity_id));
  CREATE INDEX _purge_tmp_83_idx0 ON _purge_tmp_83(sample_id) ;
  CREATE INDEX _purge_tmp_83_idx1 ON _purge_tmp_83(report_id) ;
  CREATE INDEX _purge_tmp_83_idx2 ON _purge_tmp_83(top_hosts_id) ;
  CREATE INDEX _purge_tmp_83_idx3 ON _purge_tmp_83(alerts_id) ;
  ANALYZE _purge_tmp_83 ;
  DELETE FROM flood.samples USING _purge_tmp_79 WHERE (flood.samples.alerts_id) = (_purge_tmp_79.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_83 ;

  CREATE TEMP TABLE _purge_tmp_84 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_79 ON ((flood.samples.entropy_id) = (_purge_tmp_79.entity_id));
  CREATE INDEX _purge_tmp_84_idx0 ON _purge_tmp_84(sample_id) ;
  CREATE INDEX _purge_tmp_84_idx1 ON _purge_tmp_84(report_id) ;
  CREATE INDEX _purge_tmp_84_idx2 ON _purge_tmp_84(top_hosts_id) ;
  CREATE INDEX _purge_tmp_84_idx3 ON _purge_tmp_84(alerts_id) ;
  ANALYZE _purge_tmp_84 ;
  DELETE FROM flood.samples USING _purge_tmp_79 WHERE (flood.samples.entropy_id) = (_purge_tmp_79.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_84 ;

  CREATE TEMP TABLE _purge_tmp_85 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_79 ON ((quarantine.captures.fast_id) = (_purge_tmp_79.entity_id));
  CREATE INDEX _purge_tmp_85_idx0 ON _purge_tmp_85(capture_id) ;
  CREATE INDEX _purge_tmp_85_idx1 ON _purge_tmp_85(capture_id,addr) ;
  CREATE INDEX _purge_tmp_85_idx2 ON _purge_tmp_85(fast_id) ;
  ANALYZE _purge_tmp_85 ;
  CREATE TEMP TABLE _purge_tmp_86 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_85 ON ((quarantine.samples.capture_id) = (_purge_tmp_85.capture_id));
  CREATE INDEX _purge_tmp_86_idx0 ON _purge_tmp_86(sample_id) ;
  ANALYZE _purge_tmp_86 ;
  DELETE FROM quarantine.samples USING _purge_tmp_85 WHERE (quarantine.samples.capture_id) = (_purge_tmp_85.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_86 ;

  CREATE TEMP TABLE _purge_tmp_87 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_85 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_85.capture_id,_purge_tmp_85.addr));
  CREATE INDEX _purge_tmp_87_idx0 ON _purge_tmp_87(sample_id) ;
  ANALYZE _purge_tmp_87 ;
  DELETE FROM quarantine.samples USING _purge_tmp_85 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_85.capture_id,_purge_tmp_85.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_87 ;

  DELETE FROM quarantine.captures USING (SELECT entity_id FROM _purge_tmp_79 ORDER BY entity_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_85 ;

  CREATE TEMP TABLE _purge_tmp_88 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_79 ON ((quarantine.samples.sample_id) = (_purge_tmp_79.entity_id));
  CREATE INDEX _purge_tmp_88_idx0 ON _purge_tmp_88(sample_id) ;
  ANALYZE _purge_tmp_88 ;
  DELETE FROM quarantine.samples USING _purge_tmp_79 WHERE (quarantine.samples.sample_id) = (_purge_tmp_79.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_88 ;

  DELETE FROM fast.entities USING (SELECT entity_id FROM _purge_tmp_79 ORDER BY entity_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.entities.entity_id) = (work.entity_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_79 ;
  CREATE TEMP TABLE _purge_tmp_89 WITHOUT OIDS ON COMMIT DROP AS
    SELECT p.pattern_id
    FROM fast.patterns p
    LEFT JOIN fast.entity_patterns e USING (pattern_id)
    LEFT JOIN flood.mtg_reqs_log m ON (
    p.pattern_id = m.orig_pattern_id
    OR p.pattern_id = m.pattern_id
    )
    WHERE e.entity_id IS NULL
    AND m.flood_id IS NULL;
  CREATE INDEX _purge_tmp_89_idx0 ON _purge_tmp_89(pattern_id) ;
  ANALYZE _purge_tmp_89 ;
   
  DELETE FROM fast.top_host_sets USING (SELECT pattern_id FROM _purge_tmp_89 ORDER BY pattern_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.pattern_id) = (work.pattern_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  --hb add new table for purge 12.2018
  DELETE FROM fast.top_subnet_sets USING (SELECT pattern_id FROM _purge_tmp_89 ORDER BY pattern_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_subnet_sets.pattern_id) = (work.pattern_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DELETE FROM fast.patterns USING (SELECT pattern_id FROM _purge_tmp_89 ORDER BY pattern_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.patterns.pattern_id) = (work.pattern_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_89 ;

  CREATE TEMP TABLE _purge_tmp_90 WITHOUT OIDS ON COMMIT DROP AS
    SELECT p.pat_strip_id
    FROM fast.pat_strips p
    LEFT JOIN fast.pat_contents e USING(pat_strip_id)
    WHERE e.pattern_id IS NULL;
  CREATE INDEX _purge_tmp_90_idx0 ON _purge_tmp_90(pat_strip_id) ;
  ANALYZE _purge_tmp_90 ;
  DELETE FROM fast.pat_strips USING (SELECT pat_strip_id FROM _purge_tmp_90 ORDER BY pat_strip_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.pat_strips.pat_strip_id) = (work.pat_strip_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_90 ;

  CREATE TEMP TABLE _purge_tmp_91 WITHOUT OIDS ON COMMIT DROP AS
    SELECT DISTINCT pat_strip_id from fast.pat_strips
    EXCEPT
    SELECT DISTINCT pat_strip_id FROM fast.pat_contents ;
  CREATE INDEX _purge_tmp_91_idx0 ON _purge_tmp_91(pat_strip_id) ;
  ANALYZE _purge_tmp_91 ;
  DELETE FROM fast.pat_strips USING (SELECT pat_strip_id FROM _purge_tmp_91 ORDER BY pat_strip_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.pat_strips.pat_strip_id) = (work.pat_strip_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  DROP TABLE _purge_tmp_91 ;
  
 curr_time := clock_timestamp()::TIMESTAMP;
 
RAISE NOTICE '%: fast_purge - % deleted rows ', curr_time,all_rows;  
 --COMMIT;

 END$_$;


ALTER FUNCTION purge.fast_purge(integer) OWNER TO ndbadm;
---

--- quarantine_purge
CREATE OR REPLACE FUNCTION quarantine_purge(aging_days integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    rows	INTEGER; 
    all_rows	INTEGER;    
    curr_time   TIMESTAMP;
BEGIN    

  all_rows := 0;
  
  
  CREATE TEMP TABLE _purge_tmp_42 WITHOUT OIDS ON COMMIT DROP AS
    SELECT capture_id
    FROM quarantine.captures
    LEFT JOIN quarantine.importance USING (capture_id)
    WHERE (timestamp BETWEEN CURRENT_DATE - 21 AND CURRENT_DATE - 14)
    AND importance IS NULL
    UNION ALL
    SELECT capture_id
    FROM quarantine.importance
    JOIN quarantine.captures USING (capture_id)
    WHERE importance = 0 AND timestamp < CURRENT_DATE - 14; 

  CREATE INDEX _purge_tmp_42_idx0 ON _purge_tmp_42(capture_id) ;
  ANALYZE _purge_tmp_42 ;

  CREATE TEMP TABLE _purge_tmp_43 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_42 ON ((quarantine.captures.capture_id) = (_purge_tmp_42.capture_id));
  CREATE INDEX _purge_tmp_43_idx0 ON _purge_tmp_43(capture_id) ;
  CREATE INDEX _purge_tmp_43_idx1 ON _purge_tmp_43(capture_id,addr) ;
  CREATE INDEX _purge_tmp_43_idx2 ON _purge_tmp_43(fast_id) ;
  ANALYZE _purge_tmp_43 ;
  CREATE TEMP TABLE _purge_tmp_44 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_43 ON ((quarantine.samples.capture_id) = (_purge_tmp_43.capture_id));
  CREATE INDEX _purge_tmp_44_idx0 ON _purge_tmp_44(sample_id) ;
  ANALYZE _purge_tmp_44 ;
  DELETE FROM quarantine.samples USING _purge_tmp_43 WHERE (quarantine.samples.capture_id) = (_purge_tmp_43.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DELETE FROM fast.top_host_sets USING (SELECT sample_id FROM _purge_tmp_44 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.entity_id) = (work.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  --hb add new table for purge 12.2018
  DELETE FROM fast.top_subnet_sets USING (SELECT sample_id FROM _purge_tmp_44 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_subnet_sets.sample_id) = (work.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  CREATE TEMP TABLE _purge_tmp_45 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_44 ON ((flood.samples.sample_id) = (_purge_tmp_44.sample_id));
  CREATE INDEX _purge_tmp_45_idx0 ON _purge_tmp_45(sample_id) ;
  CREATE INDEX _purge_tmp_45_idx1 ON _purge_tmp_45(report_id) ;
  CREATE INDEX _purge_tmp_45_idx2 ON _purge_tmp_45(top_hosts_id) ;
  CREATE INDEX _purge_tmp_45_idx3 ON _purge_tmp_45(alerts_id) ;
  ANALYZE _purge_tmp_45 ;
  DELETE FROM flood.samples USING _purge_tmp_44 WHERE (flood.samples.sample_id) = (_purge_tmp_44.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_45 ;
  CREATE TEMP TABLE _purge_tmp_46 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_44 ON ((flood.samples.report_id) = (_purge_tmp_44.sample_id));
  CREATE INDEX _purge_tmp_46_idx0 ON _purge_tmp_46(sample_id) ;
  CREATE INDEX _purge_tmp_46_idx1 ON _purge_tmp_46(report_id) ;
  CREATE INDEX _purge_tmp_46_idx2 ON _purge_tmp_46(top_hosts_id) ;
  CREATE INDEX _purge_tmp_46_idx3 ON _purge_tmp_46(alerts_id) ;
  ANALYZE _purge_tmp_46 ;
  DELETE FROM flood.samples USING _purge_tmp_44 WHERE (flood.samples.report_id) = (_purge_tmp_44.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_46 ;
  CREATE TEMP TABLE _purge_tmp_47 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_44 ON ((flood.samples.top_hosts_id) = (_purge_tmp_44.sample_id));
  CREATE INDEX _purge_tmp_47_idx0 ON _purge_tmp_47(sample_id) ;
  CREATE INDEX _purge_tmp_47_idx1 ON _purge_tmp_47(report_id) ;
  CREATE INDEX _purge_tmp_47_idx2 ON _purge_tmp_47(top_hosts_id) ; 
  CREATE INDEX _purge_tmp_47_idx3 ON _purge_tmp_47(alerts_id) ;
  ANALYZE _purge_tmp_47 ;
  DELETE FROM flood.samples USING _purge_tmp_44 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_44.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_47 ;
  CREATE TEMP TABLE _purge_tmp_48 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_44 ON ((flood.samples.alerts_id) = (_purge_tmp_44.sample_id));
  CREATE INDEX _purge_tmp_48_idx0 ON _purge_tmp_48(sample_id) ;
  CREATE INDEX _purge_tmp_48_idx1 ON _purge_tmp_48(report_id) ;
  CREATE INDEX _purge_tmp_48_idx2 ON _purge_tmp_48(top_hosts_id) ;
  CREATE INDEX _purge_tmp_48_idx3 ON _purge_tmp_48(alerts_id) ;
  ANALYZE _purge_tmp_48 ;
  DELETE FROM flood.samples USING _purge_tmp_44 WHERE (flood.samples.alerts_id) = (_purge_tmp_44.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_48 ;
  CREATE TEMP TABLE _purge_tmp_49 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_44 ON ((flood.samples.entropy_id) = (_purge_tmp_44.sample_id));
  CREATE INDEX _purge_tmp_49_idx0 ON _purge_tmp_49(sample_id) ;
  CREATE INDEX _purge_tmp_49_idx1 ON _purge_tmp_49(report_id) ;
  CREATE INDEX _purge_tmp_49_idx2 ON _purge_tmp_49(top_hosts_id) ;
  CREATE INDEX _purge_tmp_49_idx3 ON _purge_tmp_49(alerts_id) ;
  ANALYZE _purge_tmp_49 ;
  DELETE FROM flood.samples USING _purge_tmp_44 WHERE (flood.samples.entropy_id) = (_purge_tmp_44.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_49 ;
   
  CREATE TEMP TABLE _purge_tmp_50 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_44 ON ((quarantine.captures.fast_id) = (_purge_tmp_44.sample_id));
  CREATE INDEX _purge_tmp_50_idx0 ON _purge_tmp_50(capture_id) ;
  CREATE INDEX _purge_tmp_50_idx1 ON _purge_tmp_50(capture_id,addr) ;
  CREATE INDEX _purge_tmp_50_idx2 ON _purge_tmp_50(fast_id) ;
  ANALYZE _purge_tmp_50 ;
  CREATE TEMP TABLE _purge_tmp_51 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_50 ON ((quarantine.samples.capture_id) = (_purge_tmp_50.capture_id));
  CREATE INDEX _purge_tmp_51_idx0 ON _purge_tmp_51(sample_id) ;
  ANALYZE _purge_tmp_51 ;
  DELETE FROM quarantine.samples USING _purge_tmp_50 WHERE (quarantine.samples.capture_id) = (_purge_tmp_50.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_51 ;
  CREATE TEMP TABLE _purge_tmp_52 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_50 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_50.capture_id,_purge_tmp_50.addr));
  CREATE INDEX _purge_tmp_52_idx0 ON _purge_tmp_52(sample_id) ;
  ANALYZE _purge_tmp_52 ;
  DELETE FROM quarantine.samples USING _purge_tmp_50 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_50.capture_id,_purge_tmp_50.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_52 ;
  --hb SELECT count(*) FROM _purge_tmp_44 
  DELETE FROM quarantine.captures USING (SELECT sample_id FROM _purge_tmp_44 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_50 ;
  CREATE TEMP TABLE _purge_tmp_53 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_44 ON ((quarantine.samples.sample_id) = (_purge_tmp_44.sample_id));
  CREATE INDEX _purge_tmp_53_idx0 ON _purge_tmp_53(sample_id); 
  ANALYZE _purge_tmp_53 ;
  DELETE FROM quarantine.samples USING _purge_tmp_44 WHERE (quarantine.samples.sample_id) = (_purge_tmp_44.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_53 ;
  --hb SELECT count(*) FROM _purge_tmp_44 ;
  DELETE FROM fast.entities USING (SELECT sample_id FROM _purge_tmp_44 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.entities.entity_id) = (work.sample_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_44 ;
  CREATE TEMP TABLE _purge_tmp_54 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_43 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_43.capture_id,_purge_tmp_43.addr)) ;
  CREATE INDEX _purge_tmp_54_idx0 ON _purge_tmp_54(sample_id) ;
  ANALYZE _purge_tmp_54 ;
  DELETE FROM quarantine.samples USING _purge_tmp_43 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_43.capture_id,_purge_tmp_43.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_54 ;
  --hb SELECT count(*) FROM _purge_tmp_42 ;
  DELETE FROM quarantine.captures USING (SELECT capture_id FROM _purge_tmp_42 ORDER BY capture_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.capture_id) = (work.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
   
  --hb Special handling of constraint top_host_sets_entity_id_fkey
  --hb Automatic handling of constraint top_hosts_ths_id_fkey
  --hb SELECT count(*) FROM _purge_tmp_43 ;
  DELETE FROM fast.top_host_sets USING (SELECT fast_id FROM _purge_tmp_43 ORDER BY fast_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.top_host_sets.entity_id) = (work.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  CREATE TEMP TABLE _purge_tmp_55 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_43 ON ((flood.samples.sample_id) = (_purge_tmp_43.fast_id));
  CREATE INDEX _purge_tmp_55_idx0 ON _purge_tmp_55(sample_id) ;
  CREATE INDEX _purge_tmp_55_idx1 ON _purge_tmp_55(report_id) ;
  CREATE INDEX _purge_tmp_55_idx2 ON _purge_tmp_55(top_hosts_id) ;
  CREATE INDEX _purge_tmp_55_idx3 ON _purge_tmp_55(alerts_id) ;
  ANALYZE _purge_tmp_55 ;
  DELETE FROM flood.samples USING _purge_tmp_43 WHERE (flood.samples.sample_id) = (_purge_tmp_43.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_55 ;
  CREATE TEMP TABLE _purge_tmp_56 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_43 ON ((flood.samples.report_id) = (_purge_tmp_43.fast_id));
  CREATE INDEX _purge_tmp_56_idx0 ON _purge_tmp_56(sample_id) ;
  CREATE INDEX _purge_tmp_56_idx1 ON _purge_tmp_56(report_id) ;
  CREATE INDEX _purge_tmp_56_idx2 ON _purge_tmp_56(top_hosts_id) ;
  CREATE INDEX _purge_tmp_56_idx3 ON _purge_tmp_56(alerts_id) ;
  ANALYZE _purge_tmp_56 ;
  DELETE FROM flood.samples USING _purge_tmp_43 WHERE (flood.samples.report_id) = (_purge_tmp_43.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_56 ;
  CREATE TEMP TABLE _purge_tmp_57 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_43 ON ((flood.samples.top_hosts_id) = (_purge_tmp_43.fast_id));
  CREATE INDEX _purge_tmp_57_idx0 ON _purge_tmp_57(sample_id) ;
  CREATE INDEX _purge_tmp_57_idx1 ON _purge_tmp_57(report_id) ;
  CREATE INDEX _purge_tmp_57_idx2 ON _purge_tmp_57(top_hosts_id) ;
  CREATE INDEX _purge_tmp_57_idx3 ON _purge_tmp_57(alerts_id) ;
  ANALYZE _purge_tmp_57 ;
  DELETE FROM flood.samples USING _purge_tmp_43 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_43.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_57 ;
  CREATE TEMP TABLE _purge_tmp_58 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_43 ON ((flood.samples.alerts_id) = (_purge_tmp_43.fast_id));
  CREATE INDEX _purge_tmp_58_idx0 ON _purge_tmp_58(sample_id) ;
  CREATE INDEX _purge_tmp_58_idx1 ON _purge_tmp_58(report_id) ;
  CREATE INDEX _purge_tmp_58_idx2 ON _purge_tmp_58(top_hosts_id) ;
  --hb CREATE INDEX _purge_tmp_58;_idx3 ON _purge_tmp_58(alerts_id) 
  ANALYZE _purge_tmp_58 ;
  DELETE FROM flood.samples USING _purge_tmp_43 WHERE (flood.samples.alerts_id) = (_purge_tmp_43.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_58 ;
  CREATE TEMP TABLE _purge_tmp_59 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id FROM flood.samples JOIN _purge_tmp_43 ON ((flood.samples.entropy_id) = (_purge_tmp_43.fast_id));
  CREATE INDEX _purge_tmp_59_idx0 ON _purge_tmp_59(sample_id) ;
  CREATE INDEX _purge_tmp_59_idx1 ON _purge_tmp_59(report_id) ;
  CREATE INDEX _purge_tmp_59_idx2 ON _purge_tmp_59(top_hosts_id) ;
  CREATE INDEX _purge_tmp_59_idx3 ON _purge_tmp_59(alerts_id) ;
  ANALYZE _purge_tmp_59 ;
  DELETE FROM flood.samples USING _purge_tmp_43 WHERE (flood.samples.entropy_id) = (_purge_tmp_43.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_59 ;
   
  CREATE TEMP TABLE _purge_tmp_60 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_43 ON ((quarantine.captures.fast_id) = (_purge_tmp_43.fast_id));
  CREATE INDEX _purge_tmp_60_idx0 ON _purge_tmp_60(capture_id) ;
  CREATE INDEX _purge_tmp_60_idx1 ON _purge_tmp_60(capture_id,addr) ;
  CREATE INDEX _purge_tmp_60_idx2 ON _purge_tmp_60(fast_id) ;
  ANALYZE _purge_tmp_60 ;
  CREATE TEMP TABLE _purge_tmp_61 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_60 ON ((quarantine.samples.capture_id) = (_purge_tmp_60.capture_id));
  CREATE INDEX _purge_tmp_61_idx0 ON _purge_tmp_61(sample_id) ;
  ANALYZE _purge_tmp_61 ;
  DELETE FROM quarantine.samples USING _purge_tmp_60 WHERE (quarantine.samples.capture_id) = (_purge_tmp_60.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_61 ;
  CREATE TEMP TABLE _purge_tmp_62 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_60 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_60.capture_id,_purge_tmp_60.addr));
  CREATE INDEX _purge_tmp_62_idx0 ON _purge_tmp_62(sample_id) ;
  ANALYZE _purge_tmp_62 ;
  DELETE FROM quarantine.samples USING _purge_tmp_60 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_60.capture_id,_purge_tmp_60.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_62 ;
  --hb SELECT count(*) FROM _purge_tmp_43 ;
  DELETE FROM quarantine.captures USING (SELECT fast_id FROM _purge_tmp_43 ORDER BY fast_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.fast_id) = (work.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_60 ;
  CREATE TEMP TABLE _purge_tmp_63 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_43 ON ((quarantine.samples.sample_id) = (_purge_tmp_43.fast_id));
  CREATE INDEX _purge_tmp_63_idx0 ON _purge_tmp_63(sample_id) ;
  ANALYZE _purge_tmp_63 ;
  DELETE FROM quarantine.samples USING _purge_tmp_43 WHERE (quarantine.samples.sample_id) = (_purge_tmp_43.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_63 ;
  --hb SELECT count(*) FROM _purge_tmp_43 ;
  DELETE FROM fast.entities USING (SELECT fast_id FROM _purge_tmp_43 ORDER BY fast_id OFFSET 0 LIMIT 10000) AS work WHERE (fast.entities.entity_id) = (work.fast_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
   
 DROP TABLE _purge_tmp_43 ;
 DROP TABLE _purge_tmp_42 ;
  CREATE TEMP TABLE _purge_tmp_64 WITHOUT OIDS ON COMMIT DROP AS
    SELECT capture_id FROM quarantine.captures WHERE timestamp < CURRENT_DATE - aging_days;
  CREATE INDEX _purge_tmp_64_idx0 ON _purge_tmp_64(capture_id) ;
  ANALYZE _purge_tmp_64 ;
   
  CREATE TEMP TABLE _purge_tmp_65 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id FROM quarantine.captures JOIN _purge_tmp_64 ON ((quarantine.captures.capture_id) = (_purge_tmp_64.capture_id));
  CREATE INDEX _purge_tmp_65_idx0 ON _purge_tmp_65(capture_id) ;
  CREATE INDEX _purge_tmp_65_idx1 ON _purge_tmp_65(capture_id,addr) ;
  CREATE INDEX _purge_tmp_65_idx2 ON _purge_tmp_65(fast_id) ;
  ANALYZE _purge_tmp_65 ;
  CREATE TEMP TABLE _purge_tmp_66 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_65 ON ((quarantine.samples.capture_id) = (_purge_tmp_65.capture_id));
  CREATE INDEX _purge_tmp_66_idx0 ON _purge_tmp_66(sample_id) ;
  ANALYZE _purge_tmp_66 ;
  DELETE FROM quarantine.samples USING _purge_tmp_65 WHERE (quarantine.samples.capture_id) = (_purge_tmp_65.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_66 ;
  CREATE TEMP TABLE _purge_tmp_67 WITHOUT OIDS ON COMMIT DROP AS
    SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_65 ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_65.capture_id,_purge_tmp_65.addr));
  CREATE INDEX _purge_tmp_67_idx0 ON _purge_tmp_67(sample_id) ;
  ANALYZE _purge_tmp_67 ;
  DELETE FROM quarantine.samples USING _purge_tmp_65 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_65.capture_id,_purge_tmp_65.addr) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_67 ;
  --hb SELECT count(*) FROM _purge_tmp_64 ;
  DELETE FROM quarantine.captures USING (SELECT capture_id FROM _purge_tmp_64 ORDER BY capture_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.capture_id) = (work.capture_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_65 ;
  DROP TABLE _purge_tmp_64 ;
  DELETE FROM quarantine.sources WHERE until < CURRENT_DATE - aging_days ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  curr_time := clock_timestamp()::TIMESTAMP;
 
 RAISE NOTICE '%: quarantine_purge - % deleted rows ', curr_time,all_rows;  
 --COMMIT;

 END$_$;


ALTER FUNCTION purge.quarantine_purge(integer) OWNER TO ndbadm;
-------

--- smp_purge
CREATE OR REPLACE FUNCTION smp_purge(aging_days integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    rows	INTEGER; 
    all_rows	INTEGER;    
    curr_time   TIMESTAMP;
BEGIN    

  all_rows := 0;

  PERFORM smp.mtg_lock()  ;
  DELETE FROM smp.mtg_reqs WHERE action_expire < CURRENT_DATE -1 ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;

  CREATE TEMP TABLE _purge_tmp_68 WITHOUT OIDS ON COMMIT DROP AS
    SELECT user_id
    FROM smp.users
    LEFT JOIN quarantine.captures USING (user_id)
    WHERE users.modified < CURRENT_DATE - aging_days
    AND capture_id IS NULL ; 
  CREATE INDEX _purge_tmp_68_idx0 ON _purge_tmp_68(user_id) ;
  ANALYZE _purge_tmp_68 ;

  DELETE FROM smp.mtg_live USING _purge_tmp_68 WHERE (smp.mtg_live.user_id) = (_purge_tmp_68.user_id); 
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DELETE FROM smp.users USING (SELECT user_id FROM _purge_tmp_68 ORDER BY user_id OFFSET 0 LIMIT 10000) AS work WHERE (smp.users.user_id) = (work.user_id) ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DROP TABLE _purge_tmp_68 ;
  
  PERFORM smp.mtg_lock()  ;
  
  DELETE FROM smp.mtg_live_log_past WHERE state_until < CURRENT_DATE - aging_days ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;
  
  DELETE FROM smp.mtg_reqs_log_past WHERE req_until < CURRENT_DATE - aging_days ;
  GET DIAGNOSTICS rows = ROW_COUNT;
  all_rows := all_rows + rows;


 curr_time := clock_timestamp()::TIMESTAMP;
 
RAISE NOTICE '%: smp_purge - % deleted rows ', curr_time,all_rows;  

END$_$;


ALTER FUNCTION purge.smp_purge(integer) OWNER TO ndbadm;
-----

--- stats_purge
CREATE OR REPLACE FUNCTION stats_purge(aging_days integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    rows    INTEGER; 
    all_rows  INTEGER;    
    curr_time   TIMESTAMP;
    host_var  INTEGER; 
    name_var      TEXT;
    group_var INTEGER;
    relid_oid  OID;
BEGIN    

  all_rows := 0;
  
  FOR host_var,name_var,group_var,relid_oid  IN
    SELECT host_id, structs.name, group_id, relid
    FROM public.data_tables
    JOIN public.structs USING (struct_id)
    WHERE structs.name IN ('_stats')
    ORDER BY 1,2,3
  LOOP
   
   EXECUTE 'DELETE FROM h' || host_var|| '.' || name_var || group_var || ' WHERE to_timestamp(timestamp) < CURRENT_DATE - '|| aging_days;
   GET DIAGNOSTICS rows = ROW_COUNT;
   all_rows := all_rows + rows;  
  
  --hb Not need to use trigger function public.datatab_set_width
  --EXECUTE 'UPDATE public.data_tables SET width = 0 WHERE relid = ' || relid_oid;

  END LOOP;
  
   curr_time := clock_timestamp()::TIMESTAMP;
 
RAISE NOTICE '%: stats_purge - % deleted rows ', curr_time,all_rows;  

END$_$;


ALTER FUNCTION purge.stats_purge(integer) OWNER TO ndbadm;
