--    (c) Copyright 2017, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Calculation possible aging days for purging processing 
-- Based on available disk free size (90%) and free space in netx DB related to full disk space
-- In case available disk space less than 'Purge','available_disk_space'(PARAM table) 20%  
-- ading period(366 day) decrease to 'Purge','days2delete' value( 30 day)
-- -- first version and average of 3 days with coefficient 1.5 netx DB size growing(according to purge.dbstate table)
--
-- Additonal updated table purge.dbstate for statistics about DB size changing
-- All values of size are in bytes
--
-- Return value max 366 days (1 year) min 15 days ; 
--
--    Comments:
--    "@(#)$Id$"



SET search_path=purge,pg_catalog;

-- get_aging_days
CREATE OR REPLACE FUNCTION get_aging_days(avail_disk_var bigint,full_disk_var bigint ) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    dbsize_var	BIGINT; 
    prev_dbsize_var	    BIGINT;
    free_dbsize_var     BIGINT;
    --aging_days_var      INTEGER :=366;
    growth_var	        BIGINT :=0;
	def_aging_days_var	INTEGER :=366;
    curr_aging_days_var	INTEGER :=366;
	avail_disk_space_pct INTEGER :=90;
	min_avail_disk_space_pct INTEGER :=20;
	days2delete_var     INTEGER :=30;
	
BEGIN 

-- Delete old record from dbstate (agging period 1 year(366 days))
 DELETE FROM purge.dbstate WHERE at < CURRENT_DATE - 366;   

-- Get data from PARAM table
 def_aging_days_var := public.get_int_param('Purge','history');
 curr_aging_days_var := public.get_int_param('Purge','current_history');
 min_avail_disk_space_pct := public.get_int_param('Purge','available_disk_space');
  
 SELECT INTO dbsize_var pg_database_size('netx');
 -- SELECT INTO free_dbsize_var sum(avail) from public.pg_fsm;
 SELECT INTO free_dbsize_var public.get_freespace();
 
 SELECT INTO prev_dbsize_var physize from purge.dbstate order by at desc limit 1;
 
 IF NOT FOUND THEN
   -- No records in dbstate table
   growth_var :=0; 
 ELSE
   -- prepare new growth db value
  growth_var := dbsize_var-prev_dbsize_var;
  IF growth_var < 0 THEN growth_var :=0; END IF;
   
 END IF;
    
 INSERT INTO purge.dbstate(at,used,growth,physize,uselimit) 
     VALUES (now(),(dbsize_var-free_dbsize_var),growth_var,dbsize_var,avail_disk_var);
 
 /* first version (15.1.10b01)
 -- get growth average for last 3 purging processing
 SELECT INTO growth_var CEILING(avg(growth))  
  FROM (select growth, at from purge.dbstate where growth > 0 order by at desc limit 3) t;

 IF growth_var is NOT NULL THEN
   -- prepare aging_days_var (if not found return default max aging_days_var 366)
   aging_days_var := CEILING((avail_disk_var + free_dbsize_var)/(growth_var*1.5));
   --RAISE NOTICE 'FOUND: aging_days_var - is %', aging_days_var;
   
   IF aging_days_var > 366 THEN aging_days_var :=366; END IF;
   IF aging_days_var < 8  THEN aging_days_var :=8 ; END IF; 
 
 END IF;
 */
 
  avail_disk_space_pct := CEILING(((avail_disk_var + free_dbsize_var)::float/full_disk_var::float)*100);
  RAISE NOTICE 'FOUND: avail_disk_space_pct - is %', avail_disk_space_pct;
  
  IF avail_disk_space_pct <= min_avail_disk_space_pct THEN
   -- requires adjustment for aging days value
   days2delete_var := public.get_int_param('Purge','days2delete');
   
   curr_aging_days_var := curr_aging_days_var - days2delete_var;
   IF curr_aging_days_var < 15 THEN curr_aging_days_var := 15; END IF;
   UPDATE public.PARAM set INT_VAL=curr_aging_days_var WHERE NAME='Purge' and SUBNAME='current_history';
  ELSE
   -- update current_history parameter to default value
   IF curr_aging_days_var <> def_aging_days_var THEN  
      UPDATE public.PARAM set INT_VAL=def_aging_days_var WHERE NAME='Purge' and SUBNAME='current_history';
	  curr_aging_days_var := def_aging_days_var;
   END IF;
  END IF;
 
  --RETURN aging_days_var;
  RETURN curr_aging_days_var;
  
 END$_$;


ALTER FUNCTION purge.get_aging_days(avail_disk_var bigint,full_disk_var bigint) OWNER TO ndbadm;
-----  
