--    (c) Copyright 2018, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Calculation available free disk space inside database
-- based on pg_freespace function from pg_freespacemap 
-- scans of the Postgres free space map (FSM)
-- and returns the total free space that the FSM knows about
--  
-- (Used instead of pg_fms_free.c (libpg_fsm_free.so) C-code and VIEW public.pg_fsm
-- 
-- Return value available space inside DB (bigint) ; 
--
--    Comments:
--    "@(#)$Id$"

SET search_path=public,pg_catalog;

CREATE OR REPLACE FUNCTION get_freespace() RETURNS bigint
    LANGUAGE plpgsql
    AS $_$
DECLARE
    db_object_name varchar(150); 
    obj_avail_var BIGINT := 0;
    full_avail_var BIGINT := 0;
    	
BEGIN    

  FOR db_object_name  IN 
     SELECT  N.nspname || '.' || C.relname db_object
           FROM pg_class C
            LEFT JOIN pg_namespace N ON (N.oid = C.relnamespace)
           WHERE (C.relkind = ANY (ARRAY['i'::"char", 'r'::"char", 't'::"char"])) 
     LOOP
 
     SELECT INTO obj_avail_var COALESCE(sum(avail),0) from pg_freespace(db_object_name);    
     full_avail_var := full_avail_var + obj_avail_var;

   END LOOP; 
   
   RETURN full_avail_var;
   
END$_$;      