--    (c) Copyright 2017, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Set of SP(functions) for return INT_VAL,STR_VAL or DATE_VAL field value 
--                            from PARAM table
--                            Input parameter - NAME , SUBNAME 
--    Include - 
--
--    Comments:
--    "@(#)$Id $"



SET search_path = public,pg_catalog;


CREATE OR REPLACE FUNCTION get_int_param(param_name varchar(32), param_subname varchar(32)) 
    RETURNS INTEGER 
    LANGUAGE plpgsql
    AS $_$
DECLARE
	ret_val     INTEGER; 
    
BEGIN  
    SELECT INTO ret_val INT_VAL FROM public.PARAM WHERE NAME = param_name AND SUBNAME = param_subname ;
	return ret_val;
END$_$;  

ALTER FUNCTION public.get_int_param(param_name varchar(32), param_subname varchar(32)) OWNER TO ndbadm;

CREATE OR REPLACE FUNCTION get_str_param(param_name varchar(32), param_subname varchar(32)) 
    RETURNS VARCHAR(4096) 
    LANGUAGE plpgsql
    AS $_$
DECLARE
	ret_val     VARCHAR(4096);  
    
BEGIN  
    SELECT INTO ret_val STR_VAL FROM public.PARAM WHERE NAME = param_name AND SUBNAME = param_subname ;
	return ret_val;
END$_$;  

ALTER FUNCTION public.get_str_param(param_name varchar(32), param_subname varchar(32)) OWNER TO ndbadm;

CREATE OR REPLACE FUNCTION get_datetime_param(param_name varchar(32), param_subname varchar(32)) 
    RETURNS timestamp with time zone 
    LANGUAGE plpgsql
    AS $_$
DECLARE
	ret_val     timestamp with time zone; -- 0 success 
    
BEGIN  
    SELECT INTO ret_val DATE_VAL FROM public.PARAM WHERE NAME = param_name AND SUBNAME = param_subname ;
	return ret_val;
END$_$;  

ALTER FUNCTION public.get_datetime_param(param_name varchar(32), param_subname varchar(32)) OWNER TO ndbadm;