--    (c) Copyright 2017, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Set of SP(functions) for jobs purging data - running from purge_process.sh/jobs_purge_process.sh
-- used to purge group/sensor(host)[regular or cluster]
-- Include - 
--
--    Comments:
--    "@(#)$Id$"



SET search_path=purge,pg_catalog;

-- jobs_purge
CREATE OR REPLACE FUNCTION jobs_purge() RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    jobid_var	INTEGER; 
    relname_var      TEXT;
    attname_var      TEXT;
    query_var      TEXT;  
    curr_time   TIMESTAMP;
    ret_val     INTEGER; -- 0 success 
    state_var   char;
    result_var  TEXT; 
BEGIN    

 FOR jobid_var,relname_var,attname_var,query_var  IN
    SELECT jobid,relname,attname,query
    FROM purge.jobs
    WHERE state='s'
    ORDER BY jobid
  LOOP
   
   RAISE NOTICE '%: jobs_purge - for % started', curr_time,query_var;
   UPDATE purge.jobs SET pid=pg_backend_pid() WHERE jobid=jobid_var;
   
   result_var := 'OK';
   state_var  := 'd';
   ret_val := -1;
    
   IF attname_var = 'group_id' THEN 
      ret_val := purge.group_purge(query_var); 
   ELSE
      ret_val := purge.host_purge(query_var);
   END IF;
      
   IF ret_val <> 0 THEN 
    result_var := 'Failed';   
    state_var  := 'E'; 
   END IF; 
   
   UPDATE purge.jobs SET state=state_var, pid=NULL, at=now(), result=result_var WHERE jobid=jobid_var;
      
   curr_time := clock_timestamp()::TIMESTAMP;
   RAISE NOTICE '%: jobs_purge - for % is %', curr_time,query_var,result_var;  

  END LOOP;
  
 END$_$;


ALTER FUNCTION purge.jobs_purge() OWNER TO ndbadm;
-----  

-- group_purge
CREATE OR REPLACE FUNCTION group_purge(query_var TEXT) RETURNS INTEGER
    LANGUAGE plpgsql
    AS $_$
DECLARE
    
    curr_time   TIMESTAMP;
    ret_val     INTEGER; -- 0 success 
    
BEGIN  
   EXECUTE 'CREATE TEMP TABLE _purge_tmp_6 WITHOUT OIDS ON COMMIT DROP AS ' || query_var;
   
   DELETE FROM public.group_mapping USING (SELECT group_id FROM _purge_tmp_6 ORDER BY group_id OFFSET 0 LIMIT 10000) AS work 
    WHERE (public.group_mapping.group_id) = (work.group_id) ;
    
   DELETE FROM public.group_config USING _purge_tmp_6 WHERE (public.group_config.group_id) = (_purge_tmp_6.group_id);
   
   CREATE TEMP TABLE _purge_tmp_7 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.registry.flood_id FROM flood.registry JOIN _purge_tmp_6 ON ((flood.registry.group_id) = (_purge_tmp_6.group_id));
    CREATE INDEX _purge_tmp_7_idx0 ON _purge_tmp_7(flood_id);
   
   CREATE TEMP TABLE _purge_tmp_8 WITHOUT OIDS ON COMMIT DROP AS
    SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
           FROM flood.samples JOIN _purge_tmp_7 ON ((flood.samples.flood_id) = (_purge_tmp_7.flood_id))  ;
    CREATE INDEX _purge_tmp_8_idx0 ON _purge_tmp_8(sample_id);
    CREATE INDEX _purge_tmp_8_idx1 ON _purge_tmp_8(report_id);
    CREATE INDEX _purge_tmp_8_idx2 ON _purge_tmp_8(top_hosts_id);
    CREATE INDEX _purge_tmp_8_idx3 ON _purge_tmp_8(alerts_id);
    DELETE FROM flood.samples USING _purge_tmp_7 WHERE (flood.samples.flood_id) = (_purge_tmp_7.flood_id);
    DROP TABLE _purge_tmp_8 ;
    DELETE FROM flood.registry USING (SELECT group_id FROM _purge_tmp_6 ORDER BY group_id OFFSET 0 LIMIT 10000) AS work 
     WHERE (flood.registry.group_id) = (work.group_id) ;
    DROP TABLE _purge_tmp_7;
    
    CREATE TEMP TABLE _purge_tmp_9 WITHOUT OIDS ON COMMIT DROP AS 
     SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id 
            FROM quarantine.captures JOIN _purge_tmp_6 ON ((quarantine.captures.group_id) = (_purge_tmp_6.group_id));
    CREATE INDEX _purge_tmp_9_idx0 ON _purge_tmp_9(capture_id);
    CREATE INDEX _purge_tmp_9_idx1 ON _purge_tmp_9(capture_id,addr);
    CREATE INDEX _purge_tmp_9_idx2 ON _purge_tmp_9(fast_id) ;
    
    CREATE TEMP TABLE _purge_tmp_10 WITHOUT OIDS ON COMMIT DROP AS
     SELECT quarantine.samples.sample_id 
      FROM quarantine.samples JOIN _purge_tmp_9 ON ((quarantine.samples.capture_id) = (_purge_tmp_9.capture_id));
    CREATE INDEX _purge_tmp_10_idx0 ON _purge_tmp_10(sample_id);
    DELETE FROM quarantine.samples USING _purge_tmp_9 WHERE (quarantine.samples.capture_id) = (_purge_tmp_9.capture_id);
    DROP TABLE _purge_tmp_10;
    
    CREATE TEMP TABLE _purge_tmp_11 WITHOUT OIDS ON COMMIT DROP AS 
     SELECT quarantine.samples.sample_id 
      FROM quarantine.samples JOIN _purge_tmp_9 
           ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_9.capture_id,_purge_tmp_9.addr));
    CREATE INDEX _purge_tmp_11_idx0 ON _purge_tmp_11(sample_id) ;
    
    DELETE FROM quarantine.samples USING _purge_tmp_9 
     WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_9.capture_id,_purge_tmp_9.addr) ;
    DROP TABLE _purge_tmp_11 ;
    
    DELETE FROM quarantine.captures USING (SELECT group_id FROM _purge_tmp_6 ORDER BY group_id OFFSET 0 LIMIT 10000) AS work 
     WHERE (quarantine.captures.group_id) = (work.group_id);
    DROP TABLE _purge_tmp_9 ;
    
    DELETE FROM quarantine.sources USING _purge_tmp_6 WHERE (quarantine.sources.group_id) = (_purge_tmp_6.group_id) ;
    DELETE FROM public.groups USING (SELECT group_id FROM _purge_tmp_6 ORDER BY group_id OFFSET 0 LIMIT 10000) AS work 
     WHERE (public.groups.group_id) = (work.group_id) ;     
     
    DROP TABLE _purge_tmp_6;    
   
   ret_val := 0;
   RETURN ret_val;

END$_$;  

ALTER FUNCTION purge.group_purge(query_var TEXT) OWNER TO ndbadm;
-------------

-- host_purge
CREATE OR REPLACE FUNCTION host_purge(query_var TEXT) RETURNS INTEGER
    LANGUAGE plpgsql
    AS $_$
DECLARE
    
    curr_time   TIMESTAMP;
    ret_val     INTEGER; -- 0 success 
    is_clust    BOOLEAN;
    query_host_var   TEXT; 
BEGIN  
   ret_val := -1;
   
   EXECUTE 'CREATE TEMP TABLE _purge_tmp_150 WITHOUT OIDS ON COMMIT DROP AS ' || query_var;
   SELECT public.hosts.is_cluster into is_clust 
     FROM public.hosts JOIN _purge_tmp_150 ON ((public.hosts.host_id) = (_purge_tmp_150.host_id));
     
   IF is_clust THEN
    -- first purge all hosts belogs to host_cluster
    FOR query_host_var IN
        SELECT 'SELECT ' || member_id || ' AS host_id' query_text 
        FROM public.sensor_clusters  
         JOIN _purge_tmp_150 ON ((public.sensor_clusters.cluster_id) = (_purge_tmp_150.host_id))
    LOOP
     
     ret_val := purge.host_regular_purge(query_host_var);
     
     IF ret_val <> 0 THEN 
      -- failed
      RETURN ret_val; 
     END IF;
     
     ret_val := -1;
    END LOOP;
    
    --now purge host_cluster
    ret_val := purge.host_cluster_purge(query_var); 
   ELSE
    ret_val := purge.host_regular_purge(query_var);
   END IF;  
   
   DROP TABLE _purge_tmp_150;
   
   RETURN ret_val;

END$_$;  

ALTER FUNCTION purge.host_purge(query_var TEXT) OWNER TO ndbadm;
-------------

-- host_regular_purge
CREATE OR REPLACE FUNCTION host_regular_purge(query_var TEXT) RETURNS INTEGER
    LANGUAGE plpgsql
    AS $_$
DECLARE
    
    curr_time   TIMESTAMP;
    ret_val     INTEGER; -- 0 success 
	sg_id_val   INTEGER;
BEGIN  

 EXECUTE 'CREATE TEMP TABLE _purge_tmp_1 WITHOUT OIDS ON COMMIT DROP AS ' || query_var;
 
 -- prepare sg_id_val for future mgt_ tables cleaning
 SELECT flood.mtg_map.sg_id into sg_id_val 
     FROM flood.mtg_map JOIN _purge_tmp_1 ON ((flood.mtg_map.host_id) = (_purge_tmp_1.host_id));
 
 DELETE FROM public.group_mapping USING (SELECT host_id FROM _purge_tmp_1 ORDER BY host_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (public.group_mapping.host_id) = (work.host_id) ;
  
 CREATE TEMP TABLE _purge_tmp_2 WITHOUT OIDS ON COMMIT DROP AS
   SELECT public.subsystems.subsystem_id FROM public.subsystems JOIN _purge_tmp_1 ON ((public.subsystems.host_id) = (_purge_tmp_1.host_id));
 CREATE INDEX _purge_tmp_2_idx0 ON _purge_tmp_2(subsystem_id) ;
 CREATE TEMP TABLE _purge_tmp_3 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.registry.flood_id FROM flood.registry JOIN _purge_tmp_2 ON ((flood.registry.subsystem_id) = (_purge_tmp_2.subsystem_id));
 CREATE INDEX _purge_tmp_3_idx0 ON _purge_tmp_3(flood_id) ;
 CREATE TEMP TABLE _purge_tmp_4 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
     FROM flood.samples JOIN _purge_tmp_3 ON ((flood.samples.flood_id) = (_purge_tmp_3.flood_id));
 CREATE INDEX _purge_tmp_4_idx0 ON _purge_tmp_4(sample_id) ;
 CREATE INDEX _purge_tmp_4_idx1 ON _purge_tmp_4(report_id) ;
 CREATE INDEX _purge_tmp_4_idx2 ON _purge_tmp_4(top_hosts_id) ;
 CREATE INDEX _purge_tmp_4_idx3 ON _purge_tmp_4(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_3 WHERE (flood.samples.flood_id) = (_purge_tmp_3.flood_id) ;
 DROP TABLE _purge_tmp_4 ;
 DELETE FROM flood.registry USING (SELECT subsystem_id FROM _purge_tmp_2 ORDER BY subsystem_id OFFSET 0 LIMIT 10000) AS work 
   WHERE (flood.registry.subsystem_id) = (work.subsystem_id); 
 DROP TABLE _purge_tmp_3 ;
 
 CREATE TEMP TABLE _purge_tmp_5 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id 
    FROM quarantine.captures JOIN _purge_tmp_2 ON ((quarantine.captures.subsystem_id) = (_purge_tmp_2.subsystem_id));
 CREATE INDEX _purge_tmp_5_idx0 ON _purge_tmp_5(capture_id); 
 CREATE INDEX _purge_tmp_5_idx1 ON _purge_tmp_5(capture_id,addr) ;
 CREATE INDEX _purge_tmp_5_idx2 ON _purge_tmp_5(fast_id) ;
 CREATE TEMP TABLE _purge_tmp_6 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_5 ON ((quarantine.samples.capture_id) = (_purge_tmp_5.capture_id));
 CREATE INDEX _purge_tmp_6_idx0 ON _purge_tmp_6(sample_id); 
 DELETE FROM quarantine.samples USING _purge_tmp_5 WHERE (quarantine.samples.capture_id) = (_purge_tmp_5.capture_id) ;
 DROP TABLE _purge_tmp_6 ;
 
 CREATE TEMP TABLE _purge_tmp_7 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_5 
    ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_5.capture_id,_purge_tmp_5.addr));
 CREATE INDEX _purge_tmp_7_idx0 ON _purge_tmp_7(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_5 WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_5.capture_id,_purge_tmp_5.addr); 
 DROP TABLE _purge_tmp_7 ;
 DELETE FROM quarantine.captures USING (SELECT subsystem_id 
  FROM _purge_tmp_2 ORDER BY subsystem_id OFFSET 0 LIMIT 10000) AS work WHERE (quarantine.captures.subsystem_id) = (work.subsystem_id) ;
 DROP TABLE _purge_tmp_5 ;
 DELETE FROM quarantine.sources USING _purge_tmp_2 WHERE (quarantine.sources.subsystem_id) = (_purge_tmp_2.subsystem_id) ;
 DELETE FROM public.subsystems USING (SELECT host_id FROM _purge_tmp_1 ORDER BY host_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (public.subsystems.host_id) = (work.host_id) ;
 DROP TABLE _purge_tmp_2;
 
 CREATE TEMP TABLE _purge_tmp_8 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.registry.flood_id FROM flood.registry JOIN _purge_tmp_1 ON ((flood.registry.host_id) = (_purge_tmp_1.host_id));
 CREATE INDEX _purge_tmp_8_idx0 ON _purge_tmp_8(flood_id) ;
 CREATE TEMP TABLE _purge_tmp_9 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_8 ON ((flood.samples.flood_id) = (_purge_tmp_8.flood_id));
 CREATE INDEX _purge_tmp_9_idx0 ON _purge_tmp_9(sample_id) ;
 CREATE INDEX _purge_tmp_9_idx1 ON _purge_tmp_9(report_id) ;
 CREATE INDEX _purge_tmp_9_idx2 ON _purge_tmp_9(top_hosts_id) ;
 CREATE INDEX _purge_tmp_9_idx3 ON _purge_tmp_9(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_8 WHERE (flood.samples.flood_id) = (_purge_tmp_8.flood_id) ;
 DROP TABLE _purge_tmp_9 ;
 
 -- delete from mtg_ tables
 PERFORM flood.mtg_lock() ;
 DELETE FROM flood.mtg_sg_state WHERE sg_id = sg_id_val;
 UPDATE flood.mtg_live SET state_id='REMO', state_details='', state_since=now() WHERE sg_id = sg_id_val;
 DELETE FROM flood.mtg_live WHERE sg_id = sg_id_val;
 DELETE FROM flood.mtg_reqs USING _purge_tmp_8 WHERE (flood.mtg_reqs.flood_id) = (_purge_tmp_8.flood_id) ;
 
 DELETE FROM flood.registry USING (SELECT host_id FROM _purge_tmp_1 ORDER BY host_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (flood.registry.host_id) = (work.host_id) ;
 DROP TABLE _purge_tmp_8 ;
 
 -- finish delete related to mtg_ tables
 DELETE FROM notify.targets WHERE target_id = sg_id_val;
 
 DELETE FROM public.sensor_clusters USING _purge_tmp_1 WHERE (public.sensor_clusters.cluster_id) = (_purge_tmp_1.host_id) ;
 DELETE FROM public.sensor_clusters USING _purge_tmp_1 WHERE (public.sensor_clusters.member_id) = (_purge_tmp_1.host_id) ;
 DELETE FROM public.hosts USING (SELECT host_id FROM _purge_tmp_1 ORDER BY host_id OFFSET 0 LIMIT 10000) AS work WHERE (public.hosts.host_id) = (work.host_id) ;
 
 DROP TABLE _purge_tmp_1;
 
 ret_val := 0;  
 return ret_val;

END$_$;  

ALTER FUNCTION purge.host_regular_purge(query_var TEXT) OWNER TO ndbadm;
-------------

-- host_cluster_purge
CREATE OR REPLACE FUNCTION host_cluster_purge(query_var TEXT) RETURNS INTEGER
    LANGUAGE plpgsql
    AS $_$
DECLARE
    
    curr_time   TIMESTAMP;
    ret_val     INTEGER; -- 0 success 
BEGIN  

EXECUTE 'CREATE TEMP TABLE _purge_tmp_1 WITHOUT OIDS ON COMMIT DROP AS ' || query_var;

DELETE FROM public.group_mapping USING (SELECT host_id FROM _purge_tmp_1 ORDER BY host_id OFFSET 0 LIMIT 10000) AS work 
 WHERE (public.group_mapping.host_id) = (work.host_id) ;
 CREATE TEMP TABLE _purge_tmp_2 WITHOUT OIDS ON COMMIT DROP AS
   SELECT public.subsystems.subsystem_id FROM public.subsystems JOIN _purge_tmp_1 ON ((public.subsystems.host_id) = (_purge_tmp_1.host_id));
 CREATE INDEX _purge_tmp_2_idx0 ON _purge_tmp_2(subsystem_id) ;
 
 CREATE TEMP TABLE _purge_tmp_3 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.registry.flood_id FROM flood.registry JOIN _purge_tmp_2 ON ((flood.registry.subsystem_id) = (_purge_tmp_2.subsystem_id));
 CREATE INDEX _purge_tmp_3_idx0 ON _purge_tmp_3(flood_id) ;
 
 CREATE TEMP TABLE _purge_tmp_4 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_3 ON ((flood.samples.flood_id) = (_purge_tmp_3.flood_id));
 CREATE INDEX _purge_tmp_4_idx0 ON _purge_tmp_4(sample_id) ;
 CREATE INDEX _purge_tmp_4_idx1 ON _purge_tmp_4(report_id) ;
 CREATE INDEX _purge_tmp_4_idx2 ON _purge_tmp_4(top_hosts_id); 
 CREATE INDEX _purge_tmp_4_idx3 ON _purge_tmp_4(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_3 WHERE (flood.samples.flood_id) = (_purge_tmp_3.flood_id) ;
 DELETE FROM fast.top_host_sets USING (SELECT sample_id FROM _purge_tmp_4 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.top_host_sets.entity_id) = (work.sample_id) ;
 CREATE TEMP TABLE _purge_tmp_5 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.sample_id) = (_purge_tmp_4.sample_id));
 CREATE INDEX _purge_tmp_5_idx0 ON _purge_tmp_5(sample_id) ;
 CREATE INDEX _purge_tmp_5_idx1 ON _purge_tmp_5(report_id) ;
 CREATE INDEX _purge_tmp_5_idx2 ON _purge_tmp_5(top_hosts_id) ;
 CREATE INDEX _purge_tmp_5_idx3 ON _purge_tmp_5(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.sample_id) = (_purge_tmp_4.sample_id); 
 DROP TABLE _purge_tmp_5 ;

 CREATE TEMP TABLE _purge_tmp_6 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.report_id) = (_purge_tmp_4.sample_id));
 CREATE INDEX _purge_tmp_6_idx0 ON _purge_tmp_6(sample_id); 
 CREATE INDEX _purge_tmp_6_idx1 ON _purge_tmp_6(report_id) ;
 CREATE INDEX _purge_tmp_6_idx2 ON _purge_tmp_6(top_hosts_id) ;
 CREATE INDEX _purge_tmp_6_idx3 ON _purge_tmp_6(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.report_id) = (_purge_tmp_4.sample_id) ;
 DROP TABLE _purge_tmp_6 ;
 
 CREATE TEMP TABLE _purge_tmp_7 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.top_hosts_id) = (_purge_tmp_4.sample_id));
 CREATE INDEX _purge_tmp_7_idx0 ON _purge_tmp_7(sample_id) ;
 CREATE INDEX _purge_tmp_7_idx1 ON _purge_tmp_7(report_id) ;
 CREATE INDEX _purge_tmp_7_idx2 ON _purge_tmp_7(top_hosts_id) ;
 CREATE INDEX _purge_tmp_7_idx3 ON _purge_tmp_7(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_4.sample_id) ;
 DROP TABLE _purge_tmp_7 ;
 
 CREATE TEMP TABLE _purge_tmp_8 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.alerts_id) = (_purge_tmp_4.sample_id));
 CREATE INDEX _purge_tmp_8_idx0 ON _purge_tmp_8(sample_id) ;
 CREATE INDEX _purge_tmp_8_idx1 ON _purge_tmp_8(report_id) ;
 CREATE INDEX _purge_tmp_8_idx2 ON _purge_tmp_8(top_hosts_id) ;
 CREATE INDEX _purge_tmp_8_idx3 ON _purge_tmp_8(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.alerts_id) = (_purge_tmp_4.sample_id) ;
 DROP TABLE _purge_tmp_8 ;
 
 CREATE TEMP TABLE _purge_tmp_9 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
     FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.entropy_id) = (_purge_tmp_4.sample_id));
 CREATE INDEX _purge_tmp_9_idx0 ON _purge_tmp_9(sample_id) ;
 CREATE INDEX _purge_tmp_9_idx1 ON _purge_tmp_9(report_id) ;
 CREATE INDEX _purge_tmp_9_idx2 ON _purge_tmp_9(top_hosts_id) ;
 CREATE INDEX _purge_tmp_9_idx3 ON _purge_tmp_9(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.entropy_id) = (_purge_tmp_4.sample_id) ;
 DROP TABLE _purge_tmp_9 ;
 
 CREATE TEMP TABLE _purge_tmp_10 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id 
    FROM quarantine.captures JOIN _purge_tmp_4 ON ((quarantine.captures.fast_id) = (_purge_tmp_4.sample_id));
 CREATE INDEX _purge_tmp_10_idx0 ON _purge_tmp_10(capture_id) ;
 CREATE INDEX _purge_tmp_10_idx1 ON _purge_tmp_10(capture_id,addr) ;
 CREATE INDEX _purge_tmp_10_idx2 ON _purge_tmp_10(fast_id) ;
 
 CREATE TEMP TABLE _purge_tmp_11 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_10 ON ((quarantine.samples.capture_id) = (_purge_tmp_10.capture_id));
 CREATE INDEX _purge_tmp_11_idx0 ON _purge_tmp_11(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_10 WHERE (quarantine.samples.capture_id) = (_purge_tmp_10.capture_id) ;
 DROP TABLE _purge_tmp_11 ;
 
 CREATE TEMP TABLE _purge_tmp_12 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_10 
     ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_10.capture_id,_purge_tmp_10.addr));
 CREATE INDEX _purge_tmp_12_idx0 ON _purge_tmp_12(sample_id); 
 DELETE FROM quarantine.samples USING _purge_tmp_10 
  WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_10.capture_id,_purge_tmp_10.addr); 
 DROP TABLE _purge_tmp_12 ;
 DELETE FROM quarantine.captures USING (SELECT sample_id FROM _purge_tmp_4 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (quarantine.captures.fast_id) = (work.sample_id) ;
 DROP TABLE _purge_tmp_10 ;
 
 CREATE TEMP TABLE _purge_tmp_13 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_4 ON ((quarantine.samples.sample_id) = (_purge_tmp_4.sample_id));
 CREATE INDEX _purge_tmp_13_idx0 ON _purge_tmp_13(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_4 WHERE (quarantine.samples.sample_id) = (_purge_tmp_4.sample_id) ;
 DROP TABLE _purge_tmp_13 ;
 
 DELETE FROM fast.entities USING (SELECT sample_id FROM _purge_tmp_4 ORDER BY sample_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.entities.entity_id) = (work.sample_id) ;
 DELETE FROM fast.top_host_sets USING (SELECT report_id FROM _purge_tmp_4 ORDER BY report_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.top_host_sets.entity_id) = (work.report_id) ;
  
 CREATE TEMP TABLE _purge_tmp_14 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
     FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.sample_id) = (_purge_tmp_4.report_id));
 CREATE INDEX _purge_tmp_14_idx0 ON _purge_tmp_14(sample_id) ;
 CREATE INDEX _purge_tmp_14_idx1 ON _purge_tmp_14(report_id) ;
 CREATE INDEX _purge_tmp_14_idx2 ON _purge_tmp_14(top_hosts_id); 
 CREATE INDEX _purge_tmp_14_idx3 ON _purge_tmp_14(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.sample_id) = (_purge_tmp_4.report_id); 
 DROP TABLE _purge_tmp_14 ;
 
 CREATE TEMP TABLE _purge_tmp_15 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.report_id) = (_purge_tmp_4.report_id));
 CREATE INDEX _purge_tmp_15_idx0 ON _purge_tmp_15(sample_id) ;
 CREATE INDEX _purge_tmp_15_idx1 ON _purge_tmp_15(report_id) ;
 CREATE INDEX _purge_tmp_15_idx2 ON _purge_tmp_15(top_hosts_id) ;
 CREATE INDEX _purge_tmp_15_idx3 ON _purge_tmp_15(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.report_id) = (_purge_tmp_4.report_id) ;
 DROP TABLE _purge_tmp_15 ;
 
 CREATE TEMP TABLE _purge_tmp_16 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.top_hosts_id) = (_purge_tmp_4.report_id));
 CREATE INDEX _purge_tmp_16_idx0 ON _purge_tmp_16(sample_id); 
 CREATE INDEX _purge_tmp_16_idx1 ON _purge_tmp_16(report_id) ;
 CREATE INDEX _purge_tmp_16_idx2 ON _purge_tmp_16(top_hosts_id) ;
 CREATE INDEX _purge_tmp_16_idx3 ON _purge_tmp_16(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_4.report_id) ;
 DROP TABLE _purge_tmp_16 ;
 
 CREATE TEMP TABLE _purge_tmp_17 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.alerts_id) = (_purge_tmp_4.report_id));
 CREATE INDEX _purge_tmp_17_idx0 ON _purge_tmp_17(sample_id) ;
 CREATE INDEX _purge_tmp_17_idx1 ON _purge_tmp_17(report_id) ;
 CREATE INDEX _purge_tmp_17_idx2 ON _purge_tmp_17(top_hosts_id) ;
 CREATE INDEX _purge_tmp_17_idx3 ON _purge_tmp_17(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.alerts_id) = (_purge_tmp_4.report_id) ;
 DROP TABLE _purge_tmp_17 ;
 
 CREATE TEMP TABLE _purge_tmp_18 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.entropy_id) = (_purge_tmp_4.report_id));
 CREATE INDEX _purge_tmp_18_idx0 ON _purge_tmp_18(sample_id) ;
 CREATE INDEX _purge_tmp_18_idx1 ON _purge_tmp_18(report_id) ;
 CREATE INDEX _purge_tmp_18_idx2 ON _purge_tmp_18(top_hosts_id) ;
 CREATE INDEX _purge_tmp_18_idx3 ON _purge_tmp_18(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.entropy_id) = (_purge_tmp_4.report_id) ;
 DROP TABLE _purge_tmp_18 ;
 
 CREATE TEMP TABLE _purge_tmp_19 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id 
    FROM quarantine.captures JOIN _purge_tmp_4 ON ((quarantine.captures.fast_id) = (_purge_tmp_4.report_id));
 CREATE INDEX _purge_tmp_19_idx0 ON _purge_tmp_19(capture_id) ;
 CREATE INDEX _purge_tmp_19_idx1 ON _purge_tmp_19(capture_id,addr) ;
 CREATE INDEX _purge_tmp_19_idx2 ON _purge_tmp_19(fast_id) ;
 CREATE TEMP TABLE _purge_tmp_20 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_19 ON ((quarantine.samples.capture_id) = (_purge_tmp_19.capture_id));
 CREATE INDEX _purge_tmp_20_idx0 ON _purge_tmp_20(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_19 WHERE (quarantine.samples.capture_id) = (_purge_tmp_19.capture_id) ;
 DROP TABLE _purge_tmp_20 ;
 
 CREATE TEMP TABLE _purge_tmp_21 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_19 
    ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_19.capture_id,_purge_tmp_19.addr));
 CREATE INDEX _purge_tmp_21_idx0 ON _purge_tmp_21(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_19 
  WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_19.capture_id,_purge_tmp_19.addr); 
 DROP TABLE _purge_tmp_21 ;
 DELETE FROM quarantine.captures USING (SELECT report_id FROM _purge_tmp_4 ORDER BY report_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (quarantine.captures.fast_id) = (work.report_id) ;
 DROP TABLE _purge_tmp_19 ;
 
 CREATE TEMP TABLE _purge_tmp_22 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_4 ON ((quarantine.samples.sample_id) = (_purge_tmp_4.report_id));
 CREATE INDEX _purge_tmp_22_idx0 ON _purge_tmp_22(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_4 WHERE (quarantine.samples.sample_id) = (_purge_tmp_4.report_id) ;
 DROP TABLE _purge_tmp_22 ;
 DELETE FROM fast.entities USING (SELECT report_id FROM _purge_tmp_4 ORDER BY report_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.entities.entity_id) = (work.report_id) ;
 DELETE FROM fast.top_host_sets USING (SELECT top_hosts_id FROM _purge_tmp_4 ORDER BY top_hosts_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.top_host_sets.entity_id) = (work.top_hosts_id) ;
 CREATE TEMP TABLE _purge_tmp_23 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.sample_id) = (_purge_tmp_4.top_hosts_id));
 CREATE INDEX _purge_tmp_23_idx0 ON _purge_tmp_23(sample_id) ;
 CREATE INDEX _purge_tmp_23_idx1 ON _purge_tmp_23(report_id) ;
 CREATE INDEX _purge_tmp_23_idx2 ON _purge_tmp_23(top_hosts_id) ;
 CREATE INDEX _purge_tmp_23_idx3 ON _purge_tmp_23(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.sample_id) = (_purge_tmp_4.top_hosts_id) ;
 DROP TABLE _purge_tmp_23 ;
 CREATE TEMP TABLE _purge_tmp_24 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.report_id) = (_purge_tmp_4.top_hosts_id));
 CREATE INDEX _purge_tmp_24_idx0 ON _purge_tmp_24(sample_id) ;
 CREATE INDEX _purge_tmp_24_idx1 ON _purge_tmp_24(report_id) ;
 CREATE INDEX _purge_tmp_24_idx2 ON _purge_tmp_24(top_hosts_id) ;
 CREATE INDEX _purge_tmp_24_idx3 ON _purge_tmp_24(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.report_id) = (_purge_tmp_4.top_hosts_id) ;
 DROP TABLE _purge_tmp_24 ;
 CREATE TEMP TABLE _purge_tmp_25 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.top_hosts_id) = (_purge_tmp_4.top_hosts_id));
 CREATE INDEX _purge_tmp_25_idx0 ON _purge_tmp_25(sample_id) ;
 CREATE INDEX _purge_tmp_25_idx1 ON _purge_tmp_25(report_id) ;
 CREATE INDEX _purge_tmp_25_idx2 ON _purge_tmp_25(top_hosts_id); 
 CREATE INDEX _purge_tmp_25_idx3 ON _purge_tmp_25(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_4.top_hosts_id) ;
 DROP TABLE _purge_tmp_25 ;
 
 CREATE TEMP TABLE _purge_tmp_26 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.alerts_id) = (_purge_tmp_4.top_hosts_id));
 CREATE INDEX _purge_tmp_26_idx0 ON _purge_tmp_26(sample_id) ;
 CREATE INDEX _purge_tmp_26_idx1 ON _purge_tmp_26(report_id) ;
 CREATE INDEX _purge_tmp_26_idx2 ON _purge_tmp_26(top_hosts_id) ;
 CREATE INDEX _purge_tmp_26_idx3 ON _purge_tmp_26(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.alerts_id) = (_purge_tmp_4.top_hosts_id) ;
 DROP TABLE _purge_tmp_26 ;
 
 CREATE TEMP TABLE _purge_tmp_27 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.entropy_id) = (_purge_tmp_4.top_hosts_id));
 CREATE INDEX _purge_tmp_27_idx0 ON _purge_tmp_27(sample_id) ;
 CREATE INDEX _purge_tmp_27_idx1 ON _purge_tmp_27(report_id) ;
 CREATE INDEX _purge_tmp_27_idx2 ON _purge_tmp_27(top_hosts_id) ;
 CREATE INDEX _purge_tmp_27_idx3 ON _purge_tmp_27(alerts_id); 
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.entropy_id) = (_purge_tmp_4.top_hosts_id) ;
 DROP TABLE _purge_tmp_27 ;
 
 CREATE TEMP TABLE _purge_tmp_28 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id 
    FROM quarantine.captures JOIN _purge_tmp_4 ON ((quarantine.captures.fast_id) = (_purge_tmp_4.top_hosts_id));
 CREATE INDEX _purge_tmp_28_idx0 ON _purge_tmp_28(capture_id) ;
 CREATE INDEX _purge_tmp_28_idx1 ON _purge_tmp_28(capture_id,addr) ;
 CREATE INDEX _purge_tmp_28_idx2 ON _purge_tmp_28(fast_id) ;
 CREATE TEMP TABLE _purge_tmp_29 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_28 ON ((quarantine.samples.capture_id) = (_purge_tmp_28.capture_id));
 CREATE INDEX _purge_tmp_29_idx0 ON _purge_tmp_29(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_28 WHERE (quarantine.samples.capture_id) = (_purge_tmp_28.capture_id) ;
 DROP TABLE _purge_tmp_29 ;
 
 CREATE TEMP TABLE _purge_tmp_30 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_28 
    ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_28.capture_id,_purge_tmp_28.addr));
 CREATE INDEX _purge_tmp_30_idx0 ON _purge_tmp_30(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_28 
  WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_28.capture_id,_purge_tmp_28.addr) ;
 DROP TABLE _purge_tmp_30 ;
 DELETE FROM quarantine.captures USING (SELECT top_hosts_id FROM _purge_tmp_4 ORDER BY top_hosts_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (quarantine.captures.fast_id) = (work.top_hosts_id) ;
 DROP TABLE _purge_tmp_28 ;
 
 CREATE TEMP TABLE _purge_tmp_31 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_4
    ON ((quarantine.samples.sample_id) = (_purge_tmp_4.top_hosts_id));
 CREATE INDEX _purge_tmp_31_idx0 ON _purge_tmp_31(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_4 WHERE (quarantine.samples.sample_id) = (_purge_tmp_4.top_hosts_id) ;
 DROP TABLE _purge_tmp_31 ;
 
 DELETE FROM fast.entities USING (SELECT top_hosts_id FROM _purge_tmp_4 ORDER BY top_hosts_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.entities.entity_id) = (work.top_hosts_id); 
 DELETE FROM fast.top_host_sets USING (SELECT alerts_id FROM _purge_tmp_4 ORDER BY alerts_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.top_host_sets.entity_id) = (work.alerts_id); 
  
 CREATE TEMP TABLE _purge_tmp_32 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.sample_id) = (_purge_tmp_4.alerts_id));
 CREATE INDEX _purge_tmp_32_idx0 ON _purge_tmp_32(sample_id) ;
 CREATE INDEX _purge_tmp_32_idx1 ON _purge_tmp_32(report_id) ;
 CREATE INDEX _purge_tmp_32_idx2 ON _purge_tmp_32(top_hosts_id) ;
 CREATE INDEX _purge_tmp_32_idx3 ON _purge_tmp_32(alerts_id); 
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.sample_id) = (_purge_tmp_4.alerts_id) ;
 DROP TABLE _purge_tmp_32 ;
 
 CREATE TEMP TABLE _purge_tmp_33 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.report_id) = (_purge_tmp_4.alerts_id));
 CREATE INDEX _purge_tmp_33_idx0 ON _purge_tmp_33(sample_id) ;
 CREATE INDEX _purge_tmp_33_idx1 ON _purge_tmp_33(report_id) ;
 CREATE INDEX _purge_tmp_33_idx2 ON _purge_tmp_33(top_hosts_id) ;
 CREATE INDEX _purge_tmp_33_idx3 ON _purge_tmp_33(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.report_id) = (_purge_tmp_4.alerts_id) ;
 DROP TABLE _purge_tmp_33 ;
 
 CREATE TEMP TABLE _purge_tmp_34 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.top_hosts_id) = (_purge_tmp_4.alerts_id));
 CREATE INDEX _purge_tmp_34_idx0 ON _purge_tmp_34(sample_id) ;
 CREATE INDEX _purge_tmp_34_idx1 ON _purge_tmp_34(report_id) ;
 CREATE INDEX _purge_tmp_34_idx2 ON _purge_tmp_34(top_hosts_id) ;
 CREATE INDEX _purge_tmp_34_idx3 ON _purge_tmp_34(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.top_hosts_id) = (_purge_tmp_4.alerts_id) ;
 DROP TABLE _purge_tmp_34 ;
 
 CREATE TEMP TABLE _purge_tmp_35 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.alerts_id) = (_purge_tmp_4.alerts_id));
 CREATE INDEX _purge_tmp_35_idx0 ON _purge_tmp_35(sample_id) ;
 CREATE INDEX _purge_tmp_35_idx1 ON _purge_tmp_35(report_id) ;
 CREATE INDEX _purge_tmp_35_idx2 ON _purge_tmp_35(top_hosts_id) ;
 CREATE INDEX _purge_tmp_35_idx3 ON _purge_tmp_35(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.alerts_id) = (_purge_tmp_4.alerts_id) ;
 DROP TABLE _purge_tmp_35 ;
 CREATE TEMP TABLE _purge_tmp_36 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_4 ON ((flood.samples.entropy_id) = (_purge_tmp_4.alerts_id));
 CREATE INDEX _purge_tmp_36_idx0 ON _purge_tmp_36(sample_id) ;
 CREATE INDEX _purge_tmp_36_idx1 ON _purge_tmp_36(report_id) ;
 CREATE INDEX _purge_tmp_36_idx2 ON _purge_tmp_36(top_hosts_id) ;
 CREATE INDEX _purge_tmp_36_idx3 ON _purge_tmp_36(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_4 WHERE (flood.samples.entropy_id) = (_purge_tmp_4.alerts_id) ;
 DROP TABLE _purge_tmp_36 ;
 
 CREATE TEMP TABLE _purge_tmp_37 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id
    FROM quarantine.captures JOIN _purge_tmp_4 ON ((quarantine.captures.fast_id) = (_purge_tmp_4.alerts_id));
 CREATE INDEX _purge_tmp_37_idx0 ON _purge_tmp_37(capture_id) ;
 CREATE INDEX _purge_tmp_37_idx1 ON _purge_tmp_37(capture_id,addr) ;
 CREATE INDEX _purge_tmp_37_idx2 ON _purge_tmp_37(fast_id) ;
 CREATE TEMP TABLE _purge_tmp_38 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_37 ON ((quarantine.samples.capture_id) = (_purge_tmp_37.capture_id));
 CREATE INDEX _purge_tmp_38_idx0 ON _purge_tmp_38(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_37 WHERE (quarantine.samples.capture_id) = (_purge_tmp_37.capture_id) ;
 DROP TABLE _purge_tmp_38 ;
 
 CREATE TEMP TABLE _purge_tmp_39 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_37 
    ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_37.capture_id,_purge_tmp_37.addr));
 CREATE INDEX _purge_tmp_39_idx0 ON _purge_tmp_39(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_37 
  WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_37.capture_id,_purge_tmp_37.addr) ;
 DROP TABLE _purge_tmp_39 ;
 
 DELETE FROM quarantine.captures USING (SELECT alerts_id FROM _purge_tmp_4 ORDER BY alerts_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (quarantine.captures.fast_id) = (work.alerts_id) ;
 DROP TABLE _purge_tmp_37 ;
 
 CREATE TEMP TABLE _purge_tmp_40 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_4 ON ((quarantine.samples.sample_id) = (_purge_tmp_4.alerts_id));
 CREATE INDEX _purge_tmp_40_idx0 ON _purge_tmp_40(sample_id); 
 DELETE FROM quarantine.samples USING _purge_tmp_4 WHERE (quarantine.samples.sample_id) = (_purge_tmp_4.alerts_id) ;
 DROP TABLE _purge_tmp_40 ;
 
 DELETE FROM fast.entities USING (SELECT alerts_id FROM _purge_tmp_4 ORDER BY alerts_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (fast.entities.entity_id) = (work.alerts_id) ;
 DROP TABLE _purge_tmp_4 ;
 DELETE FROM flood.registry USING (SELECT subsystem_id FROM _purge_tmp_2 ORDER BY subsystem_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (flood.registry.subsystem_id) = (work.subsystem_id) ;
 DROP TABLE _purge_tmp_3 ;
 
 CREATE TEMP TABLE _purge_tmp_41 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.captures.capture_id,quarantine.captures.addr,quarantine.captures.fast_id 
    FROM quarantine.captures JOIN _purge_tmp_2 ON ((quarantine.captures.subsystem_id) = (_purge_tmp_2.subsystem_id));
 CREATE INDEX _purge_tmp_41_idx0 ON _purge_tmp_41(capture_id) ;
 CREATE INDEX _purge_tmp_41_idx1 ON _purge_tmp_41(capture_id,addr) ;
 CREATE INDEX _purge_tmp_41_idx2 ON _purge_tmp_41(fast_id) ;
 CREATE TEMP TABLE _purge_tmp_42 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_41
    ON ((quarantine.samples.capture_id) = (_purge_tmp_41.capture_id));
 CREATE INDEX _purge_tmp_42_idx0 ON _purge_tmp_42(sample_id) ;
 DELETE FROM quarantine.samples USING _purge_tmp_41 WHERE (quarantine.samples.capture_id) = (_purge_tmp_41.capture_id) ;
 DROP TABLE _purge_tmp_42 ;
 
 CREATE TEMP TABLE _purge_tmp_43 WITHOUT OIDS ON COMMIT DROP AS
   SELECT quarantine.samples.sample_id FROM quarantine.samples JOIN _purge_tmp_41
    ON ((quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_41.capture_id,_purge_tmp_41.addr));
 CREATE INDEX _purge_tmp_43_idx0 ON _purge_tmp_43(sample_id); 
 DELETE FROM quarantine.samples USING _purge_tmp_41 
  WHERE (quarantine.samples.capture_id,quarantine.samples.addr) = (_purge_tmp_41.capture_id,_purge_tmp_41.addr) ;
 DROP TABLE _purge_tmp_43 ;
 
 DELETE FROM quarantine.captures USING (SELECT subsystem_id FROM _purge_tmp_2 ORDER BY subsystem_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (quarantine.captures.subsystem_id) = (work.subsystem_id) ;
 DROP TABLE _purge_tmp_41 ;
 DELETE FROM quarantine.sources USING _purge_tmp_2 WHERE (quarantine.sources.subsystem_id) = (_purge_tmp_2.subsystem_id) ;
 DELETE FROM public.subsystems USING (SELECT host_id FROM _purge_tmp_1  ORDER BY host_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (public.subsystems.host_id) = (work.host_id) ;
 DROP TABLE _purge_tmp_2;
 
 CREATE TEMP TABLE _purge_tmp_44 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.registry.flood_id FROM flood.registry JOIN _purge_tmp_1 ON ((flood.registry.host_id) = (_purge_tmp_1.host_id));
 CREATE INDEX _purge_tmp_44_idx0 ON _purge_tmp_44(flood_id) ;
 CREATE TEMP TABLE _purge_tmp_45 WITHOUT OIDS ON COMMIT DROP AS
   SELECT flood.samples.sample_id,flood.samples.report_id,flood.samples.top_hosts_id,flood.samples.alerts_id 
    FROM flood.samples JOIN _purge_tmp_44 ON ((flood.samples.flood_id) = (_purge_tmp_44.flood_id));
 CREATE INDEX _purge_tmp_45_idx0 ON _purge_tmp_45(sample_id) ;
 CREATE INDEX _purge_tmp_45_idx1 ON _purge_tmp_45(report_id) ;
 CREATE INDEX _purge_tmp_45_idx2 ON _purge_tmp_45(top_hosts_id) ;
 CREATE INDEX _purge_tmp_45_idx3 ON _purge_tmp_45(alerts_id) ;
 DELETE FROM flood.samples USING _purge_tmp_44 WHERE (flood.samples.flood_id) = (_purge_tmp_44.flood_id) ;
 DROP TABLE _purge_tmp_45 ;
 DELETE FROM flood.registry USING (SELECT host_id FROM _purge_tmp_1 ORDER BY host_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (flood.registry.host_id) = (work.host_id) ;
 DROP TABLE _purge_tmp_44 ;
 DELETE FROM public.sensor_clusters USING _purge_tmp_1 WHERE (public.sensor_clusters.cluster_id) = (_purge_tmp_1.host_id) ;
 DELETE FROM public.sensor_clusters USING _purge_tmp_1 WHERE (public.sensor_clusters.member_id) = (_purge_tmp_1.host_id) ;
 DELETE FROM public.hosts USING (SELECT host_id FROM _purge_tmp_1 ORDER BY host_id OFFSET 0 LIMIT 10000) AS work 
  WHERE (public.hosts.host_id) = (work.host_id) ;
  
 DROP TABLE _purge_tmp_1; 
 
  ret_val := 0;  
  return ret_val;

END$_$;  

ALTER FUNCTION purge.host_cluster_purge(query_var TEXT) OWNER TO ndbadm;
-------------


