--
-- PostgreSQL database cluster dump
--

\connect postgres

SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET escape_string_warning = off;

--
-- Roles
--
CREATE ROLE cluster;
ALTER ROLE cluster WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN;
CREATE ROLE ndb_readers;
ALTER ROLE ndb_readers WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB NOLOGIN;
CREATE ROLE ndb_writers;
ALTER ROLE ndb_writers WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB NOLOGIN;
CREATE ROLE ndbadm;
ALTER ROLE ndbadm WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN;
--CREATE ROLE postgres;
ALTER ROLE postgres WITH SUPERUSER INHERIT CREATEROLE CREATEDB LOGIN ENCRYPTED PASSWORD 'md58a966399260ef37422c3843b69cab088';
CREATE ROLE nms;
ALTER ROLE nms WITH SUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN ENCRYPTED PASSWORD 'md5f31e2f42c9128f09f9e64f34c7693431';

--
-- Role memberships
--
GRANT ndb_writers TO cluster GRANTED BY postgres;
GRANT ndb_writers TO ndbadm GRANTED BY postgres;
GRANT ndb_readers TO nms GRANTED BY postgres;
GRANT ndb_writers TO nms GRANTED BY postgres;
GRANT ndbadm TO nms GRANTED BY postgres;


--
-- Tablespaces
--

CREATE TABLESPACE netx OWNER postgres LOCATION '/opt/shared/PostgreSQL/spc_data/pgnetx'; 

--
-- Database creation
--

CREATE DATABASE netx WITH TEMPLATE = template0 OWNER = postgres TABLESPACE = netx;
REVOKE ALL ON DATABASE netx FROM PUBLIC;
REVOKE ALL ON DATABASE netx FROM postgres;
GRANT ALL ON DATABASE netx TO postgres;
GRANT ALL ON DATABASE netx TO ndb_writers;
GRANT CONNECT,TEMPORARY ON DATABASE netx TO ndb_readers;
REVOKE ALL ON DATABASE template1 FROM PUBLIC;
REVOKE ALL ON DATABASE template1 FROM postgres;
GRANT ALL ON DATABASE template1 TO postgres;
GRANT CONNECT ON DATABASE template1 TO PUBLIC;


\connect netx

--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: auth; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA auth;


ALTER SCHEMA auth OWNER TO postgres;

--
-- Name: fast; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA fast;


ALTER SCHEMA fast OWNER TO ndbadm;

--
-- Name: SCHEMA fast; Type: COMMENT; Schema: -; Owner: ndbadm
--

COMMENT ON SCHEMA fast IS 'Data related to FAST (Traffic Sampling and Analysis Facility)';


--
-- Name: fgen; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA fgen;


ALTER SCHEMA fgen OWNER TO ndbadm;

--
-- Name: flood; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA flood;


ALTER SCHEMA flood OWNER TO ndbadm;

--
-- Name: SCHEMA flood; Type: COMMENT; Schema: -; Owner: ndbadm
--

COMMENT ON SCHEMA flood IS 'Data related to detected flood-like anomalies';


--
-- Name: h1; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA h1;


ALTER SCHEMA h1 OWNER TO ndbadm;

--
-- Name: notify; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA notify;


ALTER SCHEMA notify OWNER TO ndbadm;

--
-- Name: nx; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA nx;


ALTER SCHEMA nx OWNER TO ndbadm;

--
-- Name: purge; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA purge;


ALTER SCHEMA purge OWNER TO ndbadm;

--
-- Name: quarantine; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA quarantine;


ALTER SCHEMA quarantine OWNER TO ndbadm;

--
-- Name: report; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA report;


ALTER SCHEMA report OWNER TO ndbadm;

--
-- Name: smp; Type: SCHEMA; Schema: -; Owner: ndbadm
--

CREATE SCHEMA smp;


ALTER SCHEMA smp OWNER TO ndbadm;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE OR REPLACE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = public, pg_catalog;

--
-- Name: plruby_call_handler(); Type: FUNCTION; Schema: public; Owner: postgres
--
/*
CREATE OR REPLACE FUNCTION plruby_call_handler()
  RETURNS language_handler AS
--'/usr/lib64/ruby/site_ruby/1.8/x86_64-linux/plruby', 'plruby_call_handler'  --hb
  '/opt/allot/lib/plruby', 'plruby_call_handler'  --hb 
  LANGUAGE c volatile;


ALTER FUNCTION public.plruby_call_handler() OWNER TO postgres;

--
-- Name: plruby; Type: PROCEDURAL LANGUAGE; Schema: public; Owner: postgres
--

CREATE TRUSTED PROCEDURAL LANGUAGE plruby HANDLER plruby_call_handler;


ALTER PROCEDURAL LANGUAGE plruby OWNER TO postgres;
*/

SET search_path = flood, pg_catalog;

--
-- Name: action_source_type; Type: DOMAIN; Schema: flood; Owner: ndbadm
--

CREATE DOMAIN action_source_type AS text
	CONSTRAINT action_source_type_check CHECK ((VALUE = ANY (ARRAY['MANUAL'::text, 'POLICY'::text, 'TIMER'::text])));


ALTER DOMAIN flood.action_source_type OWNER TO ndbadm;

--
-- Name: DOMAIN action_source_type; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON DOMAIN action_source_type IS 'Allowed peer state type (manual/ policy / timer)';


--
-- Name: event_types; Type: DOMAIN; Schema: flood; Owner: ndbadm
--

CREATE DOMAIN event_types AS text DEFAULT 'TRIGGER'::text
	CONSTRAINT event_types_check CHECK ((VALUE = ANY (ARRAY['TRIGGER'::text, 'WITHDRAW'::text, 'WITHDRAW_ALL'::text,
                                        'WITHDRAW_HOSTS'::text, 'WITHDRAW_SUBNETS'::text])));


ALTER DOMAIN flood.event_types OWNER TO ndbadm;

--
-- Name: DOMAIN event_types; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON DOMAIN event_types IS 'Allowed values - (TRIGGER / WITHDRAW / WITHDRAW_ALL / WITHDRAW_HOSTS / WITHDRAW_SUBNETS)';


--
-- Name: mtg_req_action; Type: DOMAIN; Schema: flood; Owner: ndbadm
--

CREATE DOMAIN mtg_req_action AS text DEFAULT 'BLOCK'::text
	CONSTRAINT full_action CHECK ((VALUE = ANY (ARRAY[
	'BLOCK'::text,
	'BLOCK-TOP-HOSTS-TX'::text,
	'BLOCK-TOP-HOSTS-RX'::text,
	'BLOCK-TOP-HOSTS-TXRX'::text,
	'BLOCK-TARGET'::text, 
	'BLOCK-TARGET-PROTOCOL'::text,
	'NONE'::text])));


ALTER DOMAIN flood.mtg_req_action OWNER TO ndbadm;

--
-- Name: DOMAIN mtg_req_action; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON DOMAIN mtg_req_action IS 'Allowed NBAD mitigation actions';


--
-- Name: pattern_quality_state; Type: TYPE; Schema: flood; Owner: ndbadm
--

CREATE TYPE pattern_quality_state AS (
	count integer,
	sum double precision
);


ALTER TYPE flood.pattern_quality_state OWNER TO ndbadm;

--
-- Name: TYPE pattern_quality_state; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TYPE pattern_quality_state IS '(int) Used by flood.pattern_quality aggregate';


--
-- Name: peer_state_type; Type: DOMAIN; Schema: flood; Owner: ndbadm
--

CREATE DOMAIN peer_state_type AS text DEFAULT 'UP'::text
	CONSTRAINT peer_state_type_check CHECK ((VALUE = ANY (ARRAY['ADD'::text, 'REMOVE'::text, 'UP'::text, 'DOWN'::text])));


ALTER DOMAIN flood.peer_state_type OWNER TO ndbadm;

--
-- Name: DOMAIN peer_state_type; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON DOMAIN peer_state_type IS 'Allowed peer state type ("add" / "remove" / "changed status from X to Y", when X,Y is "up" or "down")';


--
-- Name: status_type; Type: DOMAIN; Schema: flood; Owner: ndbadm
--

CREATE DOMAIN status_type AS text DEFAULT 'DOWN'::text
	CONSTRAINT status_type_check CHECK ((VALUE = ANY (ARRAY['DOWN'::text, 'UP'::text, 'ADD'::text, 'REMOVE'::text])));


ALTER DOMAIN flood.status_type OWNER TO ndbadm;

--
-- Name: DOMAIN status_type; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON DOMAIN status_type IS 'Allowed status: DOWN, UP, ADD or REMOVE';


--
-- Name: triggers_type; Type: DOMAIN; Schema: flood; Owner: ndbadm
--

CREATE DOMAIN triggers_type AS text
	CONSTRAINT triggers_type_check CHECK ((VALUE = ANY (ARRAY['HOST'::text, 'SUBNET'::text, 'ALL'::text])));


ALTER DOMAIN flood.triggers_type OWNER TO ndbadm;

--
-- Name: DOMAIN triggers_type; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON DOMAIN triggers_type IS 'Allowed triggers type: HOST or SUBNET';


SET search_path = public, pg_catalog;

--
-- Name: coverage_state; Type: TYPE; Schema: public; Owner: ndbadm
--

CREATE TYPE coverage_state AS (
	till double precision,
	covered double precision
);


ALTER TYPE public.coverage_state OWNER TO ndbadm;

--
-- Name: TYPE coverage_state; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON TYPE coverage_state IS '(int) Used in public.coverage aggregate';


--
-- Name: grpcfg_search_result; Type: TYPE; Schema: public; Owner: ndbadm
--

CREATE TYPE grpcfg_search_result AS (
	at timestamp with time zone,
	prefix cidr,
	group_id integer,
	"from" timestamp with time zone,
	"to" timestamp with time zone,
	descr text
);


ALTER TYPE public.grpcfg_search_result OWNER TO ndbadm;

--
-- Name: item_name; Type: DOMAIN; Schema: public; Owner: ndbadm
--

CREATE DOMAIN item_name AS text NOT NULL
	CONSTRAINT no_spaces CHECK ((VALUE !~* '\\s'::text));


ALTER DOMAIN public.item_name OWNER TO ndbadm;

--
-- Name: DOMAIN item_name; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON DOMAIN item_name IS 'Used for unique short name columns in all registries';


--
-- Name: protoent; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE protoent AS (
	id integer,
	name text
);


ALTER TYPE public.protoent OWNER TO postgres;

--
-- Name: TYPE protoent; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TYPE protoent IS 'Type consists of protocol id, protocol name.';

SET search_path = fast, pg_catalog;

--
-- Name: attr_type_id(public.item_name); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION attr_type_id(typename public.item_name) RETURNS integer
    LANGUAGE plpgsql STABLE
    AS $$
DECLARE
  attrTypeId	fast.attr_types.attr_type_id%TYPE;

BEGIN
  SELECT INTO attrTypeId attr_type_id
    FROM fast.attr_types
   WHERE name = typeName;

  IF NOT FOUND THEN
    RAISE EXCEPTION '%: no such FAST document attribute type', typeName;
  END IF;

  RETURN attrTypeId;
END$$;


ALTER FUNCTION fast.attr_type_id(typename public.item_name) OWNER TO ndbadm;

--
-- Name: FUNCTION attr_type_id(typename public.item_name); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION attr_type_id(typename public.item_name) IS 'Finds or adds a FAST document attribute type identifier by name (typeName)';


--
-- Name: attr_type_id__register(public.item_name); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION attr_type_id__register(typename public.item_name) RETURNS integer
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
DECLARE
  attrTypeId	fast.attr_types.attr_type_id%TYPE;

BEGIN
  SELECT INTO attrTypeId attr_type_id
    FROM fast.attr_types
   WHERE name = typeName;

  IF FOUND THEN RETURN attrTypeId; END IF;

  INSERT INTO fast.attr_types(name) VALUES(typeName);
  RETURN currval(pg_get_serial_sequence('fast.attr_types', 'attr_type_id'));
END$$;


ALTER FUNCTION fast.attr_type_id__register(typename public.item_name) OWNER TO ndbadm;

--
-- Name: attrs(integer[], text[]); Type: FUNCTION; Schema: fast; Owner: ndbadm
--
/* not in use Oren H & HB (remove later)
CREATE FUNCTION attrs(entity_ids integer[], attr_types text[]) RETURNS SETOF record
    LANGUAGE plruby STABLE STRICT
    AS $_$
return if entity_ids.empty? || attr_types.empty?

# Convert attribute type names to their identifiers.
attr_type_map = {}
plan(:fast__attrs_1) {[
  'SELECT attr_type_id, name FROM fast.attr_types WHERE name = ANY($1)',
  ["_text"], nil, "value"]}.
exec([attr_types]) { |id, name| attr_type_map[name] = id }
attr_types = attr_type_map.values_at *attr_types

# Fetch all attributes of requested types for the requested entities.  Make sure
# at least line with NULLs except the entity_id is returned for those entities
# that have NO attributes of requested types stored at all (that's what
# ON() condition is for).
currID = nil
currAttrs = {}
plan(:fast__attrs_2) {[
    'SELECT e.entity_id, a.attr_type_id, a.value
       FROM fast.entities   e
  LEFT JOIN fast.attrs      a
         ON (a.entity_id = e.entity_id AND a.attr_type_id = ANY($2))
      WHERE e.entity_id = ANY($1)
   ORDER BY e.entity_id',
  ["_int4", "_int4"], nil, "value"]}.
exec([entity_ids, attr_types]).each { |id, attr, value|
  if id != currID
    yield currID, *currAttrs.values_at(*attr_types) if currID
    currID = id
    currAttrs.clear
  end

  currAttrs[attr] = value if attr
}

yield currID, *currAttrs.values_at(*attr_types) if currID
$_$;


ALTER FUNCTION fast.attrs(entity_ids integer[], attr_types text[]) OWNER TO ndbadm;

--
-- Name: FUNCTION attrs(entity_ids integer[], attr_types text[]); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION attrs(entity_ids integer[], attr_types text[]) IS 'Helps process sets of per-entity attributes together as tuples.  For each existing document in @entity_ids, returns a row of its identifier plus values of its attributes named in @attr_types, in that order.';
*/

--
-- Name: attrs__type_must_be_set(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION attrs__type_must_be_set() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  PERFORM type_id
     FROM fast.entity_data
    WHERE entity_id = NEW.entity_id
      AND type_id IS NOT NULL;

  IF FOUND THEN RETURN NEW; END IF;

  RAISE EXCEPTION
    '%: can''t set attributes of an untyped document', NEW.entity_id;
END$$;


ALTER FUNCTION fast.attrs__type_must_be_set() OWNER TO ndbadm;

--
-- Name: FUNCTION attrs__type_must_be_set(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION attrs__type_must_be_set() IS 'Ensures that attributes can only be set for documents of a known type (int)';


--
-- Name: entity__attr_set(integer, integer, text); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  IF attrValue IS NULL THEN
    DELETE FROM fast.attrs
     WHERE entity_id = entityId
       AND attr_type_id = attrTypeId;

    RETURN;
  END IF;

  UPDATE fast.attrs
     SET value = attrValue
   WHERE entity_id = entityId
     AND attr_type_id = attrTypeId;

  IF FOUND THEN RETURN; END IF;

  INSERT INTO fast.attrs(entity_id, attr_type_id, value)
  VALUES(entityId, attrTypeId, attrValue);

  RETURN;
END$$;


ALTER FUNCTION fast.entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) IS 'Sets attribute (attrTypeId) of FAST document (entityId) to (attrValue)';


--
-- Name: entity__body_set(integer, bytea); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__body_set(entityid integer, bodydata bytea) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  UPDATE fast.entity_data
     SET body = bodyData
   WHERE entity_id = entityId;

  IF NOT FOUND THEN
    RAISE EXCEPTION '%: no such FAST document', entityId;
  END IF;

  RETURN;
END$$;


ALTER FUNCTION fast.entity__body_set(entityid integer, bodydata bytea) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__body_set(entityid integer, bodydata bytea); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__body_set(entityid integer, bodydata bytea) IS 'Records bodyData of the FAST document entityId';


--
-- Name: entity__check_type(integer, integer); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__check_type(entityid integer, typeidreqd integer) RETURNS boolean
    LANGUAGE plpgsql STABLE STRICT
    AS $$
BEGIN
  PERFORM entity_id
     FROM fast.entity_data
     JOIN fast.types USING (type_id)
    WHERE entity_id = entityId
      AND type_id = typeIdReqd;

  RETURN FOUND;
END$$;


ALTER FUNCTION fast.entity__check_type(entityid integer, typeidreqd integer) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__check_type(entityid integer, typeidreqd integer); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__check_type(entityid integer, typeidreqd integer) IS 'Checks if the entity (entityId) has the required type (typeIdReqd) (int)';


--
-- Name: entity__check_type(integer, public.item_name); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__check_type(entityid integer, typeidreqd public.item_name) RETURNS boolean
    LANGUAGE sql STABLE STRICT
    AS $_$
SELECT fast.entity__check_type($1, fast.type_id($2))$_$;


ALTER FUNCTION fast.entity__check_type(entityid integer, typeidreqd public.item_name) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__check_type(entityid integer, typeidreqd public.item_name); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__check_type(entityid integer, typeidreqd public.item_name) IS 'Checks if the entity (entityId) has the required type (typeIdReqd) (int)';


--
-- Name: entity__children_set(integer, integer[]); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__children_set(entityid integer, children integer[]) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  -- Deregister all existing children.
  DELETE FROM fast.entity_links
   WHERE "from" = entityId;

  -- Are there new children?
  IF array_lower(children, 1) IS NULL THEN RETURN; END IF;

  -- Register new children.
  FOR i IN array_lower(children, 1) .. array_upper(children, 1) LOOP
    INSERT INTO fast.entity_links("from", "to")
    VALUES (entityId, children[i]);
  END LOOP;

  RETURN;
END$$;


ALTER FUNCTION fast.entity__children_set(entityid integer, children integer[]) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__children_set(entityid integer, children integer[]); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__children_set(entityid integer, children integer[]) IS 'Links the FAST document entityId to the children';


--
-- Name: entity__error_set(integer, text); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__error_set(entityid integer, errormessage text) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  UPDATE fast.entity_data
     SET error = replace(errorMessage, '\n', ' | ')
   WHERE entity_id = entityId;

  IF NOT FOUND THEN
    RAISE EXCEPTION '%: no such FAST document', entityId;
  END IF;

  RETURN;
END$$;


ALTER FUNCTION fast.entity__error_set(entityid integer, errormessage text) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__error_set(entityid integer, errormessage text); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__error_set(entityid integer, errormessage text) IS 'Marks the FAST document entityId with the errorMessage';


--
-- Name: entity__final__immutable(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__final__immutable() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  -- A FAST document can be modified only as long as it is not `final'.
  PERFORM final
     FROM fast.entity_data
    WHERE entity_id = OLD.entity_id
      AND NOT final;

  IF FOUND THEN RETURN NEW; END IF;

  -- Superusers are permitted modification.
  PERFORM usesuper
     FROM pg_catalog.pg_user
    WHERE usename = session_user
      AND usesuper;

  IF FOUND THEN RETURN NEW; END IF;

  RAISE EXCEPTION 'can not modify a finalised FAST document (%)',
    OLD.entity_id;
END$$;


ALTER FUNCTION fast.entity__final__immutable() OWNER TO ndbadm;

--
-- Name: FUNCTION entity__final__immutable(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__final__immutable() IS 'Ensures that the FAST document being updated is not finalised (int)';


--
-- Name: entity__finalise(integer); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__finalise(entityid integer) RETURNS void
    LANGUAGE plpgsql STRICT SECURITY DEFINER
    AS $$
BEGIN
  PERFORM entity_id
     FROM fast.entities
    WHERE entity_id = entityId;

  IF NOT FOUND THEN
    RAISE EXCEPTION '%: no such FAST document', entityId;
  END IF;

  UPDATE fast.entity_data
     SET final = TRUE
   WHERE entity_id = entityId;

  RETURN;
END$$;


ALTER FUNCTION fast.entity__finalise(entityid integer) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__finalise(entityid integer); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__finalise(entityid integer) IS 'Prevents further modification of the FAST document entityId';


--
-- Name: entity__new(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__new() RETURNS integer
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
DECLARE
  entityId	fast.entities.entity_id%TYPE;

BEGIN
  INSERT INTO fast.entities DEFAULT VALUES;
  entityId := currval(pg_get_serial_sequence('fast.entities', 'entity_id'));
  INSERT INTO fast.entity_data(entity_id) VALUES(entityId);

  RETURN entityId;
END$$;


ALTER FUNCTION fast.entity__new() OWNER TO ndbadm;

--
-- Name: FUNCTION entity__new(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__new() IS 'Creates a new untyped FAST document';


--
-- Name: entity__new(public.item_name); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__new(typename public.item_name) RETURNS integer
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
DECLARE
  entityId	fast.entities.entity_id%TYPE;

BEGIN
  entityId = fast.entity__new();
  PERFORM fast.entity__type_id_set(entityId, fast.type_id(typeName));

  RETURN entityId;
END$$;


ALTER FUNCTION fast.entity__new(typename public.item_name) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__new(typename public.item_name); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__new(typename public.item_name) IS 'Creates a new FAST document of the given type (typeName)';


--
-- Name: entity__parents_set(integer, integer[]); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__parents_set(entityid integer, parents integer[]) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  -- Deregister all existing parents.
  DELETE FROM fast.entity_links
   WHERE "to" = entityId;

  -- Are there new parents?
  IF array_lower(parents, 1) IS NULL THEN RETURN; END IF;

  -- Register new parents.
  FOR i IN array_lower(parents, 1) .. array_upper(parents, 1) LOOP
    INSERT INTO fast.entity_links("from", "to")
    VALUES (parents[i], entityId);
  END LOOP;

  RETURN;
END$$;


ALTER FUNCTION fast.entity__parents_set(entityid integer, parents integer[]) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__parents_set(entityid integer, parents integer[]); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__parents_set(entityid integer, parents integer[]) IS 'Links the parents to the FAST document entityId';


--
-- Name: entity__type_id_set(integer, integer); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity__type_id_set(entityid integer, typeid integer) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  UPDATE fast.entity_data
     SET type_id = typeId
   WHERE entity_id = entityId;

  IF NOT FOUND THEN
    RAISE EXCEPTION '%: no such FAST document', entityId;
  END IF;

  RETURN;
END$$;


ALTER FUNCTION fast.entity__type_id_set(entityid integer, typeid integer) OWNER TO ndbadm;

--
-- Name: FUNCTION entity__type_id_set(entityid integer, typeid integer); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity__type_id_set(entityid integer, typeid integer) IS 'Sets the FAST document''s type to typeId';


--
-- Name: entity_data; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE entity_data (
    entity_id integer NOT NULL,
    type_id integer,
    created timestamp with time zone DEFAULT now() NOT NULL,
    final boolean DEFAULT false NOT NULL,
    error text,
    body bytea,
    expired boolean DEFAULT false NOT NULL,
    CONSTRAINT entity_data_check CHECK (((expired = false) OR ((error IS NULL) AND (body IS NULL)))),
    CONSTRAINT no_expired_body CHECK (((NOT expired) OR (body IS NULL))),
    CONSTRAINT set_type_id_first CHECK (((type_id IS NOT NULL) OR (((body IS NULL) AND (error IS NULL)) AND (NOT final))))
);


ALTER TABLE fast.entity_data OWNER TO ndbadm;

--
-- Name: TABLE entity_data; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE entity_data IS 'One-to-one entity data shifted to a different table due to frequent changes of the primary `entities'' table when other data is changed and thus the need to have the tuple of the latter as small as possible';


--
-- Name: COLUMN entity_data.entity_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_data.entity_id IS 'Unique identifier of the entity (ref)';


--
-- Name: COLUMN entity_data.type_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_data.type_id IS 'Unique identifier of the entity type (ref)';


--
-- Name: COLUMN entity_data.created; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_data.created IS 'When the entity was created (auto, srv)';


--
-- Name: COLUMN entity_data.final; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_data.final IS 'If TRUE, the entity is immutable';


--
-- Name: COLUMN entity_data.error; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_data.error IS 'If NOT NULL, the entity is in error state; the column describes the error';


--
-- Name: COLUMN entity_data.body; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_data.body IS 'The bulk of the entity data';


--
-- Name: COLUMN entity_data.expired; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_data.expired IS 'If TRUE, `body'' was set to NULL by purge';

--
-- Name: entity_data__type_id_checks(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION entity_data__type_id_checks() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  -- Type setting is one shot.
  IF  OLD.type_id IS NOT NULL
  AND OLD.type_id IS DISTINCT FROM NEW.type_id THEN
    RAISE EXCEPTION
      '%: can''t change FAST document type once it''s set', OLD.entity_id;
  END IF;

  -- No final untyped documents.
  IF NEW.final AND NEW.type_id IS NULL THEN
    DELETE FROM fast.entities
    WHERE entity_id = OLD.entity_id;

    RETURN NULL;
  END IF;

  RETURN NEW;
END$$;


ALTER FUNCTION fast.entity_data__type_id_checks() OWNER TO ndbadm;

--
-- Name: FUNCTION entity_data__type_id_checks(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION entity_data__type_id_checks() IS 'Prevents FAST document type modifications and ensures there are no final untyped documents (int)';

--
-- Name: pat_contents__no_same_layer_strips(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pat_contents__no_same_layer_strips() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  dupesOnLayers	INTEGER[];
  error		TEXT := 'multiple strips on layer';
  row		RECORD;

BEGIN
  SELECT INTO dupesOnLayers
  ARRAY(
    SELECT ps.layer AS layer
      FROM fast.pat_contents pc
      JOIN fast.pat_strips   ps USING (pat_strip_id)
     WHERE pc.pattern_id = NEW.pattern_id
  GROUP BY ps.layer
    HAVING COUNT(ps.layer) > 1);

  IF array_lower(dupesOnLayers, 1) IS NULL THEN
    RETURN NEW;
  ELSIF array_lower(dupesOnLayers, 1) = array_upper(dupesOnLayers, 1) THEN
    error := error || 's';
  END IF;

  error := error || ': ' || array_to_string(dupesOnLayers, ', ');
  RAISE EXCEPTION '%', error;
END$$;


ALTER FUNCTION fast.pat_contents__no_same_layer_strips() OWNER TO ndbadm;

--
-- Name: FUNCTION pat_contents__no_same_layer_strips(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION pat_contents__no_same_layer_strips() IS 'Makes sure no pattern has more than one strip on the same layer (int)';


--
-- Name: pat_strip__register(integer, smallint[], bytea); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) RETURNS integer
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
DECLARE
  patStripId	fast.pat_strips.pat_strip_id%TYPE;

BEGIN
  -- Request relies on md5 of offsets and values to identify strip because db
  -- doesn't do any better. A unique index in db relies on md5 of offsets and
  -- values as well.
  SELECT INTO patStripId pat_strip_id
    FROM fast.pat_strips
   WHERE layer = stripLayer
     AND md5((array_to_string(offsets, ',') || ':') || encode("values", 'hex')) =
         md5((array_to_string(stripOffsets, ',') || ':') || encode(stripValues, 'hex'));

  IF FOUND THEN RETURN patStripId; END IF;

  INSERT INTO fast.pat_strips(layer, offsets, "values")
  VALUES(stripLayer, stripOffsets, stripValues);
  RETURN currval(pg_get_serial_sequence('fast.pat_strips', 'pat_strip_id'));
END$$;


ALTER FUNCTION fast.pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) OWNER TO ndbadm;

--
-- Name: FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) IS 'Finds or adds a pattern strip by (stripLayer, stripOffsets, stripValues)';


SET search_path = fast, pg_catalog;

--
-- Name: pat_strips; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE pat_strips (
    pat_strip_id integer NOT NULL,
    layer integer NOT NULL,
    offsets smallint[] NOT NULL,
    "values" bytea NOT NULL,
    CONSTRAINT layer__positive CHECK ((layer > 0))
);


ALTER TABLE fast.pat_strips OWNER TO ndbadm;

--
-- Name: TABLE pat_strips; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE pat_strips IS 'Per-layer traffic pattern pieces, of which patterns consist';


--
-- Name: COLUMN pat_strips.pat_strip_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_strips.pat_strip_id IS 'Unique identifier of the piece';


--
-- Name: COLUMN pat_strips.layer; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_strips.layer IS 'Network layer number to which the piece belongs';


--
-- Name: COLUMN pat_strips.offsets; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_strips.offsets IS 'Ordered list of unique offsets within the layer which are patterned';


--
-- Name: COLUMN pat_strips."values"; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_strips."values" IS 'Values observed at corresponding offsets within the layer';


--
-- Name: pat_strip_hash(pat_strips); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pat_strip_hash(pat_strips) RETURNS text
    LANGUAGE sql IMMUTABLE
    AS $_$
  SELECT md5(array_to_string($1.offsets, ',') || ':' || encode($1.values, 'hex'));
$_$;


ALTER FUNCTION fast.pat_strip_hash(pat_strips) OWNER TO ndbadm;

--
-- Name: pat_strip_layer(integer); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pat_strip_layer(strip_id integer) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT layer FROM fast.pat_strips WHERE pat_strip_id = $1
$_$;


ALTER FUNCTION fast.pat_strip_layer(strip_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pat_strip_layer(strip_id integer); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION pat_strip_layer(strip_id integer) IS 'Returns layer ID of given pattern strip ';


--
-- Name: pat_strips__parse(); Type: FUNCTION; Schema: fast; Owner: ndbadm
-- (changed by Oren H.)

CREATE FUNCTION pat_strips__parse() RETURNS trigger
 LANGUAGE plpgsql
AS $_$
	DECLARE
		i 		int;
		bytes 	bytea	:= new.values;
		length	int 	:= octet_length(new.values);
		tmpLen 	int 	:= 0;
		suBytes bytea;
	begin
		-- Return if not layer 4		
		IF NEW.layer <> 4 THEN 
			RETURN NEW;
		END IF;
		
		-- Walk through the offsets and build all binary substring from 'values'
		FOR i IN REVERSE length..1
		LOOP
			IF NEW.offsets[i] + 1 != NEW.offsets[i+1] THEN
				tmpLen :=1;
			ELSE
				tmpLen := tmpLen + 1;
			END IF;
			suBytes := substring(bytes from i for tmpLen);

			-- Enter binary substring to pat_payload_search
	        BEGIN
			    INSERT INTO fast.pat_payload_search(pat_strip_id, word)
			      VALUES(NEW.pat_strip_id, suBytes);
			-- Duplicates are prevented by the table constrains
			-- Embrace the rejection
        	EXCEPTION WHEN unique_violation THEN
 		       -- hb prevent logging -- RAISE NOTICE '{%, %} already exists in table. Skipping...', NEW.pat_strip_id, suBytes;
            	-- Do nothing, and skip this duplicate data.
        	END;

 		END LOOP;
		
		return NEW;

	end
$_$;


ALTER FUNCTION fast.pat_strips__parse() OWNER TO ndbadm;

--
-- Name: pat_strips__purge(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pat_strips__purge() RETURNS void
    LANGUAGE sql
    AS $$
DELETE FROM fast.pat_strips
WHERE  pat_strip_id IN (
  SELECT    pat_strip_id
  FROM	    fast.pat_strips
  LEFT JOIN fast.pat_contents ref USING (pat_strip_id)
  WHERE     ref.pat_strip_id IS NULL)$$;


ALTER FUNCTION fast.pat_strips__purge() OWNER TO ndbadm;

--
-- Name: FUNCTION pat_strips__purge(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION pat_strips__purge() IS 'Removes unused pattern strips';


--
-- Name: pattern__new(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pattern__new() RETURNS integer
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  INSERT INTO fast.patterns DEFAULT VALUES;
  RETURN currval(pg_get_serial_sequence('fast.patterns', 'pattern_id'));
END$$;


ALTER FUNCTION fast.pattern__new() OWNER TO ndbadm;

--
-- Name: FUNCTION pattern__new(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION pattern__new() IS 'Creates a new pattern';


--
-- Name: pattern_from_strips(integer); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pattern_from_strips(integer) RETURNS text
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT fast.pattern_from_strips($1, 128)$_$;


ALTER FUNCTION fast.pattern_from_strips(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_from_strips(integer); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_from_strips(integer) IS 'Given a @pattern_id, reconstructs pattern text. Payload is abridged to 128 bytes. Equivalent to fast.pattern_from_strips(@pattern_id, 128).';


--
-- Name: pattern_from_strips(integer, integer); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION pattern_from_strips(pattern_id integer, "limit" integer) RETURNS text
    LANGUAGE c STABLE
    AS '/opt/allot/lib/libFAST.so', 'pattern_from_strips';


ALTER FUNCTION fast.pattern_from_strips(pattern_id integer, "limit" integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_from_strips(pattern_id integer, "limit" integer); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_from_strips(pattern_id integer, "limit" integer) IS 'Given a @pattern_id, reconstructs pattern text. Unless @limit is NULL, limits payload to that many bytes.';


--
-- Name: patterns__purge(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION patterns__purge() RETURNS void
    LANGUAGE sql
    AS $$
DELETE FROM fast.patterns
WHERE  pattern_id IN (
  SELECT    pattern_id
  FROM	    fast.patterns
  LEFT JOIN fast.entity_patterns ref USING (pattern_id)
  WHERE     ref.pattern_id IS NULL)$$;


ALTER FUNCTION fast.patterns__purge() OWNER TO ndbadm;

--
-- Name: FUNCTION patterns__purge(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION patterns__purge() IS 'Removes unused patterns';


--
-- Name: top_host_sets__pattern_id_check(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION top_host_sets__pattern_id_check() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  -- The pattern we're about to register a top host set for must be present in
  -- our parent.
  PERFORM ep.pattern_id
     FROM fast.entity_links	l
     JOIN fast.entity_patterns	ep ON (l."from" = ep.entity_id)
    WHERE l."to" = NEW.entity_id
      AND ep.pattern_id = NEW.pattern_id;

  IF NOT FOUND THEN
    RAISE EXCEPTION 'pattern % is not in the parent of `pattern-top-hosts'' %',
      NEW.pattern_id, NEW.entity_id;
  END IF;

  RETURN NEW;
END
$$;


ALTER FUNCTION fast.top_host_sets__pattern_id_check() OWNER TO ndbadm;

--
-- Name: FUNCTION top_host_sets__pattern_id_check(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION top_host_sets__pattern_id_check() IS 'Ensures that a pattern for which a `pattern-top-hosts'' has a host set is present in its parent `pattern-report'' (int)';


--
-- Name: top_hosts(integer, integer); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION top_hosts(_flood_id integer, _pattern_id integer) RETURNS SETOF record
    LANGUAGE plpgsql STABLE STRICT
    AS $$
DECLARE
  count INTEGER;
  ips	INET[];
  rec   RECORD;
  side  "char" := 'z';
  top_hosts_ids INTEGER[];
BEGIN
  SELECT INTO top_hosts_ids array_accum(ths_id)
    FROM (SELECT report_id AS entity_id
	    FROM flood.samples
	   WHERE flood_id = _flood_id
	 ) AS pr
    JOIN fast.entity_links el ON ("from" = entity_id)
    JOIN fast.entity_data ed ON (ed.entity_id = "to"
	 AND ed.type_id = fast.type_id('pattern-top-hosts'))
    JOIN fast.top_host_sets ths ON (ths.entity_id = "to")
   WHERE pattern_id = _pattern_id;

  FOR rec IN SELECT ths.side, th.ip
	       FROM fast.top_hosts th
	       JOIN fast.top_host_sets ths USING(ths_id)
	      WHERE ths_id = ANY(top_hosts_ids)
	      ORDER BY side, matches DESC LOOP
    IF side != rec.side THEN
      side := rec.side;
      count := 0;
      ips := ARRAY[]::INET[];
    END IF;
    
    IF count < 20 THEN
      IF rec.ip = ANY(ips) THEN
        CONTINUE;
      END IF;

      ips[CASE WHEN array_upper(ips, 1) IS NULL THEN 1
        ELSE array_upper(ips, 1) + 1 END] := rec.ip;
      count := count + 1;
      RETURN NEXT rec;
    END IF;
  END LOOP;

  RETURN;
END$$;


ALTER FUNCTION fast.top_hosts(_flood_id integer, _pattern_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION top_hosts(_flood_id integer, _pattern_id integer); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION top_hosts(_flood_id integer, _pattern_id integer) IS 'Returns source and destination IPs, better matches first, limit to 20 IPs per side.';


--
-- Name: types; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE types (
    type_id integer NOT NULL,
    name public.item_name,
    descr text
);


ALTER TABLE fast.types OWNER TO ndbadm;

--
-- Name: TABLE types; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE types IS 'Registry of FAST entity types';


--
-- Name: COLUMN types.type_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN types.type_id IS 'Unique identifier of the type';


--
-- Name: COLUMN types.name; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN types.name IS 'Unique name of the type';


--
-- Name: COLUMN types.descr; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN types.descr IS 'Verbose description of the type';


--
-- Name: type__get_by_name(public.item_name); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION type__get_by_name(typename public.item_name) RETURNS types
    LANGUAGE plpgsql STABLE
    AS $$
DECLARE
  row		RECORD;

BEGIN
  SELECT INTO row * FROM fast.types WHERE name = typeName;

  IF NOT FOUND THEN
    RAISE EXCEPTION '%: no such FAST document type', typeName;
  END IF;

  RETURN row;
END$$;


ALTER FUNCTION fast.type__get_by_name(typename public.item_name) OWNER TO ndbadm;

--
-- Name: FUNCTION type__get_by_name(typename public.item_name); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION type__get_by_name(typename public.item_name) IS 'Looks up a FAST document type by name (typeName)';


--
-- Name: type_id(public.item_name); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION type_id(typename public.item_name) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$
SELECT type_id FROM fast.type__get_by_name($1)$_$;


ALTER FUNCTION fast.type_id(typename public.item_name) OWNER TO ndbadm;

--
-- Name: FUNCTION type_id(typename public.item_name); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION type_id(typename public.item_name) IS 'Looks up a FAST document type identifier by name (typeName)';


--
-- Name: update_flood_modified(); Type: FUNCTION; Schema: fast; Owner: ndbadm
--

CREATE FUNCTION update_flood_modified() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
  DECLARE
    docType  TEXT;
    floodID  INTEGER;
  BEGIN
    -- DELETE or UPDATE when final is uninteresting
    IF TG_OP = 'DELETE' THEN
      RETURN NEW;
    ELSIF TG_OP = 'UPDATE' AND OLD.final THEN
      RETURN NEW;
    END IF;

    -- New SPC versions added FloodID entity attribute
    SELECT "value"::INTEGER INTO floodID
      FROM fast.attrs
      WHERE entity_id = NEW.entity_id
        AND attr_type_id = (SELECT attr_type_id FROM fast.attr_types WHERE name = 'FloodID');
    
    -- Fallback to the old way (for old entities)
    IF NOT FOUND THEN
      SELECT name INTO docType FROM fast.types WHERE type_id = NEW.type_id;
      IF docType = 'traffic-sample' THEN
        SELECT flood_id INTO floodID FROM flood.samples WHERE sample_id = NEW.entity_id;
      ELSIF docType = 'pattern-report' THEN
        SELECT flood_id INTO floodID FROM flood.samples WHERE report_id = NEW.entity_id;
      ELSIF docType = 'pattern-top-hosts' THEN
        SELECT flood_id INTO floodID FROM flood.samples WHERE top_hosts_id = NEW.entity_id;
      ELSIF docType = 'pattern-alerts' THEN
        SELECT flood_id INTO floodID FROM flood.samples WHERE alerts_id = NEW.entity_id;
      ELSIF docType = 'pattern-entropy' THEN
        SELECT flood_id INTO floodID FROM flood.samples WHERE entropy_id = NEW.entity_id;
      ELSE
        RETURN NEW;
      END IF;
    END IF;

    -- Update
    UPDATE flood.state SET modified = now() WHERE flood_id = floodID AND modified < now();
    RETURN NEW;
  END
$$;


ALTER FUNCTION fast.update_flood_modified() OWNER TO ndbadm;

--
-- Name: FUNCTION update_flood_modified(); Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON FUNCTION update_flood_modified() IS 'Update flood.state.modified for a FAST document related to the flood';


SET search_path = fgen, pg_catalog;

--
-- Name: get_rule_text(text, integer); Type: FUNCTION; Schema: fgen; Owner: ndbadm
--


CREATE FUNCTION get_rule_text(text, integer) RETURNS text
    LANGUAGE sql STABLE STRICT SECURITY DEFINER
    AS $_$
  SELECT fgen.get_rule_text_real($1, NULL, $2)$_$;


ALTER FUNCTION fgen.get_rule_text(text, integer) OWNER TO ndbadm;


--
-- Name: FUNCTION get_rule_text(text, integer); Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON FUNCTION get_rule_text(text, integer) IS 'Given a firewall type and pattern id, returns firewall rule text';


--
-- Name: get_rule_text(text, integer, integer); Type: FUNCTION; Schema: fgen; Owner: ndbadm
--

CREATE FUNCTION get_rule_text(text, integer, integer) RETURNS text
    LANGUAGE sql STABLE STRICT SECURITY DEFINER
    AS $_$
  SELECT fgen.get_rule_text_real($1, $2, $3)$_$;


ALTER FUNCTION fgen.get_rule_text(text, integer, integer) OWNER TO ndbadm;

--
-- Name: FUNCTION get_rule_text(text, integer, integer); Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON FUNCTION get_rule_text(text, integer, integer) IS 'Given a firewall type, flood id, pattern id, returns firewall rule text';


--
-- Name: get_rule_text_real(text, integer, integer); Type: FUNCTION; Schema: fgen; Owner: ndbadm
--

CREATE FUNCTION get_rule_text_real(text, integer, integer) RETURNS text
    LANGUAGE c STABLE
    AS '/opt/allot/lib/libfgen.so', 'get_rule_text';


ALTER FUNCTION fgen.get_rule_text_real(text, integer, integer) OWNER TO ndbadm;

--
-- Name: FUNCTION get_rule_text_real(text, integer, integer); Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON FUNCTION get_rule_text_real(text, integer, integer) IS 'Given a firewall type, flood id (can be NULL), pattern id, returns 
firewall rule text';


--
-- Name: type_id(text); Type: FUNCTION; Schema: fgen; Owner: ndbadm
--
--hb** not in use
CREATE FUNCTION type_id(text) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$SELECT type_id FROM fgen.types WHERE name = $1$_$;


ALTER FUNCTION fgen.type_id(text) OWNER TO ndbadm;

--
-- Name: FUNCTION type_id(text); Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON FUNCTION type_id(text) IS 'Resolves a filter type identifier back to its name';


--
-- Name: type_name(integer); Type: FUNCTION; Schema: fgen; Owner: ndbadm
--
--hb** not in use
CREATE FUNCTION type_name(integer) RETURNS text
    LANGUAGE sql STABLE STRICT
    AS $_$SELECT name FROM fgen.types WHERE type_id = $1$_$;


ALTER FUNCTION fgen.type_name(integer) OWNER TO ndbadm;

SET search_path = flood, pg_catalog;

--
-- Name: aggregate_alerts(integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION aggregate_alerts(flood_id_in integer) RETURNS void
    LANGUAGE plpgsql STRICT
    AS $$BEGIN
  DELETE FROM flood.alerts
        WHERE flood_id = flood_id_in
          AND pattern_id IS NULL
          AND sample_id IS NULL;

  INSERT INTO flood.alerts(flood_id, alerter_id, alert_type_id, relevance, total)
    (SELECT flood_id,
	    alerter_id,
	    alert_type_id,
	    max(pat_quality*relevance) AS relevance,
	    1 AS total
       FROM flood.alerts
       JOIN (SELECT flood_id,
		    pattern_id,
                    flood.pattern_quality(ep.matches, substring(s.request FROM
		      'modelMismatch=([^[:space:]]+)')::REAL)::REAL/100 AS pat_quality
               FROM (SELECT DISTINCT flood_id, s2.report_id, pattern_id
		       FROM flood.samples s
		       JOIN fast.entity_patterns ep ON (entity_id = report_id)
                       JOIN flood.samples s2 USING (flood_id)) every
          LEFT JOIN (       fast.entity_patterns ep
	               JOIN flood.samples s ON (report_id = entity_id)
          ) USING (flood_id, report_id, pattern_id)
         GROUP BY 1, 2
       ) AS pq USING (flood_id, pattern_id)
      WHERE flood_id = flood_id_in
	AND pat_quality > 0
      GROUP BY 1, 2, 3
    );
END$$;


ALTER FUNCTION flood.aggregate_alerts(flood_id_in integer) OWNER TO ndbadm;

--
-- Name: FUNCTION aggregate_alerts(flood_id_in integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION aggregate_alerts(flood_id_in integer) IS 'Add a flood-wide relevance per alerter and alert type pair. Before adding, any such records existing for the flood are deleted.';


--
-- Name: automatic_importance(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION automatic_importance(flood_id integer, importance integer, filter_id integer) RETURNS boolean
    LANGUAGE sql STRICT
    AS $_$
  SELECT notify.set_event_importance('flood'::TEXT, $1, $2, TRUE, $3);
$_$;


ALTER FUNCTION flood.automatic_importance(flood_id integer, importance integer, filter_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION automatic_importance(flood_id integer, importance integer, filter_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION automatic_importance(flood_id integer, importance integer, filter_id integer) IS 'Set flood importance, note filter as request source. Importance is set only if current importance wasn''t set by a user and current importance is lower than the importance to be set';


--
-- Name: cleanup(integer, text); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION cleanup(subsystem_id integer, details text) RETURNS void
    LANGUAGE sql STRICT
    AS $_$UPDATE flood.state s
    SET stop = modified, details = $2
   FROM flood.registry r
  WHERE r.flood_id = s.flood_id
    AND s.stop IS NULL
    AND r.subsystem_id = $1$_$;


ALTER FUNCTION flood.cleanup(subsystem_id integer, details text) OWNER TO ndbadm;

--
-- Name: FUNCTION cleanup(subsystem_id integer, details text); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION cleanup(subsystem_id integer, details text) IS 'Closes all active floods registered by a particular subsystem';


--
-- Name: duration(timestamp with time zone, timestamp with time zone, timestamp with time zone); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) RETURNS double precision
    LANGUAGE sql IMMUTABLE
    AS $_$SELECT GREATEST(1.0, EXTRACT(epoch FROM (COALESCE($2, $3) - $1)))$_$;


ALTER FUNCTION flood.duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) OWNER TO ndbadm;

--
-- Name: FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) IS 'Returns flood duration for display or searching';


--
-- Name: error_close(integer, timestamp with time zone); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION error_close(error_id integer, stop timestamp with time zone) RETURNS void
    LANGUAGE sql STRICT
    AS $_$UPDATE flood.errors SET stop = $2 WHERE error_id = $1$_$;


ALTER FUNCTION flood.error_close(error_id integer, stop timestamp with time zone) OWNER TO ndbadm;

--
-- Name: FUNCTION error_close(error_id integer, stop timestamp with time zone); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION error_close(error_id integer, stop timestamp with time zone) IS 'Closes an error previously open by error_open()';


--
-- Name: error_open(integer, timestamp with time zone, text, text); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text) RETURNS integer
    LANGUAGE sql STRICT
    AS $_$INSERT INTO flood.errors(subsystem_id, start, descriptor, details)
	     VALUES($1, $2, $3, $4);
 SELECT currval('flood.errors_error_id_seq')::INTEGER$_$;


ALTER FUNCTION flood.error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text) OWNER TO ndbadm;

--
-- Name: FUNCTION error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text) IS 'Creates an error entry with the given data';


--
-- Name: errors_cleanup(integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION errors_cleanup(subsystem_id integer) RETURNS void
    LANGUAGE sql STRICT
    AS $_$UPDATE flood.errors
    SET stop = CURRENT_TIMESTAMP
  WHERE subsystem_id = $1 AND stop IS NULL$_$;


ALTER FUNCTION flood.errors_cleanup(subsystem_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION errors_cleanup(subsystem_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION errors_cleanup(subsystem_id integer) IS 'Closes all open errors for the given flood-like anomaly detection subsystem';


--
-- Name: exists_p(integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION exists_p(flood_id integer) RETURNS boolean
    LANGUAGE sql STABLE
    AS $_$SELECT COUNT(flood_id) > 0 FROM flood.registry WHERE flood_id = $1$_$;


ALTER FUNCTION flood.exists_p(flood_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION exists_p(flood_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION exists_p(flood_id integer) IS 'Determines if a particular flood-like anomaly exists';


--
-- Name: ext_rate(bigint, bigint, real); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION ext_rate(observed bigint, expected bigint, duration real) RETURNS double precision
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$SELECT ($1 - $2)::FLOAT / $3$_$;


ALTER FUNCTION flood.ext_rate(observed bigint, expected bigint, duration real) OWNER TO ndbadm;

--
-- Name: FUNCTION ext_rate(observed bigint, expected bigint, duration real); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION ext_rate(observed bigint, expected bigint, duration real) IS 'Calculates an extra rate';


--
-- Name: ext_rel(bigint, bigint); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION ext_rel(observed bigint, expected bigint) RETURNS double precision
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$SELECT CASE WHEN $2 < 1 THEN 1E4 ELSE LEAST(1E4, ($1 - $2)::FLOAT / $2) END$_$;


ALTER FUNCTION flood.ext_rel(observed bigint, expected bigint) OWNER TO ndbadm;

--
-- Name: FUNCTION ext_rel(observed bigint, expected bigint); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION ext_rel(observed bigint, expected bigint) IS 'Calculates a relative extra';


--
-- Name: flood_has_pattern_p(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer) RETURNS boolean
    LANGUAGE plpgsql STABLE STRICT
    AS $$DECLARE
  sumVar    INTEGER;
BEGIN
-- FIXME: iterate over sample_ids until first will yield true.
  SELECT SUM(flood.sample_has_pattern_p(sample_id, _pattern_id)::INTEGER) INTO sumVar
    FROM flood.samples
   WHERE samples.flood_id = _flood_id
     AND samples.sample_id IS NOT NULL;

  IF sumVar > 0 THEN RETURN TRUE; END IF;
  RETURN FALSE;
END$$;


ALTER FUNCTION flood.flood_has_pattern_p(_flood_id integer, _pattern_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer) IS 'Returns true if the flood has a pattern-report that contains the given pattern';


--
-- Name: flood_has_sample_p(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer) RETURNS boolean
    LANGUAGE plpgsql STABLE STRICT
    AS $$BEGIN
  PERFORM flood_id
     FROM flood.samples s
    WHERE s.flood_id = _flood_id
      AND s.sample_id = _sample_id;

  RETURN FOUND;
END$$;


ALTER FUNCTION flood.flood_has_sample_p(_flood_id integer, _sample_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer) IS 'Returns true if the specified flood has specified traffic sample (as perflood.samples table)';


--
-- Name: get_graph(integer, text, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE OR REPLACE FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) RETURNS SETOF record
 LANGUAGE plpgsql 
    AS $_$
   DECLARE
    row_count_val integer;
    step_val integer;
    indx_val integer;
    
   BEGIN 

-- The data is unpacked from arrays in flood.graphs as necessary
-- and returned simply as a set of rows of `timestamp, value' columns.
--
-- The passed number of desired data points is only a guide; fewer or more
-- points may be returned.

   IF points < 2 THEN
     RAISE NOTICE ' % points - too few, at least 2 should be requested', points;
	 RETURN;
	END IF; 
	
  CREATE TEMPORARY TABLE temp_flood_graph_value (
	 ID serial,
     at_t timestamp with time zone,
     single_val real,
     ordering interval
	) ON COMMIT DROP; 	
	
-- Fill data from flood.graphs tables into temp_flood_graph_value
   INSERT INTO temp_flood_graph_value(at_t,single_val,ordering) 
    SELECT g.at, unnest(g.values) single_val, generate_series(0,array_length(g.values,1)-1)*g.resolution*interval '1 second' ord
     FROM flood.graphs g JOIN public.statistics s USING (stat_id) 
      WHERE g.flood_id=flood AND s.name = graph order by g.at,ord ;	 
    
    GET DIAGNOSTICS row_count_val = ROW_COUNT; 
    
    step_val := (row_count_val - 1)/(points -1);
	
	IF step_val < 1 THEN
	   step_val := 1;
	END IF;   
	
	indx_val := 1;
	
	FOR indx_val IN 1..row_count_val-2 BY step_val
	 LOOP
	   RETURN QUERY select (at_t + ordering ), single_val from temp_flood_graph_value where ID=indx_val;
	 END LOOP;
     -- Last record
	 RETURN QUERY select (at_t + ordering ), single_val from temp_flood_graph_value where ID=row_count_val;

  END
$_$; 

ALTER FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) OWNER TO ndbadm;

--
-- Name: FUNCTION get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) IS 'Returns graphing points for one traffic statistic of a flood';


--
-- Name: manual_importance(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION manual_importance(flood_id integer, importance integer, uid integer) RETURNS boolean
    LANGUAGE sql STRICT
    AS $_$
  SELECT notify.set_event_importance('flood'::TEXT, $1, $2, FALSE, $3);
$_$;


ALTER FUNCTION flood.manual_importance(flood_id integer, importance integer, uid integer) OWNER TO ndbadm;

--
-- Name: FUNCTION manual_importance(flood_id integer, importance integer, uid integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION manual_importance(flood_id integer, importance integer, uid integer) IS 'Set flood importance, note user as request source';


--
-- Name: mtg_live_set_state(integer, integer, text, text); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_live_set_state(_target_id integer, _pattern_id integer, _state_id text, _state_details text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
BEGIN
  -- Avoid races.
  PERFORM flood.mtg_lock();

  UPDATE flood.mtg_live
     SET refresh	= FALSE,
	 state_id	= _state_id,
	 state_details	= _state_details,
	 state_since	= DEFAULT
   WHERE (sg_id, pattern_id) = (_target_id, _pattern_id);

  RETURN FOUND;
END;
$$;


ALTER FUNCTION flood.mtg_live_set_state(_target_id integer, _pattern_id integer, _state_id text, _state_details text) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_live_set_state(_target_id integer, _pattern_id integer, _state_id text, _state_details text); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_live_set_state(_target_id integer, _pattern_id integer, _state_id text, _state_details text) IS 'For NBAD mitigation connectivity daemon, to advance live request state';


--
-- Name: mtg_lock(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_lock() RETURNS void
    LANGUAGE sql
    AS $$
    LOCK TABLE flood.mtg_live IN EXCLUSIVE MODE;
    LOCK TABLE flood.mtg_reqs IN EXCLUSIVE MODE;
  $$;


ALTER FUNCTION flood.mtg_lock() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_lock(); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_lock() IS 'Avoids races on modifying flood.mtg_live and flood.mtg_reqs tables (int)';


--
-- Name: mtg_map__propagate(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_map__propagate() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  IF TG_OP = 'UPDATE' THEN
    -- UPDATEs aren't allowed.
    RAISE EXCEPTION '% to %.% not allowed',
      TG_TABLE_SCHEMA, TG_TABLE_NAME, TG_OP;
  END IF;

  -- Avoid races.
  PERFORM flood.mtg_lock();

  -- Remove expired requests, as required by flood.mtg_req_apply().
  DELETE FROM flood.mtg_reqs WHERE action_expire < CURRENT_TIMESTAMP;

  IF TG_OP = 'INSERT' THEN
    -- Actualise the new target.
    PERFORM flood.mtg_map__propagate(NEW.host_id, NEW.sg_id);
  ELSE
    -- DELETE
    -- Deactualise the old target.
    PERFORM flood.mtg_map__propagate(OLD.host_id, OLD.sg_id);
  END IF;

  RETURN NULL;
END
$$;


ALTER FUNCTION flood.mtg_map__propagate() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_map__propagate(); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_map__propagate() IS 'Calls flood.mtg_req_apply() upon changes to flood.mtg_map (int)';


--
-- Name: mtg_map__propagate(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_map__propagate(_host_id integer, _target_id integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
  _pattern_id	fast.patterns.pattern_id%TYPE;

BEGIN
  FOR _pattern_id IN
    SELECT DISTINCT mr.pattern_id
      FROM flood.registry r
      JOIN flood.mtg_reqs mr USING (flood_id)
     WHERE r.host_id = _host_id
  LOOP
    PERFORM flood.mtg_req_apply(_target_id, _pattern_id);
  END LOOP;
END
$$;


ALTER FUNCTION flood.mtg_map__propagate(_host_id integer, _target_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_map__propagate(_host_id integer, _target_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_map__propagate(_host_id integer, _target_id integer) IS 'Calls flood.mtg_req_apply() upon changes to flood.mtg_map (int)';


--
-- Name: mtg_req__flood_deleted(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req__flood_deleted() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  PERFORM flood.mtg_lock();
  DELETE FROM flood.mtg_reqs mr
   WHERE mr.flood_id = OLD.flood_id;
  RETURN OLD;
END;
$$;


ALTER FUNCTION flood.mtg_req__flood_deleted() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_req__flood_deleted(); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_req__flood_deleted() IS 'When a flood is purged, facilitate proper removal of its mitigation (int)';


--
-- Name: mtg_req__flood_over(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req__flood_over() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  RETURN NULL;
END;
$$;


ALTER FUNCTION flood.mtg_req__flood_over() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_req__flood_over(); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_req__flood_over() IS 'When a flood ends, removes mitigation requests that apply till it lasts (int)';


--
-- Name: mtg_req_apply(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req_apply(_target_id integer, _pattern_id integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
  _action_expire flood.mtg_reqs.action_expire%TYPE;
  _action_none	BOOLEAN;
  _action_since	flood.mtg_reqs.action_since%TYPE;
  _action flood.mtg_reqs.action%TYPE;
BEGIN
  -- Find effective request for the target/pattern combo.
  --
  -- NB!  Relies on:
  --   * ALL flood.mtg_reqs being applicable at CURRENT_TIMESTAMP;
  --   * BLOCK being higher precedence (sorting before) NONE.
  --
  -- Per action type, find the EARLIEST action_since, but the LATEST (effective)
  -- action_expire.  Return result for the highest precedence action type only.
     SELECT action, action = 'NONE',
	    MIN(action_since),
	    CASE WHEN COUNT(action_expire) <> COUNT(action_since)
	      THEN NULL
	      ELSE MAX(action_expire)
	    END
       INTO _action, _action_none, _action_since, _action_expire
       FROM flood.mtg_reqs mr
       JOIN flood.registry r  USING (flood_id)
       JOIN flood.state    s  USING (flood_id)
       JOIN flood.mtg_map  mm USING (host_id)
      WHERE mm.sg_id = _target_id
	AND mr.pattern_id = _pattern_id
	AND (NOT mr.action_flood_only OR s.stop IS NULL)
   GROUP BY action
   ORDER BY action
      LIMIT 1;

  IF NOT FOUND OR _action_none THEN
    _action_expire :=
      CASE WHEN _action_none THEN 'EPOCH' ELSE CURRENT_TIMESTAMP END;

    -- Try disabling the current live request.
    UPDATE flood.mtg_live
       SET action_expire = _action_expire,
	   refresh	 = TRUE
     WHERE (sg_id, pattern_id) = (_target_id, _pattern_id);
    RETURN;
  END IF;

  -- NB: FOUND AND NOT _action_none.
  -- Try updating the current live request.
  UPDATE flood.mtg_live
     SET action	= _action,
	 action_since	= _action_since,
	 action_expire	= _action_expire,
	 refresh	= TRUE
   WHERE (sg_id, pattern_id) = (_target_id, _pattern_id);
  IF FOUND THEN RETURN; END IF;

  -- Create a new live request.
  INSERT INTO flood.mtg_live(sg_id, pattern_id, action_since, action_expire, action)
  VALUES(_target_id, _pattern_id, _action_since, _action_expire, _action);
END;
$$;


ALTER FUNCTION flood.mtg_req_apply(_target_id integer, _pattern_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_req_apply(_target_id integer, _pattern_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_req_apply(_target_id integer, _pattern_id integer) IS 'Make aggregated non-expired mitigation request live (int)';


--
-- Name: mtg_req_auto_block(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req_auto_block(_flood_id integer, _orig_pattern_id integer, _filter_id integer) RETURNS void
    LANGUAGE sql
    AS $_$
		SELECT flood.mtg_req_auto_block($1, $2, $3, NULL);
	$_$;


ALTER FUNCTION flood.mtg_req_auto_block(_flood_id integer, _orig_pattern_id integer, _filter_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_req_auto_block(_flood_id integer, _orig_pattern_id integer, _filter_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_req_auto_block(_flood_id integer, _orig_pattern_id integer, _filter_id integer) IS 'For Informer, to submit automatic NBAD mitigation requests';


--
-- Name: mtg_req_auto_block(integer, integer, integer, timestamp with time zone); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req_auto_block(_flood_id integer, _orig_pattern_id integer, _filter_id integer, _expires timestamp with time zone) RETURNS void
    LANGUAGE plpgsql
    AS $$
    BEGIN
    INSERT INTO flood.mtg_auto_block_tbl(flood_id, orig_pattern_id, filter_id, expires)
    VALUES(_flood_id, _orig_pattern_id, _filter_id, _expires);
    END;
$$;


ALTER FUNCTION flood.mtg_req_auto_block(_flood_id integer, _orig_pattern_id integer, _filter_id integer, _expires timestamp with time zone) OWNER TO ndbadm;

--
-- Name: mtg_req_auto_block_with_action(integer, integer, integer, timestamp with time zone, mtg_req_action); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req_auto_block_with_action(_flood_id integer, _orig_pattern_id integer, _filter_id integer, _expires timestamp with time zone, _action mtg_req_action) RETURNS void
    LANGUAGE plpgsql
    AS $$
    BEGIN
    INSERT INTO flood.mtg_auto_block_with_action_tbl(flood_id, orig_pattern_id, filter_id, expires, action)
    VALUES(_flood_id, _orig_pattern_id, _filter_id, _expires, _action);
    END;
$$;


ALTER FUNCTION flood.mtg_req_auto_block_with_action(_flood_id integer, _orig_pattern_id integer, _filter_id integer, _expires timestamp with time zone, _action mtg_req_action) OWNER TO ndbadm;

--
-- Name: mtg_req_manual_block(integer, integer, integer, mtg_req_action, timestamp with time zone, boolean); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
    INSERT INTO flood.mtg_req_manual_block_tbl(flood_id, orig_pattern_id, u_id, action, action_expire, action_flood_only)
    VALUES(_flood_id, _orig_pattern_id, _uid, _action, _action_expire, _action_flood_only);
END;
$$;


ALTER FUNCTION flood.mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) IS 'For Web UI, to submit manual NBAD mitigation requests';


--
-- Name: mtg_req_manual_unblock(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req_manual_unblock(_flood_id integer, _uid integer) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
    INSERT INTO flood.mtg_req_manual_unblock_tbl(flood_id, u_id)
    VALUES(_flood_id, _uid);
END;
$$;


ALTER FUNCTION flood.mtg_req_manual_unblock(_flood_id integer, _uid integer) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_req_manual_unblock(_flood_id integer, _uid integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_req_manual_unblock(_flood_id integer, _uid integer) IS 'For Web UI, to revoke manual or automatic NBAD mitigation requests';


--
-- Name: mtg_req_manual_unblock_impl(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_req_manual_unblock_impl(_flood_id integer, _uid integer) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
  -- Avoid races.
  PERFORM flood.mtg_lock();

  -- Remove the request, if any, for an ended flood.
  DELETE FROM flood.mtg_reqs r
   USING flood.state s
   WHERE r.flood_id = _flood_id
     AND s.flood_id = r.flood_id
     AND s.stop IS NOT NULL;
  IF FOUND THEN RETURN; END IF;

  -- Update the request, if any, for an ongoing flood.
  UPDATE flood.mtg_reqs r
     SET filter_id	 = NULL,
	 uid		 = _uid,
	 action          = 'NONE',
	 action_since	 = DEFAULT,
	 action_expire   = NULL,
	 action_flood_only = TRUE
    FROM flood.state s
   WHERE r.flood_id = _flood_id
     AND s.flood_id = r.flood_id
     AND s.stop IS NULL;
END;
$$;


ALTER FUNCTION flood.mtg_req_manual_unblock_impl(_flood_id integer, _uid integer) OWNER TO ndbadm;

--
-- Name: mtg_reqs__check_insert(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_reqs__check_insert() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
      _req_until TIMESTAMPTZ;
    BEGIN
      SELECT MAX(req_until)
        INTO _req_until
        FROM flood.mtg_reqs_log_past
        WHERE flood_id = NEW.flood_id;
      
      -- This is a new request, it should be latest.
      IF FOUND THEN
        IF _req_until >= NEW.action_since THEN
          RAISE EXCEPTION 'INSERT delayed too long, aborting';
        END IF;
      END IF;
      RETURN NEW;
    END;
  $$;


ALTER FUNCTION flood.mtg_reqs__check_insert() OWNER TO ndbadm;

--
-- Name: mtg_reqs__log_delete(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_reqs__log_delete() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
      _req_since TIMESTAMPTZ;
      _req_until TIMESTAMPTZ;
    BEGIN
      _req_until = LEAST(OLD.action_expire, now());
      SELECT GREATEST(MAX(req_until), OLD.action_since)
        INTO _req_since
        FROM flood.mtg_reqs_log_past
        WHERE flood_id = OLD.flood_id;

      IF _req_since >= _req_until THEN
        -- Transaction reordered through LOCK.
        -- Abort transaction, so client (NBAD writer) may retry txn in the correct order.
        RAISE EXCEPTION 'Out of order DELETE, aborting';
      END IF;
      
      -- Log the time period the previous request state was in effect for
      INSERT INTO flood.mtg_reqs_log_past(
        flood_id, orig_pattern_id, pattern_id, filter_id, uid,
        action, action_expire, action_flood_only,
        req_since, req_until
      ) VALUES (
        OLD.flood_id, OLD.orig_pattern_id, OLD.pattern_id, OLD.filter_id, OLD.uid,
        OLD.action, OLD.action_expire, OLD.action_flood_only,
        _req_since, _req_until
      );

      -- Log the DELETE time by creating zero duration log entry with NULL action.
      -- The condition excludes Manual Unblock for in-progress floods.
      INSERT INTO flood.mtg_reqs_log_past(
        flood_id, orig_pattern_id, pattern_id, filter_id, uid,
        action, action_expire, action_flood_only,
        req_since, req_until
      )
        SELECT
          OLD.flood_id, OLD.orig_pattern_id, OLD.pattern_id, OLD.filter_id, OLD.uid,
          NULL::unknown AS action,
          OLD.action_expire, OLD.action_flood_only,
          _req_until AS req_since,
          _req_until AS req_until
        FROM flood.registry r
        JOIN flood.state s USING (flood_id)
        WHERE r.flood_id = OLD.flood_id
          AND NOT (OLD.action::text = 'NONE'::text AND s.stop IS NOT NULL)
      ;
      
      -- Done
      RETURN OLD;
    END;
  $$;


ALTER FUNCTION flood.mtg_reqs__log_delete() OWNER TO ndbadm;

--
-- Name: mtg_reqs__log_update(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_reqs__log_update() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
      _req_since TIMESTAMPTZ;
    BEGIN
      SELECT GREATEST(MAX(req_until), OLD.action_since)
        INTO _req_since
        FROM flood.mtg_reqs_log_past
        WHERE flood_id = OLD.flood_id;
      
      IF _req_since >= now() THEN
        -- Transaction reordered through LOCK.
        -- Ignore this UPDATE by reusing OLD row and not updating mtg_reqs_log_past.
        --
        -- NB: Do NOT return NULL (to cancel update) because it messes up
        --     the FOUND condition check in flood.mtg_req_manual_block() function
        RAISE NOTICE 'Out of order UPDATE, ignoring';
        RETURN OLD;
      END IF;
      
      IF NEW.action_expire NOTNULL AND NEW.action_expire <= now() THEN
        -- Subtle: An UPDATE must result in action_expire in the future.
        --
        -- When DELETE of expired reqs manipulates the flood.mtg_reqs_log_past table,
        -- it uses action_expire as the log time. But if the UPDATE was permitted,
        -- a row in future would exist.
        RAISE EXCEPTION 'UPDATE action_expire is past, aborting';
      END IF;
      
      -- Log the time period the previous request state was in effect for
      INSERT INTO flood.mtg_reqs_log_past(
        flood_id, orig_pattern_id, pattern_id, filter_id, uid,
        action, action_expire, action_flood_only,
        req_since, req_until
      ) VALUES (
        OLD.flood_id, OLD.orig_pattern_id, OLD.pattern_id, OLD.filter_id, OLD.uid,
        OLD.action, OLD.action_expire, OLD.action_flood_only,
        _req_since, now()
      );
      
      -- Done
      RETURN NEW;
    END;
  $$;


ALTER FUNCTION flood.mtg_reqs__log_update() OWNER TO ndbadm;

--
-- Name: mtg_reqs__propagate(); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_reqs__propagate() RETURNS trigger
    LANGUAGE plpgsql
    AS $$BEGIN
  -- NB: Do not merge the IFs, SQL doesn't obey the order of AND!
  IF TG_OP = 'UPDATE' THEN
    IF NEW.flood_id <> OLD.flood_id THEN
      RAISE EXCEPTION '% to %.% can''t change flood_id',
	TG_OP, TG_TABLE_SCHEMA, TG_TABLE_NAME;
    END IF;
  END IF;

  -- Remove expired requests, as required by flood.mtg_req_apply().
  DELETE FROM flood.mtg_reqs WHERE action_expire < CURRENT_TIMESTAMP;

  IF TG_OP = 'DELETE' THEN
    -- Deactualise the old request.
    PERFORM flood.mtg_reqs__propagate(OLD.flood_id, OLD.pattern_id, NULL);
  ELSIF TG_OP = 'INSERT' THEN
    -- Actualise the new request.
    PERFORM flood.mtg_reqs__propagate(NEW.flood_id, NEW.pattern_id, NULL);
  ELSE
    -- UPDATE
    -- Deactualise the old request and actualise the updated request.
    PERFORM flood.mtg_reqs__propagate(OLD.flood_id, OLD.pattern_id,
      NULLIF(NEW.pattern_id, OLD.pattern_id));
  END IF;

  RETURN NULL;
END$$;


ALTER FUNCTION flood.mtg_reqs__propagate() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_reqs__propagate(); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_reqs__propagate() IS 'Calls flood.mtg_req_apply() upon changes to flood.mtg_reqs (int)';


--
-- Name: mtg_reqs__propagate(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_reqs__propagate(_flood_id integer, _pattern_id integer, _pattern2_id integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
  _target_id	notify.targets.target_id%TYPE;

BEGIN
  FOR _target_id IN
    SELECT mm.sg_id
      FROM flood.registry r
      JOIN flood.mtg_map  mm USING (host_id)
     WHERE r.flood_id = _flood_id
  LOOP
    PERFORM flood.mtg_req_apply(_target_id, _pattern_id);
    IF _pattern2_id IS NOT NULL THEN
      PERFORM flood.mtg_req_apply(_target_id, _pattern2_id);
    END IF;
  END LOOP;
END
$$;


ALTER FUNCTION flood.mtg_reqs__propagate(_flood_id integer, _pattern_id integer, _pattern2_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_reqs__propagate(_flood_id integer, _pattern_id integer, _pattern2_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_reqs__propagate(_flood_id integer, _pattern_id integer, _pattern2_id integer) IS 'Calls flood.mtg_req_apply() upon changes to flood.mtg_reqs (int)';


--
-- Name: mtg_states; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_states (
    state_id text NOT NULL,
    descr text NOT NULL,
    "order" smallint NOT NULL,
    hot boolean NOT NULL,
    ok boolean NOT NULL,
    quiet boolean NOT NULL
);


ALTER TABLE flood.mtg_states OWNER TO ndbadm;

--
-- Name: TABLE mtg_states; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_states IS 'Mitigation request states catalogue';


--
-- Name: COLUMN mtg_states.state_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.state_id IS 'Unique identifier of the state';


--
-- Name: COLUMN mtg_states.descr; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.descr IS 'Verbose description of the state';


--
-- Name: COLUMN mtg_states."order"; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states."order" IS 'The overall state among many has the highest `order''';


--
-- Name: COLUMN mtg_states.hot; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.hot IS 'Whether the request is still to be upheld';


--
-- Name: COLUMN mtg_states.ok; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.ok IS 'Whether the state denotes normal flow';


--
-- Name: COLUMN mtg_states.quiet; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.quiet IS 'Whether the state is not to change soon';


--
-- Name: mtg_state(text); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION mtg_state(_state_id text) RETURNS mtg_states
    LANGUAGE sql IMMUTABLE
    AS $_$SELECT * FROM flood.mtg_states WHERE state_id = $1$_$;


ALTER FUNCTION flood.mtg_state(_state_id text) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_state(_state_id text); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_state(_state_id text) IS 'Resolves a state_id to complete mitigation state info';


--
-- Name: open(integer, integer, integer, integer, timestamp with time zone); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone) RETURNS integer
    LANGUAGE plpgsql STRICT
    AS $$DECLARE
  flood		flood.registry.flood_id%TYPE;

BEGIN
  INSERT INTO flood.registry(type_id, subsystem_id, host_id, group_id)
  VALUES("type", subsystem, host, "group")
  RETURNING flood_id INTO flood;

  INSERT INTO flood.state(flood_id, start) VALUES(flood, start_at);
  INSERT INTO flood.stats(flood_id)        VALUES(flood);
  INSERT INTO flood.cache(flood_id)        VALUES(flood);

  RETURN flood;
END$$;


ALTER FUNCTION flood.open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone) OWNER TO ndbadm;

--
-- Name: FUNCTION open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone) IS 'Returns the ID of a newly opened flood';


--
-- Name: pattern_attack_type(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE OR REPLACE FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) RETURNS SETOF record
   LANGUAGE plpgsql 
    AS $_$
   DECLARE
    attack_type_val text;
    ep_val integer;
    tp_val integer;
    
    result_cur record;
    srcip_val integer;
    srcep_val integer;
    srctp_val integer;
    dstip_val integer;
    dstep_val integer; 
    dsttp_val integer;
    tmp_attack_type_val text := NULL;
    
   BEGIN 
   
   attack_type_val := NULL;
   ep_val :=0;
   tp_val :=0;
   
   CREATE TEMPORARY TABLE temp_flood_attack_type_1 (
	 sample_id  integer,
	 side       char,
	 ip_cnt     integer,
	 pkt_cnt1   integer,
	 pkt_cnt2   integer
	) ON COMMIT DROP; 
	
	CREATE TEMPORARY TABLE temp_flood_attack_type_2 (
	 sample_id  integer,
	 side       char,
	 ip_cnt     integer,
	 pkt_cnt1   integer
	) ON COMMIT DROP; 
	
	INSERT INTO temp_flood_attack_type_1(sample_id,side,ip_cnt,pkt_cnt1)
	 SELECT sample_id,
	  th.side,
	  ROUND((1 - th.match)/th.minmatch) + ip_cnt AS ip_cnt,
	  (SELECT flood.pattern_packets($1, sample_id, $2)) AS pkts
     FROM flood.samples
     JOIN fast.entity_patterns ep ON(ep.entity_id = report_id)
     JOIN (SELECT flood_id,
		  top_hosts_id,
		  pattern_id,
		  side,
		  sum(matches) AS match,
		  min(matches) AS minmatch,
		  COUNT(*) AS ip_cnt
	     FROM flood.samples
	     JOIN fast.top_host_sets ths ON(ths.entity_id = top_hosts_id)
	     JOIN fast.top_hosts USING(ths_id)
	    GROUP BY 1, 2, 3, 4
	  ) AS th USING(flood_id, top_hosts_id, pattern_id)
    WHERE flood_id = $1
      AND pattern_id = $2
  ORDER BY sample_id;
  
  UPDATE temp_flood_attack_type_1 SET pkt_cnt2=pkt_cnt1;
  
  INSERT INTO temp_flood_attack_type_2(sample_id,side,ip_cnt,pkt_cnt1)
   SELECT sample_id,
   side ,
  row[1] AS ip_cnt,
  row[2] AS pkts
     FROM (SELECT sample_id,
   's'::"char" as side,
  (SELECT ARRAY[COUNT(*), SUM(pkts)]::INTEGER[]
     FROM flood.pattern_prevalent_hosts(flood_id,
    sample_id, $2, 's'::"char", true)) AS row
     FROM flood.samples
    WHERE flood_id = $1) AS foo
   WHERE row[1] > 0
   UNION
   SELECT sample_id,
   side ,
  row[1] AS ip_cnt,
  row[2] AS pkts
     FROM (SELECT sample_id,
   'd'::"char" as side,
  (SELECT ARRAY[COUNT(*), SUM(pkts)]::INTEGER[]
     FROM flood.pattern_prevalent_hosts(flood_id,
    sample_id, $2, 'd'::"char", true)) AS row
     FROM flood.samples
    WHERE flood_id = $1) AS foo
   WHERE row[1] > 0
   ORDER BY sample_id ;  
   
   
  UPDATE temp_flood_attack_type_1 type_1 SET ip_cnt=type_2.ip_cnt, pkt_cnt1=type_2.pkt_cnt1
   FROM temp_flood_attack_type_2 type_2 WHERE type_1.sample_id=type_2.sample_id AND type_1.side=type_2.side;
  
  -- calculations on records from
  FOR result_cur IN
   SELECT s1.ip_cnt srcip, s1.pkt_cnt1 srcep, s1.pkt_cnt2 srctp,
         d1.ip_cnt dstip, d1.pkt_cnt1 dstep, d1.pkt_cnt2 dsttp
   FROM temp_flood_attack_type_1 s1, temp_flood_attack_type_1 d1
    WHERE s1.sample_id=d1.sample_id and s1.side='s' and d1.side='d'
  LOOP
     srcip_val := result_cur.srcip;
     srcep_val := result_cur.srcep;
     srctp_val := result_cur.srctp;
     dstip_val := result_cur.dstip;
     dstep_val := result_cur.dstep;
     dsttp_val := result_cur.dsttp;
    
    IF srcip_val = 0 OR dstip_val = 0 THEN
       attack_type_val := NULL;
       ep_val := 0;
       tp_val := 0;
       RAISE EXCEPTION 'source/destination top hosts not found for flood %; pattern %', $1,$2; 
       EXIT;
    END IF; 
     
    IF srcip_val/dstip_val >=20 THEN
       ep_val := ep_val + dstep_val;
       tp_val := tp_val + dsttp_val;
       tmp_attack_type_val := 'DDos';
    ELSIF srcip_val/dstip_val >=10  THEN
       ep_val := ep_val + dstep_val;
       tp_val := tp_val + dsttp_val;
       tmp_attack_type_val := 'Dos';
    ELSIF dstip_val/srcip_val >=10  THEN
       ep_val := ep_val + srcep_val;
       tp_val := tp_val + srctp_val;
       tmp_attack_type_val := 'Scan';    
    END IF;
    
    IF attack_type_val is NULL THEN
       attack_type_val := tmp_attack_type_val;
    ELSIF  tmp_attack_type_val is NOT NULL AND attack_type_val <> tmp_attack_type_val THEN
       attack_type_val := NULL;
       ep_val := 0;
       tp_val := 0;
       EXIT;
    END IF;   
     
  END LOOP;
  
  DROP TABLE temp_flood_attack_type_1;
  DROP TABLE temp_flood_attack_type_2;
      
  RETURN QUERY select  attack_type_val,ep_val,tp_val;
   
   END
$_$;


ALTER FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) IS 'Returns attack type for the flood and the pattern (one of `DoS'', `DDoS'', `Scan'')';


--
-- Name: pattern_hosts(integer, integer, "char"); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char") RETURNS SETOF inet
    LANGUAGE sql STABLE
    AS $_$
  SELECT DISTINCT ip
    FROM flood.samples s
    JOIN fast.top_host_sets ths ON (ths.entity_id = s.top_hosts_id)
    JOIN fast.top_hosts th USING (ths_id)
   WHERE s.flood_id = $1
     AND ths.pattern_id = $2
     AND ths.side = $3
   ORDER BY ip;
$_$;


ALTER FUNCTION flood.pattern_hosts(flood_id integer, pattern_id integer, side "char") OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char"); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char") IS 'Returns IP addresses participating in flood, pattern and side (source or destination)';


--
-- Name: pattern_ip_packets(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) RETURNS SETOF record
    LANGUAGE plpgsql STABLE STRICT
    AS $_$
BEGIN
  RETURN QUERY SELECT * FROM flood.pattern_ip_packets_real($1, NULL, $2);  
  RETURN;
END$_$;


ALTER FUNCTION flood.pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) IS 'Returns `side-ip-number of packets'' pairs for specified flood/pattern pair';


--
-- Name: pattern_ip_packets(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) RETURNS SETOF record
    LANGUAGE plpgsql STABLE STRICT
    AS $_$
BEGIN
  RETURN QUERY SELECT * FROM flood.pattern_ip_packets_real($1, $2, $3);  
  RETURN;
END$_$;


ALTER FUNCTION flood.pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) IS 'Returns `side-ip-number of packets'' pairs for specified flood/sample/patternpair';


--
-- Name: pattern_ip_packets_real(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) RETURNS SETOF record
    LANGUAGE plpgsql STABLE
    AS $_$
BEGIN
  RETURN QUERY
    SELECT ths.side,
           th.ip,
           SUM(ROUND(a.value::INTEGER * ep.matches * th.matches))::INTEGER
      FROM flood.samples s 
      JOIN fast.entity_patterns ep ON (ep.entity_id = s.report_id)
      JOIN fast.attrs            a USING (entity_id)
      JOIN fast.attr_types      at USING (attr_type_id)
      JOIN fast.top_host_sets  ths ON
       ((ths.entity_id, ths.pattern_id) = (s.top_hosts_id, ep.pattern_id))
      JOIN fast.top_hosts       th USING (ths_id)
     WHERE s.flood_id = $1
       AND ($2 IS NULL OR s.sample_id = $2)
       AND ep.pattern_id = $3
       AND at.name = 'Entries'
     GROUP BY 1, 2;

   RETURN;
END$_$;


ALTER FUNCTION flood.pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) IS 'Returns `side-ip-number of packets'' pairs for specified flood/sample/patternor flood/pattern (i.e. sample_id may be NULL)';


--
-- Name: pattern_packets(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_packets(flood_id integer, pattern_id integer) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT flood.pattern_packets_real($1, NULL, $2);
$_$;


ALTER FUNCTION flood.pattern_packets(flood_id integer, pattern_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_packets(flood_id integer, pattern_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_packets(flood_id integer, pattern_id integer) IS 'Returns number of packets matching the pattern in the flood (spanning alltraffic-samples and pattern-reports for which a valid pattern-top-hosts exists)';


--
-- Name: pattern_packets(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT flood.pattern_packets_real($1, $2, $3);
$_$;


ALTER FUNCTION flood.pattern_packets(flood_id integer, sample_id integer, pattern_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer) IS 'Returns number of packets matching the pattern in the flood/sample (NULL ifthe coresponding pattern-top-hosts is invalid)';


--
-- Name: pattern_packets_real(integer, integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) RETURNS integer
    LANGUAGE plpgsql STABLE
    AS $_$
BEGIN
  RETURN pkts FROM (
    SELECT s.flood_id,
	   ep.pattern_id,
	   SUM(ROUND(a.value::INTEGER * ep.matches)) AS pkts
      FROM flood.samples s
      JOIN fast.entity_data         ed  ON (s.top_hosts_id = ed.entity_id)
      JOIN fast.entity_patterns     ep  ON (s.report_id = ep.entity_id)
      JOIN fast.attrs               a   ON (s.report_id = a.entity_id)
      JOIN fast.attr_types          at  USING (attr_type_id)
     WHERE s.flood_id = $1
       AND ($2 IS NULL OR s.sample_id = $2)
       AND ep.pattern_id = $3
       AND ed.error IS NULL
       AND at.name = 'Entries'
     GROUP BY 1, 2) AS foo;
END$_$;


ALTER FUNCTION flood.pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) IS 'Returns number of packets matching the pattern in the flood (spanning allor one traffic-samples and pattern-reports for which a valid pattern-top-hosts
exists)';


--
-- Name: pattern_prevalent_hosts(integer, integer, "char", boolean); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) RETURNS SETOF record
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT * FROM flood.pattern_prevalent_hosts_real($1, NULL, $2, $3, $4)
$_$;


ALTER FUNCTION flood.pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) IS 'Returns ip-number of packets pairs matching the pattern in the flood for source or destination hosts. Number of hosts returned is reduced using data from fgen.percents; if it''s impossible to reduce number of hosts, all hosts are returned';


--
-- Name: pattern_prevalent_hosts(integer, integer, integer, "char", boolean); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) RETURNS SETOF record
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT * FROM flood.pattern_prevalent_hosts_real($1, $2, $3, $4, $5)
$_$;


ALTER FUNCTION flood.pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) IS 'Returns ip-number of packets pairs matching the pattern/sample in the flood for source or destination hosts. Number of hosts returned is reduced using data from fgen.percents; if it''s impossible to reduce number of hosts, all hosts are returned';


--
-- Name: pattern_prevalent_hosts_real(integer, integer, integer, "char", boolean); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) RETURNS SETOF record
    LANGUAGE c STABLE
    AS '/opt/allot/lib/libdetect.so', 'pattern_prevalent_hosts'; --hb


ALTER FUNCTION flood.pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) IS 'Returns ip-number of packets pairs matching the pattern/sample in the flood for source or destination hosts. Number of hosts returned is reduced using data from fgen.percents; if it''s impossible to reduce number of hosts, all hosts are returned';


--
-- Name: pattern_quality_accum(pattern_quality_state, real, real); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_quality_accum(state pattern_quality_state, matches real, deviation real) RETURNS pattern_quality_state
    LANGUAGE sql IMMUTABLE
    AS $_$
  SELECT $1.count + 1,
    $1.sum + LEAST(1, COALESCE(16 * POWER($2 - $3 / (1 + $3), 2), 1));
$_$;


ALTER FUNCTION flood.pattern_quality_accum(state pattern_quality_state, matches real, deviation real) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_quality_accum(state pattern_quality_state, matches real, deviation real); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_quality_accum(state pattern_quality_state, matches real, deviation real) IS '(int) Used by flood.pattern_quality aggregate';


--
-- Name: pattern_quality_final(pattern_quality_state); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION pattern_quality_final(state pattern_quality_state) RETURNS integer
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
  SELECT ROUND((1 - $1.sum / NULLIF($1.count, 0))*10)::INTEGER*10;
$_$;


ALTER FUNCTION flood.pattern_quality_final(state pattern_quality_state) OWNER TO ndbadm;

--
-- Name: FUNCTION pattern_quality_final(state pattern_quality_state); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION pattern_quality_final(state pattern_quality_state) IS '(int) Used by flood.pattern_quality aggregate';


--
-- Name: patterns(integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

-- Create supporting sequence
CREATE SEQUENCE flood.test_fp_seq
	 START WITH 1
     INCREMENT BY 1
     NO MINVALUE
     NO MAXVALUE
     CACHE 1;
      
ALTER TABLE flood.test_fp_seq OWNER TO postgres;
GRANT ALL ON SEQUENCE flood.test_fp_seq TO postgres;
GRANT ALL ON SEQUENCE flood.test_fp_seq TO nms;

CREATE OR REPLACE FUNCTION flood.patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) RETURNS SETOF record
    LANGUAGE plpgsql 
    AS $_$
   DECLARE
    result  record; 
    stam  integer; 
   BEGIN 
    
    CREATE TEMPORARY TABLE temp_flood_patterns (
	 pattern_id integer,
	 sample_count integer,
	 mtg_count integer,
	 last_at timestamp with time zone,
	 quality integer,
	 header_octets integer, 
	 payload_octets integer
	) ON COMMIT DROP; 
    
    stam := pg_catalog.setval('flood.test_fp_seq', 1, false);
    
    INSERT INTO temp_flood_patterns (pattern_id,sample_count, mtg_count, last_at, quality )
     SELECT ep.pattern_id,
        COUNT(ep.entity_id) AS sample_count,
        COUNT(mrl.flood_id) AS mtg_count,
        MAX(s.at) AS last_at,
        flood.pattern_quality(ep.matches,
                substring(s.request FROM 'modelMismatch=([^[:space:]]+)')::REAL)
                AS quality
	  FROM flood.samples s
	  JOIN fast.entity_patterns ep ON (ep.entity_id = s.report_id)
	  LEFT JOIN flood.mtg_reqs_log mrl ON ((mrl.flood_id, mrl.orig_pattern_id) = (s.flood_id, ep.pattern_id))
	  WHERE s.flood_id = $1
	  GROUP BY ep.pattern_id ;
	
	IF NOT FOUND THEN
	 return;
	END IF;      
     
    UPDATE  temp_flood_patterns tfp SET header_octets= (SELECT SUM(CASE WHEN ps.layer > 3 THEN 0 ELSE octet_length(ps.values) END)
								      FROM fast.pat_contents pc
								      JOIN fast.pat_strips ps USING (pat_strip_id)
								     WHERE pc.pattern_id = tfp.pattern_id), 
                                   payload_octets= (SELECT SUM(CASE WHEN ps.layer = 4 THEN octet_length(ps.values) ELSE 0 END)
								      FROM fast.pat_contents pc
								      JOIN fast.pat_strips ps USING (pat_strip_id)
								     WHERE pc.pattern_id = tfp.pattern_id);
    
     RETURN QUERY SELECT nextval('flood.test_fp_seq')::INTEGER ,ft.pattern_id,  ft.sample_count, ft.quality,ft.header_octets, ft.payload_octets 
       FROM (select * from temp_flood_patterns tt
       order by (tt.header_octets*tt.quality) desc, 
           tt.last_at desc, tt.mtg_count desc, tt.payload_octets desc, tt.sample_count desc, tt.pattern_id desc ) ft;
    
    END$_$;      


ALTER FUNCTION flood.patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) OWNER TO ndbadm;

--
-- Name: FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) IS 'Ranks all patterns for a flood; also returns info used in process';


--
-- Name: sample_has_pattern_p(integer, integer); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer) RETURNS boolean
    LANGUAGE plpgsql STABLE STRICT
    AS $$BEGIN
  PERFORM pattern_id
     FROM fast.entity_links el
     JOIN fast.entity_data ON(entity_id = el."to")
     JOIN fast.types USING(type_id)
     JOIN fast.entity_patterns ep USING(entity_id)
    WHERE types.name = 'pattern-report'
      AND "from" = _sample_id
      AND ep.pattern_id = _pattern_id;
  RETURN FOUND;
END$$;


ALTER FUNCTION flood.sample_has_pattern_p(_sample_id integer, _pattern_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer) IS 'Returns true if the given sample has a pattern-report that contains thegiven pattern';




--
-- Name: type_register(text, text); Type: FUNCTION; Schema: flood; Owner: ndbadm
--

CREATE FUNCTION type_register(typename text, typedescr text) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
  row		flood.types%ROWTYPE;

BEGIN
  IF typeName IS NULL THEN RETURN NULL; END IF;
  IF typeDescr = '' THEN typeDescr := NULL; END IF;

  SELECT INTO row * FROM flood.types WHERE name = typeName;

  IF NOT FOUND THEN
    INSERT INTO flood.types(name, descr) VALUES(typeName, typeDescr)
      RETURNING * INTO row;
  ELSIF row.descr IS DISTINCT FROM typeDescr THEN
    UPDATE flood.types SET descr = typeDescr WHERE type_id = row.type_id;
  END IF;

  RETURN row.type_id;
END$$;


ALTER FUNCTION flood.type_register(typename text, typedescr text) OWNER TO ndbadm;

--
-- Name: FUNCTION type_register(typename text, typedescr text); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON FUNCTION type_register(typename text, typedescr text) IS 'Finds or registers a flood type, adjusting its description if necessary';


SET search_path = notify, pg_catalog;

--
-- Name: field_id(integer, text); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION field_id(type_id integer, field_name text) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT field_id FROM notify.fields WHERE type_id = $1 AND name = $2
$_$;


ALTER FUNCTION notify.field_id(type_id integer, field_name text) OWNER TO ndbadm;

--
-- Name: FUNCTION field_id(type_id integer, field_name text); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION field_id(type_id integer, field_name text) IS 'Given type id and field name, returns field id';


--
-- Name: filter_action_importance_check_children_p(integer, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer) RETURNS boolean
    LANGUAGE plpgsql STABLE STRICT
    AS $$
DECLARE
  filterId INTEGER;
  importance INTEGER;
  minImp INTEGER := 3;
  ret BOOLEAN;
BEGIN
  -- Ensure child filters don't have higher importance than imp_in.
  FOR filterId, importance IN
    SELECT f.filter_id, addr::INTEGER
      FROM notify.filters f
      LEFT JOIN notify.filter_targets ft ON(f.filter_id = ft.filter_id
	AND notify.target_type_id(ft.target_id) =
	  public.post_target_type_id('importance'))
      LEFT JOIN notify.targets USING(target_id)
     WHERE parent = filterId_in
  LOOP
    IF importance IS NOT NULL THEN
      IF importance <= imp_in THEN RETURN FALSE; END IF;
    ELSE
      -- Check children if filter doesn't have importance.
      SELECT notify.filter_action_importance_check_children_p(filterId, imp_in)
	INTO ret;
      IF ret = FALSE THEN RETURN FALSE; END IF;
    END IF;
  END LOOP;

  RETURN TRUE;
END$$;


ALTER FUNCTION notify.filter_action_importance_check_children_p(filterid_in integer, imp_in integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer) IS 'Return TRUE if child filiters have higher importance than imp_in';


--
-- Name: filter_action_importance_check_parents_p(integer, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) RETURNS boolean
    LANGUAGE plpgsql STABLE STRICT
    AS $$
DECLARE
  filterId INTEGER := filterId_in;
  importance INTEGER;
BEGIN
  -- Ensure parent filters don't set lower importance than imp_in.
  LOOP
    SELECT parent, addr::INTEGER INTO filterId, importance
      FROM notify.filters f
      LEFT JOIN notify.filter_targets ft ON(f.parent = ft.filter_id
	AND notify.target_type_id(ft.target_id) =
	  public.post_target_type_id('importance'))
      LEFT JOIN notify.targets USING(target_id)
     WHERE f.filter_id = filterId;

    IF NOT FOUND THEN RETURN TRUE; END IF;

    IF importance IS NOT NULL THEN
      RETURN importance < imp_in;
    END IF;
  END LOOP;
END$$;


ALTER FUNCTION notify.filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) IS 'Return TRUE if parent filters have lower importance than imp_in';


--
-- Name: filter_full_name(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_full_name(integer) RETURNS text
    LANGUAGE plpgsql STABLE STRICT
    AS $_$
DECLARE
  full_name TEXT = '';
  id	    INTEGER = $1;
  rec	    RECORD;
BEGIN
  LOOP
    SELECT INTO rec name, parent FROM notify.filters
      WHERE filter_id = id;
    IF full_name = '' THEN
      full_name := rec.name;
    ELSE
      full_name := rec.name || '.' || full_name;
    END IF;

    IF rec.parent IS NULL THEN RETURN full_name; END IF;
    id := rec.parent;
  END LOOP;
END;$_$;


ALTER FUNCTION notify.filter_full_name(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_full_name(integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_full_name(integer) IS 'Return fully qualified filter name, including all parent filters of the filter (if
any)';


--
-- Name: filter_is_leaf(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_is_leaf(filter_id_in integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
BEGIN
  PERFORM filter_id FROM notify.filters
    WHERE parent = filter_id_in;

  RETURN NOT FOUND;
END;$$;


ALTER FUNCTION notify.filter_is_leaf(filter_id_in integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_is_leaf(filter_id_in integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_is_leaf(filter_id_in integer) IS 'Returns TRUE if the filter has no subfilters';


--
-- Name: filter_is_subfilter(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_is_subfilter(integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
DECLARE
  rec   RECORD;
BEGIN
  SELECT INTO rec filter_id, parent FROM notify.filters
    WHERE filter_id = $1;

  IF rec.filter_id IS NULL THEN
    RAISE EXCEPTION 'no such policy: %', $1;
  END IF;

  RETURN rec.parent IS NOT NULL;
END;$_$;


ALTER FUNCTION notify.filter_is_subfilter(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_is_subfilter(integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_is_subfilter(integer) IS 'Returns TRUE if the filter is a subfilter';


--
-- Name: filter_root(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_root(integer) RETURNS integer
    LANGUAGE plpgsql STABLE
    AS $_$
DECLARE
  old	  INTEGER := $1;
  rec	  RECORD;
BEGIN
  LOOP
    SELECT INTO rec parent FROM notify.filters
      WHERE filter_id = old;
    IF rec.parent IS NULL THEN
      RETURN old;
    END IF;
    old := rec.parent;
  END LOOP;
END;$_$;


ALTER FUNCTION notify.filter_root(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_root(integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_root(integer) IS 'Returns the root filter for specified subfilter.';


--
-- Name: filter_subfilters(integer, boolean); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_subfilters(integer, boolean) RETURNS SETOF integer
    LANGUAGE plpgsql STABLE
    AS $_$
DECLARE
  flt_id      ALIAS FOR $1;
  recursive   ALIAS FOR $2;
  rec	      RECORD;
BEGIN
  FOR rec IN SELECT filter_id FROM notify.filters WHERE parent = flt_id LOOP
    RETURN NEXT rec.filter_id;
    IF recursive THEN
      FOR rec IN SELECT filter_subfilters AS filter_id
	  FROM notify.filter_subfilters(rec.filter_id, TRUE) LOOP
	RETURN NEXT rec.filter_id;
      END LOOP;
    END IF;
  END LOOP;

  RETURN;
END;$_$;


ALTER FUNCTION notify.filter_subfilters(integer, boolean) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_subfilters(integer, boolean); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_subfilters(integer, boolean) IS 'Returns immediate filter subfilters or all subfilters if recursive option
is TRUE';


--
-- Name: filter_templates; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE filter_templates (
    filter_id integer NOT NULL,
    type_id integer NOT NULL,
    target_type_id integer NOT NULL,
    template_id integer NOT NULL
);


ALTER TABLE notify.filter_templates OWNER TO ndbadm;

--
-- Name: filter_templates__all_templates(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_templates__all_templates() RETURNS SETOF filter_templates
    LANGUAGE plpgsql STABLE
    AS $$
DECLARE
  rec	RECORD;
  rec2	RECORD;
BEGIN
  -- Get templates for filters.
  FOR rec IN 
  SELECT t.filter_id,
	 t.type_id,
	 t.target_type_id,
	 t.template_id
    FROM notify.filters
    JOIN notify.filter_templates t USING (filter_id, type_id)
    WHERE parent IS NULL
  LOOP
    RETURN NEXT rec;
  END LOOP;

  FOR rec IN SELECT filter_id FROM notify.filters WHERE parent IS NOT NULL
  LOOP
    -- Get templates for subfilters.
    FOR rec2 IN 
    SELECT *
      FROM notify.filter_templates__subfilter_templates(rec.filter_id)
    LOOP
      RETURN NEXT rec2;
    END LOOP;
  END LOOP;

  RETURN;
END;$$;


ALTER FUNCTION notify.filter_templates__all_templates() OWNER TO ndbadm;

--
-- Name: FUNCTION filter_templates__all_templates(); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_templates__all_templates() IS 'Returns filter_templates plus rows for subfilters w/o defined templates
(inferred from parent templates)';


--
-- Name: filter_templates__delete_cascade(integer, integer, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
  rec		    RECORD;
BEGIN
  -- Do nothing if the filter was deleted.
  PERFORM filter_id FROM notify.filters
    WHERE filter_id = _filter_id;
  IF NOT FOUND THEN
    RETURN;
  END IF;

  -- Do nothing if it is a subfilter.
  SELECT INTO rec notify.filter_is_subfilter($1);
  IF rec.filter_is_subfilter THEN
    RETURN;
  END IF;

  -- If "default" template exists, set up "default" as the new
  -- template.
  SELECT INTO rec template_id FROM notify.templates
    WHERE name = 'default'
    AND type_id = _type_id
    AND target_type_id = _target_type_id;
  IF rec.template_id IS NOT NULL THEN
    UPDATE notify.filter_templates
      SET template_id = rec.template_id
      WHERE filter_id = _filter_id
      AND type_id = _type_id
      AND target_type_id = _target_type_id;

    RETURN;
  END IF;

  -- Delete targets.
  DELETE FROM notify.filter_targets
    WHERE filter_id IN (
      SELECT * FROM notify.filter_subfilters($1, TRUE)
      UNION
      SELECT _filter_id
    )
    AND notify.target_type_id(target_id) = _target_type_id;
  
  -- Delete subfilter templates.
  DELETE FROM notify.filter_templates
    WHERE filter_id IN (SELECT * FROM notify.filter_subfilters(_filter_id, TRUE))
      AND target_type_id = _target_type_id;

  RETURN;
END;$_$;


ALTER FUNCTION notify.filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) IS 'Deletes targets and subfilter templates for a given filter';


--
-- Name: filter_templates__purge_targets(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_templates__purge_targets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  PERFORM notify.filter_templates__delete_cascade(
    OLD.filter_id,
    OLD.type_id,
    OLD.target_type_id);
  RETURN OLD;
END$$;


ALTER FUNCTION notify.filter_templates__purge_targets() OWNER TO ndbadm;

--
-- Name: FUNCTION filter_templates__purge_targets(); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_templates__purge_targets() IS 'Calls filter_templates__delete_cascade';


--
-- Name: filter_templates__subfilter_templates(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_templates__subfilter_templates(integer) RETURNS SETOF filter_templates
    LANGUAGE plpgsql STABLE
    AS $_$
DECLARE
  parent	INTEGER;
  rec		notify.filter_templates%ROWTYPE;
  subfilter	BOOLEAN;
  subfilter_id  INTEGER := $1;
  subfilter_type INTEGER;
  target_types	INTEGER[] := ARRAY[-1];
  tmp		INTEGER;
BEGIN
  -- Check that $1 is a valid subfilter.
  SELECT INTO subfilter filter_is_subfilter
    FROM notify.filter_is_subfilter(subfilter_id);
  IF NOT subfilter THEN
    RAISE EXCEPTION 'policy is not nested: %', subfilter_id;
  END IF;

  -- Get templates defined directly in the specified subfilter.
  FOR rec IN SELECT * FROM notify.filter_templates WHERE filter_id = $1 LOOP
    target_types := target_types || rec.target_type_id;
    RETURN NEXT rec;
  END LOOP;

  -- Loop through parents looking for templates.
  SELECT INTO subfilter_type type_id FROM notify.filters
    WHERE filter_id = subfilter_id;
  tmp := subfilter_id;
  LOOP
    SELECT INTO parent filters.parent FROM notify.filters
      WHERE filter_id = tmp;
    IF parent IS NULL THEN RETURN; END IF;

    -- Get parent templates, excluding those target types for which subfilter
    -- has redefined template.
    FOR rec IN
    SELECT subfilter_id,
	   subfilter_type,
	   ft.target_type_id,
	   t2.template_id
      FROM notify.filter_templates ft
      JOIN notify.filters fl ON (ft.filter_id = fl.parent AND fl.filter_id = tmp)
      JOIN notify.templates t ON (ft.template_id = t.template_id)
      JOIN notify.templates t2 ON (t2.name = t.name AND t2.type_id = subfilter_type AND t2.target_type_id = t.target_type_id)
      WHERE NOT (ft.target_type_id = ANY (target_types))
    LOOP
      target_types := target_types || rec.target_type_id;
      RETURN NEXT rec;
    END LOOP;

    tmp := parent;
  END LOOP;
END;$_$;


ALTER FUNCTION notify.filter_templates__subfilter_templates(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_templates__subfilter_templates(integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_templates__subfilter_templates(integer) IS 'Returns filter_templates rows for the given subfilter, including fake rows
if necessary.';


--
-- Name: filter_templates_exists(integer, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_templates_exists(integer, integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
BEGIN
  PERFORM filter_id FROM notify.filter_templates
    WHERE filter_id = $1 AND target_type_id = $2;

  RETURN FOUND;
END;$_$;


ALTER FUNCTION notify.filter_templates_exists(integer, integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_templates_exists(integer, integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_templates_exists(integer, integer) IS 'Returns TRUE if the filter is assigned template for target type';


--
-- Name: filter_type_id(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filter_type_id(integer) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$SELECT type_id FROM notify.filters WHERE filter_id = $1$_$;


ALTER FUNCTION notify.filter_type_id(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filter_type_id(integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filter_type_id(integer) IS 'Given a notification filter identifier, returns its type identifier';


--
-- Name: filters__delete_cascade(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filters__delete_cascade(integer) RETURNS void
    LANGUAGE sql
    AS $_$
  -- Delete subfilters.
  DELETE FROM notify.filters
    WHERE filter_id IN (SELECT * FROM notify.filter_subfilters($1, FALSE));
$_$;


ALTER FUNCTION notify.filters__delete_cascade(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION filters__delete_cascade(integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION filters__delete_cascade(integer) IS 'When filter is deleted, remove its subfilters as well';


--
-- Name: filters__purge_targets(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filters__purge_targets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  PERFORM notify.filters__delete_cascade(OLD.filter_id);
  RETURN OLD;
END;$$;


ALTER FUNCTION notify.filters__purge_targets() OWNER TO ndbadm;

--
-- Name: filters__update_generation(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filters__update_generation() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  IF NEW.generation < 32767 THEN
    NEW.generation := NEW.generation + 1;
  ELSE
    NEW.generation := 0;
  END IF;

  RETURN NEW;
END$$;


ALTER FUNCTION notify.filters__update_generation() OWNER TO ndbadm;

--
-- Name: filters__update_modified(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filters__update_modified() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  IF NEW.modified = OLD.modified AND NEW.modified < CURRENT_TIMESTAMP THEN
    NEW.modified := CURRENT_TIMESTAMP;
  END IF;

  RETURN NEW;
END$$;


ALTER FUNCTION notify.filters__update_modified() OWNER TO ndbadm;

--
-- Name: filters__valid_parent(integer, integer, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION filters__valid_parent(filter integer, filter_type integer, parent integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $$
BEGIN
  -- Filter for a root type?
  IF parent IS NULL THEN
    RETURN 
      notify.type_link_exists(filter_type, NULL, filter_type);
  END IF;

  RETURN filter_type IN
    (SELECT *
       FROM notify.type_with_subtypes(notify.filter_type_id(
         notify.filter_root(parent))));
END;$$;


ALTER FUNCTION notify.filters__valid_parent(filter integer, filter_type integer, parent integer) OWNER TO ndbadm;

--
-- Name: set_event_importance(text, integer, integer, boolean, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) RETURNS boolean
    LANGUAGE plpgsql STRICT SECURITY DEFINER
    AS $$
DECLARE
  eventIdField TEXT;
  impTable TEXT;
  rows INTEGER;
  setByField TEXT;
  setBySQL TEXT := '';
  whereSQL TEXT := '';
BEGIN
  IF eventType = 'flood' THEN
    impTable := 'flood.importance';
    eventIdField := 'flood_id';
  ELSIF eventType = 'quarantine' THEN
    impTable := 'quarantine.importance';
    eventIdField := 'capture_id';
  END IF;

  IF NOT automatic THEN
    setByField := 'uid';
    setBySQL := 'uid = ' || setById || ', filter_id = NULL';
  ELSE
    IF eventImp = 0 THEN
      RAISE EXCEPTION 'Policies are forbidden to set imporance to `ignore''';
    END IF;
    setByField := 'filter_id';
    setBySQL:= 'filter_id = ' || setById;
    whereSQL := ' AND importance < ' || eventImp || ' AND uid IS NULL';
  END IF;

  -- Add new importance record for event eventId.
  BEGIN
    EXECUTE 'INSERT INTO ' || impTable ||
      '(' || eventIdField || ', importance, ' || setByField || ')' ||
      'VALUES(' || eventId || ', ' || eventImp || ', ' || setById || ')';
    RETURN TRUE;
  EXCEPTION WHEN unique_violation THEN
    RAISE DEBUG '% event with id % already exists', eventType, eventId;
  END;

  EXECUTE 'UPDATE ' || impTable ||
            ' SET importance = ' || eventImp || ', ' || setBySQL ||
	  ' WHERE ' || eventIdField || ' = ' || eventId || whereSQL;

  -- Use GET DIAGNOSTICS because FOUND isn't changed by EXECUTE.
  GET DIAGNOSTICS rows = ROW_COUNT;
  RETURN rows > 0;
END$$;


ALTER FUNCTION notify.set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) OWNER TO ndbadm;

--
-- Name: FUNCTION set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) IS 'Set flood or quarantine event importance. Internal use only, please use flood/quarantine.automatic/manual_importance() functions';


--
-- Name: target_addr(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION target_addr(target_id integer) RETURNS text
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT addr FROM notify.targets WHERE target_id = $1
$_$;


ALTER FUNCTION notify.target_addr(target_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION target_addr(target_id integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION target_addr(target_id integer) IS 'Given target identifier, returns target address';


--
-- Name: target_complete(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION target_complete(integer) RETURNS boolean
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT complete FROM notify.targets WHERE target_id = $1
$_$;


ALTER FUNCTION notify.target_complete(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION target_complete(integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION target_complete(integer) IS 'Returns TRUE if address is complete/usable, FALSE otherwise';


--
-- Name: target_type(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION target_type(target_id integer) RETURNS text
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT public.post_target_types.name
    FROM notify.targets
    JOIN public.post_target_types USING(target_type_id)
   WHERE targets.target_id = $1;
$_$;


ALTER FUNCTION notify.target_type(target_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION target_type(target_id integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION target_type(target_id integer) IS 'Given target_id, returns target type name';


--
-- Name: target_type_id(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION target_type_id(target_id integer) RETURNS integer
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
  SELECT target_type_id FROM notify.targets WHERE target_id = $1
$_$;


ALTER FUNCTION notify.target_type_id(target_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION target_type_id(target_id integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION target_type_id(target_id integer) IS 'Returns target type ID of the given target';


--
-- Name: templates__used_templates(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION templates__used_templates() RETURNS SETOF record
    LANGUAGE plpgsql STABLE
    AS $$
DECLARE
  rec	  RECORD;
  result  RECORD;
BEGIN
  FOR rec IN
  SELECT filters.type_id, t.target_type_id, templates.name
    FROM (SELECT DISTINCT filter_targets.filter_id, targets.target_type_id
            FROM notify.filter_targets
	    JOIN notify.targets USING(target_id)) AS t
    JOIN (SELECT * FROM notify.filter_templates__all_templates())
      AS filter_templates USING (filter_id, target_type_id)
    JOIN notify.templates USING (type_id, target_type_id)
    JOIN notify.filters ON (notify.filter_root(t.filter_id) = filters.filter_id)
  LOOP
    FOR result IN
    SELECT * FROM
      (SELECT type_with_subtypes AS type_id FROM
	notify.type_with_subtypes(rec.type_id)) AS subtypes,
      (SELECT rec.target_type_id, rec.name) AS props
    LOOP
      RETURN NEXT result;
    END LOOP;
  END LOOP;

  RETURN;
END;$$;


ALTER FUNCTION notify.templates__used_templates() OWNER TO ndbadm;

--
-- Name: FUNCTION templates__used_templates(); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION templates__used_templates() IS 'Returns (type_id integer, target_type_id integer, name text) list of
templates that have targets that can use them.';


--
-- Name: type_full_name(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION type_full_name(type_id integer) RETURNS text
    LANGUAGE plpgsql STABLE STRICT
    AS $_$
DECLARE
  fullName TEXT;
  rec RECORD;
  tid INTEGER := $1;
BEGIN
  LOOP
    SELECT INTO rec "from" AS parent, name
      FROM notify.type_links
      JOIN notify.types ON (types.type_id = type_links."to")
     WHERE "to" = tid;

    IF fullName IS NULL THEN
      fullName := rec.name; 
    ELSE
      fullName := rec.name || '.' || fullName;
    END IF;

    IF rec.parent IS NULL THEN
      RETURN fullName;
    END IF;

    tid := rec.parent;
  END LOOP;
END$_$;


ALTER FUNCTION notify.type_full_name(type_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION type_full_name(type_id integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION type_full_name(type_id integer) IS 'Return full type name, that includes all of its parents (e.g. flood.pattern)';


--
-- Name: type_id(text); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION type_id(text) RETURNS integer
    LANGUAGE plpgsql STABLE STRICT
    AS $_$
DECLARE
  label TEXT;
  labels TEXT[];
  labelsSize INTEGER;
  parent INTEGER;
BEGIN
  IF position('.' IN $1) = 0 THEN
    RETURN (SELECT type_id FROM notify.types WHERE name = $1);
  END IF;

  SELECT INTO labels, labelsSize
    string_to_array($1, '.'), array_upper(string_to_array($1, '.'), 1);

  FOR n IN 1..labelsSize LOOP
    label := labels[n];
    SELECT INTO parent "to"
      FROM notify.type_links
      JOIN notify.types t ON (t.type_id = "to")
     WHERE "from" IS NOT DISTINCT FROM parent
       AND name = label;
  END LOOP;

  RETURN parent;
END$_$;


ALTER FUNCTION notify.type_id(text) OWNER TO ndbadm;

--
-- Name: FUNCTION type_id(text); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION type_id(text) IS 'Resolves a notification type identifier back to its name';


--
-- Name: type_link_exists(integer, integer, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION type_link_exists(tp integer, f integer, t integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $$
BEGIN
  PERFORM "from"
    FROM notify.type_links
  WHERE type_id = tp
  AND NOT f IS DISTINCT FROM "from"
  AND NOT t IS DISTINCT FROM "to";

  RETURN FOUND;
END;$$;


ALTER FUNCTION notify.type_link_exists(tp integer, f integer, t integer) OWNER TO ndbadm;

--
-- Name: FUNCTION type_link_exists(tp integer, f integer, t integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION type_link_exists(tp integer, f integer, t integer) IS 'Returns true if the from-to link exists';


--
-- Name: type_link_valid(integer, integer, integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION type_link_valid(tp integer, f integer, t integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $$
DECLARE
  rec	    RECORD;
BEGIN
  IF (tp IS NULL) OR (t IS NULL) THEN
    RETURN FALSE;
  END IF;

  -- If root link.
  IF f IS NULL THEN
    IF tp <> t THEN
      RETURN FALSE;
    END IF;

    PERFORM "from"
      FROM notify.type_links
    WHERE tp = type_id AND NOT "from" IS NULL AND "to" = t;

    RETURN NOT FOUND;
  END IF;
      
  -- A regular link. Check whether "from" exists in types
  -- table, "to" is not a root type.
  PERFORM type_id FROM notify.types
    WHERE type_id = f;
  IF NOT FOUND THEN
    RETURN FALSE;
  END IF;

  SELECT INTO rec result FROM 
    (SELECT (NOT notify.type_link_exists(t, NULL, t)) AS result) AS foo;
  RETURN rec.result;
END;$$;


ALTER FUNCTION notify.type_link_valid(tp integer, f integer, t integer) OWNER TO ndbadm;

--
-- Name: FUNCTION type_link_valid(tp integer, f integer, t integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION type_link_valid(tp integer, f integer, t integer) IS 'Returns true if the from-to link is valid';


--
-- Name: type_links__purge_links(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION type_links__purge_links() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  IF OLD."from" IS NULL THEN
    DELETE FROM notify.type_links
      WHERE type_id = OLD."to";
  END IF;
  RETURN OLD;
END;$$;


ALTER FUNCTION notify.type_links__purge_links() OWNER TO ndbadm;

--
-- Name: type_name(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION type_name(integer) RETURNS text
    LANGUAGE sql STABLE STRICT
    AS $_$SELECT name FROM notify.types WHERE type_id = $1$_$;


ALTER FUNCTION notify.type_name(integer) OWNER TO ndbadm;

--
-- Name: type_with_subtypes(integer); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION type_with_subtypes(root integer) RETURNS SETOF integer
    LANGUAGE plpgsql STABLE
    AS $$
DECLARE
  rec	RECORD;
BEGIN
  FOR rec IN SELECT "to" FROM notify.type_links
    WHERE type_id = root
  LOOP
    RETURN NEXT rec."to";
  END LOOP;

  RETURN;
END;$$;


ALTER FUNCTION notify.type_with_subtypes(root integer) OWNER TO ndbadm;

--
-- Name: FUNCTION type_with_subtypes(root integer); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION type_with_subtypes(root integer) IS 'Return the root type and its direct and indirect subtypes';


--
-- Name: update_complete_targets_tbl(); Type: FUNCTION; Schema: notify; Owner: ndbadm
--

CREATE FUNCTION update_complete_targets_tbl() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  -- Assume that the function will be called properly. Do NOT check if it was
  -- called ON DELETE or something like that.

  IF TG_WHEN = 'AFTER' AND NEW.complete THEN
    -- A new complete target was added or existing was updated to be complete.
    -- Propagate to notify.complete_targets.
    IF TG_OP = 'UPDATE' THEN
      IF OLD.complete THEN
	RETURN NEW;
      END IF;
    END IF;

    INSERT INTO notify.complete_targets VALUES(NEW.target_id);
    RETURN NEW;
  END IF;

  IF TG_WHEN = 'BEFORE' AND TG_OP = 'UPDATE' THEN
    -- Target was updated to be incomplete. Remove corresponding ID from
    -- notify.complete_targets.
    IF OLD.complete AND NOT NEW.complete THEN
      DELETE FROM notify.complete_targets WHERE target_id = NEW.target_id;
      RETURN NEW;
    END IF;
  END IF;

  RETURN NEW;
END$$;


ALTER FUNCTION notify.update_complete_targets_tbl() OWNER TO ndbadm;

--
-- Name: FUNCTION update_complete_targets_tbl(); Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON FUNCTION update_complete_targets_tbl() IS 'Update notify.complete_targets by adding newly complete target and removing newly incomplete target';


SET search_path = nx, pg_catalog;

--
-- Name: action(text, inet, integer); Type: FUNCTION; Schema: nx; Owner: ndbadm
--

CREATE FUNCTION action(_action text, _ip inet, _hostlist_id integer) RETURNS void
    LANGUAGE plpgsql STRICT
    AS $$
BEGIN
  LOCK TABLE nx.map IN SHARE ROW EXCLUSIVE MODE;
  UPDATE nx.map
     SET target = _action,
         request_id = request_id + 1
   WHERE ip = _ip
     AND hostlist_id = _hostlist_id;

  -- Ignore requests to delete IP from hostlist if it's not there.
  IF NOT FOUND AND _action = 'add' THEN
    INSERT INTO nx.map(ip, hostlist_id, target, request_id)
      VALUES(_ip, _hostlist_id, _action, 1);
  END IF;
END$$;


ALTER FUNCTION nx.action(_action text, _ip inet, _hostlist_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION action(_action text, _ip inet, _hostlist_id integer); Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON FUNCTION action(_action text, _ip inet, _hostlist_id integer) IS 'Put add or remove request into nx.map. Internal use only, use nx.add_ip() or nx.remove_ip() instead.';


--
-- Name: add_ip(inet, integer); Type: FUNCTION; Schema: nx; Owner: ndbadm
--

CREATE FUNCTION add_ip(ip inet, hostlist_id integer) RETURNS void
    LANGUAGE sql STRICT
    AS $_$
  SELECT nx.action('add', $1, $2);
$_$;


ALTER FUNCTION nx.add_ip(ip inet, hostlist_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION add_ip(ip inet, hostlist_id integer); Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON FUNCTION add_ip(ip inet, hostlist_id integer) IS 'Request IP to be added to host list';


--
-- Name: remove_ip(inet, integer); Type: FUNCTION; Schema: nx; Owner: ndbadm
--

CREATE FUNCTION remove_ip(ip inet, hostlist_id integer) RETURNS void
    LANGUAGE sql STRICT
    AS $_$
  SELECT nx.action('remove', $1, $2);
$_$;


ALTER FUNCTION nx.remove_ip(ip inet, hostlist_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION remove_ip(ip inet, hostlist_id integer); Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON FUNCTION remove_ip(ip inet, hostlist_id integer) IS 'Request IP to be removed from host list';


--
-- Name: rollover_request_id(); Type: FUNCTION; Schema: nx; Owner: ndbadm
--

CREATE FUNCTION rollover_request_id() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  IF NEW.request_id >= 500000 THEN
    NEW.request_id = 1;
  END IF;

  RETURN NEW;
END$$;


ALTER FUNCTION nx.rollover_request_id() OWNER TO ndbadm;

SET search_path = public, pg_catalog;

--
-- Name: array_append2(anyarray, anyelement); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION array_append2(anyarray, anyelement) RETURNS anyarray
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
  SELECT array_append($1, $2)
$_$;


ALTER FUNCTION public.array_append2(anyarray, anyelement) OWNER TO ndbadm;

--
-- Name: cidr_lower(cidr); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION cidr_lower(cidr) RETURNS inet
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
	SELECT host($1::inet)::inet
$_$;


ALTER FUNCTION public.cidr_lower(cidr) OWNER TO ndbadm;

--
-- Name: cidr_upper(cidr); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION cidr_upper(cidr) RETURNS inet
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
	SELECT host(broadcast($1::inet))::inet
$_$;


ALTER FUNCTION public.cidr_upper(cidr) OWNER TO ndbadm;

--
-- Name: coverage_accum(coverage_state, double precision, double precision); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION coverage_accum(state coverage_state, start double precision, length double precision) RETURNS coverage_state
    LANGUAGE sql IMMUTABLE
    AS $_$SELECT GREATEST($1.till, $2 + $3), GREATEST(LEAST($2 + $3 - $1.till, $3), 0) + $1.covered$_$;


ALTER FUNCTION public.coverage_accum(state coverage_state, start double precision, length double precision) OWNER TO ndbadm;

--
-- Name: FUNCTION coverage_accum(state coverage_state, start double precision, length double precision); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION coverage_accum(state coverage_state, start double precision, length double precision) IS '(int) Used in public.coverage aggregate';


--
-- Name: coverage_final(coverage_state); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION coverage_final(state coverage_state) RETURNS double precision
    LANGUAGE sql IMMUTABLE
    AS $_$SELECT $1.covered$_$;


ALTER FUNCTION public.coverage_final(state coverage_state) OWNER TO ndbadm;

--
-- Name: FUNCTION coverage_final(state coverage_state); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION coverage_final(state coverage_state) IS '(int) Used in public.coverage aggregate';

--
-- Name: datatab_set_width(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION datatab_set_width() RETURNS trigger
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
	BEGIN
		IF NEW.width < 4.0 THEN
			SELECT INTO NEW.width
				SUM(COALESCE((1.0 - stanullfrac) * stawidth, CASE WHEN attlen < 1 THEN 1 ELSE attlen END))
				FROM pg_catalog.pg_attribute
				LEFT JOIN pg_catalog.pg_statistic ON (starelid = attrelid AND staattnum = attnum)
				WHERE attrelid = NEW.relid;

			IF NOT FOUND OR NEW.width IS NULL THEN
				RAISE EXCEPTION 'table_id % references nonexistant relid %', NEW.table_id, NEW.relid;
			END IF;
			IF NEW.width < 4.0 THEN
				RAISE EXCEPTION 'table_id % (relid %) has width < 4.0', NEW.table_id, NEW.relid;
			END IF;
		END IF;
		RETURN NEW;
	END
$$;


ALTER FUNCTION public.datatab_set_width() OWNER TO postgres;

--
-- Name: effective_stop_hack(timestamp with time zone, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION effective_stop_hack(timestamp with time zone, timestamp with time zone) RETURNS timestamp with time zone
    LANGUAGE sql IMMUTABLE
    AS $_$
		SELECT COALESCE($2, $1 + '2 weeks'::INTERVAL)
	$_$;


ALTER FUNCTION public.effective_stop_hack(timestamp with time zone, timestamp with time zone) OWNER TO ndbadm;

--
-- Name: FUNCTION effective_stop_hack(timestamp with time zone, timestamp with time zone); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION effective_stop_hack(timestamp with time zone, timestamp with time zone) IS 'Hacks around the slowness of (not indexable) searches for NULLs by shifting the stop of unstopped entries into to the future';


--
-- Name: enforce_sensor_grpmax(); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION enforce_sensor_grpmax() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		DECLARE
			lim INTEGER;
			cur INTEGER;
			hnm TEXT;
		BEGIN
			SELECT INTO hnm name FROM public.hosts WHERE host_id = NEW.host_id;
			SELECT INTO lim max_groups FROM public.hosts WHERE host_id = NEW.host_id;
			IF lim IS NULL THEN
				-- Get data from PARAM table
                lim := public.get_int_param('Group','max_per_sensor');
                IF lim IS NULL THEN
                       RAISE EXCEPTION '%: Group capacity not available', hnm;
                END IF;        
			END IF;

			SELECT INTO cur count(group_id) FROM public.group_mapping WHERE host_id = NEW.host_id;
			IF lim != 0 AND cur >= lim THEN
				RAISE EXCEPTION '%: Group capacity exceeded', hnm;
			END IF;

			RETURN NEW;
		END;
	$$;


ALTER FUNCTION public.enforce_sensor_grpmax() OWNER TO ndbadm;

--
-- Name: grpcfg_box(cidr, timestamp with time zone, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION grpcfg_box(cidr, timestamp with time zone, timestamp with time zone) RETURNS box
    LANGUAGE sql IMMUTABLE
    AS $_$
	SELECT box(public.grpcfg_point(public.cidr_lower($1), $2), public.grpcfg_point(public.cidr_upper($1), $3))
$_$;


ALTER FUNCTION public.grpcfg_box(cidr, timestamp with time zone, timestamp with time zone) OWNER TO ndbadm;

--
-- Name: grpcfg_find(inet, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION grpcfg_find(inet, timestamp with time zone) RETURNS SETOF grpcfg_search_result
    LANGUAGE sql STABLE STRICT
    AS $_$
		SELECT $2 AS at,* FROM public.group_config
			WHERE public.grpcfg_box(prefix, "from", "to")
				&& box(public.grpcfg_point($1,$2), public.grpcfg_point($1,$2))
			  AND ("to" IS NULL OR "to" > $2)
			ORDER BY prefix DESC LIMIT 1;
	$_$;


ALTER FUNCTION public.grpcfg_find(inet, timestamp with time zone) OWNER TO ndbadm;

--
-- Name: grpcfg_find(inet, timestamp with time zone, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION grpcfg_find(addr inet, at timestamp with time zone, inside boolean) RETURNS SETOF grpcfg_search_result
    LANGUAGE plpgsql STABLE
    AS $$
		DECLARE
			row public.grpcfg_search_result%ROWTYPE;
		BEGIN
			SELECT at, pfx.prefix, pfx.group_id, pfx."from", pfx."to", pfx.descr
				 INTO row
				 FROM public.group_config pfx
				 JOIN public.groups USING (group_id)
				WHERE public.grpcfg_box(prefix, "from", "to") &&
					box(public.grpcfg_point(addr,at), public.grpcfg_point(addr,at))
				  AND ("to" IS NULL OR "to" > at)
				  AND f_inside = inside
				ORDER BY prefix DESC LIMIT 1
			;
			
			IF NOT FOUND THEN
				IF inside THEN row.group_id := 901; ELSE row.group_id := 900; END IF;
				row.at       := at;
				row.prefix   := '0.0.0.0/0'::cidr;
				row."from"   := 'epoch'::timestamptz;
				row."to"     := NULL;
				row.descr    := (SELECT descr FROM public.groups WHERE group_id = row.group_id);
			END IF;
			RETURN NEXT row;
			RETURN;
		END
	$$;


ALTER FUNCTION public.grpcfg_find(addr inet, at timestamp with time zone, inside boolean) OWNER TO postgres;

--
-- Name: grpcfg_point(inet, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION grpcfg_point(inet, timestamp with time zone) RETURNS point
    LANGUAGE sql IMMUTABLE
    AS $_$
	SELECT point(
		extract('epoch' FROM COALESCE($2, '2038-01-01 00:00:00+0'::timestamptz)),
		public.inet_to_int8($1)
	);
$_$;


ALTER FUNCTION public.grpcfg_point(inet, timestamp with time zone) OWNER TO ndbadm;

--
-- Name: host_cap_sensor(integer); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION host_cap_sensor(host integer) RETURNS boolean
    LANGUAGE sql STABLE
    AS $_$
  SELECT cap_sensor
    FROM public.hosts
   WHERE host_id = $1$_$;


ALTER FUNCTION public.host_cap_sensor(host integer) OWNER TO ndbadm;

--
-- Name: FUNCTION host_cap_sensor(host integer); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION host_cap_sensor(host integer) IS 'Returns TRUE if the host is capable of being a sensor';


--
-- Name: host_id(text); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION host_id(text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
	DECLARE
		hName	ALIAS FOR $1;
		id	INTEGER;
	BEGIN
		SELECT INTO id host_id FROM public.hosts WHERE name = hName;
		IF NOT FOUND THEN RAISE EXCEPTION '%: unknown host', hName; END IF;
		RETURN id;
	END
$_$;


ALTER FUNCTION public.host_id(text) OWNER TO ndbadm;

--
-- Name: hosts_check_caps(); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION hosts_check_caps() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	BEGIN
		IF TG_OP = 'UPDATE' AND NOT NEW.shutdown THEN
			IF NEW.name != OLD.name THEN
				RAISE '%: Changing name requires shutdown', OLD.name;
			END IF;
			IF NEW.ip != OLD.ip THEN
				RAISE '%: Changing ip-address requires shutdown', OLD.name;
			END IF;
			IF NEW.ssh_key != OLD.ssh_key THEN
				RAISE '%: Changing public-key requires shutdown', OLD.name;
			END IF;

			IF OLD.descr = OLD.name THEN
				NEW.descr := NEW.name;
			END IF;
		END IF;
		RETURN NEW;
	END;
$$;


ALTER FUNCTION public.hosts_check_caps() OWNER TO ndbadm;

--
-- Name: hosts_create_schema(); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION hosts_create_schema() RETURNS trigger
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
	BEGIN
		EXECUTE 'CREATE SCHEMA h' || NEW.host_id::text;
		EXECUTE 'GRANT USAGE ON SCHEMA h' || NEW.host_id::text || ' TO GROUP ndb_readers';
		EXECUTE 'GRANT ALL   ON SCHEMA h' || NEW.host_id::text || ' TO GROUP ndb_writers';
		RETURN NULL;
	END
$$;


ALTER FUNCTION public.hosts_create_schema() OWNER TO ndbadm;

--
-- Name: hosts_drop_schema(); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION hosts_drop_schema() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	BEGIN
		EXECUTE 'DROP SCHEMA h' || OLD.host_id || ' CASCADE';
		RETURN NULL;
	END
$$;


ALTER FUNCTION public.hosts_drop_schema() OWNER TO ndbadm;

--
-- Name: inet_to_int8(inet); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE OR REPLACE FUNCTION inet_to_int8(addr inet) RETURNS bigint
    LANGUAGE plpgsql
    AS $$
    DECLARE
     ip_numeric numeric;
    BEGIN
     EXECUTE format('SELECT inet %L - %L', addr, '0.0.0.0') into ip_numeric;
      return ip_numeric;
  END
$$;


ALTER FUNCTION public.inet_to_int8(addr inet) OWNER TO ndbadm;

--
-- Name: log_min_duration_statement(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION log_min_duration_statement(ms integer) RETURNS void
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
DECLARE
  msDflt INTERVAL;
  msNew  INTERVAL := ms / 1000.0;
  zero   INTERVAL := '0'::INTERVAL;

BEGIN
  RESET log_min_duration_statement;
  IF msNew IS NULL THEN RETURN; END IF;

  SHOW log_min_duration_statement INTO msDflt;

  IF msNew < zero OR (msDflt >= zero AND msNew >= msDflt) THEN
    EXECUTE 'SET log_min_duration_statement = ' || pg_catalog.quote_literal(ms);
    RETURN;
  END IF;

  IF msDflt < zero THEN
    RAISE EXCEPTION 'Logging statements by duration is disabled by default';
  ELSE
    RAISE EXCEPTION 
      'Won''t set minimum duration of logged statements below the default %ms',
      EXTRACT(EPOCH FROM msDflt) * 1000;
  END IF;
END
$$;


ALTER FUNCTION public.log_min_duration_statement(ms integer) OWNER TO postgres;

--
-- Name: FUNCTION log_min_duration_statement(ms integer); Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON FUNCTION log_min_duration_statement(ms integer) IS 'Lets non-superusers relax log_min_duration_statement setting for the session';


--
-- Name: pg_freespace(regclass); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION pg_freespace(rel regclass, OUT blkno bigint, OUT avail smallint) RETURNS SETOF record
    LANGUAGE sql
    AS $_$
  SELECT blkno, pg_freespace($1, blkno) AS avail
  FROM generate_series(0, pg_relation_size($1) / current_setting('block_size')::bigint - 1) AS blkno;
$_$;


ALTER FUNCTION public.pg_freespace(rel regclass, OUT blkno bigint, OUT avail smallint) OWNER TO postgres;

--
-- Name: pg_freespace(regclass, bigint); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION pg_freespace(regclass, bigint) RETURNS smallint
    LANGUAGE c STRICT
    AS '$libdir/pg_freespacemap', 'pg_freespace';


ALTER FUNCTION public.pg_freespace(regclass, bigint) OWNER TO postgres;

--
-- Name: post_target_type_id(text); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION post_target_type_id(name text) RETURNS integer
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT target_type_id
    FROM public.post_target_types
   WHERE name = $1
$_$;


ALTER FUNCTION public.post_target_type_id(name text) OWNER TO ndbadm;

--
-- Name: FUNCTION post_target_type_id(name text); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION post_target_type_id(name text) IS 'Resolves a target type identifier back to its name';


--
-- Name: post_target_type_multiple(integer); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION post_target_type_multiple(target_type_id integer) RETURNS boolean
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
  SELECT multiple FROM public.post_target_types WHERE target_type_id = $1
$_$;


ALTER FUNCTION public.post_target_type_multiple(target_type_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION post_target_type_multiple(target_type_id integer); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION post_target_type_multiple(target_type_id integer) IS 'Returns TRUE if it''s allowed to have multiple actions of this type in single filter';


--
-- Name: query_stat_data(text,text[], integer[]); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION query_stat_data(tbl text, colmn text[], points integer[]) RETURNS SETOF record
    LANGUAGE plpgsql
    AS $_$
    DECLARE
    timestamp_val integer;
    result        record;
    colmn_str   text;
	select_part text;
    select_down text;
    select_up text;
    BEGIN
     
     colmn_str := array_to_string(colmn, ',');
     select_part := format ('(select %s from %s where ',colmn_str,tbl);
     
     FOREACH timestamp_val in ARRAY points
     LOOP
      select_down := select_part || format('timestamp <= %L ORDER BY timestamp DESC LIMIT 1) UNION ',timestamp_val);
      select_up   := select_part || format('timestamp >  %L ORDER BY timestamp ASC LIMIT 1) ',timestamp_val);
      
       FOR result IN EXECUTE select_down || select_up
        LOOP
        RETURN NEXT result;
       END LOOP;
       
      END LOOP;
     
    END$_$;     


ALTER FUNCTION public.query_stat_data(tbl text, colmn text[], points integer[]) OWNER TO ndbadm;

--
-- Name: set_modified(); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION set_modified() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
  BEGIN
    NEW.modified :=
      COALESCE(NULLIF(NEW.modified, OLD.modified), CURRENT_TIMESTAMP);
    RETURN NEW;
  END$$;


ALTER FUNCTION public.set_modified() OWNER TO ndbadm;

--
-- Name: FUNCTION set_modified(); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION set_modified() IS 'Sets `modified'' column to current time when a row update does not change it explicitly';


--
-- Name: stat_drop_data(); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION stat_drop_data() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
		relname TEXT;
		nspname TEXT;
		typnm   TEXT;
	BEGIN
		SELECT INTO nspname,relname,typnm
			      'h' || OLD.host_id,
			      s.name || OLD.group_id,
			      st.name
			 FROM public.structs      s
			 JOIN public.struct_types st USING (type_id)
			WHERE struct_id = OLD.struct_id;

		IF typnm = 'stat' THEN
			EXECUTE 'DROP TABLE IF EXISTS ' || nspname || '.' || relname || ' CASCADE';
		END IF;
		RETURN OLD;
	END
$$;


ALTER FUNCTION public.stat_drop_data() OWNER TO ndbadm;

--
-- Name: stat_struct(integer); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION stat_struct(stat integer) RETURNS text
    LANGUAGE sql STABLE
    AS $_$
  SELECT structs.name
    FROM public.statistics
    JOIN public.structs USING(struct_id)
   WHERE stat_id = $1$_$;


ALTER FUNCTION public.stat_struct(stat integer) OWNER TO ndbadm;

--
-- Name: FUNCTION stat_struct(stat integer); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION stat_struct(stat integer) IS 'Returns structure name to which given stat belongs';


--
-- Name: subsystem_alive(integer); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION subsystem_alive(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
  -- Expire in 600 seconds, i.e. 10 minutes.
  UPDATE public.subsystems
    SET alive = CURRENT_TIMESTAMP + '600'::INTERVAL
    WHERE subsystem_id = $1;

  -- Return the suggested delay until the next heartbeat in seconds.
  SELECT 300$_$;


ALTER FUNCTION public.subsystem_alive(integer) OWNER TO ndbadm;

--
-- Name: subsystem_cookie(integer); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION subsystem_cookie(integer) RETURNS text
    LANGUAGE sql STABLE STRICT
    AS $_$SELECT cookie FROM public.subsystems WHERE subsystem_id = $1$_$;


ALTER FUNCTION public.subsystem_cookie(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION subsystem_cookie(integer); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION subsystem_cookie(integer) IS 'Resolves subsystem ID to subsystem cookie.';


--
-- Name: subsystem_register(text, integer, text); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION subsystem_register(text, integer, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
  sName		ALIAS FOR $1;
  sHostID	public.hosts.host_id%TYPE := $2;
  sCookie	ALIAS FOR $3;

  id		public.subsystems.subsystem_id%TYPE;
  newAlive	public.subsystems.alive%TYPE := 
		CURRENT_TIMESTAMP + '600'::INTERVAL;
  newCookie	public.subsystems.cookie%TYPE :=
		pg_catalog.pg_backend_pid() || '~' ||
		sName || '~' ||
		sHostID || '~' ||
		CURRENT_TIMESTAMP;

BEGIN
  IF sHostID IS NULL THEN
    SELECT INTO sHostID host_id FROM public.hosts WHERE is_hydra;
  END IF;

     UPDATE public.subsystems
	SET alive = newAlive,
	    cookie = newCookie
      WHERE name = sName
	AND host_id = sHostID
	AND (alive < CURRENT_TIMESTAMP OR cookie = sCookie)
  RETURNING subsystem_id INTO id;

  IF FOUND THEN RETURN id; END IF;

  SELECT INTO id subsystem_id
    FROM public.subsystems
   WHERE name = sName AND host_id = sHostID;

  IF FOUND THEN
    RAISE EXCEPTION
      'subsystem `%'' is `alive'', another instance running?', sName;
  END IF;

  INSERT INTO public.subsystems(name, host_id, alive, cookie)
       VALUES (sName, sHostID, newAlive, newCookie)
    RETURNING subsystem_id INTO id;

  RETURN id;
END$_$;


ALTER FUNCTION public.subsystem_register(text, integer, text) OWNER TO ndbadm;

--
-- Name: subsystem_register(text, text, text); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION subsystem_register(text, text, text) RETURNS integer
    LANGUAGE sql
    AS $_$
  SELECT public.subsystem_register($1,
    CASE WHEN $2 IS NULL THEN NULL ELSE public.host_id($2) END, $3);
$_$;


ALTER FUNCTION public.subsystem_register(text, text, text) OWNER TO ndbadm;

--
-- Name: subsystem_stop(integer); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION subsystem_stop(integer) RETURNS void
    LANGUAGE sql
    AS $_$
  UPDATE public.subsystems
    SET alive = CURRENT_TIMESTAMP
    WHERE subsystem_id = $1;
$_$;


ALTER FUNCTION public.subsystem_stop(integer) OWNER TO ndbadm;

--
-- Name: timestamp_hour(timestamp with time zone); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION timestamp_hour(ts timestamp with time zone) RETURNS integer
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
  SELECT EXTRACT(EPOCH FROM DATE_TRUNC('hour', $1))::INTEGER
$_$;


ALTER FUNCTION public.timestamp_hour(ts timestamp with time zone) OWNER TO ndbadm;

SET search_path = purge, pg_catalog;

--
-- Name: rules; Type: TABLE; Schema: purge; Owner: ndbadm; Tablespace: 
--

CREATE TABLE rules (
    rule_id integer NOT NULL,
    rel text NOT NULL,
    key text[] NOT NULL,
    targrel text NOT NULL,
    targkey text[] NOT NULL
);


ALTER TABLE purge.rules OWNER TO ndbadm;

--
-- Name: rule_check(rules); Type: FUNCTION; Schema: purge; Owner: ndbadm
--

CREATE FUNCTION rule_check(rule rules) RETURNS boolean
    LANGUAGE plpgsql STABLE STRICT
    AS $$
		DECLARE
			rels    TEXT[][] = ARRAY[string_to_array(rule.rel, '.'), string_to_array(rule.targrel, '.')];
			keys	TEXT[][] = ARRAY[rule.key, rule.targkey];
			relid	OID;
			num	INT2;
			i	INTEGER;
			j	INTEGER;
		BEGIN
			FOR i IN 1..2 LOOP
				SELECT c.oid INTO relid FROM pg_class c, pg_namespace n WHERE nspname=rels[i][1] AND relname=rels[i][2] AND n.oid = relnamespace;
				IF NOT FOUND THEN
					RAISE EXCEPTION 'relation "%.%" does not exist', rels[i][1], rels[i][2];
				END IF;

				j := array_lower(keys, 2);
				WHILE j <= array_upper(keys, 2) LOOP
					SELECT attnum INTO num FROM pg_attribute WHERE attrelid = relid AND attname = keys[i][j];
					IF NOT FOUND THEN
						RAISE EXCEPTION 'column "%" does not exist in relation "%.%"', keys[i][j], rels[i][1], rels[i][2];
					END IF;
					j := j + 1;
				END LOOP;
			END LOOP;
			RETURN TRUE;
		END
	$$;


ALTER FUNCTION purge.rule_check(rule rules) OWNER TO ndbadm;

SET search_path = quarantine, pg_catalog;

--
-- Name: automatic_importance(integer, integer, integer); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer) RETURNS boolean
    LANGUAGE sql STRICT
    AS $_$
  SELECT notify.set_event_importance('quarantine'::TEXT, $1, $2, TRUE, $3);
$_$;


ALTER FUNCTION quarantine.automatic_importance(capture_id integer, importance integer, filter_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer); Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer) IS 'Set quarantine importance, note filter as request source. Importance is set only if current importance wasn''t set by a user and current importance is lower than the importance to be set';


--
-- Name: capture_duration_nonzero(); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION capture_duration_nonzero() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN      
        IF NEW.duration = '00:00:00' THEN
           NEW.duration := '00:00:00.001';
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION quarantine.capture_duration_nonzero() OWNER TO ndbadm;

--
-- Name: capture_exists_p(integer); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION capture_exists_p(integer) RETURNS boolean
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT COUNT(capture_id) > 0
    FROM quarantine.captures
   WHERE capture_id = $1
$_$;


ALTER FUNCTION quarantine.capture_exists_p(integer) OWNER TO ndbadm;

--
-- Name: FUNCTION capture_exists_p(integer); Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON FUNCTION capture_exists_p(integer) IS 'Determines if a particular capture exists';


--
-- Name: last_capture(integer); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION last_capture(user_id integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
BEGIN
  RETURN (SELECT c.capture_id
    FROM quarantine.captures c
    JOIN quarantine.importance i USING (capture_id)
   WHERE quarantine.source(c.*) = $1::TEXT
     AND i.importance > 0
ORDER BY "timestamp" DESC LIMIT 1);
END$_$;


ALTER FUNCTION quarantine.last_capture(user_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION last_capture(user_id integer); Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON FUNCTION last_capture(user_id integer) IS 'Finds the latest Quarantine detection for a subscriber';


--
-- Name: manual_importance(integer, integer, integer); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION manual_importance(capture_id integer, importance integer, uid integer) RETURNS boolean
    LANGUAGE sql STRICT
    AS $_$
  SELECT notify.set_event_importance('quarantine'::TEXT, $1, $2, FALSE, $3);
$_$;


ALTER FUNCTION quarantine.manual_importance(capture_id integer, importance integer, uid integer) OWNER TO ndbadm;

--
-- Name: FUNCTION manual_importance(capture_id integer, importance integer, uid integer); Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON FUNCTION manual_importance(capture_id integer, importance integer, uid integer) IS 'Set quarantine importance, note user as request source';


--
-- Name: prevalent_activity_name(integer); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION prevalent_activity_name(capture_id integer) RETURNS text
    LANGUAGE sql
    AS $_$SELECT et.name
    FROM quarantine.captures	c
	JOIN quarantine.events		e  USING (capture_id)
	JOIN quarantine.event_types et USING (type_id)
   WHERE capture_id = $1
GROUP BY et.name
ORDER BY SUM(e.flows)   DESC,
		 SUM(e.packets) DESC,
		 SUM(e.bytes)   DESC,
		 et.name
   LIMIT 1$_$;


ALTER FUNCTION quarantine.prevalent_activity_name(capture_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION prevalent_activity_name(capture_id integer); Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON FUNCTION prevalent_activity_name(capture_id integer) IS 'Finds name of main misbehaviour type of a Quarantine detection';


--
-- Name: samples__set_source(); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION samples__set_source() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
      IF NEW.addr IS NULL THEN
        SELECT addr, user_id INTO NEW.addr, NEW.user_id
          FROM quarantine.captures
          WHERE capture_id = NEW.capture_id
        ;
      END IF;
      RETURN NEW;
    END;
  $$;


ALTER FUNCTION quarantine.samples__set_source() OWNER TO ndbadm;

--
-- Name: captures; Type: TABLE; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE TABLE captures (
    capture_id integer NOT NULL,
    subsystem_id integer NOT NULL,
    "timestamp" timestamp with time zone NOT NULL,
    modified timestamp with time zone DEFAULT now() NOT NULL,
    addr inet NOT NULL,
    group_id integer NOT NULL,
    duration interval NOT NULL,
    flows integer NOT NULL,
    packets integer NOT NULL,
    bytes integer NOT NULL,
    fast_id integer NOT NULL,
    user_id integer
);


ALTER TABLE quarantine.captures OWNER TO ndbadm;

--
-- Name: TABLE captures; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON TABLE captures IS 'Catalogue of flow captures';


--
-- Name: COLUMN captures.capture_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.capture_id IS 'Unique identifier of the flow capture';


--
-- Name: COLUMN captures.subsystem_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.subsystem_id IS 'Submitter of the flow capture';


--
-- Name: COLUMN captures."timestamp"; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures."timestamp" IS 'When the flow capture ended';


--
-- Name: COLUMN captures.modified; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.modified IS 'When the flow capture was submitted (auto, srv)';


--
-- Name: COLUMN captures.addr; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.addr IS 'IP address of the source';


--
-- Name: COLUMN captures.group_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.group_id IS 'Subnet group of the source';


--
-- Name: COLUMN captures.duration; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.duration IS 'Duration of the flow capture';


--
-- Name: COLUMN captures.flows; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.flows IS 'Count of distinct flows in the capture';


--
-- Name: COLUMN captures.packets; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.packets IS 'Total packet count for all the flow capture';


--
-- Name: COLUMN captures.bytes; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.bytes IS 'Total byte count for all the flow capture';


--
-- Name: COLUMN captures.fast_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.fast_id IS 'FAST document containing the flow capture';


--
-- Name: COLUMN captures.user_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN captures.user_id IS 'Name of the subscriber representing the source';


--
-- Name: source(captures); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION source(captures) RETURNS text
    LANGUAGE sql IMMUTABLE
    AS $_$SELECT quarantine.source($1.user_id, $1.addr)$_$;


ALTER FUNCTION quarantine.source(captures) OWNER TO ndbadm;

--
-- Name: source(integer, inet); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION source(user_id integer, addr inet) RETURNS text
    LANGUAGE sql IMMUTABLE
    AS $_$SELECT COALESCE($1::TEXT, $2::TEXT)$_$;


ALTER FUNCTION quarantine.source(user_id integer, addr inet) OWNER TO ndbadm;

--
-- Name: sources_period_overlap(integer, integer, timestamp with time zone, timestamp with time zone); Type: FUNCTION; Schema: quarantine; Owner: ndbadm
--

CREATE FUNCTION sources_period_overlap(subsystem_id integer, group_id integer, since timestamp with time zone, until timestamp with time zone) RETURNS boolean
    LANGUAGE sql STABLE STRICT
    AS $_$
  SELECT COUNT(*) > 0
    FROM quarantine.sources
   WHERE subsystem_id = $1
     AND group_id = $2
     AND (
       (since >= $3 AND since < $4)
       OR (until > $3 AND until <= $4)
       OR (since < $3 AND until > $4)
     )
$_$;


ALTER FUNCTION quarantine.sources_period_overlap(subsystem_id integer, group_id integer, since timestamp with time zone, until timestamp with time zone) OWNER TO ndbadm;

--
-- Name: FUNCTION sources_period_overlap(subsystem_id integer, group_id integer, since timestamp with time zone, until timestamp with time zone); Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON FUNCTION sources_period_overlap(subsystem_id integer, group_id integer, since timestamp with time zone, until timestamp with time zone) IS 'Returns TRUE if an overlapping period (with the given one) exists within quarantine.sources';


SET search_path = smp, pg_catalog;

--
-- Name: action(integer, integer, text, integer, integer); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION action(_user_id integer, _action integer, _action_param text, _uid integer, _filter_id integer) RETURNS void
    LANGUAGE plpgsql
    AS $$DECLARE
  _action_expire smp.mtg_reqs.action_expire%TYPE;
  fizzle	BOOLEAN;

BEGIN
  -- Avoid races.
  PERFORM smp.mtg_lock();

  -- Do nothing if:
  --  - the subscriber has been deleted;
  --  - we're processing an automatic action, and there's been a manual action;
  --  - there's an `action from the future' already committed (a parallel
  --    transaction that had begun earlier completed before the current).
  -- At the same time, lock the corresponding smp.users row from changes.
   SELECT u.deleted
       OR _uid IS NULL AND r.uid IS NOT NULL
       OR r.action_since >= CURRENT_TIMESTAMP
     INTO fizzle
     FROM smp.users    u
LEFT JOIN smp.mtg_reqs r USING (user_id)
    WHERE user_id = _user_id
     FOR SHARE OF u;
  IF fizzle THEN RETURN; END IF;

  -- Process the SMP service plan timeout, if needed.
  -- NULLify _action_param unless _action is the special `recommend' SMP plan.
  SELECT CURRENT_TIMESTAMP + (string_to_array(t.addr, '\t'))[2]::INTERVAL,
	 CASE WHEN t.name = 'recommend' THEN _action_param ELSE NULL END
    INTO _action_expire, _action_param
    FROM notify.targets t
   WHERE t.target_id = _action;

  -- Try updating the request, if one exists.
  UPDATE smp.mtg_reqs
     SET filter_id	= _filter_id,
	 uid		= _uid,
	 action		= _action,
	 action_since	= DEFAULT,
	 action_expire	= _action_expire,
	 action_param	= _action_param
   WHERE user_id = _user_id;
  IF FOUND THEN RETURN; END IF;

  -- Create the request.
  INSERT INTO smp.mtg_reqs
	( user_id,  filter_id,  uid,  action,  action_expire,  action_param)
  VALUES(_user_id, _filter_id, _uid, _action, _action_expire, _action_param);
END$$;


ALTER FUNCTION smp.action(_user_id integer, _action integer, _action_param text, _uid integer, _filter_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION action(_user_id integer, _action integer, _action_param text, _uid integer, _filter_id integer); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION action(_user_id integer, _action integer, _action_param text, _uid integer, _filter_id integer) IS 'Submits/revokes HBAD mitigation requests (int)';


--
-- Name: automatic_action(integer, integer, text, integer); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION automatic_action(_user_id integer, _action integer, _action_param text, _filter_id integer) RETURNS void
    LANGUAGE sql
    AS $_$SELECT smp.action($1, $2, $3, NULL, $4)$_$;


ALTER FUNCTION smp.automatic_action(_user_id integer, _action integer, _action_param text, _filter_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION automatic_action(_user_id integer, _action integer, _action_param text, _filter_id integer); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION automatic_action(_user_id integer, _action integer, _action_param text, _filter_id integer) IS 'For Informer, to submit automatic HBAD mitigation requests';


--
-- Name: manual_action(integer, integer, text, integer); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION manual_action(_user_id integer, _action integer, _action_param text, _uid integer) RETURNS void
    LANGUAGE sql SECURITY DEFINER
    AS $_$SELECT smp.action($1, $2, $3, $4, NULL)$_$;


ALTER FUNCTION smp.manual_action(_user_id integer, _action integer, _action_param text, _uid integer) OWNER TO ndbadm;

--
-- Name: FUNCTION manual_action(_user_id integer, _action integer, _action_param text, _uid integer); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION manual_action(_user_id integer, _action integer, _action_param text, _uid integer) IS 'For Web UI, to submit/revoke manual or revoke automatic HBAD mitigation requests';


--
-- Name: mtg_live__aggregate(); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION mtg_live__aggregate() RETURNS trigger
    LANGUAGE plpgsql
    AS $$DECLARE
  _state_details smp.mtg_live.state_details%TYPE;
  _state_id	smp.mtg_states.state_id%TYPE;
  _state_since	smp.mtg_live.state_since%TYPE;
  _user_id	smp.users.user_id%TYPE;

BEGIN
  IF TG_OP = 'DELETE' THEN
    _user_id := OLD.user_id;
  ELSIF TG_OP = 'INSERT' THEN
    _user_id := NEW.user_id;
  ELSE -- UPDATE
    _user_id := NEW.user_id;
    IF NEW.user_id <> OLD.user_id THEN
      RAISE EXCEPTION '% to %.% can''t change user_id',
	TG_OP, TG_TABLE_SCHEMA, TG_TABLE_NAME;
    END IF;
  END IF;

  -- Obtain the highest order state for the subscriber.  Consider the latest
  -- states for all involved SMPs since the last mitigation request.
  SELECT  state_id,  state_details,  state_since
    INTO _state_id, _state_details, _state_since
    FROM (SELECT DISTINCT ON (smp_id)
		 smp_id, state_id, state_details, state_since
	    FROM smp.mtg_live_log
	   WHERE user_id = _user_id
	     AND state_since >=
		 (SELECT action_since
		    FROM smp.mtg_reqs
		   WHERE user_id = _user_id)
   ORDER BY smp_id, state_since DESC) last
    JOIN smp.mtg_states s USING (state_id)
   ORDER BY s.order DESC, state_id, state_details, state_since;

  -- Update the aggregated state for the subscriber, if:
  -- - the subscriber isn't marked deleted;
  -- - the aggregated state has changed.
  UPDATE smp.users
     SET ( state_id,  state_details,  state_since) =
	 (_state_id, _state_details, _state_since)
   WHERE user_id = _user_id
     AND NOT deleted
     AND ( state_id,  state_details) IS DISTINCT FROM
	 (_state_id, _state_details);

  RETURN NULL;
END$$;


ALTER FUNCTION smp.mtg_live__aggregate() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_live__aggregate(); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_live__aggregate() IS 'Aggregates per-SMP states from smp.mtg_live to smp.users (int)';


--
-- Name: mtg_live_apply(integer, integer, integer, timestamp with time zone, text, boolean); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION mtg_live_apply(_user_id integer, _smp_id integer, _action integer, _action_expire timestamp with time zone, _action_param text, _action_none boolean) RETURNS void
    LANGUAGE plpgsql
    AS $$BEGIN
  -- NB!  _action_none parameter is:
  --  - FALSE when _action IS NOT NULL;
  --  - TRUE  when _action IS NULL because of an explicit request of no action;
  --  - NULL  when _action IS NULL because of no current request present.

  -- An action requested?
  IF _action_none IS FALSE THEN
    -- Try updating the current live request.
    UPDATE smp.mtg_live
       SET ( action,  action_expire,  action_param) =
	   (_action, _action_expire, _action_param),
	   (state_since, refresh) = (DEFAULT, DEFAULT)
     WHERE (user_id, smp_id) = (_user_id, _smp_id);
    IF FOUND THEN RETURN; END IF;

    -- Create a new live request.
    INSERT INTO smp.mtg_live(user_id, smp_id, action, action_expire, action_param)
    VALUES(_user_id, _smp_id, _action, _action_expire, _action_param);
    RETURN;
  END IF;

  -- No current requests or an explicit request of no action.  Fake an expiry.
  _action_expire :=
    CASE WHEN _action_none THEN 'EPOCH' ELSE CURRENT_TIMESTAMP END;

  -- Try disabling the current live request, if one exists.
  UPDATE smp.mtg_live
     SET action_expire = _action_expire,
	 state_since	 = DEFAULT,
	 refresh	 = DEFAULT
   WHERE (user_id, smp_id) = (_user_id, _smp_id);

  -- No current live request for the SMP upon an explicit request of no action?
  IF NOT FOUND AND _action_none THEN
    -- Clear the state cache for the subscriber.  Leave a hot state alone,
    -- though: other SMPs may have current live requests at the same time.
    UPDATE smp.users u
       SET (state_id, state_details, state_since) = (NULL, NULL, NULL)
      FROM smp.mtg_states s
     WHERE u.user_id = _user_id AND NOT u.deleted
       AND s.state_id = u.state_id AND NOT s.hot;
  END IF;
END$$;


ALTER FUNCTION smp.mtg_live_apply(_user_id integer, _smp_id integer, _action integer, _action_expire timestamp with time zone, _action_param text, _action_none boolean) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_live_apply(_user_id integer, _smp_id integer, _action integer, _action_expire timestamp with time zone, _action_param text, _action_none boolean); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_live_apply(_user_id integer, _smp_id integer, _action integer, _action_expire timestamp with time zone, _action_param text, _action_none boolean) IS 'Make a current mitigation request live (int)';


--
-- Name: mtg_live_clear_smp(integer); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION mtg_live_clear_smp(_smp_id integer) RETURNS void
    LANGUAGE plpgsql
    AS $$BEGIN
  -- Avoid races.
  PERFORM smp.mtg_lock();

  PERFORM smp.mtg_live_apply(user_id, smp_id, NULL, NULL, NULL, TRUE)
     FROM smp.mtg_live
    WHERE smp_id = _smp_id
      AND (action_expire IS NULL OR action_expire > CURRENT_TIMESTAMP);
END$$;


ALTER FUNCTION smp.mtg_live_clear_smp(_smp_id integer) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_live_clear_smp(_smp_id integer); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_live_clear_smp(_smp_id integer) IS 'For CLI, to stop using an SMP server for ongoing HBAD mitigation';


--
-- Name: mtg_live_set_state(integer, integer, text, text); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION mtg_live_set_state(_user_id integer, _smp_id integer, _state_id text, _state_details text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$BEGIN
  -- Avoid races.
  PERFORM smp.mtg_lock();

  -- Remove the refresh bit, set the state and details.  Retain state_since if
  -- the state or details don't change, preventing gaps in smp.mtg_live_log.
  UPDATE smp.mtg_live
     SET refresh        = FALSE,
         state_id       = _state_id,
         state_details  = _state_details,
         state_since    =
	   CASE WHEN ( state_id,  state_details)
	             IS NOT DISTINCT FROM
		     (_state_id, _state_details)
	   THEN state_since
	   ELSE CURRENT_TIMESTAMP
	   END
   WHERE (user_id, smp_id) = (_user_id, _smp_id);
  IF NOT FOUND THEN RETURN FALSE; END IF;

  -- Automatically DELETE non-hot states.
  DELETE FROM smp.mtg_live l
   USING smp.mtg_states    s
   WHERE (l.user_id, l.smp_id, l.state_id) = (_user_id, _smp_id, s.state_id)
     AND NOT s.hot;
  RETURN NOT FOUND;

  -- The result of the function is whether the state of the affected
  -- subscriber/SMP pair [still] exists in smp.mtg_live.
END$$;


ALTER FUNCTION smp.mtg_live_set_state(_user_id integer, _smp_id integer, _state_id text, _state_details text) OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_live_set_state(_user_id integer, _smp_id integer, _state_id text, _state_details text); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_live_set_state(_user_id integer, _smp_id integer, _state_id text, _state_details text) IS 'For HBAD mitigation connectivity daemon, to advance live request state';


--
-- Name: mtg_lock(); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION mtg_lock() RETURNS void
    LANGUAGE sql
    AS $$LOCK TABLE smp.mtg_live, smp.mtg_reqs IN EXCLUSIVE MODE$$;


ALTER FUNCTION smp.mtg_lock() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_lock(); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_lock() IS 'Avoids races on modifying smp.mtg_live and smp.mtg_reqs tables (int)';


--
-- Name: mtg_reqs__propagate(); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION mtg_reqs__propagate() RETURNS trigger
    LANGUAGE plpgsql
    AS $$DECLARE
  _user_id	smp.users.user_id%TYPE;

BEGIN
  IF TG_OP = 'DELETE' THEN
    _user_id := OLD.user_id;
  ELSIF TG_OP = 'INSERT' THEN
    _user_id := NEW.user_id;
  ELSE
    -- UPDATE
    _user_id := NEW.user_id;
    IF NEW.user_id <> OLD.user_id THEN
      RAISE EXCEPTION '% to %.% can''t change user_id',
	TG_OP, TG_TABLE_SCHEMA, TG_TABLE_NAME;
    END IF;
  END IF;

  -- Remove expired requests.
  DELETE FROM smp.mtg_reqs WHERE action_expire < CURRENT_TIMESTAMP;

  -- Promote the current request (or absence thereof) to per-SMP live state.
  PERFORM smp.mtg_live_apply(_user_id, t.target_id, r.action, r.action_expire,
	    r.action_param, r.action IS NULL AND r.uid >= 0)
     FROM notify.targets			t
     JOIN public.post_target_types	tt USING (target_type_id)
LEFT JOIN smp.mtg_reqs				r  ON (r.user_id = _user_id)
    WHERE t.complete
      AND tt.name = 'smp';

  RETURN NULL;
END$$;


ALTER FUNCTION smp.mtg_reqs__propagate() OWNER TO ndbadm;

--
-- Name: FUNCTION mtg_reqs__propagate(); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION mtg_reqs__propagate() IS 'Calls smp.mtg_live_apply() upon changes to smp.mtg_reqs (int)';


--
-- Name: mtg_reqs_cleanup(); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION mtg_reqs_cleanup() RETURNS void
    LANGUAGE sql
    AS $$
    DELETE FROM smp.mtg_reqs
      WHERE user_id IN (
        SELECT DISTINCT rq.user_id
          FROM smp.mtg_reqs rq
          LEFT JOIN smp.mtg_live l USING (user_id)
          WHERE rq.action_expire <= CURRENT_TIMESTAMP
            AND l.smp_id IS NULL
      )
  $$;


ALTER FUNCTION smp.mtg_reqs_cleanup() OWNER TO ndbadm;

--
-- Name: user__register(text); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION user__register(name_in text) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
  id	smp.users.user_id%TYPE;
BEGIN
  SELECT user_id INTO id FROM smp.users WHERE name = name_in AND NOT deleted;
  IF id IS NULL THEN
    INSERT INTO smp.users(name) VALUES(name_in) RETURNING user_id INTO id;
  END IF;

  RETURN id;
END;$$;


ALTER FUNCTION smp.user__register(name_in text) OWNER TO ndbadm;

--
-- Name: FUNCTION user__register(name_in text); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION user__register(name_in text) IS 'Returns user_id for an active user named @name_in, creating it if necessary';


--
-- Name: users__handle_deleted(); Type: FUNCTION; Schema: smp; Owner: ndbadm
--

CREATE FUNCTION users__handle_deleted() RETURNS trigger
    LANGUAGE plpgsql
    AS $$BEGIN
  -- Ensure only superusers can further modify deleted subscribers.
  IF OLD.deleted THEN
    PERFORM usesuper FROM pg_catalog.pg_user
      WHERE usename = session_user AND usesuper;
    IF NOT FOUND THEN
      RAISE EXCEPTION 'attempt to % `deleted'' %.% row % (%)',
	TG_OP, TG_TABLE_SCHEMA, TG_TABLE_NAME, OLD.name, OLD.user_id;
    END IF;
  END IF;

  -- Clear mitigation state cache for subscriber upon deletion.
  IF NEW.deleted AND NOT OLD.deleted THEN
    NEW.state_id	:= NULL;
    NEW.state_details	:= NULL;
    NEW.state_since	:= NULL;
  END IF;

  RETURN NEW;
END$$;


ALTER FUNCTION smp.users__handle_deleted() OWNER TO ndbadm;

--
-- Name: FUNCTION users__handle_deleted(); Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON FUNCTION users__handle_deleted() IS 'Performs checks and actions related to smp.users.deleted flag (int)';


SET search_path = flood, pg_catalog;

--
-- Name: pattern_quality(real, real); Type: AGGREGATE; Schema: flood; Owner: ndbadm
--

CREATE AGGREGATE pattern_quality(real, real) (
    SFUNC = pattern_quality_accum,
    STYPE = pattern_quality_state,
    INITCOND = '(0,0)',
    FINALFUNC = pattern_quality_final
);


ALTER AGGREGATE flood.pattern_quality(real, real) OWNER TO ndbadm;

--
-- Name: AGGREGATE pattern_quality(real, real); Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON AGGREGATE pattern_quality(real, real) IS 'How well pattern reflected flood deviations whenever present';


SET search_path = public, pg_catalog;

--
-- Name: array_accum(anyelement); Type: AGGREGATE; Schema: public; Owner: ndbadm
--

CREATE AGGREGATE array_accum(anyelement) (
    SFUNC = array_append2,
    STYPE = anyarray,
    INITCOND = '{}'
);


ALTER AGGREGATE public.array_accum(anyelement) OWNER TO ndbadm;

--
-- Name: coverage(double precision, double precision); Type: AGGREGATE; Schema: public; Owner: ndbadm
--

CREATE AGGREGATE coverage(double precision, double precision) (
    SFUNC = coverage_accum,
    STYPE = coverage_state,
    INITCOND = '(0,0)',
    FINALFUNC = coverage_final
);


ALTER AGGREGATE public.coverage(double precision, double precision) OWNER TO ndbadm;

--
-- Name: AGGREGATE coverage(double precision, double precision); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON AGGREGATE coverage(double precision, double precision) IS 'Total length of union of all intervals (must be ordered by start)';


SET search_path = auth, pg_catalog;

--
-- Name: authorized_keys; Type: TABLE; Schema: auth; Owner: postgres; Tablespace: 
--

CREATE TABLE authorized_keys (
    uid integer NOT NULL,
    key_id text NOT NULL,
    key text NOT NULL
);


ALTER TABLE auth.authorized_keys OWNER TO postgres;

--
-- Name: ipsec; Type: TABLE; Schema: auth; Owner: postgres; Tablespace: 
--

CREATE TABLE ipsec (
    host_id integer NOT NULL,
    key text NOT NULL
);


ALTER TABLE auth.ipsec OWNER TO postgres;

--
-- Name: passwd; Type: TABLE; Schema: auth; Owner: postgres; Tablespace: 
--

CREATE TABLE passwd (
    username text NOT NULL,
    uid integer NOT NULL,
	password varchar(64) NOT NULL,
    is_super boolean DEFAULT false,
    mail_id integer,
    allow_ad_hoc_samples boolean DEFAULT true NOT NULL,
    allow_hbad_mitigation boolean DEFAULT true NOT NULL,
    allow_hbad_samples boolean DEFAULT true NOT NULL,
    allow_nbad_mitigation boolean DEFAULT true NOT NULL
);


ALTER TABLE auth.passwd OWNER TO postgres;

--
-- Name: COLUMN passwd.username; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.username IS 'Unique user name';


--
-- Name: COLUMN passwd.uid; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.uid IS 'Unique user identifier';


--
-- Name: COLUMN passwd.is_super; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.is_super IS 'User is superuser?';


--
-- Name: COLUMN passwd.mail_id; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.mail_id IS 'Identifier of a `mail contact'' entry';


--
-- Name: COLUMN passwd.allow_ad_hoc_samples; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.allow_ad_hoc_samples IS 'Allow ad hoc sampling and access to ad hoc samples?';


--
-- Name: COLUMN passwd.allow_hbad_mitigation; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.allow_hbad_mitigation IS 'Allow HBAD mitigation?';


--
-- Name: COLUMN passwd.allow_hbad_samples; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.allow_hbad_samples IS 'Allow access to HBAD samples?';


--
-- Name: COLUMN passwd.allow_nbad_mitigation; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON COLUMN passwd.allow_nbad_mitigation IS 'Allow NBAD mitigation?';


--
-- Name: passwd_uid_seq; Type: SEQUENCE; Schema: auth; Owner: postgres
--

CREATE SEQUENCE passwd_uid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE auth.passwd_uid_seq OWNER TO postgres;

--
-- Name: passwd_uid_seq; Type: SEQUENCE OWNED BY; Schema: auth; Owner: postgres
--

ALTER SEQUENCE passwd_uid_seq OWNED BY passwd.uid;

--
-- Name: passwd_uid_seq; Type: SEQUENCE SET; Schema: auth; Owner: postgres
--

SELECT pg_catalog.setval('passwd_uid_seq', 10000, true);


--
-- Name: ldap; Type: TABLE; Schema: auth; Owner: postgres; Tablespace: 
--

CREATE TABLE ldap (
    id SERIAL NOT NULL, 
    host text NOT NULL, 
    port integer NOT NULL, 
    start_tls boolean DEFAULT true NOT NULL, 
    base_dn text NOT NULL, 
    user_dn text NOT NULL, 
    password varchar(64) NOT NULL,
	PRIMARY KEY (id)
);
	
ALTER TABLE auth.ldap OWNER TO postgres;	
 

SET search_path = fast, pg_catalog;

--
-- Name: attr_types; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE attr_types (
    attr_type_id integer NOT NULL,
    name public.item_name,
    CONSTRAINT name__capitalised CHECK ((("substring"((name)::text, 1, 1) >= 'A'::text) AND ("substring"((name)::text, 1, 1) <= 'Z'::text))),
    CONSTRAINT name__not_special CHECK (((name)::text <> ALL (ARRAY['Children'::text, 'Created'::text, 'Error'::text, 'Final'::text, 'Modified'::text, 'Parents'::text, 'Size'::text, 'Type'::text])))
);


ALTER TABLE fast.attr_types OWNER TO ndbadm;

--
-- Name: TABLE attr_types; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE attr_types IS 'Registry of types of additional entity attributes';


--
-- Name: COLUMN attr_types.attr_type_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN attr_types.attr_type_id IS 'Unique identifier of the type';


--
-- Name: COLUMN attr_types.name; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN attr_types.name IS 'Unique name of the type, must start with an uppercase letter';


--
-- Name: attr_types_attr_type_id_seq; Type: SEQUENCE; Schema: fast; Owner: ndbadm
--

CREATE SEQUENCE attr_types_attr_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fast.attr_types_attr_type_id_seq OWNER TO ndbadm;

--
-- Name: attr_types_attr_type_id_seq; Type: SEQUENCE OWNED BY; Schema: fast; Owner: ndbadm
--

ALTER SEQUENCE attr_types_attr_type_id_seq OWNED BY attr_types.attr_type_id;


--
-- Name: attr_types_attr_type_id_seq; Type: SEQUENCE SET; Schema: fast; Owner: ndbadm
--

SELECT pg_catalog.setval('attr_types_attr_type_id_seq', 1, false);


--
-- Name: attrs; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE attrs (
    entity_id integer NOT NULL,
    attr_type_id integer NOT NULL,
    value text NOT NULL
);


ALTER TABLE fast.attrs OWNER TO ndbadm;

--
-- Name: TABLE attrs; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE attrs IS 'Additional entity attributes';


--
-- Name: COLUMN attrs.entity_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN attrs.entity_id IS 'Unique identifier of the entity (ref)';


--
-- Name: COLUMN attrs.attr_type_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN attrs.attr_type_id IS 'Unique identifier of the attribute type (ref)';


--
-- Name: COLUMN attrs.value; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN attrs.value IS 'Data of the attribute';


--
-- Name: entities; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE entities (
    entity_id integer NOT NULL,
    modified timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE fast.entities OWNER TO ndbadm;

--
-- Name: TABLE entities; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE entities IS 'Primary registry of FAST documents (entities)';


--
-- Name: COLUMN entities.entity_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entities.entity_id IS 'Unique identifier of the entity';


--
-- Name: COLUMN entities.modified; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entities.modified IS 'When data related to the entity was last changed (auto, srv)';


--
-- Name: entities_entity_id_seq; Type: SEQUENCE; Schema: fast; Owner: ndbadm
--

CREATE SEQUENCE entities_entity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fast.entities_entity_id_seq OWNER TO ndbadm;

--
-- Name: entities_entity_id_seq; Type: SEQUENCE OWNED BY; Schema: fast; Owner: ndbadm
--

ALTER SEQUENCE entities_entity_id_seq OWNED BY entities.entity_id;


--
-- Name: entities_entity_id_seq; Type: SEQUENCE SET; Schema: fast; Owner: ndbadm
--

SELECT pg_catalog.setval('entities_entity_id_seq', 1, false);


--
-- Name: entity_links; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE entity_links (
    "from" integer NOT NULL,
    "to" integer NOT NULL
);


ALTER TABLE fast.entity_links OWNER TO ndbadm;

--
-- Name: TABLE entity_links; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE entity_links IS 'Keeps hierarchy of FAST documents';


--
-- Name: COLUMN entity_links."from"; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_links."from" IS 'A parent of the entity indicated by `to''';


--
-- Name: COLUMN entity_links."to"; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_links."to" IS 'A child of the entity indicated by `from''';


--
-- Name: entity_patterns; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE entity_patterns (
    entity_id integer NOT NULL,
    pattern_id integer NOT NULL,
    rank integer NOT NULL,
    matches real NOT NULL,
    CONSTRAINT entity_id__check_type CHECK (entity__check_type(entity_id, ('pattern-report'::text)::public.item_name)),
    CONSTRAINT matches__range CHECK (((matches > (0.0)::double precision) AND (matches <= (1.0)::double precision))),
    CONSTRAINT rank__positive CHECK ((rank > 0))
);


ALTER TABLE fast.entity_patterns OWNER TO ndbadm;

--
-- Name: TABLE entity_patterns; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE entity_patterns IS 'Links entities of type `pattern-report'' to specific patterns';


--
-- Name: COLUMN entity_patterns.entity_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_patterns.entity_id IS 'Unique identifier of the entity (ref)';


--
-- Name: COLUMN entity_patterns.pattern_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_patterns.pattern_id IS 'Unique identifier of the pattern (ref)';


--
-- Name: COLUMN entity_patterns.rank; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_patterns.rank IS 'How high was the pattern ranked for the report (1 is the top)';


--
-- Name: COLUMN entity_patterns.matches; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN entity_patterns.matches IS 'How many packets or frames had the pattern relative to all analysed (0--1]';


--
-- Name: pat_contents; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE pat_contents (
    pattern_id integer NOT NULL,
    pat_strip_id integer NOT NULL
);


ALTER TABLE fast.pat_contents OWNER TO ndbadm;

--
-- Name: TABLE pat_contents; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE pat_contents IS 'Pieces of which patterns consist';


--
-- Name: COLUMN pat_contents.pattern_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_contents.pattern_id IS 'Unique identifier of the pattern (ref)';


--
-- Name: COLUMN pat_contents.pat_strip_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_contents.pat_strip_id IS 'Unique identifier of the pattern piece (ref)';


--
-- Name: pat_endpoint_search; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE pat_endpoint_search (
    pat_strip_id integer NOT NULL,
    protocol smallint NOT NULL,
    src_port integer,
    dst_port integer,
    CONSTRAINT pat_endpoint_search_check CHECK (((src_port IS NOT NULL) OR (dst_port IS NOT NULL))),
    CONSTRAINT pat_endpoint_search_pat_strip_id_check CHECK ((pat_strip_layer(pat_strip_id) = 3)),
    CONSTRAINT pat_endpoint_search_protocol_check CHECK ((protocol = ANY (ARRAY[6, 17])))
);


ALTER TABLE fast.pat_endpoint_search OWNER TO ndbadm;

--
-- Name: TABLE pat_endpoint_search; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE pat_endpoint_search IS 'Protocol, source port, destination port for layer 3';


--
-- Name: COLUMN pat_endpoint_search.pat_strip_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_endpoint_search.pat_strip_id IS 'Pattern strip identifier';


--
-- Name: COLUMN pat_endpoint_search.protocol; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_endpoint_search.protocol IS 'IP Protocol (TCP or UDP)';


--
-- Name: COLUMN pat_endpoint_search.src_port; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_endpoint_search.src_port IS 'Source port (if available)';


--
-- Name: COLUMN pat_endpoint_search.dst_port; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_endpoint_search.dst_port IS 'Destination port (if available)';


--
-- Name: pat_payload_search; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE pat_payload_search (
    pat_strip_id integer NOT NULL,
    word bytea NOT NULL,
    CONSTRAINT pat_payload_search_pat_strip_id_check CHECK ((pat_strip_layer(pat_strip_id) = 4))
);


ALTER TABLE fast.pat_payload_search OWNER TO ndbadm;

--
-- Name: TABLE pat_payload_search; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE pat_payload_search IS 'Pattern payload strip split into parts';


--
-- Name: COLUMN pat_payload_search.pat_strip_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_payload_search.pat_strip_id IS 'Identifier of pattern payload strip';


--
-- Name: COLUMN pat_payload_search.word; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN pat_payload_search.word IS 'Part of pattern payload strip';


--
-- Name: pat_strips_pat_strip_id_seq; Type: SEQUENCE; Schema: fast; Owner: ndbadm
--

CREATE SEQUENCE pat_strips_pat_strip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fast.pat_strips_pat_strip_id_seq OWNER TO ndbadm;

--
-- Name: pat_strips_pat_strip_id_seq; Type: SEQUENCE OWNED BY; Schema: fast; Owner: ndbadm
--

ALTER SEQUENCE pat_strips_pat_strip_id_seq OWNED BY pat_strips.pat_strip_id;


--
-- Name: pat_strips_pat_strip_id_seq; Type: SEQUENCE SET; Schema: fast; Owner: ndbadm
--

SELECT pg_catalog.setval('pat_strips_pat_strip_id_seq', 1, false);


--
-- Name: patterns; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE patterns (
    pattern_id integer NOT NULL
);


ALTER TABLE fast.patterns OWNER TO ndbadm;

--
-- Name: TABLE patterns; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE patterns IS 'Registry of traffic patterns';


--
-- Name: COLUMN patterns.pattern_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN patterns.pattern_id IS 'Unique identifier of the pattern';


--
-- Name: patterns_pattern_id_seq; Type: SEQUENCE; Schema: fast; Owner: ndbadm
--

CREATE SEQUENCE patterns_pattern_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fast.patterns_pattern_id_seq OWNER TO ndbadm;

--
-- Name: patterns_pattern_id_seq; Type: SEQUENCE OWNED BY; Schema: fast; Owner: ndbadm
--

ALTER SEQUENCE patterns_pattern_id_seq OWNED BY patterns.pattern_id;


--
-- Name: patterns_pattern_id_seq; Type: SEQUENCE SET; Schema: fast; Owner: ndbadm
--

SELECT pg_catalog.setval('patterns_pattern_id_seq', 1, false);


--
-- Name: top_host_sets; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE top_host_sets (
    ths_id integer NOT NULL,
    entity_id integer NOT NULL,
    pattern_id integer NOT NULL,
    side "char" NOT NULL,
    CONSTRAINT entity_id__check_type CHECK (entity__check_type(entity_id, ('pattern-top-hosts'::text)::public.item_name)),
    CONSTRAINT side__src_dst CHECK (((side = 'd'::"char") OR (side = 's'::"char")))
);


ALTER TABLE fast.top_host_sets OWNER TO ndbadm;

--
-- Name: TABLE top_host_sets; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE top_host_sets IS 'For a pattern (pattern_id) contained in a `pattern-report'' which is the parent of this `pattern-top-hosts'' (entity_id), names top host sets for sources or destinations of traffic (side)';


--
-- Name: COLUMN top_host_sets.ths_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN top_host_sets.ths_id IS 'Unique identifier of the top host set';


--
-- Name: COLUMN top_host_sets.entity_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN top_host_sets.entity_id IS 'Unique identifier of the `pattern-top-hosts'' entity (ref)';


--
-- Name: COLUMN top_host_sets.pattern_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN top_host_sets.pattern_id IS 'Unique identifier of the pattern in the parent `pattern-report'' (ref)';


--
-- Name: COLUMN top_host_sets.side; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN top_host_sets.side IS 'Whether the set lists top source (`s'') or destination (`d'') hosts';


--
-- Name: top_host_sets_ths_id_seq; Type: SEQUENCE; Schema: fast; Owner: ndbadm
--

CREATE SEQUENCE top_host_sets_ths_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fast.top_host_sets_ths_id_seq OWNER TO ndbadm;

--
-- Name: top_host_sets_ths_id_seq; Type: SEQUENCE OWNED BY; Schema: fast; Owner: ndbadm
--

ALTER SEQUENCE top_host_sets_ths_id_seq OWNED BY top_host_sets.ths_id;


--
-- Name: top_host_sets_ths_id_seq; Type: SEQUENCE SET; Schema: fast; Owner: ndbadm
--

SELECT pg_catalog.setval('top_host_sets_ths_id_seq', 1, false);


--
-- Name: top_hosts; Type: TABLE; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE TABLE top_hosts (
    ths_id integer NOT NULL,
    ip inet NOT NULL,
    matches real NOT NULL,
    CONSTRAINT matches__range CHECK (((matches > (0.0)::double precision) AND (matches <= (1.0)::double precision)))
);


ALTER TABLE fast.top_hosts OWNER TO ndbadm;

--
-- Name: TABLE top_hosts; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TABLE top_hosts IS 'Lists IPs that were most active for corresponding patterns';


--
-- Name: COLUMN top_hosts.ths_id; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts.ths_id IS 'Unique identifier of the top host set (ref)';


--
-- Name: COLUMN top_hosts.ip; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts.ip IS 'A host in the set';


--
-- Name: COLUMN top_hosts.matches; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts.matches IS 'How many packets or frames had the host relative to all that matched the pattern (0--1]';


--
-- Name: types_type_id_seq; Type: SEQUENCE; Schema: fast; Owner: ndbadm
--

CREATE SEQUENCE types_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fast.types_type_id_seq OWNER TO ndbadm;

--
-- Name: types_type_id_seq; Type: SEQUENCE OWNED BY; Schema: fast; Owner: ndbadm
--

ALTER SEQUENCE types_type_id_seq OWNED BY types.type_id;


--
-- Name: types_type_id_seq; Type: SEQUENCE SET; Schema: fast; Owner: ndbadm
--

SELECT pg_catalog.setval('types_type_id_seq', 8, true);


SET search_path = fgen, pg_catalog;

--
-- Name: percents; Type: TABLE; Schema: fgen; Owner: ndbadm; Tablespace: 
--

CREATE TABLE percents (
    host_count integer NOT NULL,
    min_percent integer NOT NULL,
    CONSTRAINT percents_host_count_check CHECK ((host_count > 0)),
    CONSTRAINT percents_min_percent_check CHECK ((min_percent > 0))
);


ALTER TABLE fgen.percents OWNER TO ndbadm;

--
-- Name: TABLE percents; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON TABLE percents IS 'Rules for reducing number of top hosts before passing them to a filter';


--
-- Name: COLUMN percents.host_count; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON COLUMN percents.host_count IS 'Reduce to the number of hosts if possible';


--
-- Name: COLUMN percents.min_percent; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON COLUMN percents.min_percent IS 'Minimum percents the number of hosts must amount to';


--
-- Name: types; Type: TABLE; Schema: fgen; Owner: ndbadm; Tablespace: 
--

CREATE TABLE types (
    type_id integer NOT NULL,
    name text NOT NULL,
    description text,
    process boolean DEFAULT false NOT NULL
);


ALTER TABLE fgen.types OWNER TO ndbadm;

--
-- Name: TABLE types; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON TABLE types IS 'Filter types';


--
-- Name: COLUMN types.type_id; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON COLUMN types.type_id IS 'Filter type id';


--
-- Name: COLUMN types.name; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON COLUMN types.name IS 'Filter type name';


--
-- Name: COLUMN types.description; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON COLUMN types.description IS 'Filter type description';


--
-- Name: COLUMN types.process; Type: COMMENT; Schema: fgen; Owner: ndbadm
--

COMMENT ON COLUMN types.process IS 'Try to reduce number of hosts before passing to the filter?';


--
-- Name: types_type_id_seq; Type: SEQUENCE; Schema: fgen; Owner: ndbadm
--

CREATE SEQUENCE types_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fgen.types_type_id_seq OWNER TO ndbadm;

--
-- Name: types_type_id_seq; Type: SEQUENCE OWNED BY; Schema: fgen; Owner: ndbadm
--

ALTER SEQUENCE types_type_id_seq OWNED BY types.type_id;


--
-- Name: types_type_id_seq; Type: SEQUENCE SET; Schema: fgen; Owner: ndbadm
--

SELECT pg_catalog.setval('types_type_id_seq', 11, true);


SET search_path = flood, pg_catalog;

--
-- Name: alert_types; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE alert_types (
    alert_type_id integer NOT NULL,
    name text NOT NULL,
    class character(1) NOT NULL,
	type  text       
);


ALTER TABLE flood.alert_types OWNER TO ndbadm;

--
-- Name: TABLE alert_types; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE alert_types IS 'Registry of alert types (e.g. `bad checksum'')';


--
-- Name: COLUMN alert_types.alert_type_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alert_types.alert_type_id IS 'Unique identifier of the alert type';


--
-- Name: COLUMN alert_types.name; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alert_types.name IS 'Unique name of the alert type';


--
-- Name: COLUMN alert_types.class; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alert_types.class IS 'Alert classification for concise display';


--
-- Name: alert_types_alert_type_id_seq; Type: SEQUENCE; Schema: flood; Owner: ndbadm
--

CREATE SEQUENCE alert_types_alert_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE flood.alert_types_alert_type_id_seq OWNER TO ndbadm;

--
-- Name: alert_types_alert_type_id_seq; Type: SEQUENCE OWNED BY; Schema: flood; Owner: ndbadm
--

ALTER SEQUENCE alert_types_alert_type_id_seq OWNED BY alert_types.alert_type_id;


--
-- Name: alert_types_alert_type_id_seq; Type: SEQUENCE SET; Schema: flood; Owner: ndbadm
--

SELECT pg_catalog.setval('alert_types_alert_type_id_seq', 19, true);


--
-- Name: alerters; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE alerters (
    alerter_id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE flood.alerters OWNER TO ndbadm;

--
-- Name: TABLE alerters; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE alerters IS 'Alerter is a source of alerts for `alerts'' table (e.g. tcpdump,wireshark)';


--
-- Name: COLUMN alerters.alerter_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerters.alerter_id IS 'Unique identifier of the pattern alerter';


--
-- Name: COLUMN alerters.name; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerters.name IS 'Unique name of the pattern alerter';


--
-- Name: alerters_alerter_id_seq; Type: SEQUENCE; Schema: flood; Owner: ndbadm
--

CREATE SEQUENCE alerters_alerter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE flood.alerters_alerter_id_seq OWNER TO ndbadm;

--
-- Name: alerters_alerter_id_seq; Type: SEQUENCE OWNED BY; Schema: flood; Owner: ndbadm
--

ALTER SEQUENCE alerters_alerter_id_seq OWNED BY alerters.alerter_id;


--
-- Name: alerters_alerter_id_seq; Type: SEQUENCE SET; Schema: flood; Owner: ndbadm
--

SELECT pg_catalog.setval('alerters_alerter_id_seq', 2, true);


--
-- Name: alerts; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE alerts (
    flood_id integer NOT NULL,
    pattern_id integer,
    sample_id integer,
    alerter_id integer NOT NULL,
    alert_type_id integer NOT NULL,
    relevance double precision NOT NULL,
    total integer NOT NULL,
    CONSTRAINT alerts_check CHECK (((pattern_id IS NOT NULL) OR (sample_id IS NULL))),
    CONSTRAINT alerts_check1 CHECK (flood_has_sample_p(flood_id, sample_id)),
    CONSTRAINT alerts_relevance_check CHECK ((relevance > (0)::double precision)),
    CONSTRAINT alerts_sample_id_check CHECK (fast.entity__check_type(sample_id, ('traffic-sample'::text)::public.item_name)),
    CONSTRAINT alerts_total_check CHECK ((total > 0)),
    CONSTRAINT pattern_id_check CHECK (((pattern_id IS NULL) OR (((sample_id IS NOT NULL) AND sample_has_pattern_p(sample_id, pattern_id)) OR ((sample_id IS NULL) AND flood_has_pattern_p(flood_id, pattern_id)))))
);


ALTER TABLE flood.alerts OWNER TO ndbadm;

--
-- Name: TABLE alerts; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE alerts IS 'For a flood (flood_id) and (optionally) pattern (pattern_id) and (optionally) traffic sample (sample_id), names what is wrong with packets(alert_type_id), alert source (alerter_id), the number of packets thattriggered alarms (matches), all packet matching the pattern (total)';


--
-- Name: COLUMN alerts.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerts.flood_id IS 'Identifier of a flood (ref)';


--
-- Name: COLUMN alerts.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerts.pattern_id IS 'Identifier of the pattern for the flood';


--
-- Name: COLUMN alerts.sample_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerts.sample_id IS 'Identifier of a traffic sample for the flood';


--
-- Name: COLUMN alerts.alerter_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerts.alerter_id IS 'Alert source (i.e. a program that analyses packets)';


--
-- Name: COLUMN alerts.alert_type_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerts.alert_type_id IS 'Alert type (i.e. what is wrong with offending packets)';


--
-- Name: COLUMN alerts.relevance; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerts.relevance IS 'Relevance of alert for pattern/flood';


--
-- Name: COLUMN alerts.total; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN alerts.total IS 'The number of packets matching the pattern (within the flood or pattern-sample)';

--
-- Name: amplification_alerts; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
-- new hb 

CREATE TABLE amplification_alerts(
        alert_type_id INTEGER NOT NULL,
        port INTEGER NOT NULL,
        PRIMARY KEY (alert_type_id)
);

ALTER TABLE flood.amplification_alerts OWNER TO ndbadm;

--
-- Name: TABLE amplification_alerts; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE amplification_alerts IS 'amplifications for alerts';


--
-- Name: bogons; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
-- new hb

CREATE TABLE bogons (
	address        TEXT NOT NULL
);

ALTER TABLE flood.bogons OWNER TO ndbadm;

--
-- Name: TABLE bogons; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE bogons IS 'Bogon List (Bogus outside networks) is a non-standard but highly regarded set of addresses that you should block from accessing your Network';


--
-- Name: cache; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE cache (
    flood_id integer NOT NULL,
    patterns integer DEFAULT 0 NOT NULL
);


ALTER TABLE flood.cache OWNER TO ndbadm;

--
-- Name: TABLE cache; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE cache IS 'Extends `registry'' with cached denormalised flood parameters';


--
-- Name: COLUMN cache.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN cache.flood_id IS 'Links to the flood in `registry''';


--
-- Name: COLUMN cache.patterns; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN cache.patterns IS 'Number of distinct patterns detected for the flood (denorm)';


--
-- Name: registry; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE registry (
    flood_id integer NOT NULL,
    type_id integer NOT NULL,
    subsystem_id integer NOT NULL,
    host_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE flood.registry OWNER TO ndbadm;

--
-- Name: TABLE registry; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE registry IS 'Catalogue of floods (static data only, not supposed to update)';


--
-- Name: COLUMN registry.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN registry.flood_id IS 'Unique identifier of the flood';


--
-- Name: COLUMN registry.type_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN registry.type_id IS 'Type of the flood';


--
-- Name: COLUMN registry.subsystem_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN registry.subsystem_id IS 'Submitter of the flood';


--
-- Name: COLUMN registry.host_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN registry.host_id IS 'Agent where the flood was detected';


--
-- Name: COLUMN registry.group_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN registry.group_id IS 'Subnet group in which the flood was detected';


--
-- Name: state; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE state (
    flood_id integer NOT NULL,
    modified timestamp with time zone DEFAULT now() NOT NULL,
    start timestamp with time zone DEFAULT now() NOT NULL,
    stop timestamp with time zone,
    details text,
    CONSTRAINT stopped_has_details CHECK (((stop IS NULL) OR (details IS NOT NULL)))
);


ALTER TABLE flood.state OWNER TO ndbadm;

--
-- Name: TABLE state; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE state IS 'Extends `registry'' (narrow; updated when any info on the flood changes)';


--
-- Name: COLUMN state.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN state.flood_id IS 'Links to the flood in `registry''';


--
-- Name: COLUMN state.modified; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN state.modified IS 'When any data on the flood changed (auto, srv)';


--
-- Name: COLUMN state.start; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN state.start IS 'When the flood was detected';


--
-- Name: COLUMN state.stop; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN state.stop IS 'When the flood was stopped being tracked';


--
-- Name: COLUMN state.details; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN state.details IS 'Reason to stop tracking the flood';


--
-- Name: stats; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE stats (
    flood_id integer NOT NULL,
    duration real DEFAULT (1.0)::real NOT NULL,
    exp_byt bigint DEFAULT 0 NOT NULL,
    exp_pkt bigint DEFAULT 0 NOT NULL,
    obs_byt bigint DEFAULT 0 NOT NULL,
    obs_pkt bigint DEFAULT 0 NOT NULL,
    shape integer DEFAULT 0 NOT NULL,
    CONSTRAINT positive_duration CHECK ((duration > (0)::double precision))
);


ALTER TABLE flood.stats OWNER TO ndbadm;

--
-- Name: TABLE stats; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE stats IS 'Extends `registry'' with flood statistics (updated periodically)';


--
-- Name: COLUMN stats.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN stats.flood_id IS 'Links to the flood in `registry''';


--
-- Name: COLUMN stats.duration; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN stats.duration IS 'Statistics are for that much of the flood';


--
-- Name: COLUMN stats.exp_byt; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN stats.exp_byt IS 'Expected byte count';


--
-- Name: COLUMN stats.exp_pkt; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN stats.exp_pkt IS 'Expected packet count';


--
-- Name: COLUMN stats.obs_byt; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN stats.obs_byt IS 'Observed byte count';


--
-- Name: COLUMN stats.obs_pkt; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN stats.obs_pkt IS 'Observed packet count';


--
-- Name: COLUMN stats.shape; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN stats.shape IS 'Shape-based severity of the flood';


--
-- Name: all; Type: VIEW; Schema: flood; Owner: ndbadm
--

CREATE VIEW "all" AS
    SELECT r.flood_id, r.subsystem_id, r.host_id, r.group_id, r.type_id, state.start, state.stop, state.modified, state.details, stats.duration AS stats_duration, stats.exp_byt, stats.exp_pkt, stats.obs_byt, stats.obs_pkt, stats.shape, cache.patterns FROM (((registry r JOIN state USING (flood_id)) JOIN stats USING (flood_id)) JOIN cache USING (flood_id));


ALTER TABLE flood."all" OWNER TO ndbadm;

--
-- Name: attack_interfaces_triggered; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE attack_interfaces_triggered (
    flood_id integer NOT NULL,
    trigger_time timestamp with time zone DEFAULT now()
);


ALTER TABLE flood.attack_interfaces_triggered OWNER TO ndbadm;


--
-- Name: config; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE config (
    name text NOT NULL,
    val text NOT NULL
);


ALTER TABLE flood.config OWNER TO ndbadm;

--
-- Name: errors; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE errors (
    error_id integer NOT NULL,
    subsystem_id integer NOT NULL,
    descriptor text NOT NULL,
    start timestamp with time zone DEFAULT now() NOT NULL,
    stop timestamp with time zone,
    details text NOT NULL
);


ALTER TABLE flood.errors OWNER TO ndbadm;

--
-- Name: TABLE errors; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE errors IS 'Run-time errors of flood-like anomaly detection';


--
-- Name: COLUMN errors.error_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN errors.error_id IS 'Unique identifier of the error';


--
-- Name: COLUMN errors.subsystem_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN errors.subsystem_id IS 'The subsystem reporting the error';


--
-- Name: COLUMN errors.descriptor; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN errors.descriptor IS 'Location of the error, e.g., `sensor=foobar, group=5, attack=syn-in, tracking=pkt_dst_tcp_flag_syn''';


--
-- Name: COLUMN errors.start; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN errors.start IS 'When this error condition appeared';


--
-- Name: COLUMN errors.stop; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN errors.stop IS 'When the error ended, NULL for ongoing errors';


--
-- Name: COLUMN errors.details; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN errors.details IS 'Describes the error, e.g., `data: value is too small (min 4.0)''';


--
-- Name: errors_error_id_seq; Type: SEQUENCE; Schema: flood; Owner: ndbadm
--

CREATE SEQUENCE errors_error_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE flood.errors_error_id_seq OWNER TO ndbadm;

--
-- Name: errors_error_id_seq; Type: SEQUENCE OWNED BY; Schema: flood; Owner: ndbadm
--

ALTER SEQUENCE errors_error_id_seq OWNED BY errors.error_id;


--
-- Name: errors_error_id_seq; Type: SEQUENCE SET; Schema: flood; Owner: ndbadm
--

SELECT pg_catalog.setval('errors_error_id_seq', 1, false);


--
-- Name: graphs; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE graphs (
    flood_id integer NOT NULL,
    at timestamp with time zone DEFAULT now() NOT NULL,
    resolution real DEFAULT 1.0,
    "values" real[],
    stat_id integer NOT NULL,
    predicted real[]
);


ALTER TABLE flood.graphs OWNER TO ndbadm;

--
-- Name: TABLE graphs; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE graphs IS 'High resolution traffic statistics used to detect floods, mainly for graphing';


--
-- Name: COLUMN graphs.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN graphs.flood_id IS 'Links to the flood in `registry''';


--
-- Name: COLUMN graphs.at; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN graphs.at IS 'Moment of time the first of `values'' corresponds to';


--
-- Name: COLUMN graphs.resolution; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN graphs.resolution IS 'Seconds between subsequent `values''';


--
-- Name: COLUMN graphs."values"; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN graphs."values" IS 'Array of values of the traffic statistic, at `at'' and later, `resolution'' seconds apart from each other';


--
-- Name: importance; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE importance (
    flood_id integer NOT NULL,
    importance smallint NOT NULL,
    filter_id integer,
    uid integer,
    CONSTRAINT importance_filter_id_check CHECK ((notify.filter_type_id(notify.filter_root(filter_id)) = notify.type_id('flood'::text))),
    CONSTRAINT importance_importance_check CHECK (((importance >= 0) AND (importance <= 3))),
    CONSTRAINT importance_setby_check CHECK ((NOT ((uid IS NOT NULL) AND (filter_id IS NOT NULL))))
);


ALTER TABLE flood.importance OWNER TO ndbadm;

--
-- Name: TABLE importance; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE importance IS 'Flood importance';


--
-- Name: COLUMN importance.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN importance.flood_id IS 'Flood id (ref)';


--
-- Name: COLUMN importance.importance; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN importance.importance IS 'Flood importance';


--
-- Name: COLUMN importance.filter_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN importance.filter_id IS 'Importance was set by this filter (ref)';


--
-- Name: COLUMN importance.uid; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN importance.uid IS 'Importance was set by this user (ref)';


--
-- Name: matches; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE matches (
    filter_id integer NOT NULL,
    match_id integer NOT NULL,
    at timestamp with time zone DEFAULT now() NOT NULL,
    CONSTRAINT matches_filter_id_check CHECK ((notify.filter_type_id(notify.filter_root(filter_id)) = notify.type_id('flood'::text)))
);


ALTER TABLE flood.matches OWNER TO ndbadm;

--
-- Name: TABLE matches; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE matches IS 'Caches all matches of filters against floods';


--
-- Name: COLUMN matches.filter_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN matches.filter_id IS 'The filter that matched (ref)';


--
-- Name: COLUMN matches.match_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN matches.match_id IS 'The flood that matched (ref)';


--
-- Name: COLUMN matches.at; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN matches.at IS 'When was the match registered (srv)';


--
-- Name: mtg_auto_block_tbl; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_auto_block_tbl (
    flood_id integer NOT NULL,
    orig_pattern_id integer NOT NULL,
    filter_id integer NOT NULL,
    expires timestamp with time zone
);


ALTER TABLE flood.mtg_auto_block_tbl OWNER TO ndbadm;

--
-- Name: mtg_auto_block_with_action_tbl; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_auto_block_with_action_tbl (
    flood_id integer NOT NULL,
    orig_pattern_id integer NOT NULL,
    filter_id integer NOT NULL,
    expires timestamp with time zone,
    action mtg_req_action
);


ALTER TABLE flood.mtg_auto_block_with_action_tbl OWNER TO ndbadm;

--
-- Name: mtg_graphs_real; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_graphs_real (
    sg_id integer NOT NULL,
    pattern_id integer,
    at timestamp with time zone NOT NULL,
    resolution real DEFAULT 5.0 NOT NULL,
    cps real[] NOT NULL,
    pps real[] NOT NULL,
    CONSTRAINT same_size CHECK ((array_dims(cps) = array_dims(pps))),
    CONSTRAINT target_sg CHECK ((notify.target_type(sg_id) = 'aos'::text))
);


ALTER TABLE flood.mtg_graphs_real OWNER TO ndbadm;

--
-- Name: TABLE mtg_graphs_real; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_graphs_real IS 'Mitigation statistics, mainly for graphing (int)';


--
-- Name: COLUMN mtg_graphs_real.sg_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs_real.sg_id IS 'SG system that the statistics are from';


--
-- Name: COLUMN mtg_graphs_real.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs_real.pattern_id IS 'Traffic pattern the statistics are for; NULL for target-wide statistics';


--
-- Name: COLUMN mtg_graphs_real.at; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs_real.at IS 'Moment of time the first of `values'' corresponds to';


--
-- Name: COLUMN mtg_graphs_real.resolution; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs_real.resolution IS 'Seconds between subsequent `values''';


--
-- Name: COLUMN mtg_graphs_real.cps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs_real.cps IS 'Byte rate at `at'' and later moments, `resolution'' seconds apart';


--
-- Name: COLUMN mtg_graphs_real.pps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs_real.pps IS 'Packet rate at `at'' and later moments, `resolution'' seconds apart';


--
-- Name: mtg_graphs; Type: VIEW; Schema: flood; Owner: ndbadm
--

CREATE VIEW mtg_graphs AS
    SELECT mtg_graphs_real.sg_id, COALESCE(mtg_graphs_real.pattern_id, 0) AS pattern_id, mtg_graphs_real.at, mtg_graphs_real.resolution, mtg_graphs_real.cps, mtg_graphs_real.pps FROM mtg_graphs_real;


ALTER TABLE flood.mtg_graphs OWNER TO ndbadm;

--
-- Name: VIEW mtg_graphs; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON VIEW mtg_graphs IS 'Mitigation statistics, mainly for graphing';


--
-- Name: COLUMN mtg_graphs.sg_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs.sg_id IS 'SG system that the statistics are from';


--
-- Name: COLUMN mtg_graphs.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs.pattern_id IS 'Traffic pattern the statistics are for; 0 for target-wide statistics';


--
-- Name: COLUMN mtg_graphs.at; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs.at IS 'Moment of time the first of `values'' corresponds to';


--
-- Name: COLUMN mtg_graphs.resolution; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs.resolution IS 'Seconds between subsequent `values''';


--
-- Name: COLUMN mtg_graphs.cps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs.cps IS 'Byte rate at `at'' and later moments, `resolution'' seconds apart';


--
-- Name: COLUMN mtg_graphs.pps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_graphs.pps IS 'Packet rate at `at'' and later moments, `resolution'' seconds apart';


--
-- Name: mtg_live; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_live (
    sg_id integer NOT NULL,
    pattern_id integer NOT NULL,
    action_since timestamp with time zone DEFAULT now() NOT NULL,
    action_expire timestamp with time zone,
    refresh boolean DEFAULT true NOT NULL,
    state_id text DEFAULT 'PEND'::text NOT NULL,
    state_details text,
    state_since timestamp with time zone DEFAULT now() NOT NULL,
    action mtg_req_action NOT NULL,
    CONSTRAINT target_sg CHECK ((notify.target_type(sg_id) = 'aos'::text))
);


ALTER TABLE flood.mtg_live OWNER TO ndbadm;

--
-- Name: TABLE mtg_live; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_live IS 'Actual mitigation requests';


--
-- Name: COLUMN mtg_live.sg_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.sg_id IS 'SG system to mitigate at';


--
-- Name: COLUMN mtg_live.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.pattern_id IS 'Traffic pattern to mitigate with';


--
-- Name: COLUMN mtg_live.action_since; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.action_since IS 'When the action was submitted';


--
-- Name: COLUMN mtg_live.action_expire; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_live.refresh; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.refresh IS 'Set upon submit or amendment';


--
-- Name: COLUMN mtg_live.state_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.state_id IS 'Processing stage the request is in';


--
-- Name: COLUMN mtg_live.state_details; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.state_details IS 'Commentary on the state (e.g., reason or error message)';


--
-- Name: COLUMN mtg_live.state_since; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.state_since IS 'When the state last changed (auto, srv)';


--
-- Name: mtg_live_log_past; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_live_log_past (
    sg_id integer NOT NULL,
    pattern_id integer NOT NULL,
    state_id text NOT NULL,
    state_details text,
    state_since timestamp with time zone NOT NULL,
    state_until timestamp with time zone DEFAULT now() NOT NULL,
    id integer NOT NULL,
    CONSTRAINT sensible_until CHECK ((state_until >= state_since)),
    CONSTRAINT target_sg CHECK ((notify.target_type(sg_id) = 'aos'::text))
);


ALTER TABLE flood.mtg_live_log_past OWNER TO ndbadm;

--
-- Name: TABLE mtg_live_log_past; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_live_log_past IS 'Past progress of mitigation requests';


--
-- Name: COLUMN mtg_live_log_past.sg_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.sg_id IS 'SG system to mitigate at';


--
-- Name: COLUMN mtg_live_log_past.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.pattern_id IS 'Traffic pattern to mitigate with';


--
-- Name: COLUMN mtg_live_log_past.state_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_id IS 'Processing stage the request was in';


--
-- Name: COLUMN mtg_live_log_past.state_details; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_details IS 'Commentary on the state (e.g., reason or error message)';


--
-- Name: COLUMN mtg_live_log_past.state_since; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_since IS 'The moment the request got into the state';


--
-- Name: COLUMN mtg_live_log_past.state_until; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_until IS 'The moment the request got out of the state';


--
-- Name: mtg_live_log; Type: VIEW; Schema: flood; Owner: ndbadm
--

CREATE VIEW mtg_live_log AS
    SELECT mtg_live_log_past.sg_id, mtg_live_log_past.pattern_id, mtg_live_log_past.state_since, mtg_live_log_past.state_until, mtg_live_log_past.state_id, mtg_live_log_past.state_details FROM mtg_live_log_past UNION ALL SELECT mtg_live.sg_id, mtg_live.pattern_id, mtg_live.state_since, 'infinity'::timestamp with time zone AS state_until, mtg_live.state_id, mtg_live.state_details FROM mtg_live;


ALTER TABLE flood.mtg_live_log OWNER TO ndbadm;

--
-- Name: VIEW mtg_live_log; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON VIEW mtg_live_log IS 'Progress of mitigation requests';


--
-- Name: COLUMN mtg_live_log.sg_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.sg_id IS 'SG system to mitigate at';


--
-- Name: COLUMN mtg_live_log.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.pattern_id IS 'Traffic pattern to mitigate with';


--
-- Name: COLUMN mtg_live_log.state_since; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_since IS 'The moment the request got into the state';


--
-- Name: COLUMN mtg_live_log.state_until; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_until IS 'The moment the request got out of the state';


--
-- Name: COLUMN mtg_live_log.state_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_id IS 'Processing stage the request was in';


--
-- Name: COLUMN mtg_live_log.state_details; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_details IS 'Commentary on the state (e.g., reason or error message)';


--
-- Name: mtg_live_log_past_id_seq; Type: SEQUENCE; Schema: flood; Owner: ndbadm
--

CREATE SEQUENCE mtg_live_log_past_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE flood.mtg_live_log_past_id_seq OWNER TO ndbadm;

--
-- Name: mtg_live_log_past_id_seq; Type: SEQUENCE OWNED BY; Schema: flood; Owner: ndbadm
--

ALTER SEQUENCE mtg_live_log_past_id_seq OWNED BY mtg_live_log_past.id;


--
-- Name: mtg_live_log_past_id_seq; Type: SEQUENCE SET; Schema: flood; Owner: ndbadm
--

SELECT pg_catalog.setval('mtg_live_log_past_id_seq', 1, false);


--
-- Name: mtg_map; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_map (
    host_id integer NOT NULL,
    sg_id integer NOT NULL,
    CONSTRAINT host_is_sensor CHECK (public.host_cap_sensor(host_id)),
    CONSTRAINT target_sg CHECK ((notify.target_type(sg_id) = 'aos'::text))
);


ALTER TABLE flood.mtg_map OWNER TO ndbadm;

--
-- Name: TABLE mtg_map; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_map IS 'Relates Sensors to SGs and vice versa';


--
-- Name: COLUMN mtg_map.host_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_map.host_id IS 'Sensor where flood appears';


--
-- Name: COLUMN mtg_map.sg_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_map.sg_id IS 'SG system to mitigate flood at';


--
-- Name: mtg_req_manual_block_tbl; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_req_manual_block_tbl (
    flood_id integer NOT NULL,
    orig_pattern_id integer NOT NULL,
    u_id integer NOT NULL,
    action mtg_req_action,
    action_expire timestamp with time zone,
    action_flood_only boolean
);


ALTER TABLE flood.mtg_req_manual_block_tbl OWNER TO ndbadm;

--
-- Name: mtg_req_manual_unblock_tbl; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_req_manual_unblock_tbl (
    flood_id integer NOT NULL,
    u_id integer NOT NULL
);


ALTER TABLE flood.mtg_req_manual_unblock_tbl OWNER TO ndbadm;

--
-- Name: mtg_reqs; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_reqs (
    flood_id integer NOT NULL,
    orig_pattern_id integer NOT NULL,
    pattern_id integer NOT NULL,
    filter_id integer,
    uid integer,
    action mtg_req_action NOT NULL,
    action_since timestamp with time zone DEFAULT now() NOT NULL,
    action_expire timestamp with time zone,
    action_flood_only boolean DEFAULT true NOT NULL,
    CONSTRAINT either_uid_or_filter CHECK (((uid IS NULL) <> (filter_id IS NULL))),
    CONSTRAINT none_is_while_flood_lasts CHECK ((((action)::text <> 'NONE'::text) OR ((action_expire IS NULL) AND action_flood_only))),
    CONSTRAINT only_manual_none CHECK ((((action)::text <> 'NONE'::text) OR (uid IS NOT NULL))),
    CONSTRAINT sensible_expire CHECK ((action_expire > action_since))
);


ALTER TABLE flood.mtg_reqs OWNER TO ndbadm;

--
-- Name: TABLE mtg_reqs; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_reqs IS 'Submitted mitigation requests';


--
-- Name: COLUMN mtg_reqs.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.flood_id IS 'Flood where original pattern was detected';


--
-- Name: COLUMN mtg_reqs.orig_pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.orig_pattern_id IS 'Original traffic pattern, edited or reduced from';


--
-- Name: COLUMN mtg_reqs.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.pattern_id IS 'Traffic pattern to mitigate with';


--
-- Name: COLUMN mtg_reqs.filter_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.filter_id IS 'Filter that made the automatic request';


--
-- Name: COLUMN mtg_reqs.uid; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.uid IS 'User that made the manual request';


--
-- Name: COLUMN mtg_reqs.action; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action IS 'Desired action upon match of the pattern';


--
-- Name: COLUMN mtg_reqs.action_since; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action_since IS 'When the action was submitted (auto, srv)';


--
-- Name: COLUMN mtg_reqs.action_expire; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_reqs.action_flood_only; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action_flood_only IS 'Whether to remove the action when flood is over';


--
-- Name: mtg_reqs_log_past; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_reqs_log_past (
    flood_id integer NOT NULL,
    orig_pattern_id integer NOT NULL,
    pattern_id integer NOT NULL,
    filter_id integer,
    uid integer,
    action mtg_req_action,
    action_expire timestamp with time zone,
    action_flood_only boolean NOT NULL,
    req_since timestamp with time zone NOT NULL,
    req_until timestamp with time zone DEFAULT now() NOT NULL,
    CONSTRAINT either_uid_or_filter CHECK (((uid IS NULL) <> (filter_id IS NULL))),
    CONSTRAINT sensible_until CHECK ((req_until >= req_since))
);


ALTER TABLE flood.mtg_reqs_log_past OWNER TO ndbadm;

--
-- Name: TABLE mtg_reqs_log_past; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_reqs_log_past IS 'Past evolution of mitigation requests';


--
-- Name: COLUMN mtg_reqs_log_past.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.flood_id IS 'Flood where original pattern was detected';


--
-- Name: COLUMN mtg_reqs_log_past.orig_pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.orig_pattern_id IS 'Original traffic pattern, edited or reduced from';


--
-- Name: COLUMN mtg_reqs_log_past.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.pattern_id IS 'Traffic pattern to mitigate with';


--
-- Name: COLUMN mtg_reqs_log_past.filter_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.filter_id IS 'Filter that made the automatic request';


--
-- Name: COLUMN mtg_reqs_log_past.uid; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.uid IS 'User that made the manual request';


--
-- Name: COLUMN mtg_reqs_log_past.action; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.action IS 'Desired action upon match of the pattern';


--
-- Name: COLUMN mtg_reqs_log_past.action_expire; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_reqs_log_past.action_flood_only; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.action_flood_only IS 'Whether to remove the action when flood is over';


--
-- Name: COLUMN mtg_reqs_log_past.req_since; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.req_since IS 'The moment the request was added or updated';


--
-- Name: COLUMN mtg_reqs_log_past.req_until; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.req_until IS 'The moment the request was updated further or removed';


--
-- Name: mtg_reqs_log; Type: VIEW; Schema: flood; Owner: ndbadm
--

CREATE VIEW mtg_reqs_log AS
    SELECT mtg_reqs_log_past.flood_id, mtg_reqs_log_past.orig_pattern_id, mtg_reqs_log_past.pattern_id, mtg_reqs_log_past.filter_id, mtg_reqs_log_past.uid, mtg_reqs_log_past.action, mtg_reqs_log_past.action_expire, mtg_reqs_log_past.action_flood_only, mtg_reqs_log_past.req_since, mtg_reqs_log_past.req_until FROM mtg_reqs_log_past UNION ALL SELECT r.flood_id, r.orig_pattern_id, r.pattern_id, r.filter_id, r.uid, r.action, r.action_expire, r.action_flood_only, GREATEST((SELECT max(p.req_until) AS max FROM mtg_reqs_log_past p WHERE (p.flood_id = r.flood_id)), r.action_since) AS req_since, COALESCE(r.action_expire, 'infinity'::timestamp with time zone) AS req_until FROM mtg_reqs r;


ALTER TABLE flood.mtg_reqs_log OWNER TO ndbadm;

--
-- Name: VIEW mtg_reqs_log; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON VIEW mtg_reqs_log IS 'Evolution of mitigation requests';


--
-- Name: COLUMN mtg_reqs_log.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.flood_id IS 'Flood where original pattern was detected';


--
-- Name: COLUMN mtg_reqs_log.orig_pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.orig_pattern_id IS 'Original traffic pattern, edited or reduced from';


--
-- Name: COLUMN mtg_reqs_log.pattern_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.pattern_id IS 'Traffic pattern to mitigate with';


--
-- Name: COLUMN mtg_reqs_log.filter_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.filter_id IS 'Filter that made the automatic request';


--
-- Name: COLUMN mtg_reqs_log.uid; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.uid IS 'User that made the manual request';


--
-- Name: COLUMN mtg_reqs_log.action; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.action IS 'Desired action upon match of the pattern';


--
-- Name: COLUMN mtg_reqs_log.action_expire; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_reqs_log.action_flood_only; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.action_flood_only IS 'Whether to remove the action when flood is over';


--
-- Name: COLUMN mtg_reqs_log.req_since; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.req_since IS 'The moment the request was added or updated';


--
-- Name: COLUMN mtg_reqs_log.req_until; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.req_until IS 'The moment the request was updated further or removed';


--
-- Name: mtg_sg_state; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_sg_state (
    sg_id integer NOT NULL,
    at timestamp with time zone DEFAULT now() NOT NULL,
    alive boolean DEFAULT false NOT NULL,
    details text,
    pat_count_max integer,
    blob_size integer,
    blob_size_max integer,
    CONSTRAINT live_has_stats CHECK (((((pat_count_max + blob_size) + blob_size_max) IS NOT NULL) = alive))
);


ALTER TABLE flood.mtg_sg_state OWNER TO ndbadm;

--
-- Name: TABLE mtg_sg_state; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE mtg_sg_state IS 'Latest state of each used SG system';


--
-- Name: COLUMN mtg_sg_state.sg_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_sg_state.sg_id IS 'SG system that is described';


--
-- Name: COLUMN mtg_sg_state.at; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_sg_state.at IS 'The moment the state was updated';


--
-- Name: COLUMN mtg_sg_state.alive; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_sg_state.alive IS 'Whether the SG was connected';


--
-- Name: COLUMN mtg_sg_state.details; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_sg_state.details IS 'Commentary on the state of the SG system';


--
-- Name: COLUMN mtg_sg_state.pat_count_max; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_sg_state.pat_count_max IS 'Maximum number of patterns the SG system supports';


--
-- Name: COLUMN mtg_sg_state.blob_size; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_sg_state.blob_size IS 'Current size of signature structure on the SG system';


--
-- Name: COLUMN mtg_sg_state.blob_size_max; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN mtg_sg_state.blob_size_max IS 'Maximum size of signature structure on the SG system';


--
-- Name: pattern_entropy; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE pattern_entropy (
    flood_id integer NOT NULL,
    pattern_id integer NOT NULL,
    coverage real[] NOT NULL,
    entropy real[] NOT NULL,
    tot_coverage real NOT NULL,
    tot_entropy real NOT NULL
);


ALTER TABLE flood.pattern_entropy OWNER TO ndbadm;

--
-- Name: COLUMN pattern_entropy.coverage; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN pattern_entropy.coverage IS 'Per-layer (L2,L3,L4,L4Data,Trailer) pattern coverage (0..1)';


--
-- Name: COLUMN pattern_entropy.entropy; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN pattern_entropy.entropy IS 'Per-layer (L2,L3,L4,L4Data,Trailer) entropy in bits (0..8)';


--
-- Name: COLUMN pattern_entropy.tot_coverage; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN pattern_entropy.tot_coverage IS 'Overall pattern coverage (0..1)';


--
-- Name: COLUMN pattern_entropy.tot_entropy; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN pattern_entropy.tot_entropy IS 'Overall entropy in bits (0..8)';


--
-- Name: registry_flood_id_seq; Type: SEQUENCE; Schema: flood; Owner: ndbadm
--

CREATE SEQUENCE registry_flood_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE flood.registry_flood_id_seq OWNER TO ndbadm;

--
-- Name: registry_flood_id_seq; Type: SEQUENCE OWNED BY; Schema: flood; Owner: ndbadm
--

ALTER SEQUENCE registry_flood_id_seq OWNED BY registry.flood_id;


--
-- Name: registry_flood_id_seq; Type: SEQUENCE SET; Schema: flood; Owner: ndbadm
--

SELECT pg_catalog.setval('registry_flood_id_seq', 1, false);


--
-- Name: samples; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE samples (
    flood_id integer NOT NULL,
    at timestamp with time zone DEFAULT now() NOT NULL,
    request text NOT NULL,
    processed boolean DEFAULT false NOT NULL,
    sample_id integer,
    report_id integer,
    top_hosts_id integer,
    alerts_id integer,
    entropy_id integer
);


ALTER TABLE flood.samples OWNER TO ndbadm;

--
-- Name: TABLE samples; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE samples IS 'Traffic sampling requests and results';


--
-- Name: COLUMN samples.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.flood_id IS 'Links to the flood in `registry''';


--
-- Name: COLUMN samples.at; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.at IS 'When the request was issued';


--
-- Name: COLUMN samples.request; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.request IS 'Request text';


--
-- Name: COLUMN samples.processed; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.processed IS 'Whether the request has been processed already';


--
-- Name: COLUMN samples.sample_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.sample_id IS 'FAST document containing the traffic sample';


--
-- Name: COLUMN samples.report_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.report_id IS 'FAST document containing the pattern report for the sample';


--
-- Name: COLUMN samples.top_hosts_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.top_hosts_id IS 'FAST document containing top hosts lists for patterns in the report';


--
-- Name: COLUMN samples.alerts_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN samples.alerts_id IS 'FAST document containing pattern alerts for patterns in the report';


--
-- Name: thresholds; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE thresholds (
    threshold_id integer NOT NULL,
    name text NOT NULL,
    descr text,
    disable boolean DEFAULT false NOT NULL,
    group_id integer,
    host_id integer,
    stat_id integer,
    grace integer,
    min boolean,
    value integer,
    dyn_short integer,
    dyn_long integer,
    dyn_percent boolean DEFAULT false NOT NULL,
    CONSTRAINT host_group_check CHECK (((host_id IS NULL) OR (group_id IS NOT NULL))),
    CONSTRAINT host_id_check CHECK (((host_id IS NULL) OR public.host_cap_sensor(host_id))),
    CONSTRAINT percents_check CHECK (((dyn_short IS NOT NULL) OR (NOT dyn_percent))),
    CONSTRAINT short_long_check CHECK (((dyn_short IS NULL) = (dyn_long IS NULL))),
    CONSTRAINT thresholds_check CHECK (((min IS NULL) OR (value IS NOT NULL))),
    CONSTRAINT thresholds_grace_check CHECK (((grace IS NULL) OR (grace > 0))),
    CONSTRAINT thresholds_stat_id_check CHECK (((stat_id IS NULL) OR (public.stat_struct(stat_id) = 'stats'::text)))
);


ALTER TABLE flood.thresholds OWNER TO ndbadm;

--
-- Name: TABLE thresholds; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE thresholds IS 'Threshold configuration';


--
-- Name: COLUMN thresholds.threshold_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.threshold_id IS 'Threshold unique identifier';


--
-- Name: COLUMN thresholds.descr; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.descr IS 'Threshold description';


--
-- Name: COLUMN thresholds.disable; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.disable IS 'Disable threshold if TRUE';


--
-- Name: COLUMN thresholds.group_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.group_id IS 'Watch the traffic of the group';


--
-- Name: COLUMN thresholds.host_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.host_id IS 'Watch the traffic of the host';


--
-- Name: COLUMN thresholds.stat_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.stat_id IS 'Stat to watch for';


--
-- Name: COLUMN thresholds.grace; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.grace IS 'A flood is created if the threshold matches traffic for grace seconds';


--
-- Name: COLUMN thresholds.min; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.min IS 'TRUE if minimum threshold, FALSE if maximum threshold';


--
-- Name: COLUMN thresholds.value; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.value IS 'Threshold matches if stat is lower/higher than value';


--
-- Name: COLUMN thresholds.dyn_short; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.dyn_short IS 'Short averaging period';


--
-- Name: COLUMN thresholds.dyn_long; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.dyn_long IS 'Long averaging period';


--
-- Name: COLUMN thresholds.dyn_percent; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN thresholds.dyn_percent IS 'Short and long periods are percents if TRUE, absolute values if FALSE';


--
-- Name: thresholds_threshold_id_seq; Type: SEQUENCE; Schema: flood; Owner: ndbadm
--

CREATE SEQUENCE thresholds_threshold_id_seq
    START WITH 1000
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE flood.thresholds_threshold_id_seq OWNER TO ndbadm;

--
-- Name: thresholds_threshold_id_seq; Type: SEQUENCE OWNED BY; Schema: flood; Owner: ndbadm
--

ALTER SEQUENCE thresholds_threshold_id_seq OWNED BY thresholds.threshold_id;


--
-- Name: thresholds_threshold_id_seq; Type: SEQUENCE SET; Schema: flood; Owner: ndbadm
--

SELECT pg_catalog.setval('thresholds_threshold_id_seq', 1000, false);


--
-- Name: top_asns; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE top_asns (
    pattern_id INTEGER NOT NULL, 
    capture_id INTEGER NOT NULL, 
    asn INTEGER NOT NULL, 
    asn_matches INTEGER NOT NULL,
    direction INTEGER NOT NULL
);

ALTER TABLE flood.top_asns OWNER TO ndbadm;

COMMENT ON TABLE top_asns IS 'ASNs per each pattern and capture';

COMMENT ON COLUMN top_asns.direction IS '0 - None, 1 - Source, 2 - Destination';

--
-- Name: top_countries; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE top_countries (
    pattern_id INTEGER NOT NULL, 
    capture_id INTEGER NOT NULL, 
    country_code TEXT NOT NULL, 
    country_matches INTEGER NOT NULL,
    direction INTEGER NOT NULL
);

ALTER TABLE flood.top_countries OWNER TO ndbadm;

COMMENT ON TABLE top_countries IS 'ASNs per each pattern and capture';

COMMENT ON COLUMN top_countries.direction IS '0 - None, 1 - Source, 2 - Destination';

--
-- Name: top_hosts_dst; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE top_hosts_dst (
    flood_id integer NOT NULL,
    ip inet NOT NULL,
    avg_bps double precision NOT NULL,
    avg_pps double precision NOT NULL
);


ALTER TABLE flood.top_hosts_dst OWNER TO ndbadm;

--
-- Name: COLUMN top_hosts_dst.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_dst.flood_id IS 'Links to the flood in `registry''';


--
-- Name: COLUMN top_hosts_dst.ip; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_dst.ip IS 'A destination ip, participating in flood';


--
-- Name: COLUMN top_hosts_dst.avg_bps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_dst.avg_bps IS 'Average bits per second received by the ip';


--
-- Name: COLUMN top_hosts_dst.avg_pps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_dst.avg_pps IS 'Average packets per second received by the ip';


--
-- Name: top_hosts_src; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE top_hosts_src (
    flood_id integer NOT NULL,
    ip inet NOT NULL,
    avg_bps double precision NOT NULL,
    avg_pps double precision NOT NULL,
    CONSTRAINT top_hosts_src_avg_bps_check CHECK ((avg_bps > (0)::double precision)),
    CONSTRAINT top_hosts_src_avg_pps_check CHECK ((avg_pps > (0)::double precision))
);


ALTER TABLE flood.top_hosts_src OWNER TO ndbadm;

--
-- Name: COLUMN top_hosts_src.flood_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_src.flood_id IS 'Links to the flood in `registry''';


--
-- Name: COLUMN top_hosts_src.ip; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_src.ip IS 'A source ip, participating in flood';


--
-- Name: COLUMN top_hosts_src.avg_bps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_src.avg_bps IS 'Average bits per second sent by the ip';


--
-- Name: COLUMN top_hosts_src.avg_pps; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN top_hosts_src.avg_pps IS 'Average packets per second sent by the ip';


--
-- Name: top_interfaces; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE top_interfaces (
    flood_id integer NOT NULL,
    interfaces text,
    bytes integer
);


ALTER TABLE flood.top_interfaces OWNER TO ndbadm;

--
-- Name: types; Type: TABLE; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE TABLE types (
    type_id integer NOT NULL,
    name text NOT NULL,
    descr text,
    CONSTRAINT forbid_empty_descr CHECK (((descr IS NULL) OR (length(descr) > 0)))
);


ALTER TABLE flood.types OWNER TO ndbadm;

--
-- Name: TABLE types; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON TABLE types IS 'Flood-like anomaly types catalogue';


--
-- Name: COLUMN types.type_id; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN types.type_id IS 'Unique identifier of the type';


--
-- Name: COLUMN types.name; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN types.name IS 'Unique name of the type';


--
-- Name: COLUMN types.descr; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON COLUMN types.descr IS 'Verbose description of the type';


--
-- Name: types_type_id_seq; Type: SEQUENCE; Schema: flood; Owner: ndbadm
--

CREATE SEQUENCE types_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE flood.types_type_id_seq OWNER TO ndbadm;

--
-- Name: types_type_id_seq; Type: SEQUENCE OWNED BY; Schema: flood; Owner: ndbadm
--

ALTER SEQUENCE types_type_id_seq OWNED BY types.type_id;


--
-- Name: types_type_id_seq; Type: SEQUENCE SET; Schema: flood; Owner: ndbadm
--

SELECT pg_catalog.setval('types_type_id_seq', 32, true);


SET search_path = notify, pg_catalog;

--
-- Name: complete_targets; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE complete_targets (
    target_id integer NOT NULL,
    CONSTRAINT complete_targets_target_id_check CHECK (target_complete(target_id))
);


ALTER TABLE notify.complete_targets OWNER TO ndbadm;

--
-- Name: TABLE complete_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON TABLE complete_targets IS 'Table containing IDs of complete targets only';


--
-- Name: COLUMN complete_targets.target_id; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN complete_targets.target_id IS 'Identificator of a complete target';


--
-- Name: data_type_operators; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE data_type_operators (
    data_type_id integer NOT NULL,
    operator_id integer NOT NULL
);


ALTER TABLE notify.data_type_operators OWNER TO ndbadm;

--
-- Name: data_types; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE data_types (
    data_type_id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE notify.data_types OWNER TO ndbadm;

--
-- Name: data_types_data_type_id_seq; Type: SEQUENCE; Schema: notify; Owner: ndbadm
--

CREATE SEQUENCE data_types_data_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notify.data_types_data_type_id_seq OWNER TO ndbadm;

--
-- Name: data_types_data_type_id_seq; Type: SEQUENCE OWNED BY; Schema: notify; Owner: ndbadm
--

ALTER SEQUENCE data_types_data_type_id_seq OWNED BY data_types.data_type_id;


--
-- Name: data_types_data_type_id_seq; Type: SEQUENCE SET; Schema: notify; Owner: ndbadm
--

SELECT pg_catalog.setval('data_types_data_type_id_seq', 6, true);


--
-- Name: fields; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE fields (
    field_id integer NOT NULL,
    type_id integer NOT NULL,
    data_type_id integer NOT NULL,
    name text NOT NULL,
    descr text NOT NULL,
    constraints text[],
    constr_msgs text[],
    operand_descr text
);


ALTER TABLE notify.fields OWNER TO ndbadm;

--
-- Name: COLUMN fields.constraints; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN fields.constraints IS 'Restrictions for values accepted by the field';


--
-- Name: COLUMN fields.constr_msgs; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN fields.constr_msgs IS 'Error messages to show for the corresponding constraints';


--
-- Name: COLUMN fields.operand_descr; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN fields.operand_descr IS 'Field value description (e.g. value should be > 0)';


--
-- Name: fields_field_id_seq; Type: SEQUENCE; Schema: notify; Owner: ndbadm
--

CREATE SEQUENCE fields_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notify.fields_field_id_seq OWNER TO ndbadm;

--
-- Name: fields_field_id_seq; Type: SEQUENCE OWNED BY; Schema: notify; Owner: ndbadm
--

ALTER SEQUENCE fields_field_id_seq OWNED BY fields.field_id;


--
-- Name: fields_field_id_seq; Type: SEQUENCE SET; Schema: notify; Owner: ndbadm
--

SELECT pg_catalog.setval('fields_field_id_seq', 104, true);


--
-- Name: filter_parts; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE filter_parts (
    filter_id integer NOT NULL,
    field_id integer NOT NULL,
    type_id integer NOT NULL,
    data_type_id integer NOT NULL,
    operator_id integer NOT NULL,
    operand text[] NOT NULL 
);


ALTER TABLE notify.filter_parts OWNER TO ndbadm;

--
-- Name: filter_targets; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE filter_targets (
    filter_id integer NOT NULL,
    target_id integer NOT NULL,
    CONSTRAINT filter_targets__check_templates CHECK ((filter_templates_exists(filter_id, target_type_id(target_id)) OR filter_is_subfilter(filter_id))),
    CONSTRAINT filter_targets_importance_check_children CHECK (((target_type(target_id) <> 'importance'::text) OR filter_action_importance_check_children_p(filter_id, (target_addr(target_id))::integer))),
    CONSTRAINT filter_targets_importance_check_parents CHECK (((target_type(target_id) <> 'importance'::text) OR filter_action_importance_check_parents_p(filter_id, (target_addr(target_id))::integer)))
);


ALTER TABLE notify.filter_targets OWNER TO ndbadm;

--
-- Name: CONSTRAINT filter_targets__check_templates ON filter_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_targets__check_templates ON filter_targets IS 'Template doesn''t exist';


--
-- Name: CONSTRAINT filter_targets_importance_check_children ON filter_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_targets_importance_check_children ON filter_targets IS 'A child policy sets lower or same importance';


--
-- Name: CONSTRAINT filter_targets_importance_check_parents ON filter_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_targets_importance_check_parents ON filter_targets IS 'A parent policy sets higher or same importance';


--
-- Name: filters; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE filters (
    filter_id integer NOT NULL,
    type_id integer NOT NULL,
    name text NOT NULL,
    descr text,
    parent integer,
    keepalive integer,
    disable boolean DEFAULT false NOT NULL,
    modified timestamp with time zone DEFAULT now() NOT NULL,
    generation smallint DEFAULT 0 NOT NULL,
    update_on_stop boolean DEFAULT true NOT NULL
);


ALTER TABLE notify.filters OWNER TO ndbadm;

--
-- Name: COLUMN filters.keepalive; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN filters.keepalive IS 'Send additional message if keepalive seconds passed since sending previous
message and the event is still active';


--
-- Name: COLUMN filters.disable; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN filters.disable IS 'Stop processing filter if TRUE';


--
-- Name: COLUMN filters.modified; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN filters.modified IS 'When any part of filter changed (auto, srv)';


--
-- Name: COLUMN filters.generation; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN filters.generation IS 'Incremented when filter is changed (auto, srv)';


--
-- Name: COLUMN filters.update_on_stop; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN filters.update_on_stop IS 'Send complementary flood stop notification if TRUE';


--
-- Name: filters_filter_id_seq; Type: SEQUENCE; Schema: notify; Owner: ndbadm
--

CREATE SEQUENCE filters_filter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notify.filters_filter_id_seq OWNER TO ndbadm;

--
-- Name: filters_filter_id_seq; Type: SEQUENCE OWNED BY; Schema: notify; Owner: ndbadm
--

ALTER SEQUENCE filters_filter_id_seq OWNED BY filters.filter_id;


--
-- Name: filters_filter_id_seq; Type: SEQUENCE SET; Schema: notify; Owner: ndbadm
--

SELECT pg_catalog.setval('filters_filter_id_seq', 60, true);


--
-- Name: operators; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE operators (
    operator_id integer NOT NULL,
    on_set boolean DEFAULT false NOT NULL,
    name text NOT NULL,
    descr text NOT NULL
);


ALTER TABLE notify.operators OWNER TO ndbadm;

--
-- Name: operators_operator_id_seq; Type: SEQUENCE; Schema: notify; Owner: ndbadm
--

CREATE SEQUENCE operators_operator_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notify.operators_operator_id_seq OWNER TO ndbadm;

--
-- Name: operators_operator_id_seq; Type: SEQUENCE OWNED BY; Schema: notify; Owner: ndbadm
--

ALTER SEQUENCE operators_operator_id_seq OWNED BY operators.operator_id;


--
-- Name: operators_operator_id_seq; Type: SEQUENCE SET; Schema: notify; Owner: ndbadm
--

SELECT pg_catalog.setval('operators_operator_id_seq', 10, true);


--
-- Name: targets; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE targets (
    target_id integer NOT NULL,
    target_type_id integer NOT NULL,
    name text NOT NULL,
    addr text,
    descr text,
    complete boolean DEFAULT false,
    CONSTRAINT targets_check CHECK (((NOT complete) OR (addr IS NOT NULL))),
    CONSTRAINT targets_name_no_space_check CHECK (("position"(name, ' '::text) = 0))
);


ALTER TABLE notify.targets OWNER TO ndbadm;

--
-- Name: COLUMN targets.name; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN targets.name IS 'Target name (unique per target type)';


--
-- Name: COLUMN targets.complete; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN targets.complete IS 'If addr contains essential part (e.g. host name) that makes addr actually usable, then complete is TRUE';


--
-- Name: CONSTRAINT targets_name_no_space_check ON targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT targets_name_no_space_check ON targets IS 'Target name must not contain whitespace';


--
-- Name: targets_target_id_seq; Type: SEQUENCE; Schema: notify; Owner: ndbadm
--

CREATE SEQUENCE targets_target_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notify.targets_target_id_seq OWNER TO ndbadm;

--
-- Name: targets_target_id_seq; Type: SEQUENCE OWNED BY; Schema: notify; Owner: ndbadm
--

ALTER SEQUENCE targets_target_id_seq OWNED BY targets.target_id;


--
-- Name: targets_target_id_seq; Type: SEQUENCE SET; Schema: notify; Owner: ndbadm
--

SELECT pg_catalog.setval('targets_target_id_seq', 40, true);


--
-- Name: templates; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE templates (
    template_id integer NOT NULL,
    target_type_id integer NOT NULL,
    type_id integer NOT NULL,
    name text NOT NULL,
    template text NOT NULL,
    allow_targets boolean DEFAULT true NOT NULL
);


ALTER TABLE notify.templates OWNER TO ndbadm;

--
-- Name: COLUMN templates.allow_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN templates.allow_targets IS 'Allow targets of target type to be assigned to filter if TRUE';


--
-- Name: templates_template_id_seq; Type: SEQUENCE; Schema: notify; Owner: ndbadm
--

CREATE SEQUENCE templates_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notify.templates_template_id_seq OWNER TO ndbadm;

--
-- Name: templates_template_id_seq; Type: SEQUENCE OWNED BY; Schema: notify; Owner: ndbadm
--

ALTER SEQUENCE templates_template_id_seq OWNED BY templates.template_id;


--
-- Name: templates_template_id_seq; Type: SEQUENCE SET; Schema: notify; Owner: ndbadm
--

SELECT pg_catalog.setval('templates_template_id_seq', 41, true);


--
-- Name: type_links; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE type_links (
    type_id integer NOT NULL,
    "from" integer,
    "to" integer NOT NULL,
    sql text NOT NULL,
    id_field text,
    CONSTRAINT type_links_check CHECK (type_link_valid(type_id, "from", "to"))
);


ALTER TABLE notify.type_links OWNER TO ndbadm;

--
-- Name: TABLE type_links; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON TABLE type_links IS 'Stores parent-child relationships between types';


--
-- Name: COLUMN type_links.type_id; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN type_links.type_id IS 'Type the link belongs to';


--
-- Name: COLUMN type_links."from"; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN type_links."from" IS 'Parent side of a link (may be NULL)';


--
-- Name: COLUMN type_links."to"; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN type_links."to" IS 'Child side of a link';


--
-- Name: COLUMN type_links.sql; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN type_links.sql IS 'SQL for getting instances of the child type of a link';


--
-- Name: COLUMN type_links.id_field; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON COLUMN type_links.id_field IS 'Name of field containing event ID (as specified in the `sql'' field)';


--
-- Name: types; Type: TABLE; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE TABLE types (
    type_id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE notify.types OWNER TO ndbadm;

--
-- Name: types_type_id_seq; Type: SEQUENCE; Schema: notify; Owner: ndbadm
--

CREATE SEQUENCE types_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notify.types_type_id_seq OWNER TO ndbadm;

--
-- Name: types_type_id_seq; Type: SEQUENCE OWNED BY; Schema: notify; Owner: ndbadm
--

ALTER SEQUENCE types_type_id_seq OWNED BY types.type_id;


--
-- Name: types_type_id_seq; Type: SEQUENCE SET; Schema: notify; Owner: ndbadm
--

SELECT pg_catalog.setval('types_type_id_seq', 3, true);


SET search_path = nx, pg_catalog;

--
-- Name: map; Type: TABLE; Schema: nx; Owner: ndbadm; Tablespace: 
--

CREATE TABLE map (
    ip inet NOT NULL,
    hostlist_id integer NOT NULL,
    current text,
    applied_request_id integer,
    added timestamp with time zone,
    expires timestamp with time zone,
    target text NOT NULL,
    request_id integer NOT NULL,
    CONSTRAINT map_current_check CHECK ((((current IS NULL) OR (current = 'add'::text)) OR (current = 'remove'::text))),
    CONSTRAINT map_target_check CHECK (((target = 'add'::text) OR (target = 'remove'::text))),
    CONSTRAINT target_nx_hostlist CHECK ((notify.target_type(hostlist_id) = 'nx-hostlist'::text))
);


ALTER TABLE nx.map OWNER TO ndbadm;

--
-- Name: TABLE map; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON TABLE map IS 'NX host list requests and their state';


--
-- Name: COLUMN map.ip; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.ip IS 'IP to add/remove from NX host list';


--
-- Name: COLUMN map.hostlist_id; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.hostlist_id IS 'Unique identifier of host list';


--
-- Name: COLUMN map.current; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.current IS 'State of request, `add'' if IP was added to host list, `remove'' if IP was removed from host lit';


--
-- Name: COLUMN map.applied_request_id; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.applied_request_id IS 'Unique revision of the request that has been applied';


--
-- Name: COLUMN map.added; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.added IS 'IP was added to host list at this time';


--
-- Name: COLUMN map.expires; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.expires IS 'IP will be removed from host list after this time';


--
-- Name: COLUMN map.target; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.target IS 'Request to be applied, can be either `add'' or `remove''';


--
-- Name: COLUMN map.request_id; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON COLUMN map.request_id IS 'Unique revision of the request';


SET search_path = public, pg_catalog;

--
-- Name: cluster_config; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE cluster_config (
    cluster_id integer NOT NULL,
    min_sensors integer DEFAULT 1 NOT NULL,
    fail_grace boolean DEFAULT true NOT NULL
);


ALTER TABLE public.cluster_config OWNER TO ndbadm;

--
-- Name: group_config; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE group_config (
    prefix cidr NOT NULL,
    group_id integer NOT NULL,
    "from" timestamp with time zone DEFAULT now() NOT NULL,
    "to" timestamp with time zone,
    descr text
);


ALTER TABLE public.group_config OWNER TO ndbadm;

--
-- Name: current_group_config; Type: VIEW; Schema: public; Owner: ndbadm
--

CREATE VIEW current_group_config AS
    SELECT group_config.prefix, group_config.group_id, group_config."from", group_config."to", group_config.descr FROM group_config WHERE (group_config."to" IS NULL);


ALTER TABLE public.current_group_config OWNER TO ndbadm;

--
-- Name: data_tables; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE data_tables (
    table_id integer NOT NULL,
    host_id integer NOT NULL,
    group_id integer NOT NULL,
    struct_id integer NOT NULL,
    relid oid NOT NULL,
    width double precision NOT NULL,
    period integer NOT NULL,
    cookie integer
);


ALTER TABLE public.data_tables OWNER TO ndbadm;

--
-- Name: data_tables_table_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE data_tables_table_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.data_tables_table_id_seq OWNER TO ndbadm;

--
-- Name: data_tables_table_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE data_tables_table_id_seq OWNED BY data_tables.table_id;


--
-- Name: data_tables_table_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('data_tables_table_id_seq', 1, false);


--
-- Name: group_mapping; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE group_mapping (
    host_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.group_mapping OWNER TO ndbadm;

--
-- Name: groups; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE groups (
    group_id integer NOT NULL,
    name text NOT NULL,
    descr text,
    f_inside boolean DEFAULT true NOT NULL,
    f_dos boolean DEFAULT true NOT NULL,
    f_rawcap boolean DEFAULT false NOT NULL,
    f_decodetun boolean DEFAULT true NOT NULL,
    f_quarantine boolean DEFAULT true NOT NULL,
    group_type varchar(10) DEFAULT 'IPV4' NOT NULL,
    CONSTRAINT dos_inside_only CHECK (((NOT f_dos) OR f_inside)),
    CONSTRAINT quarantine_inside_only CHECK (((NOT f_quarantine) OR f_inside))
);


ALTER TABLE public.groups OWNER TO ndbadm;

--
-- Name: CONSTRAINT dos_inside_only ON groups; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT dos_inside_only ON groups IS 'Only inside groups can have floods enabled';


--
-- Name: CONSTRAINT quarantine_inside_only ON groups; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT quarantine_inside_only ON groups IS 'Only inside groups can have Quarantine enabled';

--
-- Name: COLUMN groups.group_type; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN groups.group_type IS 'group type - IPV4 or IPV6';


--
-- Name: groups_group_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE groups_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.groups_group_id_seq OWNER TO ndbadm;

--
-- Name: groups_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE groups_group_id_seq OWNED BY groups.group_id;


--
-- Name: groups_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('groups_group_id_seq', 1001, true);


--
-- Name: hosts; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE hosts (
    host_id integer NOT NULL,
    name text NOT NULL,
    ip inet,
    is_hydra boolean DEFAULT false NOT NULL,
    cap_hydra boolean DEFAULT false NOT NULL,
    is_sensor boolean DEFAULT false NOT NULL,
    cap_sensor boolean DEFAULT false NOT NULL,
    cap_tasks_max integer DEFAULT 4 NOT NULL,
    ssh_key text,
    descr text,
    shutdown boolean NOT NULL,
    tunnel_via inet,
    f_aos boolean DEFAULT false NOT NULL,
    is_cluster boolean DEFAULT false NOT NULL,
    max_groups integer,
	management_protocol text DEFAULT 'http' NOT NULL,
	management_port integer DEFAULT 80 NOT NULL,
    CONSTRAINT hosts_cap_tasks_max_check CHECK ((cap_tasks_max >= 0))
);


ALTER TABLE public.hosts OWNER TO ndbadm;

--
-- Name: COLUMN hosts.cap_tasks_max; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN hosts.cap_tasks_max IS 'Maximum number of lb tasks that can be run on the host';


--
-- Name: hosts_host_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE hosts_host_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.hosts_host_id_seq OWNER TO ndbadm;

--
-- Name: hosts_host_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE hosts_host_id_seq OWNED BY hosts.host_id;


--
-- Name: hosts_host_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('hosts_host_id_seq', 1, true);


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE permissions (
    user_id integer NOT NULL,
    attribute text NOT NULL,
    host_id integer,
    group_id integer
);


ALTER TABLE public.permissions OWNER TO ndbadm;

--
-- Name: post_target_types; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE post_target_types (
    target_type_id integer NOT NULL,
    name text NOT NULL,
    descr text,
    multiple boolean DEFAULT true NOT NULL,
    zero_keepalive boolean DEFAULT false NOT NULL
);


ALTER TABLE public.post_target_types OWNER TO ndbadm;

--
-- Name: COLUMN post_target_types.descr; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN post_target_types.descr IS 'Target description';


--
-- Name: COLUMN post_target_types.multiple; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN post_target_types.multiple IS 'Allow multiple targets of the type in a filter if TRUE';


--
-- Name: COLUMN post_target_types.zero_keepalive; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN post_target_types.zero_keepalive IS 'If TRUE, run actions of this type whenever event changes';


--
-- Name: post_target_types_target_type_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE post_target_types_target_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.post_target_types_target_type_id_seq OWNER TO ndbadm;

--
-- Name: post_target_types_target_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE post_target_types_target_type_id_seq OWNED BY post_target_types.target_type_id;


--
-- Name: post_target_types_target_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('post_target_types_target_type_id_seq', 11, true);


--
-- Name: sensor_clusters; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE sensor_clusters (
    cluster_id integer NOT NULL,
    member_id integer NOT NULL
);


ALTER TABLE public.sensor_clusters OWNER TO ndbadm;

--
-- Name: statistics; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE statistics (
    stat_id integer NOT NULL,
    struct_id integer NOT NULL,
    name text NOT NULL,
    descr text
);


ALTER TABLE public.statistics OWNER TO ndbadm;

--
-- Name: statistics_stat_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE statistics_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.statistics_stat_id_seq OWNER TO ndbadm;

--
-- Name: statistics_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE statistics_stat_id_seq OWNED BY statistics.stat_id;


--
-- Name: statistics_stat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('statistics_stat_id_seq', 116, true);


--
-- Name: struct_types; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE struct_types (
    type_id integer NOT NULL,
    name text NOT NULL,
    descr text
);


ALTER TABLE public.struct_types OWNER TO ndbadm;

--
-- Name: struct_types_type_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE struct_types_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.struct_types_type_id_seq OWNER TO ndbadm;

--
-- Name: struct_types_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE struct_types_type_id_seq OWNED BY struct_types.type_id;


--
-- Name: struct_types_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('struct_types_type_id_seq', 2, true);


--
-- Name: structs; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE structs (
    struct_id integer NOT NULL,
    name text NOT NULL,
    type_id integer NOT NULL,
    descr text
);


ALTER TABLE public.structs OWNER TO ndbadm;

--
-- Name: structs_struct_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE structs_struct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.structs_struct_id_seq OWNER TO ndbadm;

--
-- Name: structs_struct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE structs_struct_id_seq OWNED BY structs.struct_id;


--
-- Name: structs_struct_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('structs_struct_id_seq', 3, true);


--
-- Name: subsystems; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE TABLE subsystems (
    subsystem_id integer NOT NULL,
    name text NOT NULL,
    host_id integer NOT NULL,
    alive timestamp with time zone DEFAULT now() NOT NULL,
    cookie text
);


ALTER TABLE public.subsystems OWNER TO ndbadm;

--
-- Name: COLUMN subsystems.subsystem_id; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN subsystems.subsystem_id IS 'Subsystem ID.';


--
-- Name: COLUMN subsystems.name; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN subsystems.name IS 'Subsystem name (unique at each host).';


--
-- Name: COLUMN subsystems.host_id; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN subsystems.host_id IS 'ID of host where subsystem runs.';


--
-- Name: COLUMN subsystems.alive; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN subsystems.alive IS 'Until after this time subsystem is perceived to be alive.';


--
-- Name: COLUMN subsystems.cookie; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON COLUMN subsystems.cookie IS 'Allows to override alive while registering subsystem (see subsystem_register().';


--
-- Name: subsystems_subsystem_id_seq; Type: SEQUENCE; Schema: public; Owner: ndbadm
--

CREATE SEQUENCE subsystems_subsystem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subsystems_subsystem_id_seq OWNER TO ndbadm;

--
-- Name: subsystems_subsystem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ndbadm
--

ALTER SEQUENCE subsystems_subsystem_id_seq OWNED BY subsystems.subsystem_id;


--
-- Name: subsystems_subsystem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ndbadm
--

SELECT pg_catalog.setval('subsystems_subsystem_id_seq', 5, true);


--
-- Name: param; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace:  
--

CREATE TABLE param (
   NAME                 varchar(32)                    not null,
   SUBNAME              varchar(32)                    not null,
   INT_VAL              int                            null,
   STR_VAL              varchar(4096)                  null,
   DATE_VAL             timestamp with time zone       null,
   DESCRIPTION          varchar(100)                   null,
   constraint PK_PARAM primary key (NAME, SUBNAME)
);

ALTER TABLE public.param OWNER TO ndbadm;

comment on column param.name is 
'group name for the logical group of variables';

comment on column param.subname is 
'Parameter name of the specific parameter in the group';

--
-- Name: mitigation; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace:  
--

CREATE TABLE mitigation (
   option           varchar(32)     NOT NULL,
   is_enabled       boolean default false NOT NULL,
   constraint pk_mitigation primary key (option)
);

ALTER TABLE public.mitigation OWNER TO ndbadm;

--
-- Name: smtp; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace:  
--
CREATE TABLE smtp (
	host_ip          text NOT NULL,
	port             INTEGER DEFAULT 25 NOT NULL,
	from_address     text DEFAULT 'spc@allot.com' NOT NULL,
	replayto_address text DEFAULT 'spc@allot.com' NOT NULL,
	is_auth          BOOLEAN DEFAULT false NOT NULL,
	username         text,
	password         text,
	start_tls           BOOLEAN DEFAULT false NOT NULL,
	constraint pk_smtp primary key (host_ip),
	constraint uniqe_server_ip UNIQUE (host_ip)
);

ALTER TABLE public.smtp OWNER TO ndbadm;

--
-- Name: pattern_analysis_config; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace:  
--
CREATE TABLE pattern_analysis_config
(
                name text NOT NULL,
                value text NOT NULL,
                description text,
                constraint PK_PATTERN_ANALYSIS_CONFIG primary key (name)
);

ALTER TABLE public.pattern_analysis_config OWNER TO ndbadm;

SET search_path = purge, pg_catalog;

--
-- Name: dbstate; Type: TABLE; Schema: purge; Owner: ndbadm; Tablespace: 
--

/* original hb
CREATE TABLE dbstate (
    at timestamp with time zone NOT NULL,
    runtime integer NOT NULL,
    used double precision NOT NULL,
    churn double precision NOT NULL,
    growth double precision NOT NULL,
    physize double precision NOT NULL,
    uselimit double precision NOT NULL,
    CONSTRAINT dbstate_runtime_check CHECK ((runtime > 0))
);
*/

-- New dbstate table (hb)
CREATE TABLE dbstate (
    at timestamp with time zone NOT NULL,
    used bigint NOT NULL,
    growth bigint NOT NULL,
    physize bigint NOT NULL,
    uselimit bigint NOT NULL
);

ALTER TABLE purge.dbstate OWNER TO ndbadm;

--
-- Name: history; Type: TABLE; Schema: purge; Owner: ndbadm; Tablespace: 
--

CREATE TABLE history (
    relid oid NOT NULL,
    at timestamp with time zone NOT NULL,
    elapsed integer NOT NULL,
    runtime integer NOT NULL,
    rows bigint NOT NULL,
    dead bigint NOT NULL,
    purged bigint NOT NULL,
    churn bigint NOT NULL,
    growth bigint NOT NULL,
    pages bigint NOT NULL,
    fsm bigint NOT NULL,
    width double precision NOT NULL,
    CONSTRAINT history_elapsed_check CHECK ((elapsed > 0)),
    CONSTRAINT history_runtime_check CHECK ((runtime > 0))
);


ALTER TABLE purge.history OWNER TO ndbadm;

--
-- Name: jobs; Type: TABLE; Schema: purge; Owner: ndbadm; Tablespace: 
--

CREATE TABLE jobs (
    jobid integer NOT NULL,
    state character(1) DEFAULT 's'::bpchar NOT NULL,
    at timestamp with time zone DEFAULT now() NOT NULL,
    relname text NOT NULL,
    attname text NOT NULL,
    query text NOT NULL,
    descr text NOT NULL,
    pid integer,
    result text
);


ALTER TABLE purge.jobs OWNER TO ndbadm;

--
-- Name: jobs_jobid_seq; Type: SEQUENCE; Schema: purge; Owner: ndbadm
--

CREATE SEQUENCE jobs_jobid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE purge.jobs_jobid_seq OWNER TO ndbadm;

--
-- Name: jobs_jobid_seq; Type: SEQUENCE OWNED BY; Schema: purge; Owner: ndbadm
--

ALTER SEQUENCE jobs_jobid_seq OWNED BY jobs.jobid;


--
-- Name: jobs_jobid_seq; Type: SEQUENCE SET; Schema: purge; Owner: ndbadm
--

SELECT pg_catalog.setval('jobs_jobid_seq', 1, false);


--
-- Name: relstate; Type: TABLE; Schema: purge; Owner: ndbadm; Tablespace: 
--

CREATE TABLE relstate (
    relid oid NOT NULL,
    created timestamp with time zone NOT NULL,
    vacuumed timestamp with time zone,
    analyzed timestamp with time zone,
    rows bigint DEFAULT 0 NOT NULL,
    purged bigint DEFAULT 0 NOT NULL,
    used double precision DEFAULT 0.0 NOT NULL,
    growth double precision DEFAULT 0.0 NOT NULL,
    churn double precision DEFAULT 0.0 NOT NULL
);


ALTER TABLE purge.relstate OWNER TO ndbadm;

--
-- Name: rules_rule_id_seq; Type: SEQUENCE; Schema: purge; Owner: ndbadm
--

CREATE SEQUENCE rules_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE purge.rules_rule_id_seq OWNER TO ndbadm;

--
-- Name: rules_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: purge; Owner: ndbadm
--

ALTER SEQUENCE rules_rule_id_seq OWNED BY rules.rule_id;


--
-- Name: rules_rule_id_seq; Type: SEQUENCE SET; Schema: purge; Owner: ndbadm
--

SELECT pg_catalog.setval('rules_rule_id_seq', 6, true);


SET search_path = quarantine, pg_catalog;

--
-- Name: captures_capture_id_seq; Type: SEQUENCE; Schema: quarantine; Owner: ndbadm
--

CREATE SEQUENCE captures_capture_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE quarantine.captures_capture_id_seq OWNER TO ndbadm;

--
-- Name: captures_capture_id_seq; Type: SEQUENCE OWNED BY; Schema: quarantine; Owner: ndbadm
--

ALTER SEQUENCE captures_capture_id_seq OWNED BY captures.capture_id;


--
-- Name: captures_capture_id_seq; Type: SEQUENCE SET; Schema: quarantine; Owner: ndbadm
--

SELECT pg_catalog.setval('captures_capture_id_seq', 1, false);


--
-- Name: event_types; Type: TABLE; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE TABLE event_types (
    type_id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE quarantine.event_types OWNER TO ndbadm;

--
-- Name: TABLE event_types; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON TABLE event_types IS 'Catalogue of Quarantine event types';


--
-- Name: COLUMN event_types.type_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN event_types.type_id IS 'Unique identifier of the type';


--
-- Name: COLUMN event_types.name; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN event_types.name IS 'Unique name of the type';


--
-- Name: event_types_type_id_seq; Type: SEQUENCE; Schema: quarantine; Owner: ndbadm
--

CREATE SEQUENCE event_types_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE quarantine.event_types_type_id_seq OWNER TO ndbadm;

--
-- Name: event_types_type_id_seq; Type: SEQUENCE OWNED BY; Schema: quarantine; Owner: ndbadm
--

ALTER SEQUENCE event_types_type_id_seq OWNED BY event_types.type_id;


--
-- Name: event_types_type_id_seq; Type: SEQUENCE SET; Schema: quarantine; Owner: ndbadm
--

SELECT pg_catalog.setval('event_types_type_id_seq', 5, true);


--
-- Name: events; Type: TABLE; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE TABLE events (
    capture_id integer NOT NULL,
    type_id integer NOT NULL,
    target_proto integer,
    target_ip inet,
    target_port integer,
    spread integer NOT NULL,
    flows integer NOT NULL,
    packets integer NOT NULL,
    bytes integer NOT NULL,
    CONSTRAINT events_check CHECK ((((target_proto IS NOT NULL) OR (target_ip IS NOT NULL)) OR (target_port IS NOT NULL))),
    CONSTRAINT events_target_port_check CHECK ((target_port >= 0))
);


ALTER TABLE quarantine.events OWNER TO ndbadm;

--
-- Name: TABLE events; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON TABLE events IS 'Quarantine events registered for the flow captures';


--
-- Name: COLUMN events.capture_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.capture_id IS 'Links to the flow capture in `captures''';


--
-- Name: COLUMN events.type_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.type_id IS 'Type of the event';


--
-- Name: COLUMN events.target_proto; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.target_proto IS 'IP protocol number of the targets, if same';


--
-- Name: COLUMN events.target_ip; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.target_ip IS 'IP address of the targets, if same';


--
-- Name: COLUMN events.target_port; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.target_port IS 'TCP/UDP port number of the targets, if same';


--
-- Name: COLUMN events.spread; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.spread IS 'How many unique targets the event had';


--
-- Name: COLUMN events.flows; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.flows IS 'How many distinct flows the event spanned';


--
-- Name: COLUMN events.packets; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.packets IS 'Total packet count for all the flows in the event';


--
-- Name: COLUMN events.bytes; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN events.bytes IS 'Total byte count for all the flows in the event';


--
-- Name: importance; Type: TABLE; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE TABLE importance (
    capture_id integer NOT NULL,
    importance smallint NOT NULL,
    filter_id integer,
    uid integer,
    CONSTRAINT importance_filter_id_check CHECK ((notify.filter_type_id(filter_id) = notify.type_id('quarantine'::text))),
    CONSTRAINT importance_filter_id_uid_check CHECK ((NOT ((uid IS NOT NULL) AND (filter_id IS NOT NULL)))),
    CONSTRAINT importance_importance_check CHECK (((importance >= 0) AND (importance <= 3)))
);


ALTER TABLE quarantine.importance OWNER TO ndbadm;

--
-- Name: TABLE importance; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON TABLE importance IS 'Quarantine importance';


--
-- Name: COLUMN importance.capture_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN importance.capture_id IS 'Quarantine id (ref)';


--
-- Name: COLUMN importance.importance; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN importance.importance IS 'Quarantine importance';


--
-- Name: COLUMN importance.filter_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN importance.filter_id IS 'Importance was set by this filter (ref)';


--
-- Name: COLUMN importance.uid; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN importance.uid IS 'Importance was set by this user (ref)';


--
-- Name: matches; Type: TABLE; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE TABLE matches (
    filter_id integer NOT NULL,
    match_id integer NOT NULL,
    at timestamp with time zone DEFAULT now() NOT NULL,
    CONSTRAINT matches_filter_id_check CHECK ((notify.filter_type_id(notify.filter_root(filter_id)) = notify.type_id('quarantine'::text)))
);


ALTER TABLE quarantine.matches OWNER TO ndbadm;

--
-- Name: TABLE matches; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON TABLE matches IS 'Caches all matches of filters against quarantine events';


--
-- Name: COLUMN matches.filter_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN matches.filter_id IS 'The filter that matched (ref)';


--
-- Name: COLUMN matches.match_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN matches.match_id IS 'The quarantine event that matched (ref)';


--
-- Name: COLUMN matches.at; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN matches.at IS 'When was the match registered (srv)';


--
-- Name: samples; Type: TABLE; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE TABLE samples (
    capture_id integer NOT NULL,
    at timestamp with time zone NOT NULL,
    sample_id integer NOT NULL,
    addr inet NOT NULL,
    user_id integer
);


ALTER TABLE quarantine.samples OWNER TO ndbadm;

--
-- Name: TABLE samples; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON TABLE samples IS 'Traffic samples taken after Quarantine events';


--
-- Name: COLUMN samples.capture_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN samples.capture_id IS 'Links to the flow capture in `captures''';


--
-- Name: COLUMN samples.at; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN samples.at IS 'When the traffic sampling ended';


--
-- Name: COLUMN samples.sample_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN samples.sample_id IS 'FAST document containing the traffic sample';


--
-- Name: sources; Type: TABLE; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE TABLE sources (
    subsystem_id integer NOT NULL,
    group_id integer NOT NULL,
    since timestamp with time zone NOT NULL,
    until timestamp with time zone NOT NULL,
    total integer NOT NULL,
    CONSTRAINT no_period_overlap CHECK ((NOT sources_period_overlap(subsystem_id, group_id, since, until)))
);


ALTER TABLE quarantine.sources OWNER TO ndbadm;

--
-- Name: TABLE sources; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON TABLE sources IS 'Count of active sources per subsystem/group/period tuple';


--
-- Name: COLUMN sources.subsystem_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN sources.subsystem_id IS 'Submitter of the record';


--
-- Name: COLUMN sources.group_id; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN sources.group_id IS 'Subnet group in which the sources were seen';


--
-- Name: COLUMN sources.since; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN sources.since IS 'Period start (inclusive)';


--
-- Name: COLUMN sources.until; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN sources.until IS 'Period end (exclusive)';


--
-- Name: COLUMN sources.total; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON COLUMN sources.total IS 'Count of active sources for the period';


SET search_path = report, pg_catalog;

--
-- Name: list; Type: TABLE; Schema: report; Owner: ndbadm; Tablespace: 
--

CREATE TABLE list (
    report_id integer NOT NULL,
    created timestamp with time zone DEFAULT now() NOT NULL,
    modified timestamp with time zone DEFAULT now() NOT NULL,
    uid integer NOT NULL,
    name text NOT NULL,
    description text,
    period "char" DEFAULT 'N'::"char" NOT NULL,
    CONSTRAINT list_period_check CHECK ((period = ANY (ARRAY['N'::"char", 'D'::"char", 'W'::"char", 'M'::"char"])))
);


ALTER TABLE report.list OWNER TO ndbadm;

--
-- Name: TABLE list; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON TABLE list IS 'Report definitions';


--
-- Name: COLUMN list.report_id; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN list.report_id IS 'Unique identifier of the report';


--
-- Name: COLUMN list.created; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN list.created IS 'When the report was created (auto, srv)';


--
-- Name: COLUMN list.modified; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN list.modified IS 'When the report was changed (auto, srv)';


--
-- Name: COLUMN list.uid; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN list.uid IS 'Links to user that owns the report';


--
-- Name: COLUMN list.name; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN list.name IS 'Name of the report';


--
-- Name: COLUMN list.description; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN list.description IS 'Description of the report';


--
-- Name: COLUMN list.period; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN list.period IS 'When to send the report automatically: No, Daily, Weekly, Monthly';


--
-- Name: list_report_id_seq; Type: SEQUENCE; Schema: report; Owner: ndbadm
--

CREATE SEQUENCE list_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE report.list_report_id_seq OWNER TO ndbadm;

--
-- Name: list_report_id_seq; Type: SEQUENCE OWNED BY; Schema: report; Owner: ndbadm
--

ALTER SEQUENCE list_report_id_seq OWNED BY list.report_id;


--
-- Name: list_report_id_seq; Type: SEQUENCE SET; Schema: report; Owner: ndbadm
--

SELECT pg_catalog.setval('list_report_id_seq', 1, false);


--
-- Name: mail; Type: TABLE; Schema: report; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mail (
    report_id integer NOT NULL,
    mail_id integer NOT NULL
);


ALTER TABLE report.mail OWNER TO ndbadm;

--
-- Name: TABLE mail; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON TABLE mail IS 'Links email addresses to PDF reports';


--
-- Name: COLUMN mail.report_id; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN mail.report_id IS 'Identifier of a report';


--
-- Name: COLUMN mail.mail_id; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN mail.mail_id IS 'Identifier of a `mail contact'' entry';


--
-- Name: views; Type: TABLE; Schema: report; Owner: ndbadm; Tablespace: 
--

CREATE TABLE views (
    view_id integer NOT NULL,
    report_id integer NOT NULL,
    "order" integer NOT NULL,
    definition bytea NOT NULL
);


ALTER TABLE report.views OWNER TO ndbadm;

--
-- Name: TABLE views; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON TABLE views IS 'Views of the report';


--
-- Name: COLUMN views.report_id; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN views.report_id IS 'Links to the report in `list''';


--
-- Name: COLUMN views."order"; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN views."order" IS 'Order of the view in the report';


--
-- Name: COLUMN views.definition; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON COLUMN views.definition IS 'Body of the view';


--
-- Name: views_view_id_seq; Type: SEQUENCE; Schema: report; Owner: ndbadm
--

CREATE SEQUENCE views_view_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE report.views_view_id_seq OWNER TO ndbadm;

--
-- Name: views_view_id_seq; Type: SEQUENCE OWNED BY; Schema: report; Owner: ndbadm
--

ALTER SEQUENCE views_view_id_seq OWNED BY views.view_id;


--
-- Name: views_view_id_seq; Type: SEQUENCE SET; Schema: report; Owner: ndbadm
--

SELECT pg_catalog.setval('views_view_id_seq', 1, false);


SET search_path = smp, pg_catalog;

--
-- Name: map; Type: TABLE; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE TABLE map (
    host_id integer NOT NULL,
    smp_id integer NOT NULL,
    CONSTRAINT map_host_id_cap_sensor CHECK (public.host_cap_sensor(host_id)),
    CONSTRAINT map_smp_id_key CHECK ((notify.target_type(smp_id) = 'smp'::text))
);


ALTER TABLE smp.map OWNER TO ndbadm;

--
-- Name: TABLE map; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TABLE map IS 'Relates Sensors to SMP servers and vice versa';


--
-- Name: COLUMN map.host_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN map.host_id IS 'Sensor where quarantine appears';


--
-- Name: COLUMN map.smp_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN map.smp_id IS 'SMP server to use with sensor';


--
-- Name: mtg_live; Type: TABLE; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_live (
    user_id integer NOT NULL,
    smp_id integer NOT NULL,
    state_id text DEFAULT 'PEND'::text NOT NULL,
    state_details text,
    state_since timestamp with time zone DEFAULT now() NOT NULL,
    refresh boolean DEFAULT true NOT NULL,
    action integer NOT NULL,
    action_expire timestamp with time zone,
    action_param text,
    CONSTRAINT action_is_smp_plan CHECK ((notify.target_type(action) = 'smp-plan'::text)),
    CONSTRAINT smp_id_is_smp CHECK ((notify.target_type(smp_id) = 'smp'::text))
);


ALTER TABLE smp.mtg_live OWNER TO ndbadm;

--
-- Name: TABLE mtg_live; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TABLE mtg_live IS 'Actual mitigation requests';


--
-- Name: COLUMN mtg_live.user_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.user_id IS 'Request is aimed at this subscriber';


--
-- Name: COLUMN mtg_live.smp_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.smp_id IS 'SMP server to mitigate at';


--
-- Name: COLUMN mtg_live.state_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.state_id IS 'Processing stage the request is in';


--
-- Name: COLUMN mtg_live.state_details; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.state_details IS 'Commentary on the state (e.g., reason or error message)';


--
-- Name: COLUMN mtg_live.state_since; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.state_since IS 'When the state last changed (auto, srv)';


--
-- Name: COLUMN mtg_live.refresh; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.refresh IS 'Set upon submit or amendment';


--
-- Name: COLUMN mtg_live.action; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.action IS 'Desired SMP service plan';


--
-- Name: COLUMN mtg_live.action_expire; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_live.action_param; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live.action_param IS 'Optional parameter for the action';


--
-- Name: mtg_live_log_past; Type: TABLE; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_live_log_past (
    user_id integer NOT NULL,
    smp_id integer NOT NULL,
    state_since timestamp without time zone NOT NULL,
    state_until timestamp without time zone DEFAULT now() NOT NULL,
    action integer,
    state_id text NOT NULL,
    state_details text,
    action_param text,
    CONSTRAINT action_is_smp_plan CHECK ((notify.target_type(action) = 'smp-plan'::text)),
    CONSTRAINT smp_id_is_smp CHECK ((notify.target_type(smp_id) = 'smp'::text))
);


ALTER TABLE smp.mtg_live_log_past OWNER TO ndbadm;

--
-- Name: TABLE mtg_live_log_past; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TABLE mtg_live_log_past IS 'Past progress of mitigation requests';


--
-- Name: COLUMN mtg_live_log_past.user_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.user_id IS 'Request was aimed at this subscriber';


--
-- Name: COLUMN mtg_live_log_past.smp_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.smp_id IS 'SMP server to mitigate at';


--
-- Name: COLUMN mtg_live_log_past.state_since; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_since IS 'The moment the request got into the state';


--
-- Name: COLUMN mtg_live_log_past.state_until; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_until IS 'The moment the request got out of the state';


--
-- Name: COLUMN mtg_live_log_past.action; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.action IS 'Desired SMP service plan';


--
-- Name: COLUMN mtg_live_log_past.state_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_id IS 'Processing stage the request was in';


--
-- Name: COLUMN mtg_live_log_past.state_details; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.state_details IS 'Commentary on the state (e.g., reason or error message)';


--
-- Name: COLUMN mtg_live_log_past.action_param; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log_past.action_param IS 'Optional parameter for the action';


--
-- Name: mtg_states; Type: TABLE; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_states (
    state_id text NOT NULL,
    descr text NOT NULL,
    "order" smallint NOT NULL,
    hot boolean NOT NULL,
    ok boolean NOT NULL,
    quiet boolean NOT NULL
);


ALTER TABLE smp.mtg_states OWNER TO ndbadm;

--
-- Name: TABLE mtg_states; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TABLE mtg_states IS 'Mitigation request states catalogue';


--
-- Name: COLUMN mtg_states.state_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.state_id IS 'Unique identifier of the state';


--
-- Name: COLUMN mtg_states.descr; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.descr IS 'Verbose description of the state';


--
-- Name: COLUMN mtg_states."order"; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states."order" IS 'The overall state among many has the highest `order''';


--
-- Name: COLUMN mtg_states.hot; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.hot IS 'Whether the request is still to be upheld';


--
-- Name: COLUMN mtg_states.ok; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.ok IS 'Whether the state denotes normal flow';


--
-- Name: COLUMN mtg_states.quiet; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_states.quiet IS 'Whether the state is not to change soon';


--
-- Name: mtg_live_log; Type: VIEW; Schema: smp; Owner: ndbadm
--

CREATE VIEW mtg_live_log AS
    SELECT mtg_live_log_past.user_id, mtg_live_log_past.smp_id, mtg_live_log_past.action, mtg_live_log_past.state_id, mtg_live_log_past.state_details, mtg_live_log_past.state_since, mtg_live_log_past.state_until, mtg_live_log_past.action_param FROM mtg_live_log_past UNION ALL SELECT mtg_live.user_id, mtg_live.smp_id, mtg_live.action, CASE WHEN (mtg_live.refresh AND mtg_states.hot) THEN 'PEND'::text ELSE mtg_live.state_id END AS state_id, CASE WHEN (mtg_live.refresh AND mtg_states.hot) THEN NULL::text ELSE mtg_live.state_details END AS state_details, mtg_live.state_since, 'infinity'::timestamp with time zone AS state_until, mtg_live.action_param FROM (mtg_live JOIN mtg_states USING (state_id));


ALTER TABLE smp.mtg_live_log OWNER TO ndbadm;

--
-- Name: VIEW mtg_live_log; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON VIEW mtg_live_log IS 'Past progress of mitigation requests';


--
-- Name: COLUMN mtg_live_log.user_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.user_id IS 'Request was aimed at this subscriber';


--
-- Name: COLUMN mtg_live_log.smp_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.smp_id IS 'SMP server to mitigate at';


--
-- Name: COLUMN mtg_live_log.action; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.action IS 'Desired SMP service plan';


--
-- Name: COLUMN mtg_live_log.state_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_id IS 'Processing stage the request was in';


--
-- Name: COLUMN mtg_live_log.state_details; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_details IS 'Commentary on the state (e.g., reason or error message)';


--
-- Name: COLUMN mtg_live_log.state_since; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_since IS 'The moment the request got into the state';


--
-- Name: COLUMN mtg_live_log.state_until; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.state_until IS 'The moment the request got out of the state';


--
-- Name: COLUMN mtg_live_log.action_param; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_live_log.action_param IS 'Optional parameter for the action';


--
-- Name: mtg_reqs; Type: TABLE; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_reqs (
    user_id integer NOT NULL,
    filter_id integer,
    uid integer,
    action integer,
    action_since timestamp with time zone DEFAULT now() NOT NULL,
    action_expire timestamp with time zone,
    action_param text,
    CONSTRAINT action_is_smp_plan CHECK ((notify.target_type(action) = 'smp-plan'::text)),
    CONSTRAINT either_uid_or_filter CHECK (((filter_id IS NULL) <> (uid IS NULL))),
    CONSTRAINT no_param_for_no_action CHECK (((action IS NOT NULL) OR (action_param IS NULL))),
    CONSTRAINT only_manual_null_action CHECK (((action IS NOT NULL) OR (uid IS NOT NULL))),
    CONSTRAINT sensible_expire CHECK ((((action IS NOT NULL) OR (action_expire IS NULL)) AND (action_expire > action_since)))
);


ALTER TABLE smp.mtg_reqs OWNER TO ndbadm;

--
-- Name: TABLE mtg_reqs; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TABLE mtg_reqs IS 'Submitted mitigation requests';


--
-- Name: COLUMN mtg_reqs.user_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.user_id IS 'Request is aimed at this subscriber';


--
-- Name: COLUMN mtg_reqs.filter_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.filter_id IS 'Filter that made the automatic request';


--
-- Name: COLUMN mtg_reqs.uid; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.uid IS 'User that made the manual request';


--
-- Name: COLUMN mtg_reqs.action; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action IS 'Desired SMP service plan';


--
-- Name: COLUMN mtg_reqs.action_since; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action_since IS 'When the action was submitted (auto, srv)';


--
-- Name: COLUMN mtg_reqs.action_expire; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_reqs.action_param; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs.action_param IS 'Optional parameter for the action';


--
-- Name: mtg_reqs_log_past; Type: TABLE; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE TABLE mtg_reqs_log_past (
    user_id integer NOT NULL,
    req_since timestamp without time zone NOT NULL,
    req_until timestamp without time zone DEFAULT now() NOT NULL,
    filter_id integer,
    uid integer,
    action integer,
    action_expire timestamp without time zone,
    action_param text,
    CONSTRAINT action_is_smp_plan CHECK ((notify.target_type(action) = 'smp-plan'::text)),
    CONSTRAINT either_uid_or_filter CHECK (((filter_id IS NULL) <> (uid IS NULL)))
);


ALTER TABLE smp.mtg_reqs_log_past OWNER TO ndbadm;

--
-- Name: TABLE mtg_reqs_log_past; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TABLE mtg_reqs_log_past IS 'Past evolution of mitigation requests';


--
-- Name: COLUMN mtg_reqs_log_past.user_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.user_id IS 'Request was aimed at this subscriber';


--
-- Name: COLUMN mtg_reqs_log_past.req_since; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.req_since IS 'The moment the request was added or updated';


--
-- Name: COLUMN mtg_reqs_log_past.req_until; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.req_until IS 'The moment the request was updated further or removed';


--
-- Name: COLUMN mtg_reqs_log_past.filter_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.filter_id IS 'Filter that made the automatic request';


--
-- Name: COLUMN mtg_reqs_log_past.uid; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.uid IS 'User that made the manual request';


--
-- Name: COLUMN mtg_reqs_log_past.action; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.action IS 'Desired SMP service plan';


--
-- Name: COLUMN mtg_reqs_log_past.action_expire; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_reqs_log_past.action_param; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log_past.action_param IS 'Optional parameter for the action';


--
-- Name: mtg_reqs_log; Type: VIEW; Schema: smp; Owner: ndbadm
--

CREATE VIEW mtg_reqs_log AS
SELECT mtg_reqs_log_past.user_id, mtg_reqs_log_past.action, mtg_reqs_log_past.action_expire, mtg_reqs_log_past.filter_id, mtg_reqs_log_past.uid, mtg_reqs_log_past.req_since, mtg_reqs_log_past.req_until, mtg_reqs_log_past.action_param FROM mtg_reqs_log_past UNION ALL SELECT r.user_id, r.action, r.action_expire, r.filter_id, r.uid, GREATEST(r.action_since, ((SELECT max(p.req_until) AS max FROM mtg_reqs_log_past p WHERE (p.user_id = r.user_id)))::timestamp with time zone) AS req_since, 'infinity'::timestamp with time zone AS req_until, r.action_param FROM mtg_reqs r;


ALTER TABLE smp.mtg_reqs_log OWNER TO ndbadm;

--
-- Name: VIEW mtg_reqs_log; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON VIEW mtg_reqs_log IS 'Past evolution of mitigation requests';


--
-- Name: COLUMN mtg_reqs_log.user_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.user_id IS 'Request was aimed at this subscriber';


--
-- Name: COLUMN mtg_reqs_log.action; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.action IS 'Desired SMP service plan';


--
-- Name: COLUMN mtg_reqs_log.action_expire; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.action_expire IS 'When to remove the action';


--
-- Name: COLUMN mtg_reqs_log.filter_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.filter_id IS 'Filter that made the automatic request';


--
-- Name: COLUMN mtg_reqs_log.uid; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.uid IS 'User that made the manual request';


--
-- Name: COLUMN mtg_reqs_log.req_since; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.req_since IS 'The moment the request was added or updated';


--
-- Name: COLUMN mtg_reqs_log.req_until; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.req_until IS 'The moment the request was updated further or removed';


--
-- Name: COLUMN mtg_reqs_log.action_param; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN mtg_reqs_log.action_param IS 'Optional parameter for the action';


--
-- Name: users; Type: TABLE; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE TABLE users (
    user_id integer NOT NULL,
    name text NOT NULL,
    deleted boolean DEFAULT false NOT NULL,
    modified timestamp with time zone DEFAULT now() NOT NULL,
    state_id text,
    state_details text,
    state_since timestamp with time zone
);


ALTER TABLE smp.users OWNER TO ndbadm;

--
-- Name: TABLE users; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TABLE users IS 'Catalogue of SMP subscribers';


--
-- Name: COLUMN users.user_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN users.user_id IS 'Unique identifier of the subscriber';


--
-- Name: COLUMN users.name; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN users.name IS 'Subscriber name (SMP external ID)';


--
-- Name: COLUMN users.deleted; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN users.deleted IS 'Whether the subscriber was deleted from SMP';


--
-- Name: COLUMN users.modified; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN users.modified IS 'Time of the last update';


--
-- Name: COLUMN users.state_id; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN users.state_id IS 'smp.mtg_live.state_id, aggregated for the subscriber';


--
-- Name: COLUMN users.state_details; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN users.state_details IS 'smp.mtg_live.state_details, aggregated for the subscriber';


--
-- Name: COLUMN users.state_since; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON COLUMN users.state_since IS 'smp.mtg_live.state_since, aggregated for the subscriber';


--
-- Name: users_user_id_seq; Type: SEQUENCE; Schema: smp; Owner: ndbadm
--

CREATE SEQUENCE users_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE smp.users_user_id_seq OWNER TO ndbadm;

--
-- Name: users_user_id_seq; Type: SEQUENCE OWNED BY; Schema: smp; Owner: ndbadm
--

ALTER SEQUENCE users_user_id_seq OWNED BY users.user_id;


--
-- Name: users_user_id_seq; Type: SEQUENCE SET; Schema: smp; Owner: ndbadm
--

SELECT pg_catalog.setval('users_user_id_seq', 1, false);


SET search_path = auth, pg_catalog;

--
-- Name: uid; Type: DEFAULT; Schema: auth; Owner: postgres
--

ALTER TABLE passwd ALTER COLUMN uid SET DEFAULT nextval('passwd_uid_seq'::regclass);


SET search_path = fast, pg_catalog;

--
-- Name: attr_type_id; Type: DEFAULT; Schema: fast; Owner: ndbadm
--

ALTER TABLE attr_types ALTER COLUMN attr_type_id SET DEFAULT nextval('attr_types_attr_type_id_seq'::regclass);


--
-- Name: entity_id; Type: DEFAULT; Schema: fast; Owner: ndbadm
--

ALTER TABLE entities ALTER COLUMN entity_id SET DEFAULT nextval('entities_entity_id_seq'::regclass);


--
-- Name: pat_strip_id; Type: DEFAULT; Schema: fast; Owner: ndbadm
--

ALTER TABLE pat_strips ALTER COLUMN pat_strip_id SET DEFAULT nextval('pat_strips_pat_strip_id_seq'::regclass);


--
-- Name: pattern_id; Type: DEFAULT; Schema: fast; Owner: ndbadm
--

ALTER TABLE patterns ALTER COLUMN pattern_id SET DEFAULT nextval('patterns_pattern_id_seq'::regclass);


--
-- Name: ths_id; Type: DEFAULT; Schema: fast; Owner: ndbadm
--

ALTER TABLE top_host_sets ALTER COLUMN ths_id SET DEFAULT nextval('top_host_sets_ths_id_seq'::regclass);


--
-- Name: type_id; Type: DEFAULT; Schema: fast; Owner: ndbadm
--

ALTER TABLE types ALTER COLUMN type_id SET DEFAULT nextval('types_type_id_seq'::regclass);


SET search_path = fgen, pg_catalog;

--
-- Name: type_id; Type: DEFAULT; Schema: fgen; Owner: ndbadm
--

ALTER TABLE types ALTER COLUMN type_id SET DEFAULT nextval('types_type_id_seq'::regclass);


SET search_path = flood, pg_catalog;

--
-- Name: alert_type_id; Type: DEFAULT; Schema: flood; Owner: ndbadm
--

ALTER TABLE alert_types ALTER COLUMN alert_type_id SET DEFAULT nextval('alert_types_alert_type_id_seq'::regclass);


--
-- Name: alerter_id; Type: DEFAULT; Schema: flood; Owner: ndbadm
--

ALTER TABLE alerters ALTER COLUMN alerter_id SET DEFAULT nextval('alerters_alerter_id_seq'::regclass);


--
-- Name: error_id; Type: DEFAULT; Schema: flood; Owner: ndbadm
--

ALTER TABLE errors ALTER COLUMN error_id SET DEFAULT nextval('errors_error_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: flood; Owner: ndbadm
--

ALTER TABLE mtg_live_log_past ALTER COLUMN id SET DEFAULT nextval('mtg_live_log_past_id_seq'::regclass);


--
-- Name: flood_id; Type: DEFAULT; Schema: flood; Owner: ndbadm
--

ALTER TABLE registry ALTER COLUMN flood_id SET DEFAULT nextval('registry_flood_id_seq'::regclass);


--
-- Name: threshold_id; Type: DEFAULT; Schema: flood; Owner: ndbadm
--

ALTER TABLE thresholds ALTER COLUMN threshold_id SET DEFAULT nextval('thresholds_threshold_id_seq'::regclass);


--
-- Name: type_id; Type: DEFAULT; Schema: flood; Owner: ndbadm
--

ALTER TABLE types ALTER COLUMN type_id SET DEFAULT nextval('types_type_id_seq'::regclass);


SET search_path = notify, pg_catalog;

--
-- Name: data_type_id; Type: DEFAULT; Schema: notify; Owner: ndbadm
--

ALTER TABLE data_types ALTER COLUMN data_type_id SET DEFAULT nextval('data_types_data_type_id_seq'::regclass);


--
-- Name: field_id; Type: DEFAULT; Schema: notify; Owner: ndbadm
--

ALTER TABLE fields ALTER COLUMN field_id SET DEFAULT nextval('fields_field_id_seq'::regclass);


--
-- Name: filter_id; Type: DEFAULT; Schema: notify; Owner: ndbadm
--

ALTER TABLE filters ALTER COLUMN filter_id SET DEFAULT nextval('filters_filter_id_seq'::regclass);


--
-- Name: operator_id; Type: DEFAULT; Schema: notify; Owner: ndbadm
--

ALTER TABLE operators ALTER COLUMN operator_id SET DEFAULT nextval('operators_operator_id_seq'::regclass);


--
-- Name: target_id; Type: DEFAULT; Schema: notify; Owner: ndbadm
--

ALTER TABLE targets ALTER COLUMN target_id SET DEFAULT nextval('targets_target_id_seq'::regclass);


--
-- Name: template_id; Type: DEFAULT; Schema: notify; Owner: ndbadm
--

ALTER TABLE templates ALTER COLUMN template_id SET DEFAULT nextval('templates_template_id_seq'::regclass);


--
-- Name: type_id; Type: DEFAULT; Schema: notify; Owner: ndbadm
--

ALTER TABLE types ALTER COLUMN type_id SET DEFAULT nextval('types_type_id_seq'::regclass);


SET search_path = public, pg_catalog;

--
-- Name: table_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE data_tables ALTER COLUMN table_id SET DEFAULT nextval('data_tables_table_id_seq'::regclass);


--
-- Name: group_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE groups ALTER COLUMN group_id SET DEFAULT nextval('groups_group_id_seq'::regclass);


--
-- Name: host_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE hosts ALTER COLUMN host_id SET DEFAULT nextval('hosts_host_id_seq'::regclass);


--
-- Name: target_type_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE post_target_types ALTER COLUMN target_type_id SET DEFAULT nextval('post_target_types_target_type_id_seq'::regclass);


--
-- Name: stat_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE statistics ALTER COLUMN stat_id SET DEFAULT nextval('statistics_stat_id_seq'::regclass);


--
-- Name: type_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE struct_types ALTER COLUMN type_id SET DEFAULT nextval('struct_types_type_id_seq'::regclass);


--
-- Name: struct_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE structs ALTER COLUMN struct_id SET DEFAULT nextval('structs_struct_id_seq'::regclass);


--
-- Name: subsystem_id; Type: DEFAULT; Schema: public; Owner: ndbadm
--

ALTER TABLE subsystems ALTER COLUMN subsystem_id SET DEFAULT nextval('subsystems_subsystem_id_seq'::regclass);


SET search_path = purge, pg_catalog;

--
-- Name: jobid; Type: DEFAULT; Schema: purge; Owner: ndbadm
--

ALTER TABLE jobs ALTER COLUMN jobid SET DEFAULT nextval('jobs_jobid_seq'::regclass);


--
-- Name: rule_id; Type: DEFAULT; Schema: purge; Owner: ndbadm
--

ALTER TABLE rules ALTER COLUMN rule_id SET DEFAULT nextval('rules_rule_id_seq'::regclass);


SET search_path = quarantine, pg_catalog;

--
-- Name: capture_id; Type: DEFAULT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE captures ALTER COLUMN capture_id SET DEFAULT nextval('captures_capture_id_seq'::regclass);


--
-- Name: type_id; Type: DEFAULT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE event_types ALTER COLUMN type_id SET DEFAULT nextval('event_types_type_id_seq'::regclass);


SET search_path = report, pg_catalog;

--
-- Name: report_id; Type: DEFAULT; Schema: report; Owner: ndbadm
--

ALTER TABLE list ALTER COLUMN report_id SET DEFAULT nextval('list_report_id_seq'::regclass);


--
-- Name: view_id; Type: DEFAULT; Schema: report; Owner: ndbadm
--

ALTER TABLE views ALTER COLUMN view_id SET DEFAULT nextval('views_view_id_seq'::regclass);


SET search_path = smp, pg_catalog;

--
-- Name: user_id; Type: DEFAULT; Schema: smp; Owner: ndbadm
--

ALTER TABLE users ALTER COLUMN user_id SET DEFAULT nextval('users_user_id_seq'::regclass);


SET search_path = auth, pg_catalog;

--
-- Data for Name: authorized_keys; Type: TABLE DATA; Schema: auth; Owner: postgres
--

COPY authorized_keys (uid, key_id, key) FROM stdin;
\.


--
-- Data for Name: ipsec; Type: TABLE DATA; Schema: auth; Owner: postgres
--

COPY ipsec (host_id, key) FROM stdin;
\.


--
-- Data for Name: passwd; Type: TABLE DATA; Schema: auth; Owner: postgres
--

COPY passwd (username, uid, password, is_super, mail_id, allow_ad_hoc_samples, allow_hbad_mitigation, allow_hbad_samples, allow_nbad_mitigation) FROM stdin;
admin	0	4tUoUq5JKTgf56Jm3de5Vv0W8uhFuW9MwiZBCKBUfzQ=	t	\N	t	t	t	t
\.

SET search_path = fast, pg_catalog;

--
-- Data for Name: attr_types; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY attr_types (attr_type_id, name) FROM stdin;
1	FloodID
2	Producer
3	Group
4	MaxPackets
5	MaxTime
6	Source
7	Stat
8	Version
9	Timeout
10	Duration
11	Packets
12	Bytes
13	WirePackets
14	Format
15	Entries
16	Patterns
17	Agent
18	Flows
\.


--
-- Data for Name: attrs; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY attrs (entity_id, attr_type_id, value) FROM stdin;
\.


--
-- Data for Name: entities; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY entities (entity_id, modified) FROM stdin;
\.


--
-- Data for Name: entity_data; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY entity_data (entity_id, type_id, created, final, error, body, expired) FROM stdin;
\.


--
-- Data for Name: entity_links; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY entity_links ("from", "to") FROM stdin;
\.


--
-- Data for Name: entity_patterns; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY entity_patterns (entity_id, pattern_id, rank, matches) FROM stdin;
\.


--
-- Data for Name: pat_contents; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY pat_contents (pattern_id, pat_strip_id) FROM stdin;
\.


--
-- Data for Name: pat_endpoint_search; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY pat_endpoint_search (pat_strip_id, protocol, src_port, dst_port) FROM stdin;
\.


--
-- Data for Name: pat_payload_search; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY pat_payload_search (pat_strip_id, word) FROM stdin;
\.


--
-- Data for Name: pat_strips; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY pat_strips (pat_strip_id, layer, offsets, "values") FROM stdin;
\.


--
-- Data for Name: patterns; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY patterns (pattern_id) FROM stdin;
\.


--
-- Data for Name: top_host_sets; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY top_host_sets (ths_id, entity_id, pattern_id, side) FROM stdin;
\.


--
-- Data for Name: top_hosts; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY top_hosts (ths_id, ip, matches) FROM stdin;
\.


--
-- Data for Name: types; Type: TABLE DATA; Schema: fast; Owner: ndbadm
--

COPY types (type_id, name, descr) FROM stdin;
1	traffic-sample	A set of traffic frames or packets stored for further processing
2	traffic-samples	Group of traffic-sample documents
3	pattern-alerts	Alert messages for traffic patterns
4	pattern-report	Results of pattern analysis of one or more traffic-samples
5	pattern-top-hosts	Most active hosts for traffic patterns
6	unknown	Unknown document type
7	pattern-entropy	Entropy measurement of packets matching patterns
8	flow-capture	A set of flow data stored for further processing
\.


SET search_path = fgen, pg_catalog;

--
-- Data for Name: percents; Type: TABLE DATA; Schema: fgen; Owner: ndbadm
--

COPY percents (host_count, min_percent) FROM stdin;
1	20
2	40
3	55
4	65
5	70
6	100
\.


--
-- Data for Name: types; Type: TABLE DATA; Schema: fgen; Owner: ndbadm
--

COPY types (type_id, name, description, process) FROM stdin;
1	cisco	Cisco ACL (IOS 12.4)	t
2	cloudshield	Cloudshield CCE	t
3	fortinet	Fortigate 2.80	t
4	huawei	Huawei	t
5	iptables	Iptables	t
6	naive	\N	f
7	netx-pktcap	\N	t
8	pix	Cisco PIX	t
9	snort	Snort	t
10	tcpdump	Tcpdump	t
11	junos	JunOS 9.4	t
\.


SET search_path = flood, pg_catalog;

--
-- Data for Name: alert_types; Type: TABLE DATA; Schema: flood; Owner: ndbadm
-- new hb

COPY alert_types (alert_type_id, name, class,type) FROM stdin;
1	DDoS	D	dos
2	DoS	D	dos
3	Scan	S	scan
4	Bad checksum	M	badchecksum
5	Truncated packets	M	truncated
6	Bogons hosts	B	bogon
7	QODT amplification	A	amplification
8	CHARGEN amplification	A	amplification
9	DNS amplification	A	amplification
10	Portmap amplification	A	amplification
11	NTP amplification	A	amplification
12	NetBIOS amplification	A	amplification
13	SNMP amplification	A	amplification
14	RIP amplification	A	amplification
15	SSDP amplification	A	amplification
16	mDNS amplification	A	amplification
17	LDAP amplification	A	amplification
18	Steam amplification	A	amplification
19	Quake amplification	A	amplification
\.

--
-- Data for Name: amplification_alerts; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY amplification_alerts (alert_type_id, port) FROM stdin;
7	17
8	19
9	53
10	111
11	123
12	137
13	161
14	520
15	1900
16	5353
17	389
18	27015
19	27960
\.



--
-- Data for Name: alerters; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY alerters (alerter_id, name) FROM stdin;
1	attack-type
2	tcpdump
\.


--
-- Data for Name: alerts; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY alerts (flood_id, pattern_id, sample_id, alerter_id, alert_type_id, relevance, total) FROM stdin;
\.


--
-- Data for Name: attack_interfaces_triggered; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY attack_interfaces_triggered (flood_id, trigger_time) FROM stdin;
\.

--
-- Data for Name: bogons; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY bogons (address) FROM stdin;
10.0.0.0/8
127.0.0.0/8
169.254.0.0/16
172.16.0.0/12
192.0.2.0/24
192.168.0.0/16
\.


--
-- Data for Name: cache; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY cache (flood_id, patterns) FROM stdin;
\.


--
-- Data for Name: config; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY config (name, val) FROM stdin;
max-tracking	72
\.


--
-- Data for Name: errors; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY errors (error_id, subsystem_id, descriptor, start, stop, details) FROM stdin;
\.


--
-- Data for Name: graphs; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY graphs (flood_id, at, resolution, "values", stat_id, predicted) FROM stdin;
\.


--
-- Data for Name: importance; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY importance (flood_id, importance, filter_id, uid) FROM stdin;
\.


--
-- Data for Name: matches; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY matches (filter_id, match_id, at) FROM stdin;
\.


--
-- Data for Name: mtg_auto_block_tbl; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_auto_block_tbl (flood_id, orig_pattern_id, filter_id, expires) FROM stdin;
\.


--
-- Data for Name: mtg_auto_block_with_action_tbl; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_auto_block_with_action_tbl (flood_id, orig_pattern_id, filter_id, expires, action) FROM stdin;
\.


--
-- Data for Name: mtg_graphs_real; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_graphs_real (sg_id, pattern_id, at, resolution, cps, pps) FROM stdin;
\.


--
-- Data for Name: mtg_live; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_live (sg_id, pattern_id, action_since, action_expire, refresh, state_id, state_details, state_since, action) FROM stdin;
\.


--
-- Data for Name: mtg_live_log_past; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_live_log_past (sg_id, pattern_id, state_id, state_details, state_since, state_until, id) FROM stdin;
\.


--
-- Data for Name: mtg_map; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_map (host_id, sg_id) FROM stdin;
\.


--
-- Data for Name: mtg_req_manual_block_tbl; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_req_manual_block_tbl (flood_id, orig_pattern_id, u_id, action, action_expire, action_flood_only) FROM stdin;
\.


--
-- Data for Name: mtg_req_manual_unblock_tbl; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_req_manual_unblock_tbl (flood_id, u_id) FROM stdin;
\.


--
-- Data for Name: mtg_reqs; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_reqs (flood_id, orig_pattern_id, pattern_id, filter_id, uid, action, action_since, action_expire, action_flood_only) FROM stdin;
\.


--
-- Data for Name: mtg_reqs_log_past; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_reqs_log_past (flood_id, orig_pattern_id, pattern_id, filter_id, uid, action, action_expire, action_flood_only, req_since, req_until) FROM stdin;
\.


--
-- Data for Name: mtg_sg_state; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_sg_state (sg_id, at, alive, details, pat_count_max, blob_size, blob_size_max) FROM stdin;
\.


--
-- Data for Name: mtg_states; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY mtg_states (state_id, descr, "order", hot, ok, quiet) FROM stdin;
ACTI	pattern active	20	t	t	t
BPAT	invalid pattern	50	f	f	t
CPAT	pattern conflict	40	t	f	f
FAIL	unexpected failure	50	f	f	t
NCAP	capacity exceeded	40	t	f	f
PEND	request submitted	30	t	t	f
REMO	pattern removed	10	f	t	t
TARD	never succeeded	50	f	f	t
NCON	no connection to AOS	40	t	f	f
\.


--
-- Data for Name: pattern_entropy; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY pattern_entropy (flood_id, pattern_id, coverage, entropy, tot_coverage, tot_entropy) FROM stdin;
\.


--
-- Data for Name: registry; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY registry (flood_id, type_id, subsystem_id, host_id, group_id) FROM stdin;
\.


--
-- Data for Name: samples; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY samples (flood_id, at, request, processed, sample_id, report_id, top_hosts_id, alerts_id, entropy_id) FROM stdin;
\.


--
-- Data for Name: state; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY state (flood_id, modified, start, stop, details) FROM stdin;
\.


--
-- Data for Name: stats; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY stats (flood_id, duration, exp_byt, exp_pkt, obs_byt, obs_pkt, shape) FROM stdin;
\.


--
-- Data for Name: thresholds; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY thresholds (threshold_id, name, descr, disable, group_id, host_id, stat_id, grace, min, value, dyn_short, dyn_long, dyn_percent) FROM stdin;
\.


--
-- Data for Name: top_hosts_dst; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY top_hosts_dst (flood_id, ip, avg_bps, avg_pps) FROM stdin;
\.


--
-- Data for Name: top_hosts_src; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY top_hosts_src (flood_id, ip, avg_bps, avg_pps) FROM stdin;
\.


--
-- Data for Name: top_interfaces; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY top_interfaces (flood_id, interfaces, bytes) FROM stdin;
\.


--
-- Data for Name: types; Type: TABLE DATA; Schema: flood; Owner: ndbadm
--

COPY types (type_id, name, descr) FROM stdin;
1	ack	TCP ACK flood                                
2	ack-data	TCP data flood                          
3	dns	UDP DNS flood                                
4	esp	ESP flood                                    
5	fin	TCP FIN flood                                
6	frag	fragmented packet flood                     
7	icmp	ICMP flood                                  
8	other	OTHER (not TCPUDP or ICMP) flood         
9	ping	ICMP PING (echo request) flood              
10	pong	ICMP PONG (echo reply) flood               
11	rst	TCP RST flood                               
12	syn	TCP SYN flood                               
13	tcp-inval	invalid TCP flood                     
14	trunc	truncated or malformed packet flood       
15	udp	UDP flood                                   
16	unr	ICMP UNR (destination unreachable) flood    
17	out-ack	TCP ACK flood                           
18	out-ack-data	TCP data flood                     
19	out-dns	UDP DNS flood                           
20	out-esp	ESP flood                               
21	out-fin	TCP FIN flood                           
22	out-frag	fragmented packet flood                
23	out-icmp	ICMP flood                             
24	out-other	OTHER (not TCPUDP or ICMP) flood    
25	out-ping	ICMP PING (echo request) flood         
26	out-pong	ICMP PONG (echo reply) flood           
27	out-rst	TCP RST flood                           
28	out-syn	TCP SYN flood                           
29	out-tcp-inval	invalid TCP flood                 
30	out-trunc	truncated or malformed packet flood   
31	out-udp	UDP flood                               
32	out-unr	ICMP UNR (destination unreachable) flood
\.


SET search_path = notify, pg_catalog;

--
-- Data for Name: complete_targets; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY complete_targets (target_id) FROM stdin;
1
2
3
4
5
6
7
8
9
26
27
28
29
30
31
32
33
34
35
36
37
38
39
40
\.


--
-- Data for Name: data_type_operators; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY data_type_operators (data_type_id, operator_id) FROM stdin;
1	3
2	9
2	10
3	1
3	2
3	3
3	4
3	5
3	6
3	9
3	10
4	1
4	2
4	5
4	6
5	1
5	2
5	3
5	4
5	5
5	6
5	7
5	8
5	9
5	10
6	1
6	2
6	3
6	4
6	5
6	6
6	9
6	10
\.


--
-- Data for Name: data_types; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY data_types (data_type_id, name) FROM stdin;
1	boolean
2	inet
3	integer
4	floating-point
5	string
6	time
\.


--
-- Data for Name: fields; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) FROM stdin;
1	1	3	day	Day of month	{Range(1,31)}	{"invalid day of month, must be from 1 to 31"}	\N
2	1	4	dev_bit_percent	Deviation bits percentage	{GT(0)}	{"invalid deviation bits percentage, must be greater than 0"}	\N
3	1	4	dev_bit_rate	Deviation bits per second (average)	{GT(0)}	{"invalid deviation bits per second, must be greater than 0"}	\N
4	1	3	dev_byte_count	Deviation bytes count	{GT(0)}	{"invalid deviation bytes count, must be 1 or greater"}	\N
5	1	3	dev_pkt_count	Deviation packets count	{GT(0)}	{"invalid deviation packets count, must be 1 or greater"}	\N
6	1	4	dev_pkt_percent	Deviation packets percentage	{GT(0)}	{"invalid deviation packets percentage, must be greater than 0"}	\N
7	1	4	dev_pkt_rate	Deviation packets per second (average)	{GT(0)}	{"invalid deviation packets per second, must be greater than 0"}	\N
8	1	3	duration	Duration of the anomaly in seconds	{GT(0)}	{"invalid flood duration, must be greater than 0"}	\N
9	1	3	exp_byte_count	Expected bytes count	{GT(0)}	{"invalid expected bytes count, must be greater than 0"}	\N
10	1	3	exp_pkt_count	Expected packets count	{GT(0)}	{"invalid expected packets count, must be greater than 0"}	\N
11	1	5	group	Group name	{GroupName}	\N	\N
12	1	5	importance	Event importance	{Enum(ignore,low,medium,high)}	\N	Importance from `ignore' to `high'
34	2	3	icmp_code	ICMP code	{Range(0,255)}	{"invalid ICMP code, must be from 0 to 255"}	\N
13	1	3	month	Month	{Range(1,12)}	{"invalid month, must be from 1 to 12"}	From January (1) to December (12)
14	1	4	obs_bit_rate	Observed bits per second (average)	{GT(0)}	{"invalid observed bits per second, must be greater than 0"}	\N
15	1	3	obs_byte_count	Observed bytes count	{GT(0)}	{"invalid observed bytes count, must be 1 or greater"}	\N
16	1	4	obs_pkt_rate	Observed packets per second (average)	{GT(0)}	{"invalid observed packets per second, must be greater than 0"}	\N
17	1	3	obs_pkt_count	Observed packets count	{GT(0)}	{"invalid observed packets count, must be 1 or greater"}	\N
18	1	5	cluster	Reporting Sensor-Cluster name	{ClusterName}	\N	\N
19	1	3	shape_severity	Shape severity	{Range(0,4)}	{"invalid shape severity, must be from 0 to 4"}	\N
20	1	6	time	Time of day	\N	\N	\N
21	1	5	type	Anomaly type	{AttackType}	\N	\N
22	1	3	wday	Day of week	{Range(0,6)}	{"invalid day of week, must be from 0 to 6"}	From Sunday (0) to Saturday (6)
35	2	3	icmp_id	ICMP identification	{Range(0,65535)}	{"invalid ICMP identification, must be from 0 to 65535"}	\N
23	1	3	year	Year	{GT(0)}	{"invalid year, must be 1 or greater"}	Year (e.g. 2010)
24	2	5	dst_group	Destination IP group name	{GroupName}	\N	\N
25	2	5	src_group	Source IP group name	{GroupName}	\N	\N
26	2	2	dst_hosts	Destination hosts	\N	\N	IP address or network
27	2	2	src_hosts	Source hosts	\N	\N	IP address or network
28	2	3	dst_ip_count	Destination IP count for the pattern	{GT(0)}	{"invalid destination ip count, must be 1 or greater"}	\N
29	2	3	src_ip_count	Source IP count for the pattern	{GT(0)}	{"invalid source ip count, must be 1 or greater"}	\N
30	2	3	dst_port	TCP/UDP destination port	{Range(0,65535)}	{"invalid TCP/UDP destination port, must be from 0 to 65535"}	Port number
31	2	3	src_port	TCP/UDP source port	{Range(0,65535)}	{"invalid TCP/UDP source port, must be from 0 to 65535"}	Port number
32	2	5	dst_prefix	Destination IP prefix description	{"PrefixName"}	\N	\N
33	2	5	src_prefix	Source IP prefix description	{"PrefixName"}	\N	\N
36	2	3	icmp_seq	ICMP sequence	{Range(0,65535)}	{"invalseq ICMP sequence, must be from 0 to 65535"}	\N
37	2	3	icmp_type	ICMP type	{Range(0,255)}	{"invalid ICMP type, must be from 0 to 255"}	\N
38	2	1	ip_flag_df	IP don't fragment flag	\N	{"invalid IP don't fragment flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
39	2	1	ip_flag_mf	IP more fragments flag	\N	{"invalid IP more fragments flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
40	2	1	ip_flag_res	IP reserved flag	\N	{"invalid IP reserved flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
41	2	3	ip_frag_ofs	IP fragment offset	{Range(0,65528),Mod(8)}	{"invalid IP fragment offset, must be from 0 to 65528","invalid IP fragment offset, must be multiple of 8"}	IP fragment offset in bytes
42	2	3	ip_hdr_len	IP header length	{Range(0,60),Mod(4)}	{"invalid IP header length, must be from 0 to 60","invalid IP header length, must be multiple of 4"}	IP header length in bytes
43	2	3	ip_id	IP identification	{Range(0,65535)}	{"invalid IP identification, must be from 0 to 65535"}	\N
44	2	3	ip_len	IP packet length	{Range(0,65535)}	{"invalid IP packet length, must be from 0 to 65535"}	IP packet length in bytes
45	2	3	ip_proto	IP protocol	{Range(0,255)}	{"invalid IP protocol, must be from 0 to 255"}	Protocol number (e.g. TCP (6), UDP (17))
46	2	3	ip_tos	IP type of service	{Range(0,255)}	{"invalid IP type of service, must be from 0 to 255"}	\N
47	2	3	ip_ttl	IP time to live	{Range(0,255)}	{"invalid IP time to live, must be from 0 to 255"}	\N
48	2	3	l2size	Number of bytes pattern has at layer 2 (e.g. Ethernet)	{Range(0,14)}	{"invalid layer 2 size, must be from 0 to 14"}	\N
49	2	3	l3size	Number of bytes pattern has at layer 3 (i.e. IP layer)	{Range(0,60)}	{"invalid layer 3 size, must be from 0 to 60"}	\N
50	2	3	l4size	Number of bytes pattern has at layer 4 (e.g. UDP, TCP)	{Range(0,65515)}	{"invalid layer 4 size, must be from 0 to 65515"}	\N
51	2	3	l7size	Number of bytes pattern has at layer 7 (i.e. payload)	{Range(0,65515)}	{"invalid layer 7 size, must be from 0 to 65515"}	\N
52	2	3	order	Pattern rank in flood	{GT(0)}	{"invalid pattern order, must be 1 or greater"}	From top pattern (1) to bottom pattern (infinity) 
53	2	3	relevance	Relevance percentage	{Range(0,100)}	{"invalid relevance percentage, must be from 0 to 100"}	\N
54	2	3	size	Number of bytes pattern has in total	{GT(0)}	{"invalid pattern size, must be 1 or greater"}	\N
55	2	3	tcp_ack	TCP acknowledgement number	{Range(0,4294967295)}	{"invalid TCP acknowledgement number, must be from 0 to 4294967295"}	\N
56	2	3	tcp_data_ofs	TCP data offset	{Range(0,60),Mod(4)}	{"invalid TCP data offset, must be from 0 to 60","invalid TCP data offset, must be multiple of 4"}	TCP data offset in bytes
57	2	1	tcp_flag_ack	TCP acknowledgment field significant flag	\N	{"invalid TCP acknowledgment field significant flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
58	2	1	tcp_flag_cwr	TCP congestion window reduced flag	\N	{"invalid TCP congestion window reduced flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
59	2	1	tcp_flag_ece	TCP explicit congestion notification flag	\N	{"invalid TCP explicit congestion notification flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
60	2	1	tcp_flag_fin	TCP no more data from sender flag	\N	{"invalid TCP no more data from sender flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
61	2	1	tcp_flag_psh	TCP push function flag	\N	{"invalid TCP push function flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
62	2	1	tcp_flag_rst	TCP reset the connection flag	\N	{"invalid TCP reset the connection flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
63	2	1	tcp_flag_syn	TCP synchronize sequence numbers flag	\N	{"invalid TCP synchronize sequence numbers flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
64	2	1	tcp_flag_urg	TCP urgent pointer field significant flag	\N	{"invalid TCP urgent pointer field significant flag, must be 0 or 1"}	Flag can be unset (0) or set (1)
65	2	3	tcp_res	TCP reserved	{Range(0,15)}	{"invalid TCP reserved, must be from 0 to 15"}	\N
66	2	3	tcp_seq	TCP sequence number	{Range(0,4294967295)}	{"invalid TCP sequence number, must be from 0 to 4294967295"}	\N
67	2	3	tcp_urg_pnt	TCP urgent pointer	{Range(0,65535)}	{"invalid TCP urgent pointer, must be from 0 to 65535"}	\N
68	2	3	tcp_window_size	TCP window size	{Range(0,65535)}	{"invalid TCP window size, must be from 0 to 65535"}	\N
69	2	3	udp_len	UDP datagram length in bytes	{Range(0,65535)}	{"invalid UDP datagram length, must be from 0 to 65535"}	\N
70	2	3	src_ip_size	Number of bytes pattern has in source IP address	{Range(0,16)}	{"invalid size, must be from 0 to 16"}	\N
71	2	3	dst_ip_size	Number of bytes pattern has in destination IP address	{Range(0,16)}	{"invalid size, must be from 0 to 16"}	\N
72	2	4	l7coverage	Percent of payload covered by pattern (0-100)	{GT(0),LE(100)}	{"invalid value, must be from 0 to 100"}	\N
73	2	4	l7entropy	Payload entropy, in bits (0-8)	{GT(0),LE(8)}	{"invalid value, must be from 0 to 8"}	\N
74	3	5	activity	Type of malicious activity	{Enum(Addr-Scan,Flow-Bomb,Mass-DNS,Mass-SMTP,Port-Scan,IP-Spawn,Aggressive-IPs)}	\N	\N
75	3	4	bps	Bits per second rate	{GT(0)}	{"invalid bits per second, must be greater than 0"}	\N
76	3	4	bps_percent	Activity involves this much of host bit rate	{GT(0),LE(100)}	{"invalid bits per second percentage, must be greater than 0 and less or equal to 100"}	\N
77	3	4	connsize_avg	Average connection size in packets	{GT(0)}	{"invalid average connection size in packets, must be greater than 0"}	\N
78	3	4	cps	Connections per second rate	{GT(0)}	{"invalid connections per second, must be greater than 0"}	\N
79	3	4	cps_percent	Activity involves this much of host connection rate	{GT(0),LE(100)}	{"invalid connections per second percentage, must be greater than 0 and less or equal to 100"}	\N
80	3	3	day	Day of month	{Range(1,31)}	{"invalid day of month, must be from 1 to 31"}	\N
81	3	5	group	Group name	{GroupName}	\N	\N
82	3	5	importance	Event importance	{Enum(ignore,low,medium,high)}	\N	Importance from `ignore' to `high'
83	3	2	ip	Target IP address (if singular)	\N	\N	IP address or network
84	3	3	month	Month	{Range(1,12)}	{"invalid month, must be from 1 to 12"}	From January (1) to December (12)
85	3	4	pktsize_avg	Average packet size in bytes	{GT(0)}	{"invalid average packet size, must be greater than 0"}	\N
86	3	3	port	Target port (if singular)	{Range(0,65535)}	{"invalid port, must be from 0 to 65535"}	Port number
87	3	4	pps	Packets per second rate	{GT(0)}	{"invalid packets per second, must be greater than 0"}	\N
88	3	4	pps_percent	Activity involves this much of host packet rate	{GT(0),LE(100)}	{"invalid packets per second percentage, must be greater than 0 and less or equal to 100"}	\N
89	3	3	proto	Activity is using this protocol	{Enum(1,17,6)}	\N	Protocol number
90	3	5	proto_name	Activity is using this protocol	{Enum(icmp,udp,tcp)}	\N	Protocol name
91	3	5	sensor	Reporting Sensor name	{SensorName}	\N	\N
92	3	4	spread	Spread percentage	{GT(0),LE(100)}	{"invalid spread percentage, must be greater than 0 and less or equal to 100"}	\N
93	3	5	subscriber	Activity is coming from this subscriber	\N	\N	Subscriber name
94	3	2	suspect_ip	Activity is coming from this host	\N	\N	IP address or network
95	3	6	time	Time of day	\N	\N	\N
96	3	3	wday	Day of week	{Range(0,6)}	{"invalid day of week, must be from 0 to 6"}	From Sunday (0) to Saturday (6)
97	3	3	year	Year	{GT(0)}	{"invalid year, must be 1 or greater"}	Year (e.g. 2010)
98	2	3	icmpv6_code	ICMPV6 code	{Range(0,255)}	{"invalid ICMPV6 code, must be from 0 to 255"}	\N
99	2	3	icmpv6_id	ICMPV6 identification	{Range(0,65535)}	{"invalid ICMPV6 identification, must be from 0 to 65535"}	\N
100	2	3	icmpv6_type	ICMPV6 type	{Range(0,255)}	{"invalid ICMPV6 type, must be from 0 to 255"}	\N
101	2	3	ipv6_flag_res	IPV6 res	{Range(0,3)}	{"invalid IPV6 res, must be from 0 to 3"}	\N
102	2	3	ipv6_id	IPV6 identification	{Range(0,65535)}	{"invalid IPV6 identification, must be from 0 to 65535"}	\N
103	2	3	ip_version	IPversion	{Enum(4,6)}	{"invalid IP version, must be 4 | 6"}	\N
104	2	3	ipv6_flowlabel	IPV6 Flowlabel	{Range(0,65535)}	{"invalid IPV6 Flowlabel, must be from 0 to 65535"}	\N
105	2	3	src_asn	ASN list of the pattern source	{Range(0,4294967295)}	{"invalid ASN must be from 0 to 4294967295"}	\N
106	2	3	dst_asn	ASN list of the pattern destination	{Range(0,4294967295)}	{"invalid ASN must be from 0 to 4294967295"}	\N
107	2	5	src_country	Country code list of the pattern source	{CountryCode}	{"invalid country code code must be aligned with ISO 3166 and 2 char length"}	\N
108	2	5	dst_country	Country code list of the pattern destination	{CountryCode}	{"invalid country code code must be aligned with ISO 3166 and 2 char length"}	\N
109	2	3	src_asn_count	Pattern source ASNs count	{Range(1,20)}	{invalid ASN count,must be from 1 to 20}	\N
110	2	3	dst_asn_count	Pattern destination ASNs count	{Range(1,20)}	{invalid ASN count,must be from 1 to 20}	\N
111	2	3	src_country_count	Pattern source countries count	{Range(1,20)}	{invalid country count,must be from 1 to 20}	\N
112	2	3	dst_country_count	Pattern destination countries count	{Range(1,20)}	{invalid country count,must be from 1 to 20}	\N
\.


--
-- Data for Name: filter_parts; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY filter_parts (filter_id, field_id, type_id, data_type_id, operator_id, operand) FROM stdin;
2	7	1	4	6	{150000}
2	8	1	3	6	{60}
2	19	1	3	6	{2}
3	49	2	3	6	{6}
3	52	2	3	1	{5}
4	28	2	3	1	{3}
4	29	2	3	6	{10}
5	28	2	3	3	{1}
5	29	2	3	3	{1}
6	28	2	3	6	{10}
6	29	2	3	3	{1}
7	7	1	4	2	{150000}
7	7	1	4	6	{80000}
7	8	1	3	6	{60}
7	19	1	3	6	{2}
8	49	2	3	6	{6}
8	52	2	3	1	{5}
9	28	2	3	1	{3}
9	29	2	3	6	{10}
10	28	2	3	3	{1}
10	29	2	3	3	{1}
11	28	2	3	6	{10}
11	29	2	3	3	{1}
12	7	1	4	2	{80000}
12	7	1	4	6	{30000}
12	8	1	3	6	{60}
12	19	1	3	6	{2}
13	49	2	3	6	{6}
13	52	2	3	1	{5}
14	28	2	3	1	{3}
14	29	2	3	6	{10}
15	28	2	3	3	{1}
15	29	2	3	3	{1}
16	28	2	3	6	{10}
16	29	2	3	3	{1}
17	7	1	4	2	{30000}
17	8	1	3	6	{60}
17	19	1	3	6	{2}
19	28	2	3	1	{3}
19	29	2	3	6	{10}
20	28	2	3	3	{1}
20	29	2	3	3	{1}
21	28	2	3	6	{10}
21	29	2	3	3	{1}
23	74	3	5	3	{Mass-DNS}
24	78	3	4	6	{20}
25	78	3	4	2	{3}
25	78	3	4	6	{1}
26	78	3	4	2	{20}
26	78	3	4	6	{3}
27	78	3	4	2	{1}
28	74	3	5	3	{Flow-Bomb}
28	86	3	3	10	{25,16881,16882,53,80,443}
29	78	3	4	6	{80}
30	78	3	4	2	{20}
30	78	3	4	6	{5}
31	78	3	4	2	{80}
31	78	3	4	6	{20}
32	78	3	4	2	{5}
33	74	3	5	3	{Flow-Bomb}
33	86	3	3	9	{80,443}
34	78	3	4	6	{80}
35	78	3	4	2	{80}
35	78	3	4	6	{20}
36	78	3	4	2	{20}
36	78	3	4	6	{5}
37	78	3	4	1	{5}
38	74	3	5	3	{Port-Scan}
39	78	3	4	6	{30}
40	78	3	4	2	{10}
40	78	3	4	6	{2}
41	78	3	4	2	{30}
41	78	3	4	6	{10}
42	78	3	4	2	{2}
43	74	3	5	9	{Mass-SMTP,Flow-Bomb,Addr-Scan}
43	86	3	3	3	{25}
43	90	3	5	3	{tcp}
44	78	3	4	6	{10}
45	78	3	4	2	{3}
45	78	3	4	6	{1}
46	78	3	4	2	{10}
46	78	3	4	6	{3}
47	78	3	4	2	{1}
48	74	3	5	3	{Addr-Scan}
49	78	3	4	6	{20}
50	90	3	5	3	{icmp}
51	86	3	3	4	{25}
52	78	3	4	2	{2}
52	78	3	4	6	{0.5}
53	90	3	5	3	{icmp}
54	86	3	3	4	{25}
55	78	3	4	2	{20}
55	78	3	4	6	{2}
56	90	3	5	3	{icmp}
57	86	3	3	4	{25}
58	78	3	4	2	{0.5}
59	90	3	5	3	{icmp}
60	86	3	3	4	{25}
\.


--
-- Data for Name: filter_templates; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY filter_templates (filter_id, type_id, target_type_id, template_id) FROM stdin;
1	1	1	5
1	1	2	1
1	1	3	3
1	1	5	7
1	1	6	9
1	1	7	12
1	1	11	6
1	1	14	41
22	3	1	26
22	3	3	25
22	3	5	30
22	3	6	31
22	3	7	32
22	3	8	29
22	3	10	28
22	3	11	27
\.


--
-- Data for Name: filters; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY filters (filter_id, type_id, name, descr, parent, keepalive, disable, modified, generation, update_on_stop) FROM stdin;
1	1	default	\N	\N	\N	f	2017-01-04 11:42:30.548468+00	0	t
58	3	Worm-Negl	cps <= 0.5	48	\N	f	2017-01-04 11:42:43.5915+00	2	t
2	1	F1-High	\N	1	\N	f	2017-01-04 11:42:30.936782+00	4	t
30	3	Flood-Low	\N	28	\N	f	2017-01-04 11:42:37.692214+00	3	t
3	2	Pat-High	\N	2	\N	f	2017-01-04 11:42:31.142496+00	2	t
4	2	DDoS-High	\N	3	\N	f	2017-01-04 11:42:31.366701+00	2	t
5	2	DoS-High	\N	3	\N	f	2017-01-04 11:42:31.580244+00	2	t
46	3	Spam-Med	\N	43	\N	f	2017-01-04 11:42:41.381925+00	3	t
6	2	IPScan-High	\N	3	\N	f	2017-01-04 11:42:31.801437+00	2	t
31	3	Flood-Med	\N	28	\N	f	2017-01-04 11:42:37.956457+00	3	t
32	3	Flood-Negl	\N	28	\N	f	2017-01-04 11:42:38.103597+00	1	t
7	1	F2-Medium	\N	1	\N	f	2017-01-04 11:42:32.179826+00	5	t
8	2	Pat-Med	\N	7	\N	f	2017-01-04 11:42:32.389713+00	2	t
47	3	Spam-Negl	\N	43	\N	f	2017-01-04 11:42:41.520974+00	1	t
9	2	DDoS-Med	\N	8	\N	f	2017-01-04 11:42:32.591388+00	2	t
33	3	Flood-Web	Identify subscribers connecting to a web site excessively; cover ports 80 (HTTP) and 443 (HTTPS), either TCP or UDP	22	\N	f	2017-01-04 11:42:38.366933+00	3	t
10	2	DoS-Med	\N	8	\N	f	2017-01-04 11:42:32.801486+00	2	t
11	2	IPScan-Med	\N	8	\N	f	2017-01-04 11:42:33.001221+00	2	t
34	3	Web-High	\N	33	\N	f	2017-01-04 11:42:38.557769+00	2	t
12	1	F3-Low	\N	1	\N	f	2017-01-04 11:42:33.375864+00	5	t
48	3	Worm	Identify subscribers spreading worms, scanning for vulnerable PCs, or performing pre-attack reconnaissance; exclude port 25 (covered by Spammer)	22	\N	f	2017-01-04 11:42:41.696859+00	2	t
13	2	Pat-Low	\N	12	\N	f	2017-01-04 11:42:33.587025+00	2	t
35	3	Web-Low	\N	33	\N	f	2017-01-04 11:42:38.825833+00	3	t
14	2	DDoS-Low	\N	13	\N	f	2017-01-04 11:42:33.79597+00	2	t
15	2	DoS-Low	\N	13	\N	f	2017-01-04 11:42:34.009515+00	2	t
16	2	IPScan-Low	\N	13	\N	f	2017-01-04 11:42:34.219788+00	2	t
59	3	Worm-Negl-ICMP	Handle ICMP separately (ICMP would never match filtering by port)	58	\N	f	2017-01-04 11:42:43.771484+00	2	t
36	3	Web-Med	\N	33	\N	f	2017-01-04 11:42:39.100649+00	3	t
17	1	F4-Negligible	\N	1	\N	f	2017-01-04 11:42:34.471604+00	3	t
18	2	Pat-Negl	\N	17	\N	f	2017-01-04 11:42:34.523231+00	0	t
19	2	DDoS-Negl	\N	18	\N	f	2017-01-04 11:42:34.741549+00	2	t
37	3	Web-Negl	\N	33	\N	f	2017-01-04 11:42:39.25181+00	1	t
20	2	DoS-Negl	\N	18	\N	f	2017-01-04 11:42:34.968618+00	2	t
21	2	IPScan-Negl	\N	18	\N	f	2017-01-04 11:42:35.183062+00	2	t
22	3	default	\N	\N	\N	f	2017-01-04 11:42:35.834549+00	0	t
49	3	Worm-High	\N	48	\N	f	2017-01-04 11:42:41.940275+00	2	t
23	3	Flood-DNS	Identify subscribers making excessive use of DNS; often relates to spamming from subscribers, but not always, since external DNS may be used; may be specific flooding attempts	22	\N	f	2017-01-04 11:42:36.080288+00	2	t
38	3	PortScan	Identify subscribers demonstrating port scanning behaviour	22	\N	f	2017-01-04 11:42:39.426841+00	2	t
24	3	DNS-High	\N	23	\N	f	2017-01-04 11:42:36.264599+00	2	t
25	3	DNS-Low	\N	23	\N	f	2017-01-04 11:42:36.525055+00	3	t
39	3	PS-High	\N	38	\N	f	2017-01-04 11:42:39.62469+00	2	t
26	3	DNS-Med	\N	23	\N	f	2017-01-04 11:42:36.798022+00	3	t
27	3	DNS-Negl	\N	23	\N	f	2017-01-04 11:42:36.938029+00	1	t
50	3	Worm-High-ICMP	Handle ICMP separately (ICMP would never match filtering by port)	49	\N	f	2017-01-04 11:42:42.141252+00	2	t
28	3	Flood-Other	Identify subscribers connecting to a target excessively; exclude ports 25 (covered by Spammer), 80 and 443 (Flood-Web), 53 (Flood-DNS), P2P ports 16881 and 16882 (normal use)	22	\N	f	2017-01-04 11:42:37.210758+00	3	t
40	3	PS-Low	\N	38	\N	f	2017-01-04 11:42:39.884577+00	3	t
29	3	Flood-High	\N	28	\N	f	2017-01-04 11:42:37.416565+00	2	t
51	3	Worm-High-TCPUDP	\N	49	\N	f	2017-01-04 11:42:42.271016+00	1	t
41	3	PS-Med	\N	38	\N	f	2017-01-04 11:42:40.143633+00	3	t
42	3	PS-Negl	\N	38	\N	f	2017-01-04 11:42:40.286917+00	1	t
60	3	Worm-Negl-TCPUDP	\N	58	\N	f	2017-01-04 11:42:43.893278+00	1	t
43	3	Spammer	Identify spammers based on Mass-SMTP, Flow-Bomb and Addr-Scan EVENTS to port 25/TCP; further classify by LEVEL OF ACTIVITY (cps)	22	\N	f	2017-01-04 11:42:40.651295+00	4	t
52	3	Worm-Low	\N	48	\N	f	2017-01-04 11:42:42.518824+00	3	t
44	3	Spam-High	\N	43	\N	f	2017-01-04 11:42:40.846987+00	2	t
45	3	Spam-Low	\N	43	\N	f	2017-01-04 11:42:41.115392+00	3	t
53	3	Worm-Low-ICMP	Handle ICMP separately (ICMP would never match filtering by port)	52	\N	f	2017-01-04 11:42:42.719443+00	2	t
54	3	Worm-Low-TCPUDP	\N	52	\N	f	2017-01-04 11:42:42.854853+00	1	t
55	3	Worm-Med	\N	48	\N	f	2017-01-04 11:42:43.110538+00	3	t
56	3	Worm-Med-ICMP	Handle ICMP separately (ICMP would never match filtering by port)	55	\N	f	2017-01-04 11:42:43.310488+00	2	t
57	3	Worm-Med-TCPUDP	\N	55	\N	f	2017-01-04 11:42:43.438583+00	1	t
\.

--
-- Data for Name: filter_targets; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY filter_targets (filter_id, target_id) FROM stdin;
2	3
7	2
12	1
24	3
25	1
26	2
29	3
30	1
31	2
34	3
35	1
36	2
39	3
40	1
41	2
44	3
45	1
46	2
49	3
52	1
55	2
\.



--
-- Data for Name: operators; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY operators (operator_id, on_set, name, descr) FROM stdin;
1	f	<	Strictly less than
2	f	<=	Less than or equal to
3	t	==	Strictly equal to
4	t	!=	Strictly not equal to
5	f	>=	Greater than or equal to
6	f	>	Strictly greater than
7	f	=~	Matches regexp
8	f	!~	Does not match regexp
9	t	=@	Included in
10	t	!@	Not included in
\.


--
-- Data for Name: targets; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY targets (target_id, target_type_id, name, addr, descr, complete) FROM stdin;
1	1	low	1	\N	t
2	1	medium	2	\N	t
3	1	high	3	\N	t
4	2	block	block	\N	t
5	2	block-30m	block 30	\N	t
6	2	block-60m	block 60	\N	t
7	2	block-90m	block 90	\N	t
8	2	block-2h	block 120	\N	t
9	8	recommend	recommend\t3600	Quarantine recommendation instead of decision (use with PCRF-aware SMP)	t
26	2	blockTopHostTx	blockTopHostTx	\N	t
27	2	blockTopHostTx-30m	blockTopHostTx 30	\N	t
28	2	blockTopHostTx-60m	blockTopHostTx 60	\N	t
29	2	blockTopHostTx-90m	blockTopHostTx 90	\N	t
30	2	blockTopHostTx-2h	blockTopHostTx 120	\N	t
31	2	blockTopHostRx	blockTopHostRx	\N	t
32	2	blockTopHostRx-30m	blockTopHostRx 30	\N	t
33	2	blockTopHostRx-60m	blockTopHostRx 60	\N	t
34	2	blockTopHostRx-90m	blockTopHostRx 90	\N	t
35	2	blockTopHostRx-2h	blockTopHostRx 120	\N	t
36	2	blockTopHostTxRx	blockTopHostTxRx	\N	t
37	2	blockTopHostTxRx-30m	blockTopHostTxRx 30	\N	t
38	2	blockTopHostTxRx-60m	blockTopHostTxRx 60	\N	t
39	2	blockTopHostTxRx-90m	blockTopHostTxRx 90	\N	t
40	2	blockTopHostTxRx-2h	blockTopHostTxRx 120	\N	t
\.


--
-- Data for Name: templates; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY templates (template_id, target_type_id, type_id, name, template, allow_targets) FROM stdin;
31	6	3	default	informer[$(_sys_pid)]: Quarantine ($(_nfy_importance)) $(activity): $(suspect_ip) $(subscriber "[%s] ")($(group), capture $(capture_id)) spread $(spread_pd "%s %s")%, $(target_syslog), $(cps_pd "%s %s")cps, $(cps_percent_pd "%s %s")%, $(connsize_avg_pd "%s %s")pkts on average, $(pps_pd "%s %s")pps, $(pps_percent_pd "%s %s")%, $(pktsize_avg_pd "%s %s")bytes on average, $(bps_pd "%s %s")bps, $(bps_percent_pd "%s %s") %, sensor $(host) [policy $(_nfy_filter)]	t
5	1	1	default	flood\n$(id)\n$(_nfy_filter_id)\n	t
6	11	1	default	$(include pattern, 1)	f
4	3	1	long	Subject: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id))\n\n$(_sys_base_url)webui/floodreport?flood=$(id)\n\nStatus:\t\t   $(status)\nDuration:\t   $(duration)\nImportance:        $(_nfy_importance)\nShape severity:\t   $(shape_severity)\n\n$(block_email)Traffic:             deviation        observed         expected\n--------------------------------------------------------------------\n  percent:$(dev_pkt_percent "%15.2f") % packets\n\t  $(dev_bit_percent "%15.2f") % bits\n  count:\t  $(dev_pkt_count_pd "%7.2f%2s")packets $(obs_pkt_count_pd "%7.2f%2s")packets $(exp_pkt_count_pd "%7.2f%2s")packets\n\t\t  $(dev_byte_count_pb "%7.2f%3s")B      $(obs_byte_count_pb "%7.2f%3s")B      $(exp_byte_count_pb "%7.2f%3s")B\n  rate:\t\t  $(dev_pkt_rate_pd "%7.2f%2s")pps     $(obs_pkt_rate_pd "%7.2f%2s")pps     $(exp_pkt_rate_pd "%7.2f%2s")pps\n\t\t  $(dev_bit_rate_pd "%7.2f%2s")bps     $(obs_bit_rate_pd "%7.2f%2s")bps     $(exp_bit_rate_pd "%7.2f%2s")bps\n\nLast update:\t   $(modified)\nStarted:\t   $(start)\nStopped:\t   $(stop)\nStop details:\t   $(details)\n\nSensor:\t\t   $(host)\nGroup:\t\t   $(group) ($(group_descr))\nType:\t\t   $(type) ($(type_descr))\nID:\t\t   $(id)\n\nReported by:       `$(subsystem)' at $(subsystem_host)\n\nMatched policy:    $(_nfy_filter)\n\nPatterns:          $(pattern_count)\n$(include pattern, 1)	t
8	5	1	long	anomalyGenericTrap\n\nanomalyID\t\tu $(id)\nanomalyTypeID\t\tu $(type_id)\nanomalyImportance       u $(_nfy_importance_raw)\nanomalyStart\t\tu $(start_unix)\nanomalyStop\t\tu $(stop_unix)\nanomalyModified\t\tu $(modified_unix)\nanomalyAgentID\t\tu $(host_id)\nanomalyGroupID\t\tu $(group_id)\nstopDetails\t\ts $(details)\nexpectedBytes\t\tU $(exp_byte_count)\nexpectedPackets\t\tU $(exp_pkt_count)\nobservedBytes\t\tU $(obs_byte_count)\nobservedPackets\t\tU $(obs_pkt_count)\n\n$(block_snmp)anomalyTypeName\t\ts $(type)\nanomalyImportanceName   s $(_nfy_importance)\nanomalyStartDate\ts $(start_snmp)\nanomalyStopDate\t\ts $(stop_snmp)\nanomalyModifiedDate\ts $(modified_snmp)\nanomalyAgentName\ts $(host)\nanomalyGroupName\ts $(group)\nanomalySubsystemID\tu $(subsystem_id)\nanomalySubsystemName\ts $(subsystem)\nanomalyShapeSeverity\tu $(shape_severity)\nanomalyPatternCount     u $(pattern_count)\n\npolicyName\t\ts $(_nfy_filter)\nanomalyDuration        u $(duration_raw "%u")\nanomalyBitRate\t\tu $(obs_bit_rate "%u")\nanomalyPktRate\t\tu $(obs_pkt_rate "%u")\n$(include pattern, 1)	t
10	6	1	long	informer[$(_sys_pid)]: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id)) [policy $(_nfy_filter)], $(status), duration $(duration), shape severity $(shape_severity)$(block_syslog), deviation: $(dev_pkt_percent "%.2f") % packets / $(dev_bit_percent "%.2f") % bits, $(dev_pkt_count_pd "%.2f %s")packets / $(dev_byte_count_pb "%.2f %s")B, $(dev_pkt_rate_pd "%.2f %s")pps / $(dev_bit_rate_pd "%.2f %s")bps; observed: $(obs_pkt_count_pd "%.2f %s")packets / $(obs_byte_count_pb "%.2f %s")B, $(obs_pkt_rate_pd "%.2f %s")pps / $(obs_bit_rate_pd "%.2f %s")bps; last modified: $(modified), start: $(start), stop: $(stop), stop details: $(details); reported by: `$(subsystem)' at $(subsystem_host); patterns: $(pattern_count); $(include pattern, 1)	t
11	3	1	sms	\nFlood $(status) $(_nfy_importance_sms):$(dev_pkt_rate_pd "%.2f%s")pps/$(dev_bit_rate_pd "%.2f%s")bps:$(_nfy_filter)\n$(host_sms):$(group):$(type):$(id)\n$(block_sms)($(_sys_base_url)webui/floodreport?flood=$(id))\nLAST:$(modified_sms)\n	t
1	2	1	default	$(_nfy_id)\n$(_nfy_last)\n$(_nfy_filter_id)\n$(include pattern)	f
2	2	1	hash	$(include pattern, 1)	f
12	7	1	default	flood $(_nfy_id)\npattern $(include pattern)\naction-status $(_nfy_last)\nfilter $(_nfy_filter_id)\npolicy $(_nfy_filter)\n	t
13	2	2	default	$(pattern_id)\n	t
14	3	2	default		t
3	3	1	default	Subject: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id))\n\n$(_sys_base_url)webui/floodreport?flood=$(id)\n\nStatus:\t\t   $(status)\nDuration:\t   $(duration)\nImportance:        $(_nfy_importance)\nShape severity:\t   $(shape_severity)\n\n$(block_email)Traffic:             deviation        observed         expected\n--------------------------------------------------------------------\n  percent:$(dev_pkt_percent "%15.2f") % packets\n\t  $(dev_bit_percent "%15.2f") % bits\n  count:\t  $(dev_pkt_count_pd "%7.2f%2s")packets $(obs_pkt_count_pd "%7.2f%2s")packets $(exp_pkt_count_pd "%7.2f%2s")packets\n\t\t  $(dev_byte_count_pb "%7.2f%3s")B      $(obs_byte_count_pb "%7.2f%3s")B      $(exp_byte_count_pb "%7.2f%3s")B\n  rate:\t\t  $(dev_pkt_rate_pd "%7.2f%2s")pps     $(obs_pkt_rate_pd "%7.2f%2s")pps     $(exp_pkt_rate_pd "%7.2f%2s")pps\n\t\t  $(dev_bit_rate_pd "%7.2f%2s")bps     $(obs_bit_rate_pd "%7.2f%2s")bps     $(exp_bit_rate_pd "%7.2f%2s")bps\n\nLast update:\t   $(modified)\nStarted:\t   $(start)\nStopped:\t   $(stop)\nStop details:\t   $(details)\n\nSensor:\t\t   $(host)\nGroup:\t\t   $(group) ($(group_descr))\nType:\t\t   $(type) ($(type_descr))\nID:\t\t   $(id)\n\nReported by:       `$(subsystem)' at $(subsystem_host)\n\nMatched policy:    $(_nfy_filter)\n\nPatterns:          $(pattern_count)\n	t
7	5	1	default	anomalyGenericTrap\n\nanomalyID\t\tu $(id)\nanomalyTypeID\t\tu $(type_id)\nanomalyImportance       u $(_nfy_importance_raw)\nanomalyStart\t\tu $(start_unix)\nanomalyStop\t\tu $(stop_unix)\nanomalyModified\t\tu $(modified_unix)\nanomalyAgentID\t\tu $(host_id)\nanomalyGroupID\t\tu $(group_id)\nstopDetails\t\ts $(details)\nexpectedBytes\t\tU $(exp_byte_count)\nexpectedPackets\t\tU $(exp_pkt_count)\nobservedBytes\t\tU $(obs_byte_count)\nobservedPackets\t\tU $(obs_pkt_count)\n\n$(block_snmp)anomalyTypeName\t\ts $(type)\nanomalyImportanceName   s $(_nfy_importance)\nanomalyStartDate\ts $(start_snmp)\nanomalyStopDate\t\ts $(stop_snmp)\nanomalyModifiedDate\ts $(modified_snmp)\nanomalyAgentName\ts $(host)\nanomalyGroupName\ts $(group)\nanomalySubsystemID\tu $(subsystem_id)\nanomalySubsystemName\ts $(subsystem)\nanomalyShapeSeverity\tu $(shape_severity)\nanomalyPatternCount     u $(pattern_count)\n\npolicyName\t\ts $(_nfy_filter)\n	t
9	6	1	default	informer[$(_sys_pid)]: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id)) [policy $(_nfy_filter)], $(status), duration $(duration), shape severity $(shape_severity)$(block_syslog), deviation: $(dev_pkt_percent "%.2f") % packets / $(dev_bit_percent "%.2f") % bits, $(dev_pkt_count_pd "%.2f %s")packets / $(dev_byte_count_pb "%.2f %s")B, $(dev_pkt_rate_pd "%.2f %s")pps / $(dev_bit_rate_pd "%.2f %s")bps; observed: $(obs_pkt_count_pd "%.2f %s")packets / $(obs_byte_count_pb "%.2f %s")B, $(obs_pkt_rate_pd "%.2f %s")pps / $(obs_bit_rate_pd "%.2f %s")bps; last modified: $(modified), start: $(start), stop: $(stop), stop details: $(details); reported by: `$(subsystem)' at $(subsystem_host); patterns: $(pattern_count)	t
15	3	2	long	\nPattern $(pattern_id_hr) $(desc)\n$(src_hosts)$(dst_hosts)	t
16	2	2	hash	$(pattern_id)\n	t
17	11	2	default	$(ip_dst)\n	t
18	5	2	default		t
19	5	2	long	anomalyPatternID\t  u $(pattern_id)\nanomalyPatternDstIPCount  u $(dst_ip_count)\nanomalyPatternSrcIPCount  u $(src_ip_count)\nanomalyPattern\t\t  s $(raw_hex)\n	t
22	3	2	sms		t
23	1	2	default		t
20	6	2	default		t
21	6	2	long	$(desc)$(strict_printf "; IPs %s %s > %s", ip_ratio, src_hosts_syslog, dst_hosts_syslog)	t
24	7	2	default	$(pattern_id),	t
26	1	3	default	quarantine\n$(_nfy_id)\n$(_nfy_filter_id)\n	t
27	11	3	default	$(_suspect_ip)	t
28	10	3	default	service addServiceToSubSession $(suspect_ip) $service\nservice applyServicesToSubSession $(suspect_ip)\n	t
30	5	3	default	HBADTrap\n\nHBADTypeID\t\tu $(type_id)\nHBADImportance          u $(_nfy_importance_raw)\nagentID\t\t\tu $(host_id)\ngroupID\t\t\tu $(group_id)\ndetectedAt\t\tu $(start_unix)\nsrcIP\t\t\ta $(suspect_ip)\nsubscriber\t\ts $(subscriber)\nHBADCaptureID\t\tu $(capture_id)\nHBADSpread              i $(spread_snmp)\nprotocol\t\tu $(proto)\ndstIP\t\t\ta $(ip)\ndstPort\t\t\tu $(port)\nconnRate\t\tu $(cps_snmp)\nconnPercent\t\ti $(cps_percent_snmp)\npktRate\t\t        u $(pps_snmp)\npktPercent\t\ti $(pps_percent_snmp)\nbitRate\t\t        u $(bps_snmp)\nbitPercent\t\ti $(bps_percent_snmp)\n\nHBADTypeName\t\ts $(activity)\nHBADImportanceName      s $(_nfy_importance)\nagentName\t\ts $(host)\ngroupName\t\ts $(group)\ndetectedAtDate          s $(start_snmp)\n\npolicyName              s $(_nfy_filter)\n	t
25	3	3	default	Subject: Quarantine ($(_nfy_importance)) $(activity): $(suspect_ip) ($(group), capture $(capture_id))\n\n$(_sys_base_url)webui/quarantinereport#capture=$(capture_id)\n\nActivity:\t   $(activity)\nImportance:\t   $(_nfy_importance)\n\nSuspect IP:\t   $(suspect_ip)\nSubscriber:        $(subscriber)\nGroup:\t\t   $(group) ($(group_descr))\nAt:\t\t   $(start)\nCapture ID:\t   $(capture_id)\n\nSpread:\t\t   $(spread_pd "%s %s")%\nProtocol:\t   $(proto_name) ($(proto))\nTarget IP:\t   $(ip)\nTarget port:\t   $(port)\n\nConnection rate:   $(printf "%-10s", $(cps_pd "%s %scps,")) $(printf "%-7s", $(cps_percent_pd "%s %s%%,")) $(connsize_avg_pd "%s %s")pkts on average\nPacket rate:\t   $(printf "%-10s", $(pps_pd "%s %spps,")) $(printf "%-7s", $(pps_percent_pd "%s %s%%,")) $(pktsize_avg_pd "%s %s")bytes on average\nBit rate:\t   $(printf "%-10s", $(bps_pd "%s %sbps,")) $(bps_percent_pd "%s %s")%\n\nSensor:\t\t   $(host)\nMatched policy:    $(_nfy_filter)\n	t
29	8	3	default	$(_nfy_filter_id)\n$(subscriber)\n$(prevalent_activity)\n	t
32	7	3	default	event        $(capture_id)\nfilter       $(_nfy_filter_id)\npolicy       $(_nfy_filter)	t
33	3	1	longphysport	Subject: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id))\n\n$(_sys_base_url)webui/floodreport?flood=$(id)\n\nStatus:\t\t   $(status)\nDuration:\t   $(duration)\nImportance:        $(_nfy_importance)\nShape severity:\t   $(shape_severity)\n\n$(block_email)Traffic:             deviation        observed         expected\n--------------------------------------------------------------------\n  percent:$(dev_pkt_percent "%15.2f") % packets\n\t  $(dev_bit_percent "%15.2f") % bits\n  count:\t  $(dev_pkt_count_pd "%7.2f%2s")packets $(obs_pkt_count_pd "%7.2f%2s")packets $(exp_pkt_count_pd "%7.2f%2s")packets\n\t\t  $(dev_byte_count_pb "%7.2f%3s")B      $(obs_byte_count_pb "%7.2f%3s")B      $(exp_byte_count_pb "%7.2f%3s")B\n  rate:\t\t  $(dev_pkt_rate_pd "%7.2f%2s")pps     $(obs_pkt_rate_pd "%7.2f%2s")pps     $(exp_pkt_rate_pd "%7.2f%2s")pps\n\t\t  $(dev_bit_rate_pd "%7.2f%2s")bps     $(obs_bit_rate_pd "%7.2f%2s")bps     $(exp_bit_rate_pd "%7.2f%2s")bps\n\nLast update:\t   $(modified)\nStarted:\t   $(start)\nStopped:\t   $(stop)\nStop details:\t   $(details)\n\nSensor:\t\t   $(host)\nGroup:\t\t   $(group) ($(group_descr))\nType:\t\t   $(type) ($(type_descr))\nID:\t\t   $(id)\nTop originating port: $(sensor_name) $(physical_port_name)\n\nReported by:       `$(subsystem)' at $(subsystem_host)\n\nMatched policy:    $(_nfy_filter)\n\nPatterns:          $(pattern_count)\n$(include pattern, 1)	t
34	3	2	defaultphysport		t
35	3	1	defaultphysport	Subject: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id))\n\n$(_sys_base_url)webui/floodreport?flood=$(id)\n\nStatus:\t\t   $(status)\nDuration:\t   $(duration)\nImportance:        $(_nfy_importance)\nShape severity:\t   $(shape_severity)\n\n$(block_email)Traffic:             deviation        observed         expected\n--------------------------------------------------------------------\n  percent:$(dev_pkt_percent "%15.2f") % packets\n\t  $(dev_bit_percent "%15.2f") % bits\n  count:\t  $(dev_pkt_count_pd "%7.2f%2s")packets $(obs_pkt_count_pd "%7.2f%2s")packets $(exp_pkt_count_pd "%7.2f%2s")packets\n\t\t  $(dev_byte_count_pb "%7.2f%3s")B      $(obs_byte_count_pb "%7.2f%3s")B      $(exp_byte_count_pb "%7.2f%3s")B\n  rate:\t\t  $(dev_pkt_rate_pd "%7.2f%2s")pps     $(obs_pkt_rate_pd "%7.2f%2s")pps     $(exp_pkt_rate_pd "%7.2f%2s")pps\n\t\t  $(dev_bit_rate_pd "%7.2f%2s")bps     $(obs_bit_rate_pd "%7.2f%2s")bps     $(exp_bit_rate_pd "%7.2f%2s")bps\n\nLast update:\t   $(modified)\nStarted:\t   $(start)\nStopped:\t   $(stop)\nStop details:\t   $(details)\n\nSensor:\t\t   $(host)\nGroup:\t\t   $(group) ($(group_descr))\nType:\t\t   $(type) ($(type_descr))\nID:\t\t   $(id)\nTop originating port: $(sensor_name) $(physical_port_name)\n\nReported by:       `$(subsystem)' at $(subsystem_host)\n\nMatched policy:    $(_nfy_filter)\n\nPatterns:          $(pattern_count)\n	t
36	3	2	longphysport	\nPattern $(pattern_id_hr) $(desc)\n$(src_hosts)$(dst_hosts)	t
37	6	1	longphysport	informer[$(_sys_pid)]: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id)) [policy $(_nfy_filter)], [top originating port: $(sensor_name) $(physical_port_name)], $(status), duration $(duration), shape severity $(shape_severity)$(block_syslog), deviation: $(dev_pkt_percent "%.2f") % packets / $(dev_bit_percent "%.2f") % bits, $(dev_pkt_count_pd "%.2f %s")packets / $(dev_byte_count_pb "%.2f %s")B, $(dev_pkt_rate_pd "%.2f %s")pps / $(dev_bit_rate_pd "%.2f %s")bps; observed: $(obs_pkt_count_pd "%.2f %s")packets / $(obs_byte_count_pb "%.2f %s")B, $(obs_pkt_rate_pd "%.2f %s")pps / $(obs_bit_rate_pd "%.2f %s")bps; last modified: $(modified), start: $(start), stop: $(stop), stop details: $(details); reported by: `$(subsystem)' at $(subsystem_host); patterns: $(pattern_count); $(include pattern, 1)	t
38	6	1	defaultphysport	informer[$(_sys_pid)]: Flood ($(_nfy_importance)) $(host):$(group):$(type) ($(id)) [policy $(_nfy_filter)], [top originating port: $(sensor_name) $(physical_port_name)], $(status), duration $(duration), shape severity $(shape_severity)$(block_syslog), deviation: $(dev_pkt_percent "%.2f") % packets / $(dev_bit_percent "%.2f") % bits, $(dev_pkt_count_pd "%.2f %s")packets / $(dev_byte_count_pb "%.2f %s")B, $(dev_pkt_rate_pd "%.2f %s")pps / $(dev_bit_rate_pd "%.2f %s")bps; observed: $(obs_pkt_count_pd "%.2f %s")packets / $(obs_byte_count_pb "%.2f %s")B, $(obs_pkt_rate_pd "%.2f %s")pps / $(obs_bit_rate_pd "%.2f %s")bps; last modified: $(modified), start: $(start), stop: $(stop), stop details: $(details); reported by: `$(subsystem)' at $(subsystem_host); patterns: $(pattern_count)	t
39	6	2	defaultphysport		t
40	6	2	longphysport	$(desc)$(strict_printf "; IPs %s %s > %s", ip_ratio, src_hosts_syslog, dst_hosts_syslog)	t
41	14	1	default		t
\.


--
-- Data for Name: types; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY types (type_id, name) FROM stdin;
1	flood
2	pattern
3	quarantine
\.


--
-- Data for Name: type_links; Type: TABLE DATA; Schema: notify; Owner: ndbadm
--

COPY type_links (type_id, "from", "to", sql, id_field) FROM stdin;
1	\N	1	SELECT flood_id\t\tAS id,\n       subsystem_id,\n\t  host_id,\n\t  group_id,\n\t  type_id\t\tAS type_id,\n\t  flood.duration(start, stop, modified)\n\t\t\t\tAS duration,\n\t  exp_byt\t\tAS exp_byte_count,\n\t  exp_pkt\t\tAS exp_pkt_count,\n\t  flood.ext_rate(exp_byt*8, 0, stats.duration)\n\t\t\t\tAS exp_bit_rate,\n\t  flood.ext_rate(exp_pkt, 0, stats.duration)\n\t\t\t\tAS exp_pkt_rate,\n\t  obs_byt\t\tAS obs_byte_count,\n\t  obs_pkt\t\tAS obs_pkt_count,\n\t  flood.ext_rate(obs_byt*8, 0, stats.duration)\n\t\t\t\tAS obs_bit_rate,\n\t  flood.ext_rate(obs_pkt, 0, stats.duration)\n\t\t\t\tAS obs_pkt_rate,\n\t  obs_byt - exp_byt AS dev_byte_count,\n\t  obs_pkt - exp_pkt AS dev_pkt_count,\n\t  flood.ext_rel(obs_byt, exp_byt)*100\n\t                        AS dev_bit_percent,\n\t  flood.ext_rel(obs_pkt, exp_pkt)*100\n\t\t\t        AS dev_pkt_percent,\n\t  flood.ext_rate(obs_byt, exp_byt, stats.duration)*8\n\t\t\t\tAS dev_bit_rate,\n\t  flood.ext_rate(obs_pkt, exp_pkt, stats.duration)\n\t\t\t\tAS dev_pkt_rate,\n\t  modified,\n\t  start,\n\t  stop,\n\t  details,\n\t  subsystem_id\n  FROM flood.registry\n  JOIN flood.state USING (flood_id)\n  JOIN flood.stats USING (flood_id)\n WHERE (flood.stats.exp_pkt + flood.stats.obs_pkt + flood.stats.exp_byt + flood.stats.obs_byt) > 0\n   AND modified > $1\n       ${condition}\n ORDER BY modified	flood_id
1	1	2	\n    SELECT ARRAY[$1, patterns.pattern_id] AS id,\n      rank              AS order,\n      quality           AS relevance,\n      coverage[5]*100.0 AS l7coverage,\n      entropy[3]        AS l7entropy,\n      (SELECT MAX(ed.created)\n        FROM flood.samples s\n        JOIN fast.entity_patterns ep ON (ep.entity_id = s.report_id)\n        JOIN fast.entity_data ed USING (entity_id)\n        WHERE s.flood_id=$1 AND\n        ep.pattern_id=patterns.pattern_id\n      ) AS last_seen\n      FROM flood.patterns($1)\n      LEFT JOIN flood.pattern_entropy pe ON ((pe.flood_id, pe.pattern_id) = ($1, patterns.pattern_id))\n      ORDER BY 6 DESC,2\n  	\N
3	\N	3	SELECT ev.capture_id,\n\t  ev.type_id,\n\t  cp.subsystem_id,\n\t  name AS activity,\n\t  modified,\n\t  timestamp AS start,\n\t  timestamp AS stop,\n\t  extract('epoch' from cp.duration) AS duration,\n\t  cp.addr AS _suspect_ip,\n\t  cp.bytes AS capture_byte_count,\n\t  cp.flows AS capture_conn_count,\n\t  cp.packets AS capture_pkt_count,\n\t  ev.spread::float/(ev.flows::float/100) AS spread,\n\t  ev.bytes AS byte_count,\n\t  ev.flows AS conn_count,\n\t  ev.packets AS pkt_count,\n\t  ev.packets::float/ev.flows AS connsize_avg,\n\t  ev.bytes::float/ev.packets AS pktsize_avg,\n\t  ev.target_proto AS proto,\n\t  ev.target_ip,\n\t  ev.target_port AS port\n  FROM quarantine.events ev\n  JOIN quarantine.event_types USING (type_id)\n  JOIN quarantine.captures cp USING (capture_id)\n WHERE modified > $1\n   ${condition}\n ORDER BY modified	ev.capture_id
\.


SET search_path = nx, pg_catalog;

--
-- Data for Name: map; Type: TABLE DATA; Schema: nx; Owner: ndbadm
--

COPY map (ip, hostlist_id, current, applied_request_id, added, expires, target, request_id) FROM stdin;
\.


SET search_path = public, pg_catalog;

--
-- Data for Name: cluster_config; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY cluster_config (cluster_id, min_sensors, fail_grace) FROM stdin;
\.


--
-- Data for Name: data_tables; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY data_tables (table_id, host_id, group_id, struct_id, relid, width, period, cookie) FROM stdin;
\.


--
-- Data for Name: group_config; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY group_config (prefix, group_id, "from", "to", descr) FROM stdin;
\.


--
-- Data for Name: group_mapping; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY group_mapping (host_id, group_id) FROM stdin;
\.


--
-- Data for Name: groups; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY groups (group_id, name, descr, f_inside, f_dos, f_rawcap, f_decodetun, f_quarantine,group_type) FROM stdin;
900	World	World	f	f	f	t	f	IPV4
901	Inside	Inside	t	t	f	t	t	IPV4
902	Inside-ipv6	Inside-ipv6	t	t	f	t	t	IPV6
903	World-ipv6	World-ipv6	f	f	f	t	f	IPV6
\.


--
-- Data for Name: hosts; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY hosts (host_id, name, ip, is_hydra, cap_hydra, is_sensor, cap_sensor, cap_tasks_max, ssh_key, descr, shutdown, tunnel_via, f_aos, is_cluster,management_protocol,management_port) FROM stdin;
1	spc	127.0.0.1	t	t	f	f	8	\N	spc	f	\N	f	f	http	80
\.


--
-- Data for Name: permissions; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY permissions (user_id, attribute, host_id, group_id) FROM stdin;
0	read	\N	\N
\.


--
-- Data for Name: post_target_types; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY post_target_types (target_type_id, name, descr, multiple, zero_keepalive) FROM stdin;
1	importance	Importance	f	f
2	sg-action	AOS mitigation	f	t
3	e-mail	Email address	t	f
4	aos	AOS	t	f
5	snmp-trap	SNMP manager	t	f
6	syslog	Syslog receiver	t	f
7	script	Script	t	t
8	smp-plan	SMP service plan	f	f
9	smp	SMP server	t	f
10	redback	Redback service	t	f
11	nx-hostlist	NetXplorer host list	t	t
12	remote-trigger	Rx BGP remote trigger	t	f
13	flow-spec-remote-trigger	BGP Flow-Spec remote trigger	t	f
14	audio-alarm	Audio Alarm	t	f
\.


--
-- Data for Name: sensor_clusters; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY sensor_clusters (cluster_id, member_id) FROM stdin;
\.


--
-- Data for Name: statistics; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY statistics (stat_id, struct_id, name, descr) FROM stdin;
13	2	byt_incom_esp	incoming ESP bytes
14	2	byt_outgo_esp	outgoing ESP bytes
15	2	pkt_incom_esp	incoming ESP packets
16	2	pkt_outgo_esp	outgoing ESP packets
1	2	byt_incom_frag	incoming fragmented bytes
2	2	byt_outgo_frag	outgoing fragmented bytes
3	2	pkt_incom_frag	incoming fragmented packets
4	2	pkt_outgo_frag	outgoing fragmented packets
69	2	byt_incom_icmp_echorep	incoming ICMP PONG (echo reply) bytes
70	2	byt_outgo_icmp_echorep	outgoing ICMP PONG (echo reply) bytes
71	2	pkt_incom_icmp_echorep	incoming ICMP PONG (echo reply) packets
72	2	pkt_outgo_icmp_echorep	outgoing ICMP PONG (echo reply) packets
65	2	byt_incom_icmp_echoreq	incoming ICMP PING (echo request) bytes
66	2	byt_outgo_icmp_echoreq	outgoing ICMP PING (echo request) bytes
67	2	pkt_incom_icmp_echoreq	incoming ICMP PING (echo request) packets
68	2	pkt_outgo_icmp_echoreq	outgoing ICMP PING (echo request) packets
77	2	byt_incom_icmp_total	incoming total ICMP bytes
78	2	byt_outgo_icmp_total	outgoing total ICMP bytes
79	2	pkt_incom_icmp_total	incoming total ICMP packets
80	2	pkt_outgo_icmp_total	outgoing total ICMP packets
73	2	byt_incom_icmp_unreach	incoming ICMP UNR (destination unreachable) bytes
74	2	byt_outgo_icmp_unreach	outgoing ICMP UNR (destination unreachable) bytes
75	2	pkt_incom_icmp_unreach	incoming ICMP UNR (destination unreachable) packets
76	2	pkt_outgo_icmp_unreach	outgoing ICMP UNR (destination unreachable) packets
17	2	byt_incom_ip	incoming total IPv4 + IPv6 bytes
18	2	byt_outgo_ip	outgoing total IPv4 + IPv6 bytes
19	2	pkt_incom_ip	incoming total IPv4 + IPv6 packets
20	2	pkt_outgo_ip	outgoing total IPv4 + IPv6 packets
9	2	byt_incom_other	incoming other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) bytes
10	2	byt_outgo_other	outgoing other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) bytes
11	2	pkt_incom_other	incoming other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) packets
12	2	pkt_outgo_other	outgoing other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) packets
33	2	byt_incom_tcp_ack	incoming TCP ACK bytes
34	2	byt_outgo_tcp_ack	outgoing TCP ACK bytes
35	2	pkt_incom_tcp_ack	incoming TCP ACK packets
36	2	pkt_outgo_tcp_ack	outgoing TCP ACK packets
37	2	byt_incom_tcp_ackdata	incoming TCP data bytes
38	2	byt_outgo_tcp_ackdata	outgoing TCP data bytes
39	2	pkt_incom_tcp_ackdata	incoming TCP data packets
40	2	pkt_outgo_tcp_ackdata	outgoing TCP data packets
45	2	byt_incom_tcp_endp	incoming TCP endpoint (FIN, RST and SYN) bytes
46	2	byt_outgo_tcp_endp	outgoing TCP endpoint (FIN, RST and SYN) bytes
47	2	pkt_incom_tcp_endp	incoming TCP endpoint (FIN, RST and SYN) packets
48	2	pkt_outgo_tcp_endp	outgoing TCP endpoint (FIN, RST and SYN) packets
21	2	byt_incom_tcp_fin	incoming TCP FIN bytes
22	2	byt_outgo_tcp_fin	outgoing TCP FIN bytes
23	2	pkt_incom_tcp_fin	incoming TCP FIN packets
24	2	pkt_outgo_tcp_fin	outgoing TCP FIN packets
41	2	byt_incom_tcp_inval	incoming invalid TCP bytes
42	2	byt_outgo_tcp_inval	outgoing invalid TCP bytes
43	2	pkt_incom_tcp_inval	incoming invalid TCP packets
44	2	pkt_outgo_tcp_inval	outgoing invalid TCP packets
29	2	byt_incom_tcp_rst	incoming TCP RST bytes
30	2	byt_outgo_tcp_rst	outgoing TCP RST bytes
31	2	pkt_incom_tcp_rst	incoming TCP RST packets
32	2	pkt_outgo_tcp_rst	outgoing TCP RST packets
25	2	byt_incom_tcp_syn	incoming TCP SYN bytes
26	2	byt_outgo_tcp_syn	outgoing TCP SYN bytes
27	2	pkt_incom_tcp_syn	incoming TCP SYN packets
28	2	pkt_outgo_tcp_syn	outgoing TCP SYN packets
49	2	byt_incom_tcp_total	incoming total TCP bytes
50	2	byt_outgo_tcp_total	outgoing total TCP bytes
51	2	pkt_incom_tcp_total	incoming total TCP packets
52	2	pkt_outgo_tcp_total	outgoing total TCP packets
5	2	byt_incom_trunc	incoming truncated and malformed bytes
6	2	byt_outgo_trunc	outgoing truncated and malformed bytes
7	2	pkt_incom_trunc	incoming truncated and malformed packets
8	2	pkt_outgo_trunc	outgoing truncated and malformed packets
53	2	byt_incom_udp_dns	incoming UDP DNS bytes
54	2	byt_outgo_udp_dns	outgoing UDP DNS bytes
55	2	pkt_incom_udp_dns	incoming UDP DNS packets
56	2	pkt_outgo_udp_dns	outgoing UDP DNS packets
57	2	byt_incom_udp_other	incoming UDP (excluding DNS) bytes
58	2	byt_outgo_udp_other	outgoing UDP (excluding DNS) bytes
59	2	pkt_incom_udp_other	incoming UDP (excluding DNS) packets
60	2	pkt_outgo_udp_other	outgoing UDP (excluding DNS) packets
61	2	byt_incom_udp_total	incoming total UDP bytes
62	2	byt_outgo_udp_total	outgoing total UDP bytes
63	2	pkt_incom_udp_total	incoming total UDP packets
64	2	pkt_outgo_udp_total	outgoing total UDP packets
81	2	in_in_ackdata_endp	incoming TCP data / endpoint ratio
82	2	in_in_ack_endp	incoming TCP ACK / endpoint ratio
83	2	in_in_dns_udp	incoming UDP DNS / non-DNS ratio
84	2	in_out_fin_fin	incoming / outgoing TCP FIN ratio
85	2	in_in_frag_ip	incoming fragmented / total IPv4 + IPv6 ratio
86	2	in_in_icmp_ip	incoming ICMP / total IPv4 + IPv6 ratio
87	2	in_out_other_other	incoming / outgoing other IPv4 + IPv6 ratio
88	2	in_out_ping_pong	incoming ICMP PING / outgoing PONG ratio
89	2	in_out_pong_ping	incoming ICMP PONG / outgoing PING ratio
90	2	in_in_rst_fin	incoming TCP RST / FIN ratio
91	2	in_out_syn_fin	incoming TCP SYN / outgoing FIN ratio
92	2	in_in_tcpinval_tcpvalid	incoming invalid / valid TCP ratio
93	2	in_in_trunc_ip	incoming truncated / total IPv4 + IPv6 ratio
94	2	in_out_udp_udp	incoming / outgoing UDP ratio
95	2	in_out_unreach_ip	incoming ICMP UNR / outgoing total IPv4 + IPv6 ratio
96	2	byt_incom_icmp_other	incoming ICMP (excluding PING, PONG and UNR) bytes
97	2	byt_outgo_icmp_other	outgoing ICMP (excluding PING, PONG and UNR) bytes
98	2	pkt_incom_icmp_other	incoming ICMP (excluding PING, PONG and UNR) packets
99	2	pkt_outgo_icmp_other	outgoing ICMP (excluding PING, PONG and UNR) packets
100	2	in_out_esp_esp	incoming / outgoing ESP ratio
101	2	out_in_esp_esp	outgoing / incoming ESP ratio
102	2	out_in_fin_fin	outgoing / incoming TCP FIN ratio
103	2	out_in_other_other	outgoing / incoming other IPv4 + IPv6 ratio
104	2	out_in_ping_pong	outgoing ICMP PING / incoming PONG ratio
105	2	out_in_pong_ping	outgoing ICMP PONG / incoming PING ratio
106	2	out_in_syn_fin	outgoing TCP SYN / incoming FIN ratio
107	2	out_in_udp_udp	outgoing / incoming UDP ratio
108	2	out_in_unreach_ip	outgoing ICMP UNR / incoming total IPv4 + IPv6 ratio
109	2	out_out_ack_endp	outgoing TCP ACK / endpoint ratio
110	2	out_out_ackdata_endp	outgoing TCP data / endpoint ratio
111	2	out_out_dns_udp	outgoing UDP DNS / non-DNS ratio
112	2	out_out_frag_ip	outgoing fragmented / total IPv4 + IPv6 ratio
113	2	out_out_icmp_ip	outgoing ICMP / total IPv4 + IPv6 ratio
114	2	out_out_rst_fin	outgoing TCP RST / FIN ratio
115	2	out_out_tcpinval_tcpvalid	outgoing invalid / valid TCP ratio
116	2	out_out_trunc_ip	outgoing truncated / total IPv4 + IPv6 ratio
\.


--
-- Data for Name: struct_types; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY struct_types (type_id, name, descr) FROM stdin;
1	stat	Generic statistics
2	floods	Flood anomalies
\.


--
-- Data for Name: structs; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY structs (struct_id, name, type_id, descr) FROM stdin;
1	_stats	1	Statistic counters (raw values)
2	stats	1	Statistic counters
3	floods	2	Flood anomalies
\.


--
-- Data for Name: subsystems; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY subsystems (subsystem_id, name, host_id, alive, cookie) FROM stdin;
1	fast	1	2017-01-04 13:06:07.839223+00	9230~fast~1~2017-01-04 12:51:07.662596+00
2	hints-fast	1	2017-01-04 13:06:07.912196+00	9284~hints-fast~1~2017-01-04 12:51:07.832144+00
3	sgspmd	1	2017-01-04 13:06:07.920331+00	9285~sgspmd~1~2017-01-04 12:51:07.843556+00
4	informer	1	2017-01-04 13:06:08.07206+00	9296~informer~1~2017-01-04 12:51:07.87296+00
5	smpd	1	2017-01-04 13:06:08.258305+00	9326~smpd~1~2017-01-04 12:51:08.22629+00
\.


-- Data for Name: param; Type: TABLE DATA; Schema: public; Owner: ndbadm
--
COPY param (name,subname,int_val,str_val,date_val,description) FROM stdin;
Purge	history	366	\N	\N	Data aging in days(default)
Purge	capture_history	14	\N	\N	Capture data aging in days(default) 
Purge	snapshot_history	14	\N	\N	Snapshot data aging in days(default)  
Purge	days2delete	30	\N	\N	Days period to correct data aging
Purge	bgp_history	60	\N	\N	BGP events data aging in days
Purge	current_history	366	\N	\N	Data aging in days with correction according to free disk space
Purge	available_disk_space	20	\N	\N	Minimal available free disk space in % for default data aging
Snapshot	time_interval	10	\N	\N	Minutes period to run snapshot(default 10 min)
DB_Refact	phase_1	1	\N	\N	Database refactoring phase 1(fast, IPV6) status(1-done;0-not)
DB_Refact	phase_2	1	\N	\N	Database refactoring phase 2(plruby, CONFIG schema) status(1-done;0-not)
DB_Refact	phase_3	1	\N	\N	Database refactoring phase 3(remove CONFIG schema) status(1-done;0-not)
DB_Refact	phase_4	1	\N	\N	Database refactoring phase 4(remove unused ROLE(USER)''s) status(1-done;0-not)
DB_Refact	phase_5	1	\N	\N	Database refactoring phase 5(remove RULE''s with NOTIFY statements) status(1-done;0-not)
DB_Refact	phase_6	1	\N	\N	Database refactoring phase 6(IPV6 functionality) status(1-done;0-not)
Group	max_per_cluster	0	\N	\N	Max number of allocated groups to cluster
Group	max_per_sensor	300	\N	\N	Max number of allocated groups to sensor
Group	max_per_dsc	300	\N	\N	Max number of configured groups in the system
Version	db_upgrade_base	\N	20220125_17310	\N	Current DB base version
Statistics	structure_change	\N	\N	2020-11-05 08:00:00	Date of statistics format change from counter to gauge
Id	mitigation_stateful_global	0	\N	\N	Mitigation stateful global id
\.

-- Data for Name: mitigation; Type: TABLE DATA; Schema: public; Owner: ndbadm
--

COPY mitigation (option,is_enabled) FROM stdin;
ignore-encap	false
ignore-routing	false
context	true
\.

-- Data for Name: smtp; Type: TABLE DATA; Schema: public; Owner: ndbadm
--
COPY smtp(host_ip, port, from_address, replayto_address, is_auth, username ,password,start_tls ) FROM stdin;
127.0.0.1	25	spc@allot.com	spc@allot.com	false	\N	\N	false
\.

-- Data for Name: pattern_analysis_config; Type: TABLE DATA; Schema: public; Owner: ndbadm
--
COPY pattern_analysis_config(name, value, description ) FROM stdin;
countryThreashold	0.001	Threshold percent per each top host country classification
asnThreashold	0.001	Threshold percent per each top host AS number classification
captureHistoryLimit	20	Max number of captures will be analyzed per flood
minimumPacketsToMatch	30	Minimum packets to match from the capture
noiseFilter	0.95	\N
generatedPatternsLimit	5	Max generated patterns per single capture
topHostsLimit	20	Max number of top hosts per capture
ipv4Netmask	255.255.255.0	IPV4 netmask for BGP action
ipv6Netmask	ffff:ffff:ffff:ffff:0000:0000:0000:0000	IPV6 netmask for BGP action
\.


SET search_path = purge, pg_catalog;

--
-- Data for Name: history; Type: TABLE DATA; Schema: purge; Owner: ndbadm
--

COPY history (relid, at, elapsed, runtime, rows, dead, purged, churn, growth, pages, fsm, width) FROM stdin;
\.


--
-- Data for Name: jobs; Type: TABLE DATA; Schema: purge; Owner: ndbadm
--

COPY jobs (jobid, state, at, relname, attname, query, descr, pid, result) FROM stdin;
\.


--
-- Data for Name: relstate; Type: TABLE DATA; Schema: purge; Owner: ndbadm
--

COPY relstate (relid, created, vacuumed, analyzed, rows, purged, used, growth, churn) FROM stdin;
\.


--
-- Data for Name: rules; Type: TABLE DATA; Schema: purge; Owner: ndbadm
--

COPY rules (rule_id, rel, key, targrel, targkey) FROM stdin;
1	flood.samples	{sample_id}	fast.entities	{entity_id}
2	flood.samples	{report_id}	fast.entities	{entity_id}
3	flood.samples	{top_hosts_id}	fast.entities	{entity_id}
4	flood.samples	{alerts_id}	fast.entities	{entity_id}
5	quarantine.captures	{fast_id}	fast.entities	{entity_id}
6	quarantine.samples	{sample_id}	fast.entities	{entity_id}
\.


SET search_path = quarantine, pg_catalog;

--
-- Data for Name: captures; Type: TABLE DATA; Schema: quarantine; Owner: ndbadm
--

COPY captures (capture_id, subsystem_id, "timestamp", modified, addr, group_id, duration, flows, packets, bytes, fast_id, user_id) FROM stdin;
\.


--
-- Data for Name: event_types; Type: TABLE DATA; Schema: quarantine; Owner: ndbadm
--

COPY event_types (type_id, name) FROM stdin;
1	Addr-Scan
2	Port-Scan
3	Mass-DNS
4	Mass-SMTP
5	Flow-Bomb
6	IP-Spawn
7	Aggressive-IPs
\.


--
-- Data for Name: events; Type: TABLE DATA; Schema: quarantine; Owner: ndbadm
--

COPY events (capture_id, type_id, target_proto, target_ip, target_port, spread, flows, packets, bytes) FROM stdin;
\.


--
-- Data for Name: importance; Type: TABLE DATA; Schema: quarantine; Owner: ndbadm
--

COPY importance (capture_id, importance, filter_id, uid) FROM stdin;
\.


--
-- Data for Name: matches; Type: TABLE DATA; Schema: quarantine; Owner: ndbadm
--

COPY matches (filter_id, match_id, at) FROM stdin;
\.


--
-- Data for Name: samples; Type: TABLE DATA; Schema: quarantine; Owner: ndbadm
--

COPY samples (capture_id, at, sample_id, addr, user_id) FROM stdin;
\.


--
-- Data for Name: sources; Type: TABLE DATA; Schema: quarantine; Owner: ndbadm
--

COPY sources (subsystem_id, group_id, since, until, total) FROM stdin;
\.


SET search_path = report, pg_catalog;

--
-- Data for Name: list; Type: TABLE DATA; Schema: report; Owner: ndbadm
--

COPY list (report_id, created, modified, uid, name, description, period) FROM stdin;
\.


--
-- Data for Name: mail; Type: TABLE DATA; Schema: report; Owner: ndbadm
--

COPY mail (report_id, mail_id) FROM stdin;
\.


--
-- Data for Name: views; Type: TABLE DATA; Schema: report; Owner: ndbadm
--

COPY views (view_id, report_id, "order", definition) FROM stdin;
\.


SET search_path = smp, pg_catalog;

--
-- Data for Name: mtg_live; Type: TABLE DATA; Schema: smp; Owner: ndbadm
--

COPY mtg_live (user_id, smp_id, state_id, state_details, state_since, refresh, action, action_expire, action_param) FROM stdin;
\.


--
-- Data for Name: mtg_live_log_past; Type: TABLE DATA; Schema: smp; Owner: ndbadm
--

COPY mtg_live_log_past (user_id, smp_id, state_since, state_until, action, state_id, state_details, action_param) FROM stdin;
\.


--
-- Data for Name: mtg_reqs; Type: TABLE DATA; Schema: smp; Owner: ndbadm
--

COPY mtg_reqs (user_id, filter_id, uid, action, action_since, action_expire, action_param) FROM stdin;
\.


--
-- Data for Name: mtg_reqs_log_past; Type: TABLE DATA; Schema: smp; Owner: ndbadm
--

COPY mtg_reqs_log_past (user_id, req_since, req_until, filter_id, uid, action, action_expire, action_param) FROM stdin;
\.


--
-- Data for Name: mtg_states; Type: TABLE DATA; Schema: smp; Owner: ndbadm
--

COPY mtg_states (state_id, descr, "order", hot, ok, quiet) FROM stdin;
BPLN	invalid action	10	f	f	t
BUSR	unknown subscriber	20	f	f	t
REMO	mitigation removed	30	f	t	t
ACTI	mitigation active	40	t	t	t
PEND	request submitted	50	t	t	f
NCON	no connection to SMP	60	t	f	f
FAIL	unexpected failure	70	f	f	t
TARD	never succeeded	70	f	f	t
\.


--
-- Data for Name: users; Type: TABLE DATA; Schema: smp; Owner: ndbadm
--

COPY users (user_id, name, deleted, modified, state_id, state_details, state_since) FROM stdin;
\.


SET search_path = auth, pg_catalog;

--
-- Name: authorized_keys_pkey; Type: CONSTRAINT; Schema: auth; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY authorized_keys
    ADD CONSTRAINT authorized_keys_pkey PRIMARY KEY (uid, key_id);


--
-- Name: CONSTRAINT authorized_keys_pkey ON authorized_keys; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON CONSTRAINT authorized_keys_pkey ON authorized_keys IS 'Such key already exists for this user';


--
-- Name: ipsec_pkey; Type: CONSTRAINT; Schema: auth; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY ipsec
    ADD CONSTRAINT ipsec_pkey PRIMARY KEY (host_id);


--
-- Name: passwd_pkey; Type: CONSTRAINT; Schema: auth; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY passwd
    ADD CONSTRAINT passwd_pkey PRIMARY KEY (uid);


--
-- Name: passwd_username_key; Type: CONSTRAINT; Schema: auth; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY passwd
    ADD CONSTRAINT passwd_username_key UNIQUE (username);


--
-- Name: CONSTRAINT passwd_username_key ON passwd; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON CONSTRAINT passwd_username_key ON passwd IS 'User with such name already exists';

SET search_path = fast, pg_catalog;

--
-- Name: attr_types_name_key; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY attr_types
    ADD CONSTRAINT attr_types_name_key UNIQUE (name);


--
-- Name: attr_types_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY attr_types
    ADD CONSTRAINT attr_types_pkey PRIMARY KEY (attr_type_id);


--
-- Name: attrs_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY attrs
    ADD CONSTRAINT attrs_pkey PRIMARY KEY (entity_id, attr_type_id);


--
-- Name: entities_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY entities
    ADD CONSTRAINT entities_pkey PRIMARY KEY (entity_id);


--
-- Name: entity_data_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY entity_data
    ADD CONSTRAINT entity_data_pkey PRIMARY KEY (entity_id);


--
-- Name: entity_links_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY entity_links
    ADD CONSTRAINT entity_links_pkey PRIMARY KEY ("from", "to");


--
-- Name: entity_patterns_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY entity_patterns
    ADD CONSTRAINT entity_patterns_pkey PRIMARY KEY (entity_id, pattern_id);


--
-- Name: pat_contents_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY pat_contents
    ADD CONSTRAINT pat_contents_pkey PRIMARY KEY (pattern_id, pat_strip_id);


--
-- Name: pat_endpoint_search_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY pat_endpoint_search
    ADD CONSTRAINT pat_endpoint_search_pkey PRIMARY KEY (pat_strip_id);


--
-- Name: pat_payload_search_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY pat_payload_search
    ADD CONSTRAINT pat_payload_search_pkey PRIMARY KEY (pat_strip_id, word);


--
-- Name: pat_strips_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY pat_strips
    ADD CONSTRAINT pat_strips_pkey PRIMARY KEY (pat_strip_id);


--
-- Name: patterns_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY patterns
    ADD CONSTRAINT patterns_pkey PRIMARY KEY (pattern_id);


--
-- Name: top_host_sets_entity_id_pattern_id_side_key; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY top_host_sets
    ADD CONSTRAINT top_host_sets_entity_id_pattern_id_side_key UNIQUE (entity_id, pattern_id, side);


--
-- Name: top_host_sets_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY top_host_sets
    ADD CONSTRAINT top_host_sets_pkey PRIMARY KEY (ths_id);


--
-- Name: top_hosts_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY top_hosts
    ADD CONSTRAINT top_hosts_pkey PRIMARY KEY (ip, ths_id);


--
-- Name: types_name_key; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_name_key UNIQUE (name);


--
-- Name: types_pkey; Type: CONSTRAINT; Schema: fast; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_pkey PRIMARY KEY (type_id);


SET search_path = fgen, pg_catalog;

--
-- Name: percents_host_count_key; Type: CONSTRAINT; Schema: fgen; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY percents
    ADD CONSTRAINT percents_host_count_key UNIQUE (host_count);


--
-- Name: percents_min_percent_key; Type: CONSTRAINT; Schema: fgen; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY percents
    ADD CONSTRAINT percents_min_percent_key UNIQUE (min_percent);


--
-- Name: types_description_key; Type: CONSTRAINT; Schema: fgen; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_description_key UNIQUE (description);


--
-- Name: types_name_key; Type: CONSTRAINT; Schema: fgen; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_name_key UNIQUE (name);


--
-- Name: types_pkey; Type: CONSTRAINT; Schema: fgen; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_pkey PRIMARY KEY (type_id);


SET search_path = flood, pg_catalog;

--
-- Name: alert_types_name_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY alert_types
    ADD CONSTRAINT alert_types_name_key UNIQUE (name);


--
-- Name: alert_types_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY alert_types
    ADD CONSTRAINT alert_types_pkey PRIMARY KEY (alert_type_id);


--
-- Name: alerters_name_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY alerters
    ADD CONSTRAINT alerters_name_key UNIQUE (name);


--
-- Name: alerters_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY alerters
    ADD CONSTRAINT alerters_pkey PRIMARY KEY (alerter_id);


--
-- Name: attack_interfaces_triggered_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY attack_interfaces_triggered
    ADD CONSTRAINT attack_interfaces_triggered_pkey PRIMARY KEY (flood_id);


--
-- Name: cache_flood_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY cache
    ADD CONSTRAINT cache_flood_id_key UNIQUE (flood_id);


--
-- Name: config_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY config
    ADD CONSTRAINT config_pkey PRIMARY KEY (name);


--
-- Name: errors_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY errors
    ADD CONSTRAINT errors_pkey PRIMARY KEY (error_id);


--
-- Name: importance_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_pkey PRIMARY KEY (flood_id);


--
-- Name: matches_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY matches
    ADD CONSTRAINT matches_pkey PRIMARY KEY (filter_id, match_id);


--
-- Name: mtg_live_log_past_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_pkey PRIMARY KEY (id);


--
-- Name: mtg_live_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_pkey PRIMARY KEY (sg_id, pattern_id);


--
-- Name: mtg_map_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_map
    ADD CONSTRAINT mtg_map_pkey PRIMARY KEY (host_id, sg_id);


--
-- Name: mtg_reqs_log_past_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_pkey PRIMARY KEY (flood_id, req_since);


--
-- Name: mtg_reqs_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_pkey PRIMARY KEY (flood_id);


--
-- Name: mtg_sg_state_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_sg_state
    ADD CONSTRAINT mtg_sg_state_pkey PRIMARY KEY (sg_id);


--
-- Name: mtg_states_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_states
    ADD CONSTRAINT mtg_states_pkey PRIMARY KEY (state_id);


--
-- Name: pattern_entropy_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY pattern_entropy
    ADD CONSTRAINT pattern_entropy_pkey PRIMARY KEY (flood_id, pattern_id);


--
-- Name: registry_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY registry
    ADD CONSTRAINT registry_pkey PRIMARY KEY (flood_id);


--
-- Name: samples_alerts_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_alerts_id_key UNIQUE (alerts_id);


--
-- Name: samples_entropy_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_entropy_id_key UNIQUE (entropy_id);


--
-- Name: samples_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_pkey PRIMARY KEY (at, flood_id);


--
-- Name: samples_report_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_report_id_key UNIQUE (report_id);


--
-- Name: samples_sample_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_sample_id_key UNIQUE (sample_id);


--
-- Name: samples_top_hosts_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_top_hosts_id_key UNIQUE (top_hosts_id);


--
-- Name: state_flood_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY state
    ADD CONSTRAINT state_flood_id_key UNIQUE (flood_id);


--
-- Name: stats_flood_id_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY stats
    ADD CONSTRAINT stats_flood_id_key UNIQUE (flood_id);


--
-- Name: thresholds_name_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY thresholds
    ADD CONSTRAINT thresholds_name_key UNIQUE (name);


--
-- Name: thresholds_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY thresholds
    ADD CONSTRAINT thresholds_pkey PRIMARY KEY (threshold_id);


--
-- Name: top_hosts_dst_flood_id_ip_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY top_hosts_dst
    ADD CONSTRAINT top_hosts_dst_flood_id_ip_key UNIQUE (flood_id, ip);


--
-- Name: top_hosts_src_flood_id_ip_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY top_hosts_src
    ADD CONSTRAINT top_hosts_src_flood_id_ip_key UNIQUE (flood_id, ip);


--
-- Name: top_interfaces_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY top_interfaces
    ADD CONSTRAINT top_interfaces_pkey PRIMARY KEY (flood_id);


--
-- Name: types_name_key; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_name_key UNIQUE (name);


--
-- Name: types_pkey; Type: CONSTRAINT; Schema: flood; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_pkey PRIMARY KEY (type_id);


SET search_path = notify, pg_catalog;

--
-- Name: complete_targets_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY complete_targets
    ADD CONSTRAINT complete_targets_pkey PRIMARY KEY (target_id);


--
-- Name: data_type_operators_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY data_type_operators
    ADD CONSTRAINT data_type_operators_pkey PRIMARY KEY (data_type_id, operator_id);


--
-- Name: data_types_name_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY data_types
    ADD CONSTRAINT data_types_name_key UNIQUE (name);


--
-- Name: data_types_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY data_types
    ADD CONSTRAINT data_types_pkey PRIMARY KEY (data_type_id);


--
-- Name: fields_field_id_type_id_data_type_id_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY fields
    ADD CONSTRAINT fields_field_id_type_id_data_type_id_key UNIQUE (field_id, type_id, data_type_id);


--
-- Name: fields_field_id_type_id_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY fields
    ADD CONSTRAINT fields_field_id_type_id_key UNIQUE (field_id, type_id);


--
-- Name: fields_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY fields
    ADD CONSTRAINT fields_pkey PRIMARY KEY (field_id);


--
-- Name: fields_type_id_name_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY fields
    ADD CONSTRAINT fields_type_id_name_key UNIQUE (type_id, name);


--
-- Name: filter_parts_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY filter_parts
    ADD CONSTRAINT filter_parts_pkey PRIMARY KEY (filter_id, field_id, operator_id, operand);


--
-- Name: CONSTRAINT filter_parts_pkey ON filter_parts; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_parts_pkey ON filter_parts IS 'Rule for this policy with the same field, operator and operand already exists';


--
-- Name: filter_templates_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY filter_templates
    ADD CONSTRAINT filter_templates_pkey PRIMARY KEY (filter_id, target_type_id);


--
-- Name: CONSTRAINT filter_templates_pkey ON filter_templates; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_templates_pkey ON filter_templates IS 'Policy or recipient type doesn''t exist';


--
-- Name: filters_filter_id_type_id_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY filters
    ADD CONSTRAINT filters_filter_id_type_id_key UNIQUE (filter_id, type_id);


--
-- Name: filters_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY filters
    ADD CONSTRAINT filters_pkey PRIMARY KEY (filter_id);


--
-- Name: filters_type_id_name_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY filters
    ADD CONSTRAINT filters_type_id_name_key UNIQUE (type_id, name);


--
-- Name: CONSTRAINT filters_type_id_name_key ON filters; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filters_type_id_name_key ON filters IS 'Top level or nested policy of this name for this type already exists';


--
-- Name: operators_name_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY operators
    ADD CONSTRAINT operators_name_key UNIQUE (name);


--
-- Name: operators_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY operators
    ADD CONSTRAINT operators_pkey PRIMARY KEY (operator_id);


--
-- Name: targets_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY targets
    ADD CONSTRAINT targets_pkey PRIMARY KEY (target_id);


--
-- Name: targets_target_id_name_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY targets
    ADD CONSTRAINT targets_target_id_name_key UNIQUE (target_type_id, name);


--
-- Name: CONSTRAINT targets_target_id_name_key ON targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT targets_target_id_name_key ON targets IS 'Action with such name already exists';


--
-- Name: targets_target_id_target_type_id_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY targets
    ADD CONSTRAINT targets_target_id_target_type_id_key UNIQUE (target_id, target_type_id);


--
-- Name: templates_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_pkey PRIMARY KEY (template_id);


--
-- Name: templates_template_id_target_type_id_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_template_id_target_type_id_key UNIQUE (template_id, target_type_id);


--
-- Name: templates_type_id_target_type_id_name_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_type_id_target_type_id_name_key UNIQUE (type_id, target_type_id, name);


--
-- Name: type_links_type_id_from_to_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY type_links
    ADD CONSTRAINT type_links_type_id_from_to_key UNIQUE (type_id, "from", "to");


--
-- Name: types_name_key; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_name_key UNIQUE (name);


--
-- Name: types_pkey; Type: CONSTRAINT; Schema: notify; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY types
    ADD CONSTRAINT types_pkey PRIMARY KEY (type_id);


SET search_path = nx, pg_catalog;

--
-- Name: map_ip_hostlist_id_key; Type: CONSTRAINT; Schema: nx; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY map
    ADD CONSTRAINT map_ip_hostlist_id_key UNIQUE (ip, hostlist_id);


SET search_path = public, pg_catalog;

--
-- Name: cluster_config_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY cluster_config
    ADD CONSTRAINT cluster_config_pkey PRIMARY KEY (cluster_id);


--
-- Name: data_tables_host_id_group_id_struct_id_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY data_tables
    ADD CONSTRAINT data_tables_host_id_group_id_struct_id_key UNIQUE (host_id, group_id, struct_id);


--
-- Name: data_tables_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY data_tables
    ADD CONSTRAINT data_tables_pkey PRIMARY KEY (table_id);


--
-- Name: group_mapping_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY group_mapping
    ADD CONSTRAINT group_mapping_pkey PRIMARY KEY (host_id, group_id);


--
-- Name: CONSTRAINT group_mapping_pkey ON group_mapping; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT group_mapping_pkey ON group_mapping IS 'This group is already configured for this host';


--
-- Name: groups_name_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_name_key UNIQUE (name);


--
-- Name: CONSTRAINT groups_name_key ON groups; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT groups_name_key ON groups IS 'A group with such name already exists';


--
-- Name: groups_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (group_id);


--
-- Name: hosts_ip_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY hosts
    ADD CONSTRAINT hosts_ip_key UNIQUE (ip,management_port);


--
-- Name: CONSTRAINT hosts_ip_key ON hosts; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT hosts_ip_key ON hosts IS 'Host with such IP/management_port  already exists';


--
-- Name: hosts_name_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY hosts
    ADD CONSTRAINT hosts_name_key UNIQUE (name);


--
-- Name: CONSTRAINT hosts_name_key ON hosts; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT hosts_name_key ON hosts IS 'Host with such name already exists';


--
-- Name: hosts_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY hosts
    ADD CONSTRAINT hosts_pkey PRIMARY KEY (host_id);


--
-- Name: post_target_types_name_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY post_target_types
    ADD CONSTRAINT post_target_types_name_key UNIQUE (name);


--
-- Name: post_target_types_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY post_target_types
    ADD CONSTRAINT post_target_types_pkey PRIMARY KEY (target_type_id);


--
-- Name: post_target_types_target_type_id_multiple_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY post_target_types
    ADD CONSTRAINT post_target_types_target_type_id_multiple_key UNIQUE (target_type_id, multiple);


--
-- Name: sensor_clusters_member_id_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY sensor_clusters
    ADD CONSTRAINT sensor_clusters_member_id_key UNIQUE (member_id);


--
-- Name: statistics_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY statistics
    ADD CONSTRAINT statistics_pkey PRIMARY KEY (stat_id);


--
-- Name: statistics_struct_id_name_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY statistics
    ADD CONSTRAINT statistics_struct_id_name_key UNIQUE (struct_id, name);


--
-- Name: struct_types_name_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY struct_types
    ADD CONSTRAINT struct_types_name_key UNIQUE (name);


--
-- Name: struct_types_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY struct_types
    ADD CONSTRAINT struct_types_pkey PRIMARY KEY (type_id);


--
-- Name: structs_name_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY structs
    ADD CONSTRAINT structs_name_key UNIQUE (name);


--
-- Name: structs_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY structs
    ADD CONSTRAINT structs_pkey PRIMARY KEY (struct_id);


--
-- Name: subsystems_name_host_id_key; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY subsystems
    ADD CONSTRAINT subsystems_name_host_id_key UNIQUE (name, host_id);


--
-- Name: subsystems_pkey; Type: CONSTRAINT; Schema: public; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY subsystems
    ADD CONSTRAINT subsystems_pkey PRIMARY KEY (subsystem_id);


SET search_path = purge, pg_catalog;

--
-- Name: dbstate_pkey; Type: CONSTRAINT; Schema: purge; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY dbstate
    ADD CONSTRAINT dbstate_pkey PRIMARY KEY (at);


--
-- Name: jobs_pkey; Type: CONSTRAINT; Schema: purge; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY jobs
    ADD CONSTRAINT jobs_pkey PRIMARY KEY (jobid);


--
-- Name: relstate_pkey; Type: CONSTRAINT; Schema: purge; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY relstate
    ADD CONSTRAINT relstate_pkey PRIMARY KEY (relid);


--
-- Name: rules_check; Type: CHECK CONSTRAINT; Schema: purge; Owner: ndbadm
--

ALTER TABLE rules
    ADD CONSTRAINT rules_check CHECK (rule_check(rules.*));


SET search_path = quarantine, pg_catalog;

--
-- Name: captures_pkey; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY captures
    ADD CONSTRAINT captures_pkey PRIMARY KEY (capture_id);


--
-- Name: captures_timestamp_addr_key; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY captures
    ADD CONSTRAINT captures_timestamp_addr_key UNIQUE ("timestamp", addr);


--
-- Name: event_types_name_key; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY event_types
    ADD CONSTRAINT event_types_name_key UNIQUE (name);


--
-- Name: event_types_pkey; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY event_types
    ADD CONSTRAINT event_types_pkey PRIMARY KEY (type_id);


--
-- Name: importance_pkey; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_pkey PRIMARY KEY (capture_id);


--
-- Name: matches_pkey; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY matches
    ADD CONSTRAINT matches_pkey PRIMARY KEY (filter_id, match_id);


--
-- Name: samples_pkey; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_pkey PRIMARY KEY (capture_id);


--
-- Name: samples_sample_id_key; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_sample_id_key UNIQUE (sample_id);


--
-- Name: sources_pkey; Type: CONSTRAINT; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY sources
    ADD CONSTRAINT sources_pkey PRIMARY KEY (since, subsystem_id, group_id);


SET search_path = report, pg_catalog;

--
-- Name: list_pkey; Type: CONSTRAINT; Schema: report; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY list
    ADD CONSTRAINT list_pkey PRIMARY KEY (report_id);


--
-- Name: list_uid_name_key; Type: CONSTRAINT; Schema: report; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY list
    ADD CONSTRAINT list_uid_name_key UNIQUE (uid, name);


--
-- Name: mail_pkey; Type: CONSTRAINT; Schema: report; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mail
    ADD CONSTRAINT mail_pkey PRIMARY KEY (report_id, mail_id);


--
-- Name: views_pkey; Type: CONSTRAINT; Schema: report; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY views
    ADD CONSTRAINT views_pkey PRIMARY KEY (view_id);


--
-- Name: views_report_id_order_key; Type: CONSTRAINT; Schema: report; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY views
    ADD CONSTRAINT views_report_id_order_key UNIQUE (report_id, "order");


SET search_path = smp, pg_catalog;

--
-- Name: map_host_id_smp_id_key; Type: CONSTRAINT; Schema: smp; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY map
    ADD CONSTRAINT map_host_id_smp_id_key PRIMARY KEY (host_id, smp_id);


--
-- Name: mtg_live_log_past_pkey; Type: CONSTRAINT; Schema: smp; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_pkey PRIMARY KEY (user_id, state_since, smp_id);


--
-- Name: mtg_live_pkey; Type: CONSTRAINT; Schema: smp; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_pkey PRIMARY KEY (user_id, smp_id);


--
-- Name: mtg_reqs_log_past_pkey; Type: CONSTRAINT; Schema: smp; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_pkey PRIMARY KEY (user_id, req_since);


--
-- Name: mtg_reqs_pkey; Type: CONSTRAINT; Schema: smp; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_pkey PRIMARY KEY (user_id);


--
-- Name: mtg_states_pkey; Type: CONSTRAINT; Schema: smp; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY mtg_states
    ADD CONSTRAINT mtg_states_pkey PRIMARY KEY (state_id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: smp; Owner: ndbadm; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (user_id);


SET search_path = auth, pg_catalog;

--
-- Name: passwd_mail_id_idx; Type: INDEX; Schema: auth; Owner: postgres; Tablespace: 
--

CREATE INDEX passwd_mail_id_idx ON passwd USING btree (mail_id);


SET search_path = fast, pg_catalog;

--
-- Name: entities__modified; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX entities__modified ON entities USING btree (modified);


--
-- Name: entity_data__type_id__entity_id; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX entity_data__type_id__entity_id ON entity_data USING btree (type_id, entity_id);


--
-- Name: entity_links__to; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX entity_links__to ON entity_links USING btree ("to");


--
-- Name: entity_patterns__pattern_id; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX entity_patterns__pattern_id ON entity_patterns USING btree (pattern_id);


--
-- Name: entity_patterns_pattern_id; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX entity_patterns_pattern_id ON entity_patterns USING btree (pattern_id);


--
-- Name: pat_contents__pat_strip_id; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX pat_contents__pat_strip_id ON pat_contents USING btree (pat_strip_id);


--
-- Name: pat_endpoint_search__dst_port_idx; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX pat_endpoint_search__dst_port_idx ON pat_endpoint_search USING btree (dst_port);


--
-- Name: pat_endpoint_search__src_port_idx; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX pat_endpoint_search__src_port_idx ON pat_endpoint_search USING btree (src_port);


--
-- Name: pat_payload_search_word_idx; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX pat_payload_search_word_idx ON pat_payload_search USING btree (word);


--
-- Name: pat_strips__unique; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX pat_strips__unique ON pat_strips USING btree (layer, pat_strip_hash(pat_strips.*));


--
-- Name: top_host_sets__pattern_id; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX top_host_sets__pattern_id ON top_host_sets USING btree (pattern_id);


--
-- Name: top_host_sets_pattern_id; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX top_host_sets_pattern_id ON top_host_sets USING btree (pattern_id);


--
-- Name: top_hosts__ths_id; Type: INDEX; Schema: fast; Owner: ndbadm; Tablespace: 
--

CREATE INDEX top_hosts__ths_id ON top_hosts USING btree (ths_id);


SET search_path = flood, pg_catalog;

--
-- Name: alerts__pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX alerts__pattern_id ON alerts USING btree (pattern_id);


--
-- Name: alerts_pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX alerts_pattern_id ON alerts USING btree (pattern_id);


--
-- Name: alerts_ukey; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX alerts_ukey ON alerts USING btree (flood_id, (COALESCE(pattern_id, (-1))), ((pattern_id IS NULL)), (COALESCE(sample_id, (-1))), ((sample_id IS NULL)), alerter_id, alert_type_id);


--
-- Name: errors__active; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX errors__active ON errors USING btree (((stop IS NULL)));


--
-- Name: errors__start; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX errors__start ON errors USING btree (start);


--
-- Name: errors__stop; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX errors__stop ON errors USING btree (stop);


--
-- Name: errors__subsystem_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX errors__subsystem_id ON errors USING btree (subsystem_id);


--
-- Name: graphs__flood_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX graphs__flood_id ON graphs USING btree (flood_id);


--
-- Name: importance__ignore; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX importance__ignore ON importance USING btree (flood_id) WHERE (importance = 0);


--
-- Name: importance__uid; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX importance__uid ON importance USING btree (uid);


--
-- Name: matches_at; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX matches_at ON matches USING btree (at);


--
-- Name: matches_match_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX matches_match_id ON matches USING btree (match_id);


--
-- Name: mtg_graphs_real__at; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_graphs_real__at ON mtg_graphs_real USING btree (at);


--
-- Name: mtg_graphs_real__pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_graphs_real__pattern_id ON mtg_graphs_real USING btree (pattern_id);


--
-- Name: mtg_graphs_real__pkey; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX mtg_graphs_real__pkey ON mtg_graphs_real USING btree (sg_id, (COALESCE(pattern_id, 0)), at);


--
-- Name: mtg_graphs_real_pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_graphs_real_pattern_id ON mtg_graphs_real USING btree (pattern_id);


--
-- Name: mtg_live__pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live__pattern_id ON mtg_live USING btree (pattern_id);


--
-- Name: mtg_live__refresh; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live__refresh ON mtg_live USING btree (sg_id, pattern_id) WHERE refresh;


--
-- Name: mtg_live_log_past__pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_log_past__pattern_id ON mtg_live_log_past USING btree (pattern_id);


--
-- Name: mtg_live_log_past__sgid_patternid_statesince; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_log_past__sgid_patternid_statesince ON mtg_live_log_past USING btree (sg_id, pattern_id, state_since);


--
-- Name: mtg_live_log_past__state_until; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_log_past__state_until ON mtg_live_log_past USING btree (state_until);


--
-- Name: mtg_live_log_past_pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_log_past_pattern_id ON mtg_live_log_past USING btree (pattern_id);


--
-- Name: mtg_live_pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_pattern_id ON mtg_live USING btree (pattern_id);


--
-- Name: mtg_map__target_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_map__target_id ON mtg_map USING btree (sg_id);


--
-- Name: mtg_reqs__action_expire; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs__action_expire ON mtg_reqs USING btree (action_expire);


--
-- Name: mtg_reqs__orig_pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs__orig_pattern_id ON mtg_reqs USING btree (orig_pattern_id);


--
-- Name: mtg_reqs__pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs__pattern_id ON mtg_reqs USING btree (pattern_id);


--
-- Name: mtg_reqs__uid; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs__uid ON mtg_reqs USING btree (uid);


--
-- Name: mtg_reqs_log_past__orig_pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past__orig_pattern_id ON mtg_reqs_log_past USING btree (orig_pattern_id);


--
-- Name: mtg_reqs_log_past__pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past__pattern_id ON mtg_reqs_log_past USING btree (pattern_id);


--
-- Name: mtg_reqs_log_past__req_until; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past__req_until ON mtg_reqs_log_past USING btree (req_until);


--
-- Name: mtg_reqs_log_past__uid; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past__uid ON mtg_reqs_log_past USING btree (uid);


--
-- Name: mtg_reqs_log_past_orig_pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past_orig_pattern_id ON mtg_reqs_log_past USING btree (orig_pattern_id);


--
-- Name: pattern_entropy__flood_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX pattern_entropy__flood_id ON pattern_entropy USING btree (flood_id);


--
-- Name: pattern_entropy__pattern_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX pattern_entropy__pattern_id ON pattern_entropy USING btree (pattern_id);


--
-- Name: registry__group_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX registry__group_id ON registry USING btree (group_id);


--
-- Name: registry__host_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX registry__host_id ON registry USING btree (host_id);


--
-- Name: registry__subsystem_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX registry__subsystem_id ON registry USING btree (subsystem_id);


--
-- Name: registry__type_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX registry__type_id ON registry USING btree (type_id);


--
-- Name: samples__alerts_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX samples__alerts_id ON samples USING btree (alerts_id);


--
-- Name: samples__flood_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX samples__flood_id ON samples USING btree (flood_id);


--
-- Name: samples__unprocessed; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX samples__unprocessed ON samples USING btree (at) WHERE (NOT processed);


--
-- Name: state__active; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX state__active ON state USING btree (((stop IS NULL)));


--
-- Name: state__start; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX state__start ON state USING btree (start);


--
-- Name: state__stop; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX state__stop ON state USING btree (stop);


--
-- Name: thresholds__group_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX thresholds__group_id ON thresholds USING btree (group_id);


--
-- Name: thresholds__host_id; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX thresholds__host_id ON thresholds USING btree (host_id);

--
-- Name: top_asns_patternid_captureid; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX top_asns_patternid_captureid ON top_asns USING btree (pattern_id, capture_id);

--
-- Name: top_countries_patternid_captureid; Type: INDEX; Schema: flood; Owner: ndbadm; Tablespace: 
--

CREATE INDEX top_countries_patternid_captureid ON top_countries USING btree (pattern_id, capture_id);


SET search_path = notify, pg_catalog;

--
-- Name: filter_targets__target_id; Type: INDEX; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE INDEX filter_targets__target_id ON filter_targets USING btree (target_id);


--
-- Name: filter_targets_pkey; Type: INDEX; Schema: notify; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX filter_targets_pkey ON filter_targets USING btree (filter_id, target_type_id(target_id), (CASE WHEN public.post_target_type_multiple(target_type_id(target_id)) THEN target_id ELSE 0 END));


SET search_path = nx, pg_catalog;

--
-- Name: map__expires; Type: INDEX; Schema: nx; Owner: ndbadm; Tablespace: 
--

CREATE INDEX map__expires ON map USING btree (expires);


--
-- Name: map__hostlist_id; Type: INDEX; Schema: nx; Owner: ndbadm; Tablespace: 
--

CREATE INDEX map__hostlist_id ON map USING btree (hostlist_id);


--
-- Name: map__target_current; Type: INDEX; Schema: nx; Owner: ndbadm; Tablespace: 
--

CREATE INDEX map__target_current ON map USING btree (target, current);


SET search_path = public, pg_catalog;

--
-- Name: data_tables__group_id; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX data_tables__group_id ON data_tables USING btree (group_id);


--
-- Name: data_tables__relid; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX data_tables__relid ON data_tables USING btree (relid);


--
-- Name: group_config__curgid; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX group_config__curgid ON group_config USING btree (group_id) WHERE ("to" IS NULL);


--
-- Name: group_config__curpref; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX group_config__curpref ON group_config USING btree (prefix) WHERE ("to" IS NULL);


--
-- Name: group_config__gid; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX group_config__gid ON group_config USING btree (group_id);


--
-- Name: group_mapping__group; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX group_mapping__group ON group_mapping USING btree (group_id);


--
-- Name: permissions__group_id; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX permissions__group_id ON permissions USING btree (group_id);


--
-- Name: permissions__host_id; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX permissions__host_id ON permissions USING btree (host_id);


--
-- Name: permissions_pkey; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX permissions_pkey ON permissions USING btree (user_id, attribute, (COALESCE(host_id, (-1))), ((host_id IS NULL)), (COALESCE(group_id, (-1))), ((group_id IS NULL)));


--
-- Name: INDEX permissions_pkey; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON INDEX permissions_pkey IS 'Such an ACL entry already exists';


--
-- Name: sensor_clusters__cluster_id; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX sensor_clusters__cluster_id ON sensor_clusters USING btree (cluster_id);


--
-- Name: subsystems__host_id; Type: INDEX; Schema: public; Owner: ndbadm; Tablespace: 
--

CREATE INDEX subsystems__host_id ON subsystems USING btree (host_id);


SET search_path = purge, pg_catalog;

--
-- Name: history__at; Type: INDEX; Schema: purge; Owner: ndbadm; Tablespace: 
--

CREATE INDEX history__at ON history USING btree (at);


--
-- Name: history__relid; Type: INDEX; Schema: purge; Owner: ndbadm; Tablespace: 
--

CREATE INDEX history__relid ON history USING btree (relid);


SET search_path = quarantine, pg_catalog;

--
-- Name: captures__fast_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX captures__fast_id ON captures USING btree (fast_id);


--
-- Name: captures__group_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX captures__group_id ON captures USING btree (group_id);


--
-- Name: captures__id_addr; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX captures__id_addr ON captures USING btree (capture_id, addr);


--
-- Name: captures__modified; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX captures__modified ON captures USING btree (modified);


--
-- Name: captures__source__ts; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX captures__source__ts ON captures USING btree (source(captures.*), "timestamp");


--
-- Name: captures__subsystem_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX captures__subsystem_id ON captures USING btree (subsystem_id);


--
-- Name: captures__user_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX captures__user_id ON captures USING btree (user_id);


--
-- Name: events_pkey; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX events_pkey ON events USING btree (capture_id, type_id, (COALESCE(target_proto, (-1))), (COALESCE(target_ip, '127.0.0.1'::inet)), ((target_ip IS NULL)), (COALESCE(target_port, (-1))));


--
-- Name: INDEX events_pkey; Type: COMMENT; Schema: quarantine; Owner: ndbadm
--

COMMENT ON INDEX events_pkey IS 'This event already exists';


--
-- Name: importance__ignore; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX importance__ignore ON importance USING btree (capture_id) WHERE (importance = 0);


--
-- Name: importance__uid; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX importance__uid ON importance USING btree (uid);


--
-- Name: magic; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX magic ON sources USING btree (public.timestamp_hour(since), subsystem_id, group_id);


--
-- Name: matches_at; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX matches_at ON matches USING btree (at);


--
-- Name: matches_match_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX matches_match_id ON matches USING btree (match_id);


--
-- Name: samples__at; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX samples__at ON samples USING btree (at);


--
-- Name: samples__id_addr; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX samples__id_addr ON samples USING btree (capture_id, addr);


--
-- Name: samples__source; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX samples__source ON samples USING btree (source(user_id, addr));


--
-- Name: samples__user_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX samples__user_id ON samples USING btree (user_id);


--
-- Name: sources__group_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX sources__group_id ON sources USING btree (group_id);


--
-- Name: sources__subsystem_id; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX sources__subsystem_id ON sources USING btree (subsystem_id);


--
-- Name: sources__until; Type: INDEX; Schema: quarantine; Owner: ndbadm; Tablespace: 
--

CREATE INDEX sources__until ON sources USING btree (until);


SET search_path = report, pg_catalog;

--
-- Name: mail__mail_id; Type: INDEX; Schema: report; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mail__mail_id ON mail USING btree (mail_id);


SET search_path = smp, pg_catalog;

--
-- Name: map__smp_id; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX map__smp_id ON map USING btree (smp_id);


--
-- Name: mtg_live__action; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live__action ON mtg_live USING btree (action);


--
-- Name: mtg_live__refresh; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live__refresh ON mtg_live USING btree (user_id, smp_id) WHERE refresh;


--
-- Name: mtg_live__smp_id; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live__smp_id ON mtg_live USING btree (smp_id);


--
-- Name: mtg_live_log_past__action; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_log_past__action ON mtg_live_log_past USING btree (action);


--
-- Name: mtg_live_log_past__smp_id; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_log_past__smp_id ON mtg_live_log_past USING btree (smp_id);


--
-- Name: mtg_live_log_past__state_until; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_live_log_past__state_until ON mtg_live_log_past USING btree (state_until);


--
-- Name: mtg_reqs__action; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs__action ON mtg_reqs USING btree (action);


--
-- Name: mtg_reqs__action_expire; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs__action_expire ON mtg_reqs USING btree (action_expire);


--
-- Name: mtg_reqs__uid; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs__uid ON mtg_reqs USING btree (uid);


--
-- Name: mtg_reqs_log_past__action; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past__action ON mtg_reqs_log_past USING btree (action);


--
-- Name: mtg_reqs_log_past__req_until; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past__req_until ON mtg_reqs_log_past USING btree (req_until);


--
-- Name: mtg_reqs_log_past__uid; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX mtg_reqs_log_past__uid ON mtg_reqs_log_past USING btree (uid);


--
-- Name: users_modified; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE INDEX users_modified ON users USING btree (modified);


--
-- Name: users_name; Type: INDEX; Schema: smp; Owner: ndbadm; Tablespace: 
--

CREATE UNIQUE INDEX users_name ON users USING btree (name, (CASE WHEN deleted THEN user_id ELSE 0 END));


--
-- Name: INDEX users_name; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON INDEX users_name IS 'Active users must have unique names';


SET search_path = fast, pg_catalog;

--
-- Name: fast.entities.modified__insert; Type: RULE; Schema: fast; Owner: ndbadm
--

CREATE RULE "fast.entities.modified__insert" AS ON INSERT TO entity_data DO UPDATE entities SET modified = now() WHERE ((entities.entity_id = new.entity_id) AND (entities.modified < now()));


--
-- Name: RULE "fast.entities.modified__insert" ON entity_data; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON RULE "fast.entities.modified__insert" ON entity_data IS 'Updates corresponding fast.entities.modified on every insert';


--
-- Name: fast.entities.modified__insert; Type: RULE; Schema: fast; Owner: ndbadm
--

CREATE RULE "fast.entities.modified__insert" AS ON INSERT TO attrs DO UPDATE entities SET modified = now() WHERE ((entities.entity_id = new.entity_id) AND (entities.modified < now()));


--
-- Name: RULE "fast.entities.modified__insert" ON attrs; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON RULE "fast.entities.modified__insert" ON attrs IS 'Updates corresponding fast.entities.modified on every insert';


--
-- Name: fast.entities.modified__update; Type: RULE; Schema: fast; Owner: ndbadm
--

CREATE RULE "fast.entities.modified__update" AS ON UPDATE TO entity_data DO UPDATE entities SET modified = now() WHERE ((entities.entity_id = new.entity_id) AND (entities.modified < now()));


--
-- Name: RULE "fast.entities.modified__update" ON entity_data; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON RULE "fast.entities.modified__update" ON entity_data IS 'Updates corresponding fast.entities.modified on every update';


--
-- Name: fast.entities.modified__update; Type: RULE; Schema: fast; Owner: ndbadm
--

CREATE RULE "fast.entities.modified__update" AS ON UPDATE TO attrs DO UPDATE entities SET modified = now() WHERE ((entities.entity_id = new.entity_id) AND (entities.modified < now()));


--
-- Name: RULE "fast.entities.modified__update" ON attrs; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON RULE "fast.entities.modified__update" ON attrs IS 'Updates corresponding fast.entities.modified on every update';


SET search_path = flood, pg_catalog;

--
-- Name: flood.state.modified__insert; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__insert" AS ON INSERT TO samples DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__insert" ON samples; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__insert" ON samples IS 'Updates corresponding flood.state.modified on every insert';


--
-- Name: flood.state.modified__insert; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__insert" AS ON INSERT TO stats DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__insert" ON stats; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__insert" ON stats IS 'Updates corresponding flood.state.modified on every insert';


--
-- Name: flood.state.modified__insert; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__insert" AS ON INSERT TO cache DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__insert" ON cache; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__insert" ON cache IS 'Updates corresponding flood.state.modified on every insert';


--
-- Name: flood.state.modified__insert; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__insert" AS ON INSERT TO mtg_reqs DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__insert" ON mtg_reqs; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__insert" ON mtg_reqs IS 'Updates corresponding flood.state.modified on every insert';


--
-- Name: flood.state.modified__update; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__update" AS ON UPDATE TO samples DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__update" ON samples; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__update" ON samples IS 'Updates corresponding flood.state.modified on every update';


--
-- Name: flood.state.modified__update; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__update" AS ON UPDATE TO stats DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__update" ON stats; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__update" ON stats IS 'Updates corresponding flood.state.modified on every update';


--
-- Name: flood.state.modified__update; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__update" AS ON UPDATE TO cache DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__update" ON cache; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__update" ON cache IS 'Updates corresponding flood.state.modified on every update';


--
-- Name: flood.state.modified__update; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE "flood.state.modified__update" AS ON UPDATE TO mtg_reqs DO UPDATE state SET modified = now() WHERE ((state.flood_id = new.flood_id) AND (state.modified < now()));


--
-- Name: RULE "flood.state.modified__update" ON mtg_reqs; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON RULE "flood.state.modified__update" ON mtg_reqs IS 'Updates corresponding flood.state.modified on every update';


--
-- Name: log_delete; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE log_delete AS ON DELETE TO mtg_live DO INSERT INTO mtg_live_log_past (sg_id, pattern_id, state_id, state_details, state_since) VALUES (old.sg_id, old.pattern_id, old.state_id, old.state_details, old.state_since);


--
-- Name: log_update; Type: RULE; Schema: flood; Owner: ndbadm
--

CREATE RULE log_update AS ON UPDATE TO mtg_live WHERE ((new.state_id IS DISTINCT FROM old.state_id) OR (new.state_details IS DISTINCT FROM old.state_details)) DO INSERT INTO mtg_live_log_past (sg_id, pattern_id, state_id, state_details, state_since) VALUES (old.sg_id, old.pattern_id, old.state_id, old.state_details, old.state_since);


SET search_path = notify, pg_catalog;

--
-- Name: modified__delete; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE modified__delete AS ON DELETE TO filter_parts DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = old.filter_id) AND (filters.modified < now()));


--
-- Name: modified__delete; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE modified__delete AS ON DELETE TO filter_targets DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = old.filter_id) AND (filters.modified < now()));


--
-- Name: modified__delete; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE modified__delete AS ON DELETE TO filter_templates DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = old.filter_id) AND (filters.modified < now()));


--
-- Name: notify.filters.modified__insert; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE "notify.filters.modified__insert" AS ON INSERT TO filter_parts DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = new.filter_id) AND (filters.modified < now()));


--
-- Name: RULE "notify.filters.modified__insert" ON filter_parts; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON RULE "notify.filters.modified__insert" ON filter_parts IS 'Updates corresponding notify.filters.modified on every insert';


--
-- Name: notify.filters.modified__insert; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE "notify.filters.modified__insert" AS ON INSERT TO filter_targets DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = new.filter_id) AND (filters.modified < now()));


--
-- Name: RULE "notify.filters.modified__insert" ON filter_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON RULE "notify.filters.modified__insert" ON filter_targets IS 'Updates corresponding notify.filters.modified on every insert';


--
-- Name: notify.filters.modified__insert; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE "notify.filters.modified__insert" AS ON INSERT TO filter_templates DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = new.filter_id) AND (filters.modified < now()));


--
-- Name: RULE "notify.filters.modified__insert" ON filter_templates; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON RULE "notify.filters.modified__insert" ON filter_templates IS 'Updates corresponding notify.filters.modified on every insert';


--
-- Name: notify.filters.modified__update; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE "notify.filters.modified__update" AS ON UPDATE TO filter_parts DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = new.filter_id) AND (filters.modified < now()));


--
-- Name: RULE "notify.filters.modified__update" ON filter_parts; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON RULE "notify.filters.modified__update" ON filter_parts IS 'Updates corresponding notify.filters.modified on every update';


--
-- Name: notify.filters.modified__update; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE "notify.filters.modified__update" AS ON UPDATE TO filter_targets DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = new.filter_id) AND (filters.modified < now()));


--
-- Name: RULE "notify.filters.modified__update" ON filter_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON RULE "notify.filters.modified__update" ON filter_targets IS 'Updates corresponding notify.filters.modified on every update';


--
-- Name: notify.filters.modified__update; Type: RULE; Schema: notify; Owner: ndbadm
--

CREATE RULE "notify.filters.modified__update" AS ON UPDATE TO filter_templates DO UPDATE filters SET modified = now() WHERE ((filters.filter_id = new.filter_id) AND (filters.modified < now()));


--
-- Name: RULE "notify.filters.modified__update" ON filter_templates; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON RULE "notify.filters.modified__update" ON filter_templates IS 'Updates corresponding notify.filters.modified on every update';


SET search_path = public, pg_catalog;

--
-- Name: update_thresholds; Type: RULE; Schema: public; Owner: ndbadm
--

CREATE RULE update_thresholds AS ON DELETE TO group_mapping DO UPDATE flood.thresholds SET group_id = NULL::integer, host_id = NULL::integer WHERE (((thresholds.group_id = old.group_id) AND (thresholds.host_id = old.host_id)) OR (thresholds.host_id IS NULL));


--
-- Name: RULE update_thresholds ON group_mapping; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON RULE update_thresholds ON group_mapping IS 'When group is removed from sensor, thresholds must stop using the sensor-group';


SET search_path = report, pg_catalog;

--
-- Name: report.list.modified__insert; Type: RULE; Schema: report; Owner: ndbadm
--

CREATE RULE "report.list.modified__insert" AS ON INSERT TO views DO UPDATE list SET modified = now() WHERE ((list.report_id = new.report_id) AND (list.modified < now()));


--
-- Name: RULE "report.list.modified__insert" ON views; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON RULE "report.list.modified__insert" ON views IS 'Updates corresponding report.list.modified on every insert';


--
-- Name: report.list.modified__update; Type: RULE; Schema: report; Owner: ndbadm
--

CREATE RULE "report.list.modified__update" AS ON UPDATE TO views DO UPDATE list SET modified = now() WHERE ((list.report_id = new.report_id) AND (list.modified < now()));


--
-- Name: RULE "report.list.modified__update" ON views; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON RULE "report.list.modified__update" ON views IS 'Updates corresponding report.list.modified on every update';


SET search_path = smp, pg_catalog;

--
-- Name: log_delete; Type: RULE; Schema: smp; Owner: ndbadm
--

CREATE RULE log_delete AS ON DELETE TO mtg_live DO INSERT INTO mtg_live_log_past (user_id, smp_id, action, action_param, state_id, state_details, state_since) SELECT old.user_id, old.smp_id, old.action, old.action_param, CASE WHEN (old.refresh AND mtg_states.hot) THEN 'PEND'::text ELSE old.state_id END AS state_id, CASE WHEN (old.refresh AND mtg_states.hot) THEN NULL::text ELSE old.state_details END AS state_details, old.state_since FROM mtg_states WHERE (mtg_states.state_id = old.state_id);


--
-- Name: log_delete; Type: RULE; Schema: smp; Owner: ndbadm
--

CREATE RULE log_delete AS on DELETE TO mtg_reqs DO (INSERT INTO mtg_reqs_log_past (user_id, filter_id, uid, action, action_expire, action_param, req_since, req_until) SELECT old.user_id, old.filter_id, old.uid, old.action, old.action_expire, old.action_param, GREATEST(old.action_since, ((SELECT max(p.req_until) AS max FROM mtg_reqs_log_past p WHERE (p.user_id = old.user_id)))::timestamp with time zone) AS "greatest", LEAST(old.action_expire, now()) AS "least" FROM users u WHERE (u.user_id = old.user_id); INSERT INTO mtg_reqs_log_past (user_id, filter_id, uid, action, action_expire, action_param, req_since, req_until) SELECT old.user_id, old.filter_id, old.uid, NULL::unknown, old.action_expire, old.action_param, LEAST(old.action_expire, now()) AS "least", LEAST(old.action_expire, now() + interval '1 seconds') AS "least"  FROM users u WHERE ((u.user_id = old.user_id) AND (old.action IS NOT NULL)); );

--
-- Name: log_update; Type: RULE; Schema: smp; Owner: ndbadm
--

CREATE RULE log_update AS ON UPDATE TO mtg_live WHERE (((((new.state_id IS DISTINCT FROM old.state_id) OR (new.state_details IS DISTINCT FROM old.state_details)) OR (new.state_since IS DISTINCT FROM old.state_since)) OR (new.action IS DISTINCT FROM old.action)) OR (new.action_param IS DISTINCT FROM old.action_param)) DO INSERT INTO mtg_live_log_past (user_id, smp_id, action, action_param, state_id, state_details, state_since) SELECT old.user_id, old.smp_id, old.action, old.action_param, CASE WHEN (old.refresh AND mtg_states.hot) THEN 'PEND'::text ELSE old.state_id END AS state_id, CASE WHEN (old.refresh AND mtg_states.hot) THEN NULL::text ELSE old.state_details END AS state_details, old.state_since FROM mtg_states WHERE (mtg_states.state_id = old.state_id);


--
-- Name: log_update; Type: RULE; Schema: smp; Owner: ndbadm
--

CREATE RULE log_update AS ON UPDATE TO mtg_reqs DO INSERT INTO mtg_reqs_log_past (user_id, filter_id, uid, action, action_expire, action_param, req_since) VALUES (old.user_id, old.filter_id, old.uid, old.action, old.action_expire, old.action_param, GREATEST(old.action_since, ((SELECT max(p.req_until) AS max FROM mtg_reqs_log_past p WHERE (p.user_id = old.user_id)))::timestamp with time zone));


--
-- Name: smp.users.modified__insert; Type: RULE; Schema: smp; Owner: ndbadm
--

CREATE RULE "smp.users.modified__insert" AS ON INSERT TO mtg_reqs DO UPDATE users SET modified = now() WHERE ((users.user_id = new.user_id) AND (users.modified < now()));


--
-- Name: RULE "smp.users.modified__insert" ON mtg_reqs; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON RULE "smp.users.modified__insert" ON mtg_reqs IS 'Updates corresponding smp.users.modified on every insert';


--
-- Name: smp.users.modified__update; Type: RULE; Schema: smp; Owner: ndbadm
--

CREATE RULE "smp.users.modified__update" AS ON UPDATE TO mtg_reqs DO UPDATE users SET modified = now() WHERE ((users.user_id = new.user_id) AND (users.modified < now()));


--
-- Name: RULE "smp.users.modified__update" ON mtg_reqs; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON RULE "smp.users.modified__update" ON mtg_reqs IS 'Updates corresponding smp.users.modified on every update';


SET search_path = fast, pg_catalog;

--
-- Name: final__immutable; Type: TRIGGER; Schema: fast; Owner: ndbadm
--

CREATE TRIGGER final__immutable BEFORE UPDATE ON entities FOR EACH ROW EXECUTE PROCEDURE entity__final__immutable();


--
-- Name: no_same_layer_strips; Type: TRIGGER; Schema: fast; Owner: ndbadm
--

CREATE TRIGGER no_same_layer_strips AFTER UPDATE ON pat_contents FOR EACH ROW EXECUTE PROCEDURE pat_contents__no_same_layer_strips();


--
-- Name: pattern_id_check; Type: TRIGGER; Schema: fast; Owner: ndbadm
--

CREATE TRIGGER pattern_id_check BEFORE INSERT OR UPDATE ON top_host_sets FOR EACH ROW EXECUTE PROCEDURE top_host_sets__pattern_id_check();


--
-- Name: strip__parse; Type: TRIGGER; Schema: fast; Owner: ndbadm
--

CREATE TRIGGER strip__parse AFTER INSERT ON pat_strips FOR EACH ROW EXECUTE PROCEDURE pat_strips__parse();


--
-- Name: type_id_checks; Type: TRIGGER; Schema: fast; Owner: ndbadm
--

CREATE TRIGGER type_id_checks BEFORE UPDATE ON entity_data FOR EACH ROW EXECUTE PROCEDURE entity_data__type_id_checks();


--
-- Name: type_must_be_set; Type: TRIGGER; Schema: fast; Owner: ndbadm
--

CREATE TRIGGER type_must_be_set BEFORE INSERT OR UPDATE ON attrs FOR EACH ROW EXECUTE PROCEDURE attrs__type_must_be_set();


--
-- Name: update_flood_modified; Type: TRIGGER; Schema: fast; Owner: ndbadm
--

CREATE TRIGGER update_flood_modified AFTER INSERT OR UPDATE ON entity_data FOR EACH ROW EXECUTE PROCEDURE update_flood_modified();


--
-- Name: TRIGGER update_flood_modified ON entity_data; Type: COMMENT; Schema: fast; Owner: ndbadm
--

COMMENT ON TRIGGER update_flood_modified ON entity_data IS 'Update flood.state.modified for a FAST document related to the flood';


SET search_path = flood, pg_catalog;

--
-- Name: check_insert; Type: TRIGGER; Schema: flood; Owner: ndbadm
--

CREATE TRIGGER check_insert BEFORE INSERT ON mtg_reqs FOR EACH ROW EXECUTE PROCEDURE mtg_reqs__check_insert();


--
-- Name: log_delete; Type: TRIGGER; Schema: flood; Owner: ndbadm
--

CREATE TRIGGER log_delete BEFORE DELETE ON mtg_reqs FOR EACH ROW EXECUTE PROCEDURE mtg_reqs__log_delete();


--
-- Name: log_update; Type: TRIGGER; Schema: flood; Owner: ndbadm
--

CREATE TRIGGER log_update BEFORE UPDATE ON mtg_reqs FOR EACH ROW EXECUTE PROCEDURE mtg_reqs__log_update();


--
-- Name: mtg_stop; Type: TRIGGER; Schema: flood; Owner: ndbadm
--

CREATE TRIGGER mtg_stop AFTER UPDATE ON state FOR EACH ROW EXECUTE PROCEDURE mtg_req__flood_over();


--
-- Name: mtg_stop; Type: TRIGGER; Schema: flood; Owner: ndbadm
--

CREATE TRIGGER mtg_stop BEFORE DELETE ON registry FOR EACH ROW EXECUTE PROCEDURE mtg_req__flood_deleted();


--
-- Name: propagate; Type: TRIGGER; Schema: flood; Owner: ndbadm
--

CREATE TRIGGER propagate AFTER INSERT OR DELETE OR UPDATE ON mtg_map FOR EACH ROW EXECUTE PROCEDURE mtg_map__propagate();


--
-- Name: propagate; Type: TRIGGER; Schema: flood; Owner: ndbadm
--

CREATE TRIGGER propagate AFTER INSERT OR DELETE OR UPDATE ON mtg_reqs FOR EACH ROW EXECUTE PROCEDURE mtg_reqs__propagate();


SET search_path = notify, pg_catalog;

--
-- Name: newly_complete_target; Type: TRIGGER; Schema: notify; Owner: ndbadm
--

CREATE TRIGGER newly_complete_target AFTER INSERT OR UPDATE ON targets FOR EACH ROW EXECUTE PROCEDURE update_complete_targets_tbl();


--
-- Name: TRIGGER newly_complete_target ON targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON TRIGGER newly_complete_target ON targets IS 'Insert a newly complete target to notify.complete_targets';


--
-- Name: newly_incomplete_target; Type: TRIGGER; Schema: notify; Owner: ndbadm
--

CREATE TRIGGER newly_incomplete_target BEFORE UPDATE ON targets FOR EACH ROW EXECUTE PROCEDURE update_complete_targets_tbl();


--
-- Name: TRIGGER newly_incomplete_target ON targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON TRIGGER newly_incomplete_target ON targets IS 'Remove a newly incomplete target from notify.complete_targets';


--
-- Name: purge_links; Type: TRIGGER; Schema: notify; Owner: ndbadm
--

CREATE TRIGGER purge_links AFTER DELETE ON type_links FOR EACH ROW EXECUTE PROCEDURE type_links__purge_links();


--
-- Name: purge_targets; Type: TRIGGER; Schema: notify; Owner: ndbadm
--

CREATE TRIGGER purge_targets BEFORE DELETE ON filter_templates FOR EACH ROW EXECUTE PROCEDURE filter_templates__purge_targets();


--
-- Name: purge_targets_and_subfilters; Type: TRIGGER; Schema: notify; Owner: ndbadm
--

CREATE TRIGGER purge_targets_and_subfilters BEFORE DELETE ON filters FOR EACH ROW EXECUTE PROCEDURE filters__purge_targets();


--
-- Name: update_generation; Type: TRIGGER; Schema: notify; Owner: ndbadm
--

CREATE TRIGGER update_generation BEFORE UPDATE ON filters FOR EACH ROW EXECUTE PROCEDURE filters__update_generation();


--
-- Name: TRIGGER update_generation ON filters; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON TRIGGER update_generation ON filters IS 'Increment `generation'' field (loops values within 0..32767 range)';


--
-- Name: update_modified; Type: TRIGGER; Schema: notify; Owner: ndbadm
--

CREATE TRIGGER update_modified BEFORE UPDATE ON filters FOR EACH ROW EXECUTE PROCEDURE filters__update_modified();


--
-- Name: TRIGGER update_modified ON filters; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON TRIGGER update_modified ON filters IS 'Update `modified'' field unless UPDATE specifies it';


SET search_path = nx, pg_catalog;

--
-- Name: rollover_request_id; Type: TRIGGER; Schema: nx; Owner: ndbadm
--

CREATE TRIGGER rollover_request_id BEFORE UPDATE ON map FOR EACH ROW EXECUTE PROCEDURE rollover_request_id();


--
-- Name: TRIGGER rollover_request_id ON map; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON TRIGGER rollover_request_id ON map IS 'Ensure request_id never gets so large as to cause `integer out of range''';


SET search_path = public, pg_catalog;

--
-- Name: check_caps; Type: TRIGGER; Schema: public; Owner: ndbadm
--

CREATE TRIGGER check_caps BEFORE INSERT OR UPDATE ON hosts FOR EACH ROW EXECUTE PROCEDURE hosts_check_caps();


--
-- Name: create_schema; Type: TRIGGER; Schema: public; Owner: ndbadm
--

CREATE TRIGGER create_schema AFTER INSERT ON hosts FOR EACH ROW EXECUTE PROCEDURE hosts_create_schema();


--
-- Name: drop_schema; Type: TRIGGER; Schema: public; Owner: ndbadm
--

CREATE TRIGGER drop_schema AFTER DELETE ON hosts FOR EACH ROW EXECUTE PROCEDURE hosts_drop_schema();


--
-- Name: group_max; Type: TRIGGER; Schema: public; Owner: ndbadm
--

CREATE TRIGGER group_max BEFORE INSERT OR UPDATE ON group_mapping FOR EACH ROW EXECUTE PROCEDURE enforce_sensor_grpmax();


--
-- Name: set_width; Type: TRIGGER; Schema: public; Owner: ndbadm
--

CREATE TRIGGER set_width BEFORE INSERT OR UPDATE ON data_tables FOR EACH ROW EXECUTE PROCEDURE datatab_set_width();


--
-- Name: stat_drop_data; Type: TRIGGER; Schema: public; Owner: ndbadm
--

CREATE TRIGGER stat_drop_data BEFORE DELETE ON data_tables FOR EACH ROW EXECUTE PROCEDURE stat_drop_data();


SET search_path = quarantine, pg_catalog;

--
-- Name: capture_duration_nonzero; Type: TRIGGER; Schema: quarantine; Owner: ndbadm
--

CREATE TRIGGER capture_duration_nonzero BEFORE INSERT OR UPDATE ON captures FOR EACH ROW EXECUTE PROCEDURE capture_duration_nonzero();


--
-- Name: set_source; Type: TRIGGER; Schema: quarantine; Owner: ndbadm
--

CREATE TRIGGER set_source BEFORE INSERT OR UPDATE ON samples FOR EACH ROW EXECUTE PROCEDURE samples__set_source();


SET search_path = report, pg_catalog;

--
-- Name: set_modified; Type: TRIGGER; Schema: report; Owner: ndbadm
--

CREATE TRIGGER set_modified BEFORE UPDATE ON list FOR EACH ROW EXECUTE PROCEDURE public.set_modified();


--
-- Name: TRIGGER set_modified ON list; Type: COMMENT; Schema: report; Owner: ndbadm
--

COMMENT ON TRIGGER set_modified ON list IS 'Sets report.list.modified to current time when an UPDATE does not change it';


SET search_path = smp, pg_catalog;

--
-- Name: aggregate; Type: TRIGGER; Schema: smp; Owner: ndbadm
--

CREATE TRIGGER aggregate AFTER INSERT OR DELETE OR UPDATE ON mtg_live FOR EACH ROW EXECUTE PROCEDURE mtg_live__aggregate();


--
-- Name: handle_deleted; Type: TRIGGER; Schema: smp; Owner: ndbadm
--

CREATE TRIGGER handle_deleted BEFORE UPDATE ON users FOR EACH ROW EXECUTE PROCEDURE users__handle_deleted();


--
-- Name: propagate; Type: TRIGGER; Schema: smp; Owner: ndbadm
--

CREATE TRIGGER propagate AFTER INSERT OR DELETE OR UPDATE ON mtg_reqs FOR EACH ROW EXECUTE PROCEDURE mtg_reqs__propagate();


--
-- Name: set_modified; Type: TRIGGER; Schema: smp; Owner: ndbadm
--

CREATE TRIGGER set_modified BEFORE UPDATE ON users FOR EACH ROW EXECUTE PROCEDURE public.set_modified();


--
-- Name: TRIGGER set_modified ON users; Type: COMMENT; Schema: smp; Owner: ndbadm
--

COMMENT ON TRIGGER set_modified ON users IS 'Sets smp.users.modified to current time when an UPDATE does not change it';


SET search_path = auth, pg_catalog;

--
-- Name: authorized_keys_uid_fkey; Type: FK CONSTRAINT; Schema: auth; Owner: postgres
--

ALTER TABLE ONLY authorized_keys
    ADD CONSTRAINT authorized_keys_uid_fkey FOREIGN KEY (uid) REFERENCES passwd(uid) ON DELETE CASCADE;


--
-- Name: CONSTRAINT authorized_keys_uid_fkey ON authorized_keys; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON CONSTRAINT authorized_keys_uid_fkey ON authorized_keys IS 'This user doesn''t exist';


--
-- Name: ipsec_host_id_fkey; Type: FK CONSTRAINT; Schema: auth; Owner: postgres
--

ALTER TABLE ONLY ipsec
    ADD CONSTRAINT ipsec_host_id_fkey FOREIGN KEY (host_id) REFERENCES public.hosts(host_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT ipsec_host_id_fkey ON ipsec; Type: COMMENT; Schema: auth; Owner: postgres
--

COMMENT ON CONSTRAINT ipsec_host_id_fkey ON ipsec IS 'This host doesn''t exist';


--
-- Name: passwd_mail_id_fkey; Type: FK CONSTRAINT; Schema: auth; Owner: postgres
--

ALTER TABLE ONLY passwd
    ADD CONSTRAINT passwd_mail_id_fkey FOREIGN KEY (mail_id) REFERENCES notify.complete_targets(target_id) ON DELETE SET NULL;



SET search_path = fast, pg_catalog;

--
-- Name: attrs_attr_type_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY attrs
    ADD CONSTRAINT attrs_attr_type_id_fkey FOREIGN KEY (attr_type_id) REFERENCES attr_types(attr_type_id) ON DELETE CASCADE;


--
-- Name: attrs_entity_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY attrs
    ADD CONSTRAINT attrs_entity_id_fkey FOREIGN KEY (entity_id) REFERENCES entities(entity_id) ON DELETE CASCADE;


--
-- Name: entity_data_entity_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY entity_data
    ADD CONSTRAINT entity_data_entity_id_fkey FOREIGN KEY (entity_id) REFERENCES entities(entity_id) ON DELETE CASCADE;


--
-- Name: entity_data_type_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY entity_data
    ADD CONSTRAINT entity_data_type_id_fkey FOREIGN KEY (type_id) REFERENCES types(type_id) ON DELETE CASCADE;


--
-- Name: entity_links_from_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY entity_links
    ADD CONSTRAINT entity_links_from_fkey FOREIGN KEY ("from") REFERENCES entities(entity_id) ON DELETE CASCADE;


--
-- Name: entity_links_to_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY entity_links
    ADD CONSTRAINT entity_links_to_fkey FOREIGN KEY ("to") REFERENCES entities(entity_id) ON DELETE CASCADE;


--
-- Name: entity_patterns_entity_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY entity_patterns
    ADD CONSTRAINT entity_patterns_entity_id_fkey FOREIGN KEY (entity_id) REFERENCES entities(entity_id) ON DELETE CASCADE;


--
-- Name: entity_patterns_pattern_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY entity_patterns
    ADD CONSTRAINT entity_patterns_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: pat_contents_pat_strip_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY pat_contents
    ADD CONSTRAINT pat_contents_pat_strip_id_fkey FOREIGN KEY (pat_strip_id) REFERENCES pat_strips(pat_strip_id) ON DELETE CASCADE;


--
-- Name: pat_contents_pattern_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY pat_contents
    ADD CONSTRAINT pat_contents_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: pat_endpoint_search_pat_strip_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY pat_endpoint_search
    ADD CONSTRAINT pat_endpoint_search_pat_strip_id_fkey FOREIGN KEY (pat_strip_id) REFERENCES pat_strips(pat_strip_id) ON DELETE CASCADE;


--
-- Name: pat_payload_search_pat_strip_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY pat_payload_search
    ADD CONSTRAINT pat_payload_search_pat_strip_id_fkey FOREIGN KEY (pat_strip_id) REFERENCES pat_strips(pat_strip_id) ON DELETE CASCADE;


--
-- Name: top_host_sets_entity_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY top_host_sets
    ADD CONSTRAINT top_host_sets_entity_id_fkey FOREIGN KEY (entity_id) REFERENCES entities(entity_id) ON DELETE CASCADE;


--
-- Name: top_host_sets_pattern_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY top_host_sets
    ADD CONSTRAINT top_host_sets_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: top_hosts_ths_id_fkey; Type: FK CONSTRAINT; Schema: fast; Owner: ndbadm
--

ALTER TABLE ONLY top_hosts
    ADD CONSTRAINT top_hosts_ths_id_fkey FOREIGN KEY (ths_id) REFERENCES top_host_sets(ths_id) ON DELETE CASCADE;


SET search_path = flood, pg_catalog;

--
-- Name: alerts_alert_type_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY alerts
    ADD CONSTRAINT alerts_alert_type_id_fkey FOREIGN KEY (alert_type_id) REFERENCES alert_types(alert_type_id) ON DELETE CASCADE;


--
-- Name: alerts_alerter_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY alerts
    ADD CONSTRAINT alerts_alerter_id_fkey FOREIGN KEY (alerter_id) REFERENCES alerters(alerter_id) ON DELETE CASCADE;


--
-- Name: alerts_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY alerts
    ADD CONSTRAINT alerts_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: alerts_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY alerts
    ADD CONSTRAINT alerts_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: cache_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY cache
    ADD CONSTRAINT cache_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: errors_subsystem_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY errors
    ADD CONSTRAINT errors_subsystem_id_fkey FOREIGN KEY (subsystem_id) REFERENCES public.subsystems(subsystem_id) ON DELETE CASCADE;


--
-- Name: graphs_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY graphs
    ADD CONSTRAINT graphs_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: graphs_stat_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY graphs
    ADD CONSTRAINT graphs_stat_id_fkey FOREIGN KEY (stat_id) REFERENCES public.statistics(stat_id) ON DELETE CASCADE;


--
-- Name: importance_filter_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE SET NULL;


--
-- Name: importance_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: importance_uid_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_uid_fkey FOREIGN KEY (uid) REFERENCES auth.passwd(uid) ON DELETE SET NULL;


--
-- Name: matches_filter_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY matches
    ADD CONSTRAINT matches_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE CASCADE;


--
-- Name: matches_match_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY matches
    ADD CONSTRAINT matches_match_id_fkey FOREIGN KEY (match_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: mtg_graphs_real_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_graphs_real
    ADD CONSTRAINT mtg_graphs_real_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: mtg_graphs_real_sg_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_graphs_real
    ADD CONSTRAINT mtg_graphs_real_sg_id_fkey FOREIGN KEY (sg_id) REFERENCES notify.targets(target_id) ON DELETE CASCADE;


--
-- Name: mtg_live_log_past_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: mtg_live_log_past_sg_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_sg_id_fkey FOREIGN KEY (sg_id) REFERENCES notify.targets(target_id) ON DELETE CASCADE;


--
-- Name: mtg_live_log_past_state_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_state_id_fkey FOREIGN KEY (state_id) REFERENCES mtg_states(state_id);


--
-- Name: mtg_live_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: mtg_live_sg_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_sg_id_fkey FOREIGN KEY (sg_id) REFERENCES notify.complete_targets(target_id);


--
-- Name: CONSTRAINT mtg_live_sg_id_fkey ON mtg_live; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON CONSTRAINT mtg_live_sg_id_fkey ON mtg_live IS 'Can''t remove entry or make incomplete because of ongoing SG mitigation';


--
-- Name: mtg_live_state_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_state_id_fkey FOREIGN KEY (state_id) REFERENCES mtg_states(state_id);


--
-- Name: mtg_map_host_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_map
    ADD CONSTRAINT mtg_map_host_id_fkey FOREIGN KEY (host_id) REFERENCES public.hosts(host_id) ON DELETE CASCADE;


--
-- Name: mtg_map_sg_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_map
    ADD CONSTRAINT mtg_map_sg_id_fkey FOREIGN KEY (sg_id) REFERENCES notify.complete_targets(target_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT mtg_map_sg_id_fkey ON mtg_map; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON CONSTRAINT mtg_map_sg_id_fkey ON mtg_map IS 'Can''t remove entry or make incomplete because of ongoing SG mitigation';


--
-- Name: mtg_reqs_filter_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_filter_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT mtg_reqs_log_past_filter_id_fkey ON mtg_reqs_log_past; Type: COMMENT; Schema: flood; Owner: ndbadm
--

COMMENT ON CONSTRAINT mtg_reqs_log_past_filter_id_fkey ON mtg_reqs_log_past IS 'Won''t remove; mitigation request made by the policy is active';


--
-- Name: mtg_reqs_log_past_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_orig_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_orig_pattern_id_fkey FOREIGN KEY (orig_pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_uid_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_uid_fkey FOREIGN KEY (uid) REFERENCES auth.passwd(uid) ON DELETE CASCADE;


--
-- Name: mtg_reqs_orig_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_orig_pattern_id_fkey FOREIGN KEY (orig_pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_uid_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_uid_fkey FOREIGN KEY (uid) REFERENCES auth.passwd(uid) ON DELETE CASCADE;


--
-- Name: mtg_sg_state_sg_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY mtg_sg_state
    ADD CONSTRAINT mtg_sg_state_sg_id_fkey FOREIGN KEY (sg_id) REFERENCES notify.complete_targets(target_id) ON DELETE CASCADE;


--
-- Name: pattern_entropy_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY pattern_entropy
    ADD CONSTRAINT pattern_entropy_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: pattern_entropy_pattern_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY pattern_entropy
    ADD CONSTRAINT pattern_entropy_pattern_id_fkey FOREIGN KEY (pattern_id) REFERENCES fast.patterns(pattern_id) ON DELETE CASCADE;


--
-- Name: registry_group_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY registry
    ADD CONSTRAINT registry_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.groups(group_id) ON DELETE CASCADE;


--
-- Name: registry_host_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY registry
    ADD CONSTRAINT registry_host_id_fkey FOREIGN KEY (host_id) REFERENCES public.hosts(host_id) ON DELETE CASCADE;


--
-- Name: registry_subsystem_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY registry
    ADD CONSTRAINT registry_subsystem_id_fkey FOREIGN KEY (subsystem_id) REFERENCES public.subsystems(subsystem_id) ON DELETE CASCADE;


--
-- Name: registry_type_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY registry
    ADD CONSTRAINT registry_type_id_fkey FOREIGN KEY (type_id) REFERENCES types(type_id) ON DELETE CASCADE;


--
-- Name: samples_alerts_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_alerts_id_fkey FOREIGN KEY (alerts_id) REFERENCES fast.entities(entity_id) ON DELETE CASCADE;


--
-- Name: samples_entropy_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_entropy_id_fkey FOREIGN KEY (entropy_id) REFERENCES fast.entities(entity_id) ON DELETE CASCADE;


--
-- Name: samples_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: samples_report_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_report_id_fkey FOREIGN KEY (report_id) REFERENCES fast.entities(entity_id) ON DELETE CASCADE;


--
-- Name: samples_sample_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_sample_id_fkey FOREIGN KEY (sample_id) REFERENCES fast.entities(entity_id) ON DELETE CASCADE;


--
-- Name: samples_top_hosts_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_top_hosts_id_fkey FOREIGN KEY (top_hosts_id) REFERENCES fast.entities(entity_id) ON DELETE CASCADE;


--
-- Name: state_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY state
    ADD CONSTRAINT state_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: stats_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY stats
    ADD CONSTRAINT stats_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: thresholds_group_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY thresholds
    ADD CONSTRAINT thresholds_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.groups(group_id) ON DELETE SET NULL;


--
-- Name: thresholds_host_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY thresholds
    ADD CONSTRAINT thresholds_host_id_fkey FOREIGN KEY (host_id) REFERENCES public.hosts(host_id) ON DELETE SET NULL;


--
-- Name: thresholds_stat_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY thresholds
    ADD CONSTRAINT thresholds_stat_id_fkey FOREIGN KEY (stat_id) REFERENCES public.statistics(stat_id) ON DELETE SET NULL;


--
-- Name: top_hosts_dst_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY top_hosts_dst
    ADD CONSTRAINT top_hosts_dst_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


--
-- Name: top_hosts_src_flood_id_fkey; Type: FK CONSTRAINT; Schema: flood; Owner: ndbadm
--

ALTER TABLE ONLY top_hosts_src
    ADD CONSTRAINT top_hosts_src_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES registry(flood_id) ON DELETE CASCADE;


SET search_path = notify, pg_catalog;

--
-- Name: complete_targets_target_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY complete_targets
    ADD CONSTRAINT complete_targets_target_id_fkey FOREIGN KEY (target_id) REFERENCES targets(target_id) ON DELETE CASCADE;


--
-- Name: data_type_operators_data_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY data_type_operators
    ADD CONSTRAINT data_type_operators_data_type_id_fkey FOREIGN KEY (data_type_id) REFERENCES data_types(data_type_id);


--
-- Name: data_type_operators_operator_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY data_type_operators
    ADD CONSTRAINT data_type_operators_operator_id_fkey FOREIGN KEY (operator_id) REFERENCES operators(operator_id);


--
-- Name: fields_data_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY fields
    ADD CONSTRAINT fields_data_type_id_fkey FOREIGN KEY (data_type_id) REFERENCES data_types(data_type_id);


--
-- Name: fields_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY fields
    ADD CONSTRAINT fields_type_id_fkey FOREIGN KEY (type_id) REFERENCES types(type_id) ON DELETE CASCADE;


--
-- Name: filter_parts_data_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filter_parts
    ADD CONSTRAINT filter_parts_data_type_id_fkey FOREIGN KEY (data_type_id, operator_id) REFERENCES data_type_operators(data_type_id, operator_id);


--
-- Name: CONSTRAINT filter_parts_data_type_id_fkey ON filter_parts; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_parts_data_type_id_fkey ON filter_parts IS 'Operator doesn''t exist';


--
-- Name: filter_parts_field_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filter_parts
    ADD CONSTRAINT filter_parts_field_id_fkey FOREIGN KEY (field_id, type_id, data_type_id) REFERENCES fields(field_id, type_id, data_type_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: CONSTRAINT filter_parts_field_id_fkey ON filter_parts; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_parts_field_id_fkey ON filter_parts IS 'Field doesn''t exist';


--
-- Name: filter_parts_filter_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filter_parts
    ADD CONSTRAINT filter_parts_filter_id_fkey FOREIGN KEY (filter_id, type_id) REFERENCES filters(filter_id, type_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT filter_parts_filter_id_fkey ON filter_parts; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_parts_filter_id_fkey ON filter_parts IS 'This policy doesn''t exist (was deleted)';


--
-- Name: filter_targets_filter_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filter_targets
    ADD CONSTRAINT filter_targets_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES filters(filter_id) ON DELETE CASCADE;


--
-- Name: filter_targets_target_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filter_targets
    ADD CONSTRAINT filter_targets_target_id_fkey FOREIGN KEY (target_id) REFERENCES complete_targets(target_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT filter_targets_target_id_fkey ON filter_targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_targets_target_id_fkey ON filter_targets IS 'Recipient doesn''t exist';


--
-- Name: filter_templates_filter_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filter_templates
    ADD CONSTRAINT filter_templates_filter_id_fkey FOREIGN KEY (filter_id, type_id) REFERENCES filters(filter_id, type_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT filter_templates_filter_id_fkey ON filter_templates; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_templates_filter_id_fkey ON filter_templates IS 'This policy doesn''t exist (was deleted)';


--
-- Name: filter_templates_template_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filter_templates
    ADD CONSTRAINT filter_templates_template_id_fkey FOREIGN KEY (template_id, target_type_id) REFERENCES templates(template_id, target_type_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT filter_templates_template_id_fkey ON filter_templates; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filter_templates_template_id_fkey ON filter_templates IS 'Template or/and recipient type doesn''t exist';


--
-- Name: filters_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY filters
    ADD CONSTRAINT filters_type_id_fkey FOREIGN KEY (type_id) REFERENCES types(type_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT filters_type_id_fkey ON filters; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT filters_type_id_fkey ON filters IS 'This policy type doesn''t exist';


--
-- Name: targets_target_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY targets
    ADD CONSTRAINT targets_target_type_id_fkey FOREIGN KEY (target_type_id) REFERENCES public.post_target_types(target_type_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT targets_target_type_id_fkey ON targets; Type: COMMENT; Schema: notify; Owner: ndbadm
--

COMMENT ON CONSTRAINT targets_target_type_id_fkey ON targets IS 'This recipient type doesn''t exist';


--
-- Name: templates_target_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_target_type_id_fkey FOREIGN KEY (target_type_id) REFERENCES public.post_target_types(target_type_id) ON DELETE CASCADE;


--
-- Name: templates_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_type_id_fkey FOREIGN KEY (type_id) REFERENCES types(type_id) ON DELETE CASCADE;


--
-- Name: type_links_to_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY type_links
    ADD CONSTRAINT type_links_to_fkey FOREIGN KEY ("to") REFERENCES types(type_id) ON DELETE CASCADE;


--
-- Name: type_links_type_id_fkey; Type: FK CONSTRAINT; Schema: notify; Owner: ndbadm
--

ALTER TABLE ONLY type_links
    ADD CONSTRAINT type_links_type_id_fkey FOREIGN KEY (type_id) REFERENCES types(type_id) ON DELETE CASCADE;


SET search_path = nx, pg_catalog;

--
-- Name: map_hostlist_id_fkey; Type: FK CONSTRAINT; Schema: nx; Owner: ndbadm
--

ALTER TABLE ONLY map
    ADD CONSTRAINT map_hostlist_id_fkey FOREIGN KEY (hostlist_id) REFERENCES notify.complete_targets(target_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT map_hostlist_id_fkey ON map; Type: COMMENT; Schema: nx; Owner: ndbadm
--

COMMENT ON CONSTRAINT map_hostlist_id_fkey ON map IS 'New IPs were added to hostlist, try again';


SET search_path = public, pg_catalog;

--
-- Name: cluster_config_cluster_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY cluster_config
    ADD CONSTRAINT cluster_config_cluster_id_fkey FOREIGN KEY (cluster_id) REFERENCES hosts(host_id) ON DELETE CASCADE;


--
-- Name: data_tables_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY data_tables
    ADD CONSTRAINT data_tables_group_id_fkey FOREIGN KEY (group_id) REFERENCES groups(group_id) ON DELETE CASCADE;


--
-- Name: data_tables_host_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY data_tables
    ADD CONSTRAINT data_tables_host_id_fkey FOREIGN KEY (host_id) REFERENCES hosts(host_id) ON DELETE CASCADE;


--
-- Name: data_tables_struct_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY data_tables
    ADD CONSTRAINT data_tables_struct_id_fkey FOREIGN KEY (struct_id) REFERENCES structs(struct_id);


--
-- Name: group_config_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY group_config
    ADD CONSTRAINT group_config_group_id_fkey FOREIGN KEY (group_id) REFERENCES groups(group_id);


--
-- Name: CONSTRAINT group_config_group_id_fkey ON group_config; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT group_config_group_id_fkey ON group_config IS 'This group doesn''t exist';


--
-- Name: group_mapping_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY group_mapping
    ADD CONSTRAINT group_mapping_group_id_fkey FOREIGN KEY (group_id) REFERENCES groups(group_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT group_mapping_group_id_fkey ON group_mapping; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT group_mapping_group_id_fkey ON group_mapping IS 'This group doesn''t exist';


--
-- Name: group_mapping_host_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY group_mapping
    ADD CONSTRAINT group_mapping_host_id_fkey FOREIGN KEY (host_id) REFERENCES hosts(host_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT group_mapping_host_id_fkey ON group_mapping; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT group_mapping_host_id_fkey ON group_mapping IS 'This host doesn''t exist';


--
-- Name: permissions_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY permissions
    ADD CONSTRAINT permissions_group_id_fkey FOREIGN KEY (group_id) REFERENCES groups(group_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT permissions_group_id_fkey ON permissions; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT permissions_group_id_fkey ON permissions IS 'This group doesn''t exist';


--
-- Name: permissions_host_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY permissions
    ADD CONSTRAINT permissions_host_id_fkey FOREIGN KEY (host_id) REFERENCES hosts(host_id) ON DELETE CASCADE;


--
-- Name: CONSTRAINT permissions_host_id_fkey ON permissions; Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON CONSTRAINT permissions_host_id_fkey ON permissions IS 'This host doesn''t exist';


--
-- Name: sensor_clusters_cluster_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY sensor_clusters
    ADD CONSTRAINT sensor_clusters_cluster_id_fkey FOREIGN KEY (cluster_id) REFERENCES hosts(host_id);


--
-- Name: sensor_clusters_member_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY sensor_clusters
    ADD CONSTRAINT sensor_clusters_member_id_fkey FOREIGN KEY (member_id) REFERENCES hosts(host_id);


--
-- Name: statistics_struct_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY statistics
    ADD CONSTRAINT statistics_struct_id_fkey FOREIGN KEY (struct_id) REFERENCES structs(struct_id) ON DELETE CASCADE;


--
-- Name: structs_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY structs
    ADD CONSTRAINT structs_type_id_fkey FOREIGN KEY (type_id) REFERENCES struct_types(type_id) ON DELETE CASCADE;


--
-- Name: subsystems_host_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ndbadm
--

ALTER TABLE ONLY subsystems
    ADD CONSTRAINT subsystems_host_id_fkey FOREIGN KEY (host_id) REFERENCES hosts(host_id) ON DELETE CASCADE;


SET search_path = quarantine, pg_catalog;

--
-- Name: captures_fast_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY captures
    ADD CONSTRAINT captures_fast_id_fkey FOREIGN KEY (fast_id) REFERENCES fast.entities(entity_id) ON DELETE CASCADE;


--
-- Name: captures_group_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY captures
    ADD CONSTRAINT captures_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.groups(group_id) ON DELETE CASCADE;


--
-- Name: captures_subsystem_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY captures
    ADD CONSTRAINT captures_subsystem_id_fkey FOREIGN KEY (subsystem_id) REFERENCES public.subsystems(subsystem_id) ON DELETE CASCADE;


--
-- Name: captures_user_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY captures
    ADD CONSTRAINT captures_user_id_fkey FOREIGN KEY (user_id) REFERENCES smp.users(user_id) ON DELETE SET NULL;


--
-- Name: events_capture_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY events
    ADD CONSTRAINT events_capture_id_fkey FOREIGN KEY (capture_id) REFERENCES captures(capture_id) ON DELETE CASCADE;


--
-- Name: events_type_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY events
    ADD CONSTRAINT events_type_id_fkey FOREIGN KEY (type_id) REFERENCES event_types(type_id) ON DELETE CASCADE;


--
-- Name: importance_capture_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_capture_id_fkey FOREIGN KEY (capture_id) REFERENCES captures(capture_id) ON DELETE CASCADE;


--
-- Name: importance_filter_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE SET NULL;


--
-- Name: importance_uid_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY importance
    ADD CONSTRAINT importance_uid_fkey FOREIGN KEY (uid) REFERENCES auth.passwd(uid) ON DELETE SET NULL;


--
-- Name: matches_filter_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY matches
    ADD CONSTRAINT matches_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE CASCADE;


--
-- Name: matches_match_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY matches
    ADD CONSTRAINT matches_match_id_fkey FOREIGN KEY (match_id) REFERENCES captures(capture_id) ON DELETE CASCADE;


--
-- Name: samples_capture_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_capture_id_fkey FOREIGN KEY (capture_id) REFERENCES captures(capture_id) ON DELETE CASCADE;


--
-- Name: samples_capture_id_fkey1; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_capture_id_fkey1 FOREIGN KEY (capture_id, addr) REFERENCES captures(capture_id, addr) ON DELETE CASCADE;


--
-- Name: samples_sample_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_sample_id_fkey FOREIGN KEY (sample_id) REFERENCES fast.entities(entity_id) ON DELETE CASCADE;


--
-- Name: samples_user_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY samples
    ADD CONSTRAINT samples_user_id_fkey FOREIGN KEY (user_id) REFERENCES smp.users(user_id) ON DELETE SET NULL;


--
-- Name: sources_group_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY sources
    ADD CONSTRAINT sources_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.groups(group_id);


--
-- Name: sources_subsystem_id_fkey; Type: FK CONSTRAINT; Schema: quarantine; Owner: ndbadm
--

ALTER TABLE ONLY sources
    ADD CONSTRAINT sources_subsystem_id_fkey FOREIGN KEY (subsystem_id) REFERENCES public.subsystems(subsystem_id);


SET search_path = report, pg_catalog;

--
-- Name: list_uid_fkey; Type: FK CONSTRAINT; Schema: report; Owner: ndbadm
--

ALTER TABLE ONLY list
    ADD CONSTRAINT list_uid_fkey FOREIGN KEY (uid) REFERENCES auth.passwd(uid) ON DELETE CASCADE;


--
-- Name: mail_mail_id_fkey; Type: FK CONSTRAINT; Schema: report; Owner: ndbadm
--

ALTER TABLE ONLY mail
    ADD CONSTRAINT mail_mail_id_fkey FOREIGN KEY (mail_id) REFERENCES notify.complete_targets(target_id) ON DELETE CASCADE;


--
-- Name: mail_report_id_fkey; Type: FK CONSTRAINT; Schema: report; Owner: ndbadm
--

ALTER TABLE ONLY mail
    ADD CONSTRAINT mail_report_id_fkey FOREIGN KEY (report_id) REFERENCES list(report_id) ON DELETE CASCADE;


--
-- Name: views_report_id_fkey; Type: FK CONSTRAINT; Schema: report; Owner: ndbadm
--

ALTER TABLE ONLY views
    ADD CONSTRAINT views_report_id_fkey FOREIGN KEY (report_id) REFERENCES list(report_id) ON DELETE CASCADE;


SET search_path = smp, pg_catalog;

--
-- Name: map_host_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY map
    ADD CONSTRAINT map_host_id_fkey FOREIGN KEY (host_id) REFERENCES public.hosts(host_id) ON DELETE CASCADE;


--
-- Name: map_smp_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY map
    ADD CONSTRAINT map_smp_id_fkey FOREIGN KEY (smp_id) REFERENCES notify.targets(target_id) ON DELETE CASCADE;


--
-- Name: mtg_live_action_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_action_fkey FOREIGN KEY (action) REFERENCES notify.complete_targets(target_id);


--
-- Name: mtg_live_log_past_action_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_action_fkey FOREIGN KEY (action) REFERENCES notify.targets(target_id) ON DELETE CASCADE;


--
-- Name: mtg_live_log_past_smp_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_smp_id_fkey FOREIGN KEY (smp_id) REFERENCES notify.targets(target_id) ON DELETE CASCADE;


--
-- Name: mtg_live_log_past_state_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_state_id_fkey FOREIGN KEY (state_id) REFERENCES mtg_states(state_id);


--
-- Name: mtg_live_log_past_user_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live_log_past
    ADD CONSTRAINT mtg_live_log_past_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id) ON DELETE CASCADE;


--
-- Name: mtg_live_smp_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_smp_id_fkey FOREIGN KEY (smp_id) REFERENCES notify.complete_targets(target_id);


--
-- Name: mtg_live_state_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_state_id_fkey FOREIGN KEY (state_id) REFERENCES mtg_states(state_id);


--
-- Name: mtg_live_user_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_live
    ADD CONSTRAINT mtg_live_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: mtg_reqs_action_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_action_fkey FOREIGN KEY (action) REFERENCES notify.complete_targets(target_id);


--
-- Name: mtg_reqs_filter_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_action_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_action_fkey FOREIGN KEY (action) REFERENCES notify.complete_targets(target_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_filter_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_filter_id_fkey FOREIGN KEY (filter_id) REFERENCES notify.filters(filter_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_uid_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_uid_fkey FOREIGN KEY (uid) REFERENCES auth.passwd(uid) ON DELETE CASCADE;


--
-- Name: mtg_reqs_log_past_user_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs_log_past
    ADD CONSTRAINT mtg_reqs_log_past_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id) ON DELETE CASCADE;


--
-- Name: mtg_reqs_uid_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_uid_fkey FOREIGN KEY (uid) REFERENCES auth.passwd(uid) ON DELETE CASCADE;


--
-- Name: mtg_reqs_user_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY mtg_reqs
    ADD CONSTRAINT mtg_reqs_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id) ON DELETE CASCADE;


--
-- Name: users_state_id_fkey; Type: FK CONSTRAINT; Schema: smp; Owner: ndbadm
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_state_id_fkey FOREIGN KEY (state_id) REFERENCES mtg_states(state_id);


--
-- Name: auth; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA auth FROM PUBLIC;
REVOKE ALL ON SCHEMA auth FROM postgres;
GRANT ALL ON SCHEMA auth TO postgres;
GRANT USAGE ON SCHEMA auth TO ndb_readers;
GRANT USAGE ON SCHEMA auth TO ndb_writers;


--
-- Name: fast; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA fast FROM PUBLIC;
REVOKE ALL ON SCHEMA fast FROM ndbadm;
GRANT ALL ON SCHEMA fast TO ndbadm;
GRANT USAGE ON SCHEMA fast TO ndb_readers;
GRANT USAGE ON SCHEMA fast TO ndb_writers;


--
-- Name: fgen; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA fgen FROM PUBLIC;
REVOKE ALL ON SCHEMA fgen FROM ndbadm;
GRANT ALL ON SCHEMA fgen TO ndbadm;
GRANT USAGE ON SCHEMA fgen TO ndb_readers;
GRANT USAGE ON SCHEMA fgen TO ndb_writers;


--
-- Name: flood; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA flood FROM PUBLIC;
REVOKE ALL ON SCHEMA flood FROM ndbadm;
GRANT ALL ON SCHEMA flood TO ndbadm;
GRANT USAGE ON SCHEMA flood TO ndb_readers;
GRANT USAGE ON SCHEMA flood TO ndb_writers;
GRANT USAGE, SELECT ON ALL SEQUENCES IN SCHEMA flood to nms;


--
-- Name: h1; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA h1 FROM PUBLIC;
REVOKE ALL ON SCHEMA h1 FROM ndbadm;
GRANT ALL ON SCHEMA h1 TO ndbadm;
GRANT USAGE ON SCHEMA h1 TO ndb_readers;
GRANT ALL ON SCHEMA h1 TO ndb_writers;


--
-- Name: notify; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA notify FROM PUBLIC;
REVOKE ALL ON SCHEMA notify FROM ndbadm;
GRANT ALL ON SCHEMA notify TO ndbadm;
GRANT USAGE ON SCHEMA notify TO ndb_readers;
GRANT USAGE ON SCHEMA notify TO ndb_writers;


--
-- Name: nx; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA nx FROM PUBLIC;
REVOKE ALL ON SCHEMA nx FROM ndbadm;
GRANT ALL ON SCHEMA nx TO ndbadm;
GRANT USAGE ON SCHEMA nx TO ndb_readers;
GRANT USAGE ON SCHEMA nx TO ndb_writers;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO ndb_writers;
GRANT USAGE ON SCHEMA public TO ndb_readers;


--
-- Name: purge; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA purge FROM PUBLIC;
REVOKE ALL ON SCHEMA purge FROM ndbadm;
GRANT ALL ON SCHEMA purge TO ndbadm;
GRANT USAGE ON SCHEMA purge TO ndb_readers;
GRANT USAGE ON SCHEMA purge TO ndb_writers;
GRANT USAGE, SELECT ON ALL SEQUENCES IN SCHEMA purge to nms;


--
-- Name: quarantine; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA quarantine FROM PUBLIC;
REVOKE ALL ON SCHEMA quarantine FROM ndbadm;
GRANT ALL ON SCHEMA quarantine TO ndbadm;
GRANT USAGE ON SCHEMA quarantine TO ndb_readers;
GRANT USAGE ON SCHEMA quarantine TO ndb_writers;


--
-- Name: report; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA report FROM PUBLIC;
REVOKE ALL ON SCHEMA report FROM ndbadm;
GRANT ALL ON SCHEMA report TO ndbadm;
GRANT USAGE ON SCHEMA report TO ndb_readers;
GRANT USAGE ON SCHEMA report TO ndb_writers;


--
-- Name: smp; Type: ACL; Schema: -; Owner: ndbadm
--

REVOKE ALL ON SCHEMA smp FROM PUBLIC;
REVOKE ALL ON SCHEMA smp FROM ndbadm;
GRANT ALL ON SCHEMA smp TO ndbadm;
GRANT USAGE ON SCHEMA smp TO ndb_readers;
GRANT USAGE ON SCHEMA smp TO ndb_writers;


SET search_path = fast, pg_catalog;

--
-- Name: attr_type_id(public.item_name); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION attr_type_id(typename public.item_name) FROM PUBLIC;
REVOKE ALL ON FUNCTION attr_type_id(typename public.item_name) FROM ndbadm;
GRANT ALL ON FUNCTION attr_type_id(typename public.item_name) TO ndbadm;
GRANT ALL ON FUNCTION attr_type_id(typename public.item_name) TO PUBLIC;
GRANT ALL ON FUNCTION attr_type_id(typename public.item_name) TO ndb_readers;
GRANT ALL ON FUNCTION attr_type_id(typename public.item_name) TO ndb_writers;


--
-- Name: entity__attr_set(integer, integer, text); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) FROM ndbadm;
GRANT ALL ON FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) TO ndbadm;
GRANT ALL ON FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) TO PUBLIC;
GRANT ALL ON FUNCTION entity__attr_set(entityid integer, attrtypeid integer, attrvalue text) TO ndb_writers;


--
-- Name: entity__body_set(integer, bytea); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__body_set(entityid integer, bodydata bytea) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__body_set(entityid integer, bodydata bytea) FROM ndbadm;
GRANT ALL ON FUNCTION entity__body_set(entityid integer, bodydata bytea) TO ndbadm;
GRANT ALL ON FUNCTION entity__body_set(entityid integer, bodydata bytea) TO PUBLIC;
GRANT ALL ON FUNCTION entity__body_set(entityid integer, bodydata bytea) TO ndb_writers;


--
-- Name: entity__children_set(integer, integer[]); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__children_set(entityid integer, children integer[]) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__children_set(entityid integer, children integer[]) FROM ndbadm;
GRANT ALL ON FUNCTION entity__children_set(entityid integer, children integer[]) TO ndbadm;
GRANT ALL ON FUNCTION entity__children_set(entityid integer, children integer[]) TO PUBLIC;
GRANT ALL ON FUNCTION entity__children_set(entityid integer, children integer[]) TO ndb_writers;


--
-- Name: entity__error_set(integer, text); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__error_set(entityid integer, errormessage text) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__error_set(entityid integer, errormessage text) FROM ndbadm;
GRANT ALL ON FUNCTION entity__error_set(entityid integer, errormessage text) TO ndbadm;
GRANT ALL ON FUNCTION entity__error_set(entityid integer, errormessage text) TO PUBLIC;
GRANT ALL ON FUNCTION entity__error_set(entityid integer, errormessage text) TO ndb_writers;


--
-- Name: entity__finalise(integer); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__finalise(entityid integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__finalise(entityid integer) FROM ndbadm;
GRANT ALL ON FUNCTION entity__finalise(entityid integer) TO ndbadm;
GRANT ALL ON FUNCTION entity__finalise(entityid integer) TO PUBLIC;
GRANT ALL ON FUNCTION entity__finalise(entityid integer) TO ndb_writers;


--
-- Name: entity__new(); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__new() FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__new() FROM ndbadm;
GRANT ALL ON FUNCTION entity__new() TO ndbadm;
GRANT ALL ON FUNCTION entity__new() TO PUBLIC;
GRANT ALL ON FUNCTION entity__new() TO ndb_writers;


--
-- Name: entity__new(public.item_name); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__new(typename public.item_name) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__new(typename public.item_name) FROM ndbadm;
GRANT ALL ON FUNCTION entity__new(typename public.item_name) TO ndbadm;
GRANT ALL ON FUNCTION entity__new(typename public.item_name) TO PUBLIC;
GRANT ALL ON FUNCTION entity__new(typename public.item_name) TO ndb_writers;


--
-- Name: entity__parents_set(integer, integer[]); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__parents_set(entityid integer, parents integer[]) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__parents_set(entityid integer, parents integer[]) FROM ndbadm;
GRANT ALL ON FUNCTION entity__parents_set(entityid integer, parents integer[]) TO ndbadm;
GRANT ALL ON FUNCTION entity__parents_set(entityid integer, parents integer[]) TO PUBLIC;
GRANT ALL ON FUNCTION entity__parents_set(entityid integer, parents integer[]) TO ndb_writers;


--
-- Name: entity__type_id_set(integer, integer); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION entity__type_id_set(entityid integer, typeid integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION entity__type_id_set(entityid integer, typeid integer) FROM ndbadm;
GRANT ALL ON FUNCTION entity__type_id_set(entityid integer, typeid integer) TO ndbadm;
GRANT ALL ON FUNCTION entity__type_id_set(entityid integer, typeid integer) TO PUBLIC;
GRANT ALL ON FUNCTION entity__type_id_set(entityid integer, typeid integer) TO ndb_writers;


--
-- Name: entity_data; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE entity_data FROM PUBLIC;
REVOKE ALL ON TABLE entity_data FROM ndbadm;
GRANT ALL ON TABLE entity_data TO ndbadm;
GRANT SELECT ON TABLE entity_data TO ndb_readers;
-- original GRANT SELECT ON TABLE entity_data TO ndb_writers;
GRANT ALL ON TABLE entity_data TO ndb_writers;

--
-- Name: pat_strip__register(integer, smallint[], bytea); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) FROM PUBLIC;
REVOKE ALL ON FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) FROM ndbadm;
GRANT ALL ON FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) TO ndbadm;
GRANT ALL ON FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) TO PUBLIC;
GRANT ALL ON FUNCTION pat_strip__register(striplayer integer, stripoffsets smallint[], stripvalues bytea) TO ndb_writers;


SET search_path = fast, pg_catalog;

--
-- Name: pat_strips; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE pat_strips FROM PUBLIC;
REVOKE ALL ON TABLE pat_strips FROM ndbadm;
GRANT ALL ON TABLE pat_strips TO ndbadm;
GRANT SELECT ON TABLE pat_strips TO ndb_readers;
GRANT SELECT ON TABLE pat_strips TO ndb_writers;


--
-- Name: top_hosts(integer, integer); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION top_hosts(_flood_id integer, _pattern_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION top_hosts(_flood_id integer, _pattern_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION top_hosts(_flood_id integer, _pattern_id integer) TO ndbadm;
GRANT ALL ON FUNCTION top_hosts(_flood_id integer, _pattern_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION top_hosts(_flood_id integer, _pattern_id integer) TO ndb_writers;


--
-- Name: types; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE types FROM PUBLIC;
REVOKE ALL ON TABLE types FROM ndbadm;
GRANT ALL ON TABLE types TO ndbadm;
GRANT SELECT ON TABLE types TO ndb_readers;
GRANT SELECT ON TABLE types TO ndb_writers;


--
-- Name: type__get_by_name(public.item_name); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type__get_by_name(typename public.item_name) FROM PUBLIC;
REVOKE ALL ON FUNCTION type__get_by_name(typename public.item_name) FROM ndbadm;
GRANT ALL ON FUNCTION type__get_by_name(typename public.item_name) TO ndbadm;
GRANT ALL ON FUNCTION type__get_by_name(typename public.item_name) TO PUBLIC;
GRANT ALL ON FUNCTION type__get_by_name(typename public.item_name) TO ndb_readers;
GRANT ALL ON FUNCTION type__get_by_name(typename public.item_name) TO ndb_writers;


--
-- Name: type_id(public.item_name); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_id(typename public.item_name) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_id(typename public.item_name) FROM ndbadm;
GRANT ALL ON FUNCTION type_id(typename public.item_name) TO ndbadm;
GRANT ALL ON FUNCTION type_id(typename public.item_name) TO PUBLIC;
GRANT ALL ON FUNCTION type_id(typename public.item_name) TO ndb_readers;
GRANT ALL ON FUNCTION type_id(typename public.item_name) TO ndb_writers;


--
-- Name: update_flood_modified(); Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON FUNCTION update_flood_modified() FROM PUBLIC;
REVOKE ALL ON FUNCTION update_flood_modified() FROM ndbadm;
GRANT ALL ON FUNCTION update_flood_modified() TO ndbadm;


SET search_path = fgen, pg_catalog;

--
-- Name: get_rule_text_real(text, integer, integer); Type: ACL; Schema: fgen; Owner: ndbadm
--
REVOKE ALL ON FUNCTION get_rule_text_real(text, integer, integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION get_rule_text_real(text, integer, integer) FROM ndbadm;
GRANT ALL ON FUNCTION get_rule_text_real(text, integer, integer) TO ndbadm;

SET search_path = flood, pg_catalog;

--
-- Name: aggregate_alerts(integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION aggregate_alerts(flood_id_in integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION aggregate_alerts(flood_id_in integer) FROM ndbadm;
GRANT ALL ON FUNCTION aggregate_alerts(flood_id_in integer) TO ndbadm;
GRANT ALL ON FUNCTION aggregate_alerts(flood_id_in integer) TO nms;


--
-- Name: automatic_importance(integer, integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION automatic_importance(flood_id integer, importance integer, filter_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION automatic_importance(flood_id integer, importance integer, filter_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION automatic_importance(flood_id integer, importance integer, filter_id integer) TO ndbadm;
GRANT ALL ON FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer) TO nms;

--
-- Name: cleanup(integer, text); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION cleanup(subsystem_id integer, details text) FROM PUBLIC;
REVOKE ALL ON FUNCTION cleanup(subsystem_id integer, details text) FROM ndbadm;
GRANT ALL ON FUNCTION cleanup(subsystem_id integer, details text) TO ndbadm;
GRANT ALL ON FUNCTION cleanup(subsystem_id integer, details text) TO ndb_writers;


--
-- Name: duration(timestamp with time zone, timestamp with time zone, timestamp with time zone); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) FROM PUBLIC;
REVOKE ALL ON FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) FROM ndbadm;
GRANT ALL ON FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) TO ndbadm;
GRANT ALL ON FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) TO ndb_readers;
GRANT ALL ON FUNCTION duration(start timestamp with time zone, stop timestamp with time zone, modified timestamp with time zone) TO ndb_writers;


--
-- Name: error_close(integer, timestamp with time zone); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION error_close(error_id integer, stop timestamp with time zone) FROM PUBLIC;
REVOKE ALL ON FUNCTION error_close(error_id integer, stop timestamp with time zone) FROM ndbadm;
GRANT ALL ON FUNCTION error_close(error_id integer, stop timestamp with time zone) TO ndbadm;
GRANT ALL ON FUNCTION error_close(error_id integer, stop timestamp with time zone) TO ndb_writers;


--
-- Name: error_open(integer, timestamp with time zone, text, text); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text) FROM PUBLIC;
REVOKE ALL ON FUNCTION error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text) FROM ndbadm;
GRANT ALL ON FUNCTION error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text) TO ndbadm;
GRANT ALL ON FUNCTION error_open(subsystem_id integer, start timestamp with time zone, descriptor text, details text) TO ndb_writers;


--
-- Name: errors_cleanup(integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION errors_cleanup(subsystem_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION errors_cleanup(subsystem_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION errors_cleanup(subsystem_id integer) TO ndbadm;
GRANT ALL ON FUNCTION errors_cleanup(subsystem_id integer) TO ndb_writers;


--
-- Name: exists_p(integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION exists_p(flood_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION exists_p(flood_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION exists_p(flood_id integer) TO ndbadm;
GRANT ALL ON FUNCTION exists_p(flood_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION exists_p(flood_id integer) TO ndb_writers;


--
-- Name: ext_rate(bigint, bigint, real); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION ext_rate(observed bigint, expected bigint, duration real) FROM PUBLIC;
REVOKE ALL ON FUNCTION ext_rate(observed bigint, expected bigint, duration real) FROM ndbadm;
GRANT ALL ON FUNCTION ext_rate(observed bigint, expected bigint, duration real) TO ndbadm;
GRANT ALL ON FUNCTION ext_rate(observed bigint, expected bigint, duration real) TO ndb_readers;
GRANT ALL ON FUNCTION ext_rate(observed bigint, expected bigint, duration real) TO ndb_writers;


--
-- Name: ext_rel(bigint, bigint); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION ext_rel(observed bigint, expected bigint) FROM PUBLIC;
REVOKE ALL ON FUNCTION ext_rel(observed bigint, expected bigint) FROM ndbadm;
GRANT ALL ON FUNCTION ext_rel(observed bigint, expected bigint) TO ndbadm;
GRANT ALL ON FUNCTION ext_rel(observed bigint, expected bigint) TO ndb_readers;
GRANT ALL ON FUNCTION ext_rel(observed bigint, expected bigint) TO ndb_writers;


--
-- Name: flood_has_pattern_p(integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer) TO ndbadm;
GRANT ALL ON FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION flood_has_pattern_p(_flood_id integer, _pattern_id integer) TO ndb_writers;


--
-- Name: flood_has_sample_p(integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer) TO ndbadm;
GRANT ALL ON FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION flood_has_sample_p(_flood_id integer, _sample_id integer) TO ndb_writers;


--
-- Name: get_graph(integer, text, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value_out real) FROM PUBLIC;
REVOKE ALL ON FUNCTION get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value_out real) FROM ndbadm;
GRANT ALL ON FUNCTION get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value_out real) TO ndbadm;
GRANT ALL ON FUNCTION get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value_out real) TO ndb_readers;
GRANT ALL ON FUNCTION get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value_out real) TO ndb_writers;


--
-- Name: manual_importance(integer, integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION manual_importance(flood_id integer, importance integer, uid integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION manual_importance(flood_id integer, importance integer, uid integer) FROM ndbadm;
GRANT ALL ON FUNCTION manual_importance(flood_id integer, importance integer, uid integer) TO ndbadm;
GRANT ALL ON FUNCTION manual_importance(flood_id integer, importance integer, uid integer) TO nms;


--
-- Name: mtg_req_manual_block(integer, integer, integer, mtg_req_action, timestamp with time zone, boolean); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) FROM PUBLIC;
REVOKE ALL ON FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) FROM ndbadm;
GRANT ALL ON FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) TO ndbadm;
GRANT ALL ON FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) TO PUBLIC;
GRANT ALL ON FUNCTION mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) TO nms;



--
-- Name: mtg_req_manual_unblock(integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION mtg_req_manual_unblock(_flood_id integer, _uid integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION mtg_req_manual_unblock(_flood_id integer, _uid integer) FROM ndbadm;
GRANT ALL ON FUNCTION mtg_req_manual_unblock(_flood_id integer, _uid integer) TO ndbadm;
GRANT ALL ON FUNCTION mtg_req_manual_unblock(_flood_id integer, _uid integer) TO nms;

--
-- Name: mtg_states; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_states FROM PUBLIC;
REVOKE ALL ON TABLE mtg_states FROM ndbadm;
GRANT ALL ON TABLE mtg_states TO ndbadm;
GRANT SELECT ON TABLE mtg_states TO ndb_readers;
GRANT SELECT ON TABLE mtg_states TO ndb_writers;


--
-- Name: open(integer, integer, integer, integer, timestamp with time zone); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone) FROM PUBLIC;
REVOKE ALL ON FUNCTION open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone) FROM ndbadm;
GRANT ALL ON FUNCTION open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone) TO ndbadm;
GRANT ALL ON FUNCTION open(subsystem integer, host integer, "group" integer, type integer, start_at timestamp with time zone) TO ndb_writers;


--
-- Name: pattern_attack_type(integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) TO ndb_writers;


--
-- Name: pattern_hosts(integer, integer, "char"); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char") FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char") FROM ndbadm;
GRANT ALL ON FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char") TO ndbadm;
GRANT ALL ON FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char") TO ndb_readers;
GRANT ALL ON FUNCTION pattern_hosts(flood_id integer, pattern_id integer, side "char") TO ndb_writers;


--
-- Name: pattern_ip_packets(integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_ip_packets(flood_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndb_writers;


--
-- Name: pattern_ip_packets(integer, integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_ip_packets(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndb_writers;


--
-- Name: pattern_ip_packets_real(integer, integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_ip_packets_real(flood_id integer, sample_id integer, pattern_id integer, OUT side "char", OUT ip inet, OUT pkts integer) TO ndb_writers;


--
-- Name: pattern_packets(integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_packets(flood_id integer, pattern_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_packets(flood_id integer, pattern_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_packets(flood_id integer, pattern_id integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_packets(flood_id integer, pattern_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_packets(flood_id integer, pattern_id integer) TO ndb_writers;


--
-- Name: pattern_packets(integer, integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_packets(flood_id integer, sample_id integer, pattern_id integer) TO ndb_writers;


--
-- Name: pattern_packets_real(integer, integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_packets_real(flood_id integer, sample_id integer, pattern_id integer) TO ndb_writers;


--
-- Name: pattern_prevalent_hosts(integer, integer, "char", boolean); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO ndb_writers;


--
-- Name: pattern_prevalent_hosts(integer, integer, integer, "char", boolean); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_prevalent_hosts(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO ndb_writers;


--
-- Name: pattern_prevalent_hosts_real(integer, integer, integer, "char", boolean); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO ndbadm;
GRANT ALL ON FUNCTION pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO nms; 


--
-- Name: pattern_quality_accum(pattern_quality_state, real, real); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_quality_accum(state pattern_quality_state, matches real, deviation real) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_quality_accum(state pattern_quality_state, matches real, deviation real) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_quality_accum(state pattern_quality_state, matches real, deviation real) TO ndbadm;


--
-- Name: pattern_quality_final(pattern_quality_state); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_quality_final(state pattern_quality_state) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_quality_final(state pattern_quality_state) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_quality_final(state pattern_quality_state) TO ndbadm;


--
-- Name: patterns(integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) FROM ndbadm;
GRANT ALL ON FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO ndbadm;
GRANT ALL ON FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO ndb_readers;
GRANT ALL ON FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO ndb_writers;
GRANT ALL ON FUNCTION patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO nms;


--
-- Name: sample_has_pattern_p(integer, integer); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer) TO ndbadm;
GRANT ALL ON FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION sample_has_pattern_p(_sample_id integer, _pattern_id integer) TO ndb_writers;


--
-- Name: type_register(text, text); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_register(typename text, typedescr text) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_register(typename text, typedescr text) FROM ndbadm;
GRANT ALL ON FUNCTION type_register(typename text, typedescr text) TO ndbadm;
GRANT ALL ON FUNCTION type_register(typename text, typedescr text) TO ndb_writers;


SET search_path = notify, pg_catalog;

--
-- Name: field_id(integer, text); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION field_id(type_id integer, field_name text) FROM PUBLIC;
REVOKE ALL ON FUNCTION field_id(type_id integer, field_name text) FROM ndbadm;
GRANT ALL ON FUNCTION field_id(type_id integer, field_name text) TO ndbadm;
GRANT ALL ON FUNCTION field_id(type_id integer, field_name text) TO ndb_readers;
GRANT ALL ON FUNCTION field_id(type_id integer, field_name text) TO ndb_writers;


--
-- Name: filter_action_importance_check_children_p(integer, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_action_importance_check_children_p(filterid_in integer, imp_in integer) TO ndb_writers;


--
-- Name: filter_action_importance_check_parents_p(integer, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_action_importance_check_parents_p(filterid_in integer, imp_in integer) TO ndb_writers;


--
-- Name: filter_full_name(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_full_name(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_full_name(integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_full_name(integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_full_name(integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_full_name(integer) TO ndb_writers;


--
-- Name: filter_is_leaf(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_is_leaf(filter_id_in integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_is_leaf(filter_id_in integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_is_leaf(filter_id_in integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_is_leaf(filter_id_in integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_is_leaf(filter_id_in integer) TO ndb_writers;


--
-- Name: filter_is_subfilter(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_is_subfilter(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_is_subfilter(integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_is_subfilter(integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_is_subfilter(integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_is_subfilter(integer) TO ndb_writers;


--
-- Name: filter_root(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_root(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_root(integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_root(integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_root(integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_root(integer) TO ndb_writers;


--
-- Name: filter_subfilters(integer, boolean); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_subfilters(integer, boolean) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_subfilters(integer, boolean) FROM ndbadm;
GRANT ALL ON FUNCTION filter_subfilters(integer, boolean) TO ndbadm;
GRANT ALL ON FUNCTION filter_subfilters(integer, boolean) TO ndb_readers;
GRANT ALL ON FUNCTION filter_subfilters(integer, boolean) TO ndb_writers;


--
-- Name: filter_templates; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE filter_templates FROM PUBLIC;
REVOKE ALL ON TABLE filter_templates FROM ndbadm;
GRANT ALL ON TABLE filter_templates TO ndbadm;
GRANT SELECT ON TABLE filter_templates TO ndb_readers;
GRANT ALL ON TABLE filter_templates TO ndb_writers;


--
-- Name: filter_templates__all_templates(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_templates__all_templates() FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_templates__all_templates() FROM ndbadm;
GRANT ALL ON FUNCTION filter_templates__all_templates() TO ndbadm;
GRANT ALL ON FUNCTION filter_templates__all_templates() TO ndb_readers;
GRANT ALL ON FUNCTION filter_templates__all_templates() TO ndb_writers;


--
-- Name: filter_templates__delete_cascade(integer, integer, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_templates__delete_cascade(_filter_id integer, _type_id integer, _target_type_id integer) TO ndb_writers;


--
-- Name: filter_templates__purge_targets(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_templates__purge_targets() FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_templates__purge_targets() FROM ndbadm;
GRANT ALL ON FUNCTION filter_templates__purge_targets() TO ndbadm;
GRANT ALL ON FUNCTION filter_templates__purge_targets() TO ndb_readers;
GRANT ALL ON FUNCTION filter_templates__purge_targets() TO ndb_writers;


--
-- Name: filter_templates__subfilter_templates(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_templates__subfilter_templates(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_templates__subfilter_templates(integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_templates__subfilter_templates(integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_templates__subfilter_templates(integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_templates__subfilter_templates(integer) TO ndb_writers;


--
-- Name: filter_templates_exists(integer, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_templates_exists(integer, integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_templates_exists(integer, integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_templates_exists(integer, integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_templates_exists(integer, integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_templates_exists(integer, integer) TO ndb_writers;


--
-- Name: filter_type_id(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filter_type_id(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filter_type_id(integer) FROM ndbadm;
GRANT ALL ON FUNCTION filter_type_id(integer) TO ndbadm;
GRANT ALL ON FUNCTION filter_type_id(integer) TO ndb_readers;
GRANT ALL ON FUNCTION filter_type_id(integer) TO ndb_writers;


--
-- Name: filters__delete_cascade(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filters__delete_cascade(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filters__delete_cascade(integer) FROM ndbadm;
GRANT ALL ON FUNCTION filters__delete_cascade(integer) TO ndbadm;
GRANT ALL ON FUNCTION filters__delete_cascade(integer) TO ndb_readers;
GRANT ALL ON FUNCTION filters__delete_cascade(integer) TO ndb_writers;


--
-- Name: filters__purge_targets(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filters__purge_targets() FROM PUBLIC;
REVOKE ALL ON FUNCTION filters__purge_targets() FROM ndbadm;
GRANT ALL ON FUNCTION filters__purge_targets() TO ndbadm;
GRANT ALL ON FUNCTION filters__purge_targets() TO ndb_readers;
GRANT ALL ON FUNCTION filters__purge_targets() TO ndb_writers;


--
-- Name: filters__update_generation(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filters__update_generation() FROM PUBLIC;
REVOKE ALL ON FUNCTION filters__update_generation() FROM ndbadm;
GRANT ALL ON FUNCTION filters__update_generation() TO ndbadm;
GRANT ALL ON FUNCTION filters__update_generation() TO ndb_readers;
GRANT ALL ON FUNCTION filters__update_generation() TO ndb_writers;


--
-- Name: filters__update_modified(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filters__update_modified() FROM PUBLIC;
REVOKE ALL ON FUNCTION filters__update_modified() FROM ndbadm;
GRANT ALL ON FUNCTION filters__update_modified() TO ndbadm;
GRANT ALL ON FUNCTION filters__update_modified() TO ndb_readers;
GRANT ALL ON FUNCTION filters__update_modified() TO ndb_writers;


--
-- Name: filters__valid_parent(integer, integer, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION filters__valid_parent(filter integer, filter_type integer, parent integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION filters__valid_parent(filter integer, filter_type integer, parent integer) FROM ndbadm;
GRANT ALL ON FUNCTION filters__valid_parent(filter integer, filter_type integer, parent integer) TO ndbadm;
GRANT ALL ON FUNCTION filters__valid_parent(filter integer, filter_type integer, parent integer) TO ndb_readers;
GRANT ALL ON FUNCTION filters__valid_parent(filter integer, filter_type integer, parent integer) TO ndb_writers;


--
-- Name: set_event_importance(text, integer, integer, boolean, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) FROM ndbadm;
GRANT ALL ON FUNCTION set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) TO ndbadm;
GRANT ALL ON FUNCTION set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) TO nms;


--
-- Name: target_addr(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION target_addr(target_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION target_addr(target_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION target_addr(target_id integer) TO ndbadm;
GRANT ALL ON FUNCTION target_addr(target_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION target_addr(target_id integer) TO ndb_writers;


--
-- Name: target_complete(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION target_complete(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION target_complete(integer) FROM ndbadm;
GRANT ALL ON FUNCTION target_complete(integer) TO ndbadm;
GRANT ALL ON FUNCTION target_complete(integer) TO ndb_readers;
GRANT ALL ON FUNCTION target_complete(integer) TO ndb_writers;


--
-- Name: target_type(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION target_type(target_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION target_type(target_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION target_type(target_id integer) TO ndbadm;
GRANT ALL ON FUNCTION target_type(target_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION target_type(target_id integer) TO ndb_writers;


--
-- Name: target_type_id(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION target_type_id(target_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION target_type_id(target_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION target_type_id(target_id integer) TO ndbadm;
GRANT ALL ON FUNCTION target_type_id(target_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION target_type_id(target_id integer) TO ndb_writers;


--
-- Name: templates__used_templates(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION templates__used_templates() FROM PUBLIC;
REVOKE ALL ON FUNCTION templates__used_templates() FROM ndbadm;
GRANT ALL ON FUNCTION templates__used_templates() TO ndbadm;
GRANT ALL ON FUNCTION templates__used_templates() TO ndb_readers;
GRANT ALL ON FUNCTION templates__used_templates() TO ndb_writers;


--
-- Name: type_full_name(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_full_name(type_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_full_name(type_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION type_full_name(type_id integer) TO ndbadm;
GRANT ALL ON FUNCTION type_full_name(type_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION type_full_name(type_id integer) TO ndb_writers;


--
-- Name: type_id(text); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_id(text) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_id(text) FROM ndbadm;
GRANT ALL ON FUNCTION type_id(text) TO ndbadm;
GRANT ALL ON FUNCTION type_id(text) TO ndb_readers;
GRANT ALL ON FUNCTION type_id(text) TO ndb_writers;


--
-- Name: type_link_exists(integer, integer, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_link_exists(tp integer, f integer, t integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_link_exists(tp integer, f integer, t integer) FROM ndbadm;
GRANT ALL ON FUNCTION type_link_exists(tp integer, f integer, t integer) TO ndbadm;
GRANT ALL ON FUNCTION type_link_exists(tp integer, f integer, t integer) TO ndb_readers;
GRANT ALL ON FUNCTION type_link_exists(tp integer, f integer, t integer) TO ndb_writers;


--
-- Name: type_link_valid(integer, integer, integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_link_valid(tp integer, f integer, t integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_link_valid(tp integer, f integer, t integer) FROM ndbadm;
GRANT ALL ON FUNCTION type_link_valid(tp integer, f integer, t integer) TO ndbadm;
GRANT ALL ON FUNCTION type_link_valid(tp integer, f integer, t integer) TO ndb_readers;
GRANT ALL ON FUNCTION type_link_valid(tp integer, f integer, t integer) TO ndb_writers;


--
-- Name: type_links__purge_links(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_links__purge_links() FROM PUBLIC;
REVOKE ALL ON FUNCTION type_links__purge_links() FROM ndbadm;
GRANT ALL ON FUNCTION type_links__purge_links() TO ndbadm;
GRANT ALL ON FUNCTION type_links__purge_links() TO ndb_readers;
GRANT ALL ON FUNCTION type_links__purge_links() TO ndb_writers;


--
-- Name: type_name(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_name(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_name(integer) FROM ndbadm;
GRANT ALL ON FUNCTION type_name(integer) TO ndbadm;
GRANT ALL ON FUNCTION type_name(integer) TO ndb_readers;
GRANT ALL ON FUNCTION type_name(integer) TO ndb_writers;


--
-- Name: type_with_subtypes(integer); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION type_with_subtypes(root integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION type_with_subtypes(root integer) FROM ndbadm;
GRANT ALL ON FUNCTION type_with_subtypes(root integer) TO ndbadm;
GRANT ALL ON FUNCTION type_with_subtypes(root integer) TO ndb_readers;
GRANT ALL ON FUNCTION type_with_subtypes(root integer) TO ndb_writers;


--
-- Name: update_complete_targets_tbl(); Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON FUNCTION update_complete_targets_tbl() FROM PUBLIC;
REVOKE ALL ON FUNCTION update_complete_targets_tbl() FROM ndbadm;
GRANT ALL ON FUNCTION update_complete_targets_tbl() TO ndbadm;
GRANT ALL ON FUNCTION update_complete_targets_tbl() TO ndb_readers;
GRANT ALL ON FUNCTION update_complete_targets_tbl() TO ndb_writers;


SET search_path = public, pg_catalog;

--
-- Name: host_id(text); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION host_id(text) FROM PUBLIC;
REVOKE ALL ON FUNCTION host_id(text) FROM ndbadm;
GRANT ALL ON FUNCTION host_id(text) TO ndbadm;
GRANT ALL ON FUNCTION host_id(text) TO PUBLIC;
GRANT ALL ON FUNCTION host_id(text) TO ndb_readers;
GRANT ALL ON FUNCTION host_id(text) TO ndb_writers;


--
-- Name: hosts_create_schema(); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION hosts_create_schema() FROM PUBLIC;
REVOKE ALL ON FUNCTION hosts_create_schema() FROM ndbadm;
GRANT ALL ON FUNCTION hosts_create_schema() TO ndbadm;
GRANT ALL ON FUNCTION hosts_create_schema() TO PUBLIC;
GRANT ALL ON FUNCTION hosts_create_schema() TO ndb_writers;


--
-- Name: hosts_drop_schema(); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION hosts_drop_schema() FROM PUBLIC;
REVOKE ALL ON FUNCTION hosts_drop_schema() FROM ndbadm;
GRANT ALL ON FUNCTION hosts_drop_schema() TO ndbadm;
GRANT ALL ON FUNCTION hosts_drop_schema() TO PUBLIC;
GRANT ALL ON FUNCTION hosts_drop_schema() TO ndb_writers;


--
-- Name: pg_freespace(regclass); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION pg_freespace(rel regclass, OUT blkno bigint, OUT avail smallint) FROM PUBLIC;
REVOKE ALL ON FUNCTION pg_freespace(rel regclass, OUT blkno bigint, OUT avail smallint) FROM postgres;
GRANT ALL ON FUNCTION pg_freespace(rel regclass, OUT blkno bigint, OUT avail smallint) TO postgres;


--
-- Name: pg_freespace(regclass, bigint); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION pg_freespace(regclass, bigint) FROM PUBLIC;
REVOKE ALL ON FUNCTION pg_freespace(regclass, bigint) FROM postgres;
GRANT ALL ON FUNCTION pg_freespace(regclass, bigint) TO postgres;


--
-- Name: post_target_type_id(text); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION post_target_type_id(name text) FROM PUBLIC;
REVOKE ALL ON FUNCTION post_target_type_id(name text) FROM ndbadm;
GRANT ALL ON FUNCTION post_target_type_id(name text) TO ndbadm;
GRANT ALL ON FUNCTION post_target_type_id(name text) TO ndb_readers;
GRANT ALL ON FUNCTION post_target_type_id(name text) TO ndb_writers;


--
-- Name: post_target_type_multiple(integer); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION post_target_type_multiple(target_type_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION post_target_type_multiple(target_type_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION post_target_type_multiple(target_type_id integer) TO ndbadm;
GRANT ALL ON FUNCTION post_target_type_multiple(target_type_id integer) TO ndb_readers;
GRANT ALL ON FUNCTION post_target_type_multiple(target_type_id integer) TO ndb_writers;


--
-- Name: subsystem_alive(integer); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION subsystem_alive(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION subsystem_alive(integer) FROM ndbadm;
GRANT ALL ON FUNCTION subsystem_alive(integer) TO ndbadm;
GRANT ALL ON FUNCTION subsystem_alive(integer) TO PUBLIC;
GRANT ALL ON FUNCTION subsystem_alive(integer) TO ndb_writers;


--
-- Name: subsystem_register(text, integer, text); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION subsystem_register(text, integer, text) FROM PUBLIC;
REVOKE ALL ON FUNCTION subsystem_register(text, integer, text) FROM ndbadm;
GRANT ALL ON FUNCTION subsystem_register(text, integer, text) TO ndbadm;
GRANT ALL ON FUNCTION subsystem_register(text, integer, text) TO PUBLIC;
GRANT ALL ON FUNCTION subsystem_register(text, integer, text) TO ndb_writers;


--
-- Name: subsystem_register(text, text, text); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION subsystem_register(text, text, text) FROM PUBLIC;
REVOKE ALL ON FUNCTION subsystem_register(text, text, text) FROM ndbadm;
GRANT ALL ON FUNCTION subsystem_register(text, text, text) TO ndbadm;
GRANT ALL ON FUNCTION subsystem_register(text, text, text) TO PUBLIC;
GRANT ALL ON FUNCTION subsystem_register(text, text, text) TO ndb_writers;


--
-- Name: subsystem_stop(integer); Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON FUNCTION subsystem_stop(integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION subsystem_stop(integer) FROM ndbadm;
GRANT ALL ON FUNCTION subsystem_stop(integer) TO ndbadm;
GRANT ALL ON FUNCTION subsystem_stop(integer) TO PUBLIC;
GRANT ALL ON FUNCTION subsystem_stop(integer) TO ndb_writers;


SET search_path = purge, pg_catalog;

--
-- Name: rules; Type: ACL; Schema: purge; Owner: ndbadm
--

REVOKE ALL ON TABLE rules FROM PUBLIC;
REVOKE ALL ON TABLE rules FROM ndbadm;
GRANT ALL ON TABLE rules TO ndbadm;
GRANT SELECT ON TABLE rules TO ndb_readers;
GRANT SELECT ON TABLE rules TO ndb_writers;


SET search_path = quarantine, pg_catalog;

--
-- Name: automatic_importance(integer, integer, integer); Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer) FROM ndbadm;
GRANT ALL ON FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer) TO ndbadm;
GRANT ALL ON FUNCTION automatic_importance(capture_id integer, importance integer, filter_id integer) TO nms;


--
-- Name: manual_importance(integer, integer, integer); Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON FUNCTION manual_importance(capture_id integer, importance integer, uid integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION manual_importance(capture_id integer, importance integer, uid integer) FROM ndbadm;
GRANT ALL ON FUNCTION manual_importance(capture_id integer, importance integer, uid integer) TO ndbadm;
GRANT ALL ON FUNCTION manual_importance(capture_id integer, importance integer, uid integer) TO nms;


--
-- Name: captures; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON TABLE captures FROM PUBLIC;
REVOKE ALL ON TABLE captures FROM ndbadm;
GRANT ALL ON TABLE captures TO ndbadm;
GRANT SELECT ON TABLE captures TO ndb_readers;
GRANT ALL ON TABLE captures TO ndb_writers;


SET search_path = smp, pg_catalog;

--
-- Name: manual_action(integer, integer, text, integer); Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON FUNCTION manual_action(_user_id integer, _action integer, _action_param text, _uid integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION manual_action(_user_id integer, _action integer, _action_param text, _uid integer) FROM ndbadm;
GRANT ALL ON FUNCTION manual_action(_user_id integer, _action integer, _action_param text, _uid integer) TO ndbadm;
GRANT ALL ON FUNCTION manual_action(_user_id integer, _action integer, _action_param text, _uid integer) TO nms;


SET search_path = flood, pg_catalog;

--
-- Name: pattern_quality(real, real); Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON FUNCTION pattern_quality(real, real) FROM PUBLIC;
REVOKE ALL ON FUNCTION pattern_quality(real, real) FROM ndbadm;
GRANT ALL ON FUNCTION pattern_quality(real, real) TO ndbadm;
GRANT ALL ON FUNCTION pattern_quality(real, real) TO ndb_readers;
GRANT ALL ON FUNCTION pattern_quality(real, real) TO ndb_writers;


SET search_path = auth, pg_catalog;

--
-- Name: authorized_keys; Type: ACL; Schema: auth; Owner: postgres
--

REVOKE ALL ON TABLE authorized_keys FROM PUBLIC;
REVOKE ALL ON TABLE authorized_keys FROM postgres;
GRANT ALL ON TABLE authorized_keys TO postgres;
GRANT SELECT ON TABLE authorized_keys TO ndb_readers;
GRANT SELECT ON TABLE authorized_keys TO ndb_writers;


--
-- Name: ipsec; Type: ACL; Schema: auth; Owner: postgres
--

REVOKE ALL ON TABLE ipsec FROM PUBLIC;
REVOKE ALL ON TABLE ipsec FROM postgres;
GRANT ALL ON TABLE ipsec TO postgres;


--
-- Name: passwd; Type: ACL; Schema: auth; Owner: postgres
--

REVOKE ALL ON TABLE passwd FROM PUBLIC;
REVOKE ALL ON TABLE passwd FROM postgres;
GRANT ALL ON TABLE passwd TO postgres;
GRANT SELECT ON TABLE passwd TO ndb_readers;
GRANT SELECT,REFERENCES ON TABLE passwd TO ndb_writers;
GRANT ALL ON TABLE passwd TO nms;


REVOKE ALL ON SEQUENCE passwd_uid_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE passwd_uid_seq FROM ndbadm;
GRANT ALL ON SEQUENCE passwd_uid_seq TO ndbadm;
GRANT USAGE ON SEQUENCE passwd_uid_seq TO ndb_writers;
GRANT USAGE ON SEQUENCE passwd_uid_seq TO nms;

--
-- Name: ldap; Type: ACL; Schema: auth; Owner: postgres
--

REVOKE ALL ON TABLE ldap FROM PUBLIC;
REVOKE ALL ON TABLE ldap FROM postgres;
GRANT ALL ON TABLE ldap TO postgres;
GRANT ALL ON TABLE ldap TO nms;
GRANT SELECT, USAGE ON SEQUENCE ldap_id_seq TO nms;
GRANT ALL ON SEQUENCE ldap_id_seq TO postgres;


SET search_path = fast, pg_catalog;

--
-- Name: attr_types; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE attr_types FROM PUBLIC;
REVOKE ALL ON TABLE attr_types FROM ndbadm;
GRANT ALL ON TABLE attr_types TO ndbadm;
GRANT SELECT ON TABLE attr_types TO ndb_readers;
GRANT SELECT ON TABLE attr_types TO ndb_writers;


--
-- Name: attrs; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE attrs FROM PUBLIC;
REVOKE ALL ON TABLE attrs FROM ndbadm;
GRANT ALL ON TABLE attrs TO ndbadm;
GRANT SELECT ON TABLE attrs TO ndb_readers;
-- original GRANT SELECT ON TABLE attrs TO ndb_writers;
GRANT ALL ON TABLE attrs TO ndb_writers;


--
-- Name: entities; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE entities FROM PUBLIC;
REVOKE ALL ON TABLE entities FROM ndbadm;
GRANT ALL ON TABLE entities TO ndbadm;
GRANT SELECT ON TABLE entities TO ndb_readers;
GRANT SELECT,DELETE ON TABLE entities TO ndb_writers;


--
-- Name: entity_links; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE entity_links FROM PUBLIC;
REVOKE ALL ON TABLE entity_links FROM ndbadm;
GRANT ALL ON TABLE entity_links TO ndbadm;
GRANT SELECT ON TABLE entity_links TO ndb_readers;
GRANT SELECT,INSERT ON TABLE entity_links TO ndb_writers;


--
-- Name: entity_patterns; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE entity_patterns FROM PUBLIC;
REVOKE ALL ON TABLE entity_patterns FROM ndbadm;
GRANT ALL ON TABLE entity_patterns TO ndbadm;
GRANT SELECT ON TABLE entity_patterns TO ndb_readers;
-- original GRANT SELECT,INSERT ON TABLE entity_patterns TO ndb_writers;
GRANT ALL ON TABLE entity_patterns TO ndb_writers;


--
-- Name: pat_contents; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE pat_contents FROM PUBLIC;
REVOKE ALL ON TABLE pat_contents FROM ndbadm;
GRANT ALL ON TABLE pat_contents TO ndbadm;
GRANT SELECT ON TABLE pat_contents TO ndb_readers;
GRANT SELECT ON TABLE pat_contents TO ndb_writers;
GRANT ALL ON TABLE pat_contents TO nms;

--
-- Name: pat_endpoint_search; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE pat_endpoint_search FROM PUBLIC;
REVOKE ALL ON TABLE pat_endpoint_search FROM ndbadm;
GRANT ALL ON TABLE pat_endpoint_search TO ndbadm;
GRANT SELECT ON TABLE pat_endpoint_search TO ndb_readers;
GRANT ALL ON TABLE pat_endpoint_search TO ndb_writers;


--
-- Name: pat_payload_search; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE pat_payload_search FROM PUBLIC;
REVOKE ALL ON TABLE pat_payload_search FROM ndbadm;
GRANT ALL ON TABLE pat_payload_search TO ndbadm;
GRANT ALL ON TABLE pat_payload_search TO ndb_writers;
GRANT SELECT ON TABLE pat_payload_search TO ndb_readers;


--
-- Name: patterns; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE patterns FROM PUBLIC;
REVOKE ALL ON TABLE patterns FROM ndbadm;
GRANT ALL ON TABLE patterns TO ndbadm;
GRANT SELECT ON TABLE patterns TO ndb_readers;
GRANT SELECT ON TABLE patterns TO ndb_writers;


--
-- Name: top_host_sets; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE top_host_sets FROM PUBLIC;
REVOKE ALL ON TABLE top_host_sets FROM ndbadm;
GRANT ALL ON TABLE top_host_sets TO ndbadm;
GRANT SELECT ON TABLE top_host_sets TO ndb_readers;
GRANT SELECT ON TABLE top_host_sets TO ndb_writers;
GRANT ALL ON TABLE top_host_sets TO nms;

GRANT ALL ON SEQUENCE top_host_sets_ths_id_seq TO nms;


--
-- Name: top_hosts; Type: ACL; Schema: fast; Owner: ndbadm
--

REVOKE ALL ON TABLE top_hosts FROM PUBLIC;
REVOKE ALL ON TABLE top_hosts FROM ndbadm;
GRANT ALL ON TABLE top_hosts TO ndbadm;
GRANT SELECT ON TABLE top_hosts TO ndb_readers;
GRANT SELECT ON TABLE top_hosts TO ndb_writers;
GRANT ALL ON TABLE top_hosts TO nms;


SET search_path = fgen, pg_catalog;

--
-- Name: percents; Type: ACL; Schema: fgen; Owner: ndbadm
--

REVOKE ALL ON TABLE percents FROM PUBLIC;
REVOKE ALL ON TABLE percents FROM ndbadm;
GRANT ALL ON TABLE percents TO ndbadm;
GRANT SELECT ON TABLE percents TO ndb_readers;
GRANT ALL ON TABLE percents TO ndb_writers;


--
-- Name: types; Type: ACL; Schema: fgen; Owner: ndbadm
--

REVOKE ALL ON TABLE types FROM PUBLIC;
REVOKE ALL ON TABLE types FROM ndbadm;
GRANT ALL ON TABLE types TO ndbadm;
GRANT SELECT ON TABLE types TO ndb_readers;
GRANT ALL ON TABLE types TO ndb_writers;


SET search_path = flood, pg_catalog;

--
-- Name: alert_types; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE alert_types FROM PUBLIC;
REVOKE ALL ON TABLE alert_types FROM ndbadm;
GRANT ALL ON TABLE alert_types TO ndbadm;
GRANT SELECT ON TABLE alert_types TO ndb_readers;
GRANT ALL ON TABLE alert_types TO ndb_writers;


--
-- Name: alerters; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE alerters FROM PUBLIC;
REVOKE ALL ON TABLE alerters FROM ndbadm;
GRANT ALL ON TABLE alerters TO ndbadm;
GRANT SELECT ON TABLE alerters TO ndb_readers;
GRANT ALL ON TABLE alerters TO ndb_writers;


--
-- Name: alerts; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE alerts FROM PUBLIC;
REVOKE ALL ON TABLE alerts FROM ndbadm;
GRANT ALL ON TABLE alerts TO ndbadm;
GRANT SELECT ON TABLE alerts TO ndb_readers;
GRANT ALL ON TABLE alerts TO ndb_writers;
GRANT ALL ON TABLE alerts TO nms; 

--
-- Name: amplification_alerts; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE amplification_alerts FROM PUBLIC;
REVOKE ALL ON TABLE amplification_alerts FROM ndbadm;
GRANT ALL ON TABLE amplification_alerts TO ndbadm;
GRANT ALL ON TABLE amplification_alerts TO nms;

--
-- Name: bogons; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE bogons FROM PUBLIC;
REVOKE ALL ON TABLE bogons FROM ndbadm;
GRANT ALL ON TABLE bogons TO ndbadm;
GRANT ALL ON TABLE bogons TO nms;

--
-- Name: cache; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE cache FROM PUBLIC;
REVOKE ALL ON TABLE cache FROM ndbadm;
GRANT ALL ON TABLE cache TO ndbadm;
GRANT SELECT ON TABLE cache TO ndb_readers;
GRANT ALL ON TABLE cache TO ndb_writers;


--
-- Name: registry; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE registry FROM PUBLIC;
REVOKE ALL ON TABLE registry FROM ndbadm;
GRANT ALL ON TABLE registry TO ndbadm;
GRANT SELECT ON TABLE registry TO ndb_readers;
GRANT ALL ON TABLE registry TO ndb_writers;


--
-- Name: state; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE state FROM PUBLIC;
REVOKE ALL ON TABLE state FROM ndbadm;
GRANT ALL ON TABLE state TO ndbadm;
GRANT SELECT ON TABLE state TO ndb_readers;
GRANT ALL ON TABLE state TO ndb_writers;


--
-- Name: stats; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE stats FROM PUBLIC;
REVOKE ALL ON TABLE stats FROM ndbadm;
GRANT ALL ON TABLE stats TO ndbadm;
GRANT SELECT ON TABLE stats TO ndb_readers;
GRANT ALL ON TABLE stats TO ndb_writers;


--
-- Name: all; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE "all" FROM PUBLIC;
REVOKE ALL ON TABLE "all" FROM ndbadm;
GRANT ALL ON TABLE "all" TO ndbadm;
GRANT SELECT ON TABLE "all" TO ndb_readers;


--
-- Name: attack_interfaces_triggered; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE attack_interfaces_triggered FROM PUBLIC;
REVOKE ALL ON TABLE attack_interfaces_triggered FROM ndbadm;
GRANT ALL ON TABLE attack_interfaces_triggered TO ndbadm;
GRANT ALL ON TABLE attack_interfaces_triggered TO PUBLIC;


--
-- Name: config; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE config FROM PUBLIC;
REVOKE ALL ON TABLE config FROM ndbadm;
GRANT ALL ON TABLE config TO ndbadm;
GRANT SELECT ON TABLE config TO ndb_readers;
GRANT ALL ON TABLE config TO ndb_writers;


--
-- Name: errors; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE errors FROM PUBLIC;
REVOKE ALL ON TABLE errors FROM ndbadm;
GRANT ALL ON TABLE errors TO ndbadm;
GRANT SELECT ON TABLE errors TO ndb_readers;
GRANT ALL ON TABLE errors TO ndb_writers;


--
-- Name: errors_error_id_seq; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE errors_error_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE errors_error_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE errors_error_id_seq TO ndbadm;
GRANT USAGE ON SEQUENCE errors_error_id_seq TO ndb_writers;


--
-- Name: graphs; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE graphs FROM PUBLIC;
REVOKE ALL ON TABLE graphs FROM ndbadm;
GRANT ALL ON TABLE graphs TO ndbadm;
GRANT SELECT ON TABLE graphs TO ndb_readers;
GRANT ALL ON TABLE graphs TO ndb_writers;


--
-- Name: importance; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE importance FROM PUBLIC;
REVOKE ALL ON TABLE importance FROM ndbadm;
GRANT ALL ON TABLE importance TO ndbadm;
GRANT SELECT ON TABLE importance TO ndb_readers;
GRANT SELECT ON TABLE importance TO ndb_writers;


--
-- Name: matches; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE matches FROM PUBLIC;
REVOKE ALL ON TABLE matches FROM ndbadm;
GRANT ALL ON TABLE matches TO ndbadm;
GRANT SELECT ON TABLE matches TO ndb_readers;
GRANT ALL ON TABLE matches TO ndb_writers;


--
-- Name: mtg_auto_block_tbl; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_auto_block_tbl FROM PUBLIC;
REVOKE ALL ON TABLE mtg_auto_block_tbl FROM ndbadm;
GRANT ALL ON TABLE mtg_auto_block_tbl TO ndbadm;
GRANT ALL ON TABLE mtg_auto_block_tbl TO PUBLIC;


--
-- Name: mtg_auto_block_with_action_tbl; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_auto_block_with_action_tbl FROM PUBLIC;
REVOKE ALL ON TABLE mtg_auto_block_with_action_tbl FROM ndbadm;
GRANT ALL ON TABLE mtg_auto_block_with_action_tbl TO ndbadm;
GRANT ALL ON TABLE mtg_auto_block_with_action_tbl TO PUBLIC;


--
-- Name: mtg_graphs_real; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_graphs_real FROM PUBLIC;
REVOKE ALL ON TABLE mtg_graphs_real FROM ndbadm;
GRANT ALL ON TABLE mtg_graphs_real TO ndbadm;
GRANT SELECT ON TABLE mtg_graphs_real TO ndb_readers;
GRANT ALL ON TABLE mtg_graphs_real TO ndb_writers;


--
-- Name: mtg_graphs; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_graphs FROM PUBLIC;
REVOKE ALL ON TABLE mtg_graphs FROM ndbadm;
GRANT ALL ON TABLE mtg_graphs TO ndbadm;
GRANT SELECT ON TABLE mtg_graphs TO ndb_readers;
GRANT ALL ON TABLE mtg_graphs TO ndb_writers;


--
-- Name: mtg_live; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_live FROM PUBLIC;
REVOKE ALL ON TABLE mtg_live FROM ndbadm;
GRANT ALL ON TABLE mtg_live TO ndbadm;
GRANT SELECT ON TABLE mtg_live TO ndb_readers;
GRANT ALL ON TABLE mtg_live TO ndb_writers;


--
-- Name: mtg_live_log_past; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_live_log_past FROM PUBLIC;
REVOKE ALL ON TABLE mtg_live_log_past FROM ndbadm;
GRANT ALL ON TABLE mtg_live_log_past TO ndbadm;
GRANT SELECT ON TABLE mtg_live_log_past TO ndb_readers;
GRANT ALL ON TABLE mtg_live_log_past TO ndb_writers;


--
-- Name: mtg_live_log; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_live_log FROM PUBLIC;
REVOKE ALL ON TABLE mtg_live_log FROM ndbadm;
GRANT ALL ON TABLE mtg_live_log TO ndbadm;
GRANT SELECT ON TABLE mtg_live_log TO ndb_readers;
GRANT ALL ON TABLE mtg_live_log TO ndb_writers;


--
-- Name: mtg_live_log_past_id_seq; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE mtg_live_log_past_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE mtg_live_log_past_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE mtg_live_log_past_id_seq TO ndbadm;
GRANT SELECT,USAGE ON SEQUENCE mtg_live_log_past_id_seq TO PUBLIC;


--
-- Name: mtg_map; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_map FROM PUBLIC;
REVOKE ALL ON TABLE mtg_map FROM ndbadm;
GRANT ALL ON TABLE mtg_map TO ndbadm;
GRANT SELECT ON TABLE mtg_map TO ndb_readers;
GRANT ALL ON TABLE mtg_map TO ndb_writers;


--
-- Name: mtg_req_manual_block_tbl; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_req_manual_block_tbl FROM PUBLIC;
REVOKE ALL ON TABLE mtg_req_manual_block_tbl FROM ndbadm;
GRANT ALL ON TABLE mtg_req_manual_block_tbl TO ndbadm;
GRANT ALL ON TABLE mtg_req_manual_block_tbl TO PUBLIC;


--
-- Name: mtg_req_manual_unblock_tbl; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_req_manual_unblock_tbl FROM PUBLIC;
REVOKE ALL ON TABLE mtg_req_manual_unblock_tbl FROM ndbadm;
GRANT ALL ON TABLE mtg_req_manual_unblock_tbl TO ndbadm;
GRANT ALL ON TABLE mtg_req_manual_unblock_tbl TO PUBLIC;


--
-- Name: mtg_reqs; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_reqs FROM PUBLIC;
REVOKE ALL ON TABLE mtg_reqs FROM ndbadm;
GRANT ALL ON TABLE mtg_reqs TO ndbadm;
GRANT SELECT ON TABLE mtg_reqs TO ndb_readers;
GRANT ALL ON TABLE mtg_reqs TO ndb_writers;


--
-- Name: mtg_reqs_log_past; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_reqs_log_past FROM PUBLIC;
REVOKE ALL ON TABLE mtg_reqs_log_past FROM ndbadm;
GRANT ALL ON TABLE mtg_reqs_log_past TO ndbadm;
GRANT SELECT ON TABLE mtg_reqs_log_past TO ndb_readers;
GRANT ALL ON TABLE mtg_reqs_log_past TO ndb_writers;


--
-- Name: mtg_reqs_log; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_reqs_log FROM PUBLIC;
REVOKE ALL ON TABLE mtg_reqs_log FROM ndbadm;
GRANT ALL ON TABLE mtg_reqs_log TO ndbadm;
GRANT SELECT ON TABLE mtg_reqs_log TO ndb_readers;
GRANT ALL ON TABLE mtg_reqs_log TO ndb_writers;


--
-- Name: mtg_sg_state; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_sg_state FROM PUBLIC;
REVOKE ALL ON TABLE mtg_sg_state FROM ndbadm;
GRANT ALL ON TABLE mtg_sg_state TO ndbadm;
GRANT SELECT ON TABLE mtg_sg_state TO ndb_readers;
GRANT ALL ON TABLE mtg_sg_state TO ndb_writers;


--
-- Name: pattern_entropy; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE pattern_entropy FROM PUBLIC;
REVOKE ALL ON TABLE pattern_entropy FROM ndbadm;
GRANT ALL ON TABLE pattern_entropy TO ndbadm;
GRANT ALL ON TABLE pattern_entropy TO ndb_writers;
GRANT SELECT ON TABLE pattern_entropy TO ndb_readers;


--
-- Name: registry_flood_id_seq; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE registry_flood_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE registry_flood_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE registry_flood_id_seq TO ndbadm;
GRANT USAGE ON SEQUENCE registry_flood_id_seq TO ndb_writers;


--
-- Name: samples; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE samples FROM PUBLIC;
REVOKE ALL ON TABLE samples FROM ndbadm;
GRANT ALL ON TABLE samples TO ndbadm;
GRANT SELECT ON TABLE samples TO ndb_readers;
GRANT ALL ON TABLE samples TO ndb_writers;


--
-- Name: thresholds; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE thresholds FROM PUBLIC;
REVOKE ALL ON TABLE thresholds FROM ndbadm;
GRANT ALL ON TABLE thresholds TO ndbadm;
GRANT SELECT ON TABLE thresholds TO ndb_readers;
GRANT ALL ON TABLE thresholds TO ndb_writers;


--
-- Name: top_asns; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE top_asns FROM PUBLIC;
REVOKE ALL ON TABLE top_asns FROM ndbadm;
GRANT ALL ON TABLE top_asns TO ndbadm;
GRANT SELECT ON TABLE top_asns TO ndb_readers;
GRANT ALL ON TABLE top_asns TO ndb_writers;
GRANT ALL ON TABLE top_asns TO nms;

--
-- Name: top_countries; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE top_countries FROM PUBLIC;
REVOKE ALL ON TABLE top_countries FROM ndbadm;
GRANT ALL ON TABLE top_countries TO ndbadm;
GRANT SELECT ON TABLE top_countries TO ndb_readers;
GRANT ALL ON TABLE top_countries TO ndb_writers;
GRANT ALL ON TABLE top_countries TO nms;

--
-- Name: top_hosts_dst; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE top_hosts_dst FROM PUBLIC;
REVOKE ALL ON TABLE top_hosts_dst FROM ndbadm;
GRANT ALL ON TABLE top_hosts_dst TO ndbadm;
GRANT SELECT ON TABLE top_hosts_dst TO ndb_readers;
GRANT ALL ON TABLE top_hosts_dst TO ndb_writers;


--
-- Name: top_hosts_src; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE top_hosts_src FROM PUBLIC;
REVOKE ALL ON TABLE top_hosts_src FROM ndbadm;
GRANT ALL ON TABLE top_hosts_src TO ndbadm;
GRANT SELECT ON TABLE top_hosts_src TO ndb_readers;
GRANT ALL ON TABLE top_hosts_src TO ndb_writers;


--
-- Name: top_interfaces; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE top_interfaces FROM PUBLIC;
REVOKE ALL ON TABLE top_interfaces FROM ndbadm;
GRANT ALL ON TABLE top_interfaces TO ndbadm;
GRANT ALL ON TABLE top_interfaces TO PUBLIC;


--
-- Name: types; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON TABLE types FROM PUBLIC;
REVOKE ALL ON TABLE types FROM ndbadm;
GRANT ALL ON TABLE types TO ndbadm;
GRANT SELECT ON TABLE types TO ndb_readers;
GRANT ALL ON TABLE types TO ndb_writers;


--
-- Name: types_type_id_seq; Type: ACL; Schema: flood; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE types_type_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE types_type_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE types_type_id_seq TO ndbadm;
GRANT USAGE ON SEQUENCE types_type_id_seq TO ndb_writers;


SET search_path = notify, pg_catalog;

--
-- Name: complete_targets; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE complete_targets FROM PUBLIC;
REVOKE ALL ON TABLE complete_targets FROM ndbadm;
GRANT ALL ON TABLE complete_targets TO ndbadm;
GRANT SELECT ON TABLE complete_targets TO ndb_readers;
GRANT ALL ON TABLE complete_targets TO ndb_writers;


--
-- Name: data_type_operators; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE data_type_operators FROM PUBLIC;
REVOKE ALL ON TABLE data_type_operators FROM ndbadm;
GRANT ALL ON TABLE data_type_operators TO ndbadm;
GRANT SELECT ON TABLE data_type_operators TO ndb_readers;
GRANT ALL ON TABLE data_type_operators TO ndb_writers;


--
-- Name: data_types; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE data_types FROM PUBLIC;
REVOKE ALL ON TABLE data_types FROM ndbadm;
GRANT ALL ON TABLE data_types TO ndbadm;
GRANT SELECT ON TABLE data_types TO ndb_readers;
GRANT ALL ON TABLE data_types TO ndb_writers;


--
-- Name: data_types_data_type_id_seq; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE data_types_data_type_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE data_types_data_type_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE data_types_data_type_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE data_types_data_type_id_seq TO ndb_writers;


--
-- Name: fields; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE fields FROM PUBLIC;
REVOKE ALL ON TABLE fields FROM ndbadm;
GRANT ALL ON TABLE fields TO ndbadm;
GRANT SELECT ON TABLE fields TO ndb_readers;
GRANT ALL ON TABLE fields TO ndb_writers;


--
-- Name: fields_field_id_seq; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE fields_field_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE fields_field_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE fields_field_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE fields_field_id_seq TO ndb_writers;


--
-- Name: filter_parts; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE filter_parts FROM PUBLIC;
REVOKE ALL ON TABLE filter_parts FROM ndbadm;
GRANT ALL ON TABLE filter_parts TO ndbadm;
GRANT SELECT ON TABLE filter_parts TO ndb_readers;
GRANT ALL ON TABLE filter_parts TO ndb_writers;


--
-- Name: filter_targets; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE filter_targets FROM PUBLIC;
REVOKE ALL ON TABLE filter_targets FROM ndbadm;
GRANT ALL ON TABLE filter_targets TO ndbadm;
GRANT SELECT ON TABLE filter_targets TO ndb_readers;
GRANT ALL ON TABLE filter_targets TO ndb_writers;


--
-- Name: filters; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE filters FROM PUBLIC;
REVOKE ALL ON TABLE filters FROM ndbadm;
GRANT ALL ON TABLE filters TO ndbadm;
GRANT SELECT ON TABLE filters TO ndb_readers;
GRANT ALL ON TABLE filters TO ndb_writers;


--
-- Name: filters_filter_id_seq; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE filters_filter_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE filters_filter_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE filters_filter_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE filters_filter_id_seq TO ndb_writers;


--
-- Name: operators; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE operators FROM PUBLIC;
REVOKE ALL ON TABLE operators FROM ndbadm;
GRANT ALL ON TABLE operators TO ndbadm;
GRANT SELECT ON TABLE operators TO ndb_readers;
GRANT ALL ON TABLE operators TO ndb_writers;


--
-- Name: operators_operator_id_seq; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE operators_operator_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operators_operator_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE operators_operator_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE operators_operator_id_seq TO ndb_writers;


--
-- Name: targets; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE targets FROM PUBLIC;
REVOKE ALL ON TABLE targets FROM ndbadm;
GRANT ALL ON TABLE targets TO ndbadm;
GRANT SELECT ON TABLE targets TO ndb_readers;
GRANT ALL ON TABLE targets TO ndb_writers;


--
-- Name: targets_target_id_seq; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE targets_target_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE targets_target_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE targets_target_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE targets_target_id_seq TO ndb_writers;


--
-- Name: templates; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE templates FROM PUBLIC;
REVOKE ALL ON TABLE templates FROM ndbadm;
GRANT ALL ON TABLE templates TO ndbadm;
GRANT SELECT ON TABLE templates TO ndb_readers;
GRANT ALL ON TABLE templates TO ndb_writers;


--
-- Name: templates_template_id_seq; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE templates_template_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE templates_template_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE templates_template_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE templates_template_id_seq TO ndb_writers;


--
-- Name: type_links; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE type_links FROM PUBLIC;
REVOKE ALL ON TABLE type_links FROM ndbadm;
GRANT ALL ON TABLE type_links TO ndbadm;
GRANT SELECT ON TABLE type_links TO ndb_readers;
GRANT ALL ON TABLE type_links TO ndb_writers;


--
-- Name: types; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON TABLE types FROM PUBLIC;
REVOKE ALL ON TABLE types FROM ndbadm;
GRANT ALL ON TABLE types TO ndbadm;
GRANT SELECT ON TABLE types TO ndb_readers;
GRANT ALL ON TABLE types TO ndb_writers;


--
-- Name: types_type_id_seq; Type: ACL; Schema: notify; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE types_type_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE types_type_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE types_type_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE types_type_id_seq TO ndb_writers;


SET search_path = nx, pg_catalog;

--
-- Name: map; Type: ACL; Schema: nx; Owner: ndbadm
--

REVOKE ALL ON TABLE map FROM PUBLIC;
REVOKE ALL ON TABLE map FROM ndbadm;
GRANT ALL ON TABLE map TO ndbadm;
GRANT SELECT ON TABLE map TO ndb_readers;
GRANT ALL ON TABLE map TO ndb_writers;


SET search_path = public, pg_catalog;

--
-- Name: cluster_config; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE cluster_config FROM PUBLIC;
REVOKE ALL ON TABLE cluster_config FROM ndbadm;
GRANT ALL ON TABLE cluster_config TO ndbadm;
GRANT SELECT ON TABLE cluster_config TO ndb_readers;
GRANT ALL ON TABLE cluster_config TO ndb_writers;


--
-- Name: group_config; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE group_config FROM PUBLIC;
REVOKE ALL ON TABLE group_config FROM ndbadm;
GRANT ALL ON TABLE group_config TO ndbadm;
GRANT SELECT ON TABLE group_config TO ndb_readers;
GRANT ALL ON TABLE group_config TO ndb_writers;


--
-- Name: current_group_config; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE current_group_config FROM PUBLIC;
REVOKE ALL ON TABLE current_group_config FROM ndbadm;
GRANT ALL ON TABLE current_group_config TO ndbadm;
GRANT SELECT ON TABLE current_group_config TO ndb_readers;
GRANT ALL ON TABLE current_group_config TO ndb_writers;


--
-- Name: data_tables; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE data_tables FROM PUBLIC;
REVOKE ALL ON TABLE data_tables FROM ndbadm;
GRANT ALL ON TABLE data_tables TO ndbadm;
GRANT SELECT ON TABLE data_tables TO ndb_readers;
GRANT ALL ON TABLE data_tables TO ndb_writers;


--
-- Name: data_tables_table_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE data_tables_table_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE data_tables_table_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE data_tables_table_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE data_tables_table_id_seq TO ndb_writers;


--
-- Name: group_mapping; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE group_mapping FROM PUBLIC;
REVOKE ALL ON TABLE group_mapping FROM ndbadm;
GRANT ALL ON TABLE group_mapping TO ndbadm;
GRANT SELECT ON TABLE group_mapping TO ndb_readers;
GRANT ALL ON TABLE group_mapping TO ndb_writers;


--
-- Name: groups; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE groups FROM PUBLIC;
REVOKE ALL ON TABLE groups FROM ndbadm;
GRANT ALL ON TABLE groups TO ndbadm;
GRANT SELECT ON TABLE groups TO ndb_readers;
GRANT ALL ON TABLE groups TO ndb_writers;


--
-- Name: groups_group_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE groups_group_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE groups_group_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE groups_group_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE groups_group_id_seq TO ndb_writers;


--
-- Name: hosts; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE hosts FROM PUBLIC;
REVOKE ALL ON TABLE hosts FROM ndbadm;
GRANT ALL ON TABLE hosts TO ndbadm;
GRANT SELECT ON TABLE hosts TO ndb_readers;
GRANT ALL ON TABLE hosts TO ndb_writers;


--
-- Name: hosts_host_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE hosts_host_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE hosts_host_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE hosts_host_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE hosts_host_id_seq TO ndb_writers;


--
-- Name: permissions; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE permissions FROM PUBLIC;
REVOKE ALL ON TABLE permissions FROM ndbadm;
GRANT ALL ON TABLE permissions TO ndbadm;
GRANT ALL ON TABLE permissions TO ndb_writers;
GRANT SELECT ON TABLE permissions TO ndb_readers;

--
-- Name: post_target_types; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE post_target_types FROM PUBLIC;
REVOKE ALL ON TABLE post_target_types FROM ndbadm;
GRANT ALL ON TABLE post_target_types TO ndbadm;
GRANT SELECT ON TABLE post_target_types TO ndb_readers;
GRANT ALL ON TABLE post_target_types TO ndb_writers;


--
-- Name: post_target_types_target_type_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE post_target_types_target_type_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE post_target_types_target_type_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE post_target_types_target_type_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE post_target_types_target_type_id_seq TO ndb_writers;


--
-- Name: sensor_clusters; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE sensor_clusters FROM PUBLIC;
REVOKE ALL ON TABLE sensor_clusters FROM ndbadm;
GRANT ALL ON TABLE sensor_clusters TO ndbadm;
GRANT SELECT ON TABLE sensor_clusters TO ndb_readers;
GRANT ALL ON TABLE sensor_clusters TO ndb_writers;


--
-- Name: statistics; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE statistics FROM PUBLIC;
REVOKE ALL ON TABLE statistics FROM ndbadm;
GRANT ALL ON TABLE statistics TO ndbadm;
GRANT SELECT ON TABLE statistics TO ndb_readers;
GRANT ALL ON TABLE statistics TO ndb_writers;


--
-- Name: statistics_stat_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE statistics_stat_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE statistics_stat_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE statistics_stat_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE statistics_stat_id_seq TO ndb_writers;


--
-- Name: struct_types; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE struct_types FROM PUBLIC;
REVOKE ALL ON TABLE struct_types FROM ndbadm;
GRANT ALL ON TABLE struct_types TO ndbadm;
GRANT SELECT ON TABLE struct_types TO ndb_readers;
GRANT ALL ON TABLE struct_types TO ndb_writers;


--
-- Name: struct_types_type_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE struct_types_type_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE struct_types_type_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE struct_types_type_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE struct_types_type_id_seq TO ndb_writers;


--
-- Name: structs; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE structs FROM PUBLIC;
REVOKE ALL ON TABLE structs FROM ndbadm;
GRANT ALL ON TABLE structs TO ndbadm;
GRANT SELECT ON TABLE structs TO ndb_readers;
GRANT ALL ON TABLE structs TO ndb_writers;


--
-- Name: structs_struct_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE structs_struct_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE structs_struct_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE structs_struct_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE structs_struct_id_seq TO ndb_writers;


--
-- Name: subsystems; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE subsystems FROM PUBLIC;
REVOKE ALL ON TABLE subsystems FROM ndbadm;
GRANT ALL ON TABLE subsystems TO ndbadm;
GRANT SELECT ON TABLE subsystems TO ndb_readers;
GRANT ALL ON TABLE subsystems TO ndb_writers;


--
-- Name: subsystems_subsystem_id_seq; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE subsystems_subsystem_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subsystems_subsystem_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE subsystems_subsystem_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE subsystems_subsystem_id_seq TO ndb_writers;

--
-- Name: param; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE param FROM PUBLIC;
REVOKE ALL ON TABLE param FROM ndbadm;
GRANT ALL ON TABLE param TO ndbadm;
GRANT SELECT ON TABLE param TO ndb_readers;
GRANT ALL ON TABLE param TO ndb_writers;
GRANT ALL ON TABLE param TO nms;

--
-- Name: mitigation; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE mitigation FROM PUBLIC;
REVOKE ALL ON TABLE mitigation FROM ndbadm;
GRANT ALL ON TABLE mitigation TO ndbadm;
GRANT SELECT ON TABLE mitigation TO ndb_readers;
GRANT ALL ON TABLE mitigation TO ndb_writers;
GRANT ALL ON TABLE mitigation TO nms;

--
-- Name: smtp; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE smtp FROM PUBLIC;
REVOKE ALL ON TABLE smtp FROM ndbadm;
GRANT ALL ON TABLE smtp TO ndbadm;
GRANT SELECT ON TABLE smtp TO ndb_readers;
GRANT ALL ON TABLE smtp TO ndb_writers;
GRANT ALL ON TABLE smtp TO nms;

--
-- Name: pattern_analysis_config; Type: ACL; Schema: public; Owner: ndbadm
--

REVOKE ALL ON TABLE pattern_analysis_config FROM PUBLIC;
REVOKE ALL ON TABLE pattern_analysis_config FROM ndbadm;
GRANT ALL ON TABLE pattern_analysis_config TO ndbadm;
GRANT SELECT ON TABLE pattern_analysis_config TO ndb_readers;
GRANT ALL ON TABLE pattern_analysis_config TO ndb_writers;
GRANT ALL ON TABLE pattern_analysis_config TO nms;


SET search_path = purge, pg_catalog;

--
-- Name: dbstate; Type: ACL; Schema: purge; Owner: ndbadm
--

REVOKE ALL ON TABLE dbstate FROM PUBLIC;
REVOKE ALL ON TABLE dbstate FROM ndbadm;
GRANT ALL ON TABLE dbstate TO ndbadm;
GRANT SELECT ON TABLE dbstate TO ndb_readers;
GRANT SELECT ON TABLE dbstate TO ndb_writers;


--
-- Name: history; Type: ACL; Schema: purge; Owner: ndbadm
--

REVOKE ALL ON TABLE history FROM PUBLIC;
REVOKE ALL ON TABLE history FROM ndbadm;
GRANT ALL ON TABLE history TO ndbadm;
GRANT SELECT ON TABLE history TO ndb_readers;
GRANT SELECT ON TABLE history TO ndb_writers;


--
-- Name: jobs; Type: ACL; Schema: purge; Owner: ndbadm
--

REVOKE ALL ON TABLE jobs FROM PUBLIC;
REVOKE ALL ON TABLE jobs FROM ndbadm;
GRANT ALL ON TABLE jobs TO ndbadm;
GRANT SELECT ON TABLE jobs TO ndb_readers;
GRANT SELECT ON TABLE jobs TO ndb_writers;
GRANT ALL ON TABLE jobs TO nms;


--
-- Name: relstate; Type: ACL; Schema: purge; Owner: ndbadm
--

REVOKE ALL ON TABLE relstate FROM PUBLIC;
REVOKE ALL ON TABLE relstate FROM ndbadm;
GRANT ALL ON TABLE relstate TO ndbadm;
GRANT SELECT ON TABLE relstate TO ndb_readers;
GRANT SELECT ON TABLE relstate TO ndb_writers;


SET search_path = quarantine, pg_catalog;

--
-- Name: captures_capture_id_seq; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE captures_capture_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE captures_capture_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE captures_capture_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE captures_capture_id_seq TO ndb_writers;


--
-- Name: event_types; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON TABLE event_types FROM PUBLIC;
REVOKE ALL ON TABLE event_types FROM ndbadm;
GRANT ALL ON TABLE event_types TO ndbadm;
GRANT SELECT ON TABLE event_types TO ndb_readers;
GRANT ALL ON TABLE event_types TO ndb_writers;


--
-- Name: event_types_type_id_seq; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE event_types_type_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE event_types_type_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE event_types_type_id_seq TO ndbadm;
GRANT ALL ON SEQUENCE event_types_type_id_seq TO ndb_writers;


--
-- Name: events; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON TABLE events FROM PUBLIC;
REVOKE ALL ON TABLE events FROM ndbadm;
GRANT ALL ON TABLE events TO ndbadm;
GRANT SELECT ON TABLE events TO ndb_readers;
GRANT ALL ON TABLE events TO ndb_writers;


--
-- Name: importance; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON TABLE importance FROM PUBLIC;
REVOKE ALL ON TABLE importance FROM ndbadm;
GRANT ALL ON TABLE importance TO ndbadm;
GRANT SELECT ON TABLE importance TO ndb_readers;
GRANT SELECT ON TABLE importance TO ndb_writers;


--
-- Name: matches; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON TABLE matches FROM PUBLIC;
REVOKE ALL ON TABLE matches FROM ndbadm;
GRANT ALL ON TABLE matches TO ndbadm;
GRANT SELECT ON TABLE matches TO ndb_readers;
GRANT ALL ON TABLE matches TO ndb_writers;


--
-- Name: samples; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON TABLE samples FROM PUBLIC;
REVOKE ALL ON TABLE samples FROM ndbadm;
GRANT ALL ON TABLE samples TO ndbadm;
GRANT SELECT ON TABLE samples TO ndb_readers;
GRANT ALL ON TABLE samples TO ndb_writers;


--
-- Name: sources; Type: ACL; Schema: quarantine; Owner: ndbadm
--

REVOKE ALL ON TABLE sources FROM PUBLIC;
REVOKE ALL ON TABLE sources FROM ndbadm;
GRANT ALL ON TABLE sources TO ndbadm;
GRANT SELECT ON TABLE sources TO ndb_readers;
GRANT ALL ON TABLE sources TO ndb_writers;


SET search_path = report, pg_catalog;

--
-- Name: list; Type: ACL; Schema: report; Owner: ndbadm
--

REVOKE ALL ON TABLE list FROM PUBLIC;
REVOKE ALL ON TABLE list FROM ndbadm;
GRANT ALL ON TABLE list TO ndbadm;
GRANT SELECT ON TABLE list TO ndb_readers;
GRANT ALL ON TABLE list TO ndb_writers;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE list TO nms;


--
-- Name: list_report_id_seq; Type: ACL; Schema: report; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE list_report_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE list_report_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE list_report_id_seq TO ndbadm;
GRANT USAGE ON SEQUENCE list_report_id_seq TO ndb_writers;
GRANT USAGE ON SEQUENCE list_report_id_seq TO nms;


--
-- Name: mail; Type: ACL; Schema: report; Owner: ndbadm
--

REVOKE ALL ON TABLE mail FROM PUBLIC;
REVOKE ALL ON TABLE mail FROM ndbadm;
GRANT ALL ON TABLE mail TO ndbadm;
GRANT SELECT ON TABLE mail TO ndb_readers;
GRANT ALL ON TABLE mail TO ndb_writers;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE mail TO nms;


--
-- Name: views; Type: ACL; Schema: report; Owner: ndbadm
--

REVOKE ALL ON TABLE views FROM PUBLIC;
REVOKE ALL ON TABLE views FROM ndbadm;
GRANT ALL ON TABLE views TO ndbadm;
GRANT SELECT ON TABLE views TO ndb_readers;
GRANT ALL ON TABLE views TO ndb_writers;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE views TO nms;


--
-- Name: views_view_id_seq; Type: ACL; Schema: report; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE views_view_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE views_view_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE views_view_id_seq TO ndbadm;
GRANT USAGE ON SEQUENCE views_view_id_seq TO ndb_writers;
GRANT USAGE ON SEQUENCE views_view_id_seq TO nms;



SET search_path = smp, pg_catalog;

--
-- Name: map; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE map FROM PUBLIC;
REVOKE ALL ON TABLE map FROM ndbadm;
GRANT ALL ON TABLE map TO ndbadm;
GRANT SELECT ON TABLE map TO ndb_readers;
GRANT ALL ON TABLE map TO ndb_writers;


--
-- Name: mtg_live; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_live FROM PUBLIC;
REVOKE ALL ON TABLE mtg_live FROM ndbadm;
GRANT ALL ON TABLE mtg_live TO ndbadm;
GRANT SELECT ON TABLE mtg_live TO ndb_readers;
GRANT ALL ON TABLE mtg_live TO ndb_writers;


--
-- Name: mtg_live_log_past; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_live_log_past FROM PUBLIC;
REVOKE ALL ON TABLE mtg_live_log_past FROM ndbadm;
GRANT ALL ON TABLE mtg_live_log_past TO ndbadm;
GRANT SELECT ON TABLE mtg_live_log_past TO ndb_readers;
GRANT ALL ON TABLE mtg_live_log_past TO ndb_writers;


--
-- Name: mtg_states; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_states FROM PUBLIC;
REVOKE ALL ON TABLE mtg_states FROM ndbadm;
GRANT ALL ON TABLE mtg_states TO ndbadm;
GRANT SELECT ON TABLE mtg_states TO ndb_readers;
GRANT SELECT ON TABLE mtg_states TO ndb_writers;


--
-- Name: mtg_live_log; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_live_log FROM PUBLIC;
REVOKE ALL ON TABLE mtg_live_log FROM ndbadm;
GRANT ALL ON TABLE mtg_live_log TO ndbadm;
GRANT SELECT ON TABLE mtg_live_log TO ndb_readers;
GRANT SELECT ON TABLE mtg_live_log TO ndb_writers;


--
-- Name: mtg_reqs; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_reqs FROM PUBLIC;
REVOKE ALL ON TABLE mtg_reqs FROM ndbadm;
GRANT ALL ON TABLE mtg_reqs TO ndbadm;
GRANT SELECT ON TABLE mtg_reqs TO ndb_readers;
GRANT ALL ON TABLE mtg_reqs TO ndb_writers;


--
-- Name: mtg_reqs_log_past; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_reqs_log_past FROM PUBLIC;
REVOKE ALL ON TABLE mtg_reqs_log_past FROM ndbadm;
GRANT ALL ON TABLE mtg_reqs_log_past TO ndbadm;
GRANT SELECT ON TABLE mtg_reqs_log_past TO ndb_readers;
GRANT ALL ON TABLE mtg_reqs_log_past TO ndb_writers;


--
-- Name: mtg_reqs_log; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE mtg_reqs_log FROM PUBLIC;
REVOKE ALL ON TABLE mtg_reqs_log FROM ndbadm;
GRANT ALL ON TABLE mtg_reqs_log TO ndbadm;
GRANT SELECT ON TABLE mtg_reqs_log TO ndb_readers;
GRANT ALL ON TABLE mtg_reqs_log TO ndb_writers;


--
-- Name: users; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON TABLE users FROM PUBLIC;
REVOKE ALL ON TABLE users FROM ndbadm;
GRANT ALL ON TABLE users TO ndbadm;
GRANT SELECT ON TABLE users TO ndb_readers;
GRANT ALL ON TABLE users TO ndb_writers;


--
-- Name: users_user_id_seq; Type: ACL; Schema: smp; Owner: ndbadm
--

REVOKE ALL ON SEQUENCE users_user_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE users_user_id_seq FROM ndbadm;
GRANT ALL ON SEQUENCE users_user_id_seq TO ndbadm;
GRANT USAGE ON SEQUENCE users_user_id_seq TO ndb_writers;


--
-- PostgreSQL database dump complete
--

\connect postgres

--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE OR REPLACE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

\connect template1

--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: template1; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON DATABASE template1 IS 'default template database';


--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE OR REPLACE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

--
-- PostgreSQL database cluster dump complete
--

-- New(hb) - add SP(functions) for purge mechanism and ...
\connect netx

\i /opt/allot/DB/sql/all_purge_proc.sql
\i /opt/allot/DB/sql/jobs_purge_proc.sql
\i /opt/allot/DB/sql/get_freespace_proc.sql
\i /opt/allot/DB/sql/get_aging_days_proc.sql
\i /opt/allot/DB/sql/get_param_value_proc.sql
\i /opt/allot/DB/sql/stats_data_unload.sql
-- not in use \i /opt/allot/DB/sql/view_attrs_grouped.sql
\i /opt/allot/DB/sql/add_stats_table_proc.sql
\i /opt/allot/DB/sql/add_bgp_tables.sql
\i /opt/allot/DB/sql/add_bgp_global_tables.sql
\i /opt/allot/DB/sql/add_bgp_flowspec_tables.sql
\i /opt/allot/DB/sql/add_top_subnet_tables.sql
\i /opt/allot/DB/sql/add_snapshot_table.sql
\i /opt/allot/DB/sql/trunc_stats_data.sql
\i /opt/allot/DB/sql/add_pattern_match_tolerance.sql
\i /opt/allot/DB/sql/add_audit_log_tables.sql
\i /opt/allot/DB/sql/add_audio_alarms_tables.sql

----
