--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog; 

--
-- Name: plruby; Type: PROCEDURAL LANGUAGE; Schema: public; Owner: postgres
--

CREATE TRUSTED PROCEDURAL LANGUAGE plruby HANDLER plruby_call_handler;


ALTER PROCEDURAL LANGUAGE plruby OWNER TO postgres;

--
-- Name: array_max(anyarray); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION array_max("array" anyarray) RETURNS anyelement
    LANGUAGE plruby IMMUTABLE STRICT
    AS $$array.max$$;


ALTER FUNCTION public.array_max("array" anyarray) OWNER TO ndbadm;

--
-- Name: FUNCTION array_max("array" anyarray); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION array_max("array" anyarray) IS 'Returns the maximum value in the array';


--
-- Name: array_min(anyarray); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION array_min("array" anyarray) RETURNS anyelement
    LANGUAGE plruby IMMUTABLE STRICT
    AS $$array.min$$;


ALTER FUNCTION public.array_min("array" anyarray) OWNER TO ndbadm;

--
-- Name: FUNCTION array_min("array" anyarray); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION array_min("array" anyarray) IS 'Returns the minimum value in the array';


--
-- Name: array_sorted_p(anyarray, boolean, boolean); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION array_sorted_p("array" anyarray, forward boolean, strict boolean) RETURNS boolean
    LANGUAGE plruby IMMUTABLE STRICT
    AS $$
  return true if array.size <= 1

  op = forward ? strict ? :> : :>= : strict ? :< : :<=

  !!array[1..-1].inject(array.first) { |prev, this|
    break unless this.send(op, prev)
    this
  }$$;


ALTER FUNCTION public.array_sorted_p("array" anyarray, forward boolean, strict boolean) OWNER TO ndbadm;

--
-- Name: FUNCTION array_sorted_p("array" anyarray, forward boolean, strict boolean); Type: COMMENT; Schema: public; Owner: ndbadm
--

COMMENT ON FUNCTION array_sorted_p("array" anyarray, forward boolean, strict boolean) IS 'Checks if elements of the array are correctly ordered (forward or backward, strictly or duplicates are allowed)';

--
-- Name: inet_to_int8(inet); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION inet_to_int8(addr inet) RETURNS bigint
    LANGUAGE plruby IMMUTABLE STRICT
    AS $$
	addr.host.split(".").map { |x| x.to_i }.pack("C4").unpack("N").first
$$;


ALTER FUNCTION public.inet_to_int8(addr inet) OWNER TO ndbadm;

--
-- Name: query_stat_data(text, integer[]); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE FUNCTION query_stat_data(tbl text, points integer[]) RETURNS SETOF record
    LANGUAGE plruby
    AS $_$
	colsql = PL::result_name.join(",")
	pos    = 0

	# Generate a prepared query that fetches 8 rows at once
	sql = (1..8).map { |n|
		"(SELECT #{colsql} FROM #{tbl} WHERE timestamp <= $#{n} ORDER BY timestamp DESC LIMIT 1) " +
		" UNION " +
		"(SELECT #{colsql} FROM #{tbl} WHERE timestamp  > $#{n} ORDER BY timestamp ASC  LIMIT 1) "
	}.join(" UNION ")
	p = PL::Plan.new(sql, ["int4"]*8, { "output" => "value" })

	# Round up request to a multiple of 8 points by repeating last data point
	points.push points.last \
		while points.size % 8 != 0
	
	# Run the query until all points have been extracted
	(0 ... points.size).step(8) { |pos|
		p.exec(points[pos,8]) { |row| yield row }
	}
	nil
$_$;


ALTER FUNCTION public.query_stat_data(tbl text, points integer[]) OWNER TO ndbadm;


