--    (c) Copyright 2017, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Unload statistics data from h-schema _stats tables for last N hours into csv-files(file per table); 
--   Input parameters - aging_hour ; unload directory(full path)
--    Example - select stats_data_unload(2,'/opt/allot/tmp/stats_data') 
--    Comments:
--    "@(#)$Id$"



SET search_path=public,pg_catalog;

CREATE OR REPLACE FUNCTION stats_data_unload(aging_hour integer, snapshot_dir text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    host_var INTEGER; 
    name_var     TEXT;
    group_var  INTEGER;
    table_name TEXT;
    file_name  TEXT;
BEGIN    

  FOR host_var,name_var,group_var IN
    SELECT host_id, structs.name, group_id 
    FROM public.data_tables
    JOIN public.structs USING (struct_id)
    WHERE structs.name IN ('_stats')
    ORDER BY 1,2,3
  LOOP
   table_name := 'h' || host_var|| '.' || name_var || group_var ;
   file_name := 'h' || host_var || name_var || '_' || group_var || '.csv';
   EXECUTE 'COPY ( select * from ' || table_name  || ' where to_timestamp(timestamp) > current_timestamp - interval ''' || aging_hour || 'hours'') to ''' || snapshot_dir  || '/' || file_name || ''' csv header' ;
   
  END LOOP;
  
END$_$;