--    (c) Copyright 2020, Allot
--    ALL RIGHTS RESERVED

-- Description: 
-- Clean all statistics data from h-schema _stats tables 
--   
--    Example - select trunc_stats_data() ;


SET search_path=public,pg_catalog;

CREATE OR REPLACE FUNCTION trunc_stats_data() RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
    host_var INTEGER; 
    name_var     TEXT;
    group_var  INTEGER;
    table_name TEXT;
BEGIN    

  FOR host_var,name_var,group_var IN
    SELECT host_id, structs.name, group_id 
    FROM public.data_tables
    JOIN public.structs USING (struct_id)
    WHERE structs.name IN ('_stats')
    ORDER BY 1,2,3
  LOOP
   table_name := 'h' || host_var|| '.' || name_var || group_var ;
   
   EXECUTE 'TRUNCATE TABLE ' || table_name  || ' ' ;
   
  END LOOP;
  
END$_$;

ALTER FUNCTION public.trunc_stats_data() OWNER TO nms;