--    (c) Copyright 2017, Allot Communications
--    ALL RIGHTS RESERVED

-- Description: 
-- Create view based on fast.attrs table - set all attributes in one record 
--
--    Comments:
--    "@(#)$Id$"

SET search_path = fast,pg_catalog;

CREATE OR REPLACE VIEW attrs_grouped
as 
select entity_id, 
            FloodID::INTEGER, created, "from"::INTEGER parent_id, type_id::INTEGER, name type_name, final, error, body, Producer, "Group"::INTEGER, MaxPackets::INTEGER, MaxTime::FLOAT, 
            Source, Stat, "Version", Timeout::FLOAT, Duration::FLOAT, 
            Packets::INTEGER, Bytes::INTEGER, WirePackets::INTEGER, Format::INTEGER, Entries::INTEGER, 
            Patterns::INTEGER, Agent, Flows::INTEGER, Protocols, Pattern, 
            Filter, Sensor::INET, Sensors::INET, Groups::INTEGER 
from (
      (
            select entity_id 
            from fast.attrs
            group by entity_id
      ) id 
      left outer join (select entity_id e1, value FloodID   from fast.attrs where attr_type_id=1) fld on (entity_id=e1)
      left outer join (select entity_id e2, value Producer from fast.attrs where attr_type_id=2) prd on (entity_id=e2)
      left outer join (select entity_id e3, value "Group", value Groups       from fast.attrs where attr_type_id=3) grp on (entity_id=e3)
      left outer join (select entity_id e4, value MaxPackets from fast.attrs where attr_type_id=4) mp on (entity_id=e4)
      left outer join (select entity_id e5, value MaxTime   from fast.attrs where attr_type_id=5) mt on (entity_id=e5)
      left outer join (select entity_id e6, value Source          from fast.attrs where attr_type_id=6) src on (entity_id=e6)
      left outer join (select entity_id e7, value Stat            from fast.attrs where attr_type_id=7) stt on (entity_id=e7)
      left outer join (select entity_id e8, value "Version" from fast.attrs where attr_type_id=8) ver on (entity_id=e8)
      left outer join (select entity_id e9, value Timeout         from fast.attrs where attr_type_id=9) tot on (entity_id=e9)
      left outer join (select entity_id e10, value Duration from fast.attrs where attr_type_id=10) dur on (entity_id=e10)
      left outer join (select entity_id e11, value Packets  from fast.attrs where attr_type_id=11) pkt on (entity_id=e11)
      left outer join (select entity_id e12, value Bytes          from fast.attrs where attr_type_id=12) bts on (entity_id=e12)
      left outer join (select entity_id e13, value WirePackets from fast.attrs where attr_type_id=13) wpk on (entity_id=e13)
      left outer join (select entity_id e14, value Format         from fast.attrs where attr_type_id=14) frm on (entity_id=e14)
      left outer join (select entity_id e15, value Entries  from fast.attrs where attr_type_id=15) ets on (entity_id=e15)
      left outer join (select entity_id e16, value Patterns, value Pattern    from fast.attrs where attr_type_id=16) pts on (entity_id=e16)
      left outer join (select entity_id e17, value Agent          from fast.attrs where attr_type_id=17) agt on (entity_id=e17)
      left outer join (select entity_id e18, value Flows          from fast.attrs where attr_type_id=18) fls on (entity_id=e18)
--   left outer join (select entity_id e17, value Sensors  from fast.attrs where attr_type_id=17) sns on (entity_id=e17)
--   left outer join (select entity_id e18, value Groups         from fast.attrs where attr_type_id=18) gps on (entity_id=e18)
      left outer join (select entity_id e19, value Protocols      from fast.attrs where attr_type_id=19) pcs on (entity_id=e19)
--   left outer join (select entity_id e20, value Pattern  from fast.attrs where attr_type_id=20) ptn on (entity_id=e20)
      left outer join (select entity_id e21, value Filter   from fast.attrs where attr_type_id=21) flt on (entity_id=e21)
      left outer join (select entity_id e22, value Sensor         from fast.attrs where attr_type_id=22) snr on (entity_id=e22)
--   left outer join (select entity_id e23, value Agent          from fast.attrs where attr_type_id=23) agt on (entity_id=e23)
--   left outer join (select entity_id e24, value Flows          from fast.attrs where attr_type_id=24) fls on (entity_id=e24)
      left outer join (select entity_id e23, value Sensors  from fast.attrs where attr_type_id=23) sns on (entity_id=e23)
--   left outer join (select entity_id e24, value Groups         from fast.attrs where attr_type_id=24) gps on (entity_id=e24)
)
left join fast.entity_data using(entity_id)
join fast.types using(type_id)
left join fast.entity_links on ("to"=entity_id);

COMMENT ON VIEW fast.attrs_grouped IS 'attrs fileds converted to table groupd by entity_id with additional data from entity_data, entity_links and types';
COMMENT ON COLUMN fast.attrs_grouped.created IS 'field of entity_data';
COMMENT ON COLUMN fast.attrs_grouped.parent_id IS '"from" field of entity_links';
COMMENT ON COLUMN fast.attrs_grouped.type_id IS 'field of entity_data';
COMMENT ON COLUMN fast.attrs_grouped.type_name IS 'field of types based on type_id';
COMMENT ON COLUMN fast.attrs_grouped.producer IS 'from attrs where attr_type_id=2';
COMMENT ON COLUMN fast.attrs_grouped.final IS 'field of entity_data';
COMMENT ON COLUMN fast.attrs_grouped.error IS 'field of entity_data';
COMMENT ON COLUMN fast.attrs_grouped.body IS 'field of entity_data';

ALTER TABLE fast.attrs_grouped OWNER TO ndbadm;


GRANT ALL ON TABLE fast.attrs_grouped TO ndbadm;
GRANT ALL ON TABLE fast.attrs_grouped TO nms;

