#!/bin/bash
################################################################################
# The scrip will create SPC backup - DB(full or partly) and Configuration file
# 
################################################################################



# ----------------------------------------- #
# Check user - must be root
check_user () {
you=`id -un`
if [ ! "$you" = "root" ] ; then
    echo "Operation should be performed by root user."
    exit 1
fi
}

# ----------------------------------------- #
usage() {
echo "Usage:  $0 [ OPTION ]
    -f, -full    : full DSC DB backup,
    -p, -partly  : partly DSC DB backup,
    -h, -help    : show help message.
"
exit 0
}

# ----------------------------------------- #
show_help () {
echo "The scrip will create DSC backup - DB(full or partly) and Configuration files"
echo
}

# ----------------------------------------- #
check_avail_disk_space () {

FREE_KB=`df -kP /opt/shared | grep -w "/opt" | awk '{print $4}'`
DB_USAGE_KB=`du -sk /opt/shared/PostgreSQL | awk '{print $1}'`

if [ $FREE_KB -lt $DB_USAGE_KB ] ; then
   echo "Error: Backup creation failed. There is not enough disk space."
   exit 1
fi

}

# ----------------------------------------------------------------------
#               MAIN
# ----------------------------------------------------------------------
if [ $# -ne 1 ]; then
    usage
fi

check_user
check_avail_disk_space

case $1 in
  '-f'|'-full')
    mode="full"
     ;;
  '-p'|'-partly')
    mode="partly"
     ;;   
  '-h' | '-help')
    show_help
    usage
     ;;
    *)
    usage
     ;;      
esac

date_str=$( date +"%Y_%m_%d_%H_%M" )

echo "${date_str} Prepare $mode DSC DB backup"

back_dir=DSC_${mode}_backup_${date_str}
dir=/opt/shared/backup/${back_dir}

mkdir -p ${dir}
if [[ $? -ne 0 ]]
then
    echo "Error: problem creating directory $dir"
    exit
fi

#Prepare configuration files backup
mkdir -p ${dir}/dsc/conf
mkdir -p ${dir}/dsc/snapshot
mkdir -p ${dir}/dsc/tomcat/reports

cp -pr /opt/shared/dsc/conf/* ${dir}/dsc/conf > /dev/null 2> /dev/null
cp -pr /opt/shared/dsc/snapshot/* ${dir}/dsc/snapshot > /dev/null 2> /dev/null
cp -pr /opt/allot/tomcat/webapps/webui/reports/* ${dir}/dsc/tomcat/reports > /dev/null 2> /dev/null

#Prepare SPC DB backup 
db_dir=${dir}/db_${mode}
mkdir -p ${db_dir}

if [[ "${mode}" == "full" ]]
then
    #Prepare SPC DB full backup
    /usr/bin/psql -U postgres -d netx -f /opt/allot/DB/sql/drop_checks.sql > /opt/allot/log/db_backup.log 2> /opt/allot/log/db_backup_err.log
    /usr/bin/pg_dump -U postgres -C -c -f ${db_dir}/netx_backup_db.sql netx 
    /usr/bin/psql -U postgres -d netx -f /opt/allot/DB/sql/add_checks.sql >> /opt/allot/log/db_backup.log 2>> /opt/allot/log/db_backup_err.log
else
 if [[ "${mode}" == "partly" ]]
 then    
    #Prepare SPC DB partly backup 
    /usr/bin/pg_dump -U postgres -n 'auth' -n 'notify' -n 'report' -f ${db_dir}/netx_backup_db_schemas.sql netx
    /usr/bin/pg_dump -U postgres -n 'public' -f ${db_dir}/netx_backup_db_public_schema.sql netx
    /usr/bin/pg_dump -U postgres -n 'h*' -s -c -f ${db_dir}/netx_backup_db_host_schemas.sql netx
    /usr/bin/pg_dump -U postgres -t 'smp.map' -c -f ${db_dir}/netx_backup_db_smp_map_table.sql netx
	/usr/bin/pg_dump -U postgres -t 'flood.snapshot' -c -f ${db_dir}/netx_backup_db_flood_snapshot_table.sql netx
	/usr/bin/pg_dump -U postgres -t 'flood.mtg_map' -c -f ${db_dir}/netx_backup_db_flood_mtg_map_table.sql netx
    #Tables notify.filter_targets,notify.type_links need unload additional to prevent errors on restore 
    #due wrong order in full DB dump
    /usr/bin/pg_dump -U postgres -t 'notify.filter_targets' -a -f ${db_dir}/filter_targets_data.sql netx
    /usr/bin/pg_dump -U postgres -t 'notify.type_links' -a -f ${db_dir}/type_links_data.sql netx
 fi 
fi


cd /opt/shared/backup
tar cf ${back_dir}.tar ${back_dir}
gzip -9 ${back_dir}.tar
rm -rf ${back_dir}

date_str=$( date +"%Y_%m_%d_%H_%M" )
echo "${date_str} Backup zip-file - /opt/shared/backup/${back_dir}.tar.gz is ready"


exit 0
#---------------------------------------------------------------------------
#                           END   OF   FILE
#---------------------------------------------------------------------------

