#!/bin/sh

you=`id -un`
if [ ! "$you" = "root" ] ; then
    echo "The script should be run by root user."
    exit 1
fi

if [ -f /etc/profile.d/zallot.sh ] ; then
. /etc/profile.d/zallot.sh
fi

ALLOT_HOME="/opt/allot"
export ALLOT_HOME 
keeper_ini=${ALLOT_HOME}/conf/swKeeper.ini

date_str=$( date +"%Y_%m_%d_%H_%M" )

snap_dir=DSC_snapshot_${date_str}
dir=${ALLOT_HOME}/tmp/${snap_dir}

mode="none"

if [ $# -eq 1 ]; then
   case $1 in
    '-stat')
    mode="stat"
     ;;
       *)
    mode="none"
     ;;      
   esac
fi


top -b -n 1 > ${ALLOT_HOME}/log/top_output.txt
${ALLOT_HOME}/bin/systemStatusData.sh >& ${ALLOT_HOME}/log/systemStatusData.log 

mkdir -p ${dir}
if [[ $? -ne 0 ]]
then
    echo "problem creating directory $dir"
    echo "exiting"
    exit
fi

mkdir -p ${dir}/dsc
mkdir -p ${dir}/dsc/detect_snapshot

cp -p -R ${ALLOT_HOME}/{log,conf}  ${dir}

#SPC specific files
${ALLOT_HOME}/bin/cli <<< $'debug\ndumpConfig\ndumpSensorState\nexit\nexit\n' &> /dev/null
${ALLOT_HOME}/bin/cli <<< $'configure\nshow running-config\nbye\n' > ${ALLOT_HOME}/dsc/dump/running_config
if [ -d ${ALLOT_HOME}/dsc/dump ]; then
    cp -p -R ${ALLOT_HOME}/dsc/dump/ ${dir}/dsc
fi

if [ -d ${ALLOT_HOME}/dsc/conf ]; then
    cp -p -R ${ALLOT_HOME}/dsc/conf/ ${dir}/dsc
fi

## SPC statistics data unload (last 2 hours)
if [[ "${mode}" == "stat" ]]
then
    if [[ ( -d ${ALLOT_HOME}/dsc/snapshot )  && ( "$(ls -A ${ALLOT_HOME}/dsc/snapshot)" ) ]]; then
            cp -p -R ${ALLOT_HOME}/dsc/snapshot/* ${dir}/dsc/detect_snapshot
    fi
	
    mkdir -p ${dir}/dsc/stats_data
    chmod 777 ${dir}/dsc/stats_data
    /usr/bin/psql -U postgres -d netx -c "select public.stats_data_unload(2,'${dir}/dsc/stats_data')"  > /dev/null 2> /dev/null
fi

if [ -f /var/log/ha-log ]; then
    cp -p /var/log/ha-* ${dir}/log
fi

if [ -d /var/lib/pgsql/12/data/pg_log ]; then
    cp -p /var/lib/pgsql/12/data/pg_log/* ${dir}/log
fi

cp ~/.bash_history ${dir}/log/history.txt
if [ -f /var/log/messages ]; then
    cp -p /var/log/messages* ${dir}/log
fi

if [ -d /var/log/sa ]; then
    cp -p -R /var/log/sa ${dir}/log
fi


# More configuration files
FLIST="/etc/hosts /etc/ha.d/ha.cf /var/lib/pacemaker/cib/cib.xml /var/lib/heartbeat/crm/cib.xml /etc/cluster/cluster.conf /var/log/cluster/corosync.log /root/allotlog.txt"
for LF in $FLIST ; do
    if [ -f $LF ]; then
        cp -p $LF ${dir}/log
    fi
done
ip a >& ${dir}/log/ifconfig.out

cd ${ALLOT_HOME}/tmp
tar cf ${snap_dir}.tar ${snap_dir}
gzip -9 ${snap_dir}.tar
rm -rf ${snap_dir}
echo "Snapshot zip-file - ${ALLOT_HOME}/tmp/${snap_dir}.tar.gz is ready"
exit
