#!/bin/sh

#used for netx db upgrade
#Run all SQL-files from directory /opt/allot/upgrade/DB
#SQL file name - <yearmmdd>_<version(15_1_10b01)>_file_num 
#Example - 20170214_15_1_10b02_01 (no more than 99 files for the same date/version)  

log_file=/opt/allot/log/db_upgrade.log
MSIZE=5000000
if [ -e ${log_file} ] ; then
    FILESIZE=`stat -c%s ${log_file}`
else
    FILESIZE=0
fi
if [ $FILESIZE -gt $MSIZE ] ; then
  mv ${log_file} ${log_file}.1
fi

date_line=`date +"%d/%m/%Y %T"`
echo "" >> $log_file
echo "$date_line - NETX DB upgrade started " >> $log_file

ret=0

SQLFILES=/opt/allot/upgrade/DB/*.sql

SQLFILES_COUNT=`ls -l $SQLFILES 2> /dev/null | wc -l`

if [ $SQLFILES_COUNT -eq 0 ] ; then
   echo "$date_line - NETX DB upgrade no files for upgrade processing " >> $log_file
   exit $ret
fi

for F in $SQLFILES 
 do
 
    /opt/allot/bin/psql-exec -f $F
	ret=$?
	
	date_line=`date +"%d/%m/%Y %T"`
	if [ $ret -eq 0 ] ; then
		echo "$date_line - Processing $F finished  " >> $log_file
	else
		echo "$date_line - Processing $F failed  " >> $log_file
		break
	fi	
 
 
 done

date_line=`date +"%d/%m/%Y %T"`
echo "$date_line - NETX DB upgrade finished with status $ret" >> $log_file

exit $ret