#!/usr/bin/python

# Upgrade DB according to upgrade_paths.txt file
# input parameters - dest version (before 15.3.10b08)
# Usage python db_upgrade_process.py <dest_version> (before 15.3.10b08)
# Current usage - python /opt/allot/bin/db_upgrade_process.py 

#Importing the modules
import os
import sys
import ConfigParser
import string
import subprocess
import datetime

def log(msg):
	"""
	Logs a message in the /opt/allot/log/db_upgrade.log file
	"""
	log_file_path = "/opt/allot/log/db_upgrade.log"
	msg = str(msg)
	with open(log_file_path, 'a') as f:
		f.write(msg + "\n")
	print msg
	
def run_command(command):
	"""
	run command in the system
	"""
	exit_code = subprocess.check_call(command, shell=True,stdout=subprocess.PIPE)
	if exit_code:
		raise Exception("Command %s exited with exit code %d." % (command, exit_code))		

if __name__ == '__main__':

	dest_ver_line = open('/opt/allot/upgrade/DB/upgrade_info.txt', 'r').readline()
	entry_name,dest_version = dest_ver_line.split('=')
	dest_version = dest_version.strip()
	#print str('dest_version = {} \n'.format(dest_version))
	path_upd = "/opt/allot/upgrade/DB/"
	log_file_path = "/opt/allot/log/db_upgrade.log"
	old_log_file_path = "/opt/allot/log/db_upgrade.log.1"
	date_str = datetime.datetime.now().strftime("%Y/%m/%d %H:%M:%S")
	
	# get current db upgrade base version for upgrade
	command = "/opt/allot/bin/psql-query -c \"select public.get_str_param('Version','db_upgrade_base')\" "
	start_version = subprocess.check_output(command, shell=True )
	if not str(start_version.strip()):
		ver_line = open('/opt/allot/products/dsc.ver', 'r').readline()
		prod_name,start_version = ver_line.split(' ')
		start_version = string.replace(start_version,'-','b').strip()
		curr_version = start_version
		# insert new entry in PARAM table
		command = '/opt/allot/bin/psql-exec -c  \"INSERT INTO public.param(name,subname,str_val) values(\'Version\',\'db_upgrade_base\',\'{}\')\"'.format(curr_version)
		run_command(command)
	else:
		curr_version = start_version.strip()
	
	#Check log file size and rename to old when size 5M(5000000)
	try:
		log_size = os.stat(log_file_path).st_size
	except OSError:
		log_size = 0

	if log_size > 5000000:
		os.rename(log_file_path,old_log_file_path)
	
	if dest_version not in open('/opt/allot/upgrade/DB/upgrade_paths.txt','r').read():
		log('{} No upgrade to version {} \n'.format(date_str, dest_version))
		sys.exit(1)

	upd_config = ConfigParser.ConfigParser()
	upd_config.read("/opt/allot/upgrade/DB/upgrade_paths.txt")

	result = 0

	log ('{} Upgrade to version {} started'.format(date_str,dest_version))

	while curr_version != dest_version and result == 0:
		try:
			next_version = upd_config.get(curr_version,'NEXT_VERSION')
			#next_version_chng replacement only for compatability with versions before 15.3.10b08
			next_version_chng = string.replace(next_version,'.','_')
			date_str = datetime.datetime.now().strftime("%Y/%m/%d %H:%M:%S")
			log('{} Upgrading from version {} to version {}'.format(date_str, curr_version, next_version))
			sort_list = sorted(os.listdir(path_upd))
			for item in sort_list:
				if next_version_chng not in item:
					continue
				elif '.sql' not in item:
					continue
				else:
					date_str = datetime.datetime.now().strftime("%Y/%m/%d %H:%M:%S")
					item = os.path.join(path_upd, item)
					log('{}   Running {}'.format(date_str, item))
					command = "/opt/allot/bin/psql-exec -f " + item
					try:
						run_command(command)
					except Exception as err:
						log(str(err))
						result = 1
						break	
		except ConfigParser.NoSectionError:
				log('{} No entry for version {}'.format(date_str, curr_version))
				result = 1
				break
		except ConfigParser.NoOptionError:
				log('{} No NEXT_VERSION for version {}'.format(date_str, curr_version))
				result = 1
				break
		curr_version = next_version
		#update param table with current DB version
		command = '/opt/allot/bin/psql-exec -c  \"UPDATE public.param SET str_val=\'{}\' WHERE name=\'Version\' and subname=\'db_upgrade_base\' \"'.format(curr_version)
		run_command(command)
		

	date_str = datetime.datetime.now().strftime("%Y/%m/%d %H:%M:%S")
	if result == 0:	
		log ('{} Upgrade to version {} finished \n'.format(date_str,dest_version))
		sys.exit(0)
	else:
		log ('{} Upgrade to version {} failed \n'.format(date_str,dest_version))
		sys.exit(1)

