#!/bin/sh

# This script will adjust cache memory values for java 
#    according to host memory size 
# in case of standalone accounting manager installation
INIFILE=/opt/allot/conf/swKeeper.ini

#    memory size - Gb
     JMEMORY=(   "2"     "3"     "4"     "6"     "8"    "12"    "24"    "32"    "48"    "64"    "128"    "256"    "512"   "1024")
         XMS=("1024"  "1792"  "2560"  "3456"  "5120"  "9216" "18432" "24576" "38912" "52224" "104448" "208896" "418816" "838656")
         XMX=("1280"  "2304"  "3328"  "4224"  "5632"  "9728" "19456" "25600" "40960" "55296" "110592" "222208" "445440" "890880")
 MAXPERMSIZE=( "192"   "192"   "192"   "256"   "256"   "256"   "256"   "256"   "256"   "256"    "256"    "256"    "256"    "256")

# Get memory size from /proc/meminfo file
mem_size=`cat /proc/meminfo | grep MemTotal | cut -d ':' -f2 | sed 's/kB//' | sed 's/ //g'`
# Convert to Gb
let jmemg=$mem_size/1000000

java_bit=_64
# Get memory array index for Java
jmem=0
let length=${#JMEMORY[@]}-1
until  [ $jmem -ge $length ] || [ ${JMEMORY[$jmem+1]} -gt $jmemg ] 
    do
        let jmem+=1
    done

xms=${XMS[jmem]}
xmx=${XMX[jmem]}
maxpermsize=${MAXPERMSIZE[jmem]}
permsize=$maxpermsize

#change INIFILE
sed -i "/spcontroller/ s/Xms[1-9][0-9]*/Xms${xms}/; /spcontroller/ s/Xmx[1-9][0-9]*/Xmx${xmx}/" $INIFILE
sed -i "/spcontroller/ s/MaxMetaspaceSize=[1-9][0-9]*/MaxMetaspaceSize=${maxpermsize}/" $INIFILE
sed -i "/spcontroller/ s/:MetaspaceSize=[1-9][0-9]*/:MetaspaceSize=${permsize}/" $INIFILE
