%w(HUP INT TERM).each { |sig| trap sig, 'EXIT' }

require 'optparse'

# {{{1 Fix Array.to_s in Ruby1.9.1.
# Ruby1.9.1 Array.to_s yields "[]" on an empty array, while Ruby1.8 used to
# yield "". The code of filters might be rewritten to only interpolate non-empty
# arrays (and that would be cleaner), but I'm not going to do it now.
class Array
  def to_s;	      empty? ? '' : super				     end
end
# }}}1

@opts = nil

def parse_opts(argv, vars)
  @opts ||= OptionParser.new do |opts|
    opts.banner = "#{$0} [options]"

    opts.on("-e",
      "end each output entry with an empty line") { |arg|
	vars[:empty_line] = arg
      }.on("-n=NAME", "firewall rule name") { |arg|
	vars[:name] = arg
      }.on("-s", "--src=IP1,IP2",
        "list of source IPs", Array) { |arg|
	  vars[:src_ips] = arg
      }.on("-d", "--dst=IP1,IP2",
        "list of destination IPs", Array) { |arg|
	  vars[:dst_ips] = arg
      }.on("-h", "--help", "print help") {
	puts opts.to_s
	exit 0
      }
  end

  @opts.parse!(argv)
end


def do_format(maxLayer=nil)
  vars = {}
  parse_opts(ARGV, vars)
  $stdin.each_line do |ptext|
    if ptext[0] == ?-
      vars.clear
      ptext.chop!
      parse_opts(ptext.split(':'), vars)
      next
    end

    begin
      p = Pattern.parse(ptext, maxLayer)
      result = format_pattern(p, vars[:name],
	vars[:src_ips], vars[:dst_ips]) || ''
      result << (vars[:empty_line] ? "\n" : '') << "\n"
      $stdout.syswrite result
    rescue
      puts "Error while processing this pattern:", ptext
      raise $!
    end
  end
end

#make libs visible
$:.insert(-2, '/usr/lib/ruby/1.8/filtergen2')
$:.insert(-2, File.dirname(File.expand_path($0)))
