def purify_name(name)
  return nil if !name || name.size == 0
  name = name[0..63] if name.size > 64
  name = name.downcase.gsub(/[^a-z0-9]/, '_')
  name[0] = '_' if name =~ /^\d/
  name
end

def add_cidr(bytes, bytes_to_mask=3)
  return nil unless bytes[0]
  octets = [0, 0, 0, 0]; i = 0
  bytes.each{|b|
    break unless b
    octets[i] = b
    i += 1
  }
  ip = octets.join('.')
  ip << "/#{i*8}" if i < bytes_to_mask+1
  ip
end

# Format an array of IPs like [ip1,ip2].
def bracket_ips(ips)
  ips.map!{|ip| ip << '/32'}
  if ips.size > 1
    return '[' << ips.join(',') << ']'
  else
    return ips.first
  end
end

def find_ranges payload, baseOffset, payloadSize, payloadBytes, maxItems
  # Find out consecutive byte ranges, generate one entry per range.
  offsets = payload.layer.keys
  offsets = offsets.find_all { |k| k < payloadSize } if payloadSize
  offsets.sort!
  offsets = offsets[0..payloadBytes-1] if payloadBytes

  last = nil
  ohash = {}
  offsets.each { |key|
    if !last
      ohash[key] = last = key
      next
    end

    if ohash[last] + 1 == key
      ohash[last] = key
    else
      ohash[key] = last = key
    end
  }
  # Reduce number of separate parts within payload. A part removed from head
  # or from tail, whichever has smaller size.
  if maxItems
    items = ohash.keys.sort
    while ohash.size > maxItems
      if (ohash[items.first] - items.first) < (ohash[items.last] - items.last)
        ohash.delete items.first
	items.shift
      else
        ohash.delete items.last
	items.pop
      end
    end
  end
  ohash
end

# Cloudshield REGEX support.
def fmt_payload_regex(payload, baseOffset=0, payloadSize=nil,
    payloadBytes=nil, maxItems=nil)
  ranges = []
  ohash = find_ranges(payload, baseOffset, payloadSize, payloadBytes, maxItems)
  ohash.keys.sort.each { |k|
    s = ""
    k.upto(ohash[k]) { |i| s << "\\x%.2x" % [payload.layer[i]] }
    ranges.push s
  }
  "content: REGEX:.*?#{ranges.join('.*?')};"
end

# Same code for Fortinet and Snort.
def fmt_payload(payload, entry_prefix, entry_suffix, baseOffset=0,
    payloadSize=nil, payloadBytes=nil, maxItems=nil)
  s = ""

  ohash = find_ranges(payload, baseOffset, payloadSize, payloadBytes, maxItems)
  ohash.keys.sort.each { |k|
    s << "#{entry_prefix} \"|"
    # Add hex values.
    bytes = []
    k.upto(ohash[k]) { |i| bytes << "%.2x" % [payload.layer[i]] }
    s << bytes.join(' ') << \
      "|\"; offset: #{k + baseOffset}; depth: #{bytes.size}; " \
      "#{entry_suffix}; "
  }
  s
end
