#!/bin/sh
# This script will adjust shared_buffers(cache memory) values for postgresql DB
# according to host memory size 
# (change will done in file postgresql.conf ) 
# shared_buffers values range between 512MB to 8192MB

#CONFFILE=/var/lib/pgsql/9.0/data/postgresql.conf
CONFFILE=/var/lib/pgsql/12/data/postgresql.conf
# Get memory size from /proc/meminfo file
mem_size=`cat /proc/meminfo | grep MemTotal | awk '{print $2}'`
##echo "mem_size=$mem_size "

# Convert to MB
let mem_mb=$mem_size/1024
##echo "mem_mb=$mem_mb "

#Calculate shared_buffers value as 5% of memory in range between 512MB to 8092MB
let sh_buf=(mem_mb/100)*5
##echo "sh_buf=$sh_buf"

if [ $sh_buf -lt 512 ] ; then
     sh_buf=512
fi

if [ $sh_buf -gt 8192 ] ; then
     sh_buf=8092
fi
##echo "sh_buf_adjst=$sh_buf"

#Calculate effective_cache_size value between 1024-4096MB
eff_cache=$sh_buf
if [ $eff_cache -lt 1024 ] ; then
     eff_cache=1024
fi

if [ $eff_cache -gt 4096 ] ; then
     eff_cache=4096
fi
# Change values in postgresql.conf file 
sed -i "s/shared_buffers = [0-9]*MB/shared_buffers = ${sh_buf}MB/" $CONFFILE
sed -i "s/effective_cache_size = [0-9]*MB/effective_cache_size = ${eff_cache}MB/" $CONFFILE
