#!/bin/bash
################################################################################
# The scrip will restore  DSC DB(full or partly) and Configuration file
# from backup directory [/opt/shared/backup/<backup dir name>
# sp services should be stopped
# Netx DB - should be recreated
################################################################################



# ----------------------------------------- #
# Check user - must be root
check_user () {
you=`id -un`
if [ ! "$you" = "root" ] ; then
    echo "Operation should be performed by root user."
    exit 1
fi
}

# ----------------------------------------- #
usage() {
echo "Usage:  $0 [ OPTION ] [ BACKUP DIRECTORY NAME ]
    -f, -full    : full DSC DB restore,
    -p, -partly  : partly DSC DB restore,
    -h, -help    : show help message.
    
    BACKUP DIRECTORY NAME - under /opt/shared/backup directory
    
    Example - restore_netx_db.sh -full DSC_full_backup_2017_08_01_15_55
"
exit 0
}

# ----------------------------------------- #
show_help () {
echo "The scrip will restore DSC backup - DB(full or partly) and Configuration files"
echo
}

# ----------------------------------------- #
check_avail_disk_space () {

FREE_KB=`df -kP /opt/shared | grep -w "/opt" | awk '{print $4}'`
DB_USAGE_KB=`du -sk /opt/shared/backup/$1 | awk '{print $1}'`

if [ $FREE_KB -lt $DB_USAGE_KB ] ; then
   echo "Error: There is not enough disk space for DB restore"
   exit 1
fi

}

# ----------------------------------------------------------------------
#               MAIN
# ----------------------------------------------------------------------
if [ $# -lt 1 ]; then
    usage
fi

check_user

case $1 in
  '-f'|'-full')
    mode="full"
     ;;
  '-p'|'-partly')
    mode="partly"
     ;;   
  '-h' | '-help')
    show_help
    usage
     ;;
    *)
    usage
     ;;      
esac

if [ $# -ne 2 ]; then
    usage
fi

if [ -d /opt/shared/backup/$2 ]; then
   check_avail_disk_space $2
 else
   echo "Error: Directory /opt/shared/backup/$2 not exist"
   exit 1
fi   

date_str=$( date +"%Y_%m_%d_%H_%M" )

echo "${date_str} Restore $mode DSC DB - start "

back_dir=/opt/shared/backup/$2
db_dir=${back_dir}/db_${mode}

# Restore DB
echo "Restarting postgresql service..."
service postgresql-12 restart
sleep 10

# just to prevent permissions problem for postgres user 
cd /opt/allot 

if [[ "${mode}" == "full" ]]
then
    if [ ! -f ${db_dir}/netx_backup_db.sql ]; then
       echo "Error: File ${db_dir}/netx_backup_db.sql not exist - cannot restore full DB"
       exit 1
    fi
    #Restore SPC DB from full backup
    /usr/bin/psql -U postgres -f ${db_dir}/netx_backup_db.sql > /opt/allot/log/db_restore.log 2> /opt/allot/log/db_restore_err.log
	/usr/bin/psql -U postgres -d netx -f /opt/allot/DB/sql/database_permission.sql >> /opt/allot/log/db_restore.log 2>> /opt/allot/log/db_restore_err.log
    /usr/bin/psql -U postgres -d netx -f /opt/allot/DB/sql/add_checks.sql >> /opt/allot/log/db_restore.log 2>> /opt/allot/log/db_restore_err.log
else
 if [[ "${mode}" == "partly" ]]
 then   
    if [ ! -f ${db_dir}/netx_backup_db_schemas.sql ]; then
       echo "Error: File ${db_dir}/netx_backup_db_schemas.sql not exist - cannot restore partly DB"
       exit 1
    fi 
    #Restore SPC DB from partly backup files
	  ## first prepare default schemas to prevent public schema cascade droping influence on other schemas
	 /usr/bin/pg_dump -U postgres -n 'fast' -n 'fgen' -n 'flood' -f ${db_dir}/netx_default_db_schemas_1.sql netx 
	 /usr/bin/pg_dump -U postgres -n 'nx' -n 'purge' -n 'quarantine' -n 'smp' -f ${db_dir}/netx_default_db_schemas_2.sql netx
	  ## now restore 
    /usr/bin/psql -U postgres -d netx -c "DROP SCHEMA public CASCADE " > /dev/null 2> /dev/null
    /usr/bin/psql -U postgres -d netx -c "CREATE SCHEMA public" > /dev/null 2> /dev/null
    /usr/bin/psql -U postgres -d netx -c "ALTER SCHEMA public OWNER TO postgres" > /dev/null 2> /dev/null
    /usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_backup_db_public_schema.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
    /usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_backup_db_host_schemas.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
    /usr/bin/psql -U postgres -d netx -f /opt/allot/DB/sql/drop_schema_cascade.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
    /usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_backup_db_schemas.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
    /usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_default_db_schemas_1.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
	/usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_default_db_schemas_2.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
	/usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_backup_db_smp_map_table.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
	/usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_backup_db_flood_snapshot_table.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
	/usr/bin/psql -U postgres -d netx -f ${db_dir}/netx_backup_db_flood_mtg_map_table.sql > /opt/allot/log/db_restore_partly.log 2> /dev/null
    /usr/bin/psql -U postgres -d netx -f ${db_dir}/filter_targets_data.sql >> /opt/allot/log/db_restore_partly.log 2>> /opt/allot/log/db_restore_partly_err.log 
    /usr/bin/psql -U postgres -d netx -f ${db_dir}/type_links_data.sql >> /opt/allot/log/db_restore_partly.log 2>> /opt/allot/log/db_restore_partly_err.log
 fi 
fi

#Restore Config file
rm -fr /opt/shared/dsc/conf/* > /dev/null 2> /dev/null
cp -pr ${back_dir}/dsc/conf/* /opt/shared/dsc/conf > /dev/null 2> /dev/null
rm -fr /opt/shared/dsc/snapshot/* > /dev/null 2> /dev/null
cp -pr ${back_dir}/dsc/snapshot/* /opt/shared/dsc/snapshot > /dev/null 2> /dev/null
rm -fr /opt/allot/tomcat/webapps/webui/reports > /dev/null 2> /dev/null
cp -pr ${back_dir}/dsc/tomcat/reports /opt/allot/tomcat/webapps/webui/ > /dev/null 2> /dev/null

date_str=$( date +"%Y_%m_%d_%H_%M" )
echo "${date_str} Restore $mode DSC DB - finish "


exit 0
#---------------------------------------------------------------------------
#                           END   OF   FILE
#---------------------------------------------------------------------------

