#!/bin/bash

##################### Constants ################
folderPath="/opt/allot/performace_data"
networkUsageFile="networkUsage.csv"
javaRamFile="actualRam.csv"
javaStatFile="jstat.txt"
diskUsageFile="diskUsage.csv"
cpuUsageFile="cpuMon.csv"

processName="spcontroller.war" #spcontroller.war / datamediation.war
IF=""
resultUnits="Bit" #Byte / Bit
javaPath="/usr/bin" # VM: "/usr/bin", docker: /usr/lib/jvm/java-1.8-openjdk/bin

RXPREV=-1
TXPREV=-1

function INIT()
{
	##################### Initialization ################
	#### Create files
	mkdir $folderPath
	touch $folderPath/$networkUsageFile
	touch $folderPath/$javaRamFile
	touch $folderPath/$javaStatFile
	touch $folderPath/$diskUsageFile
	touch $folderPath/$cpuUsageFile

	#### Network info init
	if [ -z "$IF" ]; then
			IF=`ls -1 /sys/class/net/ | head -1`
	fi

	echo "Listening $IF..."
	cat /dev/null > $folderPath/$networkUsageFile
	if [ "$resultUnits" == "Bit" ]; then
		echo "Time,Rx Bits/Sec,Tx Bits/Sec" >> $folderPath/$networkUsageFile
	else
		echo "Time,Rx Byte/Sec,Tx Byte/Sec" >> $folderPath/$networkUsageFile
	fi

	#### RAM info init
	cat /dev/null > $folderPath/$javaRamFile
	cat /dev/null > $folderPath/$javaStatFile
	echo "Date,actualRAM" > $folderPath/$javaRamFile
	echo "Date  S0C    S1C    S0U    S1U      EC       EU        OC         OU       MC     MU    CCSC   CCSU   YGC     YGCT    FGC    FGCT     GCT " > $javaStatFile

	#### Cpu info init
	cat /dev/null > $folderPath/$diskUsageFile
	cat /dev/null > $folderPath/$cpuUsageFile
	echo "Date","Size","Used","Avail","Use%" >> $folderPath/$diskUsageFile
	echo "Date","Cpu Idle","Cpu Used" >> $folderPath/$cpuUsageFile
}

function MONITOR()
{
	###################### Monitoring ################
	while [ 1 == 1 ] ; do
		date=`date +%y-%m-%d_%H:%M:%S`
		#### Network 
		RX=`cat /sys/class/net/${IF}/statistics/rx_bytes`
		TX=`cat /sys/class/net/${IF}/statistics/tx_bytes`
		if [ $RXPREV -ne -1 ] ; then
			let BWRX=$RX-$RXPREV
			let BWTX=$TX-$TXPREV
			if [ "$resultUnits" == "Bit" ]; then
				let BWRX=$BWRX*8
				let BWTX=$BWTX*8
			fi
			echo $date,$BWRX,$BWTX >> $folderPath/$networkUsageFile
		fi
		RXPREV=$RX
		TXPREV=$TX
		#### RAM 
		pid=`ps ax | grep $processName | grep -v grep | awk '{print $1}'`
		javaStat=`${javaPath}/jstat -gc $pid | tail -n 1`
		S0U=`echo $javaStat | awk '{print $3}' | cut -d "." -f 1`
		S1U=`echo $javaStat | awk '{print $4}' | cut -d "." -f 1`
		EU=`echo $javaStat | awk '{print $6}' | cut -d "." -f 1`
		OU=`echo $javaStat | awk '{print $8}' | cut -d "." -f 1`
		let actualRAM=S0U+S1U+EU+OU
		echo $date,$actualRAM >> $folderPath/$javaRamFile
		echo $date $javaStat >> $folderPath/$javaStatFile
		#### CPU 
		cpuData=`vmstat | tail -n 1 | awk '{printf ("%s,%s", $13, $15)}'`
		cpuIdle=`echo $cpuData | cut -d "," -f 2`
		cpuIdle="$cpuIdle%"
		cpuUsed=`echo $cpuData | cut -d "," -f 1`
		cpuUsed="$cpuUsed%"
		echo $date,$cpuIdle,$cpuUsed >> $folderPath/$cpuUsageFile
		#### Disc
		size=`df -k | grep opt | awk '{print $2}' | head -n 1`
		used=`df -k | grep opt | awk '{print $3}' | head -n 1`
		avail=`df -k | grep opt | awk '{print $4}' | head -n 1`
		use=`df -k | grep opt | awk '{print $5}' | head -n 1`
		echo $date,$size,$used,$avail,$use >> $folderPath/$diskUsageFile
		
		sleep 1
	done
}

# Main loop collecting arguments.
while (("$#")); do
  case $1 in
  -dsc)
    processName="spcontroller.war"
    ;;
  -dm)
    processName="datamediation.war"
    ;;
  -vm)
    javaPath="/usr/bin" 
    ;;
  -docker)
    javaPath="/usr/lib/jvm/java-1.8-openjdk/bin"
    ;;
  -bit)
    resultUnits="Bit"
    ;;
  -byte)
    resultUnits="Byte"
    ;;
  -nic)
    IF=$2
	shift
    ;;
  *)
    ;;
  esac
  shift # Move to next argument
done

INIT
MONITOR