#!/bin/bash
# Gather system information, can e.g. be sent to | mail in a cronjob
TEMP_FILE=/tmp/lopfile 

siheader() {
        echo
        echo "======================== header ======================================="
        echo -e "* System statistics for: \t`hostname`"
        echo -e "* dnsdomainname:\t`dnsdomainname`"
        echo -e "* Generated on: \t\t`date`"
        echo -e "* Running as: \t\t\t`whoami`"
        echo
}

fuptime() {
        upSeconds=$(cat /proc/uptime | tr "." " " | awk '{print $1}')
        secs=$((${upSeconds}%60))
        mins=$((${upSeconds}/60%60))
        hours=$((${upSeconds}/3600/24))
        days=$((${upSeconds}/86400))
        if [ "${days}" -ne "0" ]
        then
                echo -n "${days} days, "
        fi
        echo "`printf '%02d' ${hours}`:`printf '%02d' ${mins}`:`printf '%02d' ${secs}`"
}

siuptime() {
        echo
        echo "=================== uptime ====================================="
        echo -e "* Uptime: \t\t\t`fuptime`"
        if [ -x /usr/bin/uprecords ];
        then
                echo -e "* High score: \t\t\t`uprecords | tail -n1 | cut -d'|' -f1 | cut -d'n' -f3 | sed 's/^[[:blank:]]*//'`"
        fi
        echo -e "* Load average 1,5,15 min: \t`cat /proc/loadavg | head -c14`"
        echo
		echo -e "No of Cores: \t\t\t`cat /proc/cpuinfo | grep processor | wc -l`"
		echo
}

sivmstat () {
        echo
        echo "=================== vmstat   =============" 
        vmstat 1 5
		echo
}

fw () {
        OFS=${IFS}
        IFS=$'\n'
        CNT=$(echo `w | wc -l`-1 | bc)

        w | tail -n ${CNT} | while read -r a;
        do
                echo -e "\t${a}"
        done

        IFS=${OFS}
}

siusers() {
        echo
        echo "=================== users ======================================"
        echo -e "\n* Active users: \t\t`who | wc -l`"
        echo -e "\n* User information"
        fw
        echo
}

fpstree() {
        OFS=${IFS}
        IFS=$'\n'
        pstree | while read -r a;
        do
                echo -e "\t${a}"
        done
        IFS=${OFS}
}

fcomms() {
        ps -eo comm | sort | uniq | grep -v ^COMMAND | column
        echo

        IFS=${OFS}
}

fprocs() {
        echo
        echo "=================== fprocs ======================================"
        echo `TERM=Linux top -n1 -b | grep "Tasks" | awk '{print $4,$6,$8,$10}'`
        echo -e "==================================Tasks process and memory utilization=============================\n"
		echo "`top -n1 -b`"
		echo

}

sitasks() {
        echo
        echo "=================== tasks ======================================"
        echo -e "\n* Number of running tasks: \t$(echo `ps ax | wc -l` - 1 | bc)"
        #This fucks up the email
        echo -e "\n* PS Tree:"
        fpstree
		#
        echo -e "\n* Running programs:"
        fcomms
        echo -e "\n* CPU load: \t\t\t`TERM=linux top -n2 -b | grep 'Cpu' | tail -n1 | awk '{print $2+$4+$6}'`%"
        PROCS=`TERM=Linux top -n1 -b | grep "Tasks" | awk '{print $4,$6,$8,$10}'`
        echo -e "\n* Process state:"
        echo -e "\tRunning: \t\t`echo ${PROCS} | awk '{print $1}'`"
        echo -e "\tSleeping: \t\t`echo ${PROCS} | awk '{print $2}'`"
        echo -e "\tZombie: \t\t`echo ${PROCS} | awk '{print $3}'`"
        echo -e "\tStopped: \t\t`echo ${PROCS} | awk '{print $4}'`"
        echo
}

froute() {
        OFS=${IFS}
        IFS=$'\n'
        CNT=$(echo `/sbin/route | wc -l` - 1 | bc)
        /sbin/route | tail -n ${CNT} | while read -r a;
        do
                echo -e "\t${a}"
        done
        IFS=${OFS}
}

sinetwork() {
        echo
        echo "=================== network ================================"
        echo "* Routing table:"
        froute
        echo
        echo -e "\nNTP Info:\n`ntpq -p`\n"
        echo -e "Ifconfig:\n`ifconfig`"
	 echo
	 echo -e "Ifconfig -a:\n`ifconfig -a`"
        echo
        echo -e  "* Open Network Ports: \n `netstat -anp`"
        echo -e  "* Open Network Ports Link to service : \n `lsof -i`"
        echo
}

simemory() {
        echo
        echo "=================== memory ===================================="
        RAMTOTAL=`echo $(($(cat /proc/meminfo | grep MemTotal | awk '{print $2}')/1024))`
        echo -e "\n* Ram:\t free of ${RAMTOTAL}Mb"
	 echo -e "Free -m : `free -m`" 
        echo
}

sidiskstats() {
        echo
        echo "=================== diskstats ================================="
        echo -e "Disk partition:\n 'fdisk -l | grep Disk'"
	 echo -e "Disk  used:\n '	df -h'"
        echo "* Disk Information:"
        OFS=${IFS}
        IFS=$'\n'
        df -h | grep -v ^none | while read -r a;
        do
                echo -e "\t${a}"
        done
        IFS=${OFS}
        echo
        echo "* Mounts:"
        OFS=${IFS}
        IFS=$'\n'
        mount | while read -r a;
        do
                echo -e "\t${a}"
        done
        IFS=${OFS}
        echo
}

simd5() {
        if [ ! -e md5sums.lst ];
        then
                return
        fi

        echo "=================== MD5Sum Check =============================="

        OFS=${IFS}
        IFS=$'\n'

        echo -e "\n* Checking MD5 Sums"

        cat md5sums.lst | grep "^/" | while read -r a;
        do
                F=`echo ${a} | cut -d':' -f1`
                S=`echo ${a} | cut -d':' -f2`
                S2=`md5sum ${F} | cut -d' ' -f1`
                echo -n -e "\t${F}: \t\t\t\t"
                if [ "${S}" = "${S2}" ];
                then
                        echo "[OK]"
                else
                        echo "[INVALID]"
                fi                        
        done

        IFS=${OFS}
        echo
}

cpuinfo() {
	##For finding CPU model, cores and 
    echo
    #echo "=================== CPU Details for Xen =============================="
    #echo -e "CPU Details: \n`cat /proc/cpuinfo | sed -n '1,/^$/p'`"
    #echo -e "No of Cores: \n`cat /proc/cpuinfo | grep processor | wc -l`"
    if [ "egrep '(vmx|svm)' /proc/cpuinfo >/dev/null 2>/dev/null" ];
    then
        echo -e "\n===============================================================\nServer supports Full-virtualization"
    else
        echo -e "\n===============================================================\nEither server does not support Full-virtualization or it is turned off in BIOS"
    fi

    if [ "egrep 'pae' /proc/cpuinfo >/dev/null 2>/dev/null" ];
    then
        echo -e "\n===============================================================\nServer supports Para-virtualization"
    else
        echo -e "\n===============================================================\nServer does not support Para-virtualization"
    fi
    echo
}

diskinfo() {
		##For disk info
        echo
        echo "=================== Disk usage =============================="
        echo -e "Disk Usage details: \n`df -h`"
		echo
}   

distroinfo() {
		##Distro info
        echo
        echo "=================== Distro Info =============================="
        if [ -f /usr/bin/lsb_release ] ; then
        	echo -e "Distro details: \n`lsb_release -a`"
        fi	
        echo -e "Kernel details: \n`uname -a`"
		echo
}   

deviceinfo() {
        echo
        echo "=================== Device Info =============================="
        ##echo -e "Server : \n`dmidecode |grep -A 7 "Product Name: System"`"
        echo  -e "Server : \n`dmidecode | grep -i name`"
        echo -e "\nDevice details: \n`lspci -v`"
		echo "===="
        #echo -e "\nKernel details: \n`uname -a`"
		#echo "===="
        #echo -e "\nHD     details: \n`df -h `"
		#echo "===="
        echo -e "\nulimit details: \n`ulimit -a `"
		echo "===="
        echo

}   

spc_information(){
        echo
        echo "=================== DSC Information  ========================="
        echo -e "\nDSC load       : `rpm -q dsc`\n"
        echo -e "\nDSC NETX DB size       : `du -sh /opt/shared/PostgreSQL`\n"
        echo -e "\nJava version  : "
        java -version 2>&1 | tee  $TEMP_FILE
        echo -e "\nLONG_BIT: `getconf LONG_BIT`\n"
 
		echo
}

redhat_release(){
		echo
        echo "=================== redhat-release Information  =============="
        echo -e "OS release    : \n`cat /etc/redhat-release`"
		echo
} 

cpu_mem_information(){
		echo
        echo "=================== memory and cpi Information  =============="
        echo -e "\nMemory Info   : \n`cat  /proc/meminfo`"
		echo "====="
        echo -e "\nProcess Info  : \n`cat  /proc/cpuinfo`"
		echo "====="
		echo
}

Application_Insalled () {
		echo
        echo "=================== Application List Installed   ============="
        echo -e "\nApplication List  : \n`service --status-all`"
        sleep 3 
        echo -e "\nChkconfig     : \n`chkconfig --list`"
		echo
}


jstatus() {
		echo
	echo "============================== Jstat  ========================"
    PID=`keeperMgr -l | grep ddoscontroller | awk '{print $3}'`
	
	    echo "*******jstack :*******"
	    jstack $PID 2>/dev/null
	    echo "*******jstack -F : ******"
	    jstack -F $PID 2>/dev/null
	    echo "*******jstat : ******"
	    jstat -gc $PID 1000 5 2>/dev/null

}
summary() {
        siheader
	    sivmstat
        siusers
        sitasks
        siuptime
        sinetwork
        simemory
        sidiskstats
        simd5
        deviceinfo
        cpuinfo
        distroinfo
        cpu_mem_information
##        Application_Insalled 
        spc_information
        redhat_release
##        jstatus
}

summary

