#!/bin/bash

############### Constat #####################
snmpConfigFilePath=/etc/snmp/snmpd.conf
v3Trapses="trapsess -v 3"
authNoPriv="-u MD5 -a MD5 -A MD5UserAuthPassword12 -l authNoPriv"

function USAGE ()
{
    echo ""
    echo "USAGE: "
    echo "    $0 IPv4/IPv6 "
    echo ""
    echo "OPTIONS:"
        echo "    4   - Add Ipv4 trap target"
    echo "    6   - Add Ipv6 trap target"
    echo "    -h  help"
    echo ""
    exit $E_OPTERROR    # Exit and explain usage, if no argument(s) given.
}

if [ -z "$1" ]
        then USAGE
else
        while getopts ":46" opt
        do
                case $opt in
                        4 )
                                ip -4 route get $2/32 >/dev/null 2>&1
                                ret=$?
                                if [ $ret -eq 0 ] ; then
                                        trapTraget="$v3Trapses $authNoPriv $2:162"
                                        sed -i '/trapsess/d' /etc/snmp/snmpd.conf
                                        echo $trapTraget >> $snmpConfigFilePath
                                        service snmpd stop > /dev/null 2>&1
                                        sleep 5
                                        service snmpd start > /dev/null 2>&1
                                fi
                                exit 1 ;;
                        6 )
                                ip -6 route get $2/128 >/dev/null 2>&1
                                ret=$?
                                if [ $ret -eq 0 ] ; then
                                        trapTraget="$v3Trapses $authNoPriv udp6:[$2]:162"
                                        sed -i '/trapsess/d' /etc/snmp/snmpd.conf
                                        echo $trapTraget >> $snmpConfigFilePath
                                        service snmpd stop > /dev/null 2>&1
                                        sleep 5
                                        service snmpd start > /dev/null 2>&1
                                fi
                                exit 1 ;;
                        * ) echo "Unimplemented option chosen."
                                exit 0 ;;
                esac
        done
fi
