#!/bin/bash
################################################################################
# Version: 1.1
# Date: 16/05/2017
# Last update:
# - add interactive choice of multipath device
#  
# Allot DSC HA7 primary setup
# The script creates HA system from the pair of pre-installed DSC servers
# Based on NX/MD HA7 configuration script 
################################################################################
# ----------------------------------------- #
echof () {
  echo "`date +"%d/%m/%Y-%H:%M"` === $*" >> $HASetupLog
  echo "$*"
}
# ----------------------------------------- #
# Check user - must be root
check_user () {
echof ${FUNCNAME[0]}
you=`id -un`
if [ ! "$you" = "root" ] ; then
    echof "Operation should be performed by root user."
    exit 1
fi
}
# ----------------------------------------- #
# check_ip                                  #
# returns 0 - valid ip, 1 -invalid          #
check_ip() {
if [[ ! $1 =~ ^([0-9]{1,3}\.){3}[0-9]{1,3}$ ]] ; then return 1 ; fi
OCTETS=${1//./ }
for ii in $OCTETS; do
    if [ $ii -gt 255 ] ; then
        return 1
    fi
done
return 0
} # check_ip 
# ----------------------------------------- #
# Returns 'y' or 'n' in global ANS
ask_yn () {
while [ 1 ] ; do
    if [ ! -z $2 ] ; then ANS=$2 ; else ANS=y ; fi     # Default - second parameter if defined
    read -ep "$1 (y/n) [$ANS]? " ANS1
    if [ ! -z $ANS1 ] ; then ANS=$ANS1 ; fi 
    if [[ $ANS =~ ^[yn]$ ]] ; then
        break
    else 
        echof "Please asnwer 'y' or 'n'."
    fi
done
} # ask_yn
# ----------------------------------------- #
# Function compares versions given in number-dot notation
# Returns: 0 if $1 = $2
#          1 -  $1 > $2
#          2 -  $1 < $2
#########################
checkver () {
echof ${FUNCNAME[0]}
if [[ $1 == $2 ]]
then
    return 0
fi
local IFS=.
local i ver1=($1) ver2=($2)
# fill empty fields in ver1 with zeros
for ((i=${#ver1[@]}; i<${#ver2[@]}; i++))
do
    ver1[i]=0
done
for ((i=0; i<${#ver1[@]}; i++))
do
    if [[ -z ${ver2[i]} ]]
    then
        # fill empty fields in ver2 with zeros
        ver2[i]=0
    fi
    if ((10#${ver1[i]} > 10#${ver2[i]}))
    then
        return 1
    fi
    if ((10#${ver1[i]} < 10#${ver2[i]}))
    then
        return 2
    fi
done
return 0
} #checkver
# ----------------------------------------- #
### neet function to validate netmask
check_netmask () {
    if [ "$1" = "240.0.0.0" ] || [ "$1" = "248.0.0.0" ] || [ "$1" = "252.0.0.0" ] || [ "$1" = "254.0.0.0" ] || [ "$1" = "255.0.0.0" ]\
    || [ "$1" = "255.128.0.0" ] || [ "$1" = "255.192.0.0" ] || [ "$1" = "255.224.0.0" ] || [ "$1" = "255.240.0.0" ] || [ "$1" = "255.248.0.0" ]\
    || [ "$1" = "255.252.0.0" ] || [ "$1" = "255.254.0.0" ] || [ "$1" = "255.255.0.0" ] || [ "$1" = "255.255.128.0" ] || [ "$1" = "255.255.192.0" ]\
    || [ "$1" = "255.255.224.0" ] || [ "$1" = "255.255.240.0" ] || [ "$1" = "255.255.248.0" ] || [ "$1" = "255.255.252.0" ] || [ "$1" = "255.255.254.0" ]\
    || [ "$1" = "255.255.255.0" ] || [ "$1" = "255.255.255.128" ] || [ "$1" = "255.255.255.128" ] || [ "$1" = "255.255.255.192" ]\
    || [ "$1" = "255.255.255.224" ] || [ "$1" = "255.255.255.240" ] || [ "$1" = "255.255.255.248" ] || [ "$1" = "255.255.255.252" ]\
    || [ "$1" = "255.255.255.255" ]; then    
        return 0
    else
        return 1
    fi
} # check_netmask
# ----------------------------------------- #
LoadIF () { # Initialize variables with current values
    IPADDR="Not-defined"
    NETMASK="Not-defined"
    MASTER="Not-defined"
#    GATEWAY="Not-defined"
    if [ -f $NETWDIR/ifcfg-$1 ] ; then
        source $NETWDIR/ifcfg-$1
    fi
    if [[ "$MASTER" =~ ^bond? ]] ; then
        IPADDR=$MASTER
        if [ -f $NETWDIR/ifcfg-$IPADDR ] ; then
            NETMASK=`cat $NETWDIR/ifcfg-$IPADDR | grep NETMASK | cut -d "=" -f 2`
        fi
    fi
    #HWADDR=`cat /sys/class/net/$1/address`
    HWADDR=`ethtool -P $1 | awk '{print $3}' | tr '[:lower:]' '[:upper:]'`
    LinkStatus=`ethtool $1 | grep "Link detected:" | cut -d " " -f 3` # Get the link status
}
# ----------------------------------------- #
GetIPADDR () {
    while [ 1 ] ; do 
        read -ep "$1 [$2] : " IPA
        if [ ! -z ${IPA} ] ; then
            NEWIP="${IPA}"
        else
            NEWIP=$2
        fi
        check_ip $NEWIP
        if [ $? -eq 0 ] ; then
            break
        else
            echof "IP syntax error"
        fi
    done
} # GetIPADDR
# ----------------------------------------- #
GetMASK () {
    while [ 1 ] ; do
        read -ep "$1 [$2] : " MASKA
        if [ ! -z ${MASKA} ] ; then
            NEWMASK="${MASKA}"
        else
            NEWMASK=$2
        fi
        check_netmask $NEWMASK
        if [ $? -eq 0 ] ; then
            break
        else
            echof "MASK syntax error"
        fi
    done
} # GetMASK
# ----------------------------------------- #
GetInfo() {
    source $HAConfigurationFile
    HOST1=`hostname -s`
    HOSTFULL=`uname -n`
    DOMAIN=`hostname | cut -d "." -f 2-`
    GATEWAY=`cat /etc/sysconfig/network | grep GATEWAY= | awk -F "=" '{print $2}'`
    if [ -f $RSLV ] ; then
        CurrentDNS=`cat $RSLV | grep "^nameserver " | awk -F " " '{print $2}'` >& /dev/null
    else
        CurrentDNS=
    fi
    CurrentHostIP=`grep $HOSTFULL /etc/hosts | grep -v '127.0.0.1\|::1' | awk  -F " " '{print $1}' | head -1`
    if [ "$CurrentHostIP" = "" ] ; then
        CurrentMNG=
    else
        CurrentMNG=`grep -l $CurrentHostIP /etc/sysconfig/network-scripts/ifcfg-{e,b}* 2>/dev/null | awk -F "-" '{print $3}'`
        fi
    GetBondInfo
} # GetInfo
# ----------------------------------------- #
SelectBondIF () { # parameters are BOND and type
    echo
    echo -n "Select the Inerfaces for $1 $2, Current I/Fs are : "
    case $2 in
        MGT )
            echo " #1=$MGT1  #2=$MGT2"
        ;;
        CLT )
            echo " #1=$CLT1  #2=$CLT2"
        ;;
        * )
            break
        ;;
    esac
    echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
    NUMB=$(($IFCount+1))
    PS3="Select an item from the list, or $((${NUMB}+1)) to Quit: "
    OPTION="$INTF None Quit" # Adding Quit option to the select menu
    for LOOP in 1 2 ; do
        echo "$1 Interface #$LOOP :"
        select N in $OPTION ; do
            case n$N in
                nQuit )
                    read -p "No change... press Enter to continue" a
                    break;
                ;;
                nNone ) # delete previous definitions
                    N="" # removing I/F
                    echof "...Updating $1/MGT$LOOP to $N"
                    sed -i "s/^$2${LOOP}=.*/$2${LOOP}=$N/" $HAConfigurationFile
                    break
                ;;
                n )
                ;;
                *) # I/F was selected
                    echof "...Updating $1/MGT$LOOP to $N"
                    # delete previous definitions
                    sed -i "s/^$2${LOOP}=.*/$2${LOOP}=$N/" $HAConfigurationFile
                    break
                ;;
            esac
        done
        echo
    done
    case $1 in
        BOND0 )
            GetIPADDR "Please type the $1 IP address " $BOND0_IP ; BOND0_IP=$NEWIP
            GetMASK "Please type the $1-NETMASK" $BOND0_NETMASK ; BOND0_NETMASK=$NEWMASK
        ;;
        *)
        ;;
    esac   
    echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
} # SelectBondIF
# ----------------------------------------- #
BondConfig () { ######## BONDx ##############
echof ${FUNCNAME[0]}
    BOND[0]="$MGT1 $MGT2"
    BOND[1]="$CLT1 $CLT2"
    BOND[2]=

    echo " BOND0=${BOND[0]}"
    echo " BOND1=${BOND[1]}"

if [ "$PRI" = "y" ] ; then
    IP41=1
    IP42=2
else
    IP41=2
    IP42=1
fi

IP[0]=${BOND0_IP}
IP[1]=192.168.168.${IP41}
NETMASK[0]=${BOND0_NETMASK}
NETMASK[1]=255.255.255.0

PRIMARY_ETH[0]=`echo ${BOND[0]} | cut -d' ' -f1`
PRIMARY_ETH[1]=`echo ${BOND[1]} | cut -d' ' -f1`
######## BONDs: create ifcfg-bondx files ##############
for I in 0 1 ; do
    echo -e "IPADDR=${IP[I]}\nNETMASK=${NETMASK[I]}\nBOOTPROTO=none\nDEVICE=bond${I}\nUSERCTL=no\nONBOOT=yes\nTYPE=Ethernet" \
     > /etc/sysconfig/network-scripts/ifcfg-bond$I
    echo "BONDING_OPTS=\"mode=1 miimon=100 primary=${PRIMARY_ETH[I]}\"" >> /etc/sysconfig/network-scripts/ifcfg-bond$I
# mode=0 - round-robin, 1 - active-backup, miinon - monitoring (millisec)
done

######## BONDs configuration for ENOx
for I in 0 1 ; do
    for ENO in ${BOND[I]} ; do
        ENOF=/etc/sysconfig/network-scripts/ifcfg-$ENO
        #HW=`cat /sys/class/net/$ENO/address | tr '[:lower:]' '[:upper:]'`
        HW=`ethtool -P $ENO | awk '{print $3}' | tr '[:lower:]' '[:upper:]'`
        echo -e "TYPE=Ethernet\nBOOTPROTO=static\nHWADDR=$HW" > $ENOF
        echo -e "NAME=${ENO}\nONBOOT=yes\nNM_CONTROLLED=no\nDEVICE=${ENO}" >> $ENOF
        echo -e "SLAVE=yes\nMASTER=bond$I" >> $ENOF
    done
done
fix_modprobe
echof "restarting Network service so all changes will take effect..."
systemctl restart network.service
for I in 0 1 ; do
    for ENO in ${BOND[I]} ; do
        ifconfig $ENO up
    done
done
# On Primary node 
if [ "$PRI" = "y" ] ; then  
    share_key
    HOST2=`ssh root@${SecIP} "hostname -s"` 
    # create /etc/hosts file and copy to Second node 
    echo "127.0.0.1  localhost.localdomain  localhost
${IP[0]}  ${HOSTFULL}  ${HOST1}
${BOND0_SEC}   ${HOST2}.${DOMAIN}    $HOST2
192.168.168.$IP41    ${HOST1}-cluster.${DOMAIN}    ${HOST1}-cluster
192.168.168.$IP42    ${HOST2}-cluster.${DOMAIN}    ${HOST2}-cluster
" > /etc/hosts
    scp /etc/hosts root@${SecIP}:/etc/hosts 
fi
BondConfigDone=1
} # BondConfig
# ----------------------------------------- #
GetBondInfo () {
    if [[ ( -z  ${MGT1} ) && ( -z  ${MGT2} ) ]] ; then
        BOND0_IP=
        BOND0_NETMASK=
    else
        source /etc/sysconfig/network-scripts/ifcfg-bond0 >&  /dev/null
        BOND0_IP=$IPADDR
        BOND0_NETMASK=$NETMASK
    fi
    if [[ ( -z  ${CLT1} ) && ( -z  ${CLT2} ) ]] ; then
        BOND1_IP=
        BOND1_NETMASK=
    else
        source /etc/sysconfig/network-scripts/ifcfg-bond1 >&  /dev/null
        BOND1_IP=$IPADDR
        BOND1_NETMASK=$NETMASK
    fi    
} # GetBondInfo
# ----------------------------------------- #
RestoreSA () {
echof ${FUNCNAME[0]}
    clear
    echo
    echof "Restoring node..."
    echo
    pcs cluster destroy all  # After debugging redirect >& /dev/null   
    echo "Select the Management I/F from :"
    echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
    NUMB=$(($IFCount+1))
    PS3="Choose a number of an item you want to configure, or $NUMB to Quit: "
    OPTION="$INTF Quit" # Adding Quit optoin to the select menu
    select N in $OPTION ; do
        case n$N in
            nQuit )
                echof "No config..."
                read a
                break;
            ;;
            n )
            ;;
            *) # I/F was selected
                LoadIF $N
                CurrentMNG=$N
                echof "CurrentMNG=$N ; IP=$IPADDR ; MASK=$NETMASK ; HOST=$HOST1"
                if [[ "$MASTER" =~ ^bond? ]] ; then
                    source $NETWDIR/ifcfg-$IPADDR
                fi
                echo
                echof "CurrentMNG=$N ; IP=$IPADDR ; MASK=$NETMASK ; HOST=$HOST1"
                echof "Updating /etc/hosts file with Management I/F : $N"
                ######## create /etc/hosts and copy to second node ##############
                echo -e "127.0.0.1  localhost.localdomain  localhost\n$IPADDR ${HOSTFULL} ${HOST1}" > /etc/hosts
                echo
                break
            ;;
        esac
    done
    # restore ntpd conf
    sed -i "/-I bond0/ d" /etc/sysconfig/ntpd
    #define new ifcfg- file
    #HWADDR=`cat /sys/class/net/$CurrentMNG/address`
    HWADDR=`ethtool -P $CurrentMNG | awk '{print $3}'| tr '[:lower:]' '[:upper:]'`
    rm -f /etc/sysconfig/network-scripts/ifcfg-bond*
    rm -f /etc/sysconfig/network-scripts/ifcfg-e*
    echof "Updating : $NETWDIR/ifcfg-$CurrentMNG..."
    echo -e "HWADDR=$HWADDR\nNAME=$CurrentMNG\nTYPE=Ethernet\nBOOTPROTO=static\nDEFROUTE=yes\nIPV6INIT=no\nONBOOT=yes\nIPADDR=$IPADDR\nNETMASK=$NETMASK\nDEVICE=$CurrentMNG\n" > $NETWDIR/ifcfg-$CurrentMNG
#   echof -e "HWADDR=$HWADDR\nNAME=$CurrentMNG\nTYPE=Ethernet\nBOOTPROTO=static\nDEFROUTE=yes\nIPV6INIT=no\nONBOOT=yes\nIPADDR=$IPADDR\nNETMASK=$NETMASK\nDEVICE=$CurrentMNG\n"
    read -p "----review the new ifcfg-$CurrentMNG file and press Enter to continue..." a
    sed -i "/^alias bond.* bonding/d" /etc/modprobe.d/bonding.conf >& /dev/null
    # close back permission
    sed -i "/Match Address ${PrimIP}/,/^  *PermitRootLogin yes/ d" /etc/ssh/sshd_config; service sshd restart >& /dev/null
#    systemctl restart network.service - does not help to remove bond 
    rm -f $HAConfigurationFile # delete configuration file
    sed -i "/HA enabled/ d" $RootDir/products/${SRVC}.ver >& /dev/null
    echof "Clean multipath configuration."
    multipath -F 
    rm -f /etc/multipath.conf >& /dev/null
    
    ask_yn "Restore node done... Reboot? " "n"
    if [ "$ANS" == "y" ] ; then 
        reboot now 
    else
        echof "Reboot to implement changes."
        exit 0
    fi
} # RestoreSA
# ----------------------------------------- #
Show_Menu() {
    clear
    GetInfo
    echo "    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"    
    echo "           Allot DSC High availability for ACP 17.x Setup menu"
    echo "    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
    echo
    echo " +------------------------------------------------------+"
    if [ "$PRI" == "y" ] ; then
        echo " | Primary                                              |"
    else
        echo " | Secondary                                            |"
    fi
    printf " | HOST Name = %-40.40s |\n" $HOST1.$DOMAIN 
    printf " | GATEWAY =   %-40s |\n" $GATEWAY
    printf " | VIP =       %-40s |\n" $VIRTUALIP
    printf " |                                                      |   |BOND0-Management\n" $MGT1

    printf " | External-Storage = $STORAGE                                 |-->|%s\n" $BOND0_IP
    if [ "$PRI" == "y" ] ; then
        printf " | Node2 =     %-16s   %21s |   |%s\n" $BOND0_SEC $MGT2"" $BOND0_NETMASK
    else
        printf " | Node2 =     %-16s   %21s |   |%s\n" $BOND0_IP $MGT2"" $BOND0_NETMASK
    fi
    printf " | DNS =       %-16s %-16s        |\n" $CurrentDNS
    printf " |                                                      |\n"
    printf " | %52s |   |BOND1-Cluster\n" $CLT1
    printf " |                                                      |-->|%s\n" $BOND1_IP
    printf " | %52s |   |%s\n" $CLT2"" $BOND1_NETMASK
    printf " |                                                      |\n"
    echo " +------------------------------------------------------+"
    echo
    echo " #     I/F             MAC Address       IP Address         NETMASK     Link"
    echo "~~~ ~~~~~~~~~~~~    ~~~~~~~~~~~~~~~~~  ~~~~~~~~~~~~~~~  ~~~~~~~~~~~~~~~  ~~~~"
    LINE=1
    for CurrentLine in $INTF ; do
        LoadIF $CurrentLine
        printf " #) %-12s : %18s %16s %16s %5s\n" $CurrentLine $HWADDR $IPADDR $NETMASK $LinkStatus
    done
    echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
    echo
    echo " HA Configuration :"
    echo " ~~~~~~~~~~~~~~~~~~"
    printf "%2s) %-13s\n" $LINE "Bonding"
    (( LINE += 1 ))
    printf "    %-13s:  %-18s %-18s\n" "BOND0/MGT" "MGT1=$MGT1" "MGT2=$MGT2"
    printf "    %-13s:  %-18s %-18s\n" "BOND1/Cluster" "CLT1=$CLT1" "CLT2=$CLT2"
    echo "~~~ ~~~~~~~~~~~~    ~~~~~~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~"
    printf "%2s) Continue HA Setup\n" $LINE
    (( LINE += 1 ))
    printf "%2s) Maintenance restore (Currently not implemented)\n" $LINE
    (( LINE += 1 ))
    printf "%2s) Quit\n" $LINE
    echo
    echo -n "Choose a number of an item you want to configure: "
} # Show_Menu
# ----------------------------------------- #
Read_Options() {
    read -e choice
    # to disable the basic server configuration options 
    echo
    case $choice in
        1 )
            SelectBondIF "BOND0" "MGT"
            SelectBondIF "BOND1" "CLT"
            source $HAConfigurationFile &>> $HASetupLog # reload configuration after bond tunning
            BondConfig
        ;;
        2 )
            echof "Runnning..."
            choice=99
        ;;
        3 )
#            ask_yn "Ary you sure you want to restore the Node? " "n"
#            if [ "$ANS" == "y" ] ; then RestoreSA ; fi
#            choice=0
            echof "Currently not implemented."
        ;;
        "" )
            read -p "Refresh screen, press Enter" a
            choice=0
        ;;
        *)
            echof "* * * B Y E * * *"
            echo
            exit 0
        ;;
    esac
} # Read_Options
# ----------------------------------------- #
Questions() {
echof ${FUNCNAME[0]}
    clear
    echo
    echo "    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"    
    echo "           Allot DSC High availability for ACP 17.x Setup menu"
    echo "    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
    echo
    echo "This is $PRD device. Please answer the following questions"
    echo
    while [ 1 ] ; do
        read -ep "Is this a Primary Machine (y/n) [y]? " PRI
        if [ -z "$PRI" ] ; then PRI="y" ; fi                    # Default yes
        if [[ $PRI =~ ^[yn]$ ]] ; then
            break
        else 
            echo "Was that a yes or a no? Let's try again..."
        fi
    done
    case $PRD in 
        DSC )
            InMem="n"
            sed -i "s/^InMem=.*/InMem=${InMem}/" $HAConfigurationFile
            STORAGE="y"
            sed -i "s/^STORAGE=.*/STORAGE=${STORAGE}/" $HAConfigurationFile
        ;;
        * ) echof "Could not get product info. Exiting..." ; exit 1 ;
    esac
    if [ "$PRI" == "y" ] ; then
        GetIPADDR "Please type the IP address of the VIP" $VIRTUALIP
        VIRTUALIP=$NEWIP
        GetIPADDR "Please type the Management IP address of the Secondary host" $BOND0_SEC
        BOND0_SEC=$NEWIP
    fi
} # Questions
# ----------------------------------------- #
CreateCfg () {
echof ${FUNCNAME[0]}
for PARAM in InMem STORAGE MGT1 MGT2 CLT1 CLT2 ; do 
    grep -q "^${PARAM}" $HAConfigurationFile
    if [ ! $? -eq 0 ] ; then echo "${PARAM}=" >> $HAConfigurationFile ; fi
done
}
# ----------------------------------------- #
fix_modprobe (){
echof ${FUNCNAME[0]}
# Set bond configurations for the public and cluster interconnect networks
# on both nodes
for I in 0 1 ; do
    grep "^alias bond$I bonding" /etc/modprobe.d/bonding.conf >& /dev/null
    if [ ! $? -eq 0 ] ; then
        echo "alias bond$I bonding" >> /etc/modprobe.d/bonding.conf 
    fi
done
} # fix_modprobe
# ----------------------------------------- #
# disable RPCBIND ipv6 
RPCBIND () {
echof ${FUNCNAME[0]}
sed -i "s/^udp6/#udp6/" /etc/netconfig
sed -i "s/^tcp6/#tcp6/" /etc/netconfig
rm -f /etc/sysconfig/network-scripts/ifcfg-usb0
if [ -f /etc/resolv.conf.save ] ; then rm -f /etc/resolv.conf.save ; fi
}
# ----------------------------------------- #
open_back () {
echof ${FUNCNAME[0]}
grep -A1 "Match Address ${PrimIP}" /etc/ssh/sshd_config | grep -q "   PermitRootLogin yes"
if [ ! $? -eq 0 ] ; then
    echo -e "Match Address ${PrimIP}\n        PermitRootLogin yes" >>  /etc/ssh/sshd_config
    service sshd restart >& /dev/null
fi
[ -d ~/.ssh/ ] || mkdir  ~/.ssh/
touch ~/.ssh/authorized_keys
} # open_back
# ----------------------------------------- #
share_key () {
echof ${FUNCNAME[0]}
ping -c 2 ${SecIP}
CNCT=$?
while [ ! $CNCT -eq 0 ] ; do
    echof "No connection to ${SecIP}. Do you want to try again? (y/n) [n] "
    read -e ANS
    if [ ! "$ANS" == "y" ] ; then echof "Exiting." ; exit 1 ; fi
    ping -c 2 ${SecIP}
    CNCT=$?
done
echof "Configuration should be performed after running the script on Secondary node."
echof "Please answer some questions."
echof "Supply root password when asked:"
echof "*********************************"
echo

echo -e 'n\n' | ssh-keygen -q -f ~/.ssh/id_rsa -N ""
ssh root@${SecIP} "sed -i /`hostname -s`/d  ~/.ssh/authorized_keys"
ssh-copy-id -i ~/.ssh/id_rsa.pub root@${SecIP}
if [ ! $? -eq 0 ] ; then echof "Share key failed. Run the script on Secondary node. Exiting." ; exit 5 ; fi
} # share_key
# ----------------------------------------- #
hacl_user () {
echof ${FUNCNAME[0]}
echo "passwd" | passwd --stdin hacluster
ssh root@${SecIP} 'echo "passwd" | passwd --stdin hacluster'
} # hacl_user
# ----------------------------------------- #
# Configure multipath - on both hosts
fix_multipath () {
echof ${FUNCNAME[0]}
systemctl stop multipathd.service
rm -f /etc/multipath.conf 
ssh root@${SecIP} "systemctl stop multipathd.service; rm -f /etc/multipath.conf"
mpathconf --enable --user_friendly_names n --with_multipathd y 
ssh root@${SecIP} "mpathconf --enable --user_friendly_names n --with_multipathd y" >& /dev/null
WW=`multipath -ll | grep dm- | awk '{print $1}'`
if [ "a$WW" == "a" ] ; then 
    GetWWID 
fi
echo "multipaths {
       multipath {
               wwid                    $WW
               alias                   ha-dsc
       }
}" >> /etc/multipath.conf
scp /etc/multipath.conf root@${SecIP}:/etc/multipath.conf
systemctl restart multipathd.service 
systemctl enable multipathd.service 
ssh root@${SecIP} "systemctl restart multipathd.service; systemctl enable multipathd.service" >& /dev/null
} # fix_multipath
# ----------------------------------------- #
GetWWID() {
echof ${FUNCNAME[0]}
I=1
unset OPTNS
for O in `fdisk -l 2>&1 |grep "Disk /dev" | grep -o "/dev/sd[a-z]"` ; do OPTNS[I]="$O" ; ((++I)); done
OPTNS[I]="Quit"

while [ 1 ] ; do
    echo
    parted -l | grep -E "Model:|Disk /dev" | tr '\n' ' ' |sed "s/GB/GB\n/"g | sed -e "s/^ //" -e "s/ Disk/. Disk/"
    echof "Evailable choice:"
    for (( i=1; i<=I; i=i+1 )); do echof $i')' ${OPTNS[i]} ; done
    read -ep "Select shared device (enter number): " D
    if [ -z ${OPTNS[D]} ] ; then 
        echo
        echof "Wrong choice."
    else 
        echof "${OPTNS[D]} selected." 
        if [ $D -eq $I ] ; then echof "Exiting." ; exit 1 ; fi
        mount | grep ${OPTNS[D]} > /dev/null
        if [ $? -ne 0 ] ; then
            break
        else
            echo
            echof "Wrong choice: ${OPTNS[D]} is mounted."
        fi
    fi
done
multipath ${OPTNS[D]}
ssh root@${SecIP} "multipath ${OPTNS[D]}"
WW=`multipath -ll | grep dm- | awk '{print $1}'`
if [ "a$WW" == "a" ] ; then 
    echof "Coulg not get WWID. Exiting."
    exit 1    
fi
} # GetWWID
# ----------------------------------------- #
# Prepare storage - on primary node only format storage disk, copy data
prepare_storage () {
echof ${FUNCNAME[0]}
fix_multipath
# dm-0 should be available now
cat /proc/partitions | grep dm-0
RES=$?
if [ $RES -eq 0 ] ; then
#   Create partition on the storage
    parted -s /dev/dm-0 mklabel gpt 
    parted -s /dev/dm-0 -- mkpart primary 1 -1
else
    echof "Cannot find dm-0, please verify that storage is connected."
    exit 1
fi
echof "Looking for dm-1..."
Gotdm=n
for Itry in 1 2 3 ; do
    sleep 5
    partprobe >& /dev/null
    cat /proc/partitions | grep -q dm-1
    if [ $? -eq 0 ] ; then
        Gotdm=y
        break
    else
        echo -n "..."
    fi
done

if [ "$Gotdm" == "y" ] ; then
    echof "Found."
    mkfs.xfs -f -L HASPC1 /dev/dm-1
else
    echof "Cannot find dm-1, please verify environment and run again."
    exit 1
fi
 
mount /dev/dm-1 /mnt 

echof "Copy the data..."
cp -rp /opt/shared/*  /mnt
if [ $? -eq 0 ] ; then
    echof "Data copy done."
else
    echof "Data copy error."
fi
umount /mnt
} # prepare_storage
# ----------------------------------------- #
create_cluster () {
echof ${FUNCNAME[0]}
systemctl stop ${SRVC}.service
systemctl stop ${SRVC2}.service
systemctl disable ${SRVC}.service
systemctl disable ${SRVC2}.service
ssh root@${SecIP} "systemctl stop ${SRVC}.service; systemctl stop ${SRVC2}.service"
ssh root@${SecIP} "systemctl disable ${SRVC}.service; systemctl disable ${SRVC2}.service"


sed -i "s/^com.allot.sp.configuration.host-headers=.*/com.allot.sp.configuration.host-headers=${VIRTUALIP}/" ${RootDir}/webui/application.properties
ssh root@${SecIP} "sed -i 's/^com.allot.sp.configuration.host-headers=.*/com.allot.sp.configuration.host-headers=$VIRTUALIP/' $RootDir/webui/application.properties" 

sed -i "s/^com.allot.sp.configuration.host-headers=.*/com.allot.sp.configuration.host-headers=${VIRTUALIP}/" ${RootDir}/spconfig/application.properties
ssh root@${SecIP} "sed -i 's/^com.allot.sp.configuration.host-headers=.*/com.allot.sp.configuration.host-headers=$VIRTUALIP/' $RootDir/spconfig/application.properties"

systemctl start pcsd.service
systemctl enable pcsd.service
ssh root@${SecIP} 'systemctl start pcsd.service'
ssh root@${SecIP} 'systemctl enable pcsd.service'
# clean
pcs cluster destroy all  # After debugging redirect >& /dev/null
ssh root@${SecIP} "pcs cluster destroy all"
# names
NODE1=`hostname -s`-cluster
NODE2=`grep cluster /etc/hosts | grep -vw $NODE1 | awk '{print $3}'`

# cluster name includes IP to be unique 
CLN=`echo $VIRTUALIP | sed 's/\./-/g'`
pcs cluster auth ${NODE1} ${NODE2} -u hacluster -p passwd --force
# start
pcs cluster setup --start --name $PRD-cluster-$CLN ${NODE1} ${NODE2}
pcs cluster enable --all

# Prepare additional configuration files 
sed "s/11.11.11.11/$VIRTUALIP/g" $BaseDir/resources.xml >  $BaseDir/resources_.xml
sed "s/NODE1/$NODE1/" $BaseDir/constrains.xml | sed "s/NODE2/$NODE2/" > $BaseDir/constrains_.xml
/bin/cp -f $BaseDir/config.xml $BaseDir/config_.xml

if [ "$STORAGE" == "y" ] ; then
    prepare_storage
fi
# configure cluster
cibadmin --modify --scope crm_config --xml-file $BaseDir/config_.xml
cibadmin --modify --scope resources --xml-file $BaseDir/resources_.xml
cibadmin --modify --scope constraints --xml-file $BaseDir/constrains_.xml
} # create_cluster
# ----------------------------------------- #
check_params () {
echof ${FUNCNAME[0]}
    #check if all param exist
    echo -e "\n[NODE-Info]\nHOSTNAME=${HOST1}\nHOST2=${HOST2}\nDOMAIN=${DOMAIN}\nGATEWAY=${GATEWAY}\nDNS=$CurrentDNS\nProduct=$PRD\nPRIMARY=${PRI}" | tee -a $HASetupLog
    if [ "$PRI" == "y" ] ; then echo -e "VIRTUALIP=${VIRTUALIP}\nNode2=$BOND0_SEC"  | tee -a $HASetupLog; fi
    echo -e "External-Storage=$STORAGE\n" | tee -a $HASetupLog
    echo -e "[BOND0-MGT]\nInterface#1=$MGT1\nInterface#2=$MGT2\nIP-ADDR=$BOND0_IP\nNETMASK=$BOND0_NETMASK\n" | tee -a $HASetupLog
    echo -e "[BOND1-CLT]\nInterface#1=$CLT1\nInterface#2=$CLT2\nIP-ADDR=$BOND1_IP\nNETMASK=$BOND1_NETMASK\n" | tee -a $HASetupLog
    
    # Check minimum parameters for the script
    if [[ ( -z ${HOST1} ) ]] || \
       [[ ( "$PRI" == "y" ) && ( -z ${HOST2} ) ]] || \
       [[ ( -z ${MGT1} ) && ( -z ${MGT2} ) ]] || \
       [[ ( -z ${CLT1} ) && ( -z ${CLT2} ) ]] 
    then
       echof "Missing parameters..." 
       echof " Please Re-Run the script and apply all missing parameters."
       let RCODE=$RCODE+1 # is it needed?
       exit 1
    fi
} # check_params
# ----------------------------------------- #
prelim_check () {
echof ${FUNCNAME[0]}
# check allottype - CentOS 7.1 or higher version needed
allottype >& /dev/null 
if [ $? -ne 0 ] ; then
    echof "ACP Installation should be used."
    let RCODE=$RCODE+1
else
    ACPVER=`allottype | grep -E "kickstart|ACP" | head -n 1 | grep -oE "[0-9][0-9]\.[0-9]+"`
    checkver $ACPVER $ACP_MINV
    if [ $? -eq 2 ] ; then
        echof "ACP $ACP_MINV or higher version should be installed."
        let RCODE=$RCODE+1
    fi
fi
# DSC must be installed
rpm -q dsc >& /dev/null
if [ $? -eq 0 ] ; then
    PRD=DSC
else
    PRD=
    echof "DSC must be installed."
    echof "Please install the product and run $0 again."
    let RCODE=$RCODE+1
fi
# Exit if anything is wrong
if [ ! $RCODE -eq 0 ] ; then
    echof "Fix the problem and run again."
    exit $RCODE 
fi
} # prelim_check
# ----------------------------------------- #
check_more () {
echof ${FUNCNAME[0]}
# For shared storage - check if second disk (sdb) is available 
cat /proc/partitions | grep -q sdb
if [[ ( $? -ne 0 ) && ( "${STORAGE}" == "y" ) ]] ; then
    echof "**********************************************"
    echof "Verify that storage is connected."
    echof "Then reboot the host and run the script again."
    echof "**********************************************"
    exit 7
fi

case $PRD in
    DSC ) SRVC=dsc; SRVC2=postgresql-12 ;;
     * ) echof "Could not get product info. Exiting..." ; exit 1 ;
esac
# disable selinux if needed
grep -q "SELINUX=disabled" /etc/selinux/config
if [ $? -ne 0 ] ; then
    echof "Disabling selinux."
    sed -i s"/^SELINUX=.*/SELINUX=disabled/" /etc/selinux/config
fi
# disable NetworkManager if needed
for DISERV in NetworkManager ; do
    systemctl status $DISERV.service > /dev/null
    if [ $? -eq 0  ] ; then
        echof "Disabling $DISERV."
        systemctl disable $DISERV.service > /dev/null
        systemctl stop $DISERV.service > /dev/null
    fi
done
# ntp check
rpm -q ntp > /dev/null
if [ $? -eq 0 ] ; then
    systemctl status ntpd.service  > /dev/null
    if [ $? -ne 0 ] ; then
        echof "Enabling NetWork Time Protocol."
        systemctl enable ntpd.service >& /dev/null
    fi
else
    echof "No ntpd installed. It may cause problems."
fi
} # check_more
# ----------------------------------------- #

################# MAIN #################
NETWDIR=/etc/sysconfig/network-scripts
RootDir=/opt/allot
BaseDir=$RootDir/conf/ha
HAConfigurationFile=${BaseDir}/HA7.cfg # HA configuration file name
HASetupLog=$RootDir/log/HA7Setup.Log
RCODE=0
ACP_MINV=17.8
PrimIP=192.168.168.1
SecIP=192.168.168.2

pushd /sys/class/net >& /dev/null
INTF=`ls -dv e* | grep -v u`
IFCount=`echo $INTF | wc -w` # number of Ethernet ports in current system
popd  >& /dev/null
HOST1=
DOMAIN=
PRI=
RSLV='/etc/resolv.conf'
MODE=0
ANS=y
LINE=0
choice=0
CurrentMNG=
HWADDR=
CurrentDNS=
IPADDR=
NETMASK=
GATEWAY=
BOND0_IP=
BOND0_NETMASK=
BOND1_IP=
BOND1_NETMASK=
BOND2_IP=
BOND2_NETMASK=
BondConfigDone=
STORAGE=

echo `date +"%d/%m/%Y-%H:%M"` "=== $0 is Starting" | tee -a $HASetupLog
check_user
prelim_check
touch $HAConfigurationFile
CreateCfg
Questions

while [ $choice -lt 99 ] ; do 
    Show_Menu
    Read_Options
done
if [ -z $BondConfigDone ] ; then BondConfig ; fi
RPCBIND

# Additional checks
check_more
check_params

if [ "$PRI" == "n" ] ; then
    open_back
    echof "Done with Secondary. Continue setup on Primary server"
    exit 0
else    
    hacl_user
    create_cluster # (copy scripts, modify config, resources, constrains)
    crm_mon -1 -n
fi
echof "Done"
# Writing HA status to Allottype
grep -q "HA enabled" $RootDir/products/dsc.ver || echo "HA enabled" >> $RootDir/products/dsc.ver
ssh root@${SecIP} "grep -q 'HA enabled' $RootDir/products/dsc.ver || echo 'HA enabled' >> $RootDir/products/dsc.ver"
