#!/bin/bash

# *************************************************************************************************************
# Fix DSC HA metadata (resources.xml) inside pacemaker metadata 
# after DSC upgrade to 17.1.10 and higher from DSC 16.X (change PostgreSQL version from 9.2 to 12.6)
# Not required DSC/pacemaker restart (change done "on the fly")
# *************************************************************************************************************
pushd `pwd` >& /dev/null

cd /opt/allot/conf/ha

cibadmin --query --scope resources > curres.xml

#Check if version PostgeSQL already changed
grep -q "pgsql-12" curres.xml
if [ $? -ne 0 ] ; then
  sed -i "/pgdata/ s/pgsql/pgsql\/12/" curres.xml
  sed -i "/pgctl/ s/usr/usr\/pgsql-12/" curres.xml 
  cibadmin --replace --scope resources --xml-file curres.xml
  echo "PostgreSQL version changed PG12"
else
  echo "PostgreSQL version already PG12"
fi  

popd >& /dev/null

exit 0
