#!/bin/bash

# ***********************************************************************************************************
# Change DB password from  DB password from VZW project - version 15.1.650b11  NX
#                                                                                                        15.1.855b14 MD/SMP
#                                           to default DB password
# Usage db_pswd_chng_default.sh 
#
# Service sp should be stopped
#
# ***********************************************************************************************************

date  >> "/opt/allot/log/db_pswd_chng.txt"
echo "Start DB password change utility - back to default" >> "/opt/allot/log/db_pswd_chng.txt"
echo "Start DB password change utility - back to default"

PWFILE=/opt/allot/conf/specific/.swpwd

## Prepare values
DB_MD5_DEF=`grep "DB_MD5_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
DB_MD5_SEC=`grep "DB_MD5_SECURE" ${PWFILE} | awk -F: '{print $2}'`
DB_NX_DEF=`grep "DB_NX_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
DB_NX_SEC=`grep "DB_NX_SECURE" ${PWFILE} | awk -F: '{print $2}'`
WEBUI_DEF=`grep "WEBUI_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
WEBUI_SEC=`grep "WEBUI_SECURE" ${PWFILE} | awk -F: '{print $2}'`
CLI_DEF=`grep "CLI_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
CLI_SEC=`grep "CLI_SECURE" ${PWFILE} | awk -F: '{print $2}'`

########## netx DB ####################

   /opt/allot/bin/psql-exec -c "ALTER ROLE nms WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN ENCRYPTED PASSWORD '${DB_MD5_DEF}' "
	ret=$?
	
    if [ $ret -ne 0 ] ; then
     echo "netx database upgrade failed, code - $ret" >> "/opt/allot/log/db_pswd_chng.txt"
    else
     echo "netx database upgraded sucessful" >> "/opt/allot/log/db_pswd_chng.txt"
    fi
	
	## Change create user 
	sed -i "/ALTER ROLE nms/,/;/ s/${DB_MD5_SEC}/${DB_MD5_DEF}/" /opt/allot/DB/sql/postgres_netx_db_clean_instal.sql
	

  ## Change for nxserver standalone.xml; tomcat/webapps/webui/META-INF/context.xml
	sed -i "/dbPassword/ s/"${DB_NX_DEF}"/"${DB_NX_SEC}"/g" /opt/allot/dsc/conf/nms_config.xml
	sed -i "/db.password/ s/"${WEBUI_DEF}"/"${WEBUI_SEC}"/g" /opt/allot/webui/application.properties
  sed -i "/db.password/ s/"${WEBUI_DEF}"/"${WEBUI_SEC}"/g" /opt/allot/webui/configuration.properties
	##Change password for cli
  sed -i "/dbPassword/ s/"${CLI_DEF}"/"${CLI_SEC}"/g" /opt/allot/spconfig/cli/cli.properties
  sed -i "/dbPassword/ s/"${CLI_DEF}"/"${CLI_SEC}"/g" /opt/allot/spconfig/cli/configuration.properties

    
echo " "
date  >> "/opt/allot/log/db_pswd_chng.txt"
echo "Fihish DB password change utility- back to default " >> "/opt/allot/log/db_pswd_chng.txt"
echo "Fihish DB password change utility- back to default; See log - /opt/allot/log/db_pswd_chng.txt " 



