#!/bin/bash

# ***********************************************************************************************************
# Change DB password from default to DB password from VZW project - version 15.1.650b11  NX
#                                                                                                                     15.1.855b14 MD/SMP
#
# Only for HA install on passive node
# Usage db_pswd_chng.sh 
#
# Service sp should be stopped
#
# ***********************************************************************************************************


date  >> "/opt/allot/log/db_pswd_chng.txt"
echo "Start  DB password change utility for passive node" >> "/opt/allot/log/db_pswd_chng.txt"
echo "Start  DB password change utility for passive node"

PWFILE=/opt/allot/conf/specific/.swpwd

## Prepare values
DB_MD5_DEF=`grep "DB_MD5_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
DB_MD5_SEC=`grep "DB_MD5_SECURE" ${PWFILE} | awk -F: '{print $2}'`
DB_NX_DEF=`grep "DB_NX_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
DB_NX_SEC=`grep "DB_NX_SECURE" ${PWFILE} | awk -F: '{print $2}'`
WEBUI_DEF=`grep "WEBUI_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
WEBUI_SEC=`grep "WEBUI_SECURE" ${PWFILE} | awk -F: '{print $2}'`
CLI_DEF=`grep "CLI_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
CLI_SEC=`grep "CLI_SECURE" ${PWFILE} | awk -F: '{print $2}'`

########## netx DB ####################

	## Change create user 
	sed -i "/ALTER ROLE nms/,/;/ s/${DB_MD5_DEF}/${DB_MD5_SEC}/" /opt/allot/DB/sql/postgres_netx_db_clean_instal.sql
	
    	## Change for nxserver standalone.xml; tomcat/webapps/webui/META-INF/context.xml
	if [ -f /opt/allot/dsc/conf/nms_config.xml ] ; then
	   sed -i "/dbPassword/ s/"${DB_NX_DEF}"/"${DB_NX_SEC}"/g" /opt/allot/dsc/conf/nms_config.xml
	fi

	sed -i "/db.password/ s/"${WEBUI_DEF}"/"${WEBUI_SEC}"/g" /opt/allot/webui/application.properties
  sed -i "/db.password/ s/"${WEBUI_DEF}"/"${WEBUI_SEC}"/g" /opt/allot/webui/configuration.properties

	##Change password for cli
  sed -i "/dbPassword/ s/"${CLI_DEF}"/"${CLI_SEC}"/g" /opt/allot/spconfig/cli/cli.properties
  sed -i "/dbPassword/ s/"${CLI_DEF}"/"${CLI_SEC}"/g" /opt/allot/spconfig/cli/configuration.properties


echo " "
date  >> "/opt/allot/log/db_pswd_chng.txt"
echo "Fihish DB password change utility for passive node" >> "/opt/allot/log/db_pswd_chng.txt"
echo "Fihish DB password change utility for passive node; See log - /opt/allot/log/db_pswd_chng.txt "



