#!/bin/bash

# ***********************************************************************************************************
# security_settings.sh - used during products(DSC) upgrade processing 
#
# ***********************************************************************************************************

echo "Restore security hardening settings ..."

########## netx DB ####################
PWFILE=/opt/allot/conf/specific/.swpwd

## Prepare values
DB_MD5_DEF=`grep "DB_MD5_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
DB_MD5_SEC=`grep "DB_MD5_SECURE" ${PWFILE} | awk -F: '{print $2}'`
DB_NX_DEF=`grep "DB_NX_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
DB_NX_SEC=`grep "DB_NX_SECURE" ${PWFILE} | awk -F: '{print $2}'`
WEBUI_DEF=`grep "WEBUI_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
WEBUI_SEC=`grep "WEBUI_SECURE" ${PWFILE} | awk -F: '{print $2}'`
CLI_DEF=`grep "CLI_DEFAULT" ${PWFILE} | awk -F: '{print $2}'`
CLI_SEC=`grep "CLI_SECURE" ${PWFILE} | awk -F: '{print $2}'`


    ## Change create user 
	sed -i "/ALTER ROLE nms/,/;/ s/${DB_MD5_DEF}/${DB_MD5_SEC}/" /opt/allot/DB/sql/postgres_netx_db_clean_instal.sql
	    
	## Change for nxserver standalone.xml; tomcat/webapps/webui/META-INF/context.xml
	if [ -f /opt/allot/dsc/conf/nms_config.xml ] ; then
	     sed -i "/dbPassword/ s/"${DB_NX_DEF}"/"${DB_NX_SEC}"/g" /opt/allot/dsc/conf/nms_config.xml
	fi	 
	
	sed -i "/db.password/ s/"${WEBUI_DEF}"/"${WEBUI_SEC}"/g" /opt/allot/webui/application.properties
  sed -i "/db.password/ s/"${WEBUI_DEF}"/"${WEBUI_SEC}"/g" /opt/allot/webui/configuration.properties

	##Change password for cli
  sed -i "/dbPassword/ s/"${CLI_DEF}"/"${CLI_SEC}"/g" /opt/allot/spconfig/cli/cli.properties
  	##Change password for cli
  sed -i "/dbPassword/ s/"${CLI_DEF}"/"${CLI_SEC}"/g" /opt/allot/spconfig/cli/configuration.properties


##### restore parameter for swKeeper.ini
for FIELD in Djavax.net.ssl.keyStorePassword Djavax.net.ssl.keyStore Djavax.net.ssl.trustStorePassword Djavax.net.ssl.trustStore; do
        FVAL=`sed -n "/tasks\/ddoscontroller/,/^args/ s/^.* -${FIELD}=\([^ ]*\) .*/\1/p" /opt/allot/tmp/secur_upd/swKeeper.ini`
        if [ ! -z $FVAL ] ; then
            #echo "-$FIELD=$FVAL" >> /opt/allot/tmp/sec_ini.txt;
			sed -i "/server /s#-cp#-$FIELD=$FVAL &#" /opt/allot/conf/swKeeper.ini
        fi
done

########## restore property for nms_config.xml 

    OLD_FILE=/opt/allot/tmp/secur_upd/nms_config.xml
    NEW_FILE=/opt/allot/dsc/conf/nms_config.xml

    ARGS=`grep 'property name="webUiServerProtocol"' ${OLD_FILE} | tr " " "\n" | grep -v "^$" |sed "s#/>##" | sed "s#\"##g" | grep "^value" | awk -F"=" '{print $2}'`
	sed -i "/webUiServerProtocol/ s/\b"http"\b/${ARGS}/" ${NEW_FILE}
	
	ARGS=`grep 'property name="webUiServerPort"' ${OLD_FILE} | tr " " "\n" | grep -v "^$" |sed "s#/>##" | sed "s#\"##g" | grep "^value" | awk -F"=" '{print $2}'`
	# check both defaults ports
	sed -i "/webUiServerPort/ s/"80"/${ARGS}/" ${NEW_FILE}
	sed -i "/webUiServerPort/ s/"443"/${ARGS}/" ${NEW_FILE}
	
	ARGS=`grep 'property name="webUiServerIp"' ${OLD_FILE} | tr " " "\n" | grep -v "^$" |sed "s#/>##" | sed "s#\"##g" | grep "^value" | awk -F"=" '{print $2}'`
	sed -i "/webUiServerIp/ s/"127.0.0.1"/${ARGS}/" ${NEW_FILE}
		
####################### Fix if need /opt/allot/webui/application.properties file according to /opt/allot/tmp/secur_upd/tomcat_server.xml file
 if [ ! -f  /opt/allot/tmp/secur_upd/webui_application.properties ] && [ -f /opt/allot/tmp/secur_upd/tomcat_server.xml ] ; then
     ## need get values from /opt/allot/tmp/secur_upd/tomcat_server.xml and put into /opt/allot/webui/application.properties
	 ## First clean all comment from /opt/allot/tmp/secur_upd/tomcat_server.xml save in /opt/allot/tmp/secur_upd/tomcat_server_clean.xml
	 sed "/<\!--/,/\-\->/d" /opt/allot/tmp/secur_upd/tomcat_server.xml > /opt/allot/tmp/secur_upd/tomcat_server_clean.xml
	 
	OLD_FILE=/opt/allot/tmp/secur_upd/tomcat_server_clean.xml
    NEW_FILE=/opt/allot/webui/application.properties
	
	ARGS=`grep 'SSLEnabled=' ${OLD_FILE} | tr " " "\n" | grep -v "^$" | sed "s#\"##g" | sed "s#/>##" | grep "^SSLEnabled" | awk -F"=" '{print $2}'`
	CURR_ARGS=`grep 'server.ssl.enabled=' ${NEW_FILE} | awk -F"=" '{print $2}'`
	sed -i "/server.ssl.enabled=/ s/${CURR_ARGS}/${ARGS}/" ${NEW_FILE}
	
	ARGS=`grep 'Connector port=' ${OLD_FILE} | tr " " "\n" | grep -v "^$" | sed "s#\"##g" | sed "s#/>##" | grep "^port" | awk -F"=" '{print $2}'`
	CURR_ARGS=`grep 'server.port=' ${NEW_FILE} | awk -F"=" '{print $2}'`
	sed -i "/server.port=/ s/${CURR_ARGS}/${ARGS}/" ${NEW_FILE}
 
 fi
	
	# Logging
echo "`date`: running security hardening script for DSC (product upgrade) " >> /opt/allot/log/secur_hardening_upd.log
	



