#!/bin/bash

. /etc/spdirs

you=`id -un`
if [ ! "$you" = "root" ] ; then
    echo "Operation should be performed by root user."
    exit 1
fi

date_str=$( date +"%Y_%m_%d_%H_%M_%S" )

echo "${date_str} Prepare migration data - start "

#Prepare Migration data
su - postgres -c "/usr/bin/psql -d netx -f /var/bulk/migration/migration_14_5.sql" > /dev/null 2> /var/bulk/migration/migration_error.log
ret=$?

if [ $ret -eq 0 ] ; then
		echo "Migration schema and tables created successfully  " 
	else
		echo "Migration schema and tables failed; see /var/bulk/migration/migration_error.log   " 
		exit 1
	fi


IP_ADDR=`cat /usr/local/ntais2/conf/esmtprc | grep "hostname" | cut -d= -f2 | cut -d: -f1`

PORT_NUM=`cat /usr/local/ntais2/conf/esmtprc | grep "hostname" | cut -d= -f2 | cut -d: -f2`

psql-exec -c "INSERT INTO migration.smtp(host_ip,port) values('${IP_ADDR}',${PORT_NUM})"

su - postgres -c "/usr/bin/pg_dump netx -n 'h*' -N 'h1' -s -O -x -f /var/bulk/migration/netx_14_5_db_host_schemas.sql"
ret=$?
if [ $ret -eq 0 ] ; then
		echo "Dump of Host schema's created successfully  " 
fi

su - postgres -c "/usr/bin/pg_dump netx -n 'migration'  -f /var/bulk/migration/netx_14_5_migration_schemas.sql"
ret=$?
if [ $ret -eq 0 ] ; then
		echo "Dump of Migration schema created successfully  " 
fi		

date_str=$( date +"%Y_%m_%d_%H_%M_%S" )
echo "${date_str} Prepare migration data - finish "
echo "See files netx_14_5_migration_schemas.sql, netx_14_5_db_host_schemas.sql in /var/bulk/migration directory "

exit

