--
-- Name: migration; Type: SCHEMA; Schema: -; Owner: postgres
--

DROP SCHEMA IF EXISTS migration CASCADE;
CREATE SCHEMA migration;

ALTER SCHEMA migration OWNER TO postgres;

set search_path=migration,pg_catalog;

select * into passwd from auth.passwd;

select * into thresholds from flood.thresholds;
select * into types from flood.types where type_id >= 1000;

select * into data from config.data;
select * into names from config.names;

select * into bgp_config from flood.bgp_config;
select * into bgp_peers from flood.bgp_peers;
select * into mtg_map from flood.mtg_map;
select * into mtg_sg_state from flood.mtg_sg_state;

select * into list from report.list;
select * into mail from report.mail;
select * into views from report.views;

select * into map from smp.map;

select * into complete_targets from notify.complete_targets;
select * into filter_parts from notify.filter_parts;
select * into filter_targets from notify.filter_targets;
select * into filters from notify.filters;
select * into filter_templates from notify.filter_templates;
select * into templates from notify.templates;
select * into targets from notify.targets;
select * into notify_types from notify.types;
select * into fields from notify.fields;

select * into cluster_config from public.cluster_config;
select * into data_tables from public.data_tables;
select * into group_config from public.group_config;
select * into group_mapping from public.group_mapping;
select * into groups from public.groups;
select * into hosts from public.hosts;
select * into permissions from public.permissions;
select * into sensor_clusters from public.sensor_clusters;
select * into subsystems from public.subsystems; 
select * into post_target_types from public.post_target_types;

--
-- Name: smtp; Type: TABLE; Schema: public; Owner: ndbadm; Tablespace:  
--
CREATE TABLE smtp
(
	host_ip          text NOT NULL,
	port             INTEGER DEFAULT 25 NOT NULL,
	from_address     text DEFAULT 'spc@allot.com' NOT NULL,
	replayto_address text DEFAULT 'spc@allot.com' NOT NULL,
	is_auth          BOOLEAN DEFAULT false NOT NULL,
	username         text,
	password         text,
	constraint pk_smtp primary key (host_ip),
	constraint uniqe_server_ip UNIQUE (host_ip)
);

GRANT ALL ON TABLE smtp TO ndbadm;

REVOKE ALL ON SCHEMA migration FROM postgres;
GRANT ALL ON SCHEMA migration TO postgres;
GRANT ALL ON SCHEMA migration TO ndbadm;