--
-- Name: migration_15_1; 
--  migrate configuration data from 14.5.10 version to 15.1.10 version
--

-- Disable all triggers(FK !?!) for the current session
SET session_replication_role = replica;

\i /opt/allot/migration/netx_14_5_migration_schemas.sql
--\i /opt/allot/migration/netx_14_5_db_host_schemas.sql 

--- public schema
set search_path=public,pg_catalog;

-- fix is_sensor, is_cluster values according to table cluster_config
update migration.hosts set is_sensor=true, is_cluster=true, f_aos=true where host_id <> 1 and host_id in (select cluster_id from migration.sensor_clusters );
update migration.hosts set is_sensor=true, is_cluster=false, f_aos=true where host_id <> 1 and host_id not in (select cluster_id from migration.sensor_clusters );

insert into public.hosts(host_id,name,ip,is_hydra,cap_hydra,is_sensor,cap_sensor,cap_tasks_max,ssh_key,descr,shutdown,tunnel_via, f_aos,is_cluster) 
  select host_id,name,ip,is_hydra,cap_hydra,is_sensor,cap_sensor,cap_tasks_max,ssh_key,descr,shutdown,tunnel_via, f_aos,is_cluster from migration.hosts where host_id <> 1;

insert into public.groups(group_id,name,descr,f_inside,f_dos,f_rawcap,f_decodetun,f_quarantine) 
  select group_id,name,descr,f_inside,f_dos,f_rawcap,f_decodetun,f_quarantine from migration.groups where group_id not in (900,901); 
  
insert into public.permissions( user_id, attribute , host_id,group_id) 
  select user_id, attribute , host_id,group_id from migration.permissions where user_id <> 0;  
  
insert into public.sensor_clusters(cluster_id,member_id ) 
  select cluster_id,member_id from migration.sensor_clusters;

insert into public.subsystems(subsystem_id,name,host_id,alive,cookie) 
  select subsystem_id,name,host_id,alive,cookie from  migration.subsystems where host_id <> 1;  
  
insert into public.cluster_config(cluster_id,min_sensors,fail_grace) 
  select cluster_id,min_sensors,fail_grace from migration.cluster_config;  
  
insert into public.data_tables(table_id,host_id,group_id,struct_id, relid, width , period,cookie) 
  select table_id,host_id,group_id,struct_id, relid, width , period,cookie from migration.data_tables;  
 
insert into public.group_config(prefix,group_id,"from","to",descr) 
  select prefix,group_id,"from","to",descr from migration.group_config;  
 
insert into public.group_mapping(host_id,group_id) 
   select host_id,group_id from migration.group_mapping; 
   
delete from public.smtp; 
insert into smtp select * from migration.smtp; 
  
--- auth schema
delete from migration.passwd where username='admin';
insert into auth.passwd(username,uid,password,is_super,mail_id,allow_ad_hoc_samples,allow_hbad_mitigation,allow_hbad_samples,allow_nbad_mitigation)                                       
 select username,uid,'no',is_super,mail_id,allow_ad_hoc_samples,allow_hbad_mitigation,allow_hbad_samples,allow_nbad_mitigation from migration.passwd where uid <> 0;
 -- set password from user admin(uid=0)
update auth.passwd set password=(select password from auth.passwd where uid=0) where uid <>0; 

--- flood schema
insert into flood.thresholds(threshold_id,name,descr,disable,group_id, host_id,stat_id,grace,min,value,dyn_short,dyn_long,dyn_percent)
  select threshold_id,name,descr,disable,group_id, host_id,stat_id,grace,min,value,dyn_short,dyn_long,dyn_percent from migration.thresholds;
  
insert into flood.types(type_id,name,descr) 
  select type_id,name,descr from  migration.types where type_id >= 1000;  
 
delete from flood.bgp_config; 
insert into flood.bgp_config(ip,timeout,top_hosts_limit,top_hosts_bw,isactive,as_number, server,rtbhcom,dvrtcom,updated,profiling,syslog)
  select ip,timeout,top_hosts_limit,top_hosts_bw,isactive,as_number, server,rtbhcom,dvrtcom,updated,profiling,syslog from migration.bgp_config;  
  
delete from flood.bgp_peers; 
insert into  flood.bgp_peers(peer_ip, trigger_types_mask, as_number, password, status)
  select peer_ip, trigger_types_mask, as_number, password, status  from migration.bgp_peers; 
  
--- flood.mtg_map after notify schema migration  
  
--- config schema   
insert into config.data( modified,path,name_id,auth_id,host_id,value) 
  select modified,path,name_id,auth_id,host_id,value from migration.data where host_id <>0;

insert into config.names(name_id,name) 
  select name_id,name from migration.names where name_id not in (select name_id from config.names);  
  
--- report schema
insert into report.list( report_id,created,modified, uid,name,description,period) 
  select report_id,created,modified, uid,name,description,period from migration.list;  
  
insert into report.mail(report_id,mail_id) 
  select report_id,mail_id from migration.mail;  
  
insert into report.views(view_id,report_id,"order",definition) 
  select view_id,report_id,"order",definition from migration.views;  

--- notify schema
-- first need check if require addaption to notify.types and public.post_target_types - id's
DO LANGUAGE plpgsql $$
    DECLARE 
        notify_types integer :=0;
        post_target_types integer :=0;
	BEGIN 
	
	 IF exists (select 1 from migration.notify_types where type_id=2 and name='quarantine') THEN notify_types :=1; END IF; 
	 IF exists (select 1 from migration.post_target_types where target_type_id=7 and name='redback') THEN post_target_types :=1; END IF; 
	 
	 IF notify_types = 1 THEN
	    RAISE NOTICE 'Update types_id in migration notify schema tables'; 
	    
	    UPDATE migration.fields set type_id = -1 where type_id=3;
        UPDATE migration.fields set type_id = 3 where type_id=2;
        UPDATE migration.fields set type_id = 2 where type_id=-1;
    
        UPDATE migration.filters set type_id = -1 where type_id=3;
        UPDATE migration.filters set type_id = 3 where type_id=2;
        UPDATE migration.filters set type_id = 2 where type_id=-1;
	 
	    UPDATE migration.templates set type_id = -1 where type_id=3;
        UPDATE migration.templates set type_id = 3 where type_id=2;
        UPDATE migration.templates set type_id = 2 where type_id=-1;
    
        UPDATE migration.filter_parts set type_id = -1 where type_id=3;
        UPDATE migration.filter_parts set type_id = 3 where type_id=2;
        UPDATE migration.filter_parts set type_id = 2 where type_id=-1;
    
        UPDATE migration.filter_templates set type_id = -1 where type_id=3;
        UPDATE migration.filter_templates set type_id = 3 where type_id=2;
        UPDATE migration.filter_templates set type_id = 2 where type_id=-1;
        
	 END IF; 
	 
	 IF post_target_types = 1 THEN
	    RAISE NOTICE 'Update target_types_id in migration notify schema tables'; 
	    
	    UPDATE migration.targets set target_type_id = -1 where target_type_id=7;
        UPDATE migration.targets set target_type_id = -2 where target_type_id=10;
        UPDATE migration.targets set target_type_id = -3 where target_type_id=11;
        UPDATE migration.targets set target_type_id = 10 where target_type_id=-1;
        UPDATE migration.targets set target_type_id = 11 where target_type_id=-2;
        UPDATE migration.targets set target_type_id = 7 where target_type_id=-3;
    
        UPDATE migration.templates set target_type_id = -1 where target_type_id=7;
        UPDATE migration.templates set target_type_id = -2 where target_type_id=10;
        UPDATE migration.templates set target_type_id = -3 where target_type_id=11;
        UPDATE migration.templates set target_type_id = 10 where target_type_id=-1;
        UPDATE migration.templates set target_type_id = 11 where target_type_id=-2;
        UPDATE migration.templates set target_type_id = 7 where target_type_id=-3;
    
        UPDATE migration.filter_templates set target_type_id = -1 where target_type_id=7;
        UPDATE migration.filter_templates set target_type_id = -2 where target_type_id=10;
        UPDATE migration.filter_templates set target_type_id = -3 where target_type_id=11;
        UPDATE migration.filter_templates set target_type_id = 10 where target_type_id=-1;
        UPDATE migration.filter_templates set target_type_id = 11 where target_type_id=-2;
        UPDATE migration.filter_templates set target_type_id = 7 where target_type_id=-3;
	    
	 END IF;   
		 
	END
$$;

-- Fix ID's migration notify schema tables
--fields
alter table migration.fields add new_id integer;
update migration.fields m set new_id =  n.field_id from notify.fields n
   where  n.type_id=m.type_id and n.data_type_id=m.data_type_id and  n.name=m.name 
          and n.descr=m.descr 
          and ( n.constraints=m.constraints OR (n.constraints is null and m.constraints is null)); 
           
--filters
alter table migration.filters add new_id integer;
alter table migration.filters add new_parent integer;

update migration.filters m set new_id =  n.filter_id, new_parent=n.parent from notify.filters n
  where  n.type_id=m.type_id and  n.name=m.name;
update migration.filters m set new_id = filter_id, new_parent=parent  
  where new_id is null;
          
--templates
alter table migration.templates add new_id integer;

update migration.templates m set new_id =  n.template_id from notify.templates n
  where  n.type_id=m.type_id and n.target_type_id=m.target_type_id 
         and  n.name=m.name and n.template=m.template;
           
-- Fix ID's in related tables
 --filter_parts
 update migration.filter_parts fp set filter_id=f.new_id from migration.filters f
   where fp.filter_id=f.filter_id;
 update migration.filter_parts fp set field_id=f.new_id from migration.fields f
   where fp.field_id=f.field_id;
            
 --filter_templates
 update migration.filter_templates ft set filter_id=f.new_id from migration.filters f
   where ft.filter_id=f.filter_id;
           
 update migration.filter_templates ft set template_id=t.new_id from migration.templates t
   where ft.template_id=t.template_id;  
 
 --filter_targets           
 update migration.filter_targets ft set filter_id=f.new_id from migration.filters f
   where ft.filter_id=f.filter_id;

-- merge to notify schema
insert into notify.filters(filter_id,type_id,name,descr,parent,keepalive,disable,modified,generation,update_on_stop)
  select new_id,type_id,name,descr,parent,keepalive,disable,modified,generation,update_on_stop from migration.filters 
     where new_id not in (select filter_id from notify.filters); 
     
insert into notify.filter_parts(filter_id,field_id,type_id,data_type_id,operator_id,operand)  
  select filter_id,field_id,type_id,data_type_id,operator_id,operand from migration.filter_parts mfp
    where not exists ( select 1 from  notify.filter_parts nfp where nfp.filter_id=mfp.filter_id and nfp.field_id=mfp.field_id);
    
insert into notify.templates (template_id, target_type_id, type_id, name, template, allow_targets) 
  select new_id, target_type_id, type_id, name, template, allow_targets from migration.templates
    where new_id not in (select template_id from notify.templates); 
    
insert into notify.filter_templates(filter_id,type_id,target_type_id,template_id) 
   select filter_id,type_id,target_type_id,template_id from migration.filter_templates mft
    where not exists ( select 1 from  notify.filter_templates nft 
                        where nft.filter_id=mft.filter_id and nft.template_id=mft.template_id);           
	
 --- migration.targets table modification and fix target_id in related tables(migration schema)
 alter table migration.targets add new_id integer;
 alter table migration.targets add need_copy boolean default false; 
 
 -- the same entries in notify.targets and migration.targets
 update migration.targets m set new_id=target_id where                 
   exists( select 1 from notify.targets n where m.target_id=n.target_id and 
           m.target_type_id=n.target_type_id and m.name=n.name and m.addr=n.addr) and m.new_id is null;

--  Block targets         
  update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr= '/usr/local/ntais2/lib/post/scripts/pattern/aos-block-top-hosts-rx.rb' and n.name='blockTopHostRx';
  
  update migration.targets m set new_id=n.target_id
    from notify.targets n where         
   m.addr= '/usr/local/ntais2/lib/post/scripts/pattern/aos-block-top-hosts-tx.rb' and n.name='blockTopHostTx' ;
  
  update migration.targets m set new_id=n.target_id
    from notify.targets n where 
   m.addr= '/usr/local/ntais2/lib/post/scripts/pattern/aos-block-top-hosts-tx-rx.rb' and n.name='blockTopHostTxRx' ;

-- BGP targets
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_default_timeout.rb' and n.name='bgp-host-default';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_SUBNET_default_timeout.rb' and n.name='bgp-subnet-default';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_timeout10m.rb' and n.name='bgp-host-10m';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_SUBNET_timeout10m.rb' and n.name='bgp-subnet-10m';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_timeout20m.rb' and n.name='bgp-host-20m';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_SUBNET_timeout20m.rb' and n.name='bgp-subnet-20m';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_timeout60m.rb' and n.name='bgp-host-1h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_SUBNET_timeout60m.rb' and n.name='bgp-subnet-1h';
  
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_timeout2h.rb' and n.name='bgp-host-2h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_SUBNET_timeout2h.rb' and n.name='bgp-subnet-2h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_timeout6h.rb' and n.name='bgp-host-6h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_SUBNET_timeout6h.rb' and n.name='bgp-subnet-6h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_timeout24h.rb' and n.name='bgp-host-24h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_SUBNET_timeout24h.rb' and n.name='bgp-subnet-24h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where
  m.addr like '%bgp_HOST_timeout48h.rb' and n.name='bgp-host-48h';
    
 update migration.targets m set new_id=n.target_id
    from notify.targets n where                       
 m.addr like '%bgp_SUBNET_timeout48h.rb' and n.name='bgp-subnet-48h';   
           
 --- Not exists targets in notify.targets
  update migration.targets set new_id=nextval('notify.targets_target_id_seq'::regclass), need_copy=true  where new_id is NULL;
  
  -- Fix complete_targets 
  truncate table migration.complete_targets;
  insert into migration.complete_targets select new_id from migration.targets where complete=true;
 
 -- Fix target_id in related schemas
  update migration.filter_targets ft set target_id=t.new_id from migration.targets t where ft.target_id=t.target_id ;
  
  update migration.map smp set smp_id=t.new_id from migration.targets t where smp.smp_id=t.target_id;
  
  update migration.mtg_map flood set sg_id=t.new_id from migration.targets t where flood.sg_id=t.target_id;
  
  update migration.mtg_sg_state flood set sg_id=t.new_id from migration.targets t where flood.sg_id=t.target_id;
  
  -- insert data in targets, filter_targets, complete_targets
  insert into notify.targets(target_id, target_type_id, name, addr, descr, complete) 
    select new_id,target_type_id, name, addr, descr, complete from migration.targets
      where need_copy=true;	
	  
  insert into notify.complete_targets(target_id) select target_id from migration.complete_targets
    where target_id not in (select target_id from notify.complete_targets);  
	
  insert into notify.filter_targets(filter_id, target_id) select filter_id, target_id from migration.filter_targets
    where filter_id not in (select filter_id from notify.filter_targets);  
  
--- smp schema (After notify.targets)
insert into smp.map(host_id,smp_id) select host_id,smp_id from migration.map;

--- flood.mtg_map (After notify.targets)  
insert into flood.mtg_map( host_id,sg_id) select host_id,sg_id from migration.mtg_map;

-- flood.mtg_sg_state (After notify.complete_targets)
insert into flood.mtg_sg_state(sg_id,at,alive,details,pat_count_max,blob_size,blob_size_max) 
  select sg_id,at,alive,details,pat_count_max,blob_size,blob_size_max from migration.mtg_sg_state ;

-- fix sequences values
DO LANGUAGE plpgsql $$
    DECLARE seq_value integer;
	BEGIN 
	 select max(host_id)+1 into seq_value from public.hosts;
	 perform pg_catalog.setval('public.hosts_host_id_seq',seq_value,false);
	 
	 select max(group_id)+1 into seq_value from public.groups;
	 if seq_value > 1001 then
	    perform pg_catalog.setval('public.groups_group_id_seq',seq_value,false);
	 end if;
	 
	 select max(subsystem_id)+1 into seq_value from public.subsystems;
	 if seq_value > 5 then
	    perform pg_catalog.setval('public.subsystems_subsystem_id_seq',seq_value,false);
	 end if;   
	 
	 select max(table_id)+1 into seq_value from public.data_tables;
	 perform pg_catalog.setval('public.data_tables_table_id_seq',seq_value,false);
	 
	 select max(uid)+1 into seq_value from auth.passwd;
	 if seq_value > 10000 then
	    perform pg_catalog.setval('auth.passwd_uid_seq',seq_value,false);
	 end if;
	 
	 select max(threshold_id)+1 into seq_value from flood.thresholds;
	  if seq_value > 1000 then
	     perform pg_catalog.setval('flood.thresholds_threshold_id_seq',seq_value,false);
	  end if;
	 
	 select max(type_id)+1 into seq_value from flood.types; 
	 if seq_value > 32 then
	    perform pg_catalog.setval('flood.types_type_id_seq',seq_value,false);
	 end if;
	 
	 select max(name_id)+1 into seq_value from config.names;
	 if seq_value > 5 then
	    perform pg_catalog.setval('config.names_name_id_seq',seq_value,false);
	 end if;   
	 
	 select max(report_id)+1 into seq_value from report.list;
	 perform pg_catalog.setval('report.list_report_id_seq',seq_value,false);
	 
	 select max(view_id)+1 into seq_value from report.views;
	 perform pg_catalog.setval('report.views_view_id_seq',seq_value,false);
	 
	 select max(filter_id)+1 into seq_value from notify.filters;
	 if seq_value > 60 then
	    perform pg_catalog.setval('notify.filters_filter_id_seq',seq_value,false); 
	 end if;
	 
	 select max(template_id)+1 into seq_value from notify.templates;
	 if seq_value > 40 then
	    perform pg_catalog.setval('notify.templates_template_id_seq',seq_value,false);  
	 end if;
	 
	 select max(target_id)+1 into seq_value from notify.targets;
	 if seq_value > 40 then
	    perform pg_catalog.setval('notify.targets_target_id_seq',seq_value,false); 
	 end if; 
	 
	END
$$; 

-- fix h-schemas owner - grants 
DO LANGUAGE plpgsql $$
    DECLARE nspname_var TEXT;
   BEGIN
 
  FOR nspname_var IN
   SELECT nspname 
    FROM pg_namespace
    WHERE nspname LIKE 'h%' AND nspname <> 'h1'
    ORDER BY nspname
  LOOP
  
    EXECUTE 'ALTER SCHEMA ' || nspname_var || ' OWNER TO ndbadm ' ;
    EXECUTE 'GRANT ALL ON SCHEMA ' || nspname_var || ' TO ndbadm ' ;
    EXECUTE 'GRANT USAGE ON SCHEMA ' || nspname_var || ' TO GROUP ndb_readers ' ;
    EXECUTE 'GRANT ALL ON SCHEMA ' || nspname_var || ' TO GROUP ndb_writers ' ;
   --RAISE NOTICE 'Change owner-grants for % schema' , nspname_var;
  END LOOP;
  	 
  END
$$; 		

-- Enable all triggers on end of migration process
SET session_replication_role = DEFAULT;