-- DB upgrade for 15.1.10b09

DO LANGUAGE plpgsql $$
	BEGIN
		PERFORM 1
		    FROM
		        notify.templates 
		    WHERE
		        template_id = 40;


	IF NOT FOUND THEN
		SET search_path = notify, pg_catalog;
		COPY templates (template_id, target_type_id, type_id, name, template, allow_targets) FROM  '/opt/allot/upgrade/DB/templates_15_1_10b09.dat';

		PERFORM pg_catalog.setval('templates_template_id_seq', 40, true);

	END IF;

	
	PERFORM 1
		FROM notify.complete_targets 
		WHERE target_id 
 			IN (SELECT target_id FROM notify.targets WHERE name LIKE 'blockTopHost%');
 			
 	IF NOT FOUND THEN
		SET search_path = notify, pg_catalog;	
		
		INSERT INTO complete_targets(target_id) SELECT target_id FROM notify.targets WHERE name LIKE 'blockTopHost%';
	END if;
	
   END;	
$$;  