-- DB upgrade for 15.2.10b01 (DB refactoring phase 1)

DO LANGUAGE plpgsql $$
    DECLARE
		db_ref_val     INTEGER;
		alert_id       INTEGER;
		seq_value      INTEGER; 
	
		BEGIN
		  db_ref_val := public.get_int_param('DB_Refact','phase_1');
		  
		  IF db_ref_val is NULL  OR db_ref_val <> 1 THEN
		 
          --	drop functions/trigger
          drop trigger if exists body__parse ON fast.entity_data;
          drop trigger if exists no_loops ON fast.entity_links;
          
          drop function if exists fast.attrs(integer[], text[]);
          drop function if exists fast.entity_data__body() ;
          drop function if exists fast.entity_data__body__pattern_alerts(new fast.entity_data) ;
          drop function if exists fast.entity_data__body__pattern_alerts__calc_flood_alerts(new fast.entity_data) ;
          drop function if exists fast.entity_data__body__pattern_alerts__parse(new fast.entity_data) ;
          drop function if exists fast.entity_data__body__pattern_report(new fast.entity_data) ;
          drop function if exists fast.entity_data__body__pattern_report__parse(new fast.entity_data) ;
          drop function if exists fast.entity_data__body__pattern_report__propagate(new fast.entity_data) ;
          drop function if exists fast.entity_data__body__pattern_top_hosts(new fast.entity_data) ;
          drop function if exists fast.entity_data__body__pattern_top_hosts__parse(new fast.entity_data) ; 
          drop function if exists fast.pattern__register(integer[]) ;    
          drop function if exists fast.pattern_for_mtg_sg(integer) ;   
          drop function if exists fast.entity_links__no_loops();
          drop function if exists fast.entity_links__check_dir(integer[], boolean);
          drop function if exists flood.mtg_req_auto_block_impl(integer, integer, integer, timestamp with time zone) ;
          drop function if exists flood.mtg_req_auto_block_with_action_impl(integer, integer, integer, timestamp with time zone, flood.mtg_req_action) ; 
          drop function if exists flood.mtg_req_manual_block_impl(integer, integer, integer, flood.mtg_req_action, timestamp with time zone, boolean) ;
          
          
          -- change schema
          ALTER TABLE flood.alert_types ADD COLUMN type  text;
          
          CREATE TABLE flood.amplification_alerts(
            alert_type_id INTEGER NOT NULL,
            port INTEGER NOT NULL,
            PRIMARY KEY (alert_type_id)
          );

          ALTER TABLE flood.amplification_alerts OWNER TO ndbadm;
          
         COMMENT ON TABLE flood.amplification_alerts IS 'amplifications for alerts';
         
         CREATE TABLE flood.bogons (
	       address        TEXT NOT NULL
         );

         ALTER TABLE flood.bogons OWNER TO ndbadm;

         COMMENT ON TABLE flood.bogons IS 'Bogon List (Bogus outside networks) is a non-standard but highly regarded set of addresses that you should block from accessing your Network';

          
          -- add/change permissions
          GRANT ALL ON FUNCTION flood.aggregate_alerts(flood_id_in integer) TO nms;
          GRANT ALL ON FUNCTION flood.pattern_prevalent_hosts_real(flood_id integer, sample_id integer, pattern_id integer, side "char", null_if_no_prevalent_hosts boolean, OUT ip inet, OUT pkts integer) TO nms; 
          GRANT ALL ON TABLE fast.pat_contents TO nms;
          GRANT ALL ON TABLE fast.top_host_sets TO nms;
          GRANT ALL ON TABLE fast.top_hosts TO nms;
          GRANT ALL ON SEQUENCE fast.top_host_sets_ths_id_seq TO nms;
          GRANT ALL ON TABLE flood.alerts TO nms;
          
          GRANT ALL ON TABLE flood.amplification_alerts TO ndbadm;
          GRANT ALL ON TABLE flood.amplification_alerts TO nms;
          GRANT ALL ON TABLE flood.bogons TO ndbadm;
          GRANT ALL ON TABLE flood.bogons TO nms;
          
          	-- (David) Add missing data to flood.alert_types and flood.amplification_alerts
          DELETE FROM flood.alert_types WHERE name = 'DDOS';
          DELETE FROM flood.alert_types WHERE name = 'DOS';
          
			SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'DDoS';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('DDoS','D','dos');
ELSE
UPDATE flood.alert_types SET type = 'dos', class = 'D' WHERE alert_type_id = alert_id;
END IF; 

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'DoS';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('DoS','D','dos');
ELSE
UPDATE flood.alert_types SET type = 'dos', class = 'D' WHERE alert_type_id = alert_id;
END IF; 

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'Scan';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('Scan','S','scan');
ELSE
UPDATE flood.alert_types SET type = 'scan', class = 'S' WHERE alert_type_id = alert_id;
END IF; 

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'Bad checksum';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('Bad checksum','M','badchecksum');
ELSE
UPDATE flood.alert_types SET type = 'badchecksum', class = 'M' WHERE alert_type_id = alert_id;
END IF; 

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'Truncated packets';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('Truncated packets','M','truncated');
ELSE
UPDATE flood.alert_types SET type = 'truncated', class = 'M' WHERE alert_type_id = alert_id;
END IF;

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'Bogons hosts';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('Bogons hosts','B','bogon');
ELSE
UPDATE flood.alert_types SET type = 'bogon', class = 'B' WHERE alert_type_id = alert_id;
END IF;

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'QODT amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('QODT amplification','A','amplification') RETURNING alert_type_id INTO alert_id;    
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,17);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'CHARGEN amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('CHARGEN amplification','A','amplification') RETURNING alert_type_id INTO alert_id;    
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,19);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'DNS amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('DNS amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,53);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'Portmap amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('Portmap amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,111);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'NTP amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('NTP amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,123);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'NetBIOS amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('NetBIOS amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,137);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'SNMP amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('SNMP amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,161);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'RIP amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('RIP amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,389);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'SSDP amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('SSDP amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,520);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'mDNS amplication';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('mDNS amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,1900);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'LDAP amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('LDAP amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,5353);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'Steam amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('Steam amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,27015);

SELECT INTO alert_id alert_type_id FROM flood.alert_types WHERE name = 'Quake amplification';
IF alert_id is NULL THEN
INSERT INTO flood.alert_types(name, class,type) VALUES ('Quake amplification','A','amplification') RETURNING alert_type_id INTO alert_id;
ELSE
UPDATE flood.alert_types SET type = 'amplification', class = 'A' WHERE alert_type_id = alert_id;
END IF;
INSERT INTO flood.amplification_alerts (alert_type_id, port) VALUES (alert_id,27960);

-- If we missed something without type then set as amplification
UPDATE flood.alert_types SET type = 'amplification' WHERE type is null;

select max(alert_type_id) into seq_value from flood.alert_types;

PERFORM pg_catalog.setval('flood.alert_types_alert_type_id_seq', seq_value, true);

		  truncate table flood.alerters cascade;
		  --delete from flood.alerters;
		  INSERT INTO flood.alerters (alerter_id, name) VALUES (1,'attack-type');
		  INSERT INTO flood.alerters (alerter_id, name) VALUES (2,'tcpdump');
		  PERFORM pg_catalog.setval('flood.alerters_alerter_id_seq', 2, true);

		  INSERT INTO flood.bogons (address) VALUES ('10.0.0.0/8');
		  INSERT INTO flood.bogons (address) VALUES ('127.0.0.0/8');
		  INSERT INTO flood.bogons (address) VALUES ('169.254.0.0/16');
		  INSERT INTO flood.bogons (address) VALUES ('172.16.0.0/12');
		  INSERT INTO flood.bogons (address) VALUES ('192.0.2.0/24');
		  INSERT INTO flood.bogons (address) VALUES ('192.168.0.0/16');
		  
		  UPDATE public.statistics SET name = 'byt_incom_ip', descr = 'incoming total IPv4 + IPv6 bytes' WHERE stat_id = 17 and struct_id = 2;
		  UPDATE public.statistics SET name = 'byt_outgo_ip', descr = 'outgoing total IPv4 + IPv6 bytes' WHERE stat_id = 18 and struct_id = 2;
		  UPDATE public.statistics SET name = 'pkt_incom_ip', descr = 'incoming total IPv4 + IPv6 packets' WHERE stat_id = 19 and struct_id = 2;
		  UPDATE public.statistics SET name = 'pkt_outgo_ip', descr = 'outgoing total IPv4 + IPv6 packets' WHERE stat_id = 20 and struct_id = 2;
		  UPDATE public.statistics SET name = 'byt_incom_other', descr = 'incoming other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) bytes' WHERE stat_id = 9 and struct_id = 2;
		  UPDATE public.statistics SET name = 'byt_outgo_other', descr = 'outgoing other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) bytes' WHERE stat_id = 10 and struct_id = 2;
		  UPDATE public.statistics SET name = 'pkt_incom_other', descr = 'incoming other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) packets' WHERE stat_id = 11 and struct_id = 2;
		  UPDATE public.statistics SET name = 'pkt_outgo_other', descr = 'outgoing other IPv4 + IPv6 (not TCP, UDP, ICMP or ESP) packets' WHERE stat_id = 12 and struct_id = 2;
		  
		  UPDATE public.statistics SET name = 'in_in_frag_ip', descr = 'incoming fragmented / total IPv4 + IPv6 ratio' WHERE stat_id = 85  and struct_id = 2;
		  UPDATE public.statistics SET name = 'in_in_icmp_ip', descr = 'incoming ICMP / total IPv4 + IPv6 ratio' WHERE stat_id = 86 and struct_id = 2;
		  UPDATE public.statistics SET name = 'in_out_other_other', descr = 'incoming / outgoing other IPv4 + IPv6 ratio' WHERE stat_id = 87 and struct_id = 2;
		  UPDATE public.statistics SET name = 'in_in_trunc_ip', descr = 'incoming truncated / total IPv4 + IPv6 ratio' WHERE stat_id = 93 and struct_id = 2;
		  UPDATE public.statistics SET name = 'in_out_unreach_ip', descr = 'incoming ICMP UNR / outgoing total IPv4 + IPv6 ratio' WHERE stat_id = 95 and struct_id = 2;
		  
		  UPDATE public.statistics SET name = 'out_in_other_other', descr = 'outgoing / incoming other IPv4 + IPv6 ratio' WHERE stat_id = 103 and struct_id = 2;
		  UPDATE public.statistics SET name = 'out_in_unreach_ip', descr = 'outgoing ICMP UNR / incoming total IPv4 + IPv6 ratio' WHERE stat_id = 108 and struct_id = 2;
		  UPDATE public.statistics SET name = 'out_out_frag_ip', descr = 'outgoing fragmented / total IPv4 + IPv6 ratio' WHERE stat_id = 112 and struct_id = 2;
		  UPDATE public.statistics SET name = 'out_out_icmp_ip', descr = 'outgoing ICMP / total IPv4 + IPv6 ratio' WHERE stat_id = 113 and struct_id = 2;
		  UPDATE public.statistics SET name = 'out_out_trunc_ip', descr = 'outgoing truncated / total IPv4 + IPv6 ratio' WHERE stat_id = 116  and struct_id = 2;
     
          IF db_ref_val is NULL THEN
            INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('DB_Refact','phase_1', 1,'Database refactoring phase 1(fast, IPV6) status(1-done;0-not)');
          ELSE
            UPDATE public.PARAM SET INT_VAL=1 WHERE NAME='DB_Refact' and SUBNAME='phase_1' ;
          END IF;  
          
          END IF;
		END;
	$$; 
	
-- create view 
   \i /opt/allot/DB/sql/view_attrs_grouped.sql 	
   
 -- new/changed functions   
	
	 CREATE OR REPLACE FUNCTION fast.pat_strips__parse() RETURNS trigger
			 LANGUAGE plpgsql
		AS $_$
		DECLARE
		i 		int;
		bytes 	bytea	:= new.values;
		length	int 	:= octet_length(new.values);
		tmpLen 	int 	:= 1;
		suBytes bytea;
		begin
		-- Return if not layer 4		
		IF NEW.layer <> 4 THEN 
			RETURN NEW;
		END IF;
		
		-- Walk through the offsets and build all binary substring from 'values'
		FOR i IN REVERSE length..1
		LOOP
			IF NEW.offsets[i] + 1 != NEW.offsets[i+1] THEN
				tmpLen :=1;
			ELSE
				tmpLen := tmpLen + 1;
			END IF;
			suBytes := substring(bytes from i for tmpLen);

			-- Enter binary substring to pat_payload_search
	        BEGIN
			    INSERT INTO fast.pat_payload_search(pat_strip_id, word)
			      VALUES(NEW.pat_strip_id, suBytes);
			-- Duplicates are prevented by the table constrains
			-- Embrace the rejection
        	EXCEPTION WHEN unique_violation THEN
 		       RAISE NOTICE '{%, %} already exists in table. Skipping...', NEW.pat_strip_id, suBytes;
            	-- Do nothing, and skip this duplicate data.
        	END;

 			END LOOP;
		
			return NEW;

		end
	$_$;
	
	CREATE OR REPLACE FUNCTION flood.state__fill_top_hosts() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
  	rec RECORD;
	BEGIN
  	DELETE FROM flood.top_hosts_dst WHERE flood_id = NEW.flood_id;
  	DELETE FROM flood.top_hosts_src WHERE flood_id = NEW.flood_id;

  -- Insert into flood.top_hosts_* only when flood.state.stop is not NULL, i.e.
  -- only when a flood has finished.
  IF NEW.stop IS NULL THEN
    RETURN NEW;
  END IF;

  FOR rec IN
    SELECT side,
	   ip,
	   avg_pps/sample_cnt AS avg_pps,
	   avg_bps/sample_cnt AS avg_bps
      FROM (SELECT flood_id,
		   side,
		   ip,
		   SUM(ip_packets/sa.duration) AS avg_pps,
		   SUM((ip_packets/sa.duration)*ROUND(sa.bytes/sa.packets))*8
		     AS avg_bps
	      FROM flood.samples s
	      JOIN (
		SELECT flood_id,
		       sample_id,
		       ths.side,
		       th.ip,
		       MAX(ROUND(a.pr_packets * ep.matches * th.matches)::INTEGER)
			 AS ip_packets
		  FROM flood.samples s
		  JOIN fast.entity_patterns ep ON (ep.entity_id = s.report_id)
		  JOIN (SELECT entity_id, value::INTEGER AS pr_packets
			  FROM fast.attrs
			  JOIN fast.attr_types      at USING (attr_type_id)
			 WHERE at.name = 'Entries') a USING (entity_id)
		  JOIN fast.top_host_sets ths ON (ths.entity_id = s.top_hosts_id
		    AND ths.pattern_id = ep.pattern_id)
		  JOIN fast.top_hosts th USING (ths_id)
		 GROUP BY 1, 2, 3, 4) AS ip_data USING (flood_id, sample_id)
	      JOIN (SELECT sample_id, bytes, packets, duration 
				FROM flood.samples
				JOIN fast.attrs_grouped on (entity_id=sample_id)
				WHERE flood_id = NEW.flood_id
					   and "error" is null ) AS sa USING (sample_id)
	     WHERE flood_id = NEW.flood_id
	     GROUP BY 1, 2, 3) AS foo
      JOIN (SELECT flood_id, COUNT(*) AS sample_cnt
	      FROM flood.samples
	     GROUP BY 1) count USING (flood_id)
  LOOP
  
    -- prevent CONSTRAINT CHECK problems
	IF rec.avg_bps is NULL THEN rec.avg_bps = 1; END IF;
	IF rec.avg_pps is NULL THEN rec.avg_pps = 1; END IF;
	IF rec.avg_bps = 0 THEN rec.avg_bps = 1; END IF;
	IF rec.avg_pps = 0 THEN rec.avg_pps = 1; END IF;
	
    IF rec.side = 'd' THEN
      INSERT INTO flood.top_hosts_dst (flood_id, ip, avg_bps, avg_pps)
        VALUES (NEW.flood_id, rec.ip, rec.avg_bps, rec.avg_pps);
    ELSE
      INSERT INTO flood.top_hosts_src (flood_id, ip, avg_bps, avg_pps)
        VALUES (NEW.flood_id, rec.ip, rec.avg_bps, rec.avg_pps);
    END IF;
  END LOOP;

  	RETURN NEW;
	END$$;	