-- DB upgrade for 15.2.10b01 (DB refactoring phase 2)

-- Remove plruby

DO LANGUAGE plpgsql $$
    DECLARE
		db_ref_val     INTEGER;
	
		BEGIN
		  db_ref_val := public.get_int_param('DB_Refact','phase_2');
		  
		  IF db_ref_val is NULL  OR db_ref_val <> 1 THEN
          
          DROP PROCEDURAL LANGUAGE IF EXISTS plruby CASCADE;
          
          --PUBLIC
          --drop function if exists public.array_max(anyarray);
          --drop function if exists public.array_min(anyarray);
          --drop function if exists public.array_sorted_p(anyarray, boolean, boolean);
          drop function if exists public.array_to_setof(anyarray);
          drop function if exists public.create_modified_propagation_rules(text, text, text);
          drop function if exists public.create_notification_rules(text);
          drop function if exists public.create_set_modified_trigger(text);
          drop function if exists public.getprotobyname(text);
          drop function if exists public.getprotobynumber(integer) CASCADE; 
          drop function if exists public.getprotoents();
          drop function if exists public.pack_counter(bigint, bigint);
          drop function if exists public.pg_freespace_free(regclass) CASCADE;
          --drop function if exists public.query_stat_data(text, integer[]);
          drop function if exists public.unpack_counter(integer, bigint);
  
          --drop view if exists public.pg_fsm;
          drop table if exists public.plruby_singleton_methods;    
          
          --AUTH
          ALTER TABLE auth.passwd DROP CONSTRAINT super_check;
          ALTER TABLE auth.passwd DROP CONSTRAINT target_mail;  
          
          drop view if exists auth.shadow_pam;
          drop table if exists auth.shadow; 
          
          --QUARANTINE
          --ALTER TABLE quarantine.events DROP CONSTRAINT events_target_proto_check;
          
          --REPORT
          ALTER TABLE report.mail DROP CONSTRAINT target_mail;
          
          --NOTIFY
          drop trigger if exists type_fields_check_trigger on notify.type_fields;
          drop function if exists notify.type_fields_check();
          --drop function if exists notify.filter_tree_importance_check_p(text, integer);
          --drop function if exists notify.type_fields_valid(integer, text[]);
          
          drop table if exists notify.sql_val_list_depends CASCADE;
          drop table if exists notify.sql_val_list_not_found_msg_types CASCADE;
          drop table if exists notify.sql_val_lists CASCADE;
          drop table if exists notify.type_fields CASCADE; 
          
          --FLOOD
          --drop function if exists flood.get_graph(integer, text, integer, timestamp with time zone , real);
          --drop function if exists flood.pattern_attack_type(integer, integer, text, integer, integer);

          ALTER TABLE flood.mtg_sg_state DROP CONSTRAINT target_sg;
          ALTER TABLE flood.top_hosts_dst DROP CONSTRAINT top_hosts_dst_avg_bps_check;
          ALTER TABLE flood.top_hosts_dst DROP CONSTRAINT top_hosts_dst_avg_pps_check;    
          
          --FAST
          --drop trigger if exists insert_endpoint on fast.pat_contents;
          --drop function if exists fast.pat_contents__endpoint_insert();
          

          --ALTER TABLE fast.pat_strips DROP CONSTRAINT offsets__non_negative;
          --ALTER TABLE fast.pat_strips DROP CONSTRAINT offsets__sorted;
          ALTER TABLE fast.pat_strips DROP CONSTRAINT offsets__values__same_size;

          IF db_ref_val is NULL THEN
            INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('DB_Refact','phase_2', 1,'Database refactoring phase 2(remove plruby) status(1-done;0-not)');
          ELSE
            UPDATE public.PARAM SET INT_VAL=1 WHERE NAME='DB_Refact' and SUBNAME='phase_2' ;
          END IF;  
          
          END IF;
		END;
	$$; 	
	
-- PUBLIC
CREATE OR REPLACE FUNCTION public.inet_to_int8(addr inet) RETURNS bigint
    LANGUAGE plpgsql
    AS $$
    DECLARE
     ip_numeric numeric;
    BEGIN
     EXECUTE format('SELECT inet %L - %L', addr, '0.0.0.0') into ip_numeric;
      return ip_numeric;
  END
  $$;
  
 --
-- Name: query_stat_data(text,text[], integer[]); Type: FUNCTION; Schema: public; Owner: ndbadm
--

CREATE OR REPLACE FUNCTION public.query_stat_data(tbl text, colmn text[], points integer[]) RETURNS SETOF record
    LANGUAGE plpgsql
    AS $_$
    DECLARE
    timestamp_val integer;
    result        record;
    colmn_str   text;
	select_part text;
    select_down text;
    select_up text;
    BEGIN
     
     colmn_str := array_to_string(colmn, ',');
     select_part := format ('(select %s from %s where ',colmn_str,tbl);
     
     FOREACH timestamp_val in ARRAY points
     LOOP
      select_down := select_part || format('timestamp <= %L ORDER BY timestamp DESC LIMIT 1) UNION ',timestamp_val);
      select_up   := select_part || format('timestamp >  %L ORDER BY timestamp ASC LIMIT 1) ',timestamp_val);
      
       FOR result IN EXECUTE select_down || select_up
        LOOP
        RETURN NEXT result;
       END LOOP;
       
      END LOOP;
     
    END$_$;     


ALTER FUNCTION public.query_stat_data(tbl text, colmn text[], points integer[]) OWNER TO ndbadm;

CREATE OR REPLACE FUNCTION public.subsystem_alive(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
  -- Expire in 600 seconds, i.e. 10 minutes.
  UPDATE public.subsystems
    SET alive = CURRENT_TIMESTAMP + '600'::INTERVAL
    WHERE subsystem_id = $1;

  -- Return the suggested delay until the next heartbeat in seconds.
  SELECT 300$_$;
  
--FLOOD
--drop function if exists flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real);
CREATE OR REPLACE FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) RETURNS SETOF record
 LANGUAGE plpgsql 
    AS $_$
   DECLARE
    row_count_val integer;
    step_val integer;
    indx_val integer;
    
   BEGIN 

-- The data is unpacked from arrays in flood.graphs as necessary
-- and returned simply as a set of rows of `timestamp, value' columns.
--
-- The passed number of desired data points is only a guide; fewer or more
-- points may be returned.

   IF points < 2 THEN
     RAISE NOTICE ' % points - too few, at least 2 should be requested', points;
	 RETURN;
	END IF; 
	
  CREATE TEMPORARY TABLE temp_flood_graph_value (
	 ID serial,
     at_t timestamp with time zone,
     single_val real,
     ordering interval
	) ON COMMIT DROP; 	
	
-- Fill data from flood.graphs tables into temp_flood_graph_value
   INSERT INTO temp_flood_graph_value(at_t,single_val,ordering) 
    SELECT g.at, unnest(g.values) single_val, generate_series(0,array_length(g.values,1)-1)*g.resolution*interval '1 second' ord
     FROM flood.graphs g JOIN public.statistics s USING (stat_id) 
      WHERE g.flood_id=flood AND s.name = graph order by g.at,ord ;	 
    
    GET DIAGNOSTICS row_count_val = ROW_COUNT; 
    
    step_val := (row_count_val - 1)/(points -1);
    
    IF step_val < 1 THEN
	   step_val := 1;
	END IF; 
	
	indx_val := 1;
	
	FOR indx_val IN 1..row_count_val-2 BY step_val
	 LOOP
	   RETURN QUERY select (at_t + ordering ), single_val from temp_flood_graph_value where ID=indx_val;
	 END LOOP;
     -- Last record
	 RETURN QUERY select (at_t + ordering ), single_val from temp_flood_graph_value where ID=row_count_val;

  END
$_$; 

ALTER FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) OWNER TO ndbadm;

COMMENT ON FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) IS 'Returns graphing points for one traffic statistic of a flood';

REVOKE ALL ON FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) FROM PUBLIC;
REVOKE ALL ON FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) FROM ndbadm;
GRANT ALL ON FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) TO ndbadm;
GRANT ALL ON FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) TO ndb_readers;
GRANT ALL ON FUNCTION flood.get_graph(flood integer, graph text, points integer, OUT at timestamp with time zone, OUT value real) TO ndb_writers;

--drop function if exists flood.pattern_attack_type(flood_id integer, pattern_id integer, OUT attack_type text, OUT matches integer, OUT total integer);
CREATE OR REPLACE FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) RETURNS SETOF record
   LANGUAGE plpgsql 
    AS $_$
   DECLARE
    attack_type_val text;
    ep_val integer;
    tp_val integer;
    
    result_cur record;
    srcip_val integer;
    srcep_val integer;
    srctp_val integer;
    dstip_val integer;
    dstep_val integer; 
    dsttp_val integer;
    tmp_attack_type_val text := NULL;
    
   BEGIN 
   
   attack_type_val := NULL;
   ep_val :=0;
   tp_val :=0;
   
   CREATE TEMPORARY TABLE temp_flood_attack_type_1 (
	 sample_id  integer,
	 side       char,
	 ip_cnt     integer,
	 pkt_cnt1   integer,
	 pkt_cnt2   integer
	) ON COMMIT DROP; 
	
	CREATE TEMPORARY TABLE temp_flood_attack_type_2 (
	 sample_id  integer,
	 side       char,
	 ip_cnt     integer,
	 pkt_cnt1   integer
	) ON COMMIT DROP; 
	
	INSERT INTO temp_flood_attack_type_1(sample_id,side,ip_cnt,pkt_cnt1)
	 SELECT sample_id,
	  th.side,
	  ROUND((1 - th.match)/th.minmatch) + ip_cnt AS ip_cnt,
	  (SELECT flood.pattern_packets($1, sample_id, $2)) AS pkts
     FROM flood.samples
     JOIN fast.entity_patterns ep ON(ep.entity_id = report_id)
     JOIN (SELECT flood_id,
		  top_hosts_id,
		  pattern_id,
		  side,
		  sum(matches) AS match,
		  min(matches) AS minmatch,
		  COUNT(*) AS ip_cnt
	     FROM flood.samples
	     JOIN fast.top_host_sets ths ON(ths.entity_id = top_hosts_id)
	     JOIN fast.top_hosts USING(ths_id)
	    GROUP BY 1, 2, 3, 4
	  ) AS th USING(flood_id, top_hosts_id, pattern_id)
    WHERE flood_id = $1
      AND pattern_id = $2
  ORDER BY sample_id;
  
  UPDATE temp_flood_attack_type_1 SET pkt_cnt2=pkt_cnt1;
  
  INSERT INTO temp_flood_attack_type_2(sample_id,side,ip_cnt,pkt_cnt1)
   SELECT sample_id,
   side ,
  row[1] AS ip_cnt,
  row[2] AS pkts
     FROM (SELECT sample_id,
   's'::"char" as side,
  (SELECT ARRAY[COUNT(*), SUM(pkts)]::INTEGER[]
     FROM flood.pattern_prevalent_hosts(flood_id,
    sample_id, $2, 's'::"char", true)) AS row
     FROM flood.samples
    WHERE flood_id = $1) AS foo
   WHERE row[1] > 0
   UNION
   SELECT sample_id,
   side ,
  row[1] AS ip_cnt,
  row[2] AS pkts
     FROM (SELECT sample_id,
   'd'::"char" as side,
  (SELECT ARRAY[COUNT(*), SUM(pkts)]::INTEGER[]
     FROM flood.pattern_prevalent_hosts(flood_id,
    sample_id, $2, 'd'::"char", true)) AS row
     FROM flood.samples
    WHERE flood_id = $1) AS foo
   WHERE row[1] > 0
   ORDER BY sample_id ;  
   
   
  UPDATE temp_flood_attack_type_1 type_1 SET ip_cnt=type_2.ip_cnt, pkt_cnt1=type_2.pkt_cnt1
   FROM temp_flood_attack_type_2 type_2 WHERE type_1.sample_id=type_2.sample_id AND type_1.side=type_2.side;
  
  -- calculations on records from
  FOR result_cur IN
   SELECT s1.ip_cnt srcip, s1.pkt_cnt1 srcep, s1.pkt_cnt2 srctp,
         d1.ip_cnt dstip, d1.pkt_cnt1 dstep, d1.pkt_cnt2 dsttp
   FROM temp_flood_attack_type_1 s1, temp_flood_attack_type_1 d1
    WHERE s1.sample_id=d1.sample_id and s1.side='s' and d1.side='d'
  LOOP
     srcip_val := result_cur.srcip;
     srcep_val := result_cur.srcep;
     srctp_val := result_cur.srctp;
     dstip_val := result_cur.dstip;
     dstep_val := result_cur.dstep;
     dsttp_val := result_cur.dsttp;
    
    IF srcip_val = 0 OR dstip_val = 0 THEN
       attack_type_val := NULL;
       ep_val := 0;
       tp_val := 0;
       RAISE EXCEPTION 'source/destination top hosts not found for flood %; pattern %', $1,$2; 
       EXIT;
    END IF; 
     
    IF srcip_val/dstip_val >=20 THEN
       ep_val := ep_val + dstep_val;
       tp_val := tp_val + dsttp_val;
       tmp_attack_type_val := 'DDos';
    ELSIF srcip_val/dstip_val >=10  THEN
       ep_val := ep_val + dstep_val;
       tp_val := tp_val + dsttp_val;
       tmp_attack_type_val := 'Dos';
    ELSIF dstip_val/srcip_val >=10  THEN
       ep_val := ep_val + srcep_val;
       tp_val := tp_val + srctp_val;
       tmp_attack_type_val := 'Scan';    
    END IF;
    
    IF attack_type_val is NULL THEN
       attack_type_val := tmp_attack_type_val;
    ELSIF  tmp_attack_type_val is NOT NULL AND attack_type_val <> tmp_attack_type_val THEN
       attack_type_val := NULL;
       ep_val := 0;
       tp_val := 0;
       EXIT;
    END IF;   
     
  END LOOP;
  
  DROP TABLE temp_flood_attack_type_1;
  DROP TABLE temp_flood_attack_type_2;
      
  RETURN QUERY select  attack_type_val,ep_val,tp_val;
   
   END
$_$;

ALTER FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) OWNER TO ndbadm;

COMMENT ON FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) IS 'Returns attack type for the flood and the pattern (one of `DoS'', `DDoS'', `Scan'')';

REVOKE ALL ON FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) FROM PUBLIC;
REVOKE ALL ON FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) FROM ndbadm;
GRANT ALL ON FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) TO ndbadm;
GRANT ALL ON FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) TO ndb_readers;
GRANT ALL ON FUNCTION flood.pattern_attack_type(flood integer, pattern integer, OUT attack_type text, OUT matches_val integer, OUT total_val integer) TO ndb_writers;

-- Create supporting sequence
DROP SEQUENCE if EXISTS flood.test_fp_seq;
CREATE SEQUENCE flood.test_fp_seq
	 START WITH 1
     INCREMENT BY 1
     NO MINVALUE
     NO MAXVALUE
     CACHE 1;
      
ALTER TABLE flood.test_fp_seq OWNER TO postgres;
GRANT ALL ON SEQUENCE flood.test_fp_seq TO postgres;
GRANT ALL ON SEQUENCE flood.test_fp_seq TO nms;

CREATE OR REPLACE FUNCTION flood.patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) RETURNS SETOF record
    LANGUAGE plpgsql 
    AS $_$
   DECLARE
    result  record; 
    stam  integer; 
   BEGIN 
    
    CREATE TEMPORARY TABLE temp_flood_patterns (
	 pattern_id integer,
	 sample_count integer,
	 mtg_count integer,
	 last_at timestamp with time zone,
	 quality integer,
	 header_octets integer, 
	 payload_octets integer
	) ON COMMIT DROP; 
    
    stam := pg_catalog.setval('flood.test_fp_seq', 1, false);
    
    INSERT INTO temp_flood_patterns (pattern_id,sample_count, mtg_count, last_at, quality )
     SELECT ep.pattern_id,
        COUNT(ep.entity_id) AS sample_count,
        COUNT(mrl.flood_id) AS mtg_count,
        MAX(s.at) AS last_at,
        flood.pattern_quality(ep.matches,
                substring(s.request FROM 'modelMismatch=([^[:space:]]+)')::REAL)
                AS quality
	  FROM flood.samples s
	  JOIN fast.entity_patterns ep ON (ep.entity_id = s.report_id)
	  LEFT JOIN flood.mtg_reqs_log mrl ON ((mrl.flood_id, mrl.orig_pattern_id) = (s.flood_id, ep.pattern_id))
	  WHERE s.flood_id = $1
	  GROUP BY ep.pattern_id ;
	
	IF NOT FOUND THEN
	 return;
	END IF;      
     
    UPDATE  temp_flood_patterns tfp SET header_octets= (SELECT SUM(CASE WHEN ps.layer > 3 THEN 0 ELSE octet_length(ps.values) END)
								      FROM fast.pat_contents pc
								      JOIN fast.pat_strips ps USING (pat_strip_id)
								     WHERE pc.pattern_id = tfp.pattern_id), 
                                   payload_octets= (SELECT SUM(CASE WHEN ps.layer = 4 THEN octet_length(ps.values) ELSE 0 END)
								      FROM fast.pat_contents pc
								      JOIN fast.pat_strips ps USING (pat_strip_id)
								     WHERE pc.pattern_id = tfp.pattern_id);
    
     RETURN QUERY SELECT nextval('flood.test_fp_seq')::INTEGER ,ft.pattern_id,  ft.sample_count, ft.quality,ft.header_octets, ft.payload_octets 
       FROM (select * from temp_flood_patterns tt
       order by (tt.header_octets*tt.quality) desc, 
           tt.last_at desc, tt.mtg_count desc, tt.payload_octets desc, tt.sample_count desc, tt.pattern_id desc ) ft;
    
    END$_$;      
    
GRANT ALL ON FUNCTION flood.patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO ndbadm;
GRANT ALL ON FUNCTION flood.patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO ndb_readers;
GRANT ALL ON FUNCTION flood.patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO ndb_writers;
GRANT ALL ON FUNCTION flood.patterns(flood_id integer, OUT rank integer, OUT pattern_id integer, OUT sample_count integer, OUT quality integer, OUT header_octets integer, OUT payload_octets integer) TO nms;  
  		  