-- DB upgrade for 15.2.10b01 (DB refactoring phase 3)

-- Prepare to remove(drop) CONFIG schema

DO LANGUAGE plpgsql $$
    DECLARE
		db_ref_val     INTEGER;
	
		BEGIN
		  db_ref_val := public.get_int_param('DB_Refact','phase_3');
		  
		  IF db_ref_val is NULL  OR db_ref_val <> 1 THEN
		   -- Add new defaults to public.params table:
           INSERT INTO public.param (name, subname, int_val, description) 
            VALUES ('Mitigation', 'ignore-encap', 0, '0 - not set,1 - set; If set then all L2 and tunnel LOVs extract from mitigation plan');
           INSERT INTO public.param (name, subname, int_val, description) 
            VALUES ('Mitigation', 'ignore-routing', 0, '0 - not set,1 - set; If set then standard routing LOVs extract from mitigation plan');
           INSERT INTO public.param (name, subname, int_val, description) 
            VALUES ('Group', 'max_per_cluster', 0, 'Max number of allocated groups to cluster');
           INSERT INTO public.param (name, subname, int_val, description) 
            VALUES ('Group', 'max_per_sensor', 30, 'Max number of allocated groups to sensor');
  
          -- Add column to public.hosts table
          ALTER TABLE public.hosts ADD max_groups integer;

          IF db_ref_val is NULL THEN
            INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('DB_Refact','phase_3', 1,'Database refactoring phase 3(remove CONFIG schema) status(1-done;0-not)');
          ELSE
            UPDATE public.PARAM SET INT_VAL=1 WHERE NAME='DB_Refact' and SUBNAME='phase_3' ;
          END IF;  
          
         END IF;
		END;
	$$; 		
	
CREATE OR REPLACE FUNCTION public.enforce_sensor_grpmax() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		DECLARE
			lim INTEGER;
			cur INTEGER;
			hnm TEXT;
		BEGIN
			SELECT INTO hnm name FROM public.hosts WHERE host_id = NEW.host_id;
			SELECT INTO lim max_groups FROM public.hosts WHERE host_id = NEW.host_id;
			IF lim IS NULL THEN
				-- Get data from PARAM table
                lim := public.get_int_param('Group','max_per_sensor');
                IF lim IS NULL THEN
                       RAISE EXCEPTION '%: Group capacity not available', hnm;
                END IF;        
			END IF;

			SELECT INTO cur count(group_id) FROM public.group_mapping WHERE host_id = NEW.host_id;
			IF lim != 0 AND cur >= lim THEN
				RAISE EXCEPTION '%: Group capacity exceeded', hnm;
			END IF;

			RETURN NEW;
		END;
	$$;
	
--DROP CONFIG	
DROP SCHEMA  IF EXISTS CONFIG CASCADE; 	
	
			  