-- DB upgrade for 15.2.10b01 (DB refactoring phase 4,5)

-- remove unused ROLE(USER)'s

DO LANGUAGE plpgsql $$
    DECLARE
		db_ref_val     INTEGER;
	
		BEGIN
		  db_ref_val := public.get_int_param('DB_Refact','phase_4');
		  
		  IF db_ref_val is NULL  OR db_ref_val <> 1 THEN
		  -- DROP ROLE if EXISTS cluster;
          DROP ROLE if EXISTS dba;
          DROP ROLE if EXISTS detect;
          DROP ROLE if EXISTS "fast-ctr";
          DROP ROLE if EXISTS "hydra-shadow";
 
          REVOKE ALL ON FUNCTION quarantine.automatic_importance(flood_id integer, importance integer, filter_id integer) FROM informer;
          REVOKE ALL ON FUNCTION notify.set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) FROM informer;
          REVOKE ALL ON FUNCTION flood.automatic_importance(capture_id integer, importance integer, filter_id integer) FROM informer;
          DROP ROLE if EXISTS informer;
 
          REVOKE ALL ON DATABASE netx FROM ndb_shadow;
          DROP ROLE if EXISTS ndb_shadow;
 
          DROP ROLE if EXISTS ndbread;
          DROP ROLE if EXISTS "nx-hostlistd";
          DROP ROLE if EXISTS sgspmd;
          DROP ROLE if EXISTS smpd;
 
          REVOKE ALL ON FUNCTION flood.manual_importance(flood_id integer, importance integer, uid integer) FROM tomcat55;
          REVOKE ALL ON FUNCTION flood.mtg_req_manual_block(_flood_id integer, _orig_pattern_id integer, _uid integer, _action flood.mtg_req_action, _action_expire timestamp with time zone, _action_flood_only boolean) FROM tomcat55;
          REVOKE ALL ON FUNCTION flood.mtg_req_manual_unblock(_flood_id integer, _uid integer) FROM tomcat55;
          REVOKE ALL ON FUNCTION notify.set_event_importance(eventtype text, eventid integer, eventimp integer, automatic boolean, setbyid integer) FROM tomcat55;
          REVOKE ALL ON FUNCTION quarantine.manual_importance(capture_id integer, importance integer, uid integer) FROM tomcat55;
          REVOKE ALL ON FUNCTION smp.manual_action(_user_id integer, _action integer, _action_param text, _uid integer) FROM tomcat55;
          REVOKE ALL ON SEQUENCE auth.passwd_uid_seq FROM tomcat55;
          REVOKE ALL ON SEQUENCE report.list_report_id_seq FROM tomcat55;
          REVOKE ALL ON SEQUENCE report.views_view_id_seq FROM tomcat55;
          REVOKE SELECT,INSERT,DELETE,UPDATE ON TABLE report.list FROM tomcat55;
          REVOKE SELECT,INSERT,DELETE,UPDATE ON TABLE report.mail FROM tomcat55;
          REVOKE SELECT,INSERT,DELETE,UPDATE ON TABLE report.views FROM tomcat55;
          DROP ROLE if EXISTS tomcat55;
          
          IF db_ref_val is NULL THEN
            INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('DB_Refact','phase_4', 1,'Database refactoring phase 4(remove unused ROLE(USER)''s) status(1-done;0-not)');
          ELSE
            UPDATE public.PARAM SET INT_VAL=1 WHERE NAME='DB_Refact' and SUBNAME='phase_4' ;
          END IF;  
          
         END IF;
		END;
	$$; 
	
	

--remove RULE's with NOTIFY statements	
DO LANGUAGE plpgsql $$
    DECLARE
		db_ref_val     INTEGER;
	
		BEGIN
		  db_ref_val := public.get_int_param('DB_Refact','phase_5');
		  
		  IF db_ref_val is NULL  OR db_ref_val <> 1 THEN
		  
		  DROP RULE if EXISTS delete ON auth.passwd; 
          DROP RULE if EXISTS delete ON auth.authorized_keys;
          DROP RULE if EXISTS delete ON auth.ipsec;
          DROP RULE if EXISTS insert ON auth.passwd ;
          DROP RULE if EXISTS insert ON auth.authorized_keys;
          DROP RULE if EXISTS insert ON auth.ipsec;
          DROP RULE if EXISTS update ON auth.passwd ;
          DROP RULE if EXISTS update ON auth.authorized_keys;
          DROP RULE if EXISTS update ON auth.ipsec;
 
          DROP RULE if EXISTS delete ON flood.config;
          DROP RULE if EXISTS delete ON flood.thresholds;
          DROP RULE if EXISTS insert ON flood.config;
          DROP RULE if EXISTS insert ON flood.thresholds;
          DROP RULE if EXISTS update ON flood.config;
          DROP RULE if EXISTS update ON flood.thresholds;
 
          DROP RULE if EXISTS delete ON notify.data_type_operators;
          DROP RULE if EXISTS delete ON notify.data_types;
          DROP RULE if EXISTS delete ON notify.fields;
          DROP RULE if EXISTS delete ON notify.filter_parts;
          DROP RULE if EXISTS delete ON notify.filters;
          DROP RULE if EXISTS delete ON notify.filter_targets;
          DROP RULE if EXISTS delete ON notify.filter_templates;
          DROP RULE if EXISTS delete ON notify.operators;
          DROP RULE if EXISTS delete ON notify.targets;
          DROP RULE if EXISTS delete ON notify.templates;
          DROP RULE if EXISTS delete ON notify.type_links;
          DROP RULE if EXISTS delete ON notify.types;
          DROP RULE if EXISTS insert ON notify.data_type_operators;
          DROP RULE if EXISTS insert ON notify.data_types;
          DROP RULE if EXISTS insert ON notify.fields;
          DROP RULE if EXISTS insert ON notify.filter_parts;
          DROP RULE if EXISTS insert ON notify.filters;
          DROP RULE if EXISTS insert ON notify.filter_targets;
          DROP RULE if EXISTS insert ON notify.filter_templates;
          DROP RULE if EXISTS insert ON notify.operators;
          DROP RULE if EXISTS insert ON notify.targets;
          DROP RULE if EXISTS insert ON notify.templates;
          DROP RULE if EXISTS insert ON notify.type_links;
          DROP RULE if EXISTS insert ON notify.types;
          DROP RULE if EXISTS update ON notify.data_type_operators;
          DROP RULE if EXISTS update ON notify.data_types;
          DROP RULE if EXISTS update ON notify.fields;
          DROP RULE if EXISTS update ON notify.filter_parts;
          DROP RULE if EXISTS update ON notify.filters;
          DROP RULE if EXISTS update ON notify.filter_targets;
          DROP RULE if EXISTS update ON notify.filter_templates;
          DROP RULE if EXISTS update ON notify.operators;
          DROP RULE if EXISTS update ON notify.targets;
          DROP RULE if EXISTS update ON notify.templates;
          DROP RULE if EXISTS update ON notify.type_links;
          DROP RULE if EXISTS update ON notify.types;
 
          DROP RULE if EXISTS delete ON public.hosts;
          DROP RULE if EXISTS delete ON public.groups;
          DROP RULE if EXISTS delete ON public.group_mapping;
          DROP RULE if EXISTS delete ON public.group_config;
          DROP RULE if EXISTS delete ON public.post_target_types;
          DROP RULE if EXISTS delete ON public.sensor_clusters;
          DROP RULE if EXISTS delete ON public.cluster_config;
          DROP RULE if EXISTS insert ON public.hosts;
          DROP RULE if EXISTS insert ON public.groups;
          DROP RULE if EXISTS insert ON public.group_mapping;
          DROP RULE if EXISTS insert ON public.group_config;
          DROP RULE if EXISTS insert ON public.post_target_types;
          DROP RULE if EXISTS insert ON public.sensor_clusters;
          DROP RULE if EXISTS insert ON public.cluster_config;
          DROP RULE if EXISTS update ON public.hosts;
          DROP RULE if EXISTS update ON public.groups;
          DROP RULE if EXISTS update ON public.group_mapping;
          DROP RULE if EXISTS update ON public.group_config;
          DROP RULE if EXISTS update ON public.post_target_types;
          DROP RULE if EXISTS update ON public.sensor_clusters;
          DROP RULE if EXISTS update ON public.cluster_config;
 
          DROP RULE if EXISTS delete ON smp.map;
          DROP RULE if EXISTS insert ON smp.map;
          DROP RULE if EXISTS update ON smp.map;
		  
          IF db_ref_val is NULL THEN
            INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('DB_Refact','phase_5', 1,'Database refactoring phase 5(remove RULE''s with NOTIFY statements) status(1-done;0-not)');
          ELSE
            UPDATE public.PARAM SET INT_VAL=1 WHERE NAME='DB_Refact' and SUBNAME='phase_5' ;
          END IF;  
          
         END IF;
		END;
	$$; 			  
	
CREATE OR REPLACE FUNCTION public.subsystem_stop(integer) RETURNS void
    LANGUAGE sql
    AS $_$
  UPDATE public.subsystems
    SET alive = CURRENT_TIMESTAMP
    WHERE subsystem_id = $1;
 $_$;
 
 CREATE OR REPLACE FUNCTION public.subsystem_register(text, integer, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
  sName		ALIAS FOR $1;
  sHostID	public.hosts.host_id%TYPE := $2;
  sCookie	ALIAS FOR $3;

  id		public.subsystems.subsystem_id%TYPE;
  newAlive	public.subsystems.alive%TYPE := 
		CURRENT_TIMESTAMP + '600'::INTERVAL;
  newCookie	public.subsystems.cookie%TYPE :=
		pg_catalog.pg_backend_pid() || '~' ||
		sName || '~' ||
		sHostID || '~' ||
		CURRENT_TIMESTAMP;

BEGIN
  IF sHostID IS NULL THEN
    SELECT INTO sHostID host_id FROM public.hosts WHERE is_hydra;
  END IF;

     UPDATE public.subsystems
	SET alive = newAlive,
	    cookie = newCookie
      WHERE name = sName
	AND host_id = sHostID
	AND (alive < CURRENT_TIMESTAMP OR cookie = sCookie)
  RETURNING subsystem_id INTO id;

  IF FOUND THEN RETURN id; END IF;

  SELECT INTO id subsystem_id
    FROM public.subsystems
   WHERE name = sName AND host_id = sHostID;

  IF FOUND THEN
    RAISE EXCEPTION
      'subsystem `%'' is `alive'', another instance running?', sName;
  END IF;

  INSERT INTO public.subsystems(name, host_id, alive, cookie)
       VALUES (sName, sHostID, newAlive, newCookie)
    RETURNING subsystem_id INTO id;

  RETURN id;
END$_$;	