-- DB upgrade for 15.2.10b01 (DB refactoring phase 6)

-- Add IPV6 functionality

DO LANGUAGE plpgsql $$
    DECLARE
		db_ref_val     INTEGER;
		host_to_handle public.hosts%rowtype;
	
		BEGIN
		  db_ref_val := public.get_int_param('DB_Refact','phase_6');
		  
		  IF db_ref_val is NULL  OR db_ref_val <> 1 THEN
		   -- Add column to public.groups table
           ALTER TABLE public.groups ADD group_type varchar(10) DEFAULT 'IPV4' NOT NULL;
           COMMENT ON COLUMN public.groups.group_type IS 'group type - IPV4 or IPV6';
           
           -- Change default value
           ALTER TABLE flood.stats ALTER duration SET DEFAULT (1.0)::real;
           
           DROP INDEX if EXISTS public.group_config__rtree;
           
           INSERT INTO public.groups(group_id, name, descr, f_inside, f_dos, f_rawcap, f_decodetun, f_quarantine,group_type)
             VALUES(902,'Inside-ipv6','Inside-ipv6','t','t','f','t','f','IPV6');
           INSERT INTO public.groups(group_id, name, descr, f_inside, f_dos, f_rawcap, f_decodetun, f_quarantine,group_type)
             VALUES(903,'World-ipv6','World-ipv6','f','f','f','t','f','IPV6');
               
             -- (David) : Add function to dynamically add sensor / cluster tables
             CREATE OR REPLACE FUNCTION "public"."add_stats_table" (hostid integer, groupid integer)  RETURNS void
LANGUAGE plpgsql
AS $_$
DECLARE
    table_name TEXT;
	view_name TEXT;
BEGIN    
   table_name := 'h' || hostid || '.' || '_stats' || groupid ;
   view_name := 'h' || hostid || '.' || 'stats' || groupid ;
   
   EXECUTE 'CREATE TABLE ' || table_name  || ' (timestamp INTEGER NOT NULL, 
	byt_incom_frag BIGINT, pkt_incom_frag BIGINT, 
	byt_outgo_frag BIGINT, pkt_outgo_frag BIGINT, 
	byt_incom_trunc BIGINT, pkt_incom_trunc BIGINT, 
	byt_outgo_trunc BIGINT, pkt_outgo_trunc BIGINT, 
	byt_incom_esp BIGINT, pkt_incom_esp BIGINT, 
	byt_outgo_esp BIGINT, pkt_outgo_esp BIGINT, 
	byt_incom_other BIGINT, pkt_incom_other BIGINT, 
	byt_outgo_other BIGINT, pkt_outgo_other BIGINT, 
	byt_incom_tcp_fin BIGINT, pkt_incom_tcp_fin BIGINT, 
	byt_outgo_tcp_fin BIGINT, pkt_outgo_tcp_fin BIGINT, 
	byt_incom_tcp_syn BIGINT, pkt_incom_tcp_syn BIGINT, 
	byt_outgo_tcp_syn BIGINT, pkt_outgo_tcp_syn BIGINT, 
	byt_incom_tcp_rst BIGINT, pkt_incom_tcp_rst BIGINT,
	byt_outgo_tcp_rst BIGINT, pkt_outgo_tcp_rst BIGINT, 
	byt_incom_tcp_ack BIGINT, pkt_incom_tcp_ack BIGINT, 
	byt_outgo_tcp_ack BIGINT, pkt_outgo_tcp_ack BIGINT, 
	byt_incom_tcp_ackdata BIGINT, pkt_incom_tcp_ackdata BIGINT, 
	byt_outgo_tcp_ackdata BIGINT, pkt_outgo_tcp_ackdata BIGINT, 
	byt_incom_tcp_inval BIGINT, pkt_incom_tcp_inval BIGINT, 
	byt_outgo_tcp_inval BIGINT, pkt_outgo_tcp_inval BIGINT, 
	byt_incom_udp_dns BIGINT, pkt_incom_udp_dns BIGINT, 
	byt_outgo_udp_dns BIGINT, pkt_outgo_udp_dns BIGINT, 
	byt_incom_udp_other BIGINT, pkt_incom_udp_other BIGINT, 
	byt_outgo_udp_other BIGINT, pkt_outgo_udp_other BIGINT, 
	byt_incom_icmp_echoreq BIGINT, pkt_incom_icmp_echoreq BIGINT, 
	byt_outgo_icmp_echoreq BIGINT, pkt_outgo_icmp_echoreq BIGINT, 
	byt_incom_icmp_echorep BIGINT, pkt_incom_icmp_echorep BIGINT, 
	byt_outgo_icmp_echorep BIGINT, pkt_outgo_icmp_echorep BIGINT, 
	byt_incom_icmp_unreach BIGINT, pkt_incom_icmp_unreach BIGINT, 
	byt_outgo_icmp_unreach BIGINT, pkt_outgo_icmp_unreach BIGINT, 
	byt_incom_icmp_other BIGINT, pkt_incom_icmp_other BIGINT, 
	byt_outgo_icmp_other BIGINT, pkt_outgo_icmp_other BIGINT, PRIMARY KEY (timestamp))';
	
	EXECUTE 'ALTER TABLE ' || table_name  || ' OWNER TO nms';
	EXECUTE 'GRANT ALL ON TABLE ' || table_name  || ' TO nms';
	
	EXECUTE 'CREATE VIEW ' || view_name  || ' AS SELECT timestamp, 
byt_incom_frag, pkt_incom_frag, 
byt_outgo_frag, pkt_outgo_frag, 
byt_incom_trunc, pkt_incom_trunc, 
byt_outgo_trunc, pkt_outgo_trunc, 
byt_incom_esp, pkt_incom_esp, 
byt_outgo_esp, pkt_outgo_esp, 
byt_incom_other, pkt_incom_other, 
byt_outgo_other, pkt_outgo_other, 
byt_incom_tcp_fin, pkt_incom_tcp_fin, 
byt_outgo_tcp_fin, pkt_outgo_tcp_fin, 
byt_incom_tcp_syn, pkt_incom_tcp_syn, 
byt_outgo_tcp_syn, pkt_outgo_tcp_syn, 
byt_incom_tcp_rst, pkt_incom_tcp_rst,
byt_outgo_tcp_rst, pkt_outgo_tcp_rst, 
byt_incom_tcp_ack, pkt_incom_tcp_ack, 
byt_outgo_tcp_ack, pkt_outgo_tcp_ack, 
byt_incom_tcp_ackdata, pkt_incom_tcp_ackdata, 
byt_outgo_tcp_ackdata, pkt_outgo_tcp_ackdata, 
byt_incom_tcp_inval, pkt_incom_tcp_inval, 
byt_outgo_tcp_inval, pkt_outgo_tcp_inval, 
byt_incom_udp_dns, pkt_incom_udp_dns, 
byt_outgo_udp_dns, pkt_outgo_udp_dns, 
byt_incom_udp_other, pkt_incom_udp_other, 
byt_outgo_udp_other, pkt_outgo_udp_other, 
byt_incom_icmp_echoreq, pkt_incom_icmp_echoreq, 
byt_outgo_icmp_echoreq, pkt_outgo_icmp_echoreq, 
byt_incom_icmp_echorep, pkt_incom_icmp_echorep, 
byt_outgo_icmp_echorep, pkt_outgo_icmp_echorep, 
byt_incom_icmp_unreach, pkt_incom_icmp_unreach, 
byt_outgo_icmp_unreach, pkt_outgo_icmp_unreach, 
byt_incom_icmp_other, pkt_incom_icmp_other, 
byt_outgo_icmp_other, pkt_outgo_icmp_other,
byt_incom_tcp_fin + byt_incom_tcp_syn + byt_incom_tcp_rst AS byt_incom_tcp_endp, 
byt_incom_tcp_fin + byt_incom_tcp_syn + byt_incom_tcp_rst + byt_incom_tcp_ack + byt_incom_tcp_ackdata + byt_incom_tcp_inval AS byt_incom_tcp_total,
byt_incom_udp_dns + byt_incom_udp_other AS byt_incom_udp_total, 
byt_incom_icmp_echoreq + byt_incom_icmp_echorep + byt_incom_icmp_unreach + byt_incom_icmp_other AS byt_incom_icmp_total,
byt_incom_frag + byt_incom_trunc + byt_incom_esp + byt_incom_other + byt_incom_tcp_fin + byt_incom_tcp_syn + byt_incom_tcp_rst + byt_incom_tcp_ack + byt_incom_tcp_ackdata + byt_incom_tcp_inval + byt_incom_udp_dns + byt_incom_udp_other + byt_incom_icmp_echoreq + byt_incom_icmp_echorep + byt_incom_icmp_unreach + byt_incom_icmp_other AS byt_incom_ipv4,
pkt_incom_tcp_fin + pkt_incom_tcp_syn + pkt_incom_tcp_rst AS pkt_incom_tcp_endp, 
pkt_incom_tcp_fin + pkt_incom_tcp_syn + pkt_incom_tcp_rst + pkt_incom_tcp_ack + pkt_incom_tcp_ackdata + pkt_incom_tcp_inval AS pkt_incom_tcp_total,
pkt_incom_udp_dns + pkt_incom_udp_other AS pkt_incom_udp_total, 
pkt_incom_icmp_echoreq + pkt_incom_icmp_echorep + pkt_incom_icmp_unreach + pkt_incom_icmp_other AS pkt_incom_icmp_total,
pkt_incom_frag + pkt_incom_trunc + pkt_incom_esp + pkt_incom_other + pkt_incom_tcp_fin + pkt_incom_tcp_syn + pkt_incom_tcp_rst + pkt_incom_tcp_ack + pkt_incom_tcp_ackdata + pkt_incom_tcp_inval + pkt_incom_udp_dns + pkt_incom_udp_other + pkt_incom_icmp_echoreq + pkt_incom_icmp_echorep + pkt_incom_icmp_unreach + pkt_incom_icmp_other AS pkt_incom_ipv4,
byt_outgo_tcp_fin + byt_outgo_tcp_syn + byt_outgo_tcp_rst AS byt_outgo_tcp_endp, 
byt_outgo_tcp_fin + byt_outgo_tcp_syn + byt_outgo_tcp_rst + byt_outgo_tcp_ack + byt_outgo_tcp_ackdata + byt_outgo_tcp_inval AS byt_outgo_tcp_total,
byt_outgo_udp_dns + byt_outgo_udp_other AS byt_outgo_udp_total, 
byt_outgo_icmp_echoreq + byt_outgo_icmp_echorep + byt_outgo_icmp_unreach + byt_outgo_icmp_other AS byt_outgo_icmp_total,
byt_outgo_frag + byt_outgo_trunc + byt_outgo_esp + byt_outgo_other + byt_outgo_tcp_fin + byt_outgo_tcp_syn + byt_outgo_tcp_rst + byt_outgo_tcp_ack + byt_outgo_tcp_ackdata + byt_outgo_tcp_inval + byt_outgo_udp_dns + byt_outgo_udp_other + byt_outgo_icmp_echoreq + byt_outgo_icmp_echorep + byt_outgo_icmp_unreach + byt_outgo_icmp_other AS byt_outgo_ipv4,
pkt_outgo_tcp_fin + pkt_outgo_tcp_syn + pkt_outgo_tcp_rst AS pkt_outgo_tcp_endp, 
pkt_outgo_tcp_fin + pkt_outgo_tcp_syn + pkt_outgo_tcp_rst + pkt_outgo_tcp_ack + pkt_outgo_tcp_ackdata + pkt_outgo_tcp_inval AS pkt_outgo_tcp_total,
pkt_outgo_udp_dns + pkt_outgo_udp_other AS pkt_outgo_udp_total, 
pkt_outgo_icmp_echoreq + pkt_outgo_icmp_echorep + pkt_outgo_icmp_unreach + pkt_outgo_icmp_other AS pkt_outgo_icmp_total,
pkt_outgo_frag + pkt_outgo_trunc + pkt_outgo_esp + pkt_outgo_other + pkt_outgo_tcp_fin + pkt_outgo_tcp_syn + pkt_outgo_tcp_rst + pkt_outgo_tcp_ack + pkt_outgo_tcp_ackdata + pkt_outgo_tcp_inval + pkt_outgo_udp_dns + pkt_outgo_udp_other + pkt_outgo_icmp_echoreq + pkt_outgo_icmp_echorep + pkt_outgo_icmp_unreach + pkt_outgo_icmp_other AS pkt_outgo_ipv4
FROM ' || table_name;

EXECUTE 'ALTER VIEW ' || view_name || ' OWNER TO nms';
EXECUTE 'GRANT ALL ON TABLE ' || view_name || ' TO nms';
  
END
$_$;
             -- (David) : Add the 2 new default groups to all exist clusters / sensors 
FOR host_to_handle IN SELECT * FROM public.hosts WHERE host_id > 1
LOOP
	INSERT INTO public.group_mapping(host_id, group_id) VALUES (host_to_handle.host_id, 902);
	PERFORM public.add_stats_table(host_to_handle.host_id, 902);
	INSERT INTO public.group_mapping(host_id, group_id) VALUES (host_to_handle.host_id, 903);
	PERFORM public.add_stats_table(host_to_handle.host_id, 903);
END LOOP;

ALTER FUNCTION public.add_stats_table(hostid integer, groupid integer) OWNER TO nms;
				
           -- Add new data to notify.fields
           PERFORM 1
		    FROM
		        notify.fields 
		    WHERE
		        field_id >=98;
		        
		    IF NOT FOUND THEN
			  INSERT INTO notify.fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs) 
			    VALUES(98,2,3,'icmpv6_code', 'ICMPV6 code', '{"0-255"}', '{"invalid ICMPV6 code, must be from 0 to 255"}');
			  INSERT INTO notify.fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs) 
			    VALUES(99,2,3,'icmpv6_id', 'ICMPV6 identification', '{"0-65535"}', '{"invalid ICMPV6 identification, must be from 0 to 65535"}');
			  INSERT INTO notify.fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs) 
			    VALUES(100,2,3,'icmpv6_type', 'ICMPV6 type', '{"0-255"}', '{"invalid ICMPV6 type, must be from 0 to 255"}');
			  INSERT INTO notify.fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs) 
			    VALUES(101,2,3,'ipv6_flag_res', 'IPV6 res', '{"0-3"}', '{"invalid IPV6 res, must be from 0 to 3"}');
			  INSERT INTO notify.fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs) 
			    VALUES(102,2,3,'ipv6_id', 'IPV6 identification', '{"0-65535"}', '{"invalid IPV6 identification, must be from 0 to 65535"}');
			  INSERT INTO notify.fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs) 
			    VALUES(103,2,3,'ip_version', 'IPversion', '{"4,6"}', '{"invalid IP version, must be 4 | 6"}');
			  INSERT INTO notify.fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs) 
			    VALUES(104,2,3,'ipv6_flowlabel', 'IPV6 Flowlabel', '{"0-65355"}', '{"invalid IPV6 Flowlabel, must be from 0 to 65535"}');            
		    END IF;
		  
          IF db_ref_val is NULL THEN
            INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('DB_Refact','phase_6', 1,'Database refactoring phase 6(Add IPV6) status(1-done;0-not)');
          ELSE
            UPDATE public.PARAM SET INT_VAL=1 WHERE NAME='DB_Refact' and SUBNAME='phase_6' ;
          END IF;  
          
         END IF;
		END;
	$$; 		  