-- DB upgrade for 15.2.10b01

DO LANGUAGE plpgsql $$
		BEGIN
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'public'
		        AND c.relname = 'mitigation'
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
		      CREATE TABLE public.mitigation (
               option           varchar(32)     NOT NULL,
               is_enabled       boolean default false NOT NULL,
               constraint pk_mitigation primary key (option)
              );

              ALTER TABLE public.mitigation OWNER TO ndbadm;
              
              insert into public.mitigation (option,is_enabled) values('ignore-encap',false);
              insert into public.mitigation (option,is_enabled) values('ignore-routing',false);
              
              REVOKE ALL ON TABLE mitigation FROM PUBLIC;
              REVOKE ALL ON TABLE mitigation FROM ndbadm;
              GRANT ALL ON TABLE mitigation TO ndbadm;
              GRANT SELECT ON TABLE mitigation TO ndb_readers;
              GRANT ALL ON TABLE mitigation TO ndb_writers;
              GRANT ALL ON TABLE mitigation TO nms;
              
              delete from public.param where name='Mitigation';
              
		    END if;
		    
		END;
$$;  