
-- DB upgrade for 15.1.710b09 or next 

update notify.fields set constraints='{Range(0,16)}', constr_msgs='{"invalid size, must be from 0 to 16"}' where name in ('src_ip_size', 'dst_ip_size');

DO LANGUAGE plpgsql $$
    DECLARE
		seq_value      INTEGER; 
	
	BEGIN
	  select max(alert_type_id) into seq_value from flood.alert_types;

	  PERFORM pg_catalog.setval('flood.alert_types_alert_type_id_seq', seq_value, true);
	END;	
$$;  	

\i /opt/allot/DB/sql/add_stats_table_proc.sql
\i /opt/allot/DB/sql/all_purge_proc.sql

