-- DB upgrade for 15.1.710b10 or next (DB fix PK on _stats tables for 15.1.60b03(04,05))

DO LANGUAGE plpgsql $$
 DECLARE
    curr_time   TIMESTAMP;
    host_var  INTEGER; 
    name_var      TEXT;
    group_var INTEGER;
	table_name_var TEXT;
    table_schema_var TEXT;
	test_error INTEGER; 
 BEGIN    

  FOR host_var,name_var,group_var IN
    SELECT host_id, structs.name, group_id
    FROM public.data_tables
    JOIN public.structs USING (struct_id)
    WHERE structs.name IN ('_stats')
    ORDER BY 1,2,3
  LOOP
   
   table_name_var := name_var || group_var;
   table_schema_var := 'h' || host_var ;
   
   if NOT exists (select constraint_name from information_schema.table_constraints where table_name = table_name_var 
      and table_schema = table_schema_var and constraint_type = 'PRIMARY KEY') then
      test_error :=0;
	  --RAISE NOTICE 'Try add PK timestamp added to table %.% ', table_schema_var,table_name_var;
	  BEGIN
         EXECUTE 'ALTER TABLE ' || table_schema_var || '.' || table_name_var || ' ADD PRIMARY KEY (timestamp) ' ;
	  
	  EXCEPTION WHEN OTHERS THEN
       RAISE NOTICE 'Problem add PK timestamp to table %.% ', table_schema_var,table_name_var;
	   test_error :=1;
	  END;
	  
	  if test_error = 0 then
         curr_time := clock_timestamp()::TIMESTAMP;
         RAISE NOTICE '%: PK timestamp added to table %.% ', curr_time,table_schema_var,table_name_var;
	  end if;	 
   end if;  
    
  END LOOP;
 END $$;  