-- DB upgrade for 15.1.710b11

DO LANGUAGE plpgsql $$
		BEGIN
		
		-- Add new table public.pattern_analysis_config
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'public'
		        AND c.relname = 'pattern_analysis_config'
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
		      CREATE TABLE public.pattern_analysis_config(
                name text NOT NULL,
                value text NOT NULL,
                description text,
                constraint PK_PATTERN_ANALYSIS_CONFIG primary key (name)
              );

              ALTER TABLE public.pattern_analysis_config OWNER TO ndbadm;
              
              REVOKE ALL ON TABLE public.pattern_analysis_config FROM PUBLIC;
              REVOKE ALL ON TABLE public.pattern_analysis_config FROM ndbadm;
              GRANT ALL ON TABLE public.pattern_analysis_config TO ndbadm;
              GRANT SELECT ON TABLE public.pattern_analysis_config TO ndb_readers;
              GRANT ALL ON TABLE public.pattern_analysis_config TO ndb_writers;
              GRANT ALL ON TABLE public.pattern_analysis_config TO nms;
			  
			  INSERT INTO public.pattern_analysis_config (name, value, description) 
			    VALUES ('countryThreashold', '0.1', 'Threshold percent per each top host country classification');
              INSERT INTO public.pattern_analysis_config (name, value, description) 
			    VALUES ('asnThreashold', '0.1', 'Threshold percent per each top host AS number classification');
              INSERT INTO public.pattern_analysis_config (name, value, description) 
			    VALUES ('captureHistoryLimit', '20', 'Max number of captures will be analyzed per flood');
              INSERT INTO public.pattern_analysis_config (name, value, description) 
			    VALUES ('minimumPacketsToMatch', '30', 'Minimum packets to match from the capture');
              INSERT INTO public.pattern_analysis_config (name, value, description) 
			    VALUES ('noiseFilter', '0.95', null);
              INSERT INTO public.pattern_analysis_config (name, value, description) 
			    VALUES ('generatedPatternsLimit', '5', 'Max generated patterns per single capture');
              INSERT INTO public.pattern_analysis_config (name, value, description) 
			    VALUES ('topHostsLimit', '20', 'Max number of top hosts per capture');         
                            
		    END if;
			
			-- Add new data to notify.fields
           PERFORM 1
		    FROM
		        notify.fields 
		    WHERE
		        field_id >=105;
		        
		    IF NOT FOUND THEN
			  INSERT INTO notify.fields (field_id,type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
			    VALUES (105, 2, 3, 'src_ip_asn', 'ASN of the top source host', '{"Range(0","4294967295)"}', '{"invalid ASN, must be from 0 to 4294967295"}', null);
              INSERT INTO notify.fields (field_id,type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
			    VALUES (106, 2, 3, 'dst_ip_asn', 'ASN of the top destination host', '{"Range(0","4294967295)"}', '{"invalid ASN, must be from 0 to 4294967295"}', null);
              INSERT INTO notify.fields (field_id,type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
			    VALUES (107, 2, 5, 'src_ip_country', 'Country code of the top destination host', '{"CountryCode"}', '{"invalid country code, code must be aligned with ISO 3166 and 2 char length"}', null);
              INSERT INTO notify.fields (field_id,type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
			    VALUES (108, 2, 5, 'dst_ip_country', 'Country code of the top destination host', '{"CountryCode"}', '{"invalid country code, code must be aligned with ISO 3166 and 2 char length"}', null);      
		    END IF;
		    
		END;
$$;  