-- DB upgrade for 15.1.710b13

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = flood, pg_catalog;
		
		-- Add new table flood.top_asns
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'flood'
		        AND c.relname = 'top_asns'
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
		      CREATE TABLE top_asns (
                 pattern_id INTEGER NOT NULL, 
                 capture_id INTEGER NOT NULL, 
                 asn INTEGER NOT NULL, 
                 asn_matches INTEGER NOT NULL,
                 direction INTEGER NOT NULL
              );

              ALTER TABLE flood.top_asns OWNER TO ndbadm;

              COMMENT ON TABLE top_asns IS 'ASNs per each pattern and capture';

              COMMENT ON COLUMN top_asns.direction IS '0 - None, 1 - Source, 2 - Destination'; 
			  
			  CREATE INDEX top_asns_patternid_captureid ON top_asns USING btree (pattern_id, capture_id);
              
              REVOKE ALL ON TABLE top_asns FROM PUBLIC;
              REVOKE ALL ON TABLE top_asns FROM ndbadm;
              GRANT ALL ON TABLE top_asns TO ndbadm;
              GRANT SELECT ON TABLE top_asns TO ndb_readers;
              GRANT ALL ON TABLE top_asns TO ndb_writers;
              GRANT ALL ON TABLE top_asns TO nms;
			                             
		    END IF;
			
		-- Add new table flood.top_countries
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'flood'
		        AND c.relname = 'top_countries'
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
		      CREATE TABLE top_countries (
                 pattern_id INTEGER NOT NULL, 
                 capture_id INTEGER NOT NULL, 
                 country_code TEXT NOT NULL, 
                 country_matches INTEGER NOT NULL,
                 direction INTEGER NOT NULL
              );

              ALTER TABLE flood.top_countries OWNER TO ndbadm;

              COMMENT ON TABLE top_countries IS 'ASNs per each pattern and capture';

              COMMENT ON COLUMN top_countries.direction IS '0 - None, 1 - Source, 2 - Destination';
			  
			  CREATE INDEX top_countries_patternid_captureid ON top_countries USING btree (pattern_id, capture_id);
			  
			  REVOKE ALL ON TABLE top_countries FROM PUBLIC;
              REVOKE ALL ON TABLE top_countries FROM ndbadm;
              GRANT ALL ON TABLE top_countries TO ndbadm;
              GRANT SELECT ON TABLE top_countries TO ndb_readers;
              GRANT ALL ON TABLE top_countries TO ndb_writers;
              GRANT ALL ON TABLE top_countries TO nms;
            
			END IF; 
			
			SET search_path = notify, pg_catalog;
			-- Add new data to notify.fields
           PERFORM 1
		    FROM
		        fields 
		    WHERE
		        field_id >=109;
		        
		    IF NOT FOUND THEN
			  INSERT INTO fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
                     VALUES (109, 2, 3, 'src_asn_count', 'Pattern source ASNs count','{"Range(1","20)"}', '{"invalid ASN count, must be 1 or greater"}', null);
              INSERT INTO fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
                     VALUES (110, 2, 3, 'dst_asn_count', 'Pattern destination ASNs count','{"Range(1","20)"}', '{"invalid ASN count, must be 1 or greater"}', null);
              INSERT INTO fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
                     VALUES (111, 2, 3, 'src_country_count', 'Pattern source countries count','{"Range(1","20)"}', '{"invalid country count, must be 1 or greater"}', null);
              INSERT INTO fields (field_id, type_id, data_type_id, name, descr, constraints, constr_msgs, operand_descr) 
                     VALUES (112, 2, 3, 'dst_country_count', 'Pattern destination countries count', '{"Range(1","20)"}', '{"invalid country count, must be 1 or greater"}', null);
		    END IF;
			
			-- Update data in notify schema table - fields, operators; public schema pattern_analysis_config
			 -- fields table
			  UPDATE fields SET name='src_asn', descr='ASN list of the pattern source' WHERE field_id = 105;
			  UPDATE fields SET name='dst_asn', descr='ASN list of the pattern destination' WHERE field_id = 106;
			  UPDATE fields SET name='src_country', descr='Country code list of the pattern source' WHERE field_id = 107;
			  UPDATE fields SET name='dst_country', descr='Country code list of the pattern destination' WHERE field_id = 108;
			  
			 -- operators
              UPDATE operators SET on_set=true WHERE operator_id=3;
              UPDATE operators SET on_set=true WHERE operator_id=4; 	
			  
			 SET search_path = public, pg_catalog; 
             -- pattern_analysis_config			 
		      UPDATE pattern_analysis_config SET value='0.001' WHERE name='countryThreashold';
			  UPDATE pattern_analysis_config SET value='0.001' WHERE name='asnThreashold';
			  
			  
		END;
$$;  