-- New top_subnet tables

DO LANGUAGE plpgsql $$
   BEGIN 
   
   SET search_path = fast, pg_catalog;
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'fast'
		        AND c.relname in ('top_subnet_sets', 'top_subnets')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
					  		  
			  -- top_subnet_sets
			  CREATE TABLE top_subnet_sets (
			   tss_id SERIAL NOT NULL,
               sample_id integer NOT NULL,
               pattern_id integer NOT NULL,
               side char NOT NULL,
			   constraint pk_top_subnet_sets primary key(tss_id)
              );

			  ALTER TABLE top_subnet_sets OWNER TO nms;
			  
			  COMMENT ON COLUMN top_subnet_sets.side IS 's - source; d - destination';
              		  
              REVOKE ALL ON TABLE top_subnet_sets FROM PUBLIC;
              REVOKE ALL ON TABLE top_subnet_sets FROM nms;
              GRANT ALL ON TABLE top_subnet_sets TO nms;
              GRANT SELECT ON TABLE top_subnet_sets TO ndb_readers;
              GRANT SELECT ON TABLE top_subnet_sets TO ndb_writers;
              GRANT ALL ON TABLE top_subnet_sets TO PUBLIC;
              GRANT ALL ON TABLE top_subnet_sets TO ndbadm;
			  
			  -- top_subnets
			  CREATE TABLE top_subnets ( 
               tss_id  integer NOT NULL, 
               subnet inet NOT NULL, 
               matches real NOT NULL,
			   CONSTRAINT top_subnets_tss_id_fkey FOREIGN KEY (tss_id) REFERENCES "top_subnet_sets" ("tss_id")
                ON
               DELETE CASCADE
              );
               
			  ALTER TABLE top_subnets OWNER TO nms;
			  
			  COMMENT ON COLUMN top_subnets.tss_id IS 'synchronize(FK) with top_subnet_sets.tss_id';
              		  
              REVOKE ALL ON TABLE top_subnets FROM PUBLIC;
              REVOKE ALL ON TABLE top_subnets FROM nms;
              GRANT ALL ON TABLE top_subnets TO nms;
              GRANT SELECT ON TABLE top_subnets TO ndb_readers;
              GRANT SELECT ON TABLE top_subnets TO ndb_writers;
              GRANT ALL ON TABLE top_subnets TO PUBLIC;
              GRANT ALL ON TABLE top_subnets TO ndbadm; 
			  
			END IF; 

        		
		END;
$$;		

\i /opt/allot/DB/sql/all_purge_proc.sql 