CREATE OR REPLACE FUNCTION flood.state__fill_top_hosts() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  rec RECORD;
  attr_bytes INTEGER ;
  attr_packets INTEGER ;
  attr_duration INTEGER ;
BEGIN
  DELETE FROM flood.top_hosts_dst WHERE flood_id = NEW.flood_id;
  DELETE FROM flood.top_hosts_src WHERE flood_id = NEW.flood_id;

  -- Insert into flood.top_hosts_* only when flood.state.stop is not NULL, i.e.
  -- only when a flood has finished.
  IF NEW.stop IS NULL THEN
    RETURN NEW;
  END IF;
  
  -- Prepare attribute id's from fast.attr_types
  SELECT INTO attr_bytes attr_type_id from fast.attr_types where name = 'Bytes';
  SELECT INTO attr_packets attr_type_id from fast.attr_types where name = 'Packets';
  SELECT INTO attr_duration attr_type_id from fast.attr_types where name = 'Duration';

  FOR rec IN
    SELECT side, 
       ip, 
	   avg_pps/sample_cnt AS avg_pps, 
	   avg_bps/sample_cnt AS avg_bps
                FROM ( SELECT flood_id, 
				              side, 
							  ip,
							  SUM(ip_packets/sa2.duration) AS avg_pps, 
							  SUM((ip_packets/sa2.duration)*ROUND(sa.bytes/sa1.packets))*8 
							   AS avg_bps
			   FROM flood.samples s
				JOIN (
					SELECT flood_id, 
						   sample_id, 
						   ths.side, 
						   th.ip, 
						   MAX(ROUND(a.pr_packets * ep.matches * th.matches)::INTEGER) 
						 AS ip_packets
					FROM flood.samples s
						JOIN fast.entity_patterns ep ON (ep.entity_id = s.report_id)
						JOIN (	SELECT entity_id, value::INTEGER AS pr_packets
								FROM fast.attrs
												JOIN fast.attr_types at USING (attr_type_id)
								WHERE at.name = 'Entries') a USING (entity_id)
						JOIN fast.top_host_sets ths ON (ths.entity_id = s.top_hosts_id 
						     AND ths.pattern_id = ep.pattern_id)
						JOIN fast.top_hosts th USING (ths_id)
					GROUP BY 1, 2, 3, 4) AS ip_data USING (flood_id, sample_id)
					   JOIN (
									SELECT entity_id as sample_id, cast(value as integer) as bytes
									FROM fast.attrs fa
									WHERE attr_type_id = attr_bytes
									) AS sa USING (sample_id)
					   JOIN (
									SELECT entity_id as sample_id, cast(value as integer) as packets
									FROM fast.attrs fa
									WHERE attr_type_id = attr_packets
									) AS sa1 USING (sample_id)
					   JOIN (
									SELECT entity_id as sample_id, cast(value as double precision) as duration
									FROM fast.attrs fa
									WHERE attr_type_id = attr_duration
									) AS sa2 USING (sample_id)
						WHERE flood_id = NEW.flood_id
						GROUP BY 1, 2, 3) AS foo
                JOIN (SELECT flood_id, COUNT(*) AS sample_cnt
                FROM flood.samples
                GROUP BY 1) count USING (flood_id)
   LOOP
  
    -- prevent CONSTRAINT CHECK problems
	IF rec.avg_bps is NULL THEN rec.avg_bps = 1; END IF;
	IF rec.avg_pps is NULL THEN rec.avg_pps = 1; END IF;
	IF rec.avg_bps = 0 THEN rec.avg_bps = 1; END IF;
	IF rec.avg_pps = 0 THEN rec.avg_pps = 1; END IF;
	
    IF rec.side = 'd' THEN
      INSERT INTO flood.top_hosts_dst (flood_id, ip, avg_bps, avg_pps)
        VALUES (NEW.flood_id, rec.ip, rec.avg_bps, rec.avg_pps);
    ELSE
      INSERT INTO flood.top_hosts_src (flood_id, ip, avg_bps, avg_pps)
        VALUES (NEW.flood_id, rec.ip, rec.avg_bps, rec.avg_pps);
    END IF;
  END LOOP;

  RETURN NEW;
END$$;


ALTER FUNCTION flood.state__fill_top_hosts() OWNER TO ndbadm;

REVOKE ALL ON FUNCTION flood.state__fill_top_hosts() FROM PUBLIC;
REVOKE ALL ON FUNCTION flood.state__fill_top_hosts() FROM ndbadm;
GRANT ALL ON FUNCTION flood.state__fill_top_hosts() TO ndbadm;